//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 23 textures and 91 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.0 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 08/28/1998    (28.08.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <0.839216,0.839216,0.839216>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <-24.502, -8.932, 1.100>
  direction <0.0,     0.0,  1.0620>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-7.879, 16.605, 0.600>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <-15.566, 38.781, 38.341> // Attached to spotlite
  direction <0.0,     0.0,  1.3317>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-15.661, 39.088, 37.394> // Following spotlite
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Spotlight spotlite
  <-15.566, 38.781, 38.341>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-15.661, 39.088, 37.394>
    falloff   21.00  // outer radius (in deg)
      radius    20.00  // inner radius
}

light_source { // Light
  <-22.151, -27.395, 9.821>
  color  rgb<0.650, 0.650, 0.650>
  area_light <2.000, 0.000, 0.000>, <0.000, -2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  shadowless
}



//
// ********  TEXTURES  *******
//

#include "undrdoor.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare sunhole5 = object {
  box { // sunhole5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 10.0, 0.65>
    translate  <-22.467431, 47.782101, 22.16062>
  }
}




//
// ********  OBJECTS  *******
//

box { // carpet
  <-1, -1, -1>, <1, 1, 1>
  texture {
    carpet
  }
  scale <6.5, 35.0, 0.065>
  translate  <-16.953072, 25.775669, -5.995984>
}


#declare Doors = union {
  box { // DoorLeft
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DoorOak
    }
    scale <5.4, 2.6, 9.2>
    translate  <-22.45, 65.6, 3.3>
  }
  box { // DoorRight
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DoorOak
    }
    scale <5.4, 2.6, 9.2>
    translate  <-11.55, 65.600001, 3.3>
  }
}
#declare S = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.796048, 0.827066>,
  <1.874436, 0.827066>,
  <2.002762, 0.989691>,
  <-1.203952, 0.991502>,
  <0.291832, -1.001309>,
  <-1.232212, -1.001046>,
  <-1.232212, -1.195709>,
  <0.55527, -1.193236>,
  <0.55527, -1.007308>,
  <-0.796048, 0.827066>
  rotate -x*90
  texture {
    Shiny_Red
  }
}
#declare L = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <0.570468, -0.994428>,
  <2.002762, 0.990662>,
  <2.2229, 0.992573>,
  <0.787993, -1.000238>,
  <2.192197, -0.999975>,
  <2.192197, -1.195699>,
  <0.569425, -1.193236>,
  <0.570468, -0.994428>
  rotate -x*90
  texture {
    Shiny_Green
  }
}
#declare Signature = union {
  object { S }
  object { L }
  scale <3.0, 3.0, 1.2>
  rotate 90.0*x
  translate  <-18.710763, 63.284892, 7.317321>
}
difference { // DoorCarve
  object { Doors }
  object { Signature }
}


#declare Woman_shirt = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.785667, -3.439704, -1.988314>, <1.691515, -3.440926, -1.997207>, <1.565121, -3.448196, -1.987992>, <1.470548, -3.449173, -1.987992>, 
      <1.763798, -3.326311, -1.988314>, <1.669647, -3.327533, -1.997207>, <1.558183, -3.334800, -1.987992>, <1.463610, -3.335777, -1.987992>, 
      <1.718852, -3.176119, -2.002942>, <1.639707, -3.177342, -2.011863>, <1.539882, -3.182177, -2.002303>, <1.460232, -3.183159, -2.002303>, 
      <1.712772, -3.061728, -1.988314>, <1.633626, -3.062952, -1.997234>, <1.527070, -3.070205, -1.987992>, <1.447420, -3.071187, -1.987992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.116115, -3.440795, -1.927017>, <2.019176, -3.439942, -1.954728>, <1.886038, -3.438402, -1.978834>, <1.785667, -3.439704, -1.988314>, 
      <2.077807, -3.327403, -1.927017>, <1.980868, -3.326550, -1.954728>, <1.864169, -3.325009, -1.978834>, <1.763798, -3.326311, -1.988314>, 
      <2.005937, -3.180371, -1.941180>, <1.925800, -3.179526, -1.968642>, <1.803025, -3.174817, -1.993455>, <1.718852, -3.176119, -2.002942>, 
      <1.988422, -3.062821, -1.927017>, <1.908286, -3.061976, -1.954479>, <1.796945, -3.060426, -1.978827>, <1.712772, -3.061728, -1.988314>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.459304, -3.445627, -1.795745>, <2.358010, -3.444691, -1.839239>, <2.222106, -3.441727, -1.896718>, <2.116115, -3.440795, -1.927017>, 
      <2.403923, -3.332235, -1.795745>, <2.302629, -3.331299, -1.839239>, <2.183799, -3.328335, -1.896718>, <2.077807, -3.327403, -1.927017>, 
      <2.304968, -3.189498, -1.808492>, <2.220956, -3.188568, -1.851737>, <2.095323, -3.181313, -1.910548>, <2.005937, -3.180371, -1.941180>, 
      <2.274701, -3.067653, -1.795745>, <2.190689, -3.066723, -1.838990>, <2.077808, -3.063763, -1.896385>, <1.988422, -3.062821, -1.927017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.852233, -3.447598, -1.610937>, <2.767165, -3.455588, -1.709269>, <2.578999, -3.446733, -1.744349>, <2.459304, -3.445627, -1.795745>, 
      <2.777304, -3.334205, -1.610937>, <2.692237, -3.342195, -1.709269>, <2.523618, -3.333341, -1.744349>, <2.403923, -3.332235, -1.795745>, 
      <2.648621, -3.197027, -1.621430>, <2.581841, -3.206038, -1.711998>, <2.405332, -3.190610, -1.756830>, <2.304968, -3.189498, -1.808492>, 
      <2.602471, -3.069621, -1.610937>, <2.535691, -3.078632, -1.701504>, <2.375065, -3.068764, -1.744083>, <2.274701, -3.067653, -1.795745>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.852233, -3.447598, -1.610937>, <2.777304, -3.334205, -1.610937>, <2.648621, -3.197027, -1.621430>, <2.602471, -3.069621, -1.610937>, 
      <2.997178, -3.433984, -1.443390>, <2.922250, -3.320590, -1.443390>, <2.773162, -3.180223, -1.452527>, <2.727013, -3.052816, -1.442034>, 
      <3.176429, -3.404374, -1.174854>, <3.084883, -3.286913, -1.180193>, <2.934042, -3.147557, -1.178491>, <2.873439, -3.011448, -1.181385>, 
      <3.186810, -3.377294, -0.954796>, <3.095263, -3.259832, -0.960135>, <2.942258, -3.121863, -0.969700>, <2.881655, -2.985755, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.914976, -3.283919, -0.280856>, <3.062813, -3.316506, -0.440214>, <3.197090, -3.350477, -0.736879>, <3.186810, -3.377294, -0.954796>, 
      <2.836926, -3.170527, -0.280856>, <2.984762, -3.203114, -0.440214>, <3.105543, -3.233016, -0.742218>, <3.095263, -3.259832, -0.960135>, 
      <2.704473, -3.033931, -0.270720>, <2.835635, -3.065592, -0.444109>, <2.950831, -3.095050, -0.751807>, <2.942258, -3.121863, -0.969700>, 
      <2.654808, -2.905945, -0.280856>, <2.785970, -2.937607, -0.454246>, <2.890229, -2.958942, -0.754701>, <2.881655, -2.985755, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.474044, -3.220183, -0.186482>, <2.606702, -3.242841, -0.210010>, <2.823086, -3.263664, -0.181805>, <2.914976, -3.283919, -0.280856>, 
      <2.417930, -3.106790, -0.186482>, <2.550587, -3.129448, -0.210010>, <2.745036, -3.150272, -0.181805>, <2.836926, -3.170527, -0.280856>, 
      <2.318676, -2.964185, -0.175321>, <2.429462, -2.986868, -0.198877>, <2.635514, -3.017284, -0.179558>, <2.704473, -3.033931, -0.270720>, 
      <2.286996, -2.842207, -0.186482>, <2.397782, -2.864891, -0.210037>, <2.585849, -2.889298, -0.189695>, <2.654808, -2.905945, -0.280856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.107402, -3.145986, -0.137623>, <2.218459, -3.161864, -0.152558>, <2.364151, -3.201413, -0.166991>, <2.474044, -3.220183, -0.186482>, 
      <2.069528, -3.032594, -0.137623>, <2.180584, -3.048472, -0.152558>, <2.308037, -3.088020, -0.166991>, <2.417930, -3.106790, -0.186482>, 
      <1.999019, -2.885652, -0.126042>, <2.092024, -2.901592, -0.141036>, <2.227040, -2.945422, -0.155838>, <2.318676, -2.964185, -0.175321>, 
      <1.981154, -2.768013, -0.137623>, <2.074159, -2.783953, -0.152617>, <2.195360, -2.823444, -0.166998>, <2.286996, -2.842207, -0.186482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.828395, -3.127876, -0.099655>, <1.912683, -3.130588, -0.106963>, <2.024339, -3.134111, -0.126453>, <2.107402, -3.145986, -0.137623>, 
      <1.804401, -3.014483, -0.099655>, <1.888690, -3.017195, -0.106963>, <1.986464, -3.020719, -0.126453>, <2.069528, -3.032594, -0.137623>, 
      <1.756249, -2.864926, -0.087760>, <1.826770, -2.867646, -0.095089>, <1.929952, -2.873815, -0.114908>, <1.999019, -2.885652, -0.126042>, 
      <1.748415, -2.749901, -0.099655>, <1.818936, -2.752621, -0.106985>, <1.912087, -2.756176, -0.126488>, <1.981154, -2.768013, -0.137623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.528168, -3.127350, -0.087403>, <1.618265, -3.125604, -0.089689>, <1.738635, -3.124988, -0.091873>, <1.828395, -3.127876, -0.099655>, 
      <1.519109, -3.013958, -0.087403>, <1.609207, -3.012211, -0.089689>, <1.714641, -3.011595, -0.091873>, <1.804401, -3.014483, -0.099655>, 
      <1.495441, -2.862479, -0.075532>, <1.570609, -2.860745, -0.077805>, <1.681484, -2.862042, -0.079989>, <1.756249, -2.864926, -0.087760>, 
      <1.497973, -2.749375, -0.087403>, <1.573141, -2.747641, -0.089676>, <1.673650, -2.747017, -0.091884>, <1.748415, -2.749901, -0.099655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.330701, -3.137523, -0.087025>, <1.389941, -3.134471, -0.087138>, <1.468879, -3.128499, -0.085898>, <1.528168, -3.127350, -0.087403>, 
      <1.330720, -3.024127, -0.087025>, <1.389960, -3.021075, -0.087138>, <1.459821, -3.015107, -0.085898>, <1.519109, -3.013958, -0.087403>, 
      <1.339393, -2.871986, -0.075222>, <1.389620, -2.870294, -0.075222>, <1.445221, -2.863638, -0.074013>, <1.495441, -2.862479, -0.075532>, 
      <1.330764, -2.759537, -0.087025>, <1.380991, -2.757844, -0.087025>, <1.447754, -2.750534, -0.085884>, <1.497973, -2.749375, -0.087403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.739194, -2.565368, -1.876504>, <1.737339, -2.717937, -1.885489>, <1.704725, -2.910328, -1.968953>, <1.712772, -3.061728, -1.988314>, 
      <1.628987, -2.566847, -1.886275>, <1.627132, -2.719416, -1.895259>, <1.625579, -2.911552, -1.977873>, <1.633626, -3.062952, -1.997234>, 
      <1.481122, -2.573353, -1.876217>, <1.483977, -2.727497, -1.885291>, <1.509654, -2.917991, -1.968538>, <1.527070, -3.070205, -1.987992>, 
      <1.370480, -2.574604, -1.876217>, <1.373336, -2.728748, -1.885291>, <1.430004, -2.918973, -1.968538>, <1.447420, -3.071187, -1.987992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.985824, -2.566346, -1.821661>, <1.985038, -2.718371, -1.830097>, <1.966141, -2.913280, -1.909000>, <1.988422, -3.062821, -1.927017>, 
      <1.914124, -2.565590, -1.846232>, <1.913338, -2.717615, -1.854668>, <1.886004, -2.912435, -1.936462>, <1.908286, -3.061976, -1.954479>, 
      <1.814688, -2.564355, -1.869811>, <1.812833, -2.716924, -1.878795>, <1.788897, -2.909026, -1.959466>, <1.796945, -3.060426, -1.978827>, 
      <1.739194, -2.565368, -1.876504>, <1.737339, -2.717937, -1.885489>, <1.704725, -2.910328, -1.968953>, <1.712772, -3.061728, -1.988314>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.241963, -2.570670, -1.704210>, <2.242280, -2.722414, -1.711524>, <2.238264, -2.920967, -1.780399>, <2.274701, -3.067653, -1.795745>, 
      <2.166796, -2.569837, -1.742902>, <2.167113, -2.721581, -1.750217>, <2.154252, -2.920037, -1.823644>, <2.190689, -3.066723, -1.838990>, 
      <2.065799, -2.567189, -1.794254>, <2.065013, -2.719214, -1.802690>, <2.055527, -2.914223, -1.878368>, <2.077808, -3.063763, -1.896385>, 
      <1.985824, -2.566346, -1.821661>, <1.985038, -2.718371, -1.830097>, <1.966141, -2.913280, -1.909000>, <1.988422, -3.062821, -1.927017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.535226, -2.572432, -1.538857>, <2.536805, -2.724375, -1.544624>, <2.550838, -2.927078, -1.599197>, <2.602471, -3.069621, -1.610937>, 
      <2.473043, -2.575749, -1.618378>, <2.474622, -2.727691, -1.624145>, <2.484058, -2.936089, -1.689764>, <2.535691, -3.078632, -1.701504>, 
      <2.331761, -2.571665, -1.657987>, <2.332078, -2.723408, -1.665301>, <2.338628, -2.922079, -1.728737>, <2.375065, -3.068764, -1.744083>, 
      <2.241963, -2.570670, -1.704210>, <2.242280, -2.722414, -1.711524>, <2.238264, -2.920967, -1.780399>, <2.274701, -3.067653, -1.795745>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.535226, -2.572432, -1.538857>, <2.651961, -2.566206, -1.389576>, <2.806672, -2.563295, -1.160637>, <2.814071, -2.540155, -0.972594>, 
      <2.536805, -2.724375, -1.544624>, <2.653540, -2.718148, -1.395343>, <2.808114, -2.697643, -1.145471>, <2.815514, -2.674503, -0.957428>, 
      <2.550838, -2.927078, -1.599197>, <2.675380, -2.910273, -1.430294>, <2.818453, -2.887953, -1.184011>, <2.826668, -2.862260, -0.975220>, 
      <2.602471, -3.069621, -1.610937>, <2.727013, -3.052816, -1.442034>, <2.873439, -3.011448, -1.181385>, <2.881655, -2.985755, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.582054, -2.425985, -0.348805>, <2.583797, -2.572932, -0.343499>, <2.601754, -2.769225, -0.291684>, <2.654808, -2.905945, -0.280856>, 
      <2.705655, -2.463696, -0.504814>, <2.707397, -2.610643, -0.499508>, <2.732915, -2.800886, -0.465074>, <2.785970, -2.937607, -0.454246>, 
      <2.821977, -2.515431, -0.771685>, <2.823419, -2.649779, -0.756519>, <2.835242, -2.835447, -0.757327>, <2.890229, -2.958942, -0.754701>, 
      <2.814071, -2.540155, -0.972594>, <2.815514, -2.674503, -0.957428>, <2.826668, -2.862260, -0.975220>, <2.881655, -2.985755, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.252965, -2.368958, -0.264367>, <2.253321, -2.513080, -0.258381>, <2.250877, -2.703137, -0.199207>, <2.286996, -2.842207, -0.186482>, 
      <2.352087, -2.389253, -0.285443>, <2.352443, -2.533375, -0.279457>, <2.361663, -2.725821, -0.222762>, <2.397782, -2.864891, -0.210037>, 
      <2.518996, -2.406746, -0.269213>, <2.520738, -2.553692, -0.263907>, <2.532794, -2.752578, -0.200523>, <2.585849, -2.889298, -0.189695>, 
      <2.582054, -2.425985, -0.348805>, <2.583797, -2.572932, -0.343499>, <2.601754, -2.769225, -0.291684>, <2.654808, -2.905945, -0.280856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.979321, -2.302575, -0.220651>, <1.978558, -2.444270, -0.214352>, <1.959959, -2.628443, -0.151363>, <1.981154, -2.768013, -0.137623>, 
      <2.062535, -2.316837, -0.234066>, <2.061772, -2.458532, -0.227767>, <2.052964, -2.644383, -0.166356>, <2.074159, -2.783953, -0.152617>, 
      <2.170976, -2.352171, -0.246934>, <2.171332, -2.496292, -0.240949>, <2.159241, -2.684374, -0.179723>, <2.195360, -2.823444, -0.166998>, 
      <2.252965, -2.368958, -0.264367>, <2.253321, -2.513080, -0.258381>, <2.250877, -2.703137, -0.199207>, <2.286996, -2.842207, -0.186482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.771084, -2.286370, -0.186680>, <1.769472, -2.427859, -0.180081>, <1.738841, -2.609323, -0.114193>, <1.748415, -2.749901, -0.099655>, 
      <1.834181, -2.288804, -0.193238>, <1.832569, -2.430293, -0.186639>, <1.809362, -2.612043, -0.121523>, <1.818936, -2.752621, -0.106985>, 
      <1.917525, -2.291984, -0.210689>, <1.916762, -2.433679, -0.204389>, <1.890892, -2.616606, -0.140228>, <1.912087, -2.756176, -0.126488>, 
      <1.979321, -2.302575, -0.220651>, <1.978558, -2.444270, -0.214352>, <1.959959, -2.628443, -0.151363>, <1.981154, -2.768013, -0.137623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.547009, -2.285900, -0.175718>, <1.544472, -2.428025, -0.168991>, <1.501141, -2.607881, -0.102254>, <1.497973, -2.749375, -0.087403>, 
      <1.614284, -2.284649, -0.177223>, <1.611746, -2.426774, -0.170496>, <1.576309, -2.606147, -0.104527>, <1.573141, -2.747641, -0.089676>, 
      <1.704191, -2.283790, -0.179727>, <1.702579, -2.425279, -0.173128>, <1.664076, -2.606439, -0.106422>, <1.673650, -2.747017, -0.091884>, 
      <1.771084, -2.286370, -0.186680>, <1.769472, -2.427859, -0.180081>, <1.738841, -2.609323, -0.114193>, <1.748415, -2.749901, -0.099655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.266106, -2.295764, -0.175380>, <1.268368, -2.438543, -0.168619>, <1.319885, -2.617774, -0.101905>, <1.330764, -2.759537, -0.087025>, 
      <1.350402, -2.293624, -0.175380>, <1.352664, -2.436402, -0.168619>, <1.370112, -2.616081, -0.101905>, <1.380991, -2.757844, -0.087025>, 
      <1.462722, -2.287468, -0.173832>, <1.460185, -2.429593, -0.167105>, <1.450922, -2.609040, -0.100735>, <1.447754, -2.750534, -0.085884>, 
      <1.547009, -2.285900, -0.175718>, <1.544472, -2.428025, -0.168991>, <1.501141, -2.607881, -0.102254>, <1.497973, -2.749375, -0.087403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.726462, -1.935841, -1.922011>, <1.713953, -2.124008, -1.904542>, <1.741493, -2.376320, -1.865371>, <1.739194, -2.565368, -1.876504>, 
      <1.636910, -1.937144, -1.931029>, <1.624402, -2.125310, -1.913561>, <1.631286, -2.377799, -1.875142>, <1.628987, -2.566847, -1.886275>, 
      <1.516569, -1.944141, -1.921710>, <1.503575, -2.132941, -1.904188>, <1.477608, -2.383658, -1.865050>, <1.481122, -2.573353, -1.876217>, 
      <1.426561, -1.945212, -1.921710>, <1.413567, -2.134012, -1.904188>, <1.366966, -2.384909, -1.865050>, <1.370480, -2.574604, -1.876217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.994245, -1.936955, -1.864542>, <1.968819, -2.123798, -1.848196>, <1.986801, -2.377367, -1.811175>, <1.985824, -2.566346, -1.821661>, 
      <1.916240, -1.936135, -1.890341>, <1.890814, -2.122978, -1.873995>, <1.915102, -2.376611, -1.835745>, <1.914124, -2.565590, -1.846232>, 
      <1.808205, -1.934652, -1.913779>, <1.795696, -2.122819, -1.896311>, <1.816987, -2.375307, -1.858678>, <1.814688, -2.564355, -1.869811>, 
      <1.726462, -1.935841, -1.922011>, <1.713953, -2.124008, -1.904542>, <1.741493, -2.376320, -1.865371>, <1.739194, -2.565368, -1.876504>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.272352, -1.941577, -1.741465>, <2.233833, -2.126361, -1.727414>, <2.241569, -2.381612, -1.695097>, <2.241963, -2.570670, -1.704210>, 
      <2.190637, -1.940677, -1.782061>, <2.152118, -2.125461, -1.768009>, <2.166402, -2.380779, -1.733789>, <2.166796, -2.569837, -1.742902>, 
      <2.080873, -1.937865, -1.835891>, <2.055447, -2.124708, -1.819545>, <2.066776, -2.378211, -1.783768>, <2.065799, -2.567189, -1.794254>, 
      <1.994245, -1.936955, -1.864542>, <1.968819, -2.123798, -1.848196>, <1.986801, -2.377367, -1.811175>, <1.985824, -2.566346, -1.821661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.590766, -1.943528, -1.568194>, <2.537824, -2.125271, -1.557310>, <2.533257, -2.382969, -1.531666>, <2.535226, -2.572432, -1.538857>, 
      <2.516988, -1.950867, -1.647756>, <2.464046, -2.132611, -1.636872>, <2.471073, -2.386286, -1.611186>, <2.473043, -2.575749, -1.618378>, 
      <2.369744, -1.942650, -1.693081>, <2.331224, -2.127434, -1.679030>, <2.331367, -2.382606, -1.648873>, <2.331761, -2.571665, -1.657987>, 
      <2.272352, -1.941577, -1.741465>, <2.233833, -2.126361, -1.727414>, <2.241569, -2.381612, -1.695097>, <2.241963, -2.570670, -1.704210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.590766, -1.943528, -1.568194>, <2.702885, -1.932375, -1.447286>, <2.863125, -1.902311, -1.261076>, <2.869803, -1.882144, -1.097178>, 
      <2.537824, -2.125271, -1.557310>, <2.649943, -2.114118, -1.436402>, <2.796371, -2.092543, -1.261076>, <2.803049, -2.072376, -1.097178>, 
      <2.533257, -2.382969, -1.531666>, <2.649991, -2.376743, -1.382384>, <2.804520, -2.362974, -1.183251>, <2.811920, -2.339834, -0.995208>, 
      <2.535226, -2.572432, -1.538857>, <2.651961, -2.566206, -1.389576>, <2.806672, -2.563295, -1.160637>, <2.814071, -2.540155, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.641575, -1.790085, -0.321149>, <2.586507, -1.973508, -0.331358>, <2.579781, -2.234340, -0.355725>, <2.582054, -2.425985, -0.348805>, 
      <2.777113, -1.825253, -0.521257>, <2.722045, -2.008677, -0.531466>, <2.703382, -2.272051, -0.511734>, <2.705655, -2.463696, -0.504814>, 
      <2.879671, -1.852341, -0.854970>, <2.812917, -2.042574, -0.854970>, <2.819825, -2.315110, -0.794299>, <2.821977, -2.515431, -0.771685>, 
      <2.869803, -1.882144, -1.097178>, <2.803049, -2.072376, -1.097178>, <2.811920, -2.339834, -0.995208>, <2.814071, -2.540155, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.284247, -1.730209, -0.232667>, <2.245300, -1.917932, -0.244578>, <2.252491, -2.177034, -0.272338>, <2.252965, -2.368958, -0.264367>, 
      <2.391847, -1.751506, -0.254746>, <2.352900, -1.939229, -0.266657>, <2.351613, -2.197330, -0.293414>, <2.352087, -2.389253, -0.285443>, 
      <2.579483, -1.773974, -0.229477>, <2.524415, -1.957397, -0.239686>, <2.516723, -2.215101, -0.276133>, <2.518996, -2.406746, -0.269213>, 
      <2.641575, -1.790085, -0.321149>, <2.586507, -1.973508, -0.331358>, <2.579781, -2.234340, -0.355725>, <2.582054, -2.425985, -0.348805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.987118, -1.660547, -0.186858>, <1.962143, -1.851382, -0.199684>, <1.980359, -2.109879, -0.229218>, <1.979321, -2.302575, -0.220651>, 
      <2.077396, -1.675509, -0.200904>, <2.052421, -1.866344, -0.213730>, <2.063572, -2.124141, -0.242633>, <2.062535, -2.316837, -0.234066>, 
      <2.195213, -1.712586, -0.214398>, <2.156266, -1.900309, -0.226309>, <2.170502, -2.160247, -0.254906>, <2.170976, -2.352171, -0.246934>, 
      <2.284247, -1.730209, -0.232667>, <2.245300, -1.917932, -0.244578>, <2.252491, -2.177034, -0.272338>, <2.252965, -2.368958, -0.264367>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.761019, -1.643493, -0.151261>, <1.746898, -1.835681, -0.164779>, <1.773282, -2.093413, -0.195680>, <1.771084, -2.286370, -0.186680>, 
      <1.829483, -1.646064, -0.158129>, <1.815362, -1.838252, -0.171647>, <1.836379, -2.095847, -0.202238>, <1.834181, -2.288804, -0.193238>, 
      <1.919975, -1.649419, -0.176412>, <1.895000, -1.840254, -0.189238>, <1.918563, -2.099288, -0.219255>, <1.917525, -2.291984, -0.210689>, 
      <1.987118, -1.660547, -0.186858>, <1.962143, -1.851382, -0.199684>, <1.980359, -2.109879, -0.229218>, <1.979321, -2.302575, -0.220651>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.517726, -1.642919, -0.139774>, <1.515427, -1.835810, -0.153542>, <1.550457, -2.092752, -0.184860>, <1.547009, -2.285900, -0.175718>, 
      <1.590753, -1.641366, -0.141705>, <1.588454, -1.834256, -0.155474>, <1.617732, -2.091501, -0.186366>, <1.614284, -2.284649, -0.177223>, 
      <1.688365, -1.640765, -0.143973>, <1.674244, -1.832952, -0.157492>, <1.706389, -2.090833, -0.188727>, <1.704191, -2.283790, -0.179727>, 
      <1.761019, -1.643493, -0.151261>, <1.746898, -1.835681, -0.164779>, <1.773282, -2.093413, -0.195680>, <1.771084, -2.286370, -0.186680>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.313235, -1.653018, -0.139419>, <1.305838, -1.846027, -0.153203>, <1.263042, -2.102363, -0.184538>, <1.266106, -2.295764, -0.175380>, 
      <1.374582, -1.649988, -0.139526>, <1.367185, -1.842998, -0.153310>, <1.347338, -2.100222, -0.184538>, <1.350402, -2.293624, -0.175380>, 
      <1.456339, -1.644225, -0.138151>, <1.454040, -1.837116, -0.151919>, <1.466170, -2.094320, -0.182974>, <1.462722, -2.287468, -0.173832>, 
      <1.517726, -1.642919, -0.139774>, <1.515427, -1.835810, -0.153542>, <1.550457, -2.092752, -0.184860>, <1.547009, -2.285900, -0.175718>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.819257, -1.360978, -1.988314>, <1.799151, -1.524049, -1.925733>, <1.738074, -1.761156, -1.938228>, <1.726462, -1.935841, -1.922011>, 
      <1.709881, -1.362262, -1.997892>, <1.689775, -1.525333, -1.935311>, <1.648522, -1.762458, -1.947246>, <1.636910, -1.937144, -1.931029>, 
      <1.563164, -1.369195, -1.987992>, <1.555122, -1.541684, -1.968107>, <1.528453, -1.771472, -1.937735>, <1.516569, -1.944141, -1.921710>, 
      <1.453367, -1.370248, -1.987992>, <1.445325, -1.542737, -1.968107>, <1.438445, -1.772543, -1.937735>, <1.426561, -1.945212, -1.921710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.149705, -1.362071, -1.927017>, <2.118545, -1.527590, -1.864542>, <2.018377, -1.759620, -1.880056>, <1.994245, -1.936955, -1.864542>, 
      <2.052766, -1.361219, -1.954728>, <2.021606, -1.526738, -1.892254>, <1.940372, -1.758801, -1.905855>, <1.916240, -1.936135, -1.890341>, 
      <1.919692, -1.359799, -1.979519>, <1.899586, -1.522870, -1.916938>, <1.819817, -1.759967, -1.929996>, <1.808205, -1.934652, -1.913779>, 
      <1.819257, -1.360978, -1.988314>, <1.799151, -1.524049, -1.925733>, <1.738074, -1.761156, -1.938228>, <1.726462, -1.935841, -1.922011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.492894, -1.366903, -1.795745>, <2.449565, -1.536273, -1.734089>, <2.310077, -1.760600, -1.755226>, <2.272352, -1.941577, -1.741465>, 
      <2.391600, -1.365967, -1.839239>, <2.348271, -1.535337, -1.777583>, <2.228362, -1.759700, -1.795822>, <2.190637, -1.940677, -1.782061>, 
      <2.255696, -1.363003, -1.896718>, <2.224536, -1.528523, -1.834243>, <2.105006, -1.760531, -1.851405>, <2.080873, -1.937865, -1.835891>, 
      <2.149705, -1.362071, -1.927017>, <2.118545, -1.527590, -1.864542>, <2.018377, -1.759620, -1.880056>, <1.994245, -1.936955, -1.864542>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.885822, -1.368872, -1.610937>, <3.028884, -1.372264, -1.448917>, <3.209616, -1.410510, -1.186908>, <3.219726, -1.384137, -0.972593>, 
      <2.801690, -1.540930, -1.578714>, <2.944752, -1.544322, -1.416694>, <3.139896, -1.581890, -1.209406>, <3.150006, -1.555517, -0.995091>, 
      <2.644994, -1.757369, -1.579343>, <2.757113, -1.746215, -1.458435>, <2.924838, -1.726443, -1.261076>, <2.931516, -1.706276, -1.097178>, 
      <2.590766, -1.943528, -1.568194>, <2.702885, -1.932375, -1.447286>, <2.863125, -1.902311, -1.261076>, <2.869803, -1.882144, -1.097178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.885822, -1.368872, -1.610937>, <2.801690, -1.540930, -1.578714>, <2.644994, -1.757369, -1.579343>, <2.590766, -1.943528, -1.568194>, 
      <2.799610, -1.366828, -1.708574>, <2.715479, -1.538885, -1.676351>, <2.571216, -1.764708, -1.658905>, <2.516988, -1.950867, -1.647756>, 
      <2.612589, -1.368009, -1.744349>, <2.569259, -1.537379, -1.682693>, <2.407469, -1.761673, -1.706843>, <2.369744, -1.942650, -1.693081>, 
      <2.492894, -1.366903, -1.795745>, <2.449565, -1.536273, -1.734089>, <2.310077, -1.760600, -1.755226>, <2.272352, -1.941577, -1.741465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.948565, -1.205195, -0.280856>, <2.875239, -1.389068, -0.296047>, <2.698582, -1.600203, -0.310580>, <2.641575, -1.790085, -0.321149>, 
      <3.098608, -1.256329, -0.446496>, <3.025283, -1.440202, -0.461687>, <2.834121, -1.635371, -0.510688>, <2.777113, -1.825253, -0.521257>, 
      <3.230448, -1.356165, -0.745289>, <3.160728, -1.527545, -0.767787>, <2.941385, -1.676473, -0.854969>, <2.879671, -1.852341, -0.854970>, 
      <3.219726, -1.384137, -0.972593>, <3.150006, -1.555517, -0.995091>, <2.931516, -1.706276, -1.097178>, <2.869803, -1.882144, -1.097178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.507634, -1.141458, -0.186482>, <2.456469, -1.323177, -0.201979>, <2.322652, -1.545096, -0.220922>, <2.284247, -1.730209, -0.232667>, 
      <2.640292, -1.164116, -0.210010>, <2.589127, -1.345835, -0.225507>, <2.430252, -1.566394, -0.243001>, <2.391847, -1.751506, -0.254746>, 
      <2.859155, -1.174724, -0.182152>, <2.785830, -1.358597, -0.197344>, <2.636490, -1.584092, -0.218908>, <2.579483, -1.773974, -0.229477>, 
      <2.948565, -1.205195, -0.280856>, <2.875239, -1.389068, -0.296047>, <2.698582, -1.600203, -0.310580>, <2.641575, -1.790085, -0.321149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.140992, -1.067262, -0.137623>, <2.104711, -1.247397, -0.153841>, <2.011003, -1.478045, -0.174592>, <1.987118, -1.660547, -0.186858>, 
      <2.252048, -1.083140, -0.152558>, <2.215767, -1.263275, -0.168776>, <2.101281, -1.493007, -0.188638>, <2.077396, -1.675509, -0.200904>, 
      <2.397741, -1.122688, -0.166991>, <2.346576, -1.304407, -0.182488>, <2.233618, -1.527474, -0.202652>, <2.195213, -1.712586, -0.214398>, 
      <2.507634, -1.141458, -0.186482>, <2.456469, -1.323177, -0.201979>, <2.322652, -1.545096, -0.220922>, <2.284247, -1.730209, -0.232667>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.861987, -1.049151, -0.099655>, <1.836596, -1.228095, -0.116492>, <1.774287, -1.462906, -0.138559>, <1.761019, -1.643493, -0.151261>, 
      <1.946275, -1.051863, -0.106963>, <1.920884, -1.230807, -0.123800>, <1.842751, -1.465477, -0.145426>, <1.829483, -1.646064, -0.158129>, 
      <2.057929, -1.055387, -0.126453>, <2.021648, -1.235522, -0.142671>, <1.943860, -1.466917, -0.164145>, <1.919975, -1.649419, -0.176412>, 
      <2.140992, -1.067262, -0.137623>, <2.104711, -1.247397, -0.153841>, <2.011003, -1.478045, -0.174592>, <1.987118, -1.660547, -0.186858>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.561758, -1.048626, -0.087403>, <1.547817, -1.226740, -0.104405>, <1.519860, -1.463921, -0.126997>, <1.517726, -1.642919, -0.139774>, 
      <1.651865, -1.047074, -0.089478>, <1.637924, -1.225188, -0.106480>, <1.592887, -1.462368, -0.128929>, <1.590753, -1.641366, -0.141705>, 
      <1.772226, -1.046263, -0.091873>, <1.746835, -1.225207, -0.108710>, <1.701633, -1.460178, -0.131271>, <1.688365, -1.640765, -0.143973>, 
      <1.861987, -1.049151, -0.099655>, <1.836596, -1.228095, -0.116492>, <1.774287, -1.462906, -0.138559>, <1.761019, -1.643493, -0.151261>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.313520, -1.058598, -0.087025>, <1.313622, -1.236805, -0.104035>, <1.320073, -1.474586, -0.126676>, <1.313235, -1.653018, -0.139419>, 
      <1.388029, -1.056752, -0.087025>, <1.388131, -1.234959, -0.104035>, <1.381421, -1.471556, -0.126782>, <1.374582, -1.649988, -0.139526>, 
      <1.487257, -1.049909, -0.085687>, <1.473316, -1.228023, -0.102689>, <1.458473, -1.465227, -0.125374>, <1.456339, -1.644225, -0.138151>, 
      <1.561758, -1.048626, -0.087403>, <1.547817, -1.226740, -0.104405>, <1.519860, -1.463921, -0.126997>, <1.517726, -1.642919, -0.139774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.437326, 0.714075, -1.548219>, <1.436451, 0.713446, -1.548219>, <1.433344, 0.711992, -1.548375>, <1.434410, 0.711977, -1.548219>, 
      <1.432039, 0.492595, -1.685708>, <1.431165, 0.491965, -1.685708>, <1.552238, 0.503837, -1.685864>, <1.553304, 0.503822, -1.685708>, 
      <1.424991, 0.197287, -1.869027>, <1.548297, 0.209984, -1.869027>, <1.629376, 0.227161, -1.863106>, <1.752764, 0.235337, -1.854498>, 
      <1.419704, -0.024193, -2.006517>, <1.543010, -0.011497, -2.006517>, <1.707337, 0.009951, -2.015126>, <1.830725, 0.018128, -2.006517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.709163, -5.768912, -1.598061>, <3.667594, -5.767336, -1.585790>, <3.608620, -5.801127, -1.563403>, <3.584306, -5.791553, -1.528788>, 
      <3.723278, -5.650484, -1.572119>, <3.681709, -5.648909, -1.559848>, <3.639642, -5.690941, -1.534136>, <3.615328, -5.681367, -1.499520>, 
      <3.771324, -5.487213, -1.468154>, <3.743875, -5.491828, -1.446828>, <3.751515, -5.537634, -1.464708>, <3.734246, -5.532817, -1.434574>, 
      <3.756213, -5.374152, -1.511587>, <3.728764, -5.378767, -1.490261>, <3.704982, -5.429083, -1.461363>, <3.687713, -5.424266, -1.431229>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.892360, -5.803227, -1.619725>, <3.837599, -5.803646, -1.632756>, <3.763116, -5.770956, -1.613988>, <3.709163, -5.768912, -1.598061>, 
      <3.884032, -5.680617, -1.604405>, <3.829271, -5.681036, -1.617437>, <3.777230, -5.652529, -1.588046>, <3.723278, -5.650484, -1.572119>, 
      <3.849171, -5.516831, -1.556796>, <3.815238, -5.522122, -1.571229>, <3.800485, -5.482310, -1.490811>, <3.771324, -5.487213, -1.468154>, 
      <3.864599, -5.394526, -1.568659>, <3.830666, -5.399816, -1.583093>, <3.785375, -5.369249, -1.534244>, <3.756213, -5.374152, -1.511587>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.043875, -5.766353, -1.518409>, <4.015321, -5.779231, -1.564574>, <3.946631, -5.802812, -1.606810>, <3.892360, -5.803227, -1.619725>, 
      <4.022332, -5.638598, -1.488818>, <3.993778, -5.651476, -1.534983>, <3.938303, -5.680202, -1.591490>, <3.884032, -5.680617, -1.604405>, 
      <3.943334, -5.469917, -1.429120>, <3.911913, -5.486933, -1.474068>, <3.901474, -5.508678, -1.534548>, <3.849171, -5.516831, -1.556796>, 
      <3.972065, -5.340502, -1.419773>, <3.940644, -5.357517, -1.464721>, <3.916902, -5.386372, -1.546411>, <3.864599, -5.394526, -1.568659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.094824, -5.711915, -1.292391>, <4.100999, -5.722957, -1.362661>, <4.080420, -5.749872, -1.459326>, <4.043875, -5.766353, -1.518409>, 
      <4.095497, -5.578931, -1.275506>, <4.101672, -5.589972, -1.345776>, <4.058876, -5.622116, -1.429735>, <4.022332, -5.638598, -1.488818>, 
      <4.039899, -5.388020, -1.257302>, <4.035319, -5.397370, -1.326575>, <3.981666, -5.449159, -1.374285>, <3.943334, -5.469917, -1.429120>, 
      <4.097068, -5.268635, -1.236108>, <4.092488, -5.277985, -1.305381>, <4.010397, -5.319744, -1.364938>, <3.972065, -5.340502, -1.419773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.999952, -5.687812, -1.018564>, <4.081784, -5.684620, -1.048630>, <4.087279, -5.698424, -1.206532>, <4.094824, -5.711915, -1.292391>, 
      <4.000572, -5.565272, -1.003005>, <4.082404, -5.562080, -1.033071>, <4.087953, -5.565440, -1.189647>, <4.095497, -5.578931, -1.275506>, 
      <3.961281, -5.390464, -1.002081>, <4.027680, -5.388194, -1.056318>, <4.045506, -5.376572, -1.172490>, <4.039899, -5.388020, -1.257302>, 
      <4.002020, -5.279347, -0.966701>, <4.068418, -5.277077, -1.020939>, <4.102676, -5.257187, -1.151296>, <4.097068, -5.268635, -1.236108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.615352, -5.730620, -1.116227>, <3.716610, -5.729530, -1.052340>, <3.887640, -5.692193, -0.977299>, <3.999952, -5.687812, -1.018564>, 
      <3.668169, -5.595160, -1.077288>, <3.769427, -5.594070, -1.013400>, <3.888260, -5.569654, -0.961740>, <4.000572, -5.565272, -1.003005>, 
      <3.762462, -5.402506, -1.067578>, <3.822340, -5.398227, -1.047000>, <3.912152, -5.392144, -0.961949>, <3.961281, -5.390464, -1.002081>, 
      <3.791410, -5.279086, -0.986430>, <3.851288, -5.274808, -0.965853>, <3.952890, -5.281027, -0.926569>, <4.002020, -5.279347, -0.966701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.516415, -5.693015, -1.323647>, <3.521602, -5.682836, -1.254728>, <3.556272, -5.731256, -1.153503>, <3.615352, -5.730620, -1.116227>, 
      <3.522221, -5.578909, -1.264632>, <3.527408, -5.568730, -1.195713>, <3.609090, -5.595795, -1.114564>, <3.668169, -5.595160, -1.077288>, 
      <3.568877, -5.425079, -1.179873>, <3.587937, -5.398394, -1.098115>, <3.679344, -5.408445, -1.096141>, <3.762462, -5.402506, -1.067578>, 
      <3.535769, -5.312662, -1.126929>, <3.554829, -5.285977, -1.045171>, <3.708292, -5.285025, -1.014994>, <3.791410, -5.279086, -0.986430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.516415, -5.693015, -1.323647>, <3.522221, -5.578909, -1.264632>, <3.568877, -5.425079, -1.179873>, <3.535769, -5.312662, -1.126929>, 
      <3.511126, -5.703396, -1.393935>, <3.516932, -5.589291, -1.334920>, <3.545640, -5.457611, -1.279544>, <3.512532, -5.345194, -1.226600>, 
      <3.544365, -5.775826, -1.471924>, <3.575387, -5.665640, -1.442656>, <3.681355, -5.518064, -1.342284>, <3.634822, -5.409512, -1.338938>, 
      <3.584306, -5.791553, -1.528788>, <3.615328, -5.681367, -1.499520>, <3.734246, -5.532817, -1.434574>, <3.687713, -5.424266, -1.431229>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.611193, -5.035882, -1.879661>, <3.643533, -5.186204, -1.852424>, <3.736881, -5.229505, -1.567154>, <3.756213, -5.374152, -1.511587>, 
      <3.471394, -5.061990, -1.841301>, <3.503734, -5.212311, -1.814064>, <3.709432, -5.234120, -1.545829>, <3.728764, -5.378767, -1.490261>, 
      <3.369689, -5.180123, -1.649886>, <3.416105, -5.304904, -1.650436>, <3.652548, -5.306766, -1.457594>, <3.704982, -5.429083, -1.461363>, 
      <3.323530, -5.183216, -1.510041>, <3.369946, -5.307997, -1.510591>, <3.635279, -5.301948, -1.427460>, <3.687713, -5.424266, -1.431229>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.986181, -5.059465, -1.691869>, <3.990676, -5.171502, -1.676770>, <3.878694, -5.282792, -1.579497>, <3.864599, -5.394526, -1.568659>, 
      <3.884916, -5.039032, -1.764030>, <3.889410, -5.151070, -1.748931>, <3.844760, -5.288082, -1.593931>, <3.830666, -5.399816, -1.583093>, 
      <3.730791, -5.013547, -1.912478>, <3.763131, -5.163868, -1.885241>, <3.766042, -5.224602, -1.589811>, <3.785375, -5.369249, -1.534244>, 
      <3.611193, -5.035882, -1.879661>, <3.643533, -5.186204, -1.852424>, <3.736881, -5.229505, -1.567154>, <3.756213, -5.374152, -1.511587>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.180539, -5.150763, -1.473949>, <4.167761, -5.234630, -1.459154>, <3.990682, -5.256642, -1.413716>, <3.972065, -5.340502, -1.419773>, 
      <4.121000, -5.159474, -1.543254>, <4.108222, -5.243340, -1.528459>, <3.959262, -5.273657, -1.458664>, <3.940644, -5.357517, -1.464721>, 
      <4.059938, -5.074348, -1.639310>, <4.064432, -5.186385, -1.624212>, <3.930997, -5.274638, -1.557249>, <3.916902, -5.386372, -1.546411>, 
      <3.986181, -5.059465, -1.691869>, <3.990676, -5.171502, -1.676770>, <3.878694, -5.282792, -1.579497>, <3.864599, -5.394526, -1.568659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.438980, -4.993220, -1.164804>, <4.401409, -5.119630, -1.185165>, <4.153974, -5.149798, -1.215011>, <4.097068, -5.268635, -1.236108>, 
      <4.425122, -5.022765, -1.290428>, <4.387551, -5.149176, -1.310789>, <4.149394, -5.159148, -1.284284>, <4.092488, -5.277985, -1.305381>, 
      <4.264737, -5.138445, -1.375942>, <4.251958, -5.222312, -1.361147>, <4.029014, -5.235884, -1.358882>, <4.010397, -5.319744, -1.364938>, 
      <4.180539, -5.150763, -1.473949>, <4.167761, -5.234630, -1.459154>, <3.990682, -5.256642, -1.413716>, <3.972065, -5.340502, -1.419773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.255230, -4.991522, -0.796864>, <4.230588, -5.113590, -0.814593>, <4.043504, -5.166195, -0.930673>, <4.002020, -5.279347, -0.966701>, 
      <4.352252, -4.987497, -0.872981>, <4.327610, -5.109566, -0.890710>, <4.109902, -5.163925, -0.984911>, <4.068418, -5.277077, -1.020939>, 
      <4.452154, -4.965134, -1.045385>, <4.414583, -5.091545, -1.065746>, <4.159582, -5.138350, -1.130199>, <4.102676, -5.257187, -1.151296>, 
      <4.438980, -4.993220, -1.164804>, <4.401409, -5.119630, -1.185165>, <4.153974, -5.149798, -1.215011>, <4.097068, -5.268635, -1.236108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.781916, -5.020474, -0.649313>, <3.768975, -5.138168, -0.696603>, <3.815931, -5.174542, -0.917693>, <3.791410, -5.279086, -0.986430>, 
      <3.926336, -5.010609, -0.614061>, <3.913395, -5.128303, -0.661350>, <3.875809, -5.170263, -0.897116>, <3.851288, -5.274808, -0.965853>, 
      <4.138074, -4.996381, -0.704951>, <4.113432, -5.118450, -0.722680>, <3.994374, -5.167875, -0.890541>, <3.952890, -5.281027, -0.926569>, 
      <4.255230, -4.991522, -0.796864>, <4.230588, -5.113590, -0.814593>, <4.043504, -5.166195, -0.930673>, <4.002020, -5.279347, -0.966701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.328462, -5.054826, -1.023084>, <3.329155, -5.156155, -1.046611>, <3.508986, -5.221723, -1.084100>, <3.535769, -5.312662, -1.126929>, 
      <3.410338, -5.025757, -0.869342>, <3.411032, -5.127086, -0.892869>, <3.528047, -5.195038, -1.002342>, <3.554829, -5.285977, -1.045171>, 
      <3.610735, -5.032166, -0.691098>, <3.597794, -5.149860, -0.738387>, <3.732813, -5.180480, -0.946257>, <3.708292, -5.285025, -1.014994>, 
      <3.781916, -5.020474, -0.649313>, <3.768975, -5.138168, -0.696603>, <3.815931, -5.174542, -0.917693>, <3.791410, -5.279086, -0.986430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.328462, -5.054826, -1.023084>, <3.258412, -5.079696, -1.154620>, <3.276184, -5.186388, -1.366599>, <3.323530, -5.183216, -1.510041>, 
      <3.329155, -5.156155, -1.046611>, <3.259105, -5.181025, -1.178147>, <3.322600, -5.311170, -1.367149>, <3.369946, -5.307997, -1.510591>, 
      <3.508986, -5.221723, -1.084100>, <3.485750, -5.254255, -1.183772>, <3.582388, -5.287195, -1.335169>, <3.635279, -5.301948, -1.427460>, 
      <3.535769, -5.312662, -1.126929>, <3.512532, -5.345194, -1.226600>, <3.634822, -5.409512, -1.338938>, <3.687713, -5.424266, -1.431229>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.604549, -4.669199, -1.639318>, <3.606346, -4.794129, -1.680466>, <3.583950, -4.909252, -1.902605>, <3.611193, -5.035882, -1.879661>, 
      <3.530655, -4.692240, -1.594793>, <3.532452, -4.817170, -1.635941>, <3.444151, -4.935360, -1.864245>, <3.471394, -5.061990, -1.841301>, 
      <3.406700, -4.641513, -1.516532>, <3.407862, -4.804010, -1.548329>, <3.311960, -5.024930, -1.649202>, <3.369689, -5.180123, -1.649886>, 
      <3.396870, -4.642386, -1.427784>, <3.398031, -4.804884, -1.459580>, <3.265802, -5.028023, -1.509357>, <3.323530, -5.183216, -1.510041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.829022, -4.507637, -1.688181>, <3.845234, -4.678466, -1.701787>, <3.979343, -4.889007, -1.714841>, <3.986181, -5.059465, -1.691869>, 
      <3.746577, -4.511570, -1.705105>, <3.762788, -4.682398, -1.718710>, <3.878078, -4.868574, -1.787002>, <3.884916, -5.039032, -1.764030>, 
      <3.674272, -4.647458, -1.681330>, <3.676070, -4.772388, -1.722478>, <3.703547, -4.886917, -1.935422>, <3.730791, -5.013547, -1.912478>, 
      <3.604549, -4.669199, -1.639318>, <3.606346, -4.794129, -1.680466>, <3.583950, -4.909252, -1.902605>, <3.611193, -5.035882, -1.879661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.077786, -4.646628, -1.542176>, <4.093706, -4.801478, -1.545509>, <4.203643, -4.999127, -1.500698>, <4.180539, -5.150763, -1.473949>, 
      <4.016569, -4.635652, -1.615380>, <4.032489, -4.790502, -1.618713>, <4.144104, -5.007838, -1.570003>, <4.121000, -5.159474, -1.543254>, 
      <3.923014, -4.503154, -1.668887>, <3.939225, -4.673983, -1.682493>, <4.053100, -4.903890, -1.662282>, <4.059938, -5.074348, -1.639310>, 
      <3.829022, -4.507637, -1.688181>, <3.845234, -4.678466, -1.701787>, <3.979343, -4.889007, -1.714841>, <3.986181, -5.059465, -1.691869>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.298242, -4.591767, -1.127084>, <4.307510, -4.718687, -1.141945>, <4.475055, -4.871845, -1.145254>, <4.438980, -4.993220, -1.164804>, 
      <4.281285, -4.624762, -1.264109>, <4.290553, -4.751682, -1.278970>, <4.461197, -4.901390, -1.270878>, <4.425122, -5.022765, -1.290428>, 
      <4.168256, -4.662849, -1.433991>, <4.184176, -4.817698, -1.437324>, <4.287840, -4.986809, -1.402691>, <4.264737, -5.138445, -1.375942>, 
      <4.077786, -4.646628, -1.542176>, <4.093706, -4.801478, -1.545509>, <4.203643, -4.999127, -1.500698>, <4.180539, -5.150763, -1.473949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.163365, -4.480105, -0.850618>, <4.170448, -4.636540, -0.856676>, <4.285931, -4.839442, -0.774776>, <4.255230, -4.991522, -0.796864>, 
      <4.232720, -4.484642, -0.919956>, <4.239803, -4.641077, -0.926014>, <4.382952, -4.835417, -0.850893>, <4.352252, -4.987497, -0.872981>, 
      <4.309969, -4.568948, -1.032320>, <4.319237, -4.695868, -1.047181>, <4.488228, -4.843759, -1.025835>, <4.452154, -4.965134, -1.045385>, 
      <4.298242, -4.591767, -1.127084>, <4.307510, -4.718687, -1.141945>, <4.475055, -4.871845, -1.145254>, <4.438980, -4.993220, -1.164804>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.870063, -4.563756, -0.699010>, <3.869014, -4.703979, -0.704593>, <3.796160, -4.890927, -0.597261>, <3.781916, -5.020474, -0.649313>, 
      <3.965886, -4.534099, -0.679538>, <3.964837, -4.674322, -0.685121>, <3.940580, -4.881062, -0.562009>, <3.926336, -5.010609, -0.614061>, 
      <4.091181, -4.475383, -0.778452>, <4.098264, -4.631818, -0.784510>, <4.168775, -4.844301, -0.682862>, <4.138074, -4.996381, -0.704951>, 
      <4.163365, -4.480105, -0.850618>, <4.170448, -4.636540, -0.856676>, <4.285931, -4.839442, -0.774776>, <4.255230, -4.991522, -0.796864>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.531412, -4.675694, -0.979035>, <3.515148, -4.802978, -0.997806>, <3.327598, -4.928504, -0.993754>, <3.328462, -5.054826, -1.023084>, 
      <3.605194, -4.663434, -0.865402>, <3.588930, -4.790718, -0.884173>, <3.409474, -4.899434, -0.840012>, <3.410338, -5.025757, -0.869342>, 
      <3.742488, -4.603240, -0.724934>, <3.741438, -4.743464, -0.730517>, <3.624979, -4.902619, -0.639045>, <3.610735, -5.032166, -0.691098>, 
      <3.870063, -4.563756, -0.699010>, <3.869014, -4.703979, -0.704593>, <3.796160, -4.890927, -0.597261>, <3.781916, -5.020474, -0.649313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.531412, -4.675694, -0.979035>, <3.454994, -4.688392, -1.096729>, <3.381359, -4.643764, -1.287747>, <3.396870, -4.642386, -1.427784>, 
      <3.515148, -4.802978, -0.997806>, <3.438729, -4.815677, -1.115500>, <3.382520, -4.806261, -1.319543>, <3.398031, -4.804884, -1.459580>, 
      <3.327598, -4.928504, -0.993754>, <3.257548, -4.953374, -1.125290>, <3.218456, -5.031196, -1.365916>, <3.265802, -5.028023, -1.509357>, 
      <3.328462, -5.054826, -1.023084>, <3.258412, -5.079696, -1.154620>, <3.276184, -5.186388, -1.366599>, <3.323530, -5.183216, -1.510041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.599883, -4.249816, -1.620757>, <3.595651, -4.374972, -1.634190>, <3.602828, -4.549586, -1.599921>, <3.604549, -4.669199, -1.639318>, 
      <3.435335, -4.175596, -1.511677>, <3.431103, -4.300752, -1.525110>, <3.528934, -4.572626, -1.555396>, <3.530655, -4.692240, -1.594793>, 
      <3.329921, -3.875052, -1.390846>, <3.340080, -4.150305, -1.427079>, <3.404752, -4.368876, -1.463185>, <3.406700, -4.641513, -1.516532>, 
      <3.313230, -3.742016, -1.228039>, <3.323389, -4.017269, -1.264273>, <3.394922, -4.369750, -1.374437>, <3.396870, -4.642386, -1.427784>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.885658, -4.000211, -1.607505>, <3.880647, -4.153411, -1.631007>, <3.814417, -4.353740, -1.675924>, <3.829022, -4.507637, -1.688181>, 
      <3.800037, -4.067700, -1.640479>, <3.795026, -4.220900, -1.663982>, <3.731972, -4.357673, -1.692847>, <3.746577, -4.511570, -1.705105>, 
      <3.688746, -4.289898, -1.679664>, <3.684514, -4.415053, -1.693098>, <3.672551, -4.527845, -1.641934>, <3.674272, -4.647458, -1.681330>, 
      <3.599883, -4.249816, -1.620757>, <3.595651, -4.374972, -1.634190>, <3.602828, -4.549586, -1.599921>, <3.604549, -4.669199, -1.639318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.051328, -3.893974, -1.446897>, <4.052174, -4.117674, -1.489575>, <4.054500, -4.420138, -1.537301>, <4.077786, -4.646628, -1.542176>, 
      <4.009488, -3.925931, -1.501993>, <4.010334, -4.149632, -1.544671>, <3.993284, -4.409162, -1.610505>, <4.016569, -4.635652, -1.615380>, 
      <3.942945, -3.955056, -1.585443>, <3.937934, -4.108256, -1.608945>, <3.908409, -4.349258, -1.656630>, <3.923014, -4.503154, -1.668887>, 
      <3.885658, -4.000211, -1.607505>, <3.880647, -4.153411, -1.631007>, <3.814417, -4.353740, -1.675924>, <3.829022, -4.507637, -1.688181>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.341070, -3.652373, -1.007808>, <4.337403, -3.929138, -1.073034>, <4.277672, -4.310065, -1.094100>, <4.298242, -4.591767, -1.127084>, 
      <4.308309, -3.709067, -1.168660>, <4.304642, -3.985833, -1.233886>, <4.260715, -4.343060, -1.231126>, <4.281285, -4.624762, -1.264109>, 
      <4.146679, -3.821146, -1.321337>, <4.147525, -4.044846, -1.364015>, <4.144971, -4.436358, -1.429116>, <4.168256, -4.662849, -1.433991>, 
      <4.051328, -3.893974, -1.446897>, <4.052174, -4.117674, -1.489575>, <4.054500, -4.420138, -1.537301>, <4.077786, -4.646628, -1.542176>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.194332, -3.646502, -0.744775>, <4.192857, -3.894768, -0.789458>, <4.151964, -4.228292, -0.840866>, <4.163365, -4.480105, -0.850618>, 
      <4.266142, -3.634142, -0.798238>, <4.264667, -3.882408, -0.842921>, <4.221319, -4.232829, -0.910204>, <4.232720, -4.484642, -0.919956>, 
      <4.358119, -3.622870, -0.924102>, <4.354452, -3.899635, -0.989328>, <4.289399, -4.287247, -0.999336>, <4.309969, -4.568948, -1.032320>, 
      <4.341070, -3.652373, -1.007808>, <4.337403, -3.929138, -1.073034>, <4.277672, -4.310065, -1.094100>, <4.298242, -4.591767, -1.127084>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.791446, -3.746976, -0.598610>, <3.798476, -3.992983, -0.629205>, <3.871918, -4.315957, -0.689144>, <3.870063, -4.563756, -0.699010>, 
      <3.922420, -3.759010, -0.586742>, <3.929450, -4.005017, -0.617338>, <3.967740, -4.286300, -0.669672>, <3.965886, -4.534099, -0.679538>, 
      <4.089401, -3.664563, -0.666653>, <4.087926, -3.912830, -0.711336>, <4.079780, -4.223569, -0.768700>, <4.091181, -4.475383, -0.778452>, 
      <4.194332, -3.646502, -0.744775>, <4.192857, -3.894768, -0.789458>, <4.151964, -4.228292, -0.840866>, <4.163365, -4.480105, -0.850618>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.516377, -3.584211, -0.806205>, <3.520290, -3.914866, -0.830307>, <3.572994, -4.350276, -0.931044>, <3.531412, -4.675694, -0.979035>, 
      <3.585544, -3.584928, -0.715167>, <3.589457, -3.915583, -0.739268>, <3.646776, -4.338016, -0.817411>, <3.605194, -4.663434, -0.865402>, 
      <3.678051, -3.736557, -0.608885>, <3.685080, -3.982564, -0.639480>, <3.744342, -4.355442, -0.715068>, <3.742488, -4.603240, -0.724934>, 
      <3.791446, -3.746976, -0.598610>, <3.798476, -3.992983, -0.629205>, <3.871918, -4.315957, -0.689144>, <3.870063, -4.563756, -0.699010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.516377, -3.584211, -0.806205>, <3.426709, -3.583281, -0.924227>, <3.301500, -3.648521, -1.113622>, <3.313230, -3.742016, -1.228039>, 
      <3.520290, -3.914866, -0.830307>, <3.430621, -3.913936, -0.948328>, <3.311659, -3.923774, -1.149855>, <3.323389, -4.017269, -1.264273>, 
      <3.572994, -4.350276, -0.931044>, <3.496575, -4.362975, -1.048738>, <3.379410, -4.371127, -1.234400>, <3.394922, -4.369750, -1.374437>, 
      <3.531412, -4.675694, -0.979035>, <3.454994, -4.688392, -1.096729>, <3.381359, -4.643764, -1.287747>, <3.396870, -4.642386, -1.427784>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.660187, -3.023760, -1.462709>, <3.638714, -3.393330, -1.491369>, <3.612359, -3.880844, -1.581154>, <3.599883, -4.249816, -1.620757>, 
      <3.555190, -2.992184, -1.409518>, <3.533717, -3.361755, -1.438178>, <3.447811, -3.806624, -1.472074>, <3.435335, -4.175596, -1.511677>, 
      <3.366372, -3.047334, -1.333914>, <3.362292, -3.259094, -1.319268>, <3.322157, -3.664703, -1.363156>, <3.329921, -3.875052, -1.390846>, 
      <3.337538, -3.034847, -1.216172>, <3.333459, -3.246608, -1.201525>, <3.305466, -3.531667, -1.200349>, <3.313230, -3.742016, -1.228039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.871939, -3.195558, -1.486897>, <3.870654, -3.437806, -1.517101>, <3.893547, -3.759032, -1.570506>, <3.885658, -4.000211, -1.607505>, 
      <3.806998, -3.154016, -1.515208>, <3.805714, -3.396264, -1.545411>, <3.807926, -3.826522, -1.603481>, <3.800037, -4.067700, -1.640479>, 
      <3.730945, -3.045039, -1.498555>, <3.709472, -3.414610, -1.527215>, <3.701222, -3.920925, -1.640062>, <3.688746, -4.289898, -1.679664>, 
      <3.660187, -3.023760, -1.462709>, <3.638714, -3.393330, -1.491369>, <3.612359, -3.880844, -1.581154>, <3.599883, -4.249816, -1.620757>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.072645, -3.287605, -1.282899>, <4.064064, -3.475095, -1.300977>, <4.050628, -3.708761, -1.411562>, <4.051328, -3.893974, -1.446897>, 
      <4.023712, -3.287482, -1.358655>, <4.015132, -3.474972, -1.376732>, <4.008787, -3.740718, -1.466658>, <4.009488, -3.925931, -1.501993>, 
      <3.943253, -3.241177, -1.455808>, <3.941969, -3.483425, -1.486011>, <3.950834, -3.713878, -1.548444>, <3.942945, -3.955056, -1.585443>, 
      <3.871939, -3.195558, -1.486897>, <3.870654, -3.437806, -1.517101>, <3.893547, -3.759032, -1.570506>, <3.885658, -4.000211, -1.607505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.316726, -3.196681, -0.798301>, <4.310351, -3.346706, -0.810322>, <4.343013, -3.505761, -0.973256>, <4.341070, -3.652373, -1.007808>, 
      <4.293282, -3.230541, -0.958129>, <4.286907, -3.380566, -0.970150>, <4.310251, -3.562456, -1.134108>, <4.308309, -3.709067, -1.168660>, 
      <4.162198, -3.287831, -1.144258>, <4.153617, -3.475321, -1.162336>, <4.145978, -3.635933, -1.286002>, <4.146679, -3.821146, -1.321337>, 
      <4.072645, -3.287605, -1.282899>, <4.064064, -3.475095, -1.300977>, <4.050628, -3.708761, -1.411562>, <4.051328, -3.893974, -1.446897>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.171299, -3.145121, -0.610345>, <4.169964, -3.299749, -0.630016>, <4.195244, -3.493090, -0.717163>, <4.194332, -3.646502, -0.744775>, 
      <4.229926, -3.170460, -0.645601>, <4.228591, -3.325089, -0.665272>, <4.267054, -3.480729, -0.770626>, <4.266142, -3.634142, -0.798238>, 
      <4.327089, -3.181715, -0.727656>, <4.320714, -3.331740, -0.739677>, <4.360062, -3.476258, -0.889550>, <4.358119, -3.622870, -0.924102>, 
      <4.316726, -3.196681, -0.798301>, <4.310351, -3.346706, -0.810322>, <4.343013, -3.505761, -0.973256>, <4.341070, -3.652373, -1.007808>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.824924, -2.984119, -0.502554>, <3.814558, -3.213569, -0.526049>, <3.784901, -3.517950, -0.570127>, <3.791446, -3.746976, -0.598610>, 
      <3.932923, -3.014533, -0.462709>, <3.922557, -3.243984, -0.486204>, <3.915876, -3.529984, -0.558259>, <3.922420, -3.759010, -0.586742>, 
      <4.075616, -3.103765, -0.552805>, <4.074280, -3.258394, -0.572476>, <4.090312, -3.511150, -0.639041>, <4.089401, -3.664563, -0.666653>, 
      <4.171299, -3.145121, -0.610345>, <4.169964, -3.299749, -0.630016>, <4.195244, -3.493090, -0.717163>, <4.194332, -3.646502, -0.744775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.511100, -2.959198, -0.853919>, <3.524233, -3.142805, -0.815432>, <3.514158, -3.396666, -0.792535>, <3.516377, -3.584211, -0.806205>, 
      <3.590784, -2.950904, -0.737247>, <3.603918, -3.134511, -0.698760>, <3.583325, -3.397383, -0.701496>, <3.585544, -3.584928, -0.715167>, 
      <3.696548, -2.947966, -0.549917>, <3.686182, -3.177416, -0.573413>, <3.671506, -3.507532, -0.580401>, <3.678051, -3.736557, -0.608885>, 
      <3.824924, -2.984119, -0.502554>, <3.814558, -3.213569, -0.526049>, <3.784901, -3.517950, -0.570127>, <3.791446, -3.746976, -0.598610>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.511100, -2.959198, -0.853919>, <3.442060, -2.966384, -0.955005>, <3.308524, -3.022283, -1.097694>, <3.337538, -3.034847, -1.216172>, 
      <3.524233, -3.142805, -0.815432>, <3.455193, -3.149991, -0.916518>, <3.304445, -3.234043, -1.083048>, <3.333459, -3.246608, -1.201525>, 
      <3.514158, -3.396666, -0.792535>, <3.424490, -3.395736, -0.910556>, <3.293736, -3.438172, -1.085932>, <3.305466, -3.531667, -1.200349>, 
      <3.516377, -3.584211, -0.806205>, <3.426709, -3.583281, -0.924227>, <3.301500, -3.648521, -1.113622>, <3.313230, -3.742016, -1.228039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.694569, -2.620190, -1.494380>, <3.694187, -2.741059, -1.510048>, <3.667236, -2.902448, -1.453301>, <3.660187, -3.023760, -1.462709>, 
      <3.577712, -2.600639, -1.466119>, <3.577330, -2.721508, -1.481788>, <3.562239, -2.870872, -1.400111>, <3.555190, -2.992184, -1.409518>, 
      <3.392560, -2.638712, -1.401656>, <3.406580, -2.775448, -1.406615>, <3.369015, -2.910144, -1.343403>, <3.366372, -3.047334, -1.333914>, 
      <3.335506, -2.585671, -1.308019>, <3.349526, -2.722407, -1.312979>, <3.340181, -2.897658, -1.225661>, <3.337538, -3.034847, -1.216172>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.892664, -2.678886, -1.442762>, <3.887764, -2.833922, -1.456151>, <3.872758, -3.041066, -1.467635>, <3.871939, -3.195558, -1.486897>, 
      <3.833762, -2.682625, -1.467220>, <3.828862, -2.837661, -1.480609>, <3.807818, -2.999524, -1.495946>, <3.806998, -3.154016, -1.515208>, 
      <3.755861, -2.630444, -1.509203>, <3.755479, -2.751313, -1.524871>, <3.737994, -2.923727, -1.489147>, <3.730945, -3.045039, -1.498555>, 
      <3.694569, -2.620190, -1.494380>, <3.694187, -2.741059, -1.510048>, <3.667236, -2.902448, -1.453301>, <3.660187, -3.023760, -1.462709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.110834, -2.593765, -1.321533>, <4.128534, -2.801674, -1.314223>, <4.082147, -3.079995, -1.262882>, <4.072645, -3.287605, -1.282899>, 
      <4.058969, -2.616750, -1.376672>, <4.076669, -2.824659, -1.369362>, <4.033214, -3.079872, -1.338637>, <4.023712, -3.287482, -1.358655>, 
      <3.965602, -2.674256, -1.412476>, <3.960702, -2.829292, -1.425865>, <3.944072, -3.086685, -1.436546>, <3.943253, -3.241177, -1.455808>, 
      <3.892664, -2.678886, -1.442762>, <3.887764, -2.833922, -1.456151>, <3.872758, -3.041066, -1.467635>, <3.871939, -3.195558, -1.486897>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.391836, -2.457664, -0.912080>, <4.402524, -2.682346, -0.896915>, <4.326267, -2.972156, -0.780311>, <4.316726, -3.196681, -0.798301>, 
      <4.373798, -2.515758, -1.054074>, <4.384486, -2.740439, -1.038909>, <4.302822, -3.006017, -0.940138>, <4.293282, -3.230541, -0.958129>, 
      <4.212107, -2.548883, -1.213868>, <4.229807, -2.756792, -1.206557>, <4.171700, -3.080221, -1.124241>, <4.162198, -3.287831, -1.144258>, 
      <4.110834, -2.593765, -1.321533>, <4.128534, -2.801674, -1.314223>, <4.082147, -3.079995, -1.262882>, <4.072645, -3.287605, -1.282899>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.206071, -2.287041, -0.571831>, <4.220350, -2.543794, -0.591409>, <4.173508, -2.889298, -0.577801>, <4.171299, -3.145121, -0.610345>, 
      <4.301113, -2.309633, -0.653082>, <4.315392, -2.566386, -0.672659>, <4.232135, -2.914637, -0.613056>, <4.229926, -3.170460, -0.645601>, 
      <4.406674, -2.409879, -0.795283>, <4.417361, -2.634561, -0.780118>, <4.336629, -2.957190, -0.709665>, <4.327089, -3.181715, -0.727656>, 
      <4.391836, -2.457664, -0.912080>, <4.402524, -2.682346, -0.896915>, <4.326267, -2.972156, -0.780311>, <4.316726, -3.196681, -0.798301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.855452, -2.330165, -0.453530>, <3.863554, -2.526948, -0.453317>, <3.833766, -2.788391, -0.482512>, <3.824924, -2.984119, -0.502554>, 
      <3.949645, -2.319606, -0.394309>, <3.957747, -2.516389, -0.394096>, <3.941765, -2.818805, -0.442667>, <3.932923, -3.014533, -0.462709>, 
      <4.122473, -2.267170, -0.500364>, <4.136753, -2.523923, -0.519942>, <4.077824, -2.847942, -0.520261>, <4.075616, -3.103765, -0.552805>, 
      <4.206071, -2.287041, -0.571831>, <4.220350, -2.543794, -0.591409>, <4.173508, -2.889298, -0.577801>, <4.171299, -3.145121, -0.610345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.429818, -2.374060, -1.059874>, <3.443329, -2.557344, -1.021778>, <3.497993, -2.775950, -0.892331>, <3.511100, -2.959198, -0.853919>, 
      <3.541948, -2.318958, -0.875598>, <3.555458, -2.502243, -0.837501>, <3.577677, -2.767657, -0.775659>, <3.590784, -2.950904, -0.737247>, 
      <3.667815, -2.351199, -0.571500>, <3.675917, -2.547982, -0.571287>, <3.705390, -2.752238, -0.529875>, <3.696548, -2.947966, -0.549917>, 
      <3.855452, -2.330165, -0.453530>, <3.863554, -2.526948, -0.453317>, <3.833766, -2.788391, -0.482512>, <3.824924, -2.984119, -0.502554>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.429818, -2.374060, -1.059874>, <3.378524, -2.399266, -1.144171>, <3.287801, -2.541321, -1.229726>, <3.335506, -2.585671, -1.308019>, 
      <3.443329, -2.557344, -1.021778>, <3.392034, -2.582551, -1.106075>, <3.301821, -2.678057, -1.234686>, <3.349526, -2.722407, -1.312979>, 
      <3.497993, -2.775950, -0.892331>, <3.428953, -2.783136, -0.993417>, <3.311167, -2.885093, -1.107183>, <3.340181, -2.897658, -1.225661>, 
      <3.511100, -2.959198, -0.853919>, <3.442060, -2.966384, -0.955005>, <3.308524, -3.022283, -1.097694>, <3.337538, -3.034847, -1.216172>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.924157, -1.543463, -1.344225>, <3.981130, -1.857381, -1.318254>, <4.083697, -2.275013, -1.332741>, <4.110834, -2.593765, -1.321533>, 
      <3.924157, -1.543463, -1.344225>, <3.971682, -2.198008, -1.347815>, <4.031832, -2.297999, -1.387880>, <4.058969, -2.616750, -1.376672>, 
      <3.924157, -1.543463, -1.344225>, <3.971682, -2.198008, -1.347815>, <3.976367, -2.333655, -1.383062>, <3.965602, -2.674256, -1.412476>, 
      <3.924157, -1.543463, -1.344225>, <3.914709, -1.884090, -1.373786>, <3.903429, -2.338285, -1.413348>, <3.892664, -2.678886, -1.442762>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.664150, -1.769379, -1.300102>, <3.685594, -2.027766, -1.337595>, <3.695390, -2.360393, -1.460702>, <3.694569, -2.620190, -1.494380>, 
      <3.528927, -1.805522, -1.267195>, <3.550372, -2.063909, -1.304688>, <3.578534, -2.340842, -1.432442>, <3.577712, -2.600639, -1.466119>, 
      <3.301866, -1.825102, -1.225625>, <3.305175, -2.084488, -1.257095>, <3.365924, -2.378935, -1.392233>, <3.392560, -2.638712, -1.401656>, 
      <3.204347, -1.735860, -1.169054>, <3.207655, -1.995246, -1.200524>, <3.308870, -2.325894, -1.298596>, <3.335506, -2.585671, -1.308019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.664150, -1.769379, -1.300102>, <3.762123, -1.743192, -1.323944>, <3.849872, -1.597017, -1.393892>, <3.924157, -1.543463, -1.344225>, 
      <3.685594, -2.027766, -1.337595>, <3.783568, -2.001579, -1.361438>, <3.840424, -1.937643, -1.423453>, <3.914709, -1.884090, -1.373786>, 
      <3.695390, -2.360393, -1.460702>, <3.756682, -2.370647, -1.475525>, <3.844528, -2.342025, -1.437807>, <3.903429, -2.338285, -1.413348>, 
      <3.694569, -2.620190, -1.494380>, <3.755861, -2.630444, -1.509203>, <3.833762, -2.682625, -1.467220>, <3.892664, -2.678886, -1.442762>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.229447, -1.361844, -0.922143>, <4.277484, -1.690697, -0.920086>, <4.376080, -2.126441, -0.934436>, <4.391836, -2.457664, -0.912080>, 
      <4.202992, -1.401899, -1.080530>, <4.251030, -1.730752, -1.078473>, <4.358043, -2.184535, -1.076429>, <4.373798, -2.515758, -1.054074>, 
      <4.042169, -1.458386, -1.265322>, <4.099142, -1.772303, -1.239351>, <4.184970, -2.230131, -1.225075>, <4.212107, -2.548883, -1.213868>, 
      <3.924157, -1.543463, -1.344225>, <3.981130, -1.857381, -1.318254>, <4.083697, -2.275013, -1.332741>, <4.110834, -2.593765, -1.321533>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.069946, -1.322730, -0.471387>, <4.110946, -1.612896, -0.491113>, <4.189808, -1.994629, -0.549535>, <4.206071, -2.287041, -0.571831>, 
      <4.177444, -1.316903, -0.566906>, <4.218444, -1.607068, -0.586631>, <4.284850, -2.017220, -0.630785>, <4.301113, -2.309633, -0.653082>, 
      <4.252453, -1.327012, -0.784407>, <4.300490, -1.655865, -0.782351>, <4.390918, -2.078656, -0.817639>, <4.406674, -2.409879, -0.795283>, 
      <4.229447, -1.361844, -0.922143>, <4.277484, -1.690697, -0.920086>, <4.376080, -2.126441, -0.934436>, <4.391836, -2.457664, -0.912080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.759185, -1.387337, -0.504287>, <3.818220, -1.665703, -0.494468>, <3.843740, -2.045680, -0.453839>, <3.855452, -2.330165, -0.453530>, 
      <3.824534, -1.366630, -0.437464>, <3.883568, -1.644996, -0.427645>, <3.937933, -2.035120, -0.394618>, <3.949645, -2.319606, -0.394309>, 
      <3.998442, -1.326606, -0.407851>, <4.039442, -1.616772, -0.427577>, <4.106211, -1.974758, -0.478067>, <4.122473, -2.267170, -0.500364>, 
      <4.069946, -1.322730, -0.471387>, <4.110946, -1.612896, -0.491113>, <4.189808, -1.994629, -0.549535>, <4.206071, -2.287041, -0.571831>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.405978, -1.533121, -1.150336>, <3.429409, -1.785384, -1.134587>, <3.411546, -2.126179, -1.111397>, <3.429818, -2.374060, -1.059874>, 
      <3.539830, -1.449042, -0.989964>, <3.563261, -1.701304, -0.974215>, <3.523676, -2.071077, -0.927121>, <3.541948, -2.318958, -0.875598>, 
      <3.605474, -1.436043, -0.661467>, <3.664508, -1.714409, -0.651648>, <3.656103, -2.066714, -0.571809>, <3.667815, -2.351199, -0.571500>, 
      <3.759185, -1.387337, -0.504287>, <3.818220, -1.665703, -0.494468>, <3.843740, -2.045680, -0.453839>, <3.855452, -2.330165, -0.453530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.405978, -1.533121, -1.150336>, <3.354879, -1.565219, -1.211560>, <3.146044, -1.682506, -1.135232>, <3.204347, -1.735860, -1.169054>, 
      <3.429409, -1.785384, -1.134587>, <3.378310, -1.817482, -1.195810>, <3.149353, -1.941892, -1.166702>, <3.207655, -1.995246, -1.200524>, 
      <3.411546, -2.126179, -1.111397>, <3.360252, -2.151385, -1.195695>, <3.261165, -2.281544, -1.220303>, <3.308870, -2.325894, -1.298596>, 
      <3.429818, -2.374060, -1.059874>, <3.378524, -2.399266, -1.144171>, <3.287801, -2.541321, -1.229726>, <3.335506, -2.585671, -1.308019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.317364, -1.163379, -1.135460>, <3.283459, -1.335123, -1.145538>, <3.202127, -1.561801, -1.147936>, <3.204347, -1.735860, -1.169054>, 
      <3.317364, -1.163379, -1.135460>, <3.323810, -1.435628, -1.109467>, <3.143824, -1.508447, -1.114115>, <3.146044, -1.682506, -1.135232>, 
      <3.317364, -1.163379, -1.135460>, <3.323810, -1.435628, -1.109467>, <3.344342, -1.451776, -1.218642>, <3.354879, -1.565219, -1.211560>, 
      <3.317364, -1.163379, -1.135460>, <3.357715, -1.263883, -1.099389>, <3.395441, -1.419678, -1.157419>, <3.405978, -1.533121, -1.150336>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.583450, -1.281309, -1.300102>, <3.592041, -1.426902, -1.272641>, <3.652002, -1.623001, -1.278862>, <3.664150, -1.769379, -1.300102>, 
      <3.496906, -1.287008, -1.249693>, <3.505496, -1.432601, -1.222232>, <3.516779, -1.659145, -1.245955>, <3.528927, -1.805522, -1.267195>, 
      <3.321115, -1.207504, -1.225473>, <3.287210, -1.379248, -1.235552>, <3.299646, -1.651043, -1.204508>, <3.301866, -1.825102, -1.225625>, 
      <3.317364, -1.163379, -1.135460>, <3.283459, -1.335123, -1.145538>, <3.202127, -1.561801, -1.147936>, <3.204347, -1.735860, -1.169054>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.844927, -1.128639, -1.442747>, <3.884691, -1.250398, -1.419961>, <3.901001, -1.415877, -1.354781>, <3.924157, -1.543463, -1.344225>, 
      <3.773999, -1.182168, -1.489504>, <3.813763, -1.303927, -1.466718>, <3.826717, -1.469431, -1.404447>, <3.849872, -1.597017, -1.393892>, 
      <3.670076, -1.275605, -1.350558>, <3.678666, -1.421198, -1.323097>, <3.749975, -1.596814, -1.302704>, <3.762123, -1.743192, -1.323944>, 
      <3.583450, -1.281309, -1.300102>, <3.592041, -1.426902, -1.272641>, <3.652002, -1.623001, -1.278862>, <3.664150, -1.769379, -1.300102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.156794, -0.848611, -0.922143>, <4.185090, -0.999536, -0.897589>, <4.206971, -1.207975, -0.923105>, <4.229447, -1.361844, -0.922143>, 
      <4.127240, -0.910513, -1.110553>, <4.155536, -1.061438, -1.085998>, <4.180516, -1.248030, -1.081492>, <4.202992, -1.401899, -1.080530>, 
      <3.986562, -1.021749, -1.349379>, <4.026325, -1.143508, -1.326593>, <4.019013, -1.330800, -1.275878>, <4.042169, -1.458386, -1.265322>, 
      <3.844927, -1.128639, -1.442747>, <3.884691, -1.250398, -1.419961>, <3.901001, -1.415877, -1.354781>, <3.924157, -1.543463, -1.344225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.997294, -0.809497, -0.471387>, <4.017032, -0.961586, -0.445675>, <4.048238, -1.169102, -0.460943>, <4.069946, -1.322730, -0.471387>, 
      <4.115614, -0.801189, -0.552904>, <4.135352, -0.953278, -0.527192>, <4.155736, -1.163275, -0.556462>, <4.177444, -1.316903, -0.566906>, 
      <4.178008, -0.804178, -0.786905>, <4.206303, -0.955103, -0.762351>, <4.229977, -1.173143, -0.785370>, <4.252453, -1.327012, -0.784407>, 
      <4.156794, -0.848611, -0.922143>, <4.185090, -0.999536, -0.897589>, <4.206971, -1.207975, -0.923105>, <4.229447, -1.361844, -0.922143>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.550283, -0.891200, -0.504287>, <3.647190, -1.016797, -0.534547>, <3.725701, -1.229448, -0.509856>, <3.759185, -1.387337, -0.504287>, 
      <3.641919, -0.843506, -0.414788>, <3.738826, -0.969104, -0.445048>, <3.791050, -1.208741, -0.443033>, <3.824534, -1.366630, -0.437464>, 
      <3.884926, -0.817387, -0.393971>, <3.904664, -0.969476, -0.368260>, <3.976734, -1.172978, -0.397408>, <3.998442, -1.326606, -0.407851>, 
      <3.997294, -0.809497, -0.471387>, <4.017032, -0.961586, -0.445675>, <4.048238, -1.169102, -0.460943>, <4.069946, -1.322730, -0.471387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.550283, -0.891200, -0.504287>, <3.404313, -0.967173, -0.646853>, <3.309222, -1.067612, -0.940098>, <3.317364, -1.163379, -1.135460>, 
      <3.647190, -1.016797, -0.534547>, <3.501220, -1.092770, -0.677113>, <3.349573, -1.168117, -0.904026>, <3.357715, -1.263883, -1.099389>, 
      <3.725701, -1.229448, -0.509856>, <3.571989, -1.278154, -0.667036>, <3.529293, -1.335599, -0.997047>, <3.395441, -1.419678, -1.157419>, 
      <3.759185, -1.387337, -0.504287>, <3.605474, -1.436043, -0.661467>, <3.539830, -1.449042, -0.989964>, <3.405978, -1.533121, -1.150336>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.590543, -0.521921, -1.535393>, <3.590044, -0.760098, -1.547995>, <3.569644, -1.047324, -1.344235>, <3.583450, -1.281309, -1.300102>, 
      <3.452622, -0.603471, -1.583579>, <3.452123, -0.841649, -1.596181>, <3.483100, -1.053023, -1.293826>, <3.496906, -1.287008, -1.249693>, 
      <3.213296, -0.647797, -1.375758>, <3.216460, -0.810036, -1.328815>, <3.261404, -1.058775, -1.278852>, <3.321115, -1.207504, -1.225473>, 
      <3.089083, -0.743805, -1.433623>, <3.092248, -0.906044, -1.386680>, <3.257652, -1.014650, -1.188839>, <3.317364, -1.163379, -1.135460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.590543, -0.521921, -1.535393>, <3.666858, -0.703936, -1.507599>, <3.784008, -0.942101, -1.477655>, <3.844927, -1.128639, -1.442747>, 
      <3.590543, -0.521921, -1.535393>, <3.666360, -0.942114, -1.520201>, <3.713080, -0.995630, -1.524412>, <3.773999, -1.182168, -1.489504>, 
      <3.590543, -0.521921, -1.535393>, <3.666360, -0.942114, -1.520201>, <3.656269, -1.041619, -1.394692>, <3.670076, -1.275605, -1.350558>, 
      <3.590543, -0.521921, -1.535393>, <3.590044, -0.760098, -1.547995>, <3.569644, -1.047324, -1.344235>, <3.583450, -1.281309, -1.300102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.100801, -0.900457, -1.763540>, <3.097286, -0.853461, -1.664565>, <3.007701, -0.806707, -1.471535>, <3.089083, -0.743805, -1.433623>, 
      <3.100801, -0.900457, -1.763540>, <3.215496, -0.891249, -1.444572>, <3.043407, -0.850887, -1.620202>, <3.124789, -0.787984, -1.582290>, 
      <3.100801, -0.900457, -1.763540>, <3.215496, -0.891249, -1.444572>, <3.286283, -0.709547, -1.296016>, <3.285051, -0.670091, -1.046537>, 
      <3.100801, -0.900457, -1.763540>, <3.219012, -0.938245, -1.543548>, <3.312280, -0.836968, -1.204274>, <3.311048, -0.797513, -0.954795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.100801, -0.900457, -1.763540>, <3.219012, -0.938245, -1.543548>, <3.312280, -0.836968, -1.204274>, <3.311048, -0.797513, -0.954795>, 
      <3.089433, -1.061169, -1.756839>, <3.207644, -1.098957, -1.536847>, <3.341387, -0.979631, -1.101559>, <3.340155, -0.940176, -0.852079>, 
      <2.955674, -1.226018, -1.637691>, <3.098736, -1.229410, -1.475671>, <3.276271, -1.246665, -1.165400>, <3.286381, -1.220292, -0.951085>, 
      <2.885822, -1.368872, -1.610937>, <3.028884, -1.372264, -1.448917>, <3.209616, -1.410510, -1.186908>, <3.219726, -1.384137, -0.972593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.093215, -0.657546, -0.227581>, <3.103479, -0.827590, -0.217044>, <3.011602, -1.047122, -0.267796>, <2.948565, -1.205195, -0.280856>, 
      <3.158565, -0.699536, -0.445745>, <3.168829, -0.869580, -0.435209>, <3.161646, -1.098256, -0.433436>, <3.098608, -1.256329, -0.446496>, 
      <3.309918, -0.761339, -0.726060>, <3.339025, -0.904002, -0.623345>, <3.297103, -1.192321, -0.723781>, <3.230448, -1.356165, -0.745289>, 
      <3.311048, -0.797513, -0.954795>, <3.340155, -0.940176, -0.852079>, <3.286381, -1.220292, -0.951085>, <3.219726, -1.384137, -0.972593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.157740, -0.607825, -0.316481>, <3.128870, -0.623602, -0.301443>, <3.126271, -0.665865, -0.239690>, <3.093215, -0.657546, -0.227581>, 
      <3.137143, -0.648619, -0.651624>, <3.108273, -0.664396, -0.636586>, <3.191620, -0.707855, -0.457854>, <3.158565, -0.699536, -0.445745>, 
      <3.013196, -0.649910, -1.117658>, <3.048902, -0.694089, -1.266325>, <3.283921, -0.633917, -0.817802>, <3.309918, -0.761339, -0.726060>, 
      <3.089083, -0.743805, -1.433623>, <3.124789, -0.787984, -1.582290>, <3.285051, -0.670091, -1.046537>, <3.311048, -0.797513, -0.954795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.157740, -0.607825, -0.316481>, <3.137143, -0.648619, -0.651624>, <3.013196, -0.649910, -1.117658>, <3.089083, -0.743805, -1.433623>, 
      <3.204983, -0.756196, -0.311591>, <3.184385, -0.796990, -0.646734>, <3.016361, -0.812148, -1.070715>, <3.092248, -0.906044, -1.386680>, 
      <3.456802, -0.770043, -0.475097>, <3.310832, -0.846016, -0.617663>, <3.249510, -0.918884, -0.993476>, <3.257652, -1.014650, -1.188839>, 
      <3.550283, -0.891200, -0.504287>, <3.404313, -0.967173, -0.646853>, <3.309222, -1.067612, -0.940098>, <3.317364, -1.163379, -1.135460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.894778, -0.570675, -2.445914>, <1.772529, -0.569334, -2.456419>, <1.608507, -0.565621, -2.445672>, <1.485820, -0.563455, -2.445568>, 
      <1.896618, -0.349461, -2.448834>, <1.774369, -0.348120, -2.459339>, <1.588672, -0.403842, -2.313956>, <1.465985, -0.401676, -2.313853>, 
      <1.893139, -0.155768, -2.128222>, <1.769751, -0.163944, -2.136831>, <1.562845, -0.173275, -2.138232>, <1.439539, -0.185972, -2.138232>, 
      <1.830725, 0.018128, -2.006517>, <1.707337, 0.009951, -2.015126>, <1.543010, -0.011497, -2.006517>, <1.419704, -0.024193, -2.006517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.894778, -0.570675, -2.445914>, <1.892492, -0.845544, -2.442286>, <1.850693, -1.106010, -2.086162>, <1.819257, -1.360978, -1.988314>, 
      <1.772529, -0.569334, -2.456419>, <1.770244, -0.844202, -2.452791>, <1.741317, -1.107294, -2.095739>, <1.709881, -1.362262, -1.997892>, 
      <1.608507, -0.565621, -2.445672>, <1.598772, -0.807659, -2.308399>, <1.572900, -1.127157, -2.125265>, <1.563164, -1.369195, -1.987992>, 
      <1.485820, -0.563455, -2.445568>, <1.476084, -0.805493, -2.308295>, <1.463103, -1.128210, -2.125265>, <1.453367, -1.370248, -1.987992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.251233, -0.571854, -2.379793>, <2.240723, -0.846524, -2.374880>, <2.197391, -1.108767, -2.022625>, <2.149705, -1.362071, -1.927017>, 
      <2.146664, -0.570934, -2.409685>, <2.136154, -0.845604, -2.404772>, <2.100452, -1.107914, -2.050337>, <2.052766, -1.361219, -1.954728>, 
      <2.003134, -0.571864, -2.436603>, <2.000848, -0.846733, -2.432975>, <1.951128, -1.104831, -2.077367>, <1.919692, -1.359799, -1.979519>, 
      <1.894778, -0.570675, -2.445914>, <1.892492, -0.845544, -2.442286>, <1.850693, -1.106010, -2.086162>, <1.819257, -1.360978, -1.988314>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.621430, -0.577066, -2.238190>, <2.638589, -0.850743, -2.230628>, <2.557012, -1.116273, -1.886982>, <2.492894, -1.366903, -1.795745>, 
      <2.529568, -0.541535, -2.304824>, <2.546727, -0.815212, -2.297262>, <2.455718, -1.115337, -1.930477>, <2.391600, -1.365967, -1.839239>, 
      <2.365566, -0.572860, -2.347109>, <2.355056, -0.847529, -2.342196>, <2.303382, -1.109699, -1.992326>, <2.255696, -1.363003, -1.896718>, 
      <2.251233, -0.571854, -2.379793>, <2.240723, -0.846524, -2.374880>, <2.197391, -1.108767, -2.022625>, <2.149705, -1.362071, -1.927017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.621430, -0.577066, -2.238190>, <2.794802, -0.644124, -2.112430>, <2.995765, -0.866881, -1.959015>, <3.100801, -0.900457, -1.763540>, 
      <2.638589, -0.850743, -2.230628>, <2.811961, -0.917802, -2.104869>, <2.984397, -1.027593, -1.952314>, <3.089433, -1.061169, -1.756839>, 
      <2.557012, -1.116273, -1.886982>, <2.676707, -1.117378, -1.835587>, <2.869462, -1.223973, -1.735327>, <2.955674, -1.226018, -1.637691>, 
      <2.492894, -1.366903, -1.795745>, <2.612589, -1.368009, -1.744349>, <2.799610, -1.366828, -1.708574>, <2.885822, -1.368872, -1.610937>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.011340, -0.198492, -1.111410>, <4.078827, -0.394589, -1.098817>, <4.118989, -0.646964, -0.954949>, <4.156794, -0.848611, -0.922143>, 
      <3.942505, -0.264161, -1.291629>, <4.009992, -0.460258, -1.279036>, <4.089435, -0.708866, -1.143359>, <4.127240, -0.910513, -1.110553>, 
      <3.758529, -0.422594, -1.476703>, <3.834844, -0.604610, -1.448909>, <3.925642, -0.835211, -1.384287>, <3.986562, -1.021749, -1.349379>, 
      <3.590543, -0.521921, -1.535393>, <3.666858, -0.703936, -1.507599>, <3.784008, -0.942101, -1.477655>, <3.844927, -1.128639, -1.442747>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.924652, -0.203178, -0.660654>, <3.966754, -0.385413, -0.618197>, <3.972950, -0.621916, -0.503099>, <3.997294, -0.809497, -0.471387>, 
      <4.019745, -0.157577, -0.749211>, <4.061848, -0.339813, -0.706754>, <4.091270, -0.613608, -0.584615>, <4.115614, -0.801189, -0.552904>, 
      <4.057856, -0.154115, -0.989625>, <4.125343, -0.350212, -0.977032>, <4.140202, -0.602531, -0.819711>, <4.178008, -0.804178, -0.786905>, 
      <4.011340, -0.198492, -1.111410>, <4.078827, -0.394589, -1.098817>, <4.118989, -0.646964, -0.954949>, <4.156794, -0.848611, -0.922143>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.924652, -0.203178, -0.660654>, <3.731390, -0.295854, -0.480676>, <3.381110, -0.485757, -0.432828>, <3.157740, -0.607825, -0.316481>, 
      <3.966754, -0.385413, -0.618197>, <3.773492, -0.478090, -0.438219>, <3.428352, -0.634127, -0.427938>, <3.204983, -0.756196, -0.311591>, 
      <3.972950, -0.621916, -0.503099>, <3.860582, -0.629806, -0.425683>, <3.548438, -0.722350, -0.385598>, <3.456802, -0.770043, -0.475097>, 
      <3.997294, -0.809497, -0.471387>, <3.884926, -0.817387, -0.393971>, <3.641919, -0.843506, -0.414788>, <3.550283, -0.891200, -0.504287>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.637153, -0.476808, -0.125780>, <2.640045, -0.680065, -0.109112>, <2.562726, -0.945789, -0.169796>, <2.507634, -1.141458, -0.186482>, 
      <2.778756, -0.520171, -0.151472>, <2.781649, -0.723429, -0.134804>, <2.695384, -0.968447, -0.193324>, <2.640292, -1.164116, -0.210010>, 
      <2.955863, -0.622978, -0.177266>, <2.966127, -0.793022, -0.166730>, <2.922192, -1.016651, -0.169093>, <2.859155, -1.174724, -0.182152>, 
      <3.093215, -0.657546, -0.227581>, <3.103479, -0.827590, -0.217044>, <3.011602, -1.047122, -0.267796>, <2.948565, -1.205195, -0.280856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.241656, -0.396773, -0.073076>, <2.240405, -0.600152, -0.053521>, <2.181178, -0.867739, -0.119659>, <2.140992, -1.067262, -0.137623>, 
      <2.361453, -0.413900, -0.089186>, <2.360202, -0.617279, -0.069631>, <2.292234, -0.883617, -0.134594>, <2.252048, -1.083140, -0.152558>, 
      <2.522139, -0.441587, -0.104912>, <2.525032, -0.644845, -0.088244>, <2.452833, -0.927020, -0.150305>, <2.397741, -1.122688, -0.166991>, 
      <2.637153, -0.476808, -0.125780>, <2.640045, -0.680065, -0.109112>, <2.562726, -0.945789, -0.169796>, <2.507634, -1.141458, -0.186482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.940692, -0.377236, -0.032119>, <1.936319, -0.580120, -0.011644>, <1.890517, -0.848083, -0.080737>, <1.861987, -1.049151, -0.099655>, 
      <2.031614, -0.380162, -0.040002>, <2.027241, -0.583046, -0.019527>, <1.974805, -0.850795, -0.088044>, <1.946275, -1.051863, -0.106963>, 
      <2.152056, -0.383963, -0.061026>, <2.150805, -0.587342, -0.041471>, <2.098115, -0.855864, -0.108489>, <2.057929, -1.055387, -0.126453>, 
      <2.241656, -0.396773, -0.073076>, <2.240405, -0.600152, -0.053521>, <2.181178, -0.867739, -0.119659>, <2.140992, -1.067262, -0.137623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.616835, -0.376668, -0.018903>, <1.609142, -0.578791, 0.001586>, <1.577551, -0.846853, -0.068143>, <1.561758, -1.048626, -0.087403>, 
      <1.714041, -0.375293, -0.021011>, <1.706348, -0.577417, -0.000522>, <1.667657, -0.845301, -0.070218>, <1.651865, -1.047074, -0.089478>, 
      <1.843867, -0.374121, -0.023724>, <1.839494, -0.577005, -0.003249>, <1.800756, -0.845195, -0.072954>, <1.772226, -1.046263, -0.091873>, 
      <1.940692, -0.377236, -0.032119>, <1.936319, -0.580120, -0.011644>, <1.890517, -0.848083, -0.080737>, <1.861987, -1.049151, -0.099655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.312510, -0.386120, -0.018495>, <1.310778, -0.587863, 0.002000>, <1.313404, -0.856727, -0.067757>, <1.313520, -1.058598, -0.087025>, 
      <1.403834, -0.384343, -0.018495>, <1.402103, -0.586086, 0.002000>, <1.387913, -0.854881, -0.067757>, <1.388029, -1.056752, -0.087025>, 
      <1.525524, -0.377959, -0.016923>, <1.517831, -0.580083, 0.003567>, <1.503050, -0.848136, -0.066427>, <1.487257, -1.049909, -0.085687>, 
      <1.616835, -0.376668, -0.018903>, <1.609142, -0.578791, 0.001586>, <1.577551, -0.846853, -0.068143>, <1.561758, -1.048626, -0.087403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.202885, 0.027706, -1.951876>, <2.284721, -0.143184, -2.066517>, <2.259700, -0.350595, -2.383751>, <2.251233, -0.571854, -2.379793>, 
      <2.094931, 0.021057, -1.984186>, <2.176767, -0.149833, -2.098827>, <2.155131, -0.349675, -2.413643>, <2.146664, -0.570934, -2.409685>, 
      <1.943087, 0.025574, -1.998678>, <2.005502, -0.148322, -2.120383>, <2.004973, -0.350650, -2.439523>, <2.003134, -0.571864, -2.436603>, 
      <1.830725, 0.018128, -2.006517>, <1.893139, -0.155768, -2.128222>, <1.896618, -0.349461, -2.448834>, <1.894778, -0.570675, -2.445914>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.403842, 0.053426, -1.834988>, <2.520802, -0.120160, -1.939188>, <2.606804, -0.343798, -2.244635>, <2.621430, -0.577066, -2.238190>, 
      <2.337939, 0.047972, -1.858455>, <2.454899, -0.125614, -1.962655>, <2.514942, -0.308267, -2.311269>, <2.529568, -0.541535, -2.304824>, 
      <2.269991, 0.031839, -1.931792>, <2.351827, -0.139051, -2.046432>, <2.374032, -0.351600, -2.351067>, <2.365566, -0.572860, -2.347109>, 
      <2.202885, 0.027706, -1.951876>, <2.284721, -0.143184, -2.066517>, <2.259700, -0.350595, -2.383751>, <2.251233, -0.571854, -2.379793>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.989211, 0.092782, -1.671879>, <3.164342, -0.145238, -1.729670>, <3.122028, -0.600362, -1.776052>, <3.100801, -0.900457, -1.763540>, 
      <2.818647, 0.087989, -1.737132>, <2.993778, -0.150031, -1.794923>, <3.016992, -0.566786, -1.971527>, <2.995765, -0.866881, -1.959015>, 
      <2.575419, 0.067626, -1.773893>, <2.692379, -0.105960, -1.878092>, <2.780177, -0.410857, -2.118876>, <2.794802, -0.644124, -2.112430>, 
      <2.403842, 0.053426, -1.834988>, <2.520802, -0.120160, -1.939188>, <2.606804, -0.343798, -2.244635>, <2.621430, -0.577066, -2.238190>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.293140, 0.078416, -1.494768>, <3.388644, 0.077855, -1.423706>, <3.509610, 0.050483, -1.309940>, <3.586318, 0.089274, -1.227585>, 
      <3.437974, -0.129161, -1.524144>, <3.533478, -0.129722, -1.453082>, <3.659565, -0.082994, -1.352907>, <3.736274, -0.044204, -1.270552>, 
      <3.084309, -0.499078, -1.504434>, <3.208522, -0.403070, -1.446569>, <3.453051, -0.398456, -1.572732>, <3.590972, -0.316906, -1.524546>, 
      <3.089083, -0.743805, -1.433623>, <3.213296, -0.647797, -1.375758>, <3.452622, -0.603471, -1.583579>, <3.590543, -0.521921, -1.535393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.293140, 0.078416, -1.494768>, <3.437974, -0.129161, -1.524144>, <3.084309, -0.499078, -1.504434>, <3.089083, -0.743805, -1.433623>, 
      <3.208406, 0.078914, -1.557817>, <3.353240, -0.128663, -1.587193>, <3.002927, -0.561980, -1.542345>, <3.007701, -0.806707, -1.471535>, 
      <3.087823, 0.095553, -1.634153>, <3.262954, -0.142467, -1.691944>, <3.118512, -0.553367, -1.677077>, <3.097286, -0.853461, -1.664565>, 
      <2.989211, 0.092782, -1.671879>, <3.164342, -0.145238, -1.729670>, <3.122028, -0.600362, -1.776052>, <3.100801, -0.900457, -1.763540>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.757024, 0.313000, -0.996738>, <3.909925, 0.228787, -1.005681>, <3.954566, -0.033522, -1.122004>, <4.011340, -0.198492, -1.111410>, 
      <3.731041, 0.258555, -1.087756>, <3.883942, 0.174343, -1.096699>, <3.885730, -0.099192, -1.302223>, <3.942505, -0.264161, -1.291629>, 
      <3.656680, 0.124856, -1.152043>, <3.806636, -0.008621, -1.195010>, <3.758958, -0.217579, -1.465856>, <3.758529, -0.422594, -1.476703>, 
      <3.586318, 0.089274, -1.227585>, <3.736274, -0.044204, -1.270552>, <3.590972, -0.316906, -1.524546>, <3.590543, -0.521921, -1.535393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.723324, 0.376350, -0.747664>, <3.882699, 0.282659, -0.728231>, <3.883845, -0.026550, -0.701805>, <3.924652, -0.203178, -0.660654>, 
      <3.783522, 0.384732, -0.796170>, <3.942897, 0.291041, -0.776736>, <3.978938, 0.019051, -0.790362>, <4.019745, -0.157577, -0.749211>, 
      <3.775528, 0.351772, -0.931921>, <3.928429, 0.267559, -0.940865>, <4.001082, 0.010854, -1.000219>, <4.057856, -0.154115, -0.989625>, 
      <3.757024, 0.313000, -0.996738>, <3.909925, 0.228787, -1.005681>, <3.954566, -0.033522, -1.122004>, <4.011340, -0.198492, -1.111410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.191909, 0.234317, -0.541382>, <3.344377, 0.031461, -0.477440>, <3.078380, -0.358586, -0.324696>, <3.157740, -0.607825, -0.316481>, 
      <3.353484, 0.245667, -0.610853>, <3.505952, 0.042811, -0.546910>, <3.301750, -0.236518, -0.441043>, <3.381110, -0.485757, -0.432828>, 
      <3.586889, 0.357354, -0.637728>, <3.746264, 0.263663, -0.618294>, <3.690583, -0.119226, -0.521826>, <3.731390, -0.295854, -0.480676>, 
      <3.723324, 0.376350, -0.747664>, <3.882699, 0.282659, -0.728231>, <3.883845, -0.026550, -0.701805>, <3.924652, -0.203178, -0.660654>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.856776, 0.315479, -0.375083>, <3.035479, 0.079424, -0.307683>, <3.074955, -0.355032, -0.246326>, <3.093215, -0.657546, -0.227581>, 
      <2.963233, 0.289464, -0.409436>, <3.141936, 0.053409, -0.342036>, <3.108011, -0.363351, -0.258435>, <3.126271, -0.665865, -0.239690>, 
      <3.086619, 0.226921, -0.496111>, <3.239087, 0.024065, -0.432169>, <3.049510, -0.374363, -0.309658>, <3.128870, -0.623602, -0.301443>, 
      <3.191909, 0.234317, -0.541382>, <3.344377, 0.031461, -0.477440>, <3.078380, -0.358586, -0.324696>, <3.157740, -0.607825, -0.316481>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.485600, 0.406920, -0.313458>, <2.623861, 0.180755, -0.240944>, <2.633256, -0.202937, -0.148239>, <2.637153, -0.476808, -0.125780>, 
      <2.597766, 0.380166, -0.327484>, <2.736027, 0.154001, -0.254969>, <2.774859, -0.246300, -0.173931>, <2.778756, -0.520171, -0.151472>, 
      <2.749100, 0.341792, -0.340336>, <2.927803, 0.105737, -0.272936>, <2.937603, -0.320465, -0.196011>, <2.955863, -0.622978, -0.177266>, 
      <2.856776, 0.315479, -0.375083>, <3.035479, 0.079424, -0.307683>, <3.074955, -0.355032, -0.246326>, <3.093215, -0.657546, -0.227581>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.150534, 0.483930, -0.286771>, <2.249588, 0.241018, -0.210308>, <2.243329, -0.124784, -0.099228>, <2.241656, -0.396773, -0.073076>, 
      <2.252024, 0.466405, -0.296502>, <2.351079, 0.223493, -0.220039>, <2.363126, -0.141911, -0.115338>, <2.361453, -0.413900, -0.089186>, 
      <2.385708, 0.430746, -0.300967>, <2.523969, 0.204581, -0.228453>, <2.518242, -0.167716, -0.127371>, <2.522139, -0.441587, -0.104912>, 
      <2.485600, 0.406920, -0.313458>, <2.623861, 0.180755, -0.240944>, <2.633256, -0.202937, -0.148239>, <2.637153, -0.476808, -0.125780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.895567, 0.508805, -0.256883>, <1.961334, 0.254693, -0.176337>, <1.946579, -0.104121, -0.059682>, <1.940692, -0.377236, -0.032119>, 
      <1.972600, 0.504694, -0.262871>, <2.038367, 0.250582, -0.182324>, <2.037500, -0.107047, -0.067565>, <2.031614, -0.380162, -0.040002>, 
      <2.074626, 0.497038, -0.279493>, <2.173680, 0.254126, -0.203029>, <2.153729, -0.111974, -0.087178>, <2.152056, -0.383963, -0.061026>, 
      <2.150534, 0.483930, -0.286771>, <2.249588, 0.241018, -0.210308>, <2.243329, -0.124784, -0.099228>, <2.241656, -0.396773, -0.073076>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.621161, 0.512180, -0.245623>, <1.532864, 0.511207, -0.243875>, <1.415223, 0.504253, -0.245623>, <1.326920, 0.502541, -0.245623>, 
      <1.621161, 0.512180, -0.245623>, <1.508435, 0.666166, -0.295482>, <1.425326, 0.652264, -0.294616>, <1.337022, 0.650551, -0.294616>, 
      <1.621161, 0.512180, -0.245623>, <1.508435, 0.666166, -0.295482>, <1.513178, 0.694689, -0.337472>, <1.448303, 0.831322, -0.403766>, 
      <1.621161, 0.512180, -0.245623>, <1.596732, 0.667139, -0.297230>, <1.469785, 0.830990, -0.400308>, <1.404910, 0.967623, -0.466602>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.621161, 0.512180, -0.245623>, <1.532864, 0.511207, -0.243875>, <1.415223, 0.504253, -0.245623>, <1.326920, 0.502541, -0.245623>, 
      <1.661870, 0.253956, -0.159625>, <1.573573, 0.252983, -0.157877>, <1.397428, 0.243539, -0.159323>, <1.309125, 0.241827, -0.159323>, 
      <1.627248, -0.103072, -0.046638>, <1.535937, -0.104363, -0.044657>, <1.406184, -0.110560, -0.046309>, <1.314860, -0.112337, -0.046309>, 
      <1.616835, -0.376668, -0.018903>, <1.525524, -0.377959, -0.016923>, <1.403834, -0.384343, -0.018495>, <1.312510, -0.386120, -0.018495>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.621161, 0.512180, -0.245623>, <1.661870, 0.253956, -0.159625>, <1.627248, -0.103072, -0.046638>, <1.616835, -0.376668, -0.018903>, 
      <1.703537, 0.513087, -0.247254>, <1.744246, 0.254864, -0.161256>, <1.724453, -0.101697, -0.048746>, <1.714041, -0.375293, -0.021011>, 
      <1.813534, 0.513183, -0.250507>, <1.879301, 0.259070, -0.169960>, <1.849754, -0.101006, -0.051287>, <1.843867, -0.374121, -0.023724>, 
      <1.895567, 0.508805, -0.256883>, <1.961334, 0.254693, -0.176337>, <1.946579, -0.104121, -0.059682>, <1.940692, -0.377236, -0.032119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.636782, 0.711242, -1.519033>, <1.806613, 0.506181, -1.648886>, <2.093416, 0.256298, -1.798526>, <2.202885, 0.027706, -1.951876>, 
      <1.578009, 0.708774, -1.536420>, <1.747840, 0.503714, -1.666272>, <1.985462, 0.249650, -1.830835>, <2.094931, 0.021057, -1.984186>, 
      <1.495098, 0.711115, -1.539339>, <1.613992, 0.502960, -1.676828>, <1.865127, 0.242783, -1.846658>, <1.943087, 0.025574, -1.998678>, 
      <1.434410, 0.711977, -1.548219>, <1.553304, 0.503822, -1.685708>, <1.752764, 0.235337, -1.854498>, <1.830725, 0.018128, -2.006517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.585930, 0.993494, -0.466602>, <1.531702, 0.990948, -0.458713>, <1.443429, 1.003258, -0.482597>, <1.404910, 0.967623, -0.466602>, 
      <1.678821, 0.848087, -0.403686>, <1.624593, 0.845541, -0.395797>, <1.508304, 0.866625, -0.416303>, <1.469785, 0.830990, -0.400308>, 
      <1.851575, 0.678782, -0.310761>, <1.769541, 0.683160, -0.304385>, <1.679108, 0.668046, -0.298861>, <1.596732, 0.667139, -0.297230>, 
      <1.895567, 0.508805, -0.256883>, <1.813534, 0.513183, -0.250507>, <1.703537, 0.513087, -0.247254>, <1.621161, 0.512180, -0.245623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.680017, 0.980540, -0.506625>, <1.655791, 0.982492, -0.487513>, <1.616494, 0.994929, -0.471048>, <1.585930, 0.993494, -0.466602>, 
      <1.821172, 0.831557, -0.440669>, <1.796946, 0.833509, -0.421557>, <1.709385, 0.849522, -0.408133>, <1.678821, 0.848087, -0.403686>, 
      <2.072388, 0.675568, -0.347095>, <1.996480, 0.688676, -0.339816>, <1.928608, 0.674671, -0.316749>, <1.851575, 0.678782, -0.310761>, 
      <2.150534, 0.483930, -0.286771>, <2.074626, 0.497038, -0.279493>, <1.972600, 0.504694, -0.262871>, <1.895567, 0.508805, -0.256883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.746217, 0.980576, -0.593055>, <1.721516, 0.986273, -0.572460>, <1.705608, 0.978478, -0.526814>, <1.680017, 0.980540, -0.506625>, 
      <1.968032, 0.808479, -0.509176>, <1.943331, 0.814177, -0.488581>, <1.846763, 0.829495, -0.460858>, <1.821172, 0.831557, -0.440669>, 
      <2.338187, 0.648056, -0.390773>, <2.238295, 0.671882, -0.378282>, <2.173878, 0.658043, -0.356826>, <2.072388, 0.675568, -0.347095>, 
      <2.485600, 0.406920, -0.313458>, <2.385708, 0.430746, -0.300967>, <2.252024, 0.466405, -0.296502>, <2.150534, 0.483930, -0.286771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.889740, 0.932166, -0.681489>, <1.848116, 0.944049, -0.651575>, <1.786011, 0.971397, -0.626235>, <1.746217, 0.980576, -0.593055>, 
      <2.179851, 0.747160, -0.589567>, <2.138227, 0.759043, -0.559653>, <2.007826, 0.799300, -0.542355>, <1.968032, 0.808479, -0.509176>, 
      <2.647173, 0.592351, -0.454138>, <2.539497, 0.618664, -0.419391>, <2.450354, 0.621303, -0.404798>, <2.338187, 0.648056, -0.390773>, 
      <2.856776, 0.315479, -0.375083>, <2.749100, 0.341792, -0.340336>, <2.597766, 0.380166, -0.327484>, <2.485600, 0.406920, -0.313458>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.023352, 0.901460, -0.792224>, <1.987387, 0.911390, -0.754767>, <1.931563, 0.920226, -0.711546>, <1.889740, 0.932166, -0.681489>, 
      <2.373919, 0.701317, -0.716971>, <2.337954, 0.711248, -0.679514>, <2.221674, 0.735220, -0.619624>, <2.179851, 0.747160, -0.589567>, 
      <2.952671, 0.552619, -0.641714>, <2.847381, 0.545223, -0.596444>, <2.753630, 0.566336, -0.488491>, <2.647173, 0.592351, -0.454138>, 
      <3.191909, 0.234317, -0.541382>, <3.086619, 0.226921, -0.496111>, <2.963233, 0.289464, -0.409436>, <2.856776, 0.315479, -0.375083>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.085104, 0.878223, -0.884960>, <2.072366, 0.885983, -0.854247>, <2.046579, 0.895047, -0.816415>, <2.023352, 0.901460, -0.792224>, 
      <2.576570, 0.727661, -0.843771>, <2.563832, 0.735421, -0.813058>, <2.397146, 0.694904, -0.741162>, <2.373919, 0.701317, -0.716971>, 
      <3.281223, 0.636244, -0.801572>, <3.144788, 0.617248, -0.691635>, <3.114246, 0.563969, -0.711185>, <2.952671, 0.552619, -0.641714>, 
      <3.723324, 0.376350, -0.747664>, <3.586889, 0.357354, -0.637728>, <3.353484, 0.245667, -0.610853>, <3.191909, 0.234317, -0.541382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.109601, 0.848918, -1.000175>, <2.108003, 0.859747, -0.965445>, <2.098690, 0.869947, -0.917716>, <2.085104, 0.878223, -0.884960>, 
      <2.603828, 0.688143, -0.999144>, <2.602230, 0.698972, -0.964414>, <2.590156, 0.719385, -0.876527>, <2.576570, 0.727661, -0.843771>, 
      <3.302379, 0.563402, -0.970145>, <3.320883, 0.602174, -0.905329>, <3.341421, 0.644626, -0.850078>, <3.281223, 0.636244, -0.801572>, 
      <3.757024, 0.313000, -0.996738>, <3.775528, 0.351772, -0.931921>, <3.783522, 0.384732, -0.796170>, <3.723324, 0.376350, -0.747664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.095316, 0.809001, -1.106961>, <2.107650, 0.818165, -1.076107>, <2.111113, 0.838668, -1.033049>, <2.109601, 0.848918, -1.000175>, 
      <2.542617, 0.593083, -1.143148>, <2.554950, 0.602247, -1.112294>, <2.605340, 0.677892, -1.032018>, <2.603828, 0.688143, -0.999144>, 
      <3.222569, 0.413052, -1.123359>, <3.292932, 0.448634, -1.047817>, <3.276396, 0.508957, -1.061163>, <3.302379, 0.563402, -0.970145>, 
      <3.586318, 0.089274, -1.227585>, <3.656680, 0.124856, -1.152043>, <3.731041, 0.258555, -1.087756>, <3.757024, 0.313000, -0.996738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.022786, 0.784415, -1.217351>, <2.047662, 0.791829, -1.186516>, <2.080893, 0.798285, -1.143041>, <2.095316, 0.809001, -1.106961>, 
      <2.403892, 0.572615, -1.300576>, <2.428768, 0.580029, -1.269741>, <2.528194, 0.582367, -1.179228>, <2.542617, 0.593083, -1.143148>, 
      <3.040839, 0.440014, -1.443595>, <3.136343, 0.439453, -1.372532>, <3.145861, 0.374261, -1.205714>, <3.222569, 0.413052, -1.123359>, 
      <3.293140, 0.078416, -1.494768>, <3.388644, 0.077855, -1.423706>, <3.509610, 0.050483, -1.309940>, <3.586318, 0.089274, -1.227585>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.888389, 0.747333, -1.363459>, <1.933767, 0.757011, -1.324500>, <1.985394, 0.773272, -1.263701>, <2.022786, 0.784415, -1.217351>, 
      <2.218636, 0.550968, -1.455985>, <2.264014, 0.560646, -1.417026>, <2.366500, 0.561472, -1.346926>, <2.403892, 0.572615, -1.300576>, 
      <2.759352, 0.405184, -1.596028>, <2.857964, 0.407955, -1.558302>, <2.956105, 0.440512, -1.506644>, <3.040839, 0.440014, -1.443595>, 
      <2.989211, 0.092782, -1.671879>, <3.087823, 0.095553, -1.634153>, <3.208406, 0.078914, -1.557817>, <3.293140, 0.078416, -1.494768>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.744121, 0.724981, -1.456598>, <1.787982, 0.731272, -1.429478>, <1.849478, 0.739034, -1.396866>, <1.888389, 0.747333, -1.363459>, 
      <1.942037, 0.523514, -1.570115>, <1.985898, 0.529806, -1.542995>, <2.179725, 0.542669, -1.489392>, <2.218636, 0.550968, -1.455985>, 
      <2.251584, 0.279398, -1.699342>, <2.423161, 0.293598, -1.638246>, <2.588788, 0.400391, -1.661281>, <2.759352, 0.405184, -1.596028>, 
      <2.403842, 0.053426, -1.834988>, <2.575419, 0.067626, -1.773893>, <2.818647, 0.087989, -1.737132>, <2.989211, 0.092782, -1.671879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.744121, 0.724981, -1.456598>, <1.942037, 0.523514, -1.570115>, <2.251584, 0.279398, -1.699342>, <2.403842, 0.053426, -1.834988>, 
      <1.712477, 0.720442, -1.476164>, <1.910393, 0.518976, -1.589681>, <2.185680, 0.273944, -1.722809>, <2.337939, 0.047972, -1.858455>, 
      <1.672694, 0.712750, -1.508409>, <1.842524, 0.507689, -1.638262>, <2.160522, 0.260431, -1.778441>, <2.269991, 0.031839, -1.931792>, 
      <1.636782, 0.711242, -1.519033>, <1.806613, 0.506181, -1.648886>, <2.093416, 0.256298, -1.798526>, <2.202885, 0.027706, -1.951876>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.858074, -3.449284, -1.988314>, <0.881605, -3.335888, -1.988314>, <0.929264, -3.185949, -2.002972>, <0.936512, -3.071298, -1.988314>, 
      <1.041433, -3.449557, -2.000171>, <1.064965, -3.336161, -2.000171>, <1.082078, -3.186222, -2.014818>, <1.089326, -3.071571, -2.000160>, 
      <1.286816, -3.451070, -1.987992>, <1.279877, -3.337675, -1.987992>, <1.306971, -3.185049, -2.002303>, <1.294159, -3.073076, -1.987992>, 
      <1.470548, -3.449173, -1.987992>, <1.463610, -3.335777, -1.987992>, <1.460232, -3.183159, -2.002303>, <1.447420, -3.071187, -1.987992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.527627, -3.447768, -1.927017>, <0.567598, -3.334372, -1.927017>, <0.642106, -3.187691, -1.941224>, <0.660863, -3.069782, -1.927017>, 
      <0.624570, -3.447681, -1.954729>, <0.664541, -3.334285, -1.954729>, <0.722247, -3.187605, -1.968686>, <0.741004, -3.069695, -1.954480>, 
      <0.757458, -3.449134, -1.981808>, <0.780989, -3.335738, -1.981808>, <0.844802, -3.185798, -1.996424>, <0.852050, -3.071147, -1.981766>, 
      <0.858074, -3.449284, -1.988314>, <0.881605, -3.335888, -1.988314>, <0.929264, -3.185949, -2.002972>, <0.936512, -3.071298, -1.988314>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.184411, -3.449891, -1.795745>, <0.241456, -3.336495, -1.795745>, <0.342947, -3.194173, -1.808541>, <0.374562, -3.071905, -1.795745>, 
      <0.285709, -3.449755, -1.839239>, <0.342754, -3.336359, -1.839239>, <0.426961, -3.194038, -1.851785>, <0.458576, -3.071769, -1.838989>, 
      <0.421632, -3.447864, -1.896718>, <0.461603, -3.334468, -1.896718>, <0.552718, -3.187788, -1.910592>, <0.571475, -3.069879, -1.896386>, 
      <0.527627, -3.447768, -1.927017>, <0.567598, -3.334372, -1.927017>, <0.642106, -3.187691, -1.941224>, <0.660863, -3.069782, -1.927017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.208521, -3.448759, -1.610937>, <-0.346455, -3.434195, -1.443443>, <-0.498164, -3.403380, -1.170399>, <-0.508125, -3.376769, -0.954796>, 
      <-0.131928, -3.335363, -1.610937>, <-0.269862, -3.320799, -1.443443>, <-0.406666, -3.285915, -1.175738>, <-0.416627, -3.259304, -0.960135>, 
      <-0.000843, -3.198621, -1.621474>, <-0.119461, -3.180821, -1.452458>, <-0.256216, -3.146485, -1.175244>, <-0.264137, -3.121116, -0.969703>, 
      <0.046790, -3.070772, -1.610937>, <-0.071827, -3.052972, -1.441920>, <-0.195210, -3.010586, -1.178135>, <-0.203131, -2.985217, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.208521, -3.448759, -1.610937>, <-0.131928, -3.335363, -1.610937>, <-0.000843, -3.198621, -1.621474>, <0.046790, -3.070772, -1.610937>, 
      <-0.125896, -3.457483, -1.711269>, <-0.049302, -3.344087, -1.711269>, <0.063765, -3.208316, -1.713534>, <0.111398, -3.080467, -1.702996>, 
      <0.064711, -3.450052, -1.744349>, <0.121757, -3.336656, -1.744349>, <0.242577, -3.194335, -1.756878>, <0.274193, -3.072067, -1.744082>, 
      <0.184411, -3.449891, -1.795745>, <0.241456, -3.336495, -1.795745>, <0.342947, -3.194173, -1.808541>, <0.374562, -3.071905, -1.795745>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.269970, -3.284591, -0.280856>, <-0.190320, -3.171195, -0.280856>, <-0.055604, -3.034997, -0.270679>, <-0.004469, -2.906605, -0.280856>, 
      <-0.411659, -3.316372, -0.441047>, <-0.332009, -3.202977, -0.441047>, <-0.181357, -3.065802, -0.445065>, <-0.130222, -2.937410, -0.455242>, 
      <-0.518028, -3.350312, -0.740439>, <-0.426530, -3.232846, -0.745779>, <-0.272438, -3.094530, -0.754302>, <-0.211432, -2.958631, -0.757193>, 
      <-0.508125, -3.376769, -0.954796>, <-0.416627, -3.259304, -0.960135>, <-0.264137, -3.121116, -0.969703>, <-0.203131, -2.985217, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.171451, -3.224337, -0.186482>, <0.229141, -3.110941, -0.186482>, <0.330755, -2.968713, -0.175282>, <0.363751, -2.846350, -0.186482>, 
      <0.038619, -3.245947, -0.210010>, <0.096309, -3.132551, -0.210010>, <0.219814, -2.990350, -0.198839>, <0.252810, -2.867987, -0.210039>, 
      <-0.180439, -3.264509, -0.179634>, <-0.100789, -3.151113, -0.179634>, <0.011247, -3.018621, -0.177976>, <0.062381, -2.890229, -0.188153>, 
      <-0.269970, -3.284591, -0.280856>, <-0.190320, -3.171195, -0.280856>, <-0.055604, -3.034997, -0.270679>, <-0.004469, -2.906605, -0.280856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.538667, -3.153037, -0.137623>, <0.578089, -3.039641, -0.137623>, <0.651008, -2.893010, -0.126011>, <0.670072, -2.775051, -0.137623>, 
      <0.427489, -3.168037, -0.152558>, <0.466910, -3.054642, -0.152558>, <0.557918, -2.908067, -0.141002>, <0.576982, -2.790108, -0.152614>, 
      <0.281489, -3.206435, -0.166991>, <0.339179, -3.093039, -0.166991>, <0.422503, -2.950819, -0.155800>, <0.455498, -2.828457, -0.167000>, 
      <0.171451, -3.224337, -0.186482>, <0.229141, -3.110941, -0.186482>, <0.330755, -2.968713, -0.175282>, <0.363751, -2.846350, -0.186482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.817808, -3.137129, -0.099655>, <0.843342, -3.023733, -0.099655>, <0.893953, -2.874417, -0.087737>, <0.902923, -2.759143, -0.099655>, 
      <0.733501, -3.139176, -0.106963>, <0.759035, -3.025780, -0.106963>, <0.823424, -2.876470, -0.095066>, <0.832394, -2.761195, -0.106984>, 
      <0.621821, -3.141818, -0.126453>, <0.661243, -3.028422, -0.126453>, <0.720168, -2.881824, -0.114873>, <0.739232, -2.763865, -0.126486>, 
      <0.538667, -3.153037, -0.137623>, <0.578089, -3.039641, -0.137623>, <0.651008, -2.893010, -0.126011>, <0.670072, -2.775051, -0.137623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.118031, -3.138973, -0.087403>, <1.181814, -3.139022, -0.085832>, <1.266900, -3.137958, -0.087138>, <1.330701, -3.137523, -0.087025>, 
      <1.128630, -3.025577, -0.087403>, <1.192413, -3.025626, -0.085832>, <1.266919, -3.024562, -0.087138>, <1.330720, -3.024127, -0.087025>, 
      <1.154794, -2.874247, -0.075522>, <1.207994, -2.874295, -0.073952>, <1.286201, -2.873779, -0.075222>, <1.339393, -2.871986, -0.075222>, 
      <1.153361, -2.760987, -0.087403>, <1.206561, -2.761036, -0.085833>, <1.277571, -2.761329, -0.087025>, <1.330764, -2.759537, -0.087025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.118031, -3.138973, -0.087403>, <1.128630, -3.025577, -0.087403>, <1.154794, -2.874247, -0.075522>, <1.153361, -2.760987, -0.087403>, 
      <1.027915, -3.138904, -0.089622>, <1.038514, -3.025508, -0.089622>, <1.079603, -2.874177, -0.077742>, <1.078170, -2.760918, -0.089623>, 
      <0.907589, -3.134950, -0.091873>, <0.933123, -3.021554, -0.091873>, <0.968742, -2.872241, -0.079965>, <0.977712, -2.756967, -0.091883>, 
      <0.817808, -3.137129, -0.099655>, <0.843342, -3.023733, -0.099655>, <0.893953, -2.874417, -0.087737>, <0.902923, -2.759143, -0.099655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.913360, -2.574703, -1.876504>, <1.050086, -2.574947, -1.887103>, <1.233353, -2.576154, -1.876217>, <1.370480, -2.574604, -1.876217>, 
      <0.914211, -2.727302, -1.885490>, <1.050936, -2.727546, -1.896089>, <1.236208, -2.730298, -1.885291>, <1.373336, -2.728748, -1.885291>, 
      <0.946079, -2.919963, -1.968967>, <1.098892, -2.920236, -1.980813>, <1.276743, -2.920863, -1.968538>, <1.430004, -2.918973, -1.968538>, 
      <0.936512, -3.071298, -1.988314>, <1.089326, -3.071571, -2.000160>, <1.294159, -3.073076, -1.987992>, <1.447420, -3.071187, -1.987992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.666730, -2.573347, -1.821661>, <0.738434, -2.573270, -1.846232>, <0.837790, -2.574568, -1.870646>, <0.913360, -2.574703, -1.876504>, 
      <0.666515, -2.725371, -1.830097>, <0.738219, -2.725293, -1.854668>, <0.838640, -2.727167, -1.879631>, <0.914211, -2.727302, -1.885490>, 
      <0.684616, -2.920469, -1.909027>, <0.764757, -2.920382, -1.936489>, <0.861616, -2.919812, -1.962419>, <0.946079, -2.919963, -1.968967>, 
      <0.660863, -3.069782, -1.927017>, <0.741004, -3.069695, -1.954480>, <0.852050, -3.071147, -1.981766>, <0.936512, -3.071298, -1.988314>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.410571, -2.575247, -1.704210>, <0.485740, -2.575126, -1.742902>, <0.586753, -2.573434, -1.794255>, <0.666730, -2.573347, -1.821661>, 
      <0.409256, -2.726957, -1.711523>, <0.484425, -2.726835, -1.750215>, <0.586538, -2.725457, -1.802691>, <0.666515, -2.725371, -1.830097>, 
      <0.412393, -2.925599, -1.780434>, <0.496407, -2.925464, -1.823678>, <0.595228, -2.920565, -1.878395>, <0.684616, -2.920469, -1.909027>, 
      <0.374562, -3.071905, -1.795745>, <0.458576, -3.071769, -1.838989>, <0.571475, -3.069879, -1.896386>, <0.660863, -3.069782, -1.927017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.117306, -2.574234, -1.538857>, <0.114728, -2.726105, -1.544622>, <0.099701, -2.928758, -1.599232>, <0.046790, -3.070772, -1.610937>, 
      <0.006530, -2.567101, -1.389653>, <0.003951, -2.718972, -1.395418>, <-0.018916, -2.910958, -1.430215>, <-0.071827, -3.052972, -1.441920>, 
      <-0.125507, -2.563035, -1.157027>, <-0.127834, -2.697312, -1.141866>, <-0.139872, -2.887313, -1.180758>, <-0.195210, -3.010586, -1.178135>, 
      <-0.132615, -2.540271, -0.972594>, <-0.134941, -2.674548, -0.957434>, <-0.147793, -2.861944, -0.975217>, <-0.203131, -2.985217, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.117306, -2.574234, -1.538857>, <0.177470, -2.578108, -1.619891>, <0.320768, -2.575392, -1.657986>, <0.410571, -2.575247, -1.704210>, 
      <0.114728, -2.726105, -1.544622>, <0.174891, -2.729979, -1.625657>, <0.319453, -2.727102, -1.665299>, <0.409256, -2.726957, -1.711523>, 
      <0.099701, -2.928758, -1.599232>, <0.164309, -2.938453, -1.691291>, <0.312024, -2.925761, -1.728771>, <0.412393, -2.925599, -1.780434>, 
      <0.046790, -3.070772, -1.610937>, <0.111398, -3.080467, -1.702996>, <0.274193, -3.072067, -1.744082>, <0.374562, -3.071905, -1.795745>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.071444, -2.427349, -0.348805>, <-0.046694, -2.464292, -0.505630>, <-0.140251, -2.515815, -0.774455>, <-0.132615, -2.540271, -0.972594>, 
      <0.068735, -2.574218, -0.343501>, <-0.049403, -2.611161, -0.500326>, <-0.142577, -2.650092, -0.759295>, <-0.134941, -2.674548, -0.957434>, 
      <0.049771, -2.770416, -0.291651>, <-0.075982, -2.801221, -0.466037>, <-0.156094, -2.835358, -0.759816>, <-0.147793, -2.861944, -0.975217>, 
      <-0.004469, -2.906605, -0.280856>, <-0.130222, -2.937410, -0.455242>, <-0.211432, -2.958631, -0.757193>, <-0.203131, -2.985217, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.400898, -2.373438, -0.264367>, <0.301637, -2.392797, -0.285444>, <0.132529, -2.408247, -0.267715>, <0.071444, -2.427349, -0.348805>, 
      <0.399593, -2.517524, -0.258382>, <0.300332, -2.536882, -0.279460>, <0.129820, -2.555116, -0.262411>, <0.068735, -2.574218, -0.343501>, 
      <0.401152, -2.707648, -0.199178>, <0.290211, -2.729285, -0.222735>, <0.116622, -2.754040, -0.198948>, <0.049771, -2.770416, -0.291651>, 
      <0.363751, -2.846350, -0.186482>, <0.252810, -2.867987, -0.210039>, <0.062381, -2.890229, -0.188153>, <-0.004469, -2.906605, -0.280856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.674970, -2.309645, -0.220651>, <0.591680, -2.323117, -0.234064>, <0.482986, -2.357428, -0.246936>, <0.400898, -2.373438, -0.264367>, 
      <0.674800, -2.451339, -0.214352>, <0.591510, -2.464810, -0.227765>, <0.481681, -2.501514, -0.240952>, <0.399593, -2.517524, -0.258382>, 
      <0.692595, -2.635690, -0.151342>, <0.599504, -2.650747, -0.166334>, <0.492900, -2.689755, -0.179696>, <0.401152, -2.707648, -0.199178>, 
      <0.670072, -2.775051, -0.137623>, <0.576982, -2.790108, -0.152614>, <0.455498, -2.828457, -0.167000>, <0.363751, -2.846350, -0.186482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.883307, -2.295412, -0.186680>, <0.820203, -2.297248, -0.193237>, <0.736849, -2.299637, -0.210686>, <0.674970, -2.309645, -0.220651>, 
      <0.883987, -2.436927, -0.180080>, <0.820883, -2.438763, -0.186637>, <0.736679, -2.441330, -0.204387>, <0.674800, -2.451339, -0.214352>, 
      <0.913856, -2.618644, -0.114181>, <0.843327, -2.620697, -0.121510>, <0.761755, -2.624504, -0.140205>, <0.692595, -2.635690, -0.151342>, 
      <0.902923, -2.759143, -0.099655>, <0.832394, -2.761195, -0.106984>, <0.739232, -2.763865, -0.126486>, <0.670072, -2.775051, -0.137623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.107379, -2.297062, -0.175718>, <1.108981, -2.439241, -0.168989>, <1.151570, -2.619428, -0.102252>, <1.153361, -2.760987, -0.087403>, 
      <1.154978, -2.297106, -0.174313>, <1.156580, -2.439285, -0.167584>, <1.204770, -2.619477, -0.100682>, <1.206561, -2.761036, -0.085833>, 
      <1.218502, -2.296973, -0.175380>, <1.220763, -2.439751, -0.168619>, <1.266693, -2.619566, -0.101905>, <1.277571, -2.761329, -0.087025>, 
      <1.266106, -2.295764, -0.175380>, <1.268368, -2.438543, -0.168619>, <1.319885, -2.617774, -0.101905>, <1.330764, -2.759537, -0.087025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.107379, -2.297062, -0.175718>, <1.040105, -2.297000, -0.177704>, <0.950222, -2.293465, -0.179727>, <0.883307, -2.295412, -0.186680>, 
      <1.108981, -2.439241, -0.168989>, <1.041706, -2.439179, -0.170975>, <0.950902, -2.434979, -0.173126>, <0.883987, -2.436927, -0.180080>, 
      <1.151570, -2.619428, -0.102252>, <1.076379, -2.619359, -0.104472>, <0.988645, -2.616468, -0.106410>, <0.913856, -2.618644, -0.114181>, 
      <1.153361, -2.760987, -0.087403>, <1.078170, -2.760918, -0.089623>, <0.977712, -2.756967, -0.091883>, <0.902923, -2.759143, -0.099655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.930236, -1.945316, -1.922011>, <1.078718, -1.945572, -1.933120>, <1.277674, -1.946984, -1.921710>, <1.426561, -1.945212, -1.921710>, 
      <0.941562, -2.133544, -1.904536>, <1.090044, -2.133800, -1.915645>, <1.264680, -2.135784, -1.904188>, <1.413567, -2.134012, -1.904188>, 
      <0.912306, -2.385657, -1.865372>, <1.049032, -2.385901, -1.875971>, <1.229839, -2.386459, -1.865050>, <1.366966, -2.384909, -1.865050>, 
      <0.913360, -2.574703, -1.876504>, <1.050086, -2.574947, -1.887103>, <1.233353, -2.576154, -1.876217>, <1.370480, -2.574604, -1.876217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.662454, -1.943895, -1.864542>, <0.740463, -1.943814, -1.890342>, <0.848300, -1.945175, -1.915881>, <0.930236, -1.945316, -1.922011>, 
      <0.686717, -2.130897, -1.848185>, <0.764727, -2.130816, -1.873985>, <0.859626, -2.133403, -1.898406>, <0.941562, -2.133544, -1.904536>, 
      <0.666997, -2.384360, -1.811174>, <0.738701, -2.384283, -1.835745>, <0.836736, -2.385522, -1.859514>, <0.912306, -2.385657, -1.865372>, 
      <0.666730, -2.573347, -1.821661>, <0.738434, -2.573270, -1.846232>, <0.837790, -2.574568, -1.870646>, <0.913360, -2.574703, -1.876504>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.384324, -1.945886, -1.741465>, <0.466042, -1.945759, -1.782060>, <0.575824, -1.943985, -1.835891>, <0.662454, -1.943895, -1.864542>, 
      <0.421714, -2.130926, -1.727400>, <0.503431, -2.130798, -1.767995>, <0.600087, -2.130988, -1.819535>, <0.686717, -2.130897, -1.848185>, 
      <0.412210, -2.386171, -1.695096>, <0.487379, -2.386050, -1.733787>, <0.587020, -2.384447, -1.783768>, <0.666997, -2.384360, -1.811174>, 
      <0.410571, -2.575247, -1.704210>, <0.485740, -2.575126, -1.742902>, <0.586753, -2.573434, -1.794255>, <0.666730, -2.573347, -1.821661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.065907, -1.944824, -1.568194>, <0.117769, -2.126925, -1.557296>, <0.120523, -2.384742, -1.531664>, <0.117306, -2.574234, -1.538857>, 
      <-0.040355, -1.932833, -1.447732>, <0.011507, -2.114934, -1.436834>, <0.009747, -2.377609, -1.382459>, <0.006530, -2.567101, -1.389653>, 
      <-0.177635, -1.901468, -1.256919>, <-0.112818, -2.092418, -1.256919>, <-0.122036, -2.362687, -1.179647>, <-0.125507, -2.563035, -1.157027>, 
      <-0.184014, -1.881752, -1.097178>, <-0.119197, -2.072701, -1.097178>, <-0.129144, -2.339923, -0.995214>, <-0.132615, -2.540271, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.065907, -1.944824, -1.568194>, <0.137650, -1.952920, -1.649524>, <0.286927, -1.946038, -1.693081>, <0.384324, -1.945886, -1.741465>, 
      <0.117769, -2.126925, -1.557296>, <0.189512, -2.135021, -1.638626>, <0.324317, -2.131077, -1.679016>, <0.421714, -2.130926, -1.727400>, 
      <0.120523, -2.384742, -1.531664>, <0.180687, -2.388616, -1.612698>, <0.322407, -2.386316, -1.648872>, <0.412210, -2.386171, -1.695096>, 
      <0.117306, -2.574234, -1.538857>, <0.177470, -2.578108, -1.619891>, <0.320768, -2.575392, -1.657986>, <0.410571, -2.575247, -1.704210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016111, -1.790905, -0.321149>, <-0.113754, -1.825206, -0.522409>, <-0.193596, -1.852135, -0.857223>, <-0.184014, -1.881752, -1.097178>, 
      <0.070063, -1.974711, -0.331372>, <-0.059803, -2.009012, -0.532632>, <-0.128779, -2.043085, -0.857224>, <-0.119197, -2.072701, -1.097178>, 
      <0.074980, -2.235674, -0.355727>, <-0.043158, -2.272616, -0.512552>, <-0.136780, -2.315468, -0.797075>, <-0.129144, -2.339923, -0.995214>, 
      <0.071444, -2.427349, -0.348805>, <-0.046694, -2.464292, -0.505630>, <-0.140251, -2.515815, -0.774455>, <-0.132615, -2.540271, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.373822, -1.734412, -0.232667>, <0.266076, -1.754692, -0.254748>, <0.076136, -1.775051, -0.228124>, <0.016111, -1.790905, -0.321149>, 
      <0.411577, -1.922403, -0.244590>, <0.303831, -1.942684, -0.266671>, <0.130088, -1.958857, -0.238347>, <0.070063, -1.974711, -0.331372>, 
      <0.402637, -2.181496, -0.272339>, <0.303375, -2.200855, -0.293417>, <0.136065, -2.216572, -0.274638>, <0.074980, -2.235674, -0.355727>, 
      <0.400898, -2.373438, -0.264367>, <0.301637, -2.392797, -0.285444>, <0.132529, -2.408247, -0.267715>, <0.071444, -2.427349, -0.348805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.671400, -1.667564, -0.186858>, <0.581042, -1.681669, -0.200901>, <0.462960, -1.717634, -0.214400>, <0.373822, -1.734412, -0.232667>, 
      <0.695127, -1.858562, -0.199693>, <0.604769, -1.872667, -0.213737>, <0.500715, -1.905625, -0.226323>, <0.411577, -1.922403, -0.244590>, 
      <0.675201, -2.116941, -0.229218>, <0.591911, -2.130413, -0.242631>, <0.484725, -2.165486, -0.254909>, <0.402637, -2.181496, -0.272339>, 
      <0.674970, -2.309645, -0.220651>, <0.591680, -2.323117, -0.234064>, <0.482986, -2.357428, -0.246936>, <0.400898, -2.373438, -0.264367>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.897605, -1.652649, -0.151261>, <0.829133, -1.654572, -0.158128>, <0.738630, -1.657069, -0.176409>, <0.671400, -1.667564, -0.186858>, 
      <0.910454, -1.844915, -0.164785>, <0.841982, -1.846838, -0.171652>, <0.762357, -1.848068, -0.189244>, <0.695127, -1.858562, -0.199693>, 
      <0.882380, -2.102455, -0.195679>, <0.819276, -2.104291, -0.202237>, <0.737080, -2.106933, -0.219253>, <0.675201, -2.116941, -0.229218>, 
      <0.883307, -2.295412, -0.186680>, <0.820203, -2.297248, -0.193237>, <0.736849, -2.299637, -0.210686>, <0.674970, -2.309645, -0.220651>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.140895, -1.654378, -0.139774>, <1.141913, -1.847252, -0.153544>, <1.105203, -2.103922, -0.184859>, <1.107379, -2.297062, -0.175718>, 
      <1.192578, -1.654424, -0.138301>, <1.193596, -1.847298, -0.152072>, <1.152802, -2.103966, -0.183453>, <1.154978, -2.297106, -0.174313>, 
      <1.261533, -1.653426, -0.139526>, <1.254136, -1.846435, -0.153310>, <1.215438, -2.103571, -0.184538>, <1.218502, -2.296973, -0.175380>, 
      <1.313235, -1.653018, -0.139419>, <1.305838, -1.846027, -0.153203>, <1.263042, -2.102363, -0.184538>, <1.266106, -2.295764, -0.175380>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.140895, -1.654378, -0.139774>, <1.067854, -1.654313, -0.141855>, <0.970282, -1.650608, -0.143973>, <0.897605, -1.652649, -0.151261>, 
      <1.141913, -1.847252, -0.153544>, <1.068873, -1.847188, -0.155625>, <0.983131, -1.842874, -0.157497>, <0.910454, -1.844915, -0.164785>, 
      <1.105203, -2.103922, -0.184859>, <1.037929, -2.103861, -0.186844>, <0.949295, -2.100508, -0.188726>, <0.882380, -2.102455, -0.195679>, 
      <1.107379, -2.297062, -0.175718>, <1.040105, -2.297000, -0.177704>, <0.950222, -2.293465, -0.179727>, <0.883307, -2.295412, -0.186680>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.840893, -1.370359, -1.988314>, <1.024252, -1.370632, -2.000171>, <1.269633, -1.372010, -1.987992>, <1.453367, -1.370248, -1.987992>, 
      <0.859944, -1.533425, -1.925766>, <1.043303, -1.533698, -1.937623>, <1.261591, -1.544499, -1.968107>, <1.445325, -1.542737, -1.968107>, 
      <0.919729, -1.770694, -1.938223>, <1.068211, -1.770950, -1.949332>, <1.289558, -1.774315, -1.937735>, <1.438445, -1.772543, -1.937735>, 
      <0.930236, -1.945316, -1.922011>, <1.078718, -1.945572, -1.933120>, <1.277674, -1.946984, -1.921710>, <1.426561, -1.945212, -1.921710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.510446, -1.368843, -1.927017>, <0.607389, -1.368756, -1.954729>, <0.740277, -1.370209, -1.981808>, <0.840893, -1.370359, -1.988314>, 
      <0.540522, -1.534345, -1.864592>, <0.637465, -1.534258, -1.892304>, <0.759328, -1.533275, -1.919259>, <0.859944, -1.533425, -1.925766>, 
      <0.639454, -1.766629, -1.880047>, <0.717463, -1.766548, -1.905847>, <0.837793, -1.770553, -1.932092>, <0.919729, -1.770694, -1.938223>, 
      <0.662454, -1.943895, -1.864542>, <0.740463, -1.943814, -1.890342>, <0.848300, -1.945175, -1.915881>, <0.930236, -1.945316, -1.922011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.167230, -1.370966, -1.795745>, <0.268528, -1.370830, -1.839239>, <0.404451, -1.368938, -1.896718>, <0.510446, -1.368843, -1.927017>, 
      <0.209432, -1.540318, -1.734152>, <0.310730, -1.540181, -1.777646>, <0.434527, -1.534441, -1.834293>, <0.540522, -1.534345, -1.864592>, 
      <0.347768, -1.764973, -1.755216>, <0.429486, -1.764846, -1.795811>, <0.552823, -1.766720, -1.851396>, <0.639454, -1.766629, -1.880047>, 
      <0.384324, -1.945886, -1.741465>, <0.466042, -1.945759, -1.782060>, <0.575824, -1.943985, -1.835891>, <0.662454, -1.943895, -1.864542>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225702, -1.369834, -1.610937>, <-0.141844, -1.368327, -1.710612>, <0.047530, -1.371127, -1.744349>, <0.167230, -1.370966, -1.795745>, 
      <-0.142821, -1.542075, -1.578742>, <-0.058963, -1.540568, -1.678417>, <0.089732, -1.540479, -1.682756>, <0.209432, -1.540318, -1.734152>, 
      <0.012902, -1.758708, -1.579333>, <0.084645, -1.766804, -1.660663>, <0.250371, -1.765125, -1.706832>, <0.347768, -1.764973, -1.755216>, 
      <0.065907, -1.944824, -1.568194>, <0.137650, -1.952920, -1.649524>, <0.286927, -1.946038, -1.693081>, <0.384324, -1.945886, -1.741465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225702, -1.369834, -1.610937>, <-0.142821, -1.542075, -1.578742>, <0.012902, -1.758708, -1.579333>, <0.065907, -1.944824, -1.568194>, 
      <-0.361909, -1.372282, -1.449041>, <-0.279028, -1.544524, -1.416846>, <-0.093360, -1.746717, -1.458870>, <-0.040355, -1.932833, -1.447732>, 
      <-0.515615, -1.409305, -1.182365>, <-0.448261, -1.580162, -1.204773>, <-0.237106, -1.726271, -1.256919>, <-0.177635, -1.901468, -1.256919>, 
      <-0.525306, -1.383413, -0.972593>, <-0.457952, -1.554270, -0.995001>, <-0.243484, -1.706554, -1.097178>, <-0.184014, -1.881752, -1.097178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.287151, -1.205666, -0.280856>, <-0.431132, -1.256091, -0.447409>, <-0.535651, -1.355775, -0.748669>, <-0.525306, -1.383413, -0.972593>, 
      <-0.215194, -1.389623, -0.296034>, <-0.359175, -1.440049, -0.462587>, <-0.468297, -1.526632, -0.771076>, <-0.457952, -1.554270, -0.995001>, 
      <-0.039607, -1.601082, -0.310591>, <-0.169472, -1.635383, -0.511851>, <-0.253066, -1.676938, -0.857223>, <-0.243484, -1.706554, -1.097178>, 
      <0.016111, -1.790905, -0.321149>, <-0.113754, -1.825206, -0.522409>, <-0.193596, -1.852135, -0.857223>, <-0.184014, -1.881752, -1.097178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.154270, -1.145412, -0.186482>, <0.021438, -1.167022, -0.210010>, <-0.200059, -1.175164, -0.180111>, <-0.287151, -1.205666, -0.280856>, 
      <0.204076, -1.327161, -0.201966>, <0.071244, -1.348771, -0.225494>, <-0.128101, -1.359122, -0.195289>, <-0.215194, -1.389623, -0.296034>, 
      <0.336663, -1.549386, -0.220932>, <0.228917, -1.569666, -0.243013>, <0.020418, -1.585228, -0.217567>, <-0.039607, -1.601082, -0.310591>, 
      <0.373822, -1.734412, -0.232667>, <0.266076, -1.754692, -0.254748>, <0.076136, -1.775051, -0.228124>, <0.016111, -1.790905, -0.321149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.521486, -1.074112, -0.137623>, <0.410308, -1.089112, -0.152558>, <0.264308, -1.127510, -0.166991>, <0.154270, -1.145412, -0.186482>, 
      <0.556425, -1.254262, -0.153831>, <0.445247, -1.269263, -0.168765>, <0.314114, -1.309260, -0.182475>, <0.204076, -1.327161, -0.201966>, 
      <0.648740, -1.485153, -0.174600>, <0.558382, -1.499258, -0.188643>, <0.425801, -1.532608, -0.202665>, <0.336663, -1.549386, -0.220932>, 
      <0.671400, -1.667564, -0.186858>, <0.581042, -1.681669, -0.200901>, <0.462960, -1.717634, -0.214400>, <0.373822, -1.734412, -0.232667>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.800626, -1.058204, -0.099655>, <0.716319, -1.060251, -0.106963>, <0.604640, -1.062893, -0.126453>, <0.521486, -1.074112, -0.137623>, 
      <0.824692, -1.237164, -0.116484>, <0.740385, -1.239210, -0.123792>, <0.639579, -1.243043, -0.142660>, <0.556425, -1.254262, -0.153831>, 
      <0.885542, -1.472144, -0.138564>, <0.817070, -1.474067, -0.145431>, <0.715970, -1.474658, -0.164151>, <0.648740, -1.485153, -0.174600>, 
      <0.897605, -1.652649, -0.151261>, <0.829133, -1.654572, -0.158128>, <0.738630, -1.657069, -0.176409>, <0.671400, -1.667564, -0.186858>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.100849, -1.060048, -0.087403>, <1.113480, -1.238186, -0.104401>, <1.139950, -1.475443, -0.126999>, <1.140895, -1.654378, -0.139774>, 
      <1.164633, -1.060097, -0.085832>, <1.177264, -1.238235, -0.102831>, <1.191633, -1.475489, -0.125527>, <1.192578, -1.654424, -0.138301>, 
      <1.249737, -1.060179, -0.087025>, <1.249839, -1.238386, -0.104035>, <1.268371, -1.474994, -0.126782>, <1.261533, -1.653426, -0.139526>, 
      <1.313520, -1.058598, -0.087025>, <1.313622, -1.236805, -0.104035>, <1.320073, -1.474586, -0.126676>, <1.313235, -1.653018, -0.139419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.100849, -1.060048, -0.087403>, <1.010733, -1.059979, -0.089622>, <0.890406, -1.056025, -0.091873>, <0.800626, -1.058204, -0.099655>, 
      <1.113480, -1.238186, -0.104401>, <1.023364, -1.238117, -0.106620>, <0.914473, -1.234984, -0.108702>, <0.824692, -1.237164, -0.116484>, 
      <1.139950, -1.475443, -0.126999>, <1.066910, -1.475378, -0.129080>, <0.958219, -1.470102, -0.131276>, <0.885542, -1.472144, -0.138564>, 
      <1.140895, -1.654378, -0.139774>, <1.067854, -1.654313, -0.141855>, <0.970282, -1.650608, -0.143973>, <0.897605, -1.652649, -0.151261>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.242090, 0.699494, -1.548219>, <1.300632, 0.701514, -1.552516>, <1.378755, 0.709701, -1.548219>, <1.437326, 0.714075, -1.548219>, 
      <1.121556, 0.492284, -1.685708>, <1.180098, 0.494304, -1.690006>, <1.373469, 0.488220, -1.685708>, <1.432039, 0.492595, -1.685708>, 
      <0.920131, 0.225345, -1.854523>, <1.093747, 0.217042, -1.864493>, <1.251173, 0.207183, -1.869027>, <1.424991, 0.197287, -1.869027>, 
      <0.840311, 0.008794, -2.006517>, <1.013926, 0.000491, -2.016487>, <1.245886, -0.014297, -2.006517>, <1.419704, -0.024193, -2.006517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.222488, -5.827935, -1.222240>, <-1.218863, -5.704408, -1.217078>, <-1.236628, -5.521707, -1.146087>, <-1.210405, -5.416178, -1.205034>, 
      <-1.192283, -5.829170, -1.195104>, <-1.188658, -5.705643, -1.189942>, <-1.210671, -5.527301, -1.121194>, <-1.184449, -5.421772, -1.180141>, 
      <-1.154485, -5.833829, -1.154659>, <-1.154485, -5.720830, -1.154659>, <-1.216600, -5.557899, -1.131897>, <-1.154367, -5.465082, -1.148651>, 
      <-1.135026, -5.833281, -1.119004>, <-1.135026, -5.720282, -1.119004>, <-1.197259, -5.549436, -1.102250>, <-1.135026, -5.456619, -1.119004>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.316902, -5.825847, -1.282402>, <-1.321544, -5.702320, -1.290163>, <-1.307680, -5.533080, -1.284351>, <-1.332376, -5.414090, -1.308271>, 
      <-1.285079, -5.834890, -1.288230>, <-1.289722, -5.711362, -1.295991>, <-1.263418, -5.541938, -1.300504>, <-1.288114, -5.422948, -1.324424>, 
      <-1.247465, -5.826914, -1.244679>, <-1.243840, -5.703387, -1.239518>, <-1.270818, -5.514339, -1.178877>, <-1.244596, -5.408810, -1.237825>, 
      <-1.222488, -5.827935, -1.222240>, <-1.218863, -5.704408, -1.217078>, <-1.236628, -5.521707, -1.146087>, <-1.210405, -5.416178, -1.205034>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.508790, -5.746583, -1.169808>, <-1.490666, -5.633174, -1.154323>, <-1.415099, -5.479442, -1.113055>, <-1.448375, -5.368554, -1.118190>, 
      <-1.465912, -5.763552, -1.223602>, <-1.447787, -5.650143, -1.208117>, <-1.377933, -5.500195, -1.166323>, <-1.411210, -5.389307, -1.171458>, 
      <-1.384025, -5.806775, -1.270110>, <-1.388667, -5.683248, -1.277870>, <-1.370632, -5.520482, -1.261378>, <-1.395328, -5.401492, -1.285298>, 
      <-1.316902, -5.825847, -1.282402>, <-1.321544, -5.702320, -1.290163>, <-1.307680, -5.533080, -1.284351>, <-1.332376, -5.414090, -1.308271>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.585806, -5.719430, -0.945040>, <-1.585806, -5.585374, -0.945040>, <-1.524727, -5.391766, -0.950899>, <-1.585806, -5.272578, -0.945040>, 
      <-1.589814, -5.731504, -1.015646>, <-1.589814, -5.597449, -1.015646>, <-1.519617, -5.410393, -1.020570>, <-1.580695, -5.291204, -1.014711>, 
      <-1.552206, -5.729402, -1.115339>, <-1.534082, -5.615993, -1.099854>, <-1.454506, -5.457438, -1.056575>, <-1.487782, -5.346550, -1.061710>, 
      <-1.508790, -5.746583, -1.169808>, <-1.490666, -5.633174, -1.154323>, <-1.415099, -5.479442, -1.113055>, <-1.448375, -5.368554, -1.118190>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.480780, -5.662207, -0.676430>, <-1.480780, -5.538680, -0.676430>, <-1.437053, -5.364088, -0.697248>, <-1.480780, -5.250450, -0.676430>, 
      <-1.564428, -5.661841, -0.704428>, <-1.564428, -5.538314, -0.704428>, <-1.506820, -5.367663, -0.748729>, <-1.550546, -5.254025, -0.727911>, 
      <-1.580877, -5.704584, -0.858228>, <-1.580877, -5.570528, -0.858228>, <-1.530862, -5.369410, -0.867275>, <-1.591940, -5.250221, -0.861416>, 
      <-1.585806, -5.719430, -0.945040>, <-1.585806, -5.585374, -0.945040>, <-1.524727, -5.391766, -0.950899>, <-1.585806, -5.272578, -0.945040>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.056632, -5.721745, -0.767923>, <-1.114150, -5.581808, -0.746357>, <-1.216828, -5.389660, -0.761654>, <-1.248359, -5.255287, -0.696035>, 
      <-1.162767, -5.680582, -0.702315>, <-1.220285, -5.540645, -0.680748>, <-1.283447, -5.382015, -0.741607>, <-1.314978, -5.247642, -0.675988>, 
      <-1.356184, -5.662752, -0.634727>, <-1.356184, -5.539225, -0.634727>, <-1.380785, -5.361205, -0.655726>, <-1.424511, -5.247567, -0.634909>, 
      <-1.480780, -5.662207, -0.676430>, <-1.480780, -5.538680, -0.676430>, <-1.437053, -5.364088, -0.697248>, <-1.480780, -5.250450, -0.676430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.064908, -5.823497, -0.933504>, <-1.035389, -5.669287, -0.902808>, <-1.027357, -5.453921, -0.863186>, <-0.966511, -5.309464, -0.831185>, 
      <-1.052761, -5.806214, -0.879105>, <-1.023242, -5.652004, -0.848409>, <-1.049737, -5.414164, -0.779663>, <-0.988891, -5.269707, -0.747662>, 
      <-1.009492, -5.740028, -0.797063>, <-1.067011, -5.600090, -0.775496>, <-1.126239, -5.400055, -0.788914>, <-1.157770, -5.265683, -0.723295>, 
      <-1.056632, -5.721745, -0.767923>, <-1.114150, -5.581808, -0.746357>, <-1.216828, -5.389660, -0.761654>, <-1.248359, -5.255287, -0.696035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.064908, -5.823497, -0.933504>, <-1.077307, -5.841137, -0.989030>, <-1.106493, -5.832478, -1.066723>, <-1.135026, -5.833281, -1.119004>, 
      <-1.035389, -5.669287, -0.902808>, <-1.047788, -5.686927, -0.958334>, <-1.106493, -5.719479, -1.066723>, <-1.135026, -5.720282, -1.119004>, 
      <-1.027357, -5.453921, -0.863186>, <-1.001640, -5.499606, -0.959164>, <-1.139141, -5.524007, -1.013165>, <-1.197259, -5.549436, -1.102250>, 
      <-0.966511, -5.309464, -0.831185>, <-0.940794, -5.355149, -0.927163>, <-1.076909, -5.431190, -1.029920>, <-1.135026, -5.456619, -1.119004>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.048755, -5.128771, -1.612785>, <-0.902634, -5.150382, -1.573600>, <-0.784224, -5.246289, -1.370392>, <-0.731837, -5.231942, -1.227551>, 
      <-1.085400, -5.274640, -1.566647>, <-0.939279, -5.296251, -1.527461>, <-0.839077, -5.376551, -1.354361>, <-0.786690, -5.362204, -1.211519>, 
      <-1.177052, -5.281955, -1.280009>, <-1.151096, -5.287549, -1.255116>, <-1.076027, -5.348240, -1.169742>, <-1.056685, -5.339777, -1.140095>, 
      <-1.210405, -5.416178, -1.205034>, <-1.184449, -5.421772, -1.180141>, <-1.154367, -5.465082, -1.148651>, <-1.135026, -5.456619, -1.119004>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.462597, -5.123862, -1.423518>, <-1.349127, -5.113790, -1.498772>, <-1.179299, -5.109463, -1.647793>, <-1.048755, -5.128771, -1.612785>, 
      <-1.468077, -5.222918, -1.402064>, <-1.354607, -5.212847, -1.477318>, <-1.215944, -5.255332, -1.601654>, <-1.085400, -5.274640, -1.566647>, 
      <-1.352614, -5.316578, -1.327873>, <-1.308352, -5.325436, -1.344026>, <-1.211243, -5.274587, -1.312800>, <-1.177052, -5.281955, -1.280009>, 
      <-1.332376, -5.414090, -1.308271>, <-1.288114, -5.422948, -1.324424>, <-1.244596, -5.408810, -1.237825>, <-1.210405, -5.416178, -1.205034>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.677443, -5.184571, -1.195834>, <-1.612040, -5.202622, -1.263274>, <-1.542104, -5.130918, -1.370788>, <-1.462597, -5.123862, -1.423518>, 
      <-1.663038, -5.270563, -1.169199>, <-1.597634, -5.288614, -1.236639>, <-1.547584, -5.229975, -1.349335>, <-1.468077, -5.222918, -1.402064>, 
      <-1.474553, -5.281319, -1.122230>, <-1.437388, -5.302072, -1.175498>, <-1.415566, -5.303979, -1.304900>, <-1.352614, -5.316578, -1.327873>, 
      <-1.448375, -5.368554, -1.118190>, <-1.411210, -5.389307, -1.171458>, <-1.395328, -5.401492, -1.285298>, <-1.332376, -5.414090, -1.308271>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.961581, -4.986142, -0.908995>, <-1.945961, -5.033181, -1.034526>, <-1.769713, -5.159104, -1.100690>, <-1.677443, -5.184571, -1.195834>, 
      <-1.918604, -5.121576, -0.913504>, <-1.902984, -5.168614, -1.039035>, <-1.755308, -5.245096, -1.074056>, <-1.663038, -5.270563, -1.169199>, 
      <-1.650577, -5.146182, -0.938827>, <-1.645467, -5.164809, -1.008498>, <-1.513960, -5.259314, -1.065749>, <-1.474553, -5.281319, -1.122230>, 
      <-1.585806, -5.272578, -0.945040>, <-1.580695, -5.291204, -1.014711>, <-1.487782, -5.346550, -1.061710>, <-1.448375, -5.368554, -1.118190>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.758526, -4.940392, -0.544200>, <-1.861219, -4.944603, -0.617086>, <-1.976164, -4.942227, -0.791799>, <-1.961581, -4.986142, -0.908995>, 
      <-1.731056, -5.068489, -0.546492>, <-1.833749, -5.072700, -0.619378>, <-1.933187, -5.077660, -0.796309>, <-1.918604, -5.121576, -0.913504>, 
      <-1.527162, -5.129910, -0.654348>, <-1.596929, -5.133485, -0.705829>, <-1.656712, -5.123826, -0.855203>, <-1.650577, -5.146182, -0.938827>, 
      <-1.480780, -5.250450, -0.676430>, <-1.550546, -5.254025, -0.727911>, <-1.591940, -5.250221, -0.861416>, <-1.585806, -5.272578, -0.945040>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.236225, -4.956400, -0.394177>, <-1.395018, -4.940434, -0.360557>, <-1.625598, -4.934941, -0.449855>, <-1.758526, -4.940392, -0.544200>, 
      <-1.236337, -5.079876, -0.425921>, <-1.395131, -5.063909, -0.392300>, <-1.598128, -5.063038, -0.452147>, <-1.731056, -5.068489, -0.546492>, 
      <-1.274663, -5.143191, -0.641294>, <-1.341282, -5.135547, -0.621247>, <-1.470894, -5.127028, -0.612827>, <-1.527162, -5.129910, -0.654348>, 
      <-1.248359, -5.255287, -0.696035>, <-1.314978, -5.247642, -0.675988>, <-1.424511, -5.247567, -0.634909>, <-1.480780, -5.250450, -0.676430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.736235, -5.043181, -0.760644>, <-0.829797, -4.992069, -0.606056>, <-1.053394, -4.974783, -0.432887>, <-1.236225, -4.956400, -0.394177>, 
      <-0.737621, -5.150326, -0.771596>, <-0.831183, -5.099214, -0.617008>, <-1.053506, -5.098258, -0.464631>, <-1.236337, -5.079876, -0.425921>, 
      <-0.925545, -5.212204, -0.809639>, <-0.947924, -5.172448, -0.726117>, <-1.184074, -5.153587, -0.668555>, <-1.274663, -5.143191, -0.641294>, 
      <-0.966511, -5.309464, -0.831185>, <-0.988891, -5.269707, -0.747662>, <-1.157770, -5.265683, -0.723295>, <-1.248359, -5.255287, -0.696035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.736235, -5.043181, -0.760644>, <-0.737621, -5.150326, -0.771596>, <-0.925545, -5.212204, -0.809639>, <-0.966511, -5.309464, -0.831185>, 
      <-0.660956, -5.084305, -0.885024>, <-0.662342, -5.191450, -0.895976>, <-0.899828, -5.257889, -0.905617>, <-0.940794, -5.355149, -0.927163>, 
      <-0.680043, -5.217757, -1.086325>, <-0.734896, -5.348019, -1.070293>, <-0.998568, -5.314348, -1.051011>, <-1.076909, -5.431190, -1.029920>, 
      <-0.731837, -5.231942, -1.227551>, <-0.786690, -5.362204, -1.211519>, <-1.056685, -5.339777, -1.140095>, <-1.135026, -5.456619, -1.119004>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.039238, -4.734832, -1.420544>, <-0.959454, -4.752624, -1.374437>, <-0.821193, -4.694862, -1.306605>, <-0.809745, -4.684165, -1.214072>, 
      <-1.041938, -4.863924, -1.445628>, <-0.962154, -4.881716, -1.399521>, <-0.823397, -4.860512, -1.317711>, <-0.811949, -4.849815, -1.225178>, 
      <-1.018116, -5.006811, -1.651361>, <-0.871996, -5.028422, -1.612176>, <-0.720196, -5.094242, -1.389105>, <-0.667810, -5.079895, -1.246264>, 
      <-1.048755, -5.128771, -1.612785>, <-0.902634, -5.150382, -1.573600>, <-0.784224, -5.246289, -1.370392>, <-0.731837, -5.231942, -1.227551>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.286117, -4.577930, -1.489368>, <-1.197635, -4.584794, -1.505219>, <-1.115878, -4.717740, -1.464834>, <-1.039238, -4.734832, -1.420544>, 
      <-1.319696, -4.745822, -1.462877>, <-1.231215, -4.752686, -1.478728>, <-1.118577, -4.846832, -1.489918>, <-1.041938, -4.863924, -1.445628>, 
      <-1.453243, -4.954780, -1.460138>, <-1.339773, -4.944709, -1.535392>, <-1.148660, -4.987503, -1.686369>, <-1.018116, -5.006811, -1.651361>, 
      <-1.462597, -5.123862, -1.423518>, <-1.349127, -5.113790, -1.498772>, <-1.179299, -5.109463, -1.647793>, <-1.048755, -5.128771, -1.612785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.561320, -4.694334, -1.327019>, <-1.492534, -4.693409, -1.402355>, <-1.386246, -4.570163, -1.471431>, <-1.286117, -4.577930, -1.489368>, 
      <-1.579791, -4.848566, -1.310779>, <-1.511005, -4.847640, -1.386115>, <-1.419826, -4.738055, -1.444940>, <-1.319696, -4.745822, -1.462877>, 
      <-1.702121, -5.037257, -1.241462>, <-1.636718, -5.055308, -1.308902>, <-1.532750, -4.961837, -1.407408>, <-1.453243, -4.954780, -1.460138>, 
      <-1.677443, -5.184571, -1.195834>, <-1.612040, -5.202622, -1.263274>, <-1.542104, -5.130918, -1.370788>, <-1.462597, -5.123862, -1.423518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.804027, -4.584895, -0.922143>, <-1.785181, -4.636210, -1.056844>, <-1.659336, -4.695652, -1.219670>, <-1.561320, -4.694334, -1.327019>, 
      <-1.815070, -4.713798, -0.920886>, <-1.796224, -4.765113, -1.055587>, <-1.677807, -4.849884, -1.203430>, <-1.579791, -4.848566, -1.310779>, 
      <-2.000695, -4.862883, -0.904891>, <-1.985075, -4.909921, -1.030422>, <-1.794391, -5.011790, -1.146319>, <-1.702121, -5.037257, -1.241462>, 
      <-1.961581, -4.986142, -0.908995>, <-1.945961, -5.033181, -1.034526>, <-1.769713, -5.159104, -1.100690>, <-1.677443, -5.184571, -1.195834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.654368, -4.440975, -0.661944>, <-1.733755, -4.451743, -0.721569>, <-1.816973, -4.549644, -0.829607>, <-1.804027, -4.584895, -0.922143>, 
      <-1.663070, -4.597204, -0.648217>, <-1.742456, -4.607972, -0.707842>, <-1.828016, -4.678547, -0.828350>, <-1.815070, -4.713798, -0.920886>, 
      <-1.791456, -4.786835, -0.541452>, <-1.894149, -4.791046, -0.614338>, <-2.015277, -4.818967, -0.787695>, <-2.000695, -4.862883, -0.904891>, 
      <-1.758526, -4.940392, -0.544200>, <-1.861219, -4.944603, -0.617086>, <-1.976164, -4.942227, -0.791799>, <-1.961581, -4.986142, -0.908995>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.247680, -4.509436, -0.504287>, <-1.372847, -4.470240, -0.485815>, <-1.549076, -4.426694, -0.582862>, <-1.654368, -4.440975, -0.661944>, 
      <-1.247303, -4.647060, -0.492353>, <-1.372470, -4.607864, -0.473881>, <-1.557777, -4.582923, -0.569135>, <-1.663070, -4.597204, -0.648217>, 
      <-1.236103, -4.822610, -0.359781>, <-1.394896, -4.806644, -0.326161>, <-1.658527, -4.781384, -0.447107>, <-1.791456, -4.786835, -0.541452>, 
      <-1.236225, -4.956400, -0.394177>, <-1.395018, -4.940434, -0.360557>, <-1.625598, -4.934941, -0.449855>, <-1.758526, -4.940392, -0.544200>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.958097, -4.659015, -0.764701>, <-1.022420, -4.633351, -0.660450>, <-1.129409, -4.546473, -0.521742>, <-1.247680, -4.509436, -0.504287>, 
      <-0.940451, -4.790908, -0.767351>, <-1.004774, -4.765244, -0.663100>, <-1.129033, -4.684097, -0.509808>, <-1.247303, -4.647060, -0.492353>, 
      <-0.734522, -4.910788, -0.747112>, <-0.828085, -4.859676, -0.592524>, <-1.053272, -4.840993, -0.398491>, <-1.236103, -4.822610, -0.359781>, 
      <-0.736235, -5.043181, -0.760644>, <-0.829797, -4.992069, -0.606056>, <-1.053394, -4.974783, -0.432887>, <-1.236225, -4.956400, -0.394177>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.958097, -4.659015, -0.764701>, <-0.940451, -4.790908, -0.767351>, <-0.734522, -4.910788, -0.747112>, <-0.736235, -5.043181, -0.760644>, 
      <-0.885032, -4.688167, -0.883122>, <-0.867386, -4.820060, -0.885772>, <-0.659243, -4.951912, -0.871492>, <-0.660956, -5.084305, -0.885024>, 
      <-0.792403, -4.667961, -1.073899>, <-0.794606, -4.833610, -1.085005>, <-0.616016, -5.065710, -1.105038>, <-0.680043, -5.217757, -1.086325>, 
      <-0.809745, -4.684165, -1.214072>, <-0.811949, -4.849815, -1.225178>, <-0.667810, -5.079895, -1.246264>, <-0.731837, -5.231942, -1.227551>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.031770, -4.316521, -1.454956>, <-0.890548, -4.193839, -1.350450>, <-0.731914, -3.921527, -1.276348>, <-0.712347, -3.766871, -1.129328>, 
      <-1.027799, -4.442372, -1.452519>, <-0.886576, -4.319690, -1.348013>, <-0.744670, -4.199132, -1.277622>, <-0.725103, -4.044476, -1.130603>, 
      <-1.036653, -4.611233, -1.396527>, <-0.956870, -4.629026, -1.350420>, <-0.817505, -4.417608, -1.288017>, <-0.806057, -4.406911, -1.195484>, 
      <-1.039238, -4.734832, -1.420544>, <-0.959454, -4.752624, -1.374437>, <-0.821193, -4.694862, -1.306605>, <-0.809745, -4.684165, -1.214072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.291885, -4.270324, -1.558192>, <-1.225728, -4.321061, -1.575214>, <-1.087850, -4.365239, -1.496456>, <-1.031770, -4.316521, -1.454956>, 
      <-1.289037, -4.364828, -1.560642>, <-1.222880, -4.415565, -1.577664>, <-1.083879, -4.491089, -1.494019>, <-1.027799, -4.442372, -1.452519>, 
      <-1.267786, -4.486278, -1.503829>, <-1.179304, -4.493142, -1.519680>, <-1.113293, -4.594142, -1.440818>, <-1.036653, -4.611233, -1.396527>, 
      <-1.286117, -4.577930, -1.489368>, <-1.197635, -4.584794, -1.505219>, <-1.115878, -4.717740, -1.464834>, <-1.039238, -4.734832, -1.420544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.527914, -3.936025, -1.327302>, <-1.453844, -4.020616, -1.412318>, <-1.401478, -4.186276, -1.529994>, <-1.291885, -4.270324, -1.558192>, 
      <-1.530108, -4.163287, -1.341462>, <-1.456037, -4.247878, -1.426478>, <-1.398630, -4.280781, -1.532444>, <-1.289037, -4.364828, -1.560642>, 
      <-1.534389, -4.469462, -1.350697>, <-1.465602, -4.468537, -1.426033>, <-1.367915, -4.478511, -1.485892>, <-1.267786, -4.486278, -1.503829>, 
      <-1.561320, -4.694334, -1.327019>, <-1.492534, -4.693409, -1.402355>, <-1.386246, -4.570163, -1.471431>, <-1.286117, -4.577930, -1.489368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.846044, -3.637455, -0.922143>, <-1.809454, -3.716210, -1.078234>, <-1.621774, -3.828834, -1.219572>, <-1.527914, -3.936025, -1.327302>, 
      <-1.843563, -3.920384, -0.952000>, <-1.806973, -3.999139, -1.108091>, <-1.623968, -4.056096, -1.233732>, <-1.530108, -4.163287, -1.341462>, 
      <-1.779744, -4.301436, -0.924906>, <-1.760898, -4.352750, -1.059608>, <-1.632405, -4.470780, -1.243348>, <-1.534389, -4.469462, -1.350697>, 
      <-1.804027, -4.584895, -0.922143>, <-1.785181, -4.636210, -1.056844>, <-1.659336, -4.695652, -1.219670>, <-1.561320, -4.694334, -1.327019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.683885, -3.600321, -0.661944>, <-1.760005, -3.594154, -0.714401>, <-1.865023, -3.596605, -0.841179>, <-1.846044, -3.637455, -0.922143>, 
      <-1.683653, -3.852334, -0.675004>, <-1.759773, -3.846167, -0.727462>, <-1.862543, -3.879534, -0.871037>, <-1.843563, -3.920384, -0.952000>, 
      <-1.640388, -4.189978, -0.683998>, <-1.719774, -4.200746, -0.743622>, <-1.792691, -4.266184, -0.832370>, <-1.779744, -4.301436, -0.924906>, 
      <-1.654368, -4.440975, -0.661944>, <-1.733755, -4.451743, -0.721569>, <-1.816973, -4.549644, -0.829607>, <-1.804027, -4.584895, -0.922143>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.239703, -3.686580, -0.504287>, <-1.382585, -3.695293, -0.491156>, <-1.565784, -3.609890, -0.580556>, <-1.683885, -3.600321, -0.661944>, 
      <-1.235872, -3.933419, -0.504163>, <-1.378754, -3.942132, -0.491032>, <-1.565552, -3.861903, -0.593616>, <-1.683653, -3.852334, -0.675004>, 
      <-1.248354, -4.263492, -0.525614>, <-1.373521, -4.224295, -0.507141>, <-1.535095, -4.175697, -0.604916>, <-1.640388, -4.189978, -0.683998>, 
      <-1.247680, -4.509436, -0.504287>, <-1.372847, -4.470240, -0.485815>, <-1.549076, -4.426694, -0.582862>, <-1.654368, -4.440975, -0.661944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.935382, -3.554676, -0.730731>, <-1.012703, -3.542904, -0.639087>, <-1.119948, -3.679277, -0.515293>, <-1.239703, -3.686580, -0.504287>, 
      <-0.941535, -3.885672, -0.712992>, <-1.018857, -3.873900, -0.621348>, <-1.116117, -3.926116, -0.515169>, <-1.235872, -3.933419, -0.504163>, 
      <-1.002052, -4.330480, -0.758099>, <-1.066374, -4.304816, -0.653848>, <-1.130083, -4.300528, -0.543068>, <-1.248354, -4.263492, -0.525614>, 
      <-0.958097, -4.659015, -0.764701>, <-1.022420, -4.633351, -0.660450>, <-1.129409, -4.546473, -0.521742>, <-1.247680, -4.509436, -0.504287>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.935382, -3.554676, -0.730731>, <-0.941535, -3.885672, -0.712992>, <-1.002052, -4.330480, -0.758099>, <-0.958097, -4.659015, -0.764701>, 
      <-0.838416, -3.569439, -0.845658>, <-0.844569, -3.900436, -0.827919>, <-0.928987, -4.359632, -0.876519>, <-0.885032, -4.688167, -0.883122>, 
      <-0.698550, -3.657821, -1.025663>, <-0.711306, -3.935426, -1.026938>, <-0.788714, -4.390707, -1.055311>, <-0.792403, -4.667961, -1.073899>, 
      <-0.712347, -3.766871, -1.129328>, <-0.725103, -4.044476, -1.130603>, <-0.806057, -4.406911, -1.195484>, <-0.809745, -4.684165, -1.214072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.091470, -3.079612, -1.452600>, <-0.976461, -3.043233, -1.404263>, <-0.769177, -3.092038, -1.328805>, <-0.735278, -3.063561, -1.206630>, 
      <-1.083346, -3.450940, -1.460699>, <-0.968338, -3.414561, -1.412362>, <-0.765908, -3.301930, -1.296589>, <-0.732009, -3.273453, -1.174414>, 
      <-1.043485, -3.945270, -1.462146>, <-0.902263, -3.822588, -1.357640>, <-0.722166, -3.709378, -1.275373>, <-0.702599, -3.554722, -1.128354>, 
      <-1.031770, -4.316521, -1.454956>, <-0.890548, -4.193839, -1.350450>, <-0.731914, -3.921527, -1.276348>, <-0.712347, -3.766871, -1.129328>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.326124, -3.250456, -1.454956>, <-1.254484, -3.213740, -1.488163>, <-1.168538, -3.103990, -1.484991>, <-1.091470, -3.079612, -1.452600>, 
      <-1.318086, -3.557033, -1.479904>, <-1.246446, -3.520317, -1.513111>, <-1.160415, -3.475318, -1.493090>, <-1.083346, -3.450940, -1.460699>, 
      <-1.301151, -3.962872, -1.550222>, <-1.234994, -4.013608, -1.567244>, <-1.099565, -3.993988, -1.503646>, <-1.043485, -3.945270, -1.462146>, 
      <-1.291885, -4.270324, -1.558192>, <-1.225728, -4.321061, -1.575214>, <-1.087850, -4.365239, -1.496456>, <-1.031770, -4.316521, -1.454956>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.547991, -3.313584, -1.240989>, <-1.493273, -3.323753, -1.317225>, <-1.403776, -3.290254, -1.418962>, <-1.326124, -3.250456, -1.454956>, 
      <-1.539765, -3.502018, -1.241803>, <-1.485047, -3.512187, -1.318039>, <-1.395738, -3.596831, -1.443910>, <-1.318086, -3.557033, -1.479904>, 
      <-1.526097, -3.747784, -1.315573>, <-1.452026, -3.832374, -1.400589>, <-1.410744, -3.878824, -1.522024>, <-1.301151, -3.962872, -1.550222>, 
      <-1.527914, -3.936025, -1.327302>, <-1.453844, -4.020616, -1.412318>, <-1.401478, -4.186276, -1.529994>, <-1.291885, -4.270324, -1.558192>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.816525, -3.159320, -0.771703>, <-1.790452, -3.214383, -0.928995>, <-1.645774, -3.295412, -1.104752>, <-1.547991, -3.313584, -1.240989>, 
      <-1.810188, -3.309815, -0.772991>, <-1.784115, -3.364878, -0.930283>, <-1.637548, -3.483846, -1.105566>, <-1.539765, -3.502018, -1.241803>, 
      <-1.847357, -3.487659, -0.906335>, <-1.810767, -3.566414, -1.062426>, <-1.619957, -3.640592, -1.207843>, <-1.526097, -3.747784, -1.315573>, 
      <-1.846044, -3.637455, -0.922143>, <-1.809454, -3.716210, -1.078234>, <-1.621774, -3.828834, -1.219572>, <-1.527914, -3.936025, -1.327302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.655613, -3.086303, -0.591739>, <-1.718712, -3.114367, -0.622656>, <-1.828221, -3.134621, -0.701147>, <-1.816525, -3.159320, -0.771703>, 
      <-1.654934, -3.241800, -0.602460>, <-1.718033, -3.269865, -0.633377>, <-1.821884, -3.285115, -0.702435>, <-1.810188, -3.309815, -0.772991>, 
      <-1.684028, -3.444662, -0.653877>, <-1.760148, -3.438495, -0.706334>, <-1.866336, -3.446809, -0.825372>, <-1.847357, -3.487659, -0.906335>, 
      <-1.683885, -3.600321, -0.661944>, <-1.760005, -3.594154, -0.714401>, <-1.865023, -3.596605, -0.841179>, <-1.846044, -3.637455, -0.922143>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.272388, -2.917308, -0.505086>, <-1.390918, -2.940961, -0.462018>, <-1.548609, -3.038712, -0.539309>, <-1.655613, -3.086303, -0.591739>, 
      <-1.261564, -3.147880, -0.513782>, <-1.380093, -3.171534, -0.470714>, <-1.547930, -3.194209, -0.550030>, <-1.654934, -3.241800, -0.602460>, 
      <-1.243287, -3.455618, -0.504403>, <-1.386169, -3.464331, -0.491272>, <-1.565927, -3.454230, -0.572489>, <-1.684028, -3.444662, -0.653877>, 
      <-1.239703, -3.686580, -0.504287>, <-1.382585, -3.695293, -0.491156>, <-1.565784, -3.609890, -0.580556>, <-1.683885, -3.600321, -0.661944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.926155, -2.940736, -0.856791>, <-1.015053, -2.916530, -0.740678>, <-1.135461, -2.889984, -0.554839>, <-1.272388, -2.917308, -0.505086>, 
      <-0.941944, -3.121056, -0.805836>, <-1.030842, -3.096849, -0.689723>, <-1.124636, -3.120556, -0.563535>, <-1.261564, -3.147880, -0.513782>, 
      <-0.931892, -3.366933, -0.740793>, <-1.009213, -3.355161, -0.649149>, <-1.123532, -3.448315, -0.515408>, <-1.243287, -3.455618, -0.504403>, 
      <-0.935382, -3.554676, -0.730731>, <-1.012703, -3.542904, -0.639087>, <-1.119948, -3.679277, -0.515293>, <-1.239703, -3.686580, -0.504287>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.926155, -2.940736, -0.856791>, <-0.941944, -3.121056, -0.805836>, <-0.931892, -3.366933, -0.740793>, <-0.935382, -3.554676, -0.730731>, 
      <-0.851123, -2.961167, -0.954793>, <-0.866913, -3.141486, -0.903838>, <-0.834926, -3.381696, -0.855720>, <-0.838416, -3.569439, -0.845658>, 
      <-0.702642, -3.036145, -1.089008>, <-0.699373, -3.246037, -1.056792>, <-0.688802, -3.445672, -1.024689>, <-0.698550, -3.657821, -1.025663>, 
      <-0.735278, -3.063561, -1.206630>, <-0.732009, -3.273453, -1.174414>, <-0.702599, -3.554722, -1.128354>, <-0.712347, -3.766871, -1.129328>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.071885, -2.482919, -1.414965>, <-0.961538, -2.470561, -1.393025>, <-0.792145, -2.626732, -1.399831>, <-0.730480, -2.602684, -1.308019>, 
      <-1.072272, -2.661151, -1.435917>, <-0.961925, -2.648793, -1.413976>, <-0.808708, -2.767279, -1.403866>, <-0.747042, -2.743231, -1.312053>, 
      <-1.095394, -2.900238, -1.448688>, <-0.980386, -2.863858, -1.400351>, <-0.771357, -2.952117, -1.350281>, <-0.737457, -2.923640, -1.228107>, 
      <-1.091470, -3.079612, -1.452600>, <-0.976461, -3.043233, -1.404263>, <-0.769177, -3.092038, -1.328805>, <-0.735278, -3.063561, -1.206630>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.333836, -2.670257, -1.427985>, <-1.241045, -2.648924, -1.444842>, <-1.166154, -2.493477, -1.433709>, <-1.071885, -2.482919, -1.414965>, 
      <-1.328897, -2.844081, -1.439326>, <-1.236106, -2.822747, -1.456183>, <-1.166541, -2.671709, -1.454660>, <-1.072272, -2.661151, -1.435917>, 
      <-1.330676, -3.076827, -1.440827>, <-1.259036, -3.040111, -1.474034>, <-1.172463, -2.924616, -1.481079>, <-1.095394, -2.900238, -1.448688>, 
      <-1.326124, -3.250456, -1.454956>, <-1.254484, -3.213740, -1.488163>, <-1.168538, -3.103990, -1.484991>, <-1.091470, -3.079612, -1.452600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.586190, -2.601161, -1.321533>, <-1.525991, -2.623525, -1.376822>, <-1.415157, -2.688953, -1.413212>, <-1.333836, -2.670257, -1.427985>, 
      <-1.607298, -2.815150, -1.308984>, <-1.547098, -2.837514, -1.364273>, <-1.410219, -2.862777, -1.424552>, <-1.328897, -2.844081, -1.439326>, 
      <-1.557385, -3.098397, -1.240059>, <-1.502668, -3.108566, -1.316295>, <-1.408328, -3.116624, -1.404833>, <-1.330676, -3.076827, -1.440827>, 
      <-1.547991, -3.313584, -1.240989>, <-1.493273, -3.323753, -1.317225>, <-1.403776, -3.290254, -1.418962>, <-1.326124, -3.250456, -1.454956>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.895554, -2.461577, -0.912080>, <-1.875361, -2.521702, -1.058480>, <-1.699532, -2.559054, -1.217435>, <-1.586190, -2.601161, -1.321533>, 
      <-1.908229, -2.675280, -0.894135>, <-1.888036, -2.735405, -1.040534>, <-1.720640, -2.773043, -1.204886>, <-1.607298, -2.815150, -1.308984>, 
      <-1.825562, -2.944689, -0.769866>, <-1.799489, -2.999751, -0.927158>, <-1.655169, -3.080225, -1.103822>, <-1.557385, -3.098397, -1.240059>, 
      <-1.816525, -3.159320, -0.771703>, <-1.790452, -3.214383, -0.928995>, <-1.645774, -3.295412, -1.104752>, <-1.547991, -3.313584, -1.240989>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.689597, -2.293264, -0.571831>, <-1.790763, -2.313891, -0.650103>, <-1.911952, -2.412752, -0.793195>, <-1.895554, -2.461577, -0.912080>, 
      <-1.706017, -2.530346, -0.588083>, <-1.807183, -2.550973, -0.666356>, <-1.924627, -2.626455, -0.775249>, <-1.908229, -2.675280, -0.894135>, 
      <-1.656651, -2.848664, -0.575355>, <-1.719751, -2.876729, -0.606273>, <-1.837258, -2.919989, -0.699310>, <-1.825562, -2.944689, -0.769866>, 
      <-1.655613, -3.086303, -0.591739>, <-1.718712, -3.114367, -0.622656>, <-1.828221, -3.134621, -0.701147>, <-1.816525, -3.159320, -0.771703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.302885, -2.340736, -0.453530>, <-1.408503, -2.328814, -0.393327>, <-1.594216, -2.273817, -0.498035>, <-1.689597, -2.293264, -0.571831>, 
      <-1.312147, -2.514392, -0.453621>, <-1.417765, -2.502470, -0.393419>, <-1.610637, -2.510899, -0.514287>, <-1.706017, -2.530346, -0.588083>, 
      <-1.280537, -2.743720, -0.498539>, <-1.399067, -2.767373, -0.455471>, <-1.549648, -2.801073, -0.522926>, <-1.656651, -2.848664, -0.575355>, 
      <-1.272388, -2.917308, -0.505086>, <-1.390918, -2.940961, -0.462018>, <-1.548609, -3.038712, -0.539309>, <-1.655613, -3.086303, -0.591739>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.833390, -2.389910, -1.059874>, <-0.957722, -2.333012, -0.874270>, <-1.103561, -2.363235, -0.567146>, <-1.302885, -2.340736, -0.453530>, 
      <-0.848846, -2.563720, -1.023206>, <-0.973179, -2.506822, -0.837603>, <-1.112823, -2.536891, -0.567237>, <-1.312147, -2.514392, -0.453621>, 
      <-0.911183, -2.769755, -0.905107>, <-1.000081, -2.745548, -0.788994>, <-1.143610, -2.716395, -0.548292>, <-1.280537, -2.743720, -0.498539>, 
      <-0.926155, -2.940736, -0.856791>, <-1.015053, -2.916530, -0.740678>, <-1.135461, -2.889984, -0.554839>, <-1.272388, -2.917308, -0.505086>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.833390, -2.389910, -1.059874>, <-0.848846, -2.563720, -1.023206>, <-0.911183, -2.769755, -0.905107>, <-0.926155, -2.940736, -0.856791>, 
      <-0.777943, -2.415284, -1.142646>, <-0.793399, -2.589094, -1.105979>, <-0.836151, -2.790186, -1.003110>, <-0.851123, -2.961167, -0.954793>, 
      <-0.674467, -2.580840, -1.224623>, <-0.691029, -2.721387, -1.228657>, <-0.704822, -2.896224, -1.110485>, <-0.702642, -3.036145, -1.089008>, 
      <-0.730480, -2.602684, -1.308019>, <-0.747042, -2.743231, -1.312053>, <-0.737457, -2.923640, -1.228107>, <-0.735278, -3.063561, -1.206630>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.374349, -1.553207, -1.344225>, <-1.362195, -1.888322, -1.369353>, <-1.343367, -2.334830, -1.406101>, <-1.333836, -2.670257, -1.427985>, 
      <-1.374349, -1.553207, -1.344225>, <-1.426805, -2.201491, -1.343384>, <-1.424688, -2.353526, -1.391328>, <-1.415157, -2.688953, -1.413212>, 
      <-1.374349, -1.553207, -1.344225>, <-1.426805, -2.201491, -1.343384>, <-1.494552, -2.304799, -1.395514>, <-1.525991, -2.623525, -1.376822>, 
      <-1.374349, -1.553207, -1.344225>, <-1.438959, -1.866376, -1.318256>, <-1.554751, -2.282435, -1.340224>, <-1.586190, -2.601161, -1.321533>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.088653, -1.782341, -1.300102>, <-0.939369, -1.820224, -1.267139>, <-0.694198, -1.846676, -1.228272>, <-0.581020, -1.754527, -1.169054>, 
      <-1.102018, -1.993973, -1.320570>, <-0.952734, -2.031856, -1.287608>, <-0.708504, -2.106142, -1.259327>, <-0.595325, -2.013993, -1.200109>, 
      <-1.071426, -2.271338, -1.390093>, <-0.961079, -2.258979, -1.368153>, <-0.761530, -2.366927, -1.392374>, <-0.699864, -2.342879, -1.300561>, 
      <-1.071885, -2.482919, -1.414965>, <-0.961538, -2.470561, -1.393025>, <-0.792145, -2.626732, -1.399831>, <-0.730480, -2.602684, -1.308019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.088653, -1.782341, -1.300102>, <-1.102018, -1.993973, -1.320570>, <-1.071426, -2.271338, -1.390093>, <-1.071885, -2.482919, -1.414965>, 
      <-1.193541, -1.755724, -1.323262>, <-1.206906, -1.967356, -1.343730>, <-1.165695, -2.281895, -1.408837>, <-1.166154, -2.493477, -1.433709>, 
      <-1.292194, -1.607994, -1.394178>, <-1.280040, -1.943109, -1.419306>, <-1.250575, -2.313497, -1.422958>, <-1.241045, -2.648924, -1.444842>, 
      <-1.374349, -1.553207, -1.344225>, <-1.362195, -1.888322, -1.369353>, <-1.343367, -2.334830, -1.406101>, <-1.333836, -2.670257, -1.427985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.710266, -1.367806, -0.922143>, <-1.680398, -1.409433, -1.085416>, <-1.501389, -1.468488, -1.266981>, <-1.374349, -1.553207, -1.344225>, 
      <-1.765106, -1.696070, -0.920086>, <-1.735238, -1.737698, -1.083359>, <-1.565999, -1.781657, -1.241013>, <-1.438959, -1.866376, -1.318256>, 
      <-1.875917, -2.130502, -0.939882>, <-1.855724, -2.190627, -1.086281>, <-1.668093, -2.240328, -1.236126>, <-1.554751, -2.282435, -1.340224>, 
      <-1.895554, -2.461577, -0.912080>, <-1.875361, -2.521702, -1.058480>, <-1.699532, -2.559054, -1.217435>, <-1.586190, -2.601161, -1.321533>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.534020, -1.330672, -0.471387>, <-1.647310, -1.323832, -0.562626>, <-1.735683, -1.332382, -0.783200>, <-1.710266, -1.367806, -0.922143>, 
      <-1.580877, -1.620317, -0.491112>, <-1.694168, -1.613477, -0.582351>, <-1.790524, -1.660646, -0.781143>, <-1.765106, -1.696070, -0.920086>, 
      <-1.669326, -2.000577, -0.551767>, <-1.770492, -2.021204, -0.630039>, <-1.892315, -2.081677, -0.820996>, <-1.875917, -2.130502, -0.939882>, 
      <-1.689597, -2.293264, -0.571831>, <-1.790763, -2.313891, -0.650103>, <-1.911952, -2.412752, -0.793195>, <-1.895554, -2.461577, -0.912080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.191416, -1.399133, -0.504287>, <-1.266796, -1.376608, -0.434332>, <-1.452117, -1.335617, -0.405427>, <-1.534020, -1.330672, -0.471387>, 
      <-1.257917, -1.675950, -0.494497>, <-1.333296, -1.653424, -0.424542>, <-1.498975, -1.625262, -0.425152>, <-1.580877, -1.620317, -0.491112>, 
      <-1.287714, -2.056280, -0.453380>, <-1.393331, -2.044358, -0.393178>, <-1.573945, -1.981130, -0.477971>, <-1.669326, -2.000577, -0.551767>, 
      <-1.302885, -2.340736, -0.453530>, <-1.408503, -2.328814, -0.393327>, <-1.594216, -2.273817, -0.498035>, <-1.689597, -2.293264, -0.571831>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.802419, -1.549292, -1.150336>, <-0.947586, -1.464771, -0.992238>, <-1.026247, -1.448489, -0.657569>, <-1.191416, -1.399133, -0.504287>, 
      <-0.839612, -1.799890, -1.134923>, <-0.984779, -1.715369, -0.976826>, <-1.092748, -1.725306, -0.647779>, <-1.257917, -1.675950, -0.494497>, 
      <-0.811389, -2.142499, -1.112069>, <-0.935721, -2.085602, -0.926465>, <-1.088390, -2.078779, -0.566996>, <-1.287714, -2.056280, -0.453380>, 
      <-0.833390, -2.389910, -1.059874>, <-0.957722, -2.333012, -0.874270>, <-1.103561, -2.363235, -0.567146>, <-1.302885, -2.340736, -0.453530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.802419, -1.549292, -1.150336>, <-0.839612, -1.799890, -1.134923>, <-0.811389, -2.142499, -1.112069>, <-0.833390, -2.389910, -1.059874>, 
      <-0.745315, -1.582540, -1.212527>, <-0.782508, -1.833138, -1.197114>, <-0.755941, -2.167874, -1.194841>, <-0.777943, -2.415284, -1.142646>, 
      <-0.515815, -1.701438, -1.134937>, <-0.530121, -1.960904, -1.165992>, <-0.643852, -2.321035, -1.217165>, <-0.674467, -2.580840, -1.224623>, 
      <-0.581020, -1.754527, -1.169054>, <-0.595325, -2.013993, -1.200109>, <-0.699864, -2.342879, -1.300561>, <-0.730480, -2.602684, -1.308019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.650991, -1.160941, -1.135460>, <-0.701659, -1.268881, -1.097527>, <-0.784083, -1.425748, -1.157934>, <-0.802419, -1.549292, -1.150336>, 
      <-0.650991, -1.160941, -1.135460>, <-0.680668, -1.446957, -1.107606>, <-0.726979, -1.458996, -1.220125>, <-0.745315, -1.582540, -1.212527>, 
      <-0.650991, -1.160941, -1.135460>, <-0.680668, -1.446957, -1.107606>, <-0.505999, -1.523386, -1.113626>, <-0.515815, -1.701438, -1.134937>, 
      <-0.650991, -1.160941, -1.135460>, <-0.630000, -1.339017, -1.145538>, <-0.571203, -1.576475, -1.147743>, <-0.581020, -1.754527, -1.169054>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.996884, -1.295287, -1.300102>, <-0.887356, -1.299014, -1.246984>, <-0.656314, -1.214448, -1.244732>, <-0.650991, -1.160941, -1.135460>, 
      <-1.007192, -1.441043, -1.272589>, <-0.897663, -1.444770, -1.219471>, <-0.635323, -1.392524, -1.254811>, <-0.630000, -1.339017, -1.145538>, 
      <-1.079325, -1.634636, -1.285817>, <-0.930041, -1.672519, -1.252854>, <-0.684381, -1.668623, -1.206962>, <-0.571203, -1.576475, -1.147743>, 
      <-1.088653, -1.782341, -1.300102>, <-0.939369, -1.820224, -1.267139>, <-0.694198, -1.846676, -1.228272>, <-0.581020, -1.754527, -1.169054>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.284610, -1.139380, -1.442747>, <-1.205792, -1.194371, -1.490006>, <-1.093201, -1.292010, -1.346813>, <-0.996884, -1.295287, -1.300102>, 
      <-1.328912, -1.259942, -1.420093>, <-1.250094, -1.314933, -1.467352>, <-1.103509, -1.437765, -1.319300>, <-1.007192, -1.441043, -1.272589>, 
      <-1.348082, -1.425890, -1.354783>, <-1.265927, -1.480677, -1.404735>, <-1.184214, -1.608019, -1.308976>, <-1.079325, -1.634636, -1.285817>, 
      <-1.374349, -1.553207, -1.344225>, <-1.292194, -1.607994, -1.394178>, <-1.193541, -1.755724, -1.323262>, <-1.088653, -1.782341, -1.300102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.627239, -0.855491, -0.922143>, <-1.594258, -0.919125, -1.114690>, <-1.435814, -1.033885, -1.352085>, <-1.284610, -1.139380, -1.442747>, 
      <-1.659264, -1.005875, -0.897619>, <-1.626282, -1.069509, -1.090166>, <-1.480117, -1.154447, -1.329431>, <-1.328912, -1.259942, -1.420093>, 
      <-1.684611, -1.214238, -0.923105>, <-1.654743, -1.255865, -1.086378>, <-1.475122, -1.341171, -1.277538>, <-1.348082, -1.425890, -1.354783>, 
      <-1.710266, -1.367806, -0.922143>, <-1.680398, -1.409433, -1.085416>, <-1.501389, -1.468488, -1.266981>, <-1.374349, -1.553207, -1.344225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.450995, -0.818357, -0.471387>, <-1.574263, -0.809125, -0.548366>, <-1.650616, -0.810388, -0.785669>, <-1.627239, -0.855491, -0.922143>, 
      <-1.473628, -0.970241, -0.445668>, <-1.596896, -0.961009, -0.522647>, <-1.682641, -0.960772, -0.761145>, <-1.659264, -1.005875, -0.897619>, 
      <-1.509211, -1.177317, -0.460943>, <-1.622502, -1.170477, -0.552182>, <-1.710028, -1.178813, -0.784162>, <-1.684611, -1.214238, -0.923105>, 
      <-1.534020, -1.330672, -0.471387>, <-1.647310, -1.323832, -0.562626>, <-1.735683, -1.332382, -0.783200>, <-1.710266, -1.367806, -0.922143>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.958118, -0.905602, -0.504287>, <-1.068093, -0.858508, -0.412998>, <-1.323611, -0.827897, -0.391837>, <-1.450995, -0.818357, -0.471387>, 
      <-1.064850, -1.026465, -0.532930>, <-1.174825, -0.979371, -0.441642>, <-1.346243, -0.979781, -0.366118>, <-1.473628, -0.970241, -0.445668>, 
      <-1.153184, -1.239989, -0.509916>, <-1.228564, -1.217464, -0.439961>, <-1.427308, -1.182262, -0.394983>, <-1.509211, -1.177317, -0.460943>, 
      <-1.191416, -1.399133, -0.504287>, <-1.266796, -1.376608, -0.434332>, <-1.452117, -1.335617, -0.405427>, <-1.534020, -1.330672, -0.471387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.958118, -0.905602, -0.504287>, <-1.064850, -1.026465, -0.532930>, <-1.153184, -1.239989, -0.509916>, <-1.191416, -1.399133, -0.504287>, 
      <-0.794361, -0.975727, -0.640219>, <-0.901093, -1.096591, -0.668863>, <-0.988016, -1.289346, -0.663197>, <-1.026247, -1.448489, -0.657569>, 
      <-0.641197, -1.062491, -0.934405>, <-0.691865, -1.170430, -0.896472>, <-0.929250, -1.341227, -0.999837>, <-0.947586, -1.464771, -0.992238>, 
      <-0.650991, -1.160941, -1.135460>, <-0.701659, -1.268881, -1.097527>, <-0.784083, -1.425748, -1.157934>, <-0.802419, -1.549292, -1.150336>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.000502, -0.535835, -1.535393>, <-0.840874, -0.618175, -1.584892>, <-0.572199, -0.647496, -1.373633>, <-0.424022, -0.743182, -1.433623>, 
      <-1.001272, -0.774023, -1.547995>, <-0.841644, -0.856363, -1.597495>, <-0.575311, -0.809190, -1.326838>, <-0.427134, -0.904876, -1.386829>, 
      <-0.980349, -1.061468, -1.344238>, <-0.870821, -1.065195, -1.291120>, <-0.588141, -1.069217, -1.295770>, <-0.582818, -1.015710, -1.186498>, 
      <-0.996884, -1.295287, -1.300102>, <-0.887356, -1.299014, -1.246984>, <-0.656314, -1.214448, -1.244732>, <-0.650991, -1.160941, -1.135460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.000502, -0.535835, -1.535393>, <-1.001272, -0.774023, -1.547995>, <-0.980349, -1.061468, -1.344238>, <-0.996884, -1.295287, -1.300102>, 
      <-1.000502, -0.535835, -1.535393>, <-1.086505, -0.955086, -1.520202>, <-1.076666, -1.058190, -1.390949>, <-1.093201, -1.292010, -1.346813>, 
      <-1.000502, -0.535835, -1.535393>, <-1.086505, -0.955086, -1.520202>, <-1.137164, -1.007610, -1.525099>, <-1.205792, -1.194371, -1.490006>, 
      <-1.000502, -0.535835, -1.535393>, <-1.085734, -0.716898, -1.507599>, <-1.215982, -0.952619, -1.477840>, <-1.284610, -1.139380, -1.442747>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.436976, -0.899737, -1.763540>, <-0.549581, -0.936807, -1.543232>, <-0.613524, -0.835155, -1.201901>, <-0.611995, -0.796086, -0.954795>, 
      <-0.436976, -0.899737, -1.763540>, <-0.545695, -0.889841, -1.444257>, <-0.593770, -0.710288, -1.291817>, <-0.592241, -0.671219, -1.044711>, 
      <-0.436976, -0.899737, -1.763540>, <-0.545695, -0.889841, -1.444257>, <-0.364439, -0.842913, -1.615272>, <-0.451625, -0.786612, -1.579974>, 
      <-0.436976, -0.899737, -1.763540>, <-0.433090, -0.852770, -1.664565>, <-0.336836, -0.799483, -1.468921>, <-0.424022, -0.743182, -1.433623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.436976, -0.899737, -1.763540>, <-0.426877, -1.060534, -1.756839>, <-0.294650, -1.226547, -1.637720>, <-0.225702, -1.369834, -1.610937>, 
      <-0.549581, -0.936807, -1.543232>, <-0.539483, -1.097604, -1.536531>, <-0.430857, -1.228995, -1.475824>, <-0.361909, -1.372282, -1.449041>, 
      <-0.613524, -0.835155, -1.201901>, <-0.636213, -0.978576, -1.098623>, <-0.580482, -1.244753, -1.160785>, <-0.515615, -1.409305, -1.182365>, 
      <-0.611995, -0.796086, -0.954795>, <-0.634684, -0.939507, -0.851518>, <-0.590174, -1.218862, -0.951013>, <-0.525306, -1.383413, -0.972593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.427473, -0.656893, -0.227581>, <-0.482830, -0.698651, -0.445745>, <-0.610596, -0.760337, -0.728689>, <-0.611995, -0.796086, -0.954795>, 
      <-0.439079, -0.826850, -0.217044>, <-0.494436, -0.868608, -0.435209>, <-0.633285, -0.903759, -0.625412>, <-0.634684, -0.939507, -0.851518>, 
      <-0.349144, -1.047182, -0.267779>, <-0.493125, -1.097607, -0.434332>, <-0.600519, -1.191224, -0.727088>, <-0.590174, -1.218862, -0.951013>, 
      <-0.287151, -1.205666, -0.280856>, <-0.431132, -1.256091, -0.447409>, <-0.535651, -1.355775, -0.748669>, <-0.525306, -1.383413, -0.972593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.491604, -0.606664, -0.316481>, <-0.471329, -0.647620, -0.651624>, <-0.363839, -0.648490, -1.114530>, <-0.424022, -0.743182, -1.433623>, 
      <-0.461410, -0.620924, -0.302570>, <-0.441136, -0.661879, -0.637713>, <-0.391442, -0.691920, -1.260881>, <-0.451625, -0.786612, -1.579974>, 
      <-0.460593, -0.664951, -0.239690>, <-0.515950, -0.706709, -0.457854>, <-0.590842, -0.635471, -0.818606>, <-0.592241, -0.671219, -1.044711>, 
      <-0.427473, -0.656893, -0.227581>, <-0.482830, -0.698651, -0.445745>, <-0.610596, -0.760337, -0.728689>, <-0.611995, -0.796086, -0.954795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.491604, -0.606664, -0.316481>, <-0.554583, -0.770401, -0.311159>, <-0.843733, -0.776072, -0.473590>, <-0.958118, -0.905602, -0.504287>, 
      <-0.471329, -0.647620, -0.651624>, <-0.534308, -0.811356, -0.646302>, <-0.679976, -0.846197, -0.609522>, <-0.794361, -0.975727, -0.640219>, 
      <-0.363839, -0.648490, -1.114530>, <-0.366950, -0.810184, -1.067736>, <-0.573024, -0.917260, -0.985443>, <-0.641197, -1.062491, -0.934405>, 
      <-0.424022, -0.743182, -1.433623>, <-0.427134, -0.904876, -1.386829>, <-0.582818, -1.015710, -1.186498>, <-0.650991, -1.160941, -1.135460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.770662, -0.579480, -2.445914>, <0.770569, -0.358233, -2.448834>, <0.776400, -0.164595, -2.128216>, <0.840311, 0.008794, -2.006517>, 
      <0.984841, -0.576604, -2.459060>, <0.984748, -0.355357, -2.461980>, <0.950016, -0.172898, -2.138186>, <1.013926, 0.000491, -2.016487>, 
      <1.271273, -0.568263, -2.445672>, <1.251438, -0.406484, -2.313956>, <1.265721, -0.176076, -2.138232>, <1.245886, -0.014297, -2.006517>, 
      <1.485820, -0.563455, -2.445568>, <1.465985, -0.401676, -2.313853>, <1.439539, -0.185972, -2.138232>, <1.419704, -0.024193, -2.006517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.770662, -0.579480, -2.445914>, <0.984841, -0.576604, -2.459060>, <1.271273, -0.568263, -2.445672>, <1.485820, -0.563455, -2.445568>, 
      <0.770778, -0.854381, -2.442286>, <0.984957, -0.851505, -2.455432>, <1.261537, -0.810300, -2.308399>, <1.476084, -0.805493, -2.308295>, 
      <0.811080, -1.115183, -2.086194>, <0.994439, -1.115457, -2.098051>, <1.279369, -1.129972, -2.125265>, <1.463103, -1.128210, -2.125265>, 
      <0.840893, -1.370359, -1.988314>, <1.024252, -1.370632, -2.000171>, <1.269633, -1.372010, -1.987992>, <1.453367, -1.370248, -1.987992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.414209, -0.577846, -2.379793>, <0.518782, -0.577752, -2.409685>, <0.662115, -0.580938, -2.439251>, <0.770662, -0.579480, -2.445914>, 
      <0.422552, -0.852621, -2.374879>, <0.527124, -0.852526, -2.404772>, <0.662231, -0.855839, -2.435623>, <0.770778, -0.854381, -2.442286>, 
      <0.464358, -1.115229, -2.022676>, <0.561301, -1.115141, -2.050388>, <0.710464, -1.115033, -2.079687>, <0.811080, -1.115183, -2.086194>, 
      <0.510446, -1.368843, -1.927017>, <0.607389, -1.368756, -1.954729>, <0.740277, -1.370209, -1.981808>, <0.840893, -1.370359, -1.988314>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.043982, -0.580136, -2.238190>, <0.024660, -0.853708, -2.230627>, <0.104671, -1.119924, -1.887049>, <0.167230, -1.370966, -1.795745>, 
      <-0.129695, -0.645815, -2.112449>, <-0.149017, -0.919388, -2.104886>, <-0.015029, -1.120085, -1.835654>, <0.047530, -1.371127, -1.744349>, 
      <-0.336041, -0.866509, -1.961015>, <-0.325943, -1.027306, -1.954314>, <-0.210791, -1.225040, -1.737395>, <-0.141844, -1.368327, -1.710612>, 
      <-0.436976, -0.899737, -1.763540>, <-0.426877, -1.060534, -1.756839>, <-0.294650, -1.226547, -1.637720>, <-0.225702, -1.369834, -1.610937>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.043982, -0.580136, -2.238190>, <0.136080, -0.545307, -2.304869>, <0.299872, -0.577949, -2.347109>, <0.414209, -0.577846, -2.379793>, 
      <0.024660, -0.853708, -2.230627>, <0.116759, -0.818880, -2.297306>, <0.308214, -0.852724, -2.342196>, <0.422552, -0.852621, -2.374879>, 
      <0.104671, -1.119924, -1.887049>, <0.205969, -1.119787, -1.930544>, <0.358363, -1.115324, -1.992377>, <0.464358, -1.115229, -2.022676>, 
      <0.167230, -1.370966, -1.795745>, <0.268528, -1.370830, -1.839239>, <0.404451, -1.368938, -1.896718>, <0.510446, -1.368843, -1.927017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.463110, -0.207197, -1.111410>, <-1.385286, -0.275671, -1.296920>, <-1.182576, -0.441917, -1.478933>, <-1.000502, -0.535835, -1.535393>, 
      <-1.538230, -0.401296, -1.098892>, <-1.460406, -0.469770, -1.284402>, <-1.267809, -0.622981, -1.451140>, <-1.085734, -0.716898, -1.507599>, 
      <-1.584353, -0.654105, -0.954984>, <-1.551372, -0.717739, -1.147531>, <-1.367187, -0.847124, -1.387178>, <-1.215982, -0.952619, -1.477840>, 
      <-1.627239, -0.855491, -0.922143>, <-1.594258, -0.919125, -1.114690>, <-1.435814, -1.033885, -1.352085>, <-1.284610, -1.139380, -1.442747>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.367465, -0.212957, -0.660654>, <-1.469422, -0.171034, -0.744080>, <-1.513739, -0.162650, -0.990725>, <-1.463110, -0.207197, -1.111410>, 
      <-1.414789, -0.394084, -0.618333>, <-1.516745, -0.352161, -0.701758>, <-1.588859, -0.356749, -0.978206>, <-1.538230, -0.401296, -1.098892>, 
      <-1.423096, -0.631129, -0.503091>, <-1.546363, -0.621898, -0.580070>, <-1.607730, -0.609002, -0.818510>, <-1.584353, -0.654105, -0.954984>, 
      <-1.450995, -0.818357, -0.471387>, <-1.574263, -0.809125, -0.548366>, <-1.650616, -0.810388, -0.785669>, <-1.627239, -0.855491, -0.922143>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.367465, -0.212957, -0.660654>, <-1.414789, -0.394084, -0.618333>, <-1.423096, -0.631129, -0.503091>, <-1.450995, -0.818357, -0.471387>, 
      <-1.141772, -0.305758, -0.475982>, <-1.189095, -0.486886, -0.433661>, <-1.295711, -0.640669, -0.423541>, <-1.323611, -0.827897, -0.391837>, 
      <-0.747044, -0.486026, -0.434167>, <-0.810023, -0.649762, -0.428846>, <-0.953708, -0.728978, -0.382301>, <-1.068093, -0.858508, -0.412998>, 
      <-0.491604, -0.606664, -0.316481>, <-0.554583, -0.770401, -0.311159>, <-0.843733, -0.776072, -0.473590>, <-0.958118, -0.905602, -0.504287>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.030001, -0.479760, -0.125780>, <-0.111940, -0.522004, -0.151472>, <-0.289853, -0.623411, -0.177266>, <-0.427473, -0.656893, -0.227581>, 
      <0.025504, -0.682988, -0.109112>, <-0.116437, -0.725232, -0.134804>, <-0.301459, -0.793368, -0.166730>, <-0.439079, -0.826850, -0.217044>, 
      <0.100546, -0.949365, -0.169780>, <-0.032287, -0.970975, -0.193309>, <-0.262052, -1.016681, -0.167034>, <-0.349144, -1.047182, -0.267779>, 
      <0.154270, -1.145412, -0.186482>, <0.021438, -1.167022, -0.210010>, <-0.200059, -1.175164, -0.180111>, <-0.287151, -1.205666, -0.280856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.426117, -0.402850, -0.073076>, <0.306189, -0.419031, -0.089186>, <0.145289, -0.445448, -0.104912>, <0.030001, -0.479760, -0.125780>, 
      <0.425763, -0.606232, -0.053521>, <0.305835, -0.622413, -0.069631>, <0.140792, -0.648677, -0.088244>, <0.025504, -0.682988, -0.109112>, 
      <0.482735, -0.874307, -0.119647>, <0.371557, -0.889307, -0.134582>, <0.210584, -0.931463, -0.150289>, <0.100546, -0.949365, -0.169780>, 
      <0.521486, -1.074112, -0.137623>, <0.410308, -1.089112, -0.152558>, <0.264308, -1.127510, -0.166991>, <0.154270, -1.145412, -0.186482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.727227, -0.385689, -0.032119>, <0.636285, -0.387897, -0.040002>, <0.515816, -0.390748, -0.061026>, <0.426117, -0.402850, -0.073076>, 
      <0.729998, -0.588601, -0.011644>, <0.639056, -0.590809, -0.019527>, <0.515462, -0.594130, -0.041471>, <0.425763, -0.606232, -0.053521>, 
      <0.773560, -0.856935, -0.080728>, <0.689253, -0.858981, -0.088036>, <0.565889, -0.863088, -0.108477>, <0.482735, -0.874307, -0.119647>, 
      <0.800626, -1.058204, -0.099655>, <0.716319, -1.060251, -0.106963>, <0.604640, -1.062893, -0.126453>, <0.521486, -1.074112, -0.137623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.051078, -0.387677, -0.018903>, <1.057175, -0.589854, 0.001586>, <1.086534, -0.858165, -0.068139>, <1.100849, -1.060048, -0.087403>, 
      <1.129488, -0.387735, -0.017078>, <1.135585, -0.589912, 0.003412>, <1.150318, -0.858214, -0.066568>, <1.164633, -1.060097, -0.085832>, 
      <1.234094, -0.387646, -0.018495>, <1.232362, -0.589389, 0.002000>, <1.249621, -0.858308, -0.067757>, <1.249737, -1.060179, -0.087025>, 
      <1.312510, -0.386120, -0.018495>, <1.310778, -0.587863, 0.002000>, <1.313404, -0.856727, -0.067757>, <1.313520, -1.058598, -0.087025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.051078, -0.387677, -0.018903>, <0.953866, -0.387605, -0.021166>, <0.824073, -0.383338, -0.023724>, <0.727227, -0.385689, -0.032119>, 
      <1.057175, -0.589854, 0.001586>, <0.959963, -0.589783, -0.000677>, <0.826845, -0.586250, -0.003249>, <0.729998, -0.588601, -0.011644>, 
      <1.086534, -0.858165, -0.068139>, <0.996418, -0.858096, -0.070358>, <0.863340, -0.854755, -0.072946>, <0.773560, -0.856935, -0.080728>, 
      <1.100849, -1.060048, -0.087403>, <1.010733, -1.059979, -0.089622>, <0.890406, -1.056025, -0.091873>, <0.800626, -1.058204, -0.099655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.468239, 0.021311, -1.951876>, <0.576137, 0.013810, -1.984186>, <0.727744, 0.014178, -2.000052>, <0.840311, 0.008794, -2.006517>, 
      <0.384940, -0.148906, -2.066503>, <0.492839, -0.156407, -2.098813>, <0.663833, -0.159211, -2.121752>, <0.776400, -0.164595, -2.128216>, 
      <0.407489, -0.356507, -2.383751>, <0.512061, -0.356412, -2.413643>, <0.662022, -0.359691, -2.442172>, <0.770569, -0.358233, -2.448834>, 
      <0.414209, -0.577846, -2.379793>, <0.518782, -0.577752, -2.409685>, <0.662115, -0.580938, -2.439251>, <0.770662, -0.579480, -2.445914>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.267491, 0.048616, -1.834988>, <0.333350, 0.042642, -1.858455>, <0.401167, 0.025974, -1.931792>, <0.468239, 0.021311, -1.951876>, 
      <0.149029, -0.124053, -1.939195>, <0.214887, -0.130027, -1.962662>, <0.317869, -0.144244, -2.046418>, <0.384940, -0.148906, -2.066503>, 
      <0.060454, -0.346910, -2.244637>, <0.152553, -0.312082, -2.311316>, <0.293152, -0.356610, -2.351067>, <0.407489, -0.356507, -2.383751>, 
      <0.043982, -0.580136, -2.238190>, <0.136080, -0.545307, -2.304869>, <0.299872, -0.577949, -2.347109>, <0.414209, -0.577846, -2.379793>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.317550, 0.092591, -1.671879>, <-0.146894, 0.086485, -1.736781>, <0.096031, 0.064169, -1.773892>, <0.267491, 0.048616, -1.834988>, 
      <-0.494554, -0.144039, -1.729670>, <-0.323898, -0.150145, -1.794572>, <-0.022431, -0.108500, -1.878100>, <0.149029, -0.124053, -1.939195>, 
      <-0.455834, -0.599484, -1.776052>, <-0.354899, -0.566256, -1.973527>, <-0.113223, -0.412589, -2.118896>, <0.060454, -0.346910, -2.244637>, 
      <-0.436976, -0.899737, -1.763540>, <-0.336041, -0.866509, -1.961015>, <-0.129695, -0.645815, -2.112449>, <0.043982, -0.580136, -2.238190>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.627097, 0.080624, -1.494768>, <-0.537703, 0.082916, -1.553617>, <-0.417553, 0.096169, -1.633847>, <-0.317550, 0.092591, -1.671879>, 
      <-0.773790, -0.126119, -1.524189>, <-0.684395, -0.123827, -1.583038>, <-0.594557, -0.140461, -1.691638>, <-0.494554, -0.144039, -1.729670>, 
      <-0.419305, -0.498083, -1.504555>, <-0.332120, -0.554384, -1.539852>, <-0.451947, -0.552517, -1.677077>, <-0.455834, -0.599484, -1.776052>, 
      <-0.424022, -0.743182, -1.433623>, <-0.336836, -0.799483, -1.468921>, <-0.433090, -0.852770, -1.664565>, <-0.436976, -0.899737, -1.763540>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.627097, 0.080624, -1.494768>, <-0.773790, -0.126119, -1.524189>, <-0.419305, -0.498083, -1.504555>, <-0.424022, -0.743182, -1.433623>, 
      <-0.740497, 0.077716, -1.420116>, <-0.887190, -0.129027, -1.449537>, <-0.567482, -0.402396, -1.444564>, <-0.572199, -0.647496, -1.373633>, 
      <-0.895745, 0.036692, -1.314757>, <-1.049286, -0.093087, -1.356326>, <-0.840211, -0.413170, -1.574046>, <-0.840874, -0.618175, -1.584892>, 
      <-0.992453, 0.075287, -1.227585>, <-1.145994, -0.054492, -1.269154>, <-0.999839, -0.330830, -1.524546>, <-1.000502, -0.535835, -1.535393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.179605, 0.301125, -0.996738>, <-1.150708, 0.245349, -1.089435>, <-1.072197, 0.107112, -1.155704>, <-0.992453, 0.075287, -1.227585>, 
      <-1.337543, 0.219558, -1.005388>, <-1.308646, 0.163783, -1.098084>, <-1.225737, -0.022667, -1.197273>, <-1.145994, -0.054492, -1.269154>, 
      <-1.398992, -0.041525, -1.122095>, <-1.321168, -0.110000, -1.307605>, <-1.181914, -0.236912, -1.468086>, <-0.999839, -0.330830, -1.524546>, 
      <-1.463110, -0.207197, -1.111410>, <-1.385286, -0.275671, -1.296920>, <-1.182576, -0.441917, -1.478933>, <-1.000502, -0.535835, -1.535393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.142064, 0.364055, -0.747664>, <-1.205978, 0.370384, -0.791728>, <-1.199706, 0.339922, -0.932260>, <-1.179605, 0.301125, -0.996738>, 
      <-1.305480, 0.273699, -0.728964>, <-1.369394, 0.280028, -0.773028>, <-1.357644, 0.258355, -0.940909>, <-1.337543, 0.219558, -1.005388>, 
      <-1.321193, -0.035855, -0.702035>, <-1.423150, 0.006068, -0.785461>, <-1.449620, 0.003021, -1.001410>, <-1.398992, -0.041525, -1.122095>, 
      <-1.367465, -0.212957, -0.660654>, <-1.469422, -0.171034, -0.744080>, <-1.513739, -0.162650, -0.990725>, <-1.463110, -0.207197, -1.111410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.519125, 0.235722, -0.541382>, <-0.705874, 0.245427, -0.613958>, <-0.977464, 0.347756, -0.634183>, <-1.142064, 0.364055, -0.747664>, 
      <-0.673189, 0.034076, -0.477440>, <-0.859938, 0.043780, -0.550016>, <-1.140880, 0.257400, -0.615484>, <-1.305480, 0.273699, -0.728964>, 
      <-0.397699, -0.362524, -0.324416>, <-0.653139, -0.241885, -0.442102>, <-1.095500, -0.128656, -0.517363>, <-1.321193, -0.035855, -0.702035>, 
      <-0.491604, -0.606664, -0.316481>, <-0.747044, -0.486026, -0.434167>, <-1.141772, -0.305758, -0.475982>, <-1.367465, -0.212957, -0.660654>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.183361, 0.314235, -0.375083>, <-0.290021, 0.289061, -0.409436>, <-0.412202, 0.230166, -0.499829>, <-0.519125, 0.235722, -0.541382>, 
      <-0.363922, 0.079598, -0.307683>, <-0.470581, 0.054424, -0.342036>, <-0.566266, 0.028519, -0.435886>, <-0.673189, 0.034076, -0.477440>, 
      <-0.406826, -0.354533, -0.246326>, <-0.439946, -0.362591, -0.258435>, <-0.367505, -0.376783, -0.310505>, <-0.397699, -0.362524, -0.324416>, 
      <-0.427473, -0.656893, -0.227581>, <-0.460593, -0.664951, -0.239690>, <-0.461410, -0.620924, -0.302570>, <-0.491604, -0.606664, -0.316481>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.188526, 0.402744, -0.313458>, <0.076152, 0.376876, -0.327484>, <-0.075481, 0.339697, -0.340336>, <-0.183361, 0.314235, -0.375083>, 
      <0.048484, 0.177677, -0.240944>, <-0.063890, 0.151810, -0.254970>, <-0.256041, 0.105061, -0.272936>, <-0.363922, 0.079598, -0.307683>, 
      <0.036060, -0.205928, -0.148239>, <-0.105881, -0.248172, -0.173931>, <-0.269205, -0.321051, -0.196011>, <-0.406826, -0.354533, -0.246326>, 
      <0.030001, -0.479760, -0.125780>, <-0.111940, -0.522004, -0.151472>, <-0.289853, -0.623411, -0.177266>, <-0.427473, -0.656893, -0.227581>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.524188, 0.477107, -0.286771>, <0.422563, 0.460384, -0.296502>, <0.288602, 0.425781, -0.300967>, <0.188526, 0.402744, -0.313458>, 
      <0.411151, 0.239889, -0.211839>, <0.309526, 0.223165, -0.221570>, <0.148561, 0.200714, -0.228453>, <0.048484, 0.177677, -0.240944>, 
      <0.426591, -0.130856, -0.099228>, <0.306663, -0.147037, -0.115338>, <0.151348, -0.171617, -0.127371>, <0.036060, -0.205928, -0.148239>, 
      <0.426117, -0.402850, -0.073076>, <0.306189, -0.419031, -0.089186>, <0.145289, -0.445448, -0.104912>, <0.030001, -0.479760, -0.125780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.779344, 0.499969, -0.256883>, <0.702281, 0.496466, -0.262871>, <0.600197, 0.489615, -0.279493>, <0.524188, 0.477107, -0.286771>, 
      <0.697668, 0.250138, -0.177510>, <0.620605, 0.246636, -0.183498>, <0.487161, 0.252397, -0.204560>, <0.411151, 0.239889, -0.211839>, 
      <0.723496, -0.112536, -0.059682>, <0.632554, -0.114744, -0.067565>, <0.516290, -0.118754, -0.087178>, <0.426591, -0.130856, -0.099228>, 
      <0.727227, -0.385689, -0.032119>, <0.636285, -0.387897, -0.040002>, <0.515816, -0.390748, -0.061026>, <0.426117, -0.402850, -0.073076>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.053769, 0.501177, -0.245623>, <0.971390, 0.500790, -0.247317>, <0.861410, 0.503699, -0.250507>, <0.779344, 0.499969, -0.256883>, 
      <0.987553, 0.247547, -0.161841>, <0.905174, 0.247160, -0.163535>, <0.779734, 0.253869, -0.171134>, <0.697668, 0.250138, -0.177510>, 
      <1.042825, -0.114007, -0.046638>, <0.945614, -0.113936, -0.048901>, <0.820343, -0.110185, -0.051287>, <0.723496, -0.112536, -0.059682>, 
      <1.051078, -0.387677, -0.018903>, <0.953866, -0.387605, -0.021166>, <0.824073, -0.383338, -0.023724>, <0.727227, -0.385689, -0.032119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.053769, 0.501177, -0.245623>, <1.098831, 0.673780, -0.302639>, <1.273411, 0.845969, -0.411997>, <1.404910, 0.967623, -0.466602>, 
      <1.053769, 0.501177, -0.245623>, <1.180759, 0.674165, -0.300955>, <1.316804, 0.709668, -0.349161>, <1.448303, 0.831322, -0.403766>, 
      <1.053769, 0.501177, -0.245623>, <1.180759, 0.674165, -0.300955>, <1.255092, 0.648962, -0.294616>, <1.337022, 0.650551, -0.294616>, 
      <1.053769, 0.501177, -0.245623>, <1.135697, 0.501562, -0.243938>, <1.244989, 0.500952, -0.245623>, <1.326920, 0.502541, -0.245623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.053769, 0.501177, -0.245623>, <0.987553, 0.247547, -0.161841>, <1.042825, -0.114007, -0.046638>, <1.051078, -0.387677, -0.018903>, 
      <1.135697, 0.501562, -0.243938>, <1.069481, 0.247932, -0.160156>, <1.121235, -0.114065, -0.044812>, <1.129488, -0.387735, -0.017078>, 
      <1.244989, 0.500952, -0.245623>, <1.227194, 0.240238, -0.159323>, <1.236444, -0.113863, -0.046309>, <1.234094, -0.387646, -0.018495>, 
      <1.326920, 0.502541, -0.245623>, <1.309125, 0.241827, -0.159323>, <1.314860, -0.112337, -0.046309>, <1.312510, -0.386120, -0.018495>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.053769, 0.501177, -0.245623>, <1.135697, 0.501562, -0.243938>, <1.244989, 0.500952, -0.245623>, <1.326920, 0.502541, -0.245623>, 
      <1.098831, 0.673780, -0.302639>, <1.180759, 0.674165, -0.300955>, <1.333292, 0.502665, -0.245623>, <1.415223, 0.504253, -0.245623>, 
      <1.273411, 0.845969, -0.411997>, <1.338286, 0.709337, -0.345704>, <1.508435, 0.666166, -0.295482>, <1.532864, 0.511207, -0.243875>, 
      <1.404910, 0.967623, -0.466602>, <1.469785, 0.830990, -0.400308>, <1.596732, 0.667139, -0.297230>, <1.621161, 0.512180, -0.245623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.039719, 0.700356, -1.519033>, <1.098470, 0.697425, -1.536420>, <1.180951, 0.697384, -1.543731>, <1.242090, 0.699494, -1.548219>, 
      <0.868275, 0.496642, -1.648886>, <0.927026, 0.493711, -1.666272>, <1.060417, 0.490175, -1.681221>, <1.121556, 0.492284, -1.685708>, 
      <0.579654, 0.248983, -1.798558>, <0.687552, 0.241482, -1.830868>, <0.807564, 0.230728, -1.848058>, <0.920131, 0.225345, -1.854523>, 
      <0.468239, 0.021311, -1.951876>, <0.576137, 0.013810, -1.984186>, <0.727744, 0.014178, -2.000052>, <0.840311, 0.008794, -2.006517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.174319, 0.981876, -0.466602>, <1.055827, 0.837304, -0.403686>, <0.838015, 0.679432, -0.313899>, <0.779344, 0.499969, -0.256883>, 
      <1.243107, 0.981444, -0.458125>, <1.124614, 0.836871, -0.395209>, <0.920081, 0.683162, -0.307523>, <0.861410, 0.503699, -0.250507>, 
      <1.385660, 1.028089, -0.494478>, <1.254161, 0.906436, -0.439873>, <1.016452, 0.673393, -0.304333>, <0.971390, 0.500790, -0.247317>, 
      <1.404910, 0.967623, -0.466602>, <1.273411, 0.845969, -0.411997>, <1.098831, 0.673780, -0.302639>, <1.053769, 0.501177, -0.245623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.080132, 0.969665, -0.506625>, <0.913349, 0.821898, -0.440669>, <0.620320, 0.678849, -0.350497>, <0.524188, 0.477107, -0.286771>, 
      <1.107510, 0.970947, -0.492314>, <0.940726, 0.823180, -0.426358>, <0.696329, 0.691357, -0.343219>, <0.600197, 0.489615, -0.279493>, 
      <1.143633, 0.982069, -0.470384>, <1.025140, 0.837497, -0.407468>, <0.760952, 0.675929, -0.319887>, <0.702281, 0.496466, -0.262871>, 
      <1.174319, 0.981876, -0.466602>, <1.055827, 0.837304, -0.403686>, <0.838015, 0.679432, -0.313899>, <0.779344, 0.499969, -0.256883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.932414, 0.970546, -0.593055>, <0.709248, 0.800205, -0.509176>, <0.337838, 0.642709, -0.390773>, <0.188526, 0.402744, -0.313458>, 
      <0.976044, 0.977487, -0.566893>, <0.752878, 0.807147, -0.483014>, <0.437914, 0.665746, -0.378282>, <0.288602, 0.425781, -0.300967>, 
      <1.034669, 0.967536, -0.530390>, <0.867885, 0.819768, -0.464434>, <0.518695, 0.662125, -0.360228>, <0.422563, 0.460384, -0.296502>, 
      <1.080132, 0.969665, -0.506625>, <0.913349, 0.821898, -0.440669>, <0.620320, 0.678849, -0.350497>, <0.524188, 0.477107, -0.286771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.788513, 0.923270, -0.681489>, <0.496951, 0.740560, -0.589567>, <0.028421, 0.589444, -0.454138>, <-0.183361, 0.314235, -0.375083>, 
      <0.830230, 0.934824, -0.651575>, <0.538668, 0.752113, -0.559653>, <0.136301, 0.614906, -0.419391>, <-0.075481, 0.339697, -0.340336>, 
      <0.887701, 0.963432, -0.619866>, <0.664535, 0.793092, -0.535987>, <0.225464, 0.616842, -0.404799>, <0.076152, 0.376876, -0.327484>, 
      <0.932414, 0.970546, -0.593055>, <0.709248, 0.800205, -0.509176>, <0.337838, 0.642709, -0.390773>, <0.188526, 0.402744, -0.313458>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.654662, 0.893620, -0.792224>, <0.302526, 0.696251, -0.716971>, <-0.277382, 0.552126, -0.641714>, <-0.519125, 0.235722, -0.541382>, 
      <0.690704, 0.903266, -0.754767>, <0.338568, 0.705897, -0.679514>, <-0.170459, 0.546569, -0.600161>, <-0.412202, 0.230166, -0.499829>, 
      <0.746597, 0.911661, -0.711546>, <0.455035, 0.728950, -0.619624>, <-0.078238, 0.564270, -0.488491>, <-0.290021, 0.289061, -0.409436>, 
      <0.788513, 0.923270, -0.681489>, <0.496951, 0.740560, -0.589567>, <0.028421, 0.589444, -0.454138>, <-0.183361, 0.314235, -0.375083>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.592729, 0.870871, -0.884960>, <0.072291, 0.718826, -0.843771>, <-0.668573, 0.625857, -0.801846>, <-1.142064, 0.364055, -0.747664>, 
      <0.605528, 0.878530, -0.854247>, <0.085090, 0.726486, -0.813058>, <-0.503973, 0.609558, -0.688365>, <-0.977464, 0.347756, -0.634183>, 
      <0.631386, 0.887390, -0.816415>, <0.279249, 0.690021, -0.741162>, <-0.464131, 0.561830, -0.714291>, <-0.705874, 0.245427, -0.613958>, 
      <0.654662, 0.893620, -0.792224>, <0.302526, 0.696251, -0.716971>, <-0.277382, 0.552126, -0.641714>, <-0.519125, 0.235722, -0.541382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.568001, 0.841761, -1.000175>, <0.043719, 0.679570, -0.999144>, <-0.692572, 0.552651, -0.970065>, <-1.179605, 0.301125, -0.996738>, 
      <0.569684, 0.852577, -0.965445>, <0.045402, 0.690386, -0.964414>, <-0.712672, 0.591448, -0.905587>, <-1.199706, 0.339922, -0.932260>, 
      <0.579079, 0.862702, -0.917716>, <0.058640, 0.710658, -0.876527>, <-0.732487, 0.632186, -0.845910>, <-1.205978, 0.370384, -0.791728>, 
      <0.592729, 0.870871, -0.884960>, <0.072291, 0.718826, -0.843771>, <-0.668573, 0.625857, -0.801846>, <-1.142064, 0.364055, -0.747664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.581971, 0.801732, -1.106961>, <0.109644, 0.583799, -1.143148>, <-0.602464, 0.404921, -1.122001>, <-0.992453, 0.075287, -1.227585>, 
      <0.569710, 0.810993, -1.076107>, <0.097383, 0.593059, -1.112294>, <-0.682208, 0.436746, -1.050120>, <-1.072197, 0.107112, -1.155704>, 
      <0.566408, 0.831523, -1.033049>, <0.042126, 0.669332, -1.032018>, <-0.663674, 0.496876, -1.062762>, <-1.150708, 0.245349, -1.089435>, 
      <0.568001, 0.841761, -1.000175>, <0.043719, 0.679570, -0.999144>, <-0.692572, 0.552651, -0.970065>, <-1.179605, 0.301125, -0.996738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.654305, 0.776574, -1.217351>, <0.269884, 0.567789, -1.300576>, <-0.371129, 0.441376, -1.443431>, <-0.627097, 0.080624, -1.494768>, 
      <0.629488, 0.784184, -1.186516>, <0.245068, 0.575399, -1.269741>, <-0.484530, 0.438468, -1.368778>, <-0.740497, 0.077716, -1.420116>, 
      <0.596309, 0.790902, -1.143041>, <0.123981, 0.572969, -1.179228>, <-0.505756, 0.366325, -1.209173>, <-0.895745, 0.036692, -1.314757>, 
      <0.581971, 0.801732, -1.106961>, <0.109644, 0.583799, -1.143148>, <-0.602464, 0.404921, -1.122001>, <-0.992453, 0.075287, -1.227585>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.788404, 0.738432, -1.363459>, <0.456618, 0.544680, -1.455985>, <-0.085233, 0.403168, -1.596028>, <-0.317550, 0.092591, -1.671879>, 
      <0.743104, 0.748468, -1.324500>, <0.411318, 0.554716, -1.417026>, <-0.185235, 0.406747, -1.557997>, <-0.417553, 0.096169, -1.633847>, 
      <0.691608, 0.765136, -1.263701>, <0.307187, 0.556351, -1.346926>, <-0.281735, 0.443668, -1.502280>, <-0.537703, 0.082916, -1.553617>, 
      <0.654305, 0.776574, -1.217351>, <0.269884, 0.567789, -1.300576>, <-0.371129, 0.441376, -1.443431>, <-0.627097, 0.080624, -1.494768>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.932491, 0.714942, -1.456598>, <0.964098, 0.710153, -1.476164>, <1.003820, 0.702147, -1.508409>, <1.039719, 0.700356, -1.519033>, 
      <0.732991, 0.515044, -1.570115>, <0.764598, 0.510255, -1.589681>, <0.832376, 0.498434, -1.638262>, <0.868275, 0.496642, -1.648886>, 
      <0.421651, 0.273317, -1.699379>, <0.487509, 0.267343, -1.722846>, <0.512582, 0.253646, -1.778474>, <0.579654, 0.248983, -1.798558>, 
      <0.267491, 0.048616, -1.834988>, <0.333350, 0.042642, -1.858455>, <0.401167, 0.025974, -1.931792>, <0.468239, 0.021311, -1.951876>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.932491, 0.714942, -1.456598>, <0.732991, 0.515044, -1.570115>, <0.421651, 0.273317, -1.699379>, <0.267491, 0.048616, -1.834988>, 
      <0.888681, 0.721580, -1.429478>, <0.689181, 0.521682, -1.542995>, <0.250191, 0.288870, -1.638283>, <0.096031, 0.064169, -1.773892>, 
      <0.827248, 0.729826, -1.396866>, <0.495462, 0.536074, -1.489392>, <0.085423, 0.397062, -1.660931>, <-0.146894, 0.086485, -1.736781>, 
      <0.788404, 0.738432, -1.363459>, <0.456618, 0.544680, -1.455985>, <-0.085233, 0.403168, -1.596028>, <-0.317550, 0.092591, -1.671879>
    }
  }
  texture {
    BlueLeather
    translate <0.013563, 0.000000, 0.023018>
  }
  rotate <90.0, 0.0, 180.0>
  translate  <-17.050459, -4.075115, -0.044723>
}
#declare Head1 = merge {
  cone { // Cone2
    <0,0,0>, 0.6, <0,0,1>, 1.0
    hollow
    scale <0.9, 0.9, 1.23>
    rotate 180.0*x
    translate  1.5*z
  }
  sphere { // Sphere2
    <0,0,0>,1
    hollow
    scale <0.9, 0.9, 1.25>
  }
  texture {
    Xenon
  }
  hollow
  scale <1.0, 1.2, 1.0>
  translate  <-1.56957, -1.33306, 1.8>
}
#declare crwnDone = difference {
  cone { // Lady_Crown
    <0,0,0>, 0.86, <0,0,1>, 1.0
    open
    texture {
      Yellow
    }
    hollow
    scale <1.0, 1.0, 0.2>
    translate  <-116.557454, -105.091784, 11.905276>
  }
  cylinder { // CntrCut
    <0,0,1>, <0,0,0>, 1 
    texture {
      DoorKnob
    }
    scale <0.172414, 0.282876, 0.269343>
    rotate <35.0, -90.0, 0.0>
    translate  <-117.110159, -105.559559, 12.155294>
  }
  rotate <-0.0, -0.0, 110.605736>
  translate  <-140.561397, 70.750067, -9.677566>
}
#declare HoleHead1 = union {
  object { Head1 }
  object { crwnDone }
  scale <0.75, 0.7, 1.0>
  rotate -18.0*z
  translate  <-17.074506, -4.503429, 0.069272>
}
#declare Xenon_Face = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.674714, -0.304630, -0.733588>, <1.682541, -0.218209, -0.728270>, <1.675437, -0.103439, -0.707526>, <1.674729, -0.017007, -0.698185>, 
      <1.695867, -0.314479, -0.756055>, <1.703695, -0.228057, -0.750737>, <1.692229, -0.106546, -0.715281>, <1.691520, -0.020114, -0.705940>, 
      <1.718330, -0.316558, -0.794547>, <1.708770, -0.210553, -0.772902>, <1.708854, -0.090355, -0.729043>, <1.704012, 0.015736, -0.706280>, 
      <1.741094, -0.320699, -0.817217>, <1.731534, -0.214694, -0.795572>, <1.725440, -0.081969, -0.731558>, <1.720598, 0.024122, -0.708795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.670677, 0.187894, -0.680357>, <1.685423, 0.185195, -0.687230>, <1.702290, 0.186982, -0.703224>, <1.717946, 0.186530, -0.708388>, 
      <1.672911, 0.133486, -0.709399>, <1.687657, 0.130787, -0.716272>, <1.701753, 0.144797, -0.727609>, <1.717409, 0.144345, -0.732773>, 
      <1.674226, 0.044348, -0.691554>, <1.691017, 0.041242, -0.699309>, <1.701840, 0.063333, -0.696068>, <1.718426, 0.071719, -0.698583>, 
      <1.674729, -0.017007, -0.698185>, <1.691520, -0.020114, -0.705940>, <1.704012, 0.015736, -0.706280>, <1.720598, 0.024122, -0.708795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.653722, 0.494650, -0.425069>, <1.674416, 0.501947, -0.427985>, <1.704603, 0.502253, -0.430913>, <1.726699, 0.503140, -0.431895>, 
      <1.658808, 0.402623, -0.501655>, <1.679502, 0.409920, -0.504572>, <1.701977, 0.407270, -0.513861>, <1.724073, 0.408157, -0.514843>, 
      <1.666339, 0.293541, -0.623964>, <1.681086, 0.290842, -0.630837>, <1.703681, 0.296174, -0.640104>, <1.719337, 0.295723, -0.645268>, 
      <1.670677, 0.187894, -0.680357>, <1.685423, 0.185195, -0.687230>, <1.702290, 0.186982, -0.703224>, <1.717946, 0.186530, -0.708388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.410904, 0.178764, -0.495807>, <1.374150, 0.154446, -0.437142>, <1.344566, 0.117788, -0.350229>, <1.316135, 0.091656, -0.287839>, 
      <1.411828, 0.144922, -0.520008>, <1.375075, 0.120604, -0.461343>, <1.343572, 0.068450, -0.366692>, <1.315142, 0.042318, -0.304302>, 
      <1.424255, 0.090861, -0.536841>, <1.381499, 0.060744, -0.475684>, <1.346225, 0.014011, -0.408076>, <1.312957, -0.023524, -0.345150>, 
      <1.425289, 0.050324, -0.546194>, <1.382533, 0.020207, -0.485037>, <1.347665, -0.037256, -0.399366>, <1.314397, -0.074791, -0.336440>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.410904, 0.178764, -0.495807>, <1.374150, 0.154446, -0.437142>, <1.344566, 0.117788, -0.350229>, <1.316135, 0.091656, -0.287839>, 
      <1.408825, 0.254862, -0.441389>, <1.372072, 0.230544, -0.382723>, <1.345590, 0.168635, -0.333263>, <1.317159, 0.142503, -0.270873>, 
      <1.414070, 0.341578, -0.350354>, <1.376345, 0.314662, -0.317177>, <1.347915, 0.254468, -0.262793>, <1.319622, 0.208735, -0.243915>, 
      <1.415427, 0.411356, -0.288017>, <1.377702, 0.384439, -0.254840>, <1.349409, 0.304645, -0.243969>, <1.321116, 0.258912, -0.225091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.420415, -0.194070, -0.581832>, <1.421877, -0.120752, -0.571141>, <1.427131, -0.021864, -0.562850>, <1.425289, 0.050324, -0.546194>, 
      <1.361859, -0.214293, -0.480187>, <1.363322, -0.140974, -0.469495>, <1.384375, -0.051982, -0.501693>, <1.382533, 0.020207, -0.485037>, 
      <1.314382, -0.207384, -0.248954>, <1.306484, -0.137327, -0.291278>, <1.349940, -0.118293, -0.385599>, <1.347665, -0.037256, -0.399366>, 
      <1.327736, -0.321453, -0.217658>, <1.319838, -0.251396, -0.259982>, <1.316673, -0.155828, -0.322673>, <1.314397, -0.074791, -0.336440>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.420415, -0.194070, -0.581832>, <1.424989, -0.140309, -0.598692>, <1.468193, -0.079060, -0.625278>, <1.488670, -0.029770, -0.643898>, 
      <1.420415, -0.194070, -0.581832>, <1.426451, -0.066990, -0.588001>, <1.440338, -0.063893, -0.597135>, <1.460814, -0.014603, -0.615754>, 
      <1.420415, -0.194070, -0.581832>, <1.426451, -0.066990, -0.588001>, <1.446145, -0.045893, -0.592161>, <1.444303, 0.026296, -0.575505>, 
      <1.420415, -0.194070, -0.581832>, <1.421877, -0.120752, -0.571141>, <1.427131, -0.021864, -0.562850>, <1.425289, 0.050324, -0.546194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.509976, 0.219910, -0.597241>, <1.476892, 0.213667, -0.568462>, <1.433090, 0.193443, -0.531219>, <1.410904, 0.178764, -0.495807>, 
      <1.511818, 0.287762, -0.553925>, <1.478734, 0.281520, -0.525146>, <1.431011, 0.269542, -0.476801>, <1.408825, 0.254862, -0.441389>, 
      <1.514217, 0.344562, -0.456729>, <1.478652, 0.335676, -0.431379>, <1.443571, 0.362627, -0.376298>, <1.414070, 0.341578, -0.350354>, 
      <1.516034, 0.397984, -0.396509>, <1.480470, 0.389099, -0.371159>, <1.444927, 0.432404, -0.313961>, <1.415427, 0.411356, -0.288017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.506881, 0.060795, -0.611766>, <1.480021, 0.061255, -0.595204>, <1.442058, 0.062136, -0.570179>, <1.425289, 0.050324, -0.546194>, 
      <1.507810, 0.108530, -0.607409>, <1.480949, 0.108990, -0.590846>, <1.441023, 0.102673, -0.560826>, <1.424255, 0.090861, -0.536841>, 
      <1.508879, 0.179511, -0.623031>, <1.475795, 0.173268, -0.594253>, <1.434014, 0.159601, -0.555420>, <1.411828, 0.144922, -0.520008>, 
      <1.509976, 0.219910, -0.597241>, <1.476892, 0.213667, -0.568462>, <1.433090, 0.193443, -0.531219>, <1.410904, 0.178764, -0.495807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.582976, 0.211233, -0.645485>, <1.559904, 0.215830, -0.633552>, <1.529680, 0.223628, -0.614381>, <1.509976, 0.219910, -0.597241>, 
      <1.582043, 0.298592, -0.594488>, <1.558971, 0.303188, -0.582555>, <1.531522, 0.291481, -0.571065>, <1.511818, 0.287762, -0.553925>, 
      <1.588113, 0.381905, -0.482519>, <1.565103, 0.365751, -0.477746>, <1.536972, 0.350247, -0.472948>, <1.514217, 0.344562, -0.456729>, 
      <1.590314, 0.455050, -0.412676>, <1.567304, 0.438896, -0.407903>, <1.538789, 0.403669, -0.412729>, <1.516034, 0.397984, -0.396509>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.582976, 0.211233, -0.645485>, <1.582043, 0.298592, -0.594488>, <1.588113, 0.381905, -0.482519>, <1.590314, 0.455050, -0.412676>, 
      <1.608486, 0.206151, -0.658679>, <1.607554, 0.293509, -0.607683>, <1.606456, 0.394783, -0.486324>, <1.608658, 0.467928, -0.416481>, 
      <1.644597, 0.192667, -0.668202>, <1.640259, 0.298314, -0.611809>, <1.637556, 0.395129, -0.498661>, <1.632469, 0.487156, -0.422074>, 
      <1.670677, 0.187894, -0.680357>, <1.666339, 0.293541, -0.623964>, <1.658808, 0.402623, -0.501655>, <1.653722, 0.494650, -0.425069>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.594666, 0.047422, -0.650633>, <1.570762, 0.058502, -0.638326>, <1.531630, 0.060371, -0.627027>, <1.506881, 0.060795, -0.611766>, 
      <1.591159, 0.096565, -0.649089>, <1.567255, 0.107645, -0.636782>, <1.532559, 0.108105, -0.622669>, <1.507810, 0.108530, -0.607409>, 
      <1.583430, 0.168665, -0.670335>, <1.560358, 0.173262, -0.658401>, <1.528584, 0.183229, -0.640171>, <1.508879, 0.179511, -0.623031>, 
      <1.582976, 0.211233, -0.645485>, <1.559904, 0.215830, -0.633552>, <1.529680, 0.223628, -0.614381>, <1.509976, 0.219910, -0.597241>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.594666, 0.047422, -0.650633>, <1.591159, 0.096565, -0.649089>, <1.583430, 0.168665, -0.670335>, <1.582976, 0.211233, -0.645485>, 
      <1.622590, 0.034478, -0.665010>, <1.619083, 0.083622, -0.663466>, <1.608941, 0.163583, -0.683529>, <1.608486, 0.206151, -0.658679>, 
      <1.644315, -0.011380, -0.684138>, <1.643812, 0.049975, -0.677507>, <1.646830, 0.138259, -0.697245>, <1.644597, 0.192667, -0.668202>, 
      <1.674729, -0.017007, -0.698185>, <1.674226, 0.044348, -0.691554>, <1.672911, 0.133486, -0.709399>, <1.670677, 0.187894, -0.680357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.565988, -0.239171, -0.631233>, <1.574301, -0.173885, -0.637728>, <1.565912, -0.090109, -0.671135>, <1.565879, -0.026225, -0.688236>, 
      <1.527323, -0.222361, -0.608159>, <1.535636, -0.157075, -0.614654>, <1.540306, -0.091865, -0.663664>, <1.540273, -0.027981, -0.680765>, 
      <1.444058, -0.185905, -0.622872>, <1.448632, -0.132144, -0.639733>, <1.485754, -0.088621, -0.643020>, <1.506231, -0.039331, -0.661640>, 
      <1.420415, -0.194070, -0.581832>, <1.424989, -0.140309, -0.598692>, <1.468193, -0.079060, -0.625278>, <1.488670, -0.029770, -0.643898>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.565988, -0.239171, -0.631233>, <1.605337, -0.256279, -0.654715>, <1.642772, -0.289758, -0.699662>, <1.674714, -0.304630, -0.733588>, 
      <1.574301, -0.173885, -0.637728>, <1.613650, -0.190992, -0.661210>, <1.650600, -0.203337, -0.694343>, <1.682541, -0.218209, -0.728270>, 
      <1.565912, -0.090109, -0.671135>, <1.597434, -0.087946, -0.680332>, <1.642782, -0.106204, -0.704542>, <1.675437, -0.103439, -0.707526>, 
      <1.565879, -0.026225, -0.688236>, <1.597401, -0.024063, -0.697433>, <1.642074, -0.019772, -0.695200>, <1.674729, -0.017007, -0.698185>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.796306, -0.326750, -0.854676>, <1.794693, -0.210455, -0.833586>, <1.790865, -0.072470, -0.745464>, <1.791367, 0.041967, -0.715869>, 
      <1.816076, -0.326104, -0.836115>, <1.814463, -0.209809, -0.815025>, <1.814285, -0.073013, -0.745464>, <1.814787, 0.041424, -0.715869>, 
      <1.842749, -0.326229, -0.811637>, <1.846355, -0.221520, -0.791807>, <1.843640, -0.073524, -0.729311>, <1.845667, 0.031644, -0.711822>, 
      <1.862205, -0.324596, -0.792807>, <1.865811, -0.219887, -0.772976>, <1.864156, -0.084420, -0.726285>, <1.866184, 0.020748, -0.708795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.796306, -0.326750, -0.854676>, <1.794693, -0.210455, -0.833586>, <1.790865, -0.072470, -0.745464>, <1.791367, 0.041967, -0.715869>, 
      <1.779742, -0.324935, -0.843438>, <1.778129, -0.208640, -0.822348>, <1.768873, -0.071960, -0.745464>, <1.769375, 0.042477, -0.715869>, 
      <1.755218, -0.323269, -0.831283>, <1.745658, -0.217264, -0.809637>, <1.744894, -0.072133, -0.734507>, <1.740052, 0.033958, -0.711745>, 
      <1.741094, -0.320699, -0.817217>, <1.731534, -0.214694, -0.795572>, <1.725440, -0.081969, -0.731558>, <1.720598, 0.024122, -0.708795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.798549, 0.184205, -0.722535>, <1.796394, 0.141534, -0.720535>, <1.791549, 0.083377, -0.705160>, <1.791367, 0.041967, -0.715869>, 
      <1.773995, 0.184762, -0.722535>, <1.771840, 0.142091, -0.720535>, <1.769557, 0.083886, -0.705160>, <1.769375, 0.042477, -0.715869>, 
      <1.741262, 0.185857, -0.716078>, <1.740724, 0.143672, -0.740464>, <1.737880, 0.081556, -0.701532>, <1.740052, 0.033958, -0.711745>, 
      <1.717946, 0.186530, -0.708388>, <1.717409, 0.144345, -0.732773>, <1.718426, 0.071719, -0.698583>, <1.720598, 0.024122, -0.708795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.798549, 0.184205, -0.722535>, <1.820984, 0.183696, -0.722535>, <1.850808, 0.183239, -0.715789>, <1.871992, 0.183033, -0.708388>, 
      <1.796394, 0.141534, -0.720535>, <1.818829, 0.141024, -0.720535>, <1.850297, 0.141064, -0.740169>, <1.871481, 0.140858, -0.732767>, 
      <1.791549, 0.083377, -0.705160>, <1.814969, 0.082834, -0.705160>, <1.846594, 0.079692, -0.703831>, <1.867110, 0.068796, -0.700805>, 
      <1.791367, 0.041967, -0.715869>, <1.814787, 0.041424, -0.715869>, <1.845667, 0.031644, -0.711822>, <1.866184, 0.020748, -0.708795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.807302, 0.500815, -0.431895>, <1.804676, 0.405832, -0.519087>, <1.801175, 0.279188, -0.635343>, <1.798549, 0.184205, -0.722535>, 
      <1.783121, 0.501513, -0.431895>, <1.780495, 0.406529, -0.519087>, <1.776621, 0.279745, -0.635343>, <1.773995, 0.184762, -0.722535>, 
      <1.750847, 0.504109, -0.432968>, <1.748221, 0.409126, -0.515916>, <1.742652, 0.295050, -0.652959>, <1.741262, 0.185857, -0.716078>, 
      <1.726699, 0.503140, -0.431895>, <1.724073, 0.408157, -0.514843>, <1.719337, 0.295723, -0.645268>, <1.717946, 0.186530, -0.708388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.807302, 0.500815, -0.431895>, <1.826709, 0.500502, -0.431895>, <1.852675, 0.501405, -0.432854>, <1.871992, 0.499770, -0.431895>, 
      <1.804676, 0.405832, -0.519087>, <1.824083, 0.405519, -0.519087>, <1.852675, 0.406384, -0.515802>, <1.871992, 0.404749, -0.514843>, 
      <1.801175, 0.279188, -0.635343>, <1.823610, 0.278679, -0.635343>, <1.852132, 0.292433, -0.652669>, <1.873316, 0.292227, -0.645268>, 
      <1.798549, 0.184205, -0.722535>, <1.820984, 0.183696, -0.722535>, <1.850808, 0.183239, -0.715789>, <1.871992, 0.183033, -0.708388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.928936, -0.315616, -0.726309>, <1.916851, -0.227787, -0.722495>, <1.912952, -0.110041, -0.706327>, <1.911240, -0.021693, -0.698185>, 
      <1.909175, -0.324276, -0.744761>, <1.897090, -0.236447, -0.740948>, <1.895687, -0.112861, -0.713321>, <1.893975, -0.024513, -0.705180>, 
      <1.882568, -0.322887, -0.773098>, <1.886174, -0.218177, -0.753268>, <1.880656, -0.093182, -0.723850>, <1.882684, 0.011986, -0.706361>, 
      <1.862205, -0.324596, -0.792807>, <1.865811, -0.219887, -0.772976>, <1.864156, -0.084420, -0.726285>, <1.866184, 0.020748, -0.708795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.919274, 0.183033, -0.680357>, <1.915707, 0.128714, -0.709396>, <1.910050, 0.039733, -0.692524>, <1.911240, -0.021693, -0.698185>, 
      <1.904462, 0.180757, -0.687238>, <1.900895, 0.126438, -0.716277>, <1.892785, 0.036913, -0.699519>, <1.893975, -0.024513, -0.705180>, 
      <1.887559, 0.182882, -0.702949>, <1.887047, 0.140707, -0.727329>, <1.883610, 0.060034, -0.698371>, <1.882684, 0.011986, -0.706361>, 
      <1.871992, 0.183033, -0.708388>, <1.871481, 0.140858, -0.732767>, <1.867110, 0.068796, -0.700805>, <1.866184, 0.020748, -0.708795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.944784, 0.489177, -0.425069>, <1.937131, 0.397334, -0.501655>, <1.926201, 0.288533, -0.623956>, <1.919274, 0.183033, -0.680357>, 
      <1.924274, 0.497055, -0.427980>, <1.916621, 0.405211, -0.504566>, <1.911389, 0.286257, -0.630837>, <1.904462, 0.180757, -0.687238>, 
      <1.894048, 0.497903, -0.430800>, <1.894048, 0.402882, -0.513748>, <1.888883, 0.292076, -0.639829>, <1.887559, 0.182882, -0.702949>, 
      <1.871992, 0.499770, -0.431895>, <1.871992, 0.404749, -0.514843>, <1.873316, 0.292227, -0.645268>, <1.871992, 0.183033, -0.708388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.178796, 0.166414, -0.495807>, <2.179161, 0.137073, -0.517828>, <2.180528, 0.090521, -0.537111>, <2.183079, 0.055067, -0.546194>, 
      <2.214712, 0.141067, -0.437186>, <2.215077, 0.111725, -0.459207>, <2.221339, 0.058707, -0.475031>, <2.223891, 0.023253, -0.484114>, 
      <2.242722, 0.103560, -0.350229>, <2.242722, 0.054207, -0.366692>, <2.242822, 0.004754, -0.408915>, <2.244007, -0.046375, -0.399366>, 
      <2.270119, 0.076622, -0.287839>, <2.270119, 0.027269, -0.304302>, <2.268934, -0.038721, -0.345989>, <2.270119, -0.089850, -0.336440>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.178796, 0.166414, -0.495807>, <2.177864, 0.241258, -0.439637>, <2.178796, 0.329274, -0.350354>, <2.178796, 0.399071, -0.288017>, 
      <2.214712, 0.141067, -0.437186>, <2.213780, 0.215910, -0.381016>, <2.215725, 0.301102, -0.316960>, <2.215725, 0.370899, -0.254623>, 
      <2.242722, 0.103560, -0.350229>, <2.242722, 0.154417, -0.333265>, <2.242722, 0.240288, -0.262793>, <2.242722, 0.290487, -0.243969>, 
      <2.270119, 0.076622, -0.287839>, <2.270119, 0.127479, -0.270874>, <2.270119, 0.193752, -0.243915>, <2.270119, 0.243951, -0.225091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.204474, -0.190426, -0.587227>, <2.264691, -0.214028, -0.482008>, <2.302554, -0.222558, -0.247509>, <2.279729, -0.338120, -0.210379>, 
      <2.209314, -0.115965, -0.594221>, <2.269532, -0.139568, -0.489003>, <2.303626, -0.150887, -0.290498>, <2.280801, -0.266449, -0.253368>, 
      <2.188291, -0.017358, -0.564749>, <2.229102, -0.049172, -0.502669>, <2.245910, -0.128515, -0.384025>, <2.272022, -0.171990, -0.321099>, 
      <2.183079, 0.055067, -0.546194>, <2.223891, 0.023253, -0.484114>, <2.244007, -0.046375, -0.399366>, <2.270119, -0.089850, -0.336440>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.080554, 0.210406, -0.597241>, <2.078831, 0.278266, -0.553937>, <2.080554, 0.335119, -0.456729>, <2.080554, 0.388567, -0.396509>, 
      <2.113532, 0.203205, -0.568441>, <2.111809, 0.271065, -0.525137>, <2.115251, 0.325262, -0.431492>, <2.115251, 0.378710, -0.371273>, 
      <2.157047, 0.181763, -0.531306>, <2.156115, 0.256607, -0.475135>, <2.150378, 0.350953, -0.376051>, <2.150378, 0.420750, -0.313714>, 
      <2.178796, 0.166414, -0.495807>, <2.177864, 0.241258, -0.439637>, <2.178796, 0.329274, -0.350354>, <2.178796, 0.399071, -0.288017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.089119, 0.051247, -0.611766>, <2.086550, 0.098995, -0.607409>, <2.081582, 0.169939, -0.623064>, <2.080554, 0.210406, -0.597241>, 
      <2.118535, 0.053092, -0.594042>, <2.115966, 0.100839, -0.589685>, <2.114559, 0.162739, -0.594264>, <2.113532, 0.203205, -0.568441>, 
      <2.165712, 0.068606, -0.572612>, <2.163160, 0.104059, -0.563529>, <2.157412, 0.152422, -0.553327>, <2.157047, 0.181763, -0.531306>, 
      <2.183079, 0.055067, -0.546194>, <2.180528, 0.090521, -0.537111>, <2.179161, 0.137073, -0.517828>, <2.178796, 0.166414, -0.495807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.043037, -0.245348, -0.623954>, <2.031372, -0.180211, -0.631673>, <2.026828, -0.097437, -0.668951>, <2.019881, -0.034047, -0.688236>, 
      <2.001189, -0.264362, -0.645077>, <1.989524, -0.199225, -0.652797>, <1.995115, -0.096576, -0.677811>, <1.988169, -0.033186, -0.697095>, 
      <1.964147, -0.300185, -0.693430>, <1.952063, -0.212356, -0.689616>, <1.945544, -0.113747, -0.703342>, <1.943832, -0.025399, -0.695200>, 
      <1.928936, -0.315616, -0.726309>, <1.916851, -0.227787, -0.722495>, <1.912952, -0.110041, -0.706327>, <1.911240, -0.021693, -0.698185>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.043037, -0.245348, -0.623954>, <2.086328, -0.225679, -0.602102>, <2.178960, -0.180426, -0.631808>, <2.204474, -0.190426, -0.587227>, 
      <2.061795, -0.179835, -0.629937>, <2.105086, -0.160166, -0.608086>, <2.183800, -0.105965, -0.638802>, <2.209314, -0.115965, -0.594221>, 
      <2.086807, -0.092483, -0.637915>, <2.118042, -0.075427, -0.610729>, <2.165036, -0.041969, -0.594060>, <2.188291, -0.017358, -0.564749>, 
      <2.105565, -0.026970, -0.643898>, <2.136800, -0.009914, -0.616712>, <2.159825, 0.030456, -0.575505>, <2.183079, 0.055067, -0.546194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.043037, -0.245348, -0.623954>, <2.061795, -0.179835, -0.629937>, <2.086807, -0.092483, -0.637915>, <2.105565, -0.026970, -0.643898>, 
      <2.043037, -0.245348, -0.623954>, <2.050131, -0.114698, -0.637656>, <2.066566, -0.103536, -0.655532>, <2.085324, -0.038022, -0.661515>, 
      <2.043037, -0.245348, -0.623954>, <2.050131, -0.114698, -0.637656>, <2.054769, -0.098196, -0.661146>, <2.047822, -0.034806, -0.680430>, 
      <2.043037, -0.245348, -0.623954>, <2.031372, -0.180211, -0.631673>, <2.026828, -0.097437, -0.668951>, <2.019881, -0.034047, -0.688236>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.007405, 0.203837, -0.645485>, <2.006900, 0.290973, -0.594106>, <2.007405, 0.374582, -0.482519>, <2.007405, 0.447759, -0.412676>, 
      <2.030576, 0.207770, -0.633544>, <2.030071, 0.294906, -0.582165>, <2.030096, 0.357767, -0.477745>, <2.030096, 0.430944, -0.407903>, 
      <2.060961, 0.214684, -0.614351>, <2.059238, 0.282544, -0.571048>, <2.057978, 0.341532, -0.473149>, <2.057978, 0.394980, -0.412929>, 
      <2.080554, 0.210406, -0.597241>, <2.078831, 0.278266, -0.553937>, <2.080554, 0.335119, -0.456729>, <2.080554, 0.388567, -0.396509>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.007405, 0.203837, -0.645485>, <1.981818, 0.199494, -0.658671>, <1.945423, 0.187050, -0.668210>, <1.919274, 0.183033, -0.680357>, 
      <2.006900, 0.290973, -0.594106>, <1.981313, 0.286631, -0.607292>, <1.952350, 0.292550, -0.611809>, <1.926201, 0.288533, -0.623956>, 
      <2.007405, 0.374582, -0.482519>, <1.989320, 0.387984, -0.486323>, <1.958257, 0.389220, -0.498657>, <1.937131, 0.397334, -0.501655>, 
      <2.007405, 0.447759, -0.412676>, <1.989320, 0.461161, -0.416480>, <1.965910, 0.481063, -0.422071>, <1.944784, 0.489177, -0.425069>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.009743, 0.044197, -0.650633>, <1.977415, 0.030941, -0.666339>, <1.946345, -0.015959, -0.683963>, <1.911240, -0.021693, -0.698185>, 
      <2.009042, 0.092089, -0.649089>, <1.976714, 0.078833, -0.664794>, <1.945155, 0.045467, -0.678302>, <1.910050, 0.039733, -0.692524>, 
      <2.007644, 0.162557, -0.669825>, <1.982057, 0.158215, -0.683012>, <1.941856, 0.132731, -0.697250>, <1.915707, 0.128714, -0.709396>, 
      <2.007405, 0.203837, -0.645485>, <1.981818, 0.199494, -0.658671>, <1.945423, 0.187050, -0.668210>, <1.919274, 0.183033, -0.680357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.009743, 0.044197, -0.650633>, <2.009042, 0.092089, -0.649089>, <2.007644, 0.162557, -0.669825>, <2.007405, 0.203837, -0.645485>, 
      <2.032189, 0.053401, -0.639728>, <2.031488, 0.101293, -0.638183>, <2.030815, 0.166490, -0.657884>, <2.030576, 0.207770, -0.633544>, 
      <2.066369, 0.049820, -0.625473>, <2.063800, 0.097568, -0.621116>, <2.061989, 0.174218, -0.640174>, <2.060961, 0.214684, -0.614351>, 
      <2.089119, 0.051247, -0.611766>, <2.086550, 0.098995, -0.607409>, <2.081582, 0.169939, -0.623064>, <2.080554, 0.210406, -0.597241>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.972463, -0.533971, -0.732547>, <1.972631, -0.543645, -0.735456>, <1.971417, -0.550196, -0.758860>, <1.969720, -0.559226, -0.754657>, 
      <1.972463, -0.533971, -0.732547>, <2.010484, -0.555314, -0.701867>, <2.008418, -0.554495, -0.717047>, <2.006721, -0.563524, -0.712845>, 
      <1.972463, -0.533971, -0.732547>, <2.010484, -0.555314, -0.701867>, <2.016906, -0.559837, -0.690074>, <2.050856, -0.573554, -0.653245>, 
      <1.972463, -0.533971, -0.732547>, <2.010315, -0.545640, -0.698959>, <2.051678, -0.565978, -0.646612>, <2.085628, -0.579695, -0.609782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.887712, -0.518685, -0.785403>, <1.891211, -0.534487, -0.788784>, <1.896531, -0.541883, -0.827837>, <1.896763, -0.557754, -0.823207>, 
      <1.917107, -0.522108, -0.778834>, <1.920606, -0.537910, -0.782215>, <1.925909, -0.542113, -0.821587>, <1.926141, -0.557984, -0.816957>, 
      <1.950369, -0.527160, -0.752152>, <1.950537, -0.536834, -0.755061>, <1.951571, -0.547891, -0.781287>, <1.949874, -0.556920, -0.777084>, 
      <1.972463, -0.533971, -0.732547>, <1.972631, -0.543645, -0.735456>, <1.971417, -0.550196, -0.758860>, <1.969720, -0.559226, -0.754657>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.807670, -0.514780, -0.769376>, <1.808702, -0.528942, -0.769215>, <1.809889, -0.543878, -0.787064>, <1.810778, -0.557981, -0.788471>, 
      <1.832148, -0.516076, -0.768871>, <1.833180, -0.530238, -0.768710>, <1.837706, -0.544362, -0.787072>, <1.838595, -0.558465, -0.788479>, 
      <1.863938, -0.515916, -0.790716>, <1.867437, -0.531718, -0.794097>, <1.869320, -0.541670, -0.833626>, <1.869552, -0.557541, -0.828996>, 
      <1.887712, -0.518685, -0.785403>, <1.891211, -0.534487, -0.788784>, <1.896531, -0.541883, -0.827837>, <1.896763, -0.557754, -0.823207>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.725273, -0.510084, -0.788757>, <1.722815, -0.526567, -0.791789>, <1.726698, -0.540235, -0.831767>, <1.727399, -0.554807, -0.823159>, 
      <1.750292, -0.508542, -0.793059>, <1.747834, -0.525026, -0.796090>, <1.753310, -0.539972, -0.836927>, <1.754011, -0.554544, -0.828318>, 
      <1.782278, -0.513436, -0.769900>, <1.783311, -0.527598, -0.769740>, <1.782785, -0.543407, -0.787056>, <1.783673, -0.557509, -0.788463>, 
      <1.807670, -0.514780, -0.769376>, <1.808702, -0.528942, -0.769215>, <1.809889, -0.543878, -0.787064>, <1.810778, -0.557981, -0.788471>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.635815, -0.525369, -0.739826>, <1.635889, -0.536377, -0.742410>, <1.638156, -0.550888, -0.762211>, <1.638808, -0.559682, -0.755133>, 
      <1.635815, -0.525369, -0.739826>, <1.602654, -0.545059, -0.710709>, <1.605022, -0.551306, -0.724717>, <1.605675, -0.560100, -0.717639>, 
      <1.635815, -0.525369, -0.739826>, <1.602654, -0.545059, -0.710709>, <1.600495, -0.548357, -0.695312>, <1.573332, -0.557878, -0.658483>, 
      <1.635815, -0.525369, -0.739826>, <1.602580, -0.534051, -0.708125>, <1.572434, -0.547584, -0.653891>, <1.545271, -0.557105, -0.617061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.635815, -0.525369, -0.739826>, <1.635889, -0.536377, -0.742410>, <1.638156, -0.550888, -0.762211>, <1.638808, -0.559682, -0.755133>, 
      <1.657808, -0.519624, -0.760804>, <1.657882, -0.530632, -0.763388>, <1.660365, -0.550608, -0.787343>, <1.661017, -0.559402, -0.780265>, 
      <1.694845, -0.511959, -0.783525>, <1.692387, -0.528442, -0.786556>, <1.693772, -0.540561, -0.825384>, <1.694473, -0.555133, -0.816776>, 
      <1.725273, -0.510084, -0.788757>, <1.722815, -0.526567, -0.791789>, <1.726698, -0.540235, -0.831767>, <1.727399, -0.554807, -0.823159>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.967754, -0.627201, -0.792325>, <2.012594, -0.612511, -0.745143>, <2.050266, -0.593947, -0.664545>, <2.085628, -0.579695, -0.609782>, 
      <1.967754, -0.627201, -0.792325>, <2.042134, -0.638478, -0.762206>, <2.024518, -0.618911, -0.678924>, <2.059880, -0.604659, -0.624161>, 
      <1.967754, -0.627201, -0.792325>, <2.042134, -0.638478, -0.762206>, <2.030141, -0.606580, -0.661528>, <2.027474, -0.643168, -0.639341>, 
      <1.967754, -0.627201, -0.792325>, <1.997294, -0.653168, -0.809388>, <2.002469, -0.626320, -0.679899>, <1.999802, -0.662908, -0.657712>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.894774, -0.642220, -0.810607>, <1.916889, -0.635949, -0.809446>, <1.952288, -0.632268, -0.808599>, <1.967754, -0.627201, -0.792325>, 
      <1.901561, -0.672354, -0.804175>, <1.923676, -0.666083, -0.803014>, <1.981828, -0.658235, -0.825662>, <1.997294, -0.653168, -0.809388>, 
      <1.907237, -0.679575, -0.742340>, <1.938780, -0.672035, -0.722313>, <1.975170, -0.645794, -0.698022>, <2.002469, -0.626320, -0.679899>, 
      <1.905309, -0.708326, -0.729490>, <1.936853, -0.700786, -0.709463>, <1.972503, -0.682382, -0.675835>, <1.999802, -0.662908, -0.657712>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.810024, -0.671929, -0.800603>, <1.836734, -0.669041, -0.804227>, <1.868727, -0.649606, -0.811974>, <1.894774, -0.642220, -0.810607>, 
      <1.810634, -0.684712, -0.800507>, <1.837344, -0.681823, -0.804131>, <1.875514, -0.679740, -0.805542>, <1.901561, -0.672354, -0.804175>, 
      <1.810349, -0.696205, -0.782422>, <1.842418, -0.697123, -0.779796>, <1.880599, -0.685942, -0.759253>, <1.907237, -0.679575, -0.742340>, 
      <1.809784, -0.708326, -0.778356>, <1.841853, -0.709244, -0.775730>, <1.878671, -0.714693, -0.746403>, <1.905309, -0.708326, -0.729490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.727628, -0.660296, -0.787929>, <1.748802, -0.667706, -0.799523>, <1.785144, -0.674620, -0.797227>, <1.810024, -0.671929, -0.800603>, 
      <1.727713, -0.678305, -0.784259>, <1.748886, -0.685715, -0.795853>, <1.785754, -0.687402, -0.797131>, <1.810634, -0.684712, -0.800507>, 
      <1.725270, -0.685632, -0.749722>, <1.747182, -0.688968, -0.765795>, <1.783073, -0.695424, -0.784655>, <1.810349, -0.696205, -0.782422>, 
      <1.725300, -0.703172, -0.744230>, <1.747212, -0.706508, -0.760303>, <1.782508, -0.707545, -0.780590>, <1.809784, -0.708326, -0.778356>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.637930, -0.611702, -0.706372>, <1.664358, -0.626657, -0.731135>, <1.694773, -0.648798, -0.769939>, <1.727628, -0.660296, -0.787929>, 
      <1.633506, -0.639220, -0.706600>, <1.659933, -0.654175, -0.731363>, <1.694858, -0.666807, -0.766270>, <1.727713, -0.678305, -0.784259>, 
      <1.624311, -0.653498, -0.650246>, <1.653107, -0.676862, -0.670587>, <1.691420, -0.680479, -0.724893>, <1.725270, -0.685632, -0.749722>, 
      <1.627833, -0.680624, -0.644893>, <1.656629, -0.703988, -0.665234>, <1.691450, -0.698018, -0.719401>, <1.725300, -0.703172, -0.744230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.637930, -0.611702, -0.706372>, <1.609643, -0.595695, -0.679867>, <1.573069, -0.573484, -0.643854>, <1.545271, -0.557105, -0.617061>, 
      <1.637930, -0.611702, -0.706372>, <1.605219, -0.623213, -0.680095>, <1.597837, -0.610540, -0.652204>, <1.570040, -0.594161, -0.625411>, 
      <1.637930, -0.611702, -0.706372>, <1.605219, -0.623213, -0.680095>, <1.593437, -0.628449, -0.628437>, <1.596959, -0.655574, -0.623084>, 
      <1.637930, -0.611702, -0.706372>, <1.633506, -0.639220, -0.706600>, <1.624311, -0.653498, -0.650246>, <1.627833, -0.680624, -0.644893>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.888936, -0.602518, -0.760945>, <1.891284, -0.589089, -0.779624>, <1.897087, -0.579951, -0.816731>, <1.896763, -0.557754, -0.823207>, 
      <1.865966, -0.598572, -0.765707>, <1.868314, -0.585143, -0.784386>, <1.869876, -0.579738, -0.822520>, <1.869552, -0.557541, -0.828996>, 
      <1.835892, -0.590240, -0.780253>, <1.835415, -0.580825, -0.783749>, <1.839224, -0.568450, -0.789475>, <1.838595, -0.558465, -0.788479>, 
      <1.812370, -0.589364, -0.776819>, <1.811892, -0.579949, -0.780315>, <1.811407, -0.567966, -0.789467>, <1.810778, -0.557981, -0.788471>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.959629, -0.602259, -0.700764>, <1.962656, -0.589349, -0.716932>, <1.966208, -0.577914, -0.745959>, <1.969720, -0.559226, -0.754657>, 
      <1.937638, -0.604811, -0.717665>, <1.940665, -0.591901, -0.733833>, <1.946362, -0.575608, -0.768386>, <1.949874, -0.556920, -0.777084>, 
      <1.910144, -0.602440, -0.742891>, <1.912492, -0.589011, -0.761569>, <1.926465, -0.580181, -0.810481>, <1.926141, -0.557984, -0.816957>, 
      <1.888936, -0.602518, -0.760945>, <1.891284, -0.589089, -0.779624>, <1.897087, -0.579951, -0.816731>, <1.896763, -0.557754, -0.823207>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.959629, -0.602259, -0.700764>, <1.962656, -0.589349, -0.716932>, <1.966208, -0.577914, -0.745959>, <1.969720, -0.559226, -0.754657>, 
      <1.996828, -0.597943, -0.672176>, <1.999855, -0.585033, -0.688344>, <1.967905, -0.568884, -0.750162>, <1.971417, -0.550196, -0.758860>, 
      <2.047828, -0.586464, -0.637077>, <2.013879, -0.572747, -0.673906>, <2.010484, -0.555314, -0.701867>, <1.972631, -0.543645, -0.735456>, 
      <2.085628, -0.579695, -0.609782>, <2.051678, -0.565978, -0.646612>, <2.010315, -0.545640, -0.698959>, <1.972463, -0.533971, -0.732547>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.959629, -0.602259, -0.700764>, <1.996828, -0.597943, -0.672176>, <2.047828, -0.586464, -0.637077>, <2.085628, -0.579695, -0.609782>, 
      <1.959629, -0.602259, -0.700764>, <1.999855, -0.585033, -0.688344>, <2.013056, -0.580323, -0.680539>, <2.050856, -0.573554, -0.653245>, 
      <1.959629, -0.602259, -0.700764>, <1.999855, -0.585033, -0.688344>, <2.003209, -0.582213, -0.704147>, <2.006721, -0.563524, -0.712845>, 
      <1.959629, -0.602259, -0.700764>, <1.962656, -0.589349, -0.716932>, <1.966208, -0.577914, -0.745959>, <1.969720, -0.559226, -0.754657>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.729433, -0.596579, -0.737659>, <1.753517, -0.595370, -0.751085>, <1.785078, -0.588348, -0.772835>, <1.812370, -0.589364, -0.776819>, 
      <1.728823, -0.584048, -0.763309>, <1.752907, -0.582839, -0.776735>, <1.784600, -0.578933, -0.776330>, <1.811892, -0.579949, -0.780315>, 
      <1.728580, -0.579371, -0.808648>, <1.755192, -0.579107, -0.813807>, <1.784303, -0.567494, -0.789460>, <1.811407, -0.567966, -0.789467>, 
      <1.727399, -0.554807, -0.823159>, <1.754011, -0.554544, -0.828318>, <1.783673, -0.557509, -0.788463>, <1.810778, -0.557981, -0.788471>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.641200, -0.597956, -0.681401>, <1.640482, -0.586474, -0.703521>, <1.640246, -0.579072, -0.739526>, <1.638808, -0.559682, -0.755133>, 
      <1.610934, -0.591469, -0.661581>, <1.610216, -0.579986, -0.683701>, <1.639594, -0.570278, -0.746604>, <1.638156, -0.550888, -0.762211>, 
      <1.574050, -0.569360, -0.636363>, <1.601213, -0.559840, -0.673192>, <1.602654, -0.545059, -0.710709>, <1.635889, -0.536377, -0.742410>, 
      <1.545271, -0.557105, -0.617061>, <1.572434, -0.547584, -0.653891>, <1.602580, -0.534051, -0.708125>, <1.635815, -0.525369, -0.739826>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.641200, -0.597956, -0.681401>, <1.640482, -0.586474, -0.703521>, <1.640246, -0.579072, -0.739526>, <1.638808, -0.559682, -0.755133>, 
      <1.641200, -0.597956, -0.681401>, <1.610216, -0.579986, -0.683701>, <1.607113, -0.579490, -0.702032>, <1.605675, -0.560100, -0.717639>, 
      <1.641200, -0.597956, -0.681401>, <1.610216, -0.579986, -0.683701>, <1.602111, -0.570133, -0.677785>, <1.573332, -0.557878, -0.658483>, 
      <1.641200, -0.597956, -0.681401>, <1.610934, -0.591469, -0.661581>, <1.574050, -0.569360, -0.636363>, <1.545271, -0.557105, -0.617061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.641200, -0.597956, -0.681401>, <1.667053, -0.603497, -0.698330>, <1.702037, -0.597954, -0.722387>, <1.729433, -0.596579, -0.737659>, 
      <1.640482, -0.586474, -0.703521>, <1.666335, -0.592015, -0.720450>, <1.701427, -0.585423, -0.748037>, <1.728823, -0.584048, -0.763309>, 
      <1.640246, -0.579072, -0.739526>, <1.662456, -0.578792, -0.764658>, <1.695654, -0.579696, -0.802265>, <1.728580, -0.579371, -0.808648>, 
      <1.638808, -0.559682, -0.755133>, <1.661017, -0.559402, -0.780265>, <1.694473, -0.555133, -0.816776>, <1.727399, -0.554807, -0.823159>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.870960, -0.918373, -0.349215>, <1.871136, -0.933820, -0.310179>, <1.877591, -1.007686, -0.309532>, <1.880433, -1.045963, -0.292525>, 
      <1.851103, -0.923694, -0.365625>, <1.851279, -0.939141, -0.326589>, <1.854353, -1.010297, -0.316619>, <1.857195, -1.048574, -0.299612>, 
      <1.833894, -0.926007, -0.408134>, <1.834224, -0.943879, -0.363751>, <1.828790, -1.015028, -0.344261>, <1.827393, -1.053809, -0.316272>, 
      <1.807630, -0.925394, -0.409446>, <1.807960, -0.943266, -0.365063>, <1.804371, -1.015884, -0.344138>, <1.802974, -1.054666, -0.316149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.870960, -0.918373, -0.349215>, <1.823992, -0.917277, -0.351562>, <1.761367, -0.915817, -0.354691>, <1.714399, -0.914721, -0.357038>, 
      <1.870960, -0.918373, -0.349215>, <1.804135, -0.922599, -0.367972>, <1.787245, -0.922941, -0.372560>, <1.740277, -0.921846, -0.374907>, 
      <1.870960, -0.918373, -0.349215>, <1.804135, -0.922599, -0.367972>, <1.801698, -0.925256, -0.409742>, <1.775434, -0.924643, -0.411055>, 
      <1.870960, -0.918373, -0.349215>, <1.851103, -0.923694, -0.365625>, <1.833894, -0.926007, -0.408134>, <1.807630, -0.925394, -0.409446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.717388, -1.051684, -0.291703>, <1.716491, -1.010595, -0.311304>, <1.715296, -0.955810, -0.337438>, <1.714399, -0.914721, -0.357038>, 
      <1.743064, -1.052579, -0.299037>, <1.742167, -1.011490, -0.318637>, <1.741174, -0.962935, -0.355306>, <1.740277, -0.921846, -0.374907>, 
      <1.776273, -1.055603, -0.316014>, <1.777670, -1.016821, -0.344004>, <1.775764, -0.942515, -0.366672>, <1.775434, -0.924643, -0.411055>, 
      <1.802974, -1.054666, -0.316149>, <1.804371, -1.015884, -0.344138>, <1.807960, -0.943266, -0.365063>, <1.807630, -0.925394, -0.409446>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.451847, -0.462561, -0.508168>, <1.438815, -0.384224, -0.535712>, <1.413614, -0.274010, -0.556762>, <1.420415, -0.194070, -0.581832>, 
      <1.451847, -0.462561, -0.508168>, <1.397370, -0.368966, -0.441778>, <1.355058, -0.294232, -0.455116>, <1.361859, -0.214293, -0.480187>, 
      <1.451847, -0.462561, -0.508168>, <1.397370, -0.368966, -0.441778>, <1.326027, -0.306851, -0.221664>, <1.314382, -0.207384, -0.248954>, 
      <1.451847, -0.462561, -0.508168>, <1.410402, -0.447302, -0.414234>, <1.339381, -0.420920, -0.190368>, <1.327736, -0.321453, -0.217658>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.354145, -0.427350, -0.123446>, <1.392475, -0.468263, -0.221970>, <1.442159, -0.536739, -0.349187>, <1.481913, -0.563728, -0.451858>, 
      <1.366902, -0.466276, -0.099211>, <1.405232, -0.507190, -0.197735>, <1.446340, -0.583239, -0.316385>, <1.486093, -0.610228, -0.419056>, 
      <1.399161, -0.531213, -0.098145>, <1.419147, -0.575135, -0.178119>, <1.449157, -0.646839, -0.302528>, <1.479476, -0.684520, -0.382437>, 
      <1.407614, -0.565193, -0.065908>, <1.427601, -0.609115, -0.145882>, <1.443917, -0.673920, -0.252580>, <1.474236, -0.711601, -0.332489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.354145, -0.427350, -0.123446>, <1.342552, -0.391975, -0.145470>, <1.331891, -0.358304, -0.195395>, <1.327736, -0.321453, -0.217658>, 
      <1.392475, -0.468263, -0.221970>, <1.380882, -0.432888, -0.243994>, <1.343535, -0.457771, -0.168105>, <1.339381, -0.420920, -0.190368>, 
      <1.442159, -0.536739, -0.349187>, <1.439530, -0.507494, -0.369818>, <1.415966, -0.480748, -0.402475>, <1.410402, -0.447302, -0.414234>, 
      <1.481913, -0.563728, -0.451858>, <1.479284, -0.534482, -0.472489>, <1.457411, -0.496007, -0.496408>, <1.451847, -0.462561, -0.508168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.408976, -0.647752, 0.085647>, <1.407478, -0.602332, 0.060836>, <1.416810, -0.602158, -0.030839>, <1.407614, -0.565193, -0.065908>, 
      <1.420332, -0.676934, 0.024710>, <1.418835, -0.631514, -0.000101>, <1.436797, -0.646081, -0.110814>, <1.427601, -0.609115, -0.145882>, 
      <1.424282, -0.712473, -0.061568>, <1.430209, -0.676693, -0.116464>, <1.437874, -0.705148, -0.194985>, <1.443917, -0.673920, -0.252580>, 
      <1.446831, -0.745027, -0.117475>, <1.452758, -0.709247, -0.172371>, <1.468193, -0.742829, -0.274893>, <1.474236, -0.711601, -0.332489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.415456, -0.803017, 0.064005>, <1.413512, -0.756437, 0.070498>, <1.410338, -0.689043, 0.108203>, <1.408976, -0.647752, 0.085647>, 
      <1.423619, -0.832766, 0.032777>, <1.421675, -0.786186, 0.039270>, <1.421694, -0.718226, 0.047266>, <1.420332, -0.676934, 0.024710>, 
      <1.426745, -0.876716, -0.008072>, <1.427995, -0.829570, -0.031288>, <1.419546, -0.741060, -0.017708>, <1.424282, -0.712473, -0.061568>, 
      <1.442664, -0.902180, -0.040087>, <1.443914, -0.855034, -0.063303>, <1.442095, -0.773614, -0.073615>, <1.446831, -0.745027, -0.117475>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.519307, -0.391983, -0.651850>, <1.515980, -0.443044, -0.649574>, <1.537482, -0.507568, -0.627498>, <1.545271, -0.557105, -0.617061>, 
      <1.485524, -0.399040, -0.612801>, <1.482197, -0.450101, -0.610525>, <1.518474, -0.509555, -0.577937>, <1.526264, -0.559092, -0.567500>, 
      <1.472655, -0.470222, -0.555330>, <1.478220, -0.503668, -0.543570>, <1.497912, -0.547129, -0.520599>, <1.500541, -0.576375, -0.499968>, 
      <1.451847, -0.462561, -0.508168>, <1.457411, -0.496007, -0.496408>, <1.479284, -0.534482, -0.472489>, <1.481913, -0.563728, -0.451858>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.519307, -0.391983, -0.651850>, <1.522447, -0.343801, -0.653998>, <1.559913, -0.286884, -0.626486>, <1.565988, -0.239171, -0.631233>, 
      <1.485524, -0.399040, -0.612801>, <1.488664, -0.350857, -0.614949>, <1.521248, -0.270074, -0.603413>, <1.527323, -0.222361, -0.608159>, 
      <1.472655, -0.470222, -0.555330>, <1.459623, -0.391885, -0.582873>, <1.437256, -0.265845, -0.597802>, <1.444058, -0.185905, -0.622872>, 
      <1.451847, -0.462561, -0.508168>, <1.438815, -0.384224, -0.535712>, <1.413614, -0.274010, -0.556762>, <1.420415, -0.194070, -0.581832>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.600759, -0.805234, -0.574959>, <1.559053, -0.774722, -0.505313>, <1.502387, -0.746587, -0.406682>, <1.474236, -0.711601, -0.332489>, 
      <1.601175, -0.758262, -0.636369>, <1.559468, -0.727750, -0.566722>, <1.507627, -0.719505, -0.456630>, <1.479476, -0.684520, -0.382437>, 
      <1.561917, -0.631544, -0.604430>, <1.542910, -0.633531, -0.554870>, <1.504721, -0.622874, -0.467166>, <1.486093, -0.610228, -0.419056>, 
      <1.545271, -0.557105, -0.617061>, <1.526264, -0.559092, -0.567500>, <1.500541, -0.576375, -0.499968>, <1.481913, -0.563728, -0.451858>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.542759, -0.840893, -0.246048>, <1.505624, -0.815659, -0.212471>, <1.465283, -0.771666, -0.163224>, <1.446831, -0.745027, -0.117475>, 
      <1.556978, -0.796524, -0.335395>, <1.519843, -0.771291, -0.301818>, <1.471211, -0.735886, -0.218121>, <1.452758, -0.709247, -0.172371>, 
      <1.600217, -0.866453, -0.494924>, <1.558511, -0.835941, -0.425278>, <1.496344, -0.777814, -0.349086>, <1.468193, -0.742829, -0.274893>, 
      <1.600759, -0.805234, -0.574959>, <1.559053, -0.774722, -0.505313>, <1.502387, -0.746587, -0.406682>, <1.474236, -0.711601, -0.332489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.538431, -0.999724, -0.183309>, <1.500468, -0.975377, -0.144658>, <1.464205, -0.936636, -0.083407>, <1.442664, -0.902180, -0.040087>, 
      <1.539729, -0.952075, -0.202131>, <1.501766, -0.927728, -0.163480>, <1.465455, -0.889490, -0.106624>, <1.443914, -0.855034, -0.063303>, 
      <1.535527, -0.863459, -0.200607>, <1.498393, -0.838225, -0.167030>, <1.460547, -0.800253, -0.119364>, <1.442095, -0.773614, -0.073615>, 
      <1.542759, -0.840893, -0.246048>, <1.505624, -0.815659, -0.212471>, <1.465283, -0.771666, -0.163224>, <1.446831, -0.745027, -0.117475>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.637893, -0.423700, -0.723213>, <1.601177, -0.427884, -0.702025>, <1.546920, -0.386215, -0.683768>, <1.519307, -0.391983, -0.651850>, 
      <1.632531, -0.454131, -0.724073>, <1.595814, -0.458315, -0.702885>, <1.543593, -0.437276, -0.681492>, <1.515980, -0.443044, -0.649574>, 
      <1.635612, -0.495276, -0.732762>, <1.602378, -0.503958, -0.701061>, <1.564645, -0.498048, -0.664327>, <1.537482, -0.507568, -0.627498>, 
      <1.635815, -0.525369, -0.739826>, <1.602580, -0.534051, -0.708125>, <1.572434, -0.547584, -0.653891>, <1.545271, -0.557105, -0.617061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.637893, -0.423700, -0.723213>, <1.644402, -0.386764, -0.722169>, <1.671336, -0.341926, -0.735883>, <1.674714, -0.304630, -0.733588>, 
      <1.601177, -0.427884, -0.702025>, <1.607685, -0.390948, -0.700982>, <1.639394, -0.327055, -0.701957>, <1.642772, -0.289758, -0.699662>, 
      <1.546920, -0.386215, -0.683768>, <1.550060, -0.338033, -0.685915>, <1.599262, -0.303992, -0.649969>, <1.605337, -0.256279, -0.654715>, 
      <1.519307, -0.391983, -0.651850>, <1.522447, -0.343801, -0.653998>, <1.559913, -0.286884, -0.626486>, <1.565988, -0.239171, -0.631233>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.636791, -0.624910, -0.644431>, <1.610529, -0.614209, -0.623675>, <1.572727, -0.577446, -0.625272>, <1.545271, -0.557105, -0.617061>, 
      <1.636791, -0.624910, -0.644431>, <1.610870, -0.610247, -0.642257>, <1.600525, -0.593826, -0.652065>, <1.573069, -0.573484, -0.643854>, 
      <1.636791, -0.624910, -0.644431>, <1.610870, -0.610247, -0.642257>, <1.612660, -0.576934, -0.679712>, <1.609643, -0.595695, -0.679867>, 
      <1.636791, -0.624910, -0.644431>, <1.637133, -0.620948, -0.663013>, <1.640947, -0.592940, -0.706217>, <1.637930, -0.611702, -0.706372>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.636791, -0.624910, -0.644431>, <1.637133, -0.620948, -0.663013>, <1.640947, -0.592940, -0.706217>, <1.637930, -0.611702, -0.706372>, 
      <1.610529, -0.614209, -0.623675>, <1.610870, -0.610247, -0.642257>, <1.636522, -0.620458, -0.706445>, <1.633506, -0.639220, -0.706600>, 
      <1.572727, -0.577446, -0.625272>, <1.597496, -0.614502, -0.633622>, <1.593437, -0.628449, -0.628437>, <1.624311, -0.653498, -0.650246>, 
      <1.545271, -0.557105, -0.617061>, <1.570040, -0.594161, -0.625411>, <1.596959, -0.655574, -0.623084>, <1.627833, -0.680624, -0.644893>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.669446, -0.854413, -0.658474>, <1.647443, -0.841770, -0.633453>, <1.617897, -0.817772, -0.603579>, <1.600759, -0.805234, -0.574959>, 
      <1.666832, -0.827484, -0.704936>, <1.644829, -0.814841, -0.679915>, <1.618313, -0.770800, -0.664988>, <1.601175, -0.758262, -0.636369>, 
      <1.634627, -0.732949, -0.634567>, <1.603753, -0.707899, -0.612758>, <1.586686, -0.668599, -0.612780>, <1.561917, -0.631544, -0.604430>, 
      <1.627833, -0.680624, -0.644893>, <1.596959, -0.655574, -0.623084>, <1.570040, -0.594161, -0.625411>, <1.545271, -0.557105, -0.617061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.647307, -0.881253, -0.298744>, <1.617965, -0.868632, -0.279770>, <1.567367, -0.857614, -0.268299>, <1.542759, -0.840893, -0.246048>, 
      <1.653664, -0.838894, -0.398347>, <1.624322, -0.826273, -0.379373>, <1.581586, -0.813246, -0.357645>, <1.556978, -0.796524, -0.335395>, 
      <1.674717, -0.908718, -0.564780>, <1.652714, -0.896076, -0.539759>, <1.617355, -0.878991, -0.523544>, <1.600217, -0.866453, -0.494924>, 
      <1.669446, -0.854413, -0.658474>, <1.647443, -0.841770, -0.633453>, <1.617897, -0.817772, -0.603579>, <1.600759, -0.805234, -0.574959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.642998, -1.030660, -0.244047>, <1.611913, -1.021635, -0.225219>, <1.562365, -1.015074, -0.207677>, <1.538431, -0.999724, -0.183309>, 
      <1.644291, -0.985838, -0.260456>, <1.613206, -0.976812, -0.241628>, <1.563664, -0.967424, -0.226498>, <1.539729, -0.952075, -0.202131>, 
      <1.644508, -0.899908, -0.254879>, <1.615166, -0.887287, -0.235905>, <1.560135, -0.880180, -0.222857>, <1.535527, -0.863459, -0.200607>, 
      <1.647307, -0.881253, -0.298744>, <1.617965, -0.868632, -0.279770>, <1.567367, -0.857614, -0.268299>, <1.542759, -0.840893, -0.246048>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.642998, -1.030660, -0.244047>, <1.644291, -0.985838, -0.260456>, <1.644508, -0.899908, -0.254879>, <1.647307, -0.881253, -0.298744>, 
      <1.665614, -1.037226, -0.257745>, <1.666906, -0.992404, -0.274154>, <1.667010, -0.909587, -0.269430>, <1.669809, -0.890932, -0.313295>, 
      <1.695071, -1.045377, -0.277406>, <1.694174, -1.004288, -0.297007>, <1.692430, -0.949514, -0.321649>, <1.691533, -0.908426, -0.341249>, 
      <1.717388, -1.051684, -0.291703>, <1.716491, -1.010595, -0.311304>, <1.715296, -0.955810, -0.337438>, <1.714399, -0.914721, -0.357038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.755695, -0.365046, -0.788260>, <1.716958, -0.378081, -0.771861>, <1.675852, -0.419374, -0.745117>, <1.637893, -0.423700, -0.723213>, 
      <1.752035, -0.408862, -0.781676>, <1.713298, -0.421897, -0.765277>, <1.670489, -0.449805, -0.745977>, <1.632531, -0.454131, -0.724073>, 
      <1.731724, -0.466822, -0.780801>, <1.701296, -0.468696, -0.775569>, <1.657605, -0.489531, -0.753740>, <1.635612, -0.495276, -0.732762>, 
      <1.725273, -0.510084, -0.788757>, <1.694845, -0.511959, -0.783525>, <1.657808, -0.519624, -0.760804>, <1.635815, -0.525369, -0.739826>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.755695, -0.365046, -0.788260>, <1.757052, -0.348803, -0.790701>, <1.742545, -0.336785, -0.820502>, <1.741094, -0.320699, -0.817217>, 
      <1.716958, -0.378081, -0.771861>, <1.718315, -0.361838, -0.774302>, <1.719781, -0.332644, -0.797832>, <1.718330, -0.316558, -0.794547>, 
      <1.675852, -0.419374, -0.745117>, <1.682361, -0.382439, -0.744074>, <1.692489, -0.351775, -0.758351>, <1.695867, -0.314479, -0.756055>, 
      <1.637893, -0.423700, -0.723213>, <1.644402, -0.386764, -0.722169>, <1.671336, -0.341926, -0.735883>, <1.674714, -0.304630, -0.733588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.724958, -0.630319, -0.759075>, <1.725759, -0.639312, -0.767731>, <1.727571, -0.648040, -0.790426>, <1.727628, -0.660296, -0.787929>, 
      <1.691056, -0.626115, -0.732277>, <1.691857, -0.635108, -0.740933>, <1.694716, -0.636542, -0.772436>, <1.694773, -0.648798, -0.769939>, 
      <1.669237, -0.638130, -0.670075>, <1.669579, -0.634168, -0.688657>, <1.667375, -0.607895, -0.730979>, <1.664358, -0.626657, -0.731135>, 
      <1.636791, -0.624910, -0.644431>, <1.637133, -0.620948, -0.663013>, <1.640947, -0.592940, -0.706217>, <1.637930, -0.611702, -0.706372>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.728003, -0.878348, -0.719654>, <1.725301, -0.930789, -0.623672>, <1.718480, -0.903809, -0.465823>, <1.714399, -0.914721, -0.357038>, 
      <1.705301, -0.872348, -0.707586>, <1.702598, -0.924789, -0.611605>, <1.695614, -0.897514, -0.450034>, <1.691533, -0.908426, -0.341249>, 
      <1.685747, -0.863779, -0.677010>, <1.691018, -0.918085, -0.583316>, <1.676166, -0.848573, -0.412898>, <1.669809, -0.890932, -0.313295>, 
      <1.669446, -0.854413, -0.658474>, <1.674717, -0.908718, -0.564780>, <1.653664, -0.838894, -0.398347>, <1.647307, -0.881253, -0.298744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.728003, -0.878348, -0.719654>, <1.705301, -0.872348, -0.707586>, <1.685747, -0.863779, -0.677010>, <1.669446, -0.854413, -0.658474>, 
      <1.729314, -0.852909, -0.766215>, <1.706611, -0.846909, -0.754147>, <1.683133, -0.836850, -0.723472>, <1.666832, -0.827484, -0.704936>, 
      <1.725387, -0.753821, -0.728371>, <1.691537, -0.748667, -0.703542>, <1.663424, -0.756313, -0.654908>, <1.634627, -0.732949, -0.634567>, 
      <1.725300, -0.703172, -0.744230>, <1.691450, -0.698018, -0.719401>, <1.656629, -0.703988, -0.665234>, <1.627833, -0.680624, -0.644893>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.797083, -0.370132, -0.790604>, <1.796850, -0.357117, -0.809826>, <1.796623, -0.349590, -0.858818>, <1.796306, -0.326750, -0.854676>, 
      <1.784602, -0.370726, -0.791537>, <1.784369, -0.357712, -0.810759>, <1.780059, -0.347774, -0.847580>, <1.779742, -0.324935, -0.843438>, 
      <1.766716, -0.361337, -0.792926>, <1.768073, -0.345094, -0.795367>, <1.756669, -0.339355, -0.834567>, <1.755218, -0.323269, -0.831283>, 
      <1.755695, -0.365046, -0.788260>, <1.757052, -0.348803, -0.790701>, <1.742545, -0.336785, -0.820502>, <1.741094, -0.320699, -0.817217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.797083, -0.370132, -0.790604>, <1.784602, -0.370726, -0.791537>, <1.766716, -0.361337, -0.792926>, <1.755695, -0.365046, -0.788260>, 
      <1.800259, -0.413526, -0.784236>, <1.787778, -0.414121, -0.785169>, <1.763056, -0.405153, -0.786341>, <1.752035, -0.408862, -0.781676>, 
      <1.804473, -0.470925, -0.769874>, <1.779081, -0.469581, -0.770398>, <1.756743, -0.465280, -0.785103>, <1.731724, -0.466822, -0.780801>, 
      <1.807670, -0.514780, -0.769376>, <1.782278, -0.513436, -0.769900>, <1.750292, -0.508542, -0.793059>, <1.725273, -0.510084, -0.788757>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.148797, -0.472313, -0.496656>, <2.190274, -0.458538, -0.403761>, <2.260756, -0.434177, -0.179516>, <2.279729, -0.338120, -0.210379>, 
      <2.148797, -0.472313, -0.496656>, <2.202174, -0.374694, -0.435341>, <2.283581, -0.318615, -0.216646>, <2.302554, -0.222558, -0.247509>, 
      <2.148797, -0.472313, -0.496656>, <2.202174, -0.374694, -0.435341>, <2.258854, -0.303825, -0.473573>, <2.264691, -0.214028, -0.482008>, 
      <2.148797, -0.472313, -0.496656>, <2.160697, -0.388469, -0.528235>, <2.198637, -0.280223, -0.578792>, <2.204474, -0.190426, -0.587227>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.264626, -0.457091, -0.116167>, <2.256631, -0.490735, -0.094472>, <2.231136, -0.545199, -0.087169>, <2.223804, -0.573451, -0.058629>, 
      <2.230454, -0.490711, -0.214691>, <2.222459, -0.524355, -0.192996>, <2.200672, -0.588127, -0.167384>, <2.193340, -0.616379, -0.138843>, 
      <2.187094, -0.544245, -0.344274>, <2.182003, -0.591101, -0.311535>, <2.148757, -0.652047, -0.291292>, <2.149061, -0.680273, -0.241328>, 
      <2.150721, -0.569159, -0.444579>, <2.145629, -0.616015, -0.411841>, <2.121953, -0.688319, -0.375974>, <2.122258, -0.716545, -0.326010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.264626, -0.457091, -0.116167>, <2.273587, -0.419385, -0.140481>, <2.279142, -0.377352, -0.186848>, <2.279729, -0.338120, -0.210379>, 
      <2.230454, -0.490711, -0.214691>, <2.239415, -0.453005, -0.239005>, <2.260170, -0.473409, -0.155984>, <2.260756, -0.434177, -0.179516>, 
      <2.187094, -0.544245, -0.344274>, <2.190022, -0.517306, -0.363096>, <2.185930, -0.489145, -0.392234>, <2.190274, -0.458538, -0.403761>, 
      <2.150721, -0.569159, -0.444579>, <2.153648, -0.542220, -0.463401>, <2.144453, -0.502920, -0.485128>, <2.148797, -0.472313, -0.496656>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.210911, -0.664075, 0.092926>, <2.193465, -0.692135, 0.031749>, <2.179111, -0.726156, -0.054866>, <2.152757, -0.757608, -0.110996>, 
      <2.217593, -0.616555, 0.070155>, <2.200147, -0.644615, 0.008979>, <2.173261, -0.689087, -0.109528>, <2.146908, -0.720539, -0.165658>, 
      <2.214264, -0.610211, -0.021494>, <2.183800, -0.653139, -0.101709>, <2.149414, -0.712885, -0.183599>, <2.122610, -0.749157, -0.268282>, 
      <2.223804, -0.573451, -0.058629>, <2.193340, -0.616379, -0.138843>, <2.149061, -0.680273, -0.241328>, <2.122258, -0.716545, -0.326010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.185915, -0.842898, 0.070484>, <2.176204, -0.864481, 0.039256>, <2.169230, -0.894796, -0.003817>, <2.153546, -0.914840, -0.033608>, 
      <2.193414, -0.789251, 0.077217>, <2.183703, -0.810834, 0.045989>, <2.168993, -0.847626, -0.027033>, <2.153309, -0.867670, -0.056824>, 
      <2.204044, -0.712910, 0.116327>, <2.186598, -0.740970, 0.055150>, <2.183748, -0.755549, -0.011523>, <2.157395, -0.787001, -0.067654>, 
      <2.210911, -0.664075, 0.092926>, <2.193465, -0.692135, 0.031749>, <2.179111, -0.726156, -0.054866>, <2.152757, -0.757608, -0.110996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.085865, -0.402505, -0.644571>, <2.092704, -0.456195, -0.642295>, <2.085699, -0.526538, -0.620219>, <2.085628, -0.579695, -0.609782>, 
      <2.119011, -0.410159, -0.604485>, <2.125850, -0.463849, -0.602209>, <2.105227, -0.523377, -0.570658>, <2.105156, -0.576534, -0.560221>, 
      <2.127556, -0.479367, -0.544229>, <2.123212, -0.509974, -0.532701>, <2.135933, -0.554354, -0.512254>, <2.133006, -0.581293, -0.493431>, 
      <2.148797, -0.472313, -0.496656>, <2.144453, -0.502920, -0.485128>, <2.153648, -0.542220, -0.463401>, <2.150721, -0.569159, -0.444579>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.085865, -0.402505, -0.644571>, <2.119011, -0.410159, -0.604485>, <2.127556, -0.479367, -0.544229>, <2.148797, -0.472313, -0.496656>, 
      <2.079646, -0.353687, -0.646640>, <2.112792, -0.361341, -0.606554>, <2.139456, -0.395523, -0.575808>, <2.160697, -0.388469, -0.528235>, 
      <2.051661, -0.293507, -0.618247>, <2.094952, -0.273838, -0.596395>, <2.173123, -0.270223, -0.623373>, <2.198637, -0.280223, -0.578792>, 
      <2.043037, -0.245348, -0.623954>, <2.086328, -0.225679, -0.602102>, <2.178960, -0.180426, -0.631808>, <2.204474, -0.190426, -0.587227>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.062427, -0.791836, -0.568480>, <2.066800, -0.753434, -0.621001>, <2.078668, -0.643337, -0.597391>, <2.085628, -0.579695, -0.609782>, 
      <2.096400, -0.763672, -0.503856>, <2.100774, -0.725270, -0.556378>, <2.098196, -0.640177, -0.547831>, <2.105156, -0.576534, -0.560221>, 
      <2.100396, -0.746129, -0.395079>, <2.100091, -0.717903, -0.445043>, <2.127914, -0.628149, -0.460693>, <2.133006, -0.581293, -0.493431>, 
      <2.122258, -0.716545, -0.326010>, <2.121953, -0.688319, -0.375974>, <2.145629, -0.616015, -0.411841>, <2.150721, -0.569159, -0.444579>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.054802, -0.850383, -0.239569>, <2.056304, -0.801724, -0.327205>, <2.055704, -0.850873, -0.487736>, <2.062427, -0.791836, -0.568480>, 
      <2.092478, -0.826334, -0.205981>, <2.093980, -0.777675, -0.293617>, <2.089677, -0.822710, -0.423113>, <2.096400, -0.763672, -0.503856>, 
      <2.131565, -0.782899, -0.156132>, <2.125716, -0.745830, -0.210794>, <2.100749, -0.778741, -0.337350>, <2.100396, -0.746129, -0.395079>, 
      <2.152757, -0.757608, -0.110996>, <2.146908, -0.720539, -0.165658>, <2.122610, -0.749157, -0.268282>, <2.122258, -0.716545, -0.326010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.055715, -1.009297, -0.176829>, <2.055441, -0.961623, -0.195651>, <2.054034, -0.875262, -0.194762>, <2.054802, -0.850383, -0.239569>, 
      <2.094197, -0.986164, -0.138170>, <2.093923, -0.938490, -0.156992>, <2.091710, -0.851213, -0.161174>, <2.092478, -0.826334, -0.205981>, 
      <2.129830, -0.945150, -0.078656>, <2.129593, -0.897980, -0.101873>, <2.136203, -0.812292, -0.112790>, <2.131565, -0.782899, -0.156132>, 
      <2.153546, -0.914840, -0.033608>, <2.153309, -0.867670, -0.056824>, <2.157395, -0.787001, -0.067654>, <2.152757, -0.757608, -0.110996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.967481, -0.430444, -0.715934>, <1.973635, -0.461315, -0.716816>, <1.971939, -0.503818, -0.723480>, <1.972463, -0.533971, -0.732547>, 
      <2.003548, -0.436966, -0.694801>, <2.009701, -0.467837, -0.695683>, <2.009791, -0.515487, -0.689892>, <2.010315, -0.545640, -0.698959>, 
      <2.059192, -0.396346, -0.676829>, <2.066031, -0.450036, -0.674553>, <2.051749, -0.512821, -0.657048>, <2.051678, -0.565978, -0.646612>, 
      <2.085865, -0.402505, -0.644571>, <2.092704, -0.456195, -0.642295>, <2.085699, -0.526538, -0.620219>, <2.085628, -0.579695, -0.609782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.967481, -0.430444, -0.715934>, <2.003548, -0.436966, -0.694801>, <2.059192, -0.396346, -0.676829>, <2.085865, -0.402505, -0.644571>, 
      <1.960354, -0.394691, -0.714913>, <1.996421, -0.401213, -0.693780>, <2.052974, -0.347527, -0.678898>, <2.079646, -0.353687, -0.646640>, 
      <1.933903, -0.351713, -0.727876>, <1.969114, -0.336282, -0.694998>, <2.009813, -0.312520, -0.639370>, <2.051661, -0.293507, -0.618247>, 
      <1.928936, -0.315616, -0.726309>, <1.964147, -0.300185, -0.693430>, <2.001189, -0.264362, -0.645077>, <2.043037, -0.245348, -0.623954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.964208, -0.631619, -0.637152>, <1.996796, -0.623197, -0.614702>, <2.049202, -0.595272, -0.617993>, <2.085628, -0.579695, -0.609782>, 
      <1.964208, -0.631619, -0.637152>, <1.997860, -0.621872, -0.661253>, <2.013840, -0.609524, -0.672756>, <2.050266, -0.593947, -0.664545>, 
      <1.964208, -0.631619, -0.637152>, <1.997860, -0.621872, -0.661253>, <1.980497, -0.584297, -0.726603>, <2.012594, -0.612511, -0.745143>, 
      <1.964208, -0.631619, -0.637152>, <1.965272, -0.630294, -0.683704>, <1.935658, -0.598986, -0.773785>, <1.967754, -0.627201, -0.792325>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.964208, -0.631619, -0.637152>, <1.996796, -0.623197, -0.614702>, <2.049202, -0.595272, -0.617993>, <2.085628, -0.579695, -0.609782>, 
      <1.965272, -0.630294, -0.683704>, <1.997860, -0.621872, -0.661253>, <2.023454, -0.620236, -0.632372>, <2.059880, -0.604659, -0.624161>, 
      <1.935658, -0.598986, -0.773785>, <1.965197, -0.624954, -0.790848>, <2.030141, -0.606580, -0.661528>, <2.027474, -0.643168, -0.639341>, 
      <1.967754, -0.627201, -0.792325>, <1.997294, -0.653168, -0.809388>, <2.002469, -0.626320, -0.679899>, <1.999802, -0.662908, -0.657712>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.950883, -0.858613, -0.651995>, <1.957946, -0.827141, -0.703229>, <1.996035, -0.714575, -0.626381>, <1.999802, -0.662908, -0.657712>, 
      <1.985604, -0.841272, -0.626646>, <1.992667, -0.809800, -0.677880>, <2.023707, -0.694835, -0.608010>, <2.027474, -0.643168, -0.639341>, 
      <2.042302, -0.808520, -0.606762>, <2.046675, -0.770118, -0.659283>, <2.052920, -0.668301, -0.611770>, <2.059880, -0.604659, -0.624161>, 
      <2.062427, -0.791836, -0.568480>, <2.066800, -0.753434, -0.621001>, <2.078668, -0.643337, -0.597391>, <2.085628, -0.579695, -0.609782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.949423, -0.887395, -0.292265>, <1.949510, -0.844613, -0.391718>, <1.938253, -0.914894, -0.560375>, <1.950883, -0.858613, -0.651995>, 
      <1.979749, -0.876179, -0.274178>, <1.979837, -0.833398, -0.373631>, <1.972974, -0.897553, -0.535026>, <1.985604, -0.841272, -0.626646>, 
      <2.029836, -0.866319, -0.261826>, <2.031337, -0.817659, -0.349463>, <2.035579, -0.867557, -0.526018>, <2.042302, -0.808520, -0.606762>, 
      <2.054802, -0.850383, -0.239569>, <2.056304, -0.801724, -0.327205>, <2.055704, -0.850873, -0.487736>, <2.062427, -0.791836, -0.568480>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.950520, -1.036888, -0.237567>, <1.928439, -1.041507, -0.252142>, <1.901459, -1.043241, -0.276038>, <1.880433, -1.045963, -0.292525>, 
      <1.950191, -0.992040, -0.253976>, <1.928110, -0.996659, -0.268551>, <1.898617, -1.004963, -0.293045>, <1.877591, -1.007686, -0.309532>, 
      <1.949385, -0.906267, -0.248395>, <1.924391, -0.915510, -0.263302>, <1.894186, -0.927643, -0.291130>, <1.871136, -0.933820, -0.310179>, 
      <1.949423, -0.887395, -0.292265>, <1.924429, -0.896639, -0.307172>, <1.894010, -0.912196, -0.330166>, <1.870960, -0.918373, -0.349215>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.950520, -1.036888, -0.237567>, <1.950191, -0.992040, -0.253976>, <1.949385, -0.906267, -0.248395>, <1.949423, -0.887395, -0.292265>, 
      <1.981243, -1.030461, -0.217288>, <1.980914, -0.985613, -0.233697>, <1.979711, -0.895051, -0.230308>, <1.979749, -0.876179, -0.274178>, 
      <2.031444, -1.023887, -0.201212>, <2.031170, -0.976213, -0.220034>, <2.029068, -0.891197, -0.217019>, <2.029836, -0.866319, -0.261826>, 
      <2.055715, -1.009297, -0.176829>, <2.055441, -0.961623, -0.195651>, <2.054034, -0.875262, -0.194762>, <2.054802, -0.850383, -0.239569>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.853059, -0.360409, -0.780981>, <1.859390, -0.408586, -0.779143>, <1.877420, -0.472213, -0.775459>, <1.887712, -0.518685, -0.785403>, 
      <1.892029, -0.374202, -0.763904>, <1.898360, -0.422379, -0.762066>, <1.906815, -0.475636, -0.768890>, <1.917107, -0.522108, -0.778834>, 
      <1.929351, -0.423549, -0.738276>, <1.935505, -0.454421, -0.739158>, <1.949844, -0.497007, -0.743086>, <1.950369, -0.527160, -0.752152>, 
      <1.967481, -0.430444, -0.715934>, <1.973635, -0.461315, -0.716816>, <1.971939, -0.503818, -0.723480>, <1.972463, -0.533971, -0.732547>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.853059, -0.360409, -0.780981>, <1.892029, -0.374202, -0.763904>, <1.929351, -0.423549, -0.738276>, <1.967481, -0.430444, -0.715934>, 
      <1.851543, -0.348874, -0.781421>, <1.890513, -0.362667, -0.764344>, <1.922224, -0.387797, -0.737254>, <1.960354, -0.394691, -0.714913>, 
      <1.861811, -0.336029, -0.794972>, <1.882174, -0.334319, -0.775264>, <1.914141, -0.360373, -0.746329>, <1.933903, -0.351713, -0.727876>, 
      <1.862205, -0.324596, -0.792807>, <1.882568, -0.322887, -0.773098>, <1.909175, -0.324276, -0.744761>, <1.928936, -0.315616, -0.726309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.853059, -0.360409, -0.780981>, <1.851543, -0.348874, -0.781421>, <1.861811, -0.336029, -0.794972>, <1.862205, -0.324596, -0.792807>, 
      <1.837997, -0.355078, -0.787581>, <1.836481, -0.343543, -0.788021>, <1.842356, -0.337662, -0.813802>, <1.842749, -0.326229, -0.811637>, 
      <1.814303, -0.369312, -0.789317>, <1.814070, -0.356297, -0.808538>, <1.816393, -0.348943, -0.840257>, <1.816076, -0.326104, -0.836115>, 
      <1.797083, -0.370132, -0.790604>, <1.796850, -0.357117, -0.809826>, <1.796623, -0.349590, -0.858818>, <1.796306, -0.326750, -0.854676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.853059, -0.360409, -0.780981>, <1.837997, -0.355078, -0.787581>, <1.814303, -0.369312, -0.789317>, <1.797083, -0.370132, -0.790604>, 
      <1.859390, -0.408586, -0.779143>, <1.844329, -0.403255, -0.785743>, <1.817479, -0.412706, -0.782948>, <1.800259, -0.413526, -0.784236>, 
      <1.877420, -0.472213, -0.775459>, <1.853646, -0.469444, -0.780772>, <1.828951, -0.472221, -0.769369>, <1.804473, -0.470925, -0.769874>, 
      <1.887712, -0.518685, -0.785403>, <1.863938, -0.515916, -0.790716>, <1.832148, -0.516076, -0.768871>, <1.807670, -0.514780, -0.769376>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.887849, -0.630807, -0.746036>, <1.917436, -0.628105, -0.719406>, <1.932072, -0.639924, -0.659291>, <1.964208, -0.631619, -0.637152>, 
      <1.889926, -0.634231, -0.765407>, <1.919513, -0.631529, -0.738777>, <1.933136, -0.638598, -0.705843>, <1.965272, -0.630294, -0.683704>, 
      <1.890519, -0.623328, -0.814639>, <1.912633, -0.617057, -0.813479>, <1.920191, -0.604053, -0.790060>, <1.935658, -0.598986, -0.773785>, 
      <1.894774, -0.642220, -0.810607>, <1.916889, -0.635949, -0.809446>, <1.952288, -0.632268, -0.808599>, <1.967754, -0.627201, -0.792325>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.878585, -0.883651, -0.702699>, <1.882826, -0.857715, -0.749653>, <1.902021, -0.757359, -0.707575>, <1.905309, -0.708326, -0.729490>, 
      <1.902806, -0.878793, -0.690534>, <1.907047, -0.852858, -0.737488>, <1.933565, -0.749820, -0.687547>, <1.936853, -0.700786, -0.709463>, 
      <1.930258, -0.868914, -0.667053>, <1.937321, -0.837441, -0.718287>, <1.968736, -0.734049, -0.644504>, <1.972503, -0.682382, -0.675835>, 
      <1.950883, -0.858613, -0.651995>, <1.957946, -0.827141, -0.703229>, <1.996035, -0.714575, -0.626381>, <1.999802, -0.662908, -0.657712>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.878585, -0.883651, -0.702699>, <1.902806, -0.878793, -0.690534>, <1.930258, -0.868914, -0.667053>, <1.950883, -0.858613, -0.651995>, 
      <1.870184, -0.935022, -0.609695>, <1.894405, -0.930164, -0.597530>, <1.917628, -0.925194, -0.575433>, <1.938253, -0.914894, -0.560375>, 
      <1.870514, -0.879157, -0.448317>, <1.893564, -0.872980, -0.429268>, <1.924516, -0.853857, -0.406625>, <1.949510, -0.844613, -0.391718>, 
      <1.870960, -0.918373, -0.349215>, <1.894010, -0.912196, -0.330166>, <1.924429, -0.896639, -0.307172>, <1.949423, -0.887395, -0.292265>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.806809, -0.645994, -0.778823>, <1.807773, -0.653775, -0.785357>, <1.809538, -0.661735, -0.800679>, <1.810024, -0.671929, -0.800603>, 
      <1.781197, -0.645917, -0.780873>, <1.782162, -0.653698, -0.787407>, <1.784657, -0.664426, -0.797304>, <1.785144, -0.674620, -0.797227>, 
      <1.745020, -0.632807, -0.774933>, <1.745821, -0.641800, -0.783590>, <1.748744, -0.655450, -0.802020>, <1.748802, -0.667706, -0.799523>, 
      <1.724958, -0.630319, -0.759075>, <1.725759, -0.639312, -0.767731>, <1.727571, -0.648040, -0.790426>, <1.727628, -0.660296, -0.787929>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.806809, -0.645994, -0.778823>, <1.833343, -0.646073, -0.776699>, <1.868109, -0.632610, -0.763803>, <1.887849, -0.630807, -0.746036>, 
      <1.807773, -0.653775, -0.785357>, <1.834308, -0.653854, -0.783233>, <1.870187, -0.636034, -0.783175>, <1.889926, -0.634231, -0.765407>, 
      <1.809538, -0.661735, -0.800679>, <1.836247, -0.658847, -0.804303>, <1.864472, -0.630714, -0.816006>, <1.890519, -0.623328, -0.814639>, 
      <1.810024, -0.671929, -0.800603>, <1.836734, -0.669041, -0.804227>, <1.868727, -0.649606, -0.811974>, <1.894774, -0.642220, -0.810607>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.799911, -0.888893, -0.727824>, <1.799427, -0.937661, -0.644942>, <1.806966, -0.889473, -0.498650>, <1.807630, -0.925394, -0.409446>, 
      <1.778122, -0.888126, -0.730277>, <1.777638, -0.936894, -0.647395>, <1.774770, -0.888722, -0.500259>, <1.775434, -0.924643, -0.411055>, 
      <1.746870, -0.883334, -0.729683>, <1.744167, -0.935775, -0.633701>, <1.744358, -0.910934, -0.483692>, <1.740277, -0.921846, -0.374907>, 
      <1.728003, -0.878348, -0.719654>, <1.725301, -0.930789, -0.623672>, <1.718480, -0.903809, -0.465823>, <1.714399, -0.914721, -0.357038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.799911, -0.888893, -0.727824>, <1.778122, -0.888126, -0.730277>, <1.746870, -0.883334, -0.729683>, <1.728003, -0.878348, -0.719654>, 
      <1.800195, -0.860327, -0.776372>, <1.778405, -0.859560, -0.778825>, <1.748180, -0.857895, -0.776244>, <1.729314, -0.852909, -0.766215>, 
      <1.807297, -0.761679, -0.760459>, <1.780021, -0.760898, -0.762693>, <1.747299, -0.757157, -0.744444>, <1.725387, -0.753821, -0.728371>, 
      <1.809784, -0.708326, -0.778356>, <1.782508, -0.707545, -0.780590>, <1.747212, -0.706508, -0.760303>, <1.725300, -0.703172, -0.744230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.799911, -0.888893, -0.727824>, <1.800195, -0.860327, -0.776372>, <1.807297, -0.761679, -0.760459>, <1.809784, -0.708326, -0.778356>, 
      <1.824566, -0.889761, -0.725048>, <1.824850, -0.861196, -0.773596>, <1.839366, -0.762597, -0.757833>, <1.841853, -0.709244, -0.775730>, 
      <1.856748, -0.888031, -0.713667>, <1.860989, -0.862095, -0.760622>, <1.875383, -0.763726, -0.724487>, <1.878671, -0.714693, -0.746403>, 
      <1.878585, -0.883651, -0.702699>, <1.882826, -0.857715, -0.749653>, <1.902021, -0.757359, -0.707575>, <1.905309, -0.708326, -0.729490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.799911, -0.888893, -0.727824>, <1.824566, -0.889761, -0.725048>, <1.856748, -0.888031, -0.713667>, <1.878585, -0.883651, -0.702699>, 
      <1.799427, -0.937661, -0.644942>, <1.824082, -0.938530, -0.642165>, <1.848347, -0.939402, -0.620663>, <1.870184, -0.935022, -0.609695>, 
      <1.806966, -0.889473, -0.498650>, <1.833230, -0.890086, -0.497338>, <1.850657, -0.884478, -0.464727>, <1.870514, -0.879157, -0.448317>, 
      <1.807630, -0.925394, -0.409446>, <1.833894, -0.926007, -0.408134>, <1.851103, -0.923694, -0.365625>, <1.870960, -0.918373, -0.349215>
    }
  }
  texture {
    Clear_Glass
  }
  scale <1.2, 1.2, 1.0>
  rotate <90.0, -0.0, -135.934219>
  translate  <-16.731694, -3.599497, 2.066322>
}
#declare Collar = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.039719, 1.455705, -0.564575>, <1.098470, 1.458636, -0.547188>, <1.180951, 1.458677, -0.539877>, <1.242090, 1.456567, -0.535389>, 
      <1.055491, 1.414002, -0.424138>, <1.114242, 1.416933, -0.406752>, <1.164182, 1.377759, -0.420335>, <1.225322, 1.375650, -0.415847>, 
      <1.146738, 1.096100, -0.542517>, <1.174116, 1.097382, -0.528206>, <1.204849, 1.108616, -0.507227>, <1.235535, 1.108423, -0.503445>, 
      <1.080132, 0.969665, -0.506625>, <1.107510, 0.970947, -0.492314>, <1.143633, 0.982069, -0.470384>, <1.174319, 0.981876, -0.466602>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.932491, 1.441119, -0.627010>, <0.964098, 1.445908, -0.607444>, <1.003820, 1.453914, -0.575199>, <1.039719, 1.455705, -0.564575>, 
      <0.910258, 1.347267, -0.523420>, <0.941866, 1.352056, -0.503854>, <1.019592, 1.412211, -0.434762>, <1.055491, 1.414002, -0.424138>, 
      <1.012472, 1.082285, -0.626796>, <1.056102, 1.089226, -0.600634>, <1.101275, 1.093970, -0.566283>, <1.146738, 1.096100, -0.542517>, 
      <0.932414, 0.970546, -0.593055>, <0.976044, 0.977487, -0.566893>, <1.034669, 0.967536, -0.530390>, <1.080132, 0.969665, -0.506625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.788404, 1.417629, -0.720149>, <0.827248, 1.426235, -0.686742>, <0.888681, 1.434481, -0.654130>, <0.932491, 1.441119, -0.627010>, 
      <0.780400, 1.332209, -0.598621>, <0.819244, 1.340815, -0.565214>, <0.866448, 1.340630, -0.550541>, <0.910258, 1.347267, -0.523420>, 
      <0.884232, 1.031954, -0.715478>, <0.925949, 1.043508, -0.685564>, <0.967759, 1.075171, -0.653607>, <1.012472, 1.082285, -0.626796>, 
      <0.788513, 0.923270, -0.681489>, <0.830230, 0.934824, -0.651575>, <0.887701, 0.963432, -0.619866>, <0.932414, 0.970546, -0.593055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.654305, 1.379487, -0.866257>, <0.691608, 1.390926, -0.819907>, <0.743104, 1.407593, -0.759108>, <0.788404, 1.417629, -0.720149>, 
      <0.699350, 1.250592, -0.810612>, <0.736653, 1.262031, -0.764262>, <0.735100, 1.322173, -0.637580>, <0.780400, 1.332209, -0.598621>, 
      <0.758230, 0.994570, -0.820898>, <0.794272, 1.004216, -0.783440>, <0.842316, 1.020345, -0.745535>, <0.884232, 1.031954, -0.715478>, 
      <0.654662, 0.893620, -0.792224>, <0.690704, 0.903266, -0.754767>, <0.746597, 0.911661, -0.711546>, <0.788513, 0.923270, -0.681489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.581971, 1.354329, -0.976647>, <0.596309, 1.365159, -0.940567>, <0.629488, 1.371877, -0.897092>, <0.654305, 1.379487, -0.866257>, 
      <0.688736, 1.303867, -0.888004>, <0.703074, 1.314696, -0.851924>, <0.674533, 1.242982, -0.841447>, <0.699350, 1.250592, -0.810612>, 
      <0.719927, 0.943933, -0.901854>, <0.732727, 0.951592, -0.871141>, <0.734953, 0.988340, -0.845088>, <0.758230, 0.994570, -0.820898>, 
      <0.592729, 0.870871, -0.884960>, <0.605528, 0.878530, -0.854247>, <0.631386, 0.887390, -0.816415>, <0.654662, 0.893620, -0.792224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.568001, 1.314300, -1.083433>, <0.566408, 1.324538, -1.050559>, <0.569710, 1.345068, -1.007501>, <0.581971, 1.354329, -0.976647>, 
      <0.679939, 1.234965, -1.039890>, <0.678346, 1.245203, -1.007016>, <0.676475, 1.294606, -0.918858>, <0.688736, 1.303867, -0.888004>, 
      <0.692417, 0.913891, -1.006347>, <0.694100, 0.924708, -0.971617>, <0.706277, 0.935764, -0.934610>, <0.719927, 0.943933, -0.901854>, 
      <0.568001, 0.841761, -1.000175>, <0.569684, 0.852577, -0.965445>, <0.579079, 0.862702, -0.917716>, <0.592729, 0.870871, -0.884960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.592729, 1.285190, -1.198648>, <0.579079, 1.293359, -1.165892>, <0.569684, 1.303484, -1.118163>, <0.568001, 1.314300, -1.083433>, 
      <0.704260, 1.198146, -1.156375>, <0.690610, 1.206315, -1.123619>, <0.681622, 1.224149, -1.074620>, <0.679939, 1.234965, -1.039890>, 
      <0.710998, 0.873487, -1.104472>, <0.698737, 0.882748, -1.073618>, <0.690824, 0.903653, -1.039221>, <0.692417, 0.913891, -1.006347>, 
      <0.581971, 0.801732, -1.106961>, <0.569710, 0.810993, -1.076107>, <0.566408, 0.831523, -1.033049>, <0.568001, 0.841761, -1.000175>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.654662, 1.262441, -1.291384>, <0.631386, 1.268671, -1.267194>, <0.605528, 1.277531, -1.229361>, <0.592729, 1.285190, -1.198648>, 
      <0.666935, 1.119155, -1.258859>, <0.643658, 1.125385, -1.234668>, <0.717059, 1.190487, -1.187088>, <0.704260, 1.198146, -1.156375>, 
      <0.761973, 0.875847, -1.200267>, <0.737156, 0.883456, -1.169431>, <0.725336, 0.862657, -1.140551>, <0.710998, 0.873487, -1.104472>, 
      <0.654305, 0.776574, -1.217351>, <0.629488, 0.784184, -1.186516>, <0.596309, 0.790902, -1.143041>, <0.581971, 0.801732, -1.106961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.788513, 1.232791, -1.402119>, <0.746597, 1.244400, -1.372062>, <0.690704, 1.252795, -1.328841>, <0.654662, 1.262441, -1.291384>, 
      <0.797222, 1.084862, -1.415190>, <0.755306, 1.096471, -1.385133>, <0.702977, 1.109509, -1.296316>, <0.666935, 1.119155, -1.258859>, 
      <0.888675, 0.844297, -1.333998>, <0.843375, 0.854333, -1.295039>, <0.799276, 0.864408, -1.246617>, <0.761973, 0.875847, -1.200267>, 
      <0.788404, 0.738432, -1.363459>, <0.743104, 0.748468, -1.324500>, <0.691608, 0.765136, -1.263701>, <0.654305, 0.776574, -1.217351>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.932491, 0.714942, -1.456598>, <1.001622, 0.833144, -1.420788>, <0.934272, 1.053316, -1.541083>, <0.932414, 1.185515, -1.490553>, 
      <0.888681, 0.721580, -1.429478>, <0.957812, 0.839782, -1.393667>, <0.889559, 1.060430, -1.514271>, <0.887701, 1.192629, -1.463742>, 
      <0.827248, 0.729826, -1.396866>, <0.927519, 0.835691, -1.367405>, <0.838939, 1.073308, -1.445104>, <0.830230, 1.221237, -1.432033>, 
      <0.788404, 0.738432, -1.363459>, <0.888675, 0.844297, -1.333998>, <0.797222, 1.084862, -1.415190>, <0.788513, 1.232791, -1.402119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.039719, 0.700356, -1.519033>, <1.111764, 0.820082, -1.472282>, <1.063309, 1.063534, -1.656559>, <1.080132, 1.186396, -1.576983>, 
      <1.003820, 0.702147, -1.508409>, <1.075865, 0.821873, -1.461659>, <1.017845, 1.065663, -1.632793>, <1.034669, 1.188525, -1.553218>, 
      <0.964098, 0.710153, -1.476164>, <1.033230, 0.828356, -1.440354>, <0.977902, 1.046375, -1.567245>, <0.976044, 1.178574, -1.516715>, 
      <0.932491, 0.714942, -1.456598>, <1.001622, 0.833144, -1.420788>, <0.934272, 1.053316, -1.541083>, <0.932414, 1.185515, -1.490553>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.174319, 1.174185, -1.617006>, <1.143633, 1.173992, -1.613224>, <1.107510, 1.185114, -1.591294>, <1.080132, 1.186396, -1.576983>, 
      <1.210001, 1.061750, -1.701884>, <1.179314, 1.061557, -1.698102>, <1.090686, 1.062252, -1.670870>, <1.063309, 1.063534, -1.656559>, 
      <1.280209, 0.832497, -1.503765>, <1.219070, 0.830388, -1.499277>, <1.170515, 0.817150, -1.489669>, <1.111764, 0.820082, -1.472282>, 
      <1.242090, 0.699494, -1.548219>, <1.180951, 0.697384, -1.543731>, <1.098470, 0.697425, -1.536420>, <1.039719, 0.700356, -1.519033>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.746217, 1.175485, -1.490553>, <1.786011, 1.184664, -1.457374>, <1.848116, 1.212012, -1.432033>, <1.889740, 1.223895, -1.402119>, 
      <1.745976, 1.034903, -1.487783>, <1.785770, 1.044081, -1.454603>, <1.834949, 1.086326, -1.354072>, <1.876574, 1.098208, -1.324157>, 
      <1.777091, 0.831671, -1.346997>, <1.822469, 0.841349, -1.308037>, <1.870510, 0.867041, -1.256117>, <1.907902, 0.878185, -1.209767>, 
      <1.888389, 0.747333, -1.363459>, <1.933767, 0.757011, -1.324500>, <1.985394, 0.773272, -1.263701>, <2.022786, 0.784415, -1.217351>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.680017, 1.175521, -1.576983>, <1.705608, 1.177583, -1.556794>, <1.721516, 1.169788, -1.511148>, <1.746217, 1.175485, -1.490553>, 
      <1.676814, 1.044985, -1.630771>, <1.702405, 1.047048, -1.610582>, <1.721275, 1.029205, -1.508377>, <1.745976, 1.034903, -1.487783>, 
      <1.668960, 0.841497, -1.429807>, <1.712821, 0.847789, -1.402687>, <1.738180, 0.823372, -1.380403>, <1.777091, 0.831671, -1.346997>, 
      <1.744121, 0.724981, -1.456598>, <1.787982, 0.731272, -1.429478>, <1.849478, 0.739034, -1.396866>, <1.888389, 0.747333, -1.363459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.585930, 1.162567, -1.617006>, <1.616494, 1.161132, -1.612559>, <1.655791, 1.173569, -1.596095>, <1.680017, 1.175521, -1.576983>, 
      <1.582628, 1.046478, -1.694087>, <1.613192, 1.045043, -1.689641>, <1.652588, 1.043033, -1.649883>, <1.676814, 1.044985, -1.630771>, 
      <1.569964, 0.826572, -1.478248>, <1.605876, 0.828080, -1.467625>, <1.637316, 0.836958, -1.449373>, <1.668960, 0.841497, -1.429807>, 
      <1.636782, 0.711242, -1.519033>, <1.672694, 0.712750, -1.508409>, <1.712477, 0.720442, -1.476164>, <1.744121, 0.724981, -1.456598>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.404910, 1.188438, -1.617006>, <1.366584, 1.232937, -1.653813>, <1.243107, 1.174618, -1.625483>, <1.174319, 1.174185, -1.617006>, 
      <1.354608, 1.083422, -1.701939>, <1.316282, 1.127921, -1.738746>, <1.278788, 1.062183, -1.710361>, <1.210001, 1.061750, -1.701884>, 
      <1.437646, 0.847554, -1.493856>, <1.379075, 0.843180, -1.493856>, <1.338751, 0.834517, -1.508062>, <1.280209, 0.832497, -1.503765>, 
      <1.437326, 0.714075, -1.548219>, <1.378755, 0.709701, -1.548219>, <1.300632, 0.701514, -1.552516>, <1.242090, 0.699494, -1.548219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.436355, 1.019638, -0.660172>, <1.490003, 1.046448, -0.660172>, <1.555389, 1.107660, -0.655708>, <1.615180, 1.109003, -0.660172>, 
      <1.436647, 1.146343, -0.622737>, <1.490294, 1.173152, -0.622737>, <1.501157, 1.208185, -0.618273>, <1.560949, 1.209528, -0.622737>, 
      <1.457803, 1.475858, -0.661440>, <1.456928, 1.476487, -0.661440>, <1.487575, 1.343545, -0.572668>, <1.488641, 1.343560, -0.572824>, 
      <1.437326, 1.441986, -0.535389>, <1.436451, 1.442615, -0.535389>, <1.433344, 1.444069, -0.535233>, <1.434410, 1.444084, -0.535389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.888731, 0.946600, -1.367386>, <1.935584, 0.957776, -1.361527>, <1.999037, 0.972781, -1.356082>, <2.043777, 0.984796, -1.341645>, 
      <1.845976, 1.015266, -1.404336>, <1.892830, 1.026441, -1.398477>, <1.952826, 1.044511, -1.374225>, <1.997566, 1.056526, -1.359787>, 
      <1.746369, 1.264396, -1.492305>, <1.786163, 1.273574, -1.459126>, <1.855850, 1.285851, -1.477835>, <1.897475, 1.297734, -1.447920>, 
      <1.746217, 1.175485, -1.490553>, <1.786011, 1.184664, -1.457374>, <1.848116, 1.212012, -1.432033>, <1.889740, 1.223895, -1.402119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.748770, 0.914431, -1.378534>, <1.791163, 0.921752, -1.374469>, <1.847004, 0.936648, -1.372604>, <1.888731, 0.946600, -1.367386>, 
      <1.728144, 0.992758, -1.438069>, <1.770537, 1.000079, -1.434004>, <1.804250, 1.005313, -1.409554>, <1.845976, 1.015266, -1.404336>, 
      <1.682297, 1.268439, -1.538696>, <1.707888, 1.270502, -1.518507>, <1.721669, 1.258698, -1.512900>, <1.746369, 1.264396, -1.492305>, 
      <1.680017, 1.175521, -1.576983>, <1.705608, 1.177583, -1.556794>, <1.721516, 1.169788, -1.511148>, <1.746217, 1.175485, -1.490553>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.642267, 0.904041, -1.391018>, <1.674444, 0.905758, -1.388517>, <1.717062, 0.908956, -1.381574>, <1.748770, 0.914431, -1.378534>, 
      <1.625366, 0.981599, -1.458814>, <1.657543, 0.983316, -1.456313>, <1.696436, 0.987283, -1.441109>, <1.728144, 0.992758, -1.438069>, 
      <1.588403, 1.249508, -1.559279>, <1.618967, 1.248073, -1.554833>, <1.658071, 1.266487, -1.557808>, <1.682297, 1.268439, -1.538696>, 
      <1.585930, 1.162567, -1.617006>, <1.616494, 1.161132, -1.612559>, <1.655791, 1.173569, -1.596095>, <1.680017, 1.175521, -1.576983>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.527643, 0.902631, -1.395722>, <1.490760, 0.903037, -1.396452>, <1.441620, 0.905942, -1.395722>, <1.404735, 0.906657, -1.395722>, 
      <1.527643, 0.902631, -1.395722>, <1.453940, 0.988779, -1.462838>, <1.441672, 0.990476, -1.462107>, <1.404787, 0.991192, -1.462107>, 
      <1.527643, 0.902631, -1.395722>, <1.453940, 0.988779, -1.462838>, <1.504314, 1.202872, -1.492440>, <1.464346, 1.119429, -1.559926>, 
      <1.527643, 0.902631, -1.395722>, <1.490823, 0.988373, -1.462107>, <1.444878, 1.271881, -1.549521>, <1.404910, 1.188438, -1.617006>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.527643, 0.902631, -1.395722>, <1.562052, 0.902252, -1.395041>, <1.608000, 0.902213, -1.393682>, <1.642267, 0.904041, -1.391018>, 
      <1.490823, 0.988373, -1.462107>, <1.525233, 0.987994, -1.461426>, <1.591099, 0.979770, -1.461478>, <1.625366, 0.981599, -1.458814>, 
      <1.444878, 1.271881, -1.549521>, <1.480978, 1.303096, -1.576573>, <1.534175, 1.252054, -1.567168>, <1.588403, 1.249508, -1.559279>, 
      <1.404910, 1.188438, -1.617006>, <1.441010, 1.219653, -1.644058>, <1.531702, 1.165113, -1.624895>, <1.585930, 1.162567, -1.617006>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.636782, 1.444819, -0.564575>, <1.578009, 1.447287, -0.547188>, <1.495098, 1.444946, -0.544269>, <1.434410, 1.444084, -0.535389>, 
      <1.714719, 1.461294, -0.672573>, <1.655947, 1.463761, -0.655186>, <1.549329, 1.344422, -0.581704>, <1.488641, 1.343560, -0.572824>, 
      <1.710499, 1.151999, -0.647470>, <1.666580, 1.154704, -0.634326>, <1.606735, 1.210556, -0.626155>, <1.560949, 1.209528, -0.622737>, 
      <1.742092, 1.026504, -0.682997>, <1.698173, 1.029209, -0.669852>, <1.660966, 1.110031, -0.663590>, <1.615180, 1.109003, -0.660172>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.023352, 1.254601, -1.291384>, <1.987387, 1.244671, -1.328841>, <1.931563, 1.235834, -1.372062>, <1.889740, 1.223895, -1.402119>, 
      <2.049282, 1.318168, -1.339820>, <2.013317, 1.308238, -1.377277>, <1.939298, 1.309673, -1.417863>, <1.897475, 1.297734, -1.447920>, 
      <2.135641, 1.094464, -1.277940>, <2.091203, 1.097586, -1.297047>, <2.042259, 1.068529, -1.345365>, <1.997566, 1.056526, -1.359787>, 
      <2.183765, 1.025834, -1.272179>, <2.139327, 1.028956, -1.291286>, <2.088470, 0.996799, -1.327223>, <2.043777, 0.984796, -1.341645>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.023352, 1.254601, -1.291384>, <1.978207, 1.143929, -1.207056>, <1.971215, 0.886248, -1.112382>, <2.095316, 0.809001, -1.106961>, 
      <1.987387, 1.244671, -1.328841>, <1.942242, 1.133998, -1.244514>, <1.956792, 0.875532, -1.148462>, <2.080893, 0.798285, -1.143041>, 
      <1.931563, 1.235834, -1.372062>, <1.918397, 1.110148, -1.294100>, <1.932779, 0.885598, -1.178931>, <2.047662, 0.791829, -1.186516>, 
      <1.889740, 1.223895, -1.402119>, <1.876574, 1.098208, -1.324157>, <1.907902, 0.878185, -1.209767>, <2.022786, 0.784415, -1.217351>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.085104, 1.277838, -1.198648>, <1.970433, 1.235070, -1.126689>, <1.987301, 0.919496, -1.014945>, <2.109601, 0.848918, -1.000175>, 
      <2.072366, 1.270078, -1.229361>, <1.957694, 1.227310, -1.157402>, <1.988813, 0.909245, -1.047819>, <2.111113, 0.838668, -1.033049>, 
      <2.046579, 1.261014, -1.267193>, <2.001434, 1.150342, -1.182866>, <1.983549, 0.895412, -1.081528>, <2.107650, 0.818165, -1.076107>, 
      <2.023352, 1.254601, -1.291384>, <1.978207, 1.143929, -1.207056>, <1.971215, 0.886248, -1.112382>, <2.095316, 0.809001, -1.106961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.085104, 1.277838, -1.198648>, <2.072366, 1.270078, -1.229361>, <2.046579, 1.261014, -1.267193>, <2.023352, 1.254601, -1.291384>, 
      <2.194651, 1.318695, -1.267391>, <2.181912, 1.310935, -1.298104>, <2.072509, 1.324582, -1.315629>, <2.049282, 1.318168, -1.339820>, 
      <2.309553, 1.054910, -1.189803>, <2.252299, 1.064613, -1.235937>, <2.203635, 1.089688, -1.248706>, <2.135641, 1.094464, -1.277940>, 
      <2.405746, 0.959369, -1.186012>, <2.348491, 0.969072, -1.232146>, <2.251759, 1.021058, -1.242944>, <2.183765, 1.025834, -1.272179>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.109601, 1.307143, -1.083433>, <1.991689, 1.269236, -1.014031>, <1.964071, 0.948035, -0.910143>, <2.085104, 0.878223, -0.884960>, 
      <2.108003, 1.296314, -1.118163>, <1.990092, 1.258406, -1.048761>, <1.977657, 0.939758, -0.942899>, <2.098690, 0.869947, -0.917716>, 
      <2.098690, 1.286114, -1.165892>, <1.984018, 1.243346, -1.093933>, <1.985703, 0.930325, -0.980214>, <2.108003, 0.859747, -0.965445>, 
      <2.085104, 1.277838, -1.198648>, <1.970433, 1.235070, -1.126689>, <1.987301, 0.919496, -1.014945>, <2.109601, 0.848918, -1.000175>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.109601, 1.307143, -1.083433>, <2.108003, 1.296314, -1.118163>, <2.098690, 1.286114, -1.165892>, <2.085104, 1.277838, -1.198648>, 
      <2.220881, 1.342918, -1.148931>, <2.219284, 1.332089, -1.183661>, <2.208236, 1.326971, -1.234635>, <2.194651, 1.318695, -1.267391>, 
      <2.326755, 1.082225, -1.082410>, <2.341236, 1.080362, -1.111425>, <2.334628, 1.050661, -1.169598>, <2.309553, 1.054910, -1.189803>, 
      <2.419822, 0.985831, -1.081971>, <2.434302, 0.983968, -1.110987>, <2.430821, 0.955120, -1.165807>, <2.405746, 0.959369, -1.186012>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.095316, 1.347060, -0.976647>, <1.977120, 1.317429, -0.895720>, <1.925156, 1.002632, -0.831201>, <2.023352, 0.901460, -0.792224>, 
      <2.107650, 1.337896, -1.007501>, <1.989454, 1.308266, -0.926574>, <1.946526, 0.994588, -0.856585>, <2.044722, 0.893416, -0.817609>, 
      <2.111113, 1.317393, -1.050559>, <1.993201, 1.279486, -0.981157>, <1.951333, 0.955795, -0.879430>, <2.072366, 0.885983, -0.854247>, 
      <2.109601, 1.307143, -1.083433>, <1.991689, 1.269236, -1.014031>, <1.964071, 0.948035, -0.910143>, <2.085104, 0.878223, -0.884960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.095316, 1.347060, -0.976647>, <2.107650, 1.337896, -1.007501>, <2.111113, 1.317393, -1.050559>, <2.109601, 1.307143, -1.083433>, 
      <2.199530, 1.373185, -1.048001>, <2.211864, 1.364022, -1.078855>, <2.222394, 1.353169, -1.116057>, <2.220881, 1.342918, -1.148931>, 
      <2.242584, 1.084687, -0.982874>, <2.271585, 1.070021, -1.014010>, <2.306691, 1.084806, -1.042205>, <2.326755, 1.082225, -1.082410>, 
      <2.305698, 0.972241, -0.985543>, <2.334700, 0.957575, -1.016679>, <2.399757, 0.988413, -1.041767>, <2.419822, 0.985831, -1.081971>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.022786, 1.371646, -0.866257>, <1.910814, 1.311907, -0.803544>, <1.859389, 1.036531, -0.763270>, <1.941800, 0.932166, -0.714735>, 
      <2.047662, 1.364233, -0.897092>, <1.935690, 1.304493, -0.834380>, <1.885766, 1.027557, -0.784426>, <1.968177, 0.923192, -0.735890>, 
      <2.080893, 1.357776, -0.940567>, <1.962697, 1.328145, -0.859640>, <1.903260, 1.010874, -0.805191>, <2.001456, 0.909702, -0.766215>, 
      <2.095316, 1.347060, -0.976647>, <1.977120, 1.317429, -0.895720>, <1.925156, 1.002632, -0.831201>, <2.023352, 0.901460, -0.792224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.022786, 1.371646, -0.866257>, <2.047662, 1.364233, -0.897092>, <2.080893, 1.357776, -0.940567>, <2.095316, 1.347060, -0.976647>, 
      <2.106420, 1.416267, -0.913098>, <2.131296, 1.408853, -0.943934>, <2.185108, 1.383901, -1.011922>, <2.199530, 1.373185, -1.048001>, 
      <2.165072, 1.170168, -0.871633>, <2.204695, 1.162502, -0.906038>, <2.208411, 1.101968, -0.946186>, <2.242584, 1.084687, -0.982874>, 
      <2.226052, 1.083820, -0.873937>, <2.265675, 1.076154, -0.908342>, <2.271526, 0.989522, -0.948855>, <2.305698, 0.972241, -0.985543>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.022786, 1.371646, -0.866257>, <2.106420, 1.416267, -0.913098>, <2.165072, 1.170168, -0.871633>, <2.226052, 1.083820, -0.873937>, 
      <1.985394, 1.382790, -0.819907>, <2.069028, 1.427410, -0.866749>, <2.127308, 1.177474, -0.838843>, <2.188287, 1.091126, -0.841147>, 
      <1.933767, 1.399050, -0.759108>, <2.047315, 1.413920, -0.831499>, <2.078080, 1.130808, -0.794067>, <2.139151, 1.012267, -0.818009>, 
      <1.888389, 1.408728, -0.720149>, <2.001937, 1.423599, -0.792540>, <2.030888, 1.132134, -0.776013>, <2.091959, 1.013593, -0.799955>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.744121, 1.431080, -0.627010>, <1.807219, 1.472185, -0.708411>, <1.821442, 1.195305, -0.700378>, <1.854579, 1.094259, -0.731822>, 
      <1.787982, 1.424789, -0.654130>, <1.851080, 1.465894, -0.735531>, <1.895317, 1.192579, -0.725074>, <1.928455, 1.091533, -0.756518>, 
      <1.849478, 1.417027, -0.686742>, <1.963026, 1.431897, -0.759134>, <1.958117, 1.134179, -0.748173>, <2.019189, 1.015638, -0.772115>, 
      <1.888389, 1.408728, -0.720149>, <2.001937, 1.423599, -0.792540>, <2.030888, 1.132134, -0.776013>, <2.091959, 1.013593, -0.799955>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.744121, 1.431080, -0.627010>, <1.663767, 1.378733, -0.523348>, <1.627138, 1.103775, -0.550894>, <1.680017, 0.980540, -0.506625>, 
      <1.712477, 1.435619, -0.607444>, <1.632123, 1.383272, -0.503782>, <1.601705, 1.105819, -0.533430>, <1.654584, 0.982583, -0.489161>, 
      <1.672694, 1.443311, -0.575199>, <1.591742, 1.426199, -0.463024>, <1.581085, 1.123002, -0.513150>, <1.616494, 0.994929, -0.471048>, 
      <1.636782, 1.444819, -0.564575>, <1.555831, 1.427707, -0.452400>, <1.550521, 1.121567, -0.508703>, <1.585930, 0.993494, -0.466602>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.744121, 1.431080, -0.627010>, <1.712477, 1.435619, -0.607444>, <1.672694, 1.443311, -0.575199>, <1.636782, 1.444819, -0.564575>, 
      <1.807219, 1.472185, -0.708411>, <1.775575, 1.476725, -0.688845>, <1.750631, 1.459786, -0.683196>, <1.714719, 1.461294, -0.672573>, 
      <1.821442, 1.195305, -0.700378>, <1.781605, 1.196775, -0.687061>, <1.750695, 1.149523, -0.659501>, <1.710499, 1.151999, -0.647470>, 
      <1.854579, 1.094259, -0.731822>, <1.814742, 1.095729, -0.718505>, <1.782288, 1.024029, -0.695027>, <1.742092, 1.026504, -0.682997>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.201471, 1.112902, -0.660172>, <1.277147, 1.112419, -0.655578>, <1.365890, 1.047617, -0.660172>, <1.436355, 1.019638, -0.660172>, 
      <1.213657, 1.216002, -0.622737>, <1.289333, 1.215518, -0.618144>, <1.366181, 1.174322, -0.622737>, <1.436647, 1.146343, -0.622737>, 
      <1.254824, 1.518016, -0.626170>, <1.313366, 1.515996, -0.621873>, <1.399232, 1.480232, -0.661440>, <1.457803, 1.475858, -0.661440>, 
      <1.242090, 1.456567, -0.535389>, <1.300632, 1.454547, -0.531092>, <1.378755, 1.446360, -0.535389>, <1.437326, 1.441986, -0.535389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.060324, 1.022039, -0.682997>, <1.108904, 1.025417, -0.668450>, <1.150743, 1.113226, -0.663251>, <1.201471, 1.112902, -0.660172>, 
      <1.054143, 1.152139, -0.647470>, <1.102722, 1.155516, -0.632924>, <1.162929, 1.216326, -0.625816>, <1.213657, 1.216002, -0.622737>, 
      <1.025268, 1.493916, -0.693251>, <1.084019, 1.496847, -0.675864>, <1.193685, 1.520126, -0.630658>, <1.254824, 1.518016, -0.626170>, 
      <1.039719, 1.455705, -0.564575>, <1.098470, 1.458636, -0.547188>, <1.180951, 1.458677, -0.539877>, <1.242090, 1.456567, -0.535389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.962197, 1.096268, -0.731822>, <0.998453, 1.098397, -0.715760>, <1.022365, 1.019400, -0.694364>, <1.060324, 1.022039, -0.682997>, 
      <0.953285, 1.199723, -0.700378>, <0.989541, 1.201852, -0.684316>, <1.016184, 1.149500, -0.658837>, <1.054143, 1.152139, -0.647470>, 
      <0.949533, 1.513060, -0.706415>, <0.981140, 1.517848, -0.686849>, <0.989369, 1.492125, -0.703874>, <1.025268, 1.493916, -0.693251>, 
      <0.932491, 1.441119, -0.627010>, <0.964098, 1.445908, -0.607444>, <1.003820, 1.453914, -0.575199>, <1.039719, 1.455705, -0.564575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.796315, 1.006537, -0.799955>, <0.852513, 1.008548, -0.778583>, <0.907274, 1.093043, -0.756153>, <0.962197, 1.096268, -0.731822>, 
      <0.793942, 1.129865, -0.776013>, <0.850139, 1.131876, -0.754641>, <0.898362, 1.196498, -0.724710>, <0.953285, 1.199723, -0.700378>, 
      <0.795165, 1.489780, -0.822799>, <0.834009, 1.498385, -0.789393>, <0.905723, 1.506422, -0.733536>, <0.949533, 1.513060, -0.706415>, 
      <0.788404, 1.417629, -0.720149>, <0.827248, 1.426235, -0.686742>, <0.888681, 1.434481, -0.654130>, <0.932491, 1.441119, -0.627010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.588515, 1.082898, -0.873937>, <0.648020, 1.097266, -0.839930>, <0.730900, 1.004197, -0.824834>, <0.796315, 1.006537, -0.799955>, 
      <0.608252, 1.171875, -0.871633>, <0.667756, 1.186242, -0.837626>, <0.728526, 1.127524, -0.800892>, <0.793942, 1.129865, -0.776013>, 
      <0.626452, 1.459187, -0.900664>, <0.663755, 1.470625, -0.854314>, <0.749865, 1.479744, -0.861758>, <0.795165, 1.489780, -0.822799>, 
      <0.654305, 1.379487, -0.866257>, <0.691608, 1.390926, -0.819907>, <0.743104, 1.407593, -0.759108>, <0.788404, 1.417629, -0.720149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.588515, 1.082898, -0.873937>, <0.608252, 1.171875, -0.871633>, <0.626452, 1.459187, -0.900664>, <0.654305, 1.379487, -0.866257>, 
      <0.531466, 1.069124, -0.906541>, <0.551203, 1.158100, -0.904237>, <0.601636, 1.451577, -0.931500>, <0.629488, 1.371877, -0.897092>, 
      <0.519394, 0.947212, -0.942446>, <0.552511, 1.075071, -0.939777>, <0.500789, 1.410306, -1.019874>, <0.596309, 1.365159, -0.940567>, 
      <0.471583, 0.928130, -0.985543>, <0.504699, 1.055990, -0.982874>, <0.486451, 1.399476, -1.055954>, <0.581971, 1.354329, -0.976647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.357725, 0.990791, -1.081971>, <0.378800, 0.982983, -1.038938>, <0.437009, 0.914332, -1.016708>, <0.471583, 0.928130, -0.985543>, 
      <0.420808, 1.087844, -1.082410>, <0.441883, 1.080035, -1.039377>, <0.470126, 1.042192, -1.014039>, <0.504699, 1.055990, -0.982874>, 
      <0.477986, 1.378097, -1.118448>, <0.476393, 1.388335, -1.085574>, <0.474190, 1.390215, -1.086807>, <0.486451, 1.399476, -1.055954>, 
      <0.568001, 1.314300, -1.083433>, <0.566408, 1.324538, -1.050559>, <0.569710, 1.345068, -1.007501>, <0.581971, 1.354329, -0.976647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.373406, 0.964505, -1.186012>, <0.346709, 0.961862, -1.167606>, <0.343602, 0.996024, -1.110810>, <0.357725, 0.990791, -1.081971>, 
      <0.439203, 1.060711, -1.189803>, <0.412506, 1.058067, -1.171397>, <0.406685, 1.093077, -1.111248>, <0.420808, 1.087844, -1.082410>, 
      <0.504646, 1.353934, -1.232034>, <0.490995, 1.362103, -1.199278>, <0.479669, 1.367281, -1.153179>, <0.477986, 1.378097, -1.118448>, 
      <0.592729, 1.285190, -1.198648>, <0.579079, 1.293359, -1.165892>, <0.569684, 1.303484, -1.118163>, <0.568001, 1.314300, -1.083433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.633617, 1.018111, -1.272179>, <0.555609, 1.014058, -1.241863>, <0.442162, 0.971314, -1.233414>, <0.373406, 0.964505, -1.186012>, 
      <0.639930, 1.091410, -1.277940>, <0.561923, 1.087357, -1.247624>, <0.507959, 1.067519, -1.237205>, <0.439203, 1.060711, -1.189803>, 
      <0.648519, 1.334156, -1.307663>, <0.625243, 1.340386, -1.283473>, <0.517445, 1.346275, -1.262747>, <0.504646, 1.353934, -1.232034>, 
      <0.654662, 1.262441, -1.291384>, <0.631386, 1.268671, -1.267194>, <0.605528, 1.277531, -1.229361>, <0.592729, 1.285190, -1.198648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.773869, 0.985315, -1.341645>, <0.729316, 0.995831, -1.327295>, <0.678280, 1.020432, -1.289537>, <0.633617, 1.018111, -1.272179>, 
      <0.778263, 1.059558, -1.359787>, <0.733709, 1.070073, -1.345437>, <0.684593, 1.093731, -1.295298>, <0.639930, 1.091410, -1.277940>, 
      <0.784031, 1.308916, -1.395393>, <0.742115, 1.320526, -1.365336>, <0.684562, 1.324510, -1.345120>, <0.648519, 1.334156, -1.307663>, 
      <0.788513, 1.232791, -1.402119>, <0.746597, 1.244400, -1.372062>, <0.690704, 1.252795, -1.328841>, <0.654662, 1.262441, -1.291384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.929211, 0.948344, -1.367386>, <0.882271, 0.959149, -1.361527>, <0.818932, 0.974679, -1.356159>, <0.773869, 0.985315, -1.341645>, 
      <0.930172, 1.019496, -1.404336>, <0.883232, 1.030301, -1.398477>, <0.823326, 1.048922, -1.374301>, <0.778263, 1.059558, -1.359787>, 
      <0.931362, 1.260404, -1.461929>, <0.886649, 1.267517, -1.435118>, <0.825749, 1.297362, -1.425307>, <0.784031, 1.308916, -1.395393>, 
      <0.932414, 1.185515, -1.490553>, <0.887701, 1.192629, -1.463742>, <0.830230, 1.221237, -1.432033>, <0.788513, 1.232791, -1.402119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.069422, 0.917282, -1.378534>, <1.026972, 0.924268, -1.374469>, <0.971015, 0.938722, -1.372604>, <0.929211, 0.948344, -1.367386>, 
      <1.072635, 0.998016, -1.438069>, <1.030185, 1.005002, -1.434004>, <0.971976, 1.009873, -1.409554>, <0.930172, 1.019496, -1.404336>, 
      <1.091591, 1.270083, -1.522781>, <1.046128, 1.272212, -1.499015>, <0.974992, 1.253462, -1.488091>, <0.931362, 1.260404, -1.461929>, 
      <1.080132, 1.186396, -1.576983>, <1.034669, 1.188525, -1.553218>, <0.976044, 1.178574, -1.516715>, <0.932414, 1.185515, -1.490553>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.176004, 0.907732, -1.391018>, <1.143814, 0.909195, -1.388517>, <1.101173, 0.912057, -1.381574>, <1.069422, 0.917282, -1.378534>, 
      <1.175499, 0.987668, -1.458814>, <1.143309, 0.989131, -1.456313>, <1.104385, 0.992792, -1.441109>, <1.072635, 0.998016, -1.438069>, 
      <1.148583, 1.255279, -1.555787>, <1.117897, 1.255086, -1.552005>, <1.118969, 1.268801, -1.537092>, <1.091591, 1.270083, -1.522781>, 
      <1.174319, 1.174185, -1.617006>, <1.143633, 1.173992, -1.613224>, <1.107510, 1.185114, -1.591294>, <1.080132, 1.186396, -1.576983>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.290636, 0.907227, -1.395722>, <1.324858, 0.907066, -1.396426>, <1.370511, 0.907321, -1.395722>, <1.404735, 0.906657, -1.395722>, 
      <1.324918, 0.991590, -1.462107>, <1.359140, 0.991430, -1.462811>, <1.407396, 0.906606, -1.395722>, <1.441620, 0.905942, -1.395722>, 
      <1.330752, 1.124314, -1.561435>, <1.370720, 1.207757, -1.493949>, <1.453940, 0.988779, -1.462838>, <1.490760, 0.903037, -1.396452>, 
      <1.404910, 1.188438, -1.617006>, <1.444878, 1.271881, -1.549521>, <1.490823, 0.988373, -1.462107>, <1.527643, 0.902631, -1.395722>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.290636, 0.907227, -1.395722>, <1.256225, 0.907389, -1.395014>, <1.210285, 0.906174, -1.393682>, <1.176004, 0.907732, -1.391018>, 
      <1.324918, 0.991590, -1.462107>, <1.290507, 0.991752, -1.461400>, <1.209779, 0.986110, -1.461478>, <1.175499, 0.987668, -1.458814>, 
      <1.330752, 1.124314, -1.561435>, <1.292426, 1.168813, -1.598242>, <1.217371, 1.255712, -1.564264>, <1.148583, 1.255279, -1.555787>, 
      <1.404910, 1.188438, -1.617006>, <1.366584, 1.232937, -1.653813>, <1.243107, 1.174618, -1.625483>, <1.174319, 1.174185, -1.617006>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.290636, 0.907227, -1.395722>, <1.324918, 0.991590, -1.462107>, <1.330752, 1.124314, -1.561435>, <1.404910, 1.188438, -1.617006>, 
      <1.290636, 0.907227, -1.395722>, <1.359140, 0.991430, -1.462811>, <1.390188, 1.055305, -1.504354>, <1.464346, 1.119429, -1.559926>, 
      <1.290636, 0.907227, -1.395722>, <1.359140, 0.991430, -1.462811>, <1.370564, 0.991855, -1.462107>, <1.404787, 0.991192, -1.462107>, 
      <1.290636, 0.907227, -1.395722>, <1.324858, 0.907066, -1.396426>, <1.370511, 0.907321, -1.395722>, <1.404735, 0.906657, -1.395722>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.402620, 0.232067, -2.006517>, <1.531051, 0.167885, -2.006517>, <1.687584, 0.021343, -2.017203>, <1.830725, 0.018128, -2.006517>, 
      <1.413032, 0.376669, -1.869027>, <1.541463, 0.312488, -1.869027>, <1.568689, 0.229497, -1.879713>, <1.711830, 0.226283, -1.869027>, 
      <1.436883, 0.529030, -1.623584>, <1.436008, 0.528401, -1.623584>, <1.552238, 0.503837, -1.685864>, <1.553304, 0.503822, -1.685708>, 
      <1.437326, 0.714075, -1.548219>, <1.436451, 0.713446, -1.548219>, <1.433344, 0.711992, -1.548375>, <1.434410, 0.711977, -1.548219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.404910, 0.967623, -0.466602>, <1.385660, 1.028089, -0.494478>, <1.243107, 0.981444, -0.458125>, <1.174319, 0.981876, -0.466602>, 
      <1.378177, 1.102834, -0.508739>, <1.358927, 1.163300, -0.536615>, <1.304323, 1.107991, -0.494968>, <1.235535, 1.108423, -0.503445>, 
      <1.414988, 1.405036, -0.397883>, <1.356417, 1.409410, -0.397883>, <1.283863, 1.373630, -0.411550>, <1.225322, 1.375650, -0.415847>, 
      <1.437326, 1.441986, -0.535389>, <1.378755, 1.446360, -0.535389>, <1.300632, 1.454547, -0.531092>, <1.242090, 1.456567, -0.535389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.134549, 0.215630, -1.951876>, <2.029406, 0.209154, -1.983344>, <1.940334, 0.015667, -1.998334>, <1.830725, 0.018128, -2.006517>, 
      <1.985219, 0.364314, -1.822023>, <1.880076, 0.357838, -1.853491>, <1.821440, 0.223821, -1.860845>, <1.711830, 0.226283, -1.869027>, 
      <1.755436, 0.506440, -1.591458>, <1.696664, 0.503972, -1.608845>, <1.613992, 0.502960, -1.676828>, <1.553304, 0.503822, -1.685708>, 
      <1.636782, 0.711242, -1.519033>, <1.578009, 0.708774, -1.536420>, <1.495098, 0.711115, -1.539339>, <1.434410, 0.711977, -1.548219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.403842, 0.053426, -1.834988>, <2.308472, 0.049907, -1.866870>, <2.230776, 0.221557, -1.923076>, <2.134549, 0.215630, -1.951876>, 
      <2.205926, 0.254893, -1.721471>, <2.110556, 0.251373, -1.753353>, <2.081446, 0.370240, -1.793223>, <1.985219, 0.364314, -1.822023>, 
      <1.906119, 0.473847, -1.514342>, <1.874475, 0.469308, -1.533908>, <1.791348, 0.507948, -1.580834>, <1.755436, 0.506440, -1.591458>, 
      <1.744121, 0.724981, -1.456598>, <1.712477, 0.720442, -1.476164>, <1.672694, 0.712750, -1.508409>, <1.636782, 0.711242, -1.519033>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.972127, 0.246538, -1.671879>, <2.797915, 0.241643, -1.738528>, <2.580698, 0.059952, -1.775866>, <2.403842, 0.053426, -1.834988>, 
      <2.647006, 0.396776, -1.579353>, <2.472793, 0.391881, -1.646002>, <2.382782, 0.261419, -1.662349>, <2.205926, 0.254893, -1.721471>, 
      <2.181191, 0.525459, -1.406768>, <2.142281, 0.517160, -1.440174>, <1.949980, 0.480139, -1.487221>, <1.906119, 0.473847, -1.514342>, 
      <1.888389, 0.747333, -1.363459>, <1.849478, 0.739034, -1.396866>, <1.787982, 0.731272, -1.429478>, <1.744121, 0.724981, -1.456598>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.293140, 0.078416, -1.494768>, <3.202733, 0.060925, -1.573267>, <3.085102, 0.249713, -1.628658>, <2.972127, 0.246538, -1.671879>, 
      <2.912034, 0.290216, -1.411543>, <2.821627, 0.272725, -1.490042>, <2.759980, 0.399951, -1.536132>, <2.647006, 0.396776, -1.579353>, 
      <2.366210, 0.504106, -1.240023>, <2.328818, 0.492963, -1.286373>, <2.226569, 0.535137, -1.367809>, <2.181191, 0.525459, -1.406768>, 
      <2.022786, 0.784415, -1.217351>, <1.985394, 0.773272, -1.263701>, <1.933767, 0.757011, -1.324500>, <1.888389, 0.747333, -1.363459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.293140, 0.078416, -1.494768>, <2.912034, 0.290216, -1.411543>, <2.366210, 0.504106, -1.240023>, <2.022786, 0.784415, -1.217351>, 
      <3.387997, 0.096768, -1.412404>, <3.006891, 0.308568, -1.329179>, <2.391087, 0.511520, -1.209188>, <2.047662, 0.791829, -1.186516>, 
      <3.402005, 0.304163, -1.315416>, <2.985455, 0.443204, -1.279229>, <2.454718, 0.565597, -1.126710>, <2.080893, 0.798285, -1.143041>, 
      <3.483814, 0.345534, -1.227585>, <3.067265, 0.484574, -1.191398>, <2.469141, 0.576313, -1.090631>, <2.095316, 0.809001, -1.106961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.757024, 0.313000, -0.996738>, <3.708990, 0.306820, -1.092987>, <3.553243, 0.380644, -1.153045>, <3.483814, 0.345534, -1.227585>, 
      <3.262797, 0.473775, -0.997769>, <3.214763, 0.467595, -1.094018>, <3.136694, 0.519684, -1.116858>, <3.067265, 0.484574, -1.191398>, 
      <2.557302, 0.590557, -0.946108>, <2.558815, 0.580307, -0.978982>, <2.481474, 0.585477, -1.059777>, <2.469141, 0.576313, -1.090631>, 
      <2.109601, 0.848918, -1.000175>, <2.111113, 0.838668, -1.033049>, <2.107650, 0.818165, -1.076107>, <2.095316, 0.809001, -1.106961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.723324, 0.376350, -0.747664>, <3.783354, 0.386523, -0.796035>, <3.791690, 0.317460, -0.927275>, <3.757024, 0.313000, -0.996738>, 
      <3.231858, 0.526912, -0.788853>, <3.291888, 0.537085, -0.837224>, <3.297464, 0.478236, -0.928306>, <3.262797, 0.473775, -0.997769>, 
      <2.524701, 0.624664, -0.793493>, <2.538287, 0.616388, -0.826248>, <2.555705, 0.601386, -0.911378>, <2.557302, 0.590557, -0.946108>, 
      <2.085104, 0.878223, -0.884960>, <2.098690, 0.869947, -0.917716>, <2.108003, 0.859747, -0.965445>, <2.109601, 0.848918, -1.000175>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.191909, 0.217233, -0.541382>, <3.354684, 0.228667, -0.611369>, <3.586258, 0.353122, -0.637220>, <3.723324, 0.376350, -0.747664>, 
      <2.841342, 0.422501, -0.616635>, <3.004117, 0.433935, -0.686621>, <3.094792, 0.503684, -0.678408>, <3.231858, 0.526912, -0.788853>, 
      <2.300699, 0.615707, -0.682138>, <2.322070, 0.607663, -0.707523>, <2.511963, 0.632424, -0.762779>, <2.524701, 0.624664, -0.793493>, 
      <2.023352, 0.901460, -0.792224>, <2.044722, 0.893416, -0.817609>, <2.072366, 0.885983, -0.854247>, <2.085104, 0.878223, -0.884960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.856776, 0.315479, -0.375083>, <2.963772, 0.286744, -0.409610>, <3.085524, 0.209760, -0.495641>, <3.191909, 0.217233, -0.541382>, 
      <2.582283, 0.500485, -0.476979>, <2.689279, 0.471750, -0.511506>, <2.734957, 0.415028, -0.570893>, <2.841342, 0.422501, -0.616635>, 
      <2.143430, 0.676822, -0.595986>, <2.169806, 0.667848, -0.617142>, <2.278804, 0.623949, -0.656129>, <2.300699, 0.615707, -0.682138>, 
      <1.941800, 0.932166, -0.714735>, <1.968177, 0.923192, -0.735890>, <2.001456, 0.909702, -0.766215>, <2.023352, 0.901460, -0.792224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.895567, 0.508805, -0.256883>, <1.972600, 0.504694, -0.262871>, <2.074626, 0.497038, -0.279493>, <2.150534, 0.483930, -0.286771>, 
      <1.802676, 0.654212, -0.319799>, <1.879709, 0.650101, -0.325786>, <1.933471, 0.646021, -0.345449>, <2.009379, 0.632913, -0.352727>, 
      <1.632585, 0.824744, -0.411130>, <1.663149, 0.826180, -0.415576>, <1.735304, 0.794465, -0.421584>, <1.760737, 0.792421, -0.439048>, 
      <1.585930, 0.993494, -0.466602>, <1.616494, 0.994929, -0.471048>, <1.654584, 0.982583, -0.489161>, <1.680017, 0.980540, -0.506625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.621161, 0.512180, -0.245623>, <1.703537, 0.513087, -0.247254>, <1.813534, 0.513183, -0.250507>, <1.895567, 0.508805, -0.256883>, 
      <1.556286, 0.648813, -0.311917>, <1.638662, 0.649720, -0.313548>, <1.720642, 0.658589, -0.313422>, <1.802676, 0.654212, -0.319799>, 
      <1.435541, 0.812695, -0.418320>, <1.474060, 0.848330, -0.434315>, <1.578357, 0.822198, -0.403241>, <1.632585, 0.824744, -0.411130>, 
      <1.404910, 0.967623, -0.466602>, <1.443429, 1.003258, -0.482597>, <1.531702, 0.990948, -0.458713>, <1.585930, 0.993494, -0.466602>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.621161, 0.512180, -0.245623>, <1.532864, 0.511207, -0.243875>, <1.415223, 0.504253, -0.245623>, <1.326920, 0.502541, -0.245623>, 
      <1.621161, 0.512180, -0.245623>, <1.467989, 0.647840, -0.310168>, <1.438620, 0.643778, -0.311917>, <1.350317, 0.642066, -0.311917>, 
      <1.621161, 0.512180, -0.245623>, <1.467989, 0.647840, -0.310168>, <1.478934, 0.676393, -0.355484>, <1.448303, 0.831322, -0.403766>, 
      <1.621161, 0.512180, -0.245623>, <1.556286, 0.648813, -0.311917>, <1.435541, 0.812695, -0.418320>, <1.404910, 0.967623, -0.466602>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.804440, 0.975939, -0.616650>, <1.765823, 0.983075, -0.585950>, <1.721019, 0.977246, -0.534780>, <1.680017, 0.980540, -0.506625>, 
      <1.940485, 0.747727, -0.524006>, <1.901867, 0.754863, -0.493306>, <1.801739, 0.789127, -0.467204>, <1.760737, 0.792421, -0.439048>, 
      <2.281252, 0.577626, -0.404416>, <2.181360, 0.601452, -0.391925>, <2.110869, 0.615388, -0.362459>, <2.009379, 0.632913, -0.352727>, 
      <2.485600, 0.406920, -0.313458>, <2.385708, 0.430746, -0.300967>, <2.252024, 0.466405, -0.296502>, <2.150534, 0.483930, -0.286771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.804440, 0.975939, -0.616650>, <1.738755, 1.086124, -0.661380>, <1.774529, 1.393817, -0.647559>, <1.888389, 1.408728, -0.720149>, 
      <1.765823, 0.983075, -0.585950>, <1.700138, 1.093260, -0.630680>, <1.735618, 1.402116, -0.614152>, <1.849478, 1.417027, -0.686742>, 
      <1.721019, 0.977246, -0.534780>, <1.668140, 1.100481, -0.579049>, <1.707628, 1.372441, -0.550468>, <1.787982, 1.424789, -0.654130>, 
      <1.680017, 0.980540, -0.506625>, <1.627138, 1.103775, -0.550894>, <1.663767, 1.378733, -0.523348>, <1.744121, 1.431080, -0.627010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.804440, 0.975939, -0.616650>, <1.940485, 0.747727, -0.524006>, <2.281252, 0.577626, -0.404416>, <2.485600, 0.406920, -0.313458>, 
      <1.844966, 0.968450, -0.648867>, <1.981011, 0.740238, -0.556223>, <2.393418, 0.550872, -0.418442>, <2.597766, 0.380166, -0.327484>, 
      <1.902358, 0.945585, -0.683101>, <2.103988, 0.690241, -0.564353>, <2.475177, 0.529250, -0.442416>, <2.749670, 0.344244, -0.340520>, 
      <1.941800, 0.932166, -0.714735>, <2.143430, 0.676822, -0.595986>, <2.582283, 0.500485, -0.476979>, <2.856776, 0.315479, -0.375083>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.804440, 0.975939, -0.616650>, <1.844966, 0.968450, -0.648867>, <1.902358, 0.945585, -0.683101>, <1.941800, 0.932166, -0.714735>, 
      <1.738755, 1.086124, -0.661380>, <1.779282, 1.078635, -0.693597>, <1.819947, 1.049951, -0.731637>, <1.859389, 1.036531, -0.763270>, 
      <1.774529, 1.393817, -0.647559>, <1.819907, 1.384138, -0.686518>, <1.873422, 1.323050, -0.757194>, <1.910814, 1.311907, -0.803544>, 
      <1.888389, 1.408728, -0.720149>, <1.933767, 1.399050, -0.759108>, <1.985394, 1.382790, -0.819907>, <2.022786, 1.371646, -0.866257>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.840311, 0.008794, -2.006517>, <1.021478, 0.009951, -2.017513>, <1.233927, 0.165085, -2.006517>, <1.402620, 0.232067, -2.006517>, 
      <0.960845, 0.216004, -1.869027>, <1.142012, 0.217161, -1.880024>, <1.244339, 0.309688, -1.869027>, <1.413032, 0.376669, -1.869027>, 
      <1.169602, 0.446576, -1.632752>, <1.228144, 0.448596, -1.637049>, <1.378312, 0.524656, -1.623584>, <1.436883, 0.529030, -1.623584>, 
      <1.242090, 0.699494, -1.548219>, <1.300632, 0.701514, -1.552516>, <1.378755, 0.709701, -1.548219>, <1.437326, 0.714075, -1.548219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.502407, 0.226319, -1.951876>, <0.618705, 0.218234, -1.986701>, <0.718868, 0.008019, -1.999146>, <0.840311, 0.008794, -2.006517>, 
      <0.663601, 0.368530, -1.822023>, <0.779899, 0.360445, -1.856848>, <0.839402, 0.215229, -1.861656>, <0.960845, 0.216004, -1.869027>, 
      <0.916925, 0.496294, -1.598716>, <0.975676, 0.493362, -1.616102>, <1.108463, 0.444467, -1.628264>, <1.169602, 0.446576, -1.632752>, 
      <1.039719, 0.700356, -1.519033>, <1.098470, 0.697425, -1.536420>, <1.180951, 0.697384, -1.543731>, <1.242090, 0.699494, -1.548219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.267491, 0.048616, -1.834988>, <0.354289, 0.043519, -1.873440>, <0.411533, 0.232637, -1.924664>, <0.502407, 0.226319, -1.951876>, 
      <0.466991, 0.248514, -1.721471>, <0.553789, 0.243417, -1.759923>, <0.572727, 0.374848, -1.794811>, <0.663601, 0.368530, -1.822023>, 
      <0.783825, 0.460750, -1.533608>, <0.815433, 0.455962, -1.553174>, <0.881026, 0.498085, -1.588092>, <0.916925, 0.496294, -1.598716>, 
      <0.932491, 0.714942, -1.456598>, <0.964098, 0.710153, -1.476164>, <1.003820, 0.702147, -1.508409>, <1.039719, 0.700356, -1.519033>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.129626, 0.263431, -1.671879>, <0.004909, 0.258617, -1.723044>, <0.136007, 0.056337, -1.776739>, <0.267491, 0.048616, -1.834988>, 
      <0.145783, 0.405931, -1.579353>, <0.280318, 0.401118, -1.630518>, <0.335507, 0.256234, -1.663222>, <0.466991, 0.248514, -1.721471>, 
      <0.570283, 0.508142, -1.427546>, <0.609126, 0.499536, -1.460952>, <0.740015, 0.467388, -1.506488>, <0.783825, 0.460750, -1.533608>, 
      <0.788404, 0.738432, -1.363459>, <0.827248, 0.729826, -1.396866>, <0.888681, 0.721580, -1.429478>, <0.932491, 0.714942, -1.456598>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.627097, 0.080624, -1.494768>, <-0.242676, 0.289409, -1.411543>, <0.329127, 0.476751, -1.268949>, <0.654305, 0.776574, -1.217351>, 
      <-0.763673, 0.113600, -1.416714>, <-0.379252, 0.322385, -1.333489>, <0.304310, 0.484361, -1.238113>, <0.629488, 0.784184, -1.186516>, 
      <-0.792573, 0.405456, -1.330759>, <-0.345872, 0.510635, -1.294572>, <0.194052, 0.567198, -1.150802>, <0.596309, 0.790902, -1.143041>, 
      <-0.907033, 0.451136, -1.227585>, <-0.460332, 0.556315, -1.191398>, <0.179715, 0.578028, -1.114722>, <0.581971, 0.801732, -1.106961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.627097, 0.080624, -1.494768>, <-0.484644, 0.046229, -1.576181>, <-0.286231, 0.269034, -1.612321>, <-0.129626, 0.263431, -1.671879>, 
      <-0.242676, 0.289409, -1.411543>, <-0.100224, 0.255014, -1.492956>, <-0.010822, 0.411535, -1.519795>, <0.145783, 0.405931, -1.579353>, 
      <0.329127, 0.476751, -1.268949>, <0.366430, 0.465313, -1.315299>, <0.524983, 0.518178, -1.388586>, <0.570283, 0.508142, -1.427546>, 
      <0.654305, 0.776574, -1.217351>, <0.691608, 0.765136, -1.263701>, <0.743104, 0.748468, -1.324500>, <0.788404, 0.738432, -1.363459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.179605, 0.301125, -0.996738>, <-1.129153, 0.319818, -1.099758>, <-0.989802, 0.484168, -1.152978>, <-0.907033, 0.451136, -1.227585>, 
      <-0.655323, 0.463316, -0.997769>, <-0.604871, 0.482009, -1.100790>, <-0.543100, 0.589347, -1.116790>, <-0.460332, 0.556315, -1.191398>, 
      <0.093660, 0.566761, -0.976644>, <0.092066, 0.556523, -1.009518>, <0.167454, 0.587288, -1.083868>, <0.179715, 0.578028, -1.114722>, 
      <0.568001, 0.841761, -1.000175>, <0.566408, 0.831523, -1.033049>, <0.569710, 0.810993, -1.076107>, <0.581971, 0.801732, -1.106961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.142064, 0.364055, -0.747664>, <-1.205978, 0.370384, -0.791728>, <-1.213416, 0.288598, -0.927698>, <-1.179605, 0.301125, -0.996738>, 
      <-0.621626, 0.516100, -0.788853>, <-0.685540, 0.522429, -0.832917>, <-0.689134, 0.450789, -0.928729>, <-0.655323, 0.463316, -0.997769>, 
      <0.124317, 0.601818, -0.822746>, <0.110666, 0.593650, -0.855502>, <0.095342, 0.577578, -0.941914>, <0.093660, 0.566761, -0.976644>, 
      <0.592729, 0.870871, -0.884960>, <0.579079, 0.862702, -0.917716>, <0.569684, 0.852577, -0.965445>, <0.568001, 0.841761, -1.000175>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.519125, 0.235722, -0.541382>, <-0.705874, 0.245427, -0.613958>, <-0.977464, 0.347756, -0.634183>, <-1.142064, 0.364055, -0.747664>, 
      <-0.166989, 0.433091, -0.616635>, <-0.353738, 0.442796, -0.689211>, <-0.457026, 0.499801, -0.675372>, <-0.621626, 0.516100, -0.788853>, 
      <0.366223, 0.612473, -0.712367>, <0.342947, 0.606244, -0.736558>, <0.137116, 0.609478, -0.792033>, <0.124317, 0.601818, -0.822746>, 
      <0.654662, 0.893620, -0.792224>, <0.631386, 0.887390, -0.816415>, <0.605528, 0.878530, -0.854247>, <0.592729, 0.870871, -0.884960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.183361, 0.314235, -0.375083>, <-0.290021, 0.289061, -0.409436>, <-0.412202, 0.230166, -0.499829>, <-0.519125, 0.235722, -0.541382>, 
      <0.108201, 0.496945, -0.467005>, <0.001542, 0.471771, -0.501358>, <-0.060066, 0.427535, -0.575081>, <-0.166989, 0.433091, -0.616635>, 
      <0.559352, 0.663068, -0.600116>, <0.517436, 0.651459, -0.630173>, <0.402266, 0.622120, -0.674910>, <0.366223, 0.612473, -0.712367>, 
      <0.788513, 0.923270, -0.681489>, <0.746597, 0.911661, -0.711546>, <0.690704, 0.903266, -0.754767>, <0.654662, 0.893620, -0.792224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.188526, 0.402744, -0.313458>, <0.076152, 0.376876, -0.327484>, <-0.075481, 0.339697, -0.340336>, <-0.183361, 0.314235, -0.375083>, 
      <0.411693, 0.573085, -0.397337>, <0.299318, 0.547217, -0.411363>, <0.216082, 0.522408, -0.432258>, <0.108201, 0.496945, -0.467005>, 
      <0.766681, 0.739227, -0.523205>, <0.721968, 0.732114, -0.550016>, <0.601069, 0.674622, -0.570202>, <0.559352, 0.663068, -0.600116>, 
      <0.932414, 0.970546, -0.593055>, <0.887701, 0.963432, -0.619866>, <0.830230, 0.934824, -0.651575>, <0.788513, 0.923270, -0.681489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.524188, 0.477107, -0.286771>, <0.422563, 0.460384, -0.296502>, <0.288602, 0.425781, -0.300967>, <0.188526, 0.402744, -0.313458>, 
      <0.690971, 0.624874, -0.352727>, <0.589346, 0.608151, -0.362459>, <0.511769, 0.596121, -0.384846>, <0.411693, 0.573085, -0.397337>, 
      <0.975084, 0.770259, -0.450018>, <0.929621, 0.768130, -0.473783>, <0.810311, 0.746169, -0.497043>, <0.766681, 0.739227, -0.523205>, 
      <1.080132, 0.969665, -0.506625>, <1.034669, 0.967536, -0.530390>, <0.976044, 0.977487, -0.566893>, <0.932414, 0.970546, -0.593055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.779344, 0.499969, -0.256883>, <0.702281, 0.496466, -0.262871>, <0.600197, 0.489615, -0.279493>, <0.524188, 0.477107, -0.286771>, 
      <0.897837, 0.644541, -0.319799>, <0.820773, 0.641039, -0.325786>, <0.766981, 0.637382, -0.345449>, <0.690971, 0.624874, -0.352727>, 
      <1.091238, 0.810129, -0.416599>, <1.060551, 0.810322, -0.420381>, <1.002462, 0.771542, -0.435707>, <0.975084, 0.770259, -0.450018>, 
      <1.174319, 0.981876, -0.466602>, <1.143633, 0.982069, -0.470384>, <1.107510, 0.970947, -0.492314>, <1.080132, 0.969665, -0.506625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.053769, 0.501177, -0.245623>, <1.135697, 0.501562, -0.243938>, <1.244989, 0.500952, -0.245623>, <1.326920, 0.502541, -0.245623>, 
      <1.159111, 0.641111, -0.311917>, <1.241039, 0.641496, -0.310232>, <1.333292, 0.502665, -0.245623>, <1.415223, 0.504253, -0.245623>, 
      <1.273411, 0.845969, -0.411997>, <1.304042, 0.691041, -0.363715>, <1.467989, 0.647840, -0.310168>, <1.532864, 0.511207, -0.243875>, 
      <1.404910, 0.967623, -0.466602>, <1.435541, 0.812695, -0.418320>, <1.556286, 0.648813, -0.311917>, <1.621161, 0.512180, -0.245623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.053769, 0.501177, -0.245623>, <0.971390, 0.500790, -0.247317>, <0.861410, 0.503699, -0.250507>, <0.779344, 0.499969, -0.256883>, 
      <1.159111, 0.641111, -0.311917>, <1.076732, 0.640724, -0.313611>, <0.979902, 0.648271, -0.313422>, <0.897837, 0.644541, -0.319799>, 
      <1.273411, 0.845969, -0.411997>, <1.254161, 0.906436, -0.439873>, <1.160025, 0.809696, -0.408122>, <1.091238, 0.810129, -0.416599>, 
      <1.404910, 0.967623, -0.466602>, <1.385660, 1.028089, -0.494478>, <1.243107, 0.981444, -0.458125>, <1.174319, 0.981876, -0.466602>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.053769, 0.501177, -0.245623>, <1.159111, 0.641111, -0.311917>, <1.273411, 0.845969, -0.411997>, <1.404910, 0.967623, -0.466602>, 
      <1.053769, 0.501177, -0.245623>, <1.241039, 0.641496, -0.310232>, <1.316804, 0.709668, -0.349161>, <1.448303, 0.831322, -0.403766>, 
      <1.053769, 0.501177, -0.245623>, <1.241039, 0.641496, -0.310232>, <1.268386, 0.640477, -0.311917>, <1.350317, 0.642066, -0.311917>, 
      <1.053769, 0.501177, -0.245623>, <1.135697, 0.501562, -0.243938>, <1.244989, 0.500952, -0.245623>, <1.326920, 0.502541, -0.245623>
    }
  }
  texture {
    LaceCollar
    scale <2.479754, 1.77265, 1.0>
    rotate -90.0*x
    translate <0.201417, 0.000000, -0.205503>
  }
  scale <1.0, 0.5, 1.0>
  rotate <90.0, 0.0, -180.0>
  translate  <-17.07365, -4.03128, 0.42>
}
#declare buckle = difference {
  box { // Outer
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.23, 0.23>
    translate  <-21.933785, -5.0, -0.507829>
  }
  box { // Inner
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.17, 0.17>
    translate  <-21.913665, -5.0, -0.509158>
  }
  texture {
    DoorKnob
  }
  scale <2.0, 2.0, 1.724138>
  rotate <-0.0, 0.0, 93.941841>
  translate  <-31.276558, 37.007696, -1.682305>
}
union { // Lady_Xenon
  object { Woman_shirt }
  object { HoleHead1 }
  object { Xenon_Face }
  object { Collar }
  torus { // necklace
    1.0, 0.05  rotate -x*90
    texture {
      BlueMarble
    }
    scale <0.845384, 0.51565, 0.61926>
    rotate <10.769069, 0.73766, 0.06953>
    translate  <-18.396301, -5.065501, 0.9>
  }
  object { buckle }
  cylinder { // solidBelt
    <0,0,1>, <0,0,0>, 1 
    texture {
      DoorHandle
    }
    scale <0.981626, 1.513425, 0.469852>
    rotate <-0.0, 0.0, 89.41848>
    translate  <-18.381929, -5.091785, -2.808585>
  }
  scale <0.5, 0.5, 0.58>
  rotate -93.941841*z
  translate  <-19.43463, -14.44611, 0.51432>
}


#declare MedallionDone = union {
  sphere { // Medallion_Core
    <0,0,0>,1
    texture {
      Blood_Marble
    }
    scale <0.2, 0.02, 0.2>
    translate  <-1.615372, -1.543083, 0.913697>
  }
  sphere { // Medallion_Core1
    <0,0,0>,1
    texture {
      Chrome__realShiny_
    }
    scale <0.25, 0.01, 0.25>
    translate  <-1.615372, -1.543083, 0.913697>
  }
  rotate 11.0*x
  translate  <-0.564255, -2.084928, 0.493202>
}
#declare Head = merge {
  cone { // Cone001
    <0,0,0>, 0.6, <0,0,1>, 1.0
    hollow
    scale <0.9, 0.9, 1.23>
    rotate 180.0*x
    translate  1.5*z
  }
  sphere { // Sphere001
    <0,0,0>,1
    hollow
    scale <0.9, 0.9, 1.23>
  }
  texture {
    Radon
  }
  hollow
  scale <1.266667, 1.266667, 0.8>
  translate  <-1.388771, -1.219626, 1.78822>
}
#declare HoleHead = union {
  object { Head }
  torus { // CrownBase
    1.6, 0.15  rotate -x*90
    texture {
      Yellow
    }
    scale 0.45
    rotate <-0.0, 0.0, 29.129642>
    translate  <-1.36125, -1.190363, 2.312179>
  }
  scale 0.9
  rotate -18.0*z
  translate  <-0.506963, -2.524601, 0.573178>
}
#declare Sash = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.903513, -4.452701, -1.554816>, <-0.903513, -4.447320, -1.727469>, <-0.820056, -4.424906, -1.981282>, <-0.682945, -4.430277, -2.086210>, 
      <-0.916696, -4.373051, -1.554816>, <-0.916696, -4.367670, -1.727469>, <-0.833238, -4.345256, -1.981282>, <-0.696128, -4.350627, -2.086210>, 
      <-0.940797, -4.267659, -1.554816>, <-0.940797, -4.262278, -1.727469>, <-0.866481, -4.242056, -1.994349>, <-0.720229, -4.245236, -2.086210>, 
      <-0.947456, -4.187200, -1.554816>, <-0.947456, -4.181819, -1.727469>, <-0.873139, -4.161597, -1.994349>, <-0.726888, -4.164777, -2.086210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682945, -4.475123, -0.647355>, <-0.935198, -4.475697, -0.769443>, <-0.903513, -4.461432, -1.274707>, <-0.903513, -4.452701, -1.554816>, 
      <-0.696128, -4.395473, -0.647355>, <-0.948381, -4.396047, -0.769443>, <-0.916696, -4.381781, -1.274707>, <-0.916696, -4.373051, -1.554816>, 
      <-0.720229, -4.290082, -0.647355>, <-0.972048, -4.279934, -0.769919>, <-0.940797, -4.276389, -1.274707>, <-0.940797, -4.267659, -1.554816>, 
      <-0.726888, -4.209623, -0.647355>, <-0.978706, -4.199475, -0.769919>, <-0.947456, -4.195930, -1.274707>, <-0.947456, -4.187200, -1.554816>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.708700, -4.446756, -0.290535>, <0.983401, -4.445965, -0.306924>, <-0.029925, -4.473637, -0.331301>, <-0.682945, -4.475123, -0.647355>, 
      <1.691122, -4.400293, -0.290535>, <0.965823, -4.399503, -0.306924>, <-0.043108, -4.393987, -0.331301>, <-0.696128, -4.395473, -0.647355>, 
      <1.656850, -4.341097, -0.290535>, <0.935523, -4.340311, -0.306834>, <-0.071906, -4.316208, -0.331805>, <-0.720229, -4.290082, -0.647355>, 
      <1.650108, -4.291880, -0.290535>, <0.928782, -4.291094, -0.306834>, <-0.078565, -4.235750, -0.331805>, <-0.726888, -4.209623, -0.647355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.347129, -4.479516, -0.556291>, <2.925947, -4.477174, -0.290483>, <2.206622, -4.447298, -0.279284>, <1.708700, -4.446756, -0.290535>, 
      <3.333946, -4.399866, -0.556291>, <2.912764, -4.397524, -0.290483>, <2.189044, -4.400836, -0.279284>, <1.691122, -4.400293, -0.290535>, 
      <3.309844, -4.294474, -0.556291>, <2.884103, -4.317262, -0.289706>, <2.159555, -4.341645, -0.279176>, <1.656850, -4.341097, -0.290535>, 
      <3.303185, -4.214015, -0.556291>, <2.877445, -4.236803, -0.289706>, <2.152813, -4.292428, -0.279176>, <1.650108, -4.291880, -0.290535>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.567698, -4.457093, -1.463750>, <3.567698, -4.465823, -1.183641>, <3.584122, -4.480834, -0.705857>, <3.347129, -4.479516, -0.556291>, 
      <3.554514, -4.377443, -1.463750>, <3.554514, -4.386173, -1.183641>, <3.570938, -4.401184, -0.705857>, <3.333946, -4.399866, -0.556291>, 
      <3.530412, -4.272052, -1.463750>, <3.583631, -4.270050, -1.188612>, <3.547122, -4.281774, -0.704867>, <3.309844, -4.294474, -0.556291>, 
      <3.523753, -4.191593, -1.463750>, <3.576972, -4.189592, -1.188612>, <3.540464, -4.201315, -0.704867>, <3.303185, -4.214015, -0.556291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.347129, -4.434670, -1.995147>, <3.457191, -4.431414, -1.862053>, <3.567698, -4.451712, -1.636404>, <3.567698, -4.457093, -1.463750>, 
      <3.250452, -4.371614, -1.995147>, <3.360514, -4.368358, -1.862053>, <3.554514, -4.372062, -1.636404>, <3.554514, -4.377443, -1.463750>, 
      <3.034391, -4.339512, -1.995147>, <3.191934, -4.315138, -1.845156>, <3.488845, -4.273615, -1.678648>, <3.530412, -4.272052, -1.463750>, 
      <3.024871, -4.224482, -1.995147>, <3.182415, -4.200108, -1.845156>, <3.482186, -4.193156, -1.678648>, <3.523753, -4.191593, -1.463750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.971280, -4.474736, -2.184979>, <3.095482, -4.470811, -2.159291>, <3.266279, -4.437062, -2.092916>, <3.347129, -4.434670, -1.995147>, 
      <2.909758, -4.424955, -2.184979>, <3.033960, -4.421030, -2.159291>, <3.169602, -4.374005, -2.092916>, <3.250452, -4.371614, -1.995147>, 
      <2.807815, -4.375759, -2.178044>, <2.904131, -4.377806, -2.153070>, <2.962759, -4.350595, -2.063344>, <3.034391, -4.339512, -1.995147>, 
      <2.766207, -4.308798, -2.184979>, <2.862523, -4.310844, -2.160005>, <2.953240, -4.235565, -2.063344>, <3.024871, -4.224482, -1.995147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.429299, -4.463674, -2.184979>, <2.591869, -4.459595, -2.186515>, <2.812099, -4.479766, -2.217902>, <2.971280, -4.474736, -2.184979>, 
      <2.388339, -4.387250, -2.184979>, <2.550909, -4.383171, -2.186515>, <2.750577, -4.429985, -2.217902>, <2.909758, -4.424955, -2.184979>, 
      <2.318921, -4.291135, -2.176261>, <2.462938, -4.301175, -2.161123>, <2.667334, -4.372774, -2.214471>, <2.807815, -4.375759, -2.178044>, 
      <2.292766, -4.208926, -2.184979>, <2.436783, -4.218966, -2.169841>, <2.625725, -4.305813, -2.221405>, <2.766207, -4.308798, -2.184979>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.989856, -4.499362, -2.175704>, <2.122126, -4.501160, -2.177652>, <2.297050, -4.466992, -2.183729>, <2.429299, -4.463674, -2.184979>, 
      <1.985462, -4.425650, -2.203429>, <2.117731, -4.427448, -2.205377>, <2.256090, -4.390568, -2.183729>, <2.388339, -4.387250, -2.184979>, 
      <1.982019, -4.331872, -2.260555>, <2.081339, -4.328574, -2.262188>, <2.220313, -4.284261, -2.186625>, <2.318921, -4.291135, -2.176261>, 
      <1.975208, -4.253656, -2.268122>, <2.074528, -4.250358, -2.269755>, <2.194158, -4.202052, -2.195344>, <2.292766, -4.208926, -2.184979>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.401090, -4.449698, -2.169839>, <1.578075, -4.454218, -2.160944>, <1.812626, -4.496953, -2.173094>, <1.989856, -4.499362, -2.175704>, 
      <1.392301, -4.386642, -2.169839>, <1.569286, -4.391162, -2.160944>, <1.808231, -4.423241, -2.200820>, <1.985462, -4.425650, -2.203429>, 
      <1.374208, -4.302620, -2.161793>, <1.557263, -4.310956, -2.170645>, <1.798686, -4.337961, -2.257541>, <1.982019, -4.331872, -2.260555>, 
      <1.371794, -4.239511, -2.169839>, <1.554849, -4.247848, -2.178691>, <1.791875, -4.259745, -2.265109>, <1.975208, -4.253656, -2.268122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.067024, -4.475797, -2.222082>, <1.167205, -4.488788, -2.209996>, <1.299512, -4.447104, -2.174944>, <1.401090, -4.449698, -2.169839>, 
      <1.053841, -4.396147, -2.222082>, <1.154021, -4.409137, -2.209996>, <1.290723, -4.384048, -2.174944>, <1.392301, -4.386642, -2.169839>, 
      <1.028431, -4.290357, -2.213163>, <1.133186, -4.306003, -2.206219>, <1.268297, -4.297797, -2.156672>, <1.374208, -4.302620, -2.161793>, 
      <1.023079, -4.210296, -2.222082>, <1.127834, -4.225942, -2.215138>, <1.265883, -4.234688, -2.164717>, <1.371794, -4.239511, -2.169839>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.627580, -4.349397, -2.263157>, <0.765304, -4.348010, -2.263157>, <0.931404, -4.458212, -2.238443>, <1.067024, -4.475797, -2.222082>, 
      <0.614397, -4.281116, -2.250834>, <0.752120, -4.279730, -2.250834>, <0.918221, -4.378561, -2.238443>, <1.053841, -4.396147, -2.222082>, 
      <0.593486, -4.191708, -2.220344>, <0.727966, -4.191708, -2.220344>, <0.895711, -4.270534, -2.221960>, <1.028431, -4.290357, -2.213163>, 
      <0.583635, -4.121795, -2.222082>, <0.718115, -4.121795, -2.222082>, <0.890359, -4.190474, -2.230879>, <1.023079, -4.210296, -2.222082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.031586, -4.486859, -2.222082>, <0.168600, -4.474504, -2.249111>, <0.425211, -4.351435, -2.263157>, <0.627580, -4.349397, -2.263157>, 
      <0.012359, -4.403890, -2.222082>, <0.212544, -4.391535, -2.249111>, <0.412027, -4.283154, -2.250834>, <0.614397, -4.281116, -2.250834>, 
      <0.083369, -4.298215, -2.212529>, <0.225637, -4.293550, -2.227279>, <0.450380, -4.191708, -2.220344>, <0.593486, -4.191708, -2.220344>, 
      <0.114896, -4.210296, -2.222082>, <0.257163, -4.205630, -2.236832>, <0.440529, -4.121795, -2.222082>, <0.583635, -4.121795, -2.222082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.031586, -4.486859, -2.222082>, <0.012359, -4.403890, -2.222082>, <0.083369, -4.298215, -2.212529>, <0.114896, -4.210296, -2.222082>, 
      <-0.229748, -4.499088, -2.195326>, <-0.185804, -4.416120, -2.195326>, <-0.171297, -4.306568, -2.186126>, <-0.139771, -4.218648, -2.195679>, 
      <-0.523929, -4.436506, -2.207901>, <-0.537112, -4.356856, -2.207901>, <-0.503339, -4.249951, -2.222439>, <-0.509998, -4.169492, -2.222439>, 
      <-0.682945, -4.430277, -2.086210>, <-0.696128, -4.350627, -2.086210>, <-0.720229, -4.245236, -2.086210>, <-0.726888, -4.164777, -2.086210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.932809, -4.098700, -1.554816>, <-0.934036, -4.125583, -1.554816>, <-0.949676, -4.160380, -1.554816>, <-0.947456, -4.187200, -1.554816>, 
      <-0.932809, -4.093319, -1.727469>, <-0.934036, -4.120202, -1.727469>, <-0.949676, -4.154999, -1.727469>, <-0.947456, -4.181819, -1.727469>, 
      <-0.855313, -4.084518, -1.989771>, <-0.856540, -4.111401, -1.989771>, <-0.875359, -4.134778, -1.994349>, <-0.873139, -4.161597, -1.994349>, 
      <-0.712241, -4.076277, -2.086210>, <-0.713468, -4.103160, -2.086210>, <-0.729108, -4.137957, -2.086210>, <-0.726888, -4.164777, -2.086210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.712241, -4.121122, -0.647355>, <-0.713468, -4.148006, -0.647355>, <-0.729108, -4.182803, -0.647355>, <-0.726888, -4.209623, -0.647355>, 
      <-0.964213, -4.118479, -0.769995>, <-0.965441, -4.145363, -0.769995>, <-0.980926, -4.172655, -0.769919>, <-0.978706, -4.199475, -0.769919>, 
      <-0.932809, -4.107430, -1.274707>, <-0.934036, -4.134313, -1.274707>, <-0.949676, -4.169111, -1.274707>, <-0.947456, -4.195930, -1.274707>, 
      <-0.932809, -4.098700, -1.554816>, <-0.934036, -4.125583, -1.554816>, <-0.949676, -4.160380, -1.554816>, <-0.947456, -4.187200, -1.554816>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.664756, -4.125943, -0.290535>, <1.666331, -4.175893, -0.290535>, <1.643326, -4.242368, -0.290535>, <1.650108, -4.291880, -0.290535>, 
      <0.943850, -4.125157, -0.306825>, <0.945425, -4.175107, -0.306825>, <0.922000, -4.241582, -0.306834>, <0.928782, -4.291094, -0.306834>, 
      <-0.063899, -4.127922, -0.331796>, <-0.065126, -4.154805, -0.331796>, <-0.080784, -4.208930, -0.331805>, <-0.078565, -4.235750, -0.331805>, 
      <-0.712241, -4.121122, -0.647355>, <-0.713468, -4.148006, -0.647355>, <-0.729108, -4.182803, -0.647355>, <-0.726888, -4.209623, -0.647355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.317833, -4.125515, -0.556291>, <3.316606, -4.152398, -0.556291>, <3.300966, -4.187195, -0.556291>, <3.303185, -4.214015, -0.556291>, 
      <2.892137, -4.130707, -0.289734>, <2.890910, -4.157590, -0.289734>, <2.875225, -4.209983, -0.289706>, <2.877445, -4.236803, -0.289706>, 
      <2.166918, -4.126490, -0.279188>, <2.168493, -4.176440, -0.279188>, <2.146031, -4.242916, -0.279176>, <2.152813, -4.292428, -0.279176>, 
      <1.664756, -4.125943, -0.290535>, <1.666331, -4.175893, -0.290535>, <1.643326, -4.242368, -0.290535>, <1.650108, -4.291880, -0.290535>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.538401, -4.103093, -1.463750>, <3.537174, -4.129976, -1.463750>, <3.521533, -4.164774, -1.463750>, <3.523753, -4.191593, -1.463750>, 
      <3.538401, -4.111824, -1.183641>, <3.537174, -4.138707, -1.183641>, <3.574752, -4.162772, -1.188612>, <3.576972, -4.189592, -1.188612>, 
      <3.555343, -4.122618, -0.705012>, <3.554115, -4.149501, -0.705012>, <3.538244, -4.174495, -0.704867>, <3.540464, -4.201315, -0.704867>, 
      <3.317833, -4.125515, -0.556291>, <3.316606, -4.152398, -0.556291>, <3.300966, -4.187195, -0.556291>, <3.303185, -4.214015, -0.556291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.317833, -4.080669, -1.995147>, <3.257670, -4.157910, -1.995147>, <3.016796, -4.126908, -1.995147>, <3.024871, -4.224482, -1.995147>, 
      <3.446048, -4.095551, -1.880353>, <3.385885, -4.172792, -1.880353>, <3.174340, -4.102534, -1.845156>, <3.182415, -4.200108, -1.845156>, 
      <3.538401, -4.097712, -1.636404>, <3.537174, -4.124595, -1.636404>, <3.479966, -4.166336, -1.678648>, <3.482186, -4.193156, -1.678648>, 
      <3.538401, -4.103093, -1.463750>, <3.537174, -4.129976, -1.463750>, <3.521533, -4.164774, -1.463750>, <3.523753, -4.191593, -1.463750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.678317, -4.003263, -2.233806>, <2.696674, -4.097997, -2.233806>, <2.715474, -4.227152, -2.193434>, <2.766207, -4.308798, -2.184979>, 
      <2.878608, -4.018242, -2.187622>, <2.896965, -4.112976, -2.187622>, <2.811790, -4.229198, -2.168460>, <2.862523, -4.310844, -2.160005>, 
      <3.164861, -4.062914, -2.132107>, <3.104698, -4.140155, -2.132107>, <2.945165, -4.137991, -2.063344>, <2.953240, -4.235565, -2.063344>, 
      <3.317833, -4.080669, -1.995147>, <3.257670, -4.157910, -1.995147>, <3.016796, -4.126908, -1.995147>, <3.024871, -4.224482, -1.995147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.282818, -4.003263, -2.233806>, <2.284603, -4.066722, -2.233806>, <2.273616, -4.148736, -2.191362>, <2.292766, -4.208926, -2.184979>, 
      <2.401450, -4.004650, -2.235308>, <2.403235, -4.068108, -2.235308>, <2.417633, -4.158776, -2.176224>, <2.436783, -4.218966, -2.169841>, 
      <2.563007, -3.994639, -2.260395>, <2.581364, -4.089373, -2.260395>, <2.574992, -4.224167, -2.229861>, <2.625725, -4.305813, -2.221405>, 
      <2.678317, -4.003263, -2.233806>, <2.696674, -4.097997, -2.233806>, <2.715474, -4.227152, -2.193434>, <2.766207, -4.308798, -2.184979>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.945911, -3.994701, -2.224529>, <1.945911, -4.071921, -2.242431>, <1.968363, -4.175051, -2.275727>, <1.975208, -4.253656, -2.268122>, 
      <2.046787, -3.987559, -2.226233>, <2.046787, -4.064779, -2.244135>, <2.067684, -4.171752, -2.277360>, <2.074528, -4.250358, -2.269755>, 
      <2.181690, -4.002081, -2.232525>, <2.183475, -4.065540, -2.232525>, <2.175009, -4.141862, -2.201727>, <2.194158, -4.202052, -2.195344>, 
      <2.282818, -4.003263, -2.233806>, <2.284603, -4.066722, -2.233806>, <2.273616, -4.148736, -2.191362>, <2.292766, -4.208926, -2.184979>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.386441, -4.066726, -2.218665>, <1.363563, -4.113361, -2.203747>, <1.369745, -4.185939, -2.176669>, <1.371794, -4.239511, -2.169839>, 
      <1.555269, -4.058768, -2.210043>, <1.532391, -4.105403, -2.195125>, <1.552800, -4.194276, -2.185521>, <1.554849, -4.247848, -2.178691>, 
      <1.777122, -4.006651, -2.221678>, <1.777122, -4.083871, -2.239580>, <1.785030, -4.181139, -2.272713>, <1.791875, -4.259745, -2.265109>, 
      <1.945911, -3.994701, -2.224529>, <1.945911, -4.071921, -2.242431>, <1.968363, -4.175051, -2.275727>, <1.975208, -4.253656, -2.268122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.037727, -4.037512, -2.270908>, <1.028097, -4.090656, -2.268985>, <1.019497, -4.156702, -2.228052>, <1.023079, -4.210296, -2.222082>, 
      <1.143577, -4.041364, -2.264020>, <1.133947, -4.094508, -2.262097>, <1.124252, -4.172348, -2.221109>, <1.127834, -4.225942, -2.215138>, 
      <1.280552, -4.071718, -2.224072>, <1.257675, -4.118353, -2.209155>, <1.263834, -4.181116, -2.171547>, <1.265883, -4.234688, -2.164717>, 
      <1.386441, -4.066726, -2.218665>, <1.363563, -4.113361, -2.203747>, <1.369745, -4.185939, -2.176669>, <1.371794, -4.239511, -2.169839>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.583635, -4.037512, -2.270908>, <0.581879, -4.066680, -2.270908>, <0.579559, -4.092868, -2.222801>, <0.583635, -4.121795, -2.222082>, 
      <0.719863, -4.037512, -2.270908>, <0.718107, -4.066680, -2.270908>, <0.714039, -4.092868, -2.222801>, <0.718115, -4.121795, -2.222082>, 
      <0.901876, -4.032568, -2.279749>, <0.892247, -4.085712, -2.277826>, <0.886777, -4.136880, -2.236850>, <0.890359, -4.190474, -2.230879>, 
      <1.037727, -4.037512, -2.270908>, <1.028097, -4.090656, -2.268985>, <1.019497, -4.156702, -2.228052>, <1.023079, -4.210296, -2.222082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.129544, -4.037512, -2.270908>, <0.126438, -4.091466, -2.270908>, <0.133044, -4.159688, -2.227581>, <0.114896, -4.210296, -2.222082>, 
      <0.264349, -4.033479, -2.290122>, <0.261243, -4.087434, -2.290122>, <0.275311, -4.155022, -2.242331>, <0.257163, -4.205630, -2.236832>, 
      <0.447408, -4.037512, -2.270908>, <0.445652, -4.066680, -2.270908>, <0.436453, -4.092868, -2.222801>, <0.440529, -4.121795, -2.222082>, 
      <0.583635, -4.037512, -2.270908>, <0.581879, -4.066680, -2.270908>, <0.579559, -4.092868, -2.222801>, <0.583635, -4.121795, -2.222082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.129544, -4.037512, -2.270908>, <-0.126559, -4.045173, -2.234406>, <-0.497883, -4.063930, -2.230701>, <-0.712241, -4.076277, -2.086210>, 
      <0.126438, -4.091466, -2.270908>, <-0.129665, -4.099127, -2.234406>, <-0.499110, -4.090814, -2.230701>, <-0.713468, -4.103160, -2.086210>, 
      <0.133044, -4.159688, -2.227581>, <-0.121623, -4.168040, -2.201178>, <-0.512217, -4.142672, -2.222439>, <-0.729108, -4.137957, -2.086210>, 
      <0.114896, -4.210296, -2.222082>, <-0.139771, -4.218648, -2.195679>, <-0.509998, -4.169492, -2.222439>, <-0.726888, -4.164777, -2.086210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.932809, -3.866387, -1.554816>, <-0.932809, -3.936081, -1.554816>, <-0.929630, -4.029078, -1.554816>, <-0.932809, -4.098700, -1.554816>, 
      <-0.932809, -3.861006, -1.727469>, <-0.932809, -3.930700, -1.727469>, <-0.929630, -4.023697, -1.727469>, <-0.932809, -4.093319, -1.727469>, 
      <-0.858147, -3.831674, -1.994567>, <-0.858147, -3.901369, -1.994567>, <-0.852134, -4.014896, -1.989771>, <-0.855313, -4.084518, -1.989771>, 
      <-0.712241, -3.843963, -2.086210>, <-0.712241, -3.913657, -2.086210>, <-0.709062, -4.006655, -2.086210>, <-0.712241, -4.076277, -2.086210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.712241, -3.888809, -0.647355>, <-0.712241, -3.958503, -0.647355>, <-0.709062, -4.051500, -0.647355>, <-0.712241, -4.121122, -0.647355>, 
      <-0.963649, -3.892640, -0.771116>, <-0.963649, -3.962334, -0.771116>, <-0.961035, -4.048858, -0.769995>, <-0.964213, -4.118479, -0.769995>, 
      <-0.932809, -3.875117, -1.274707>, <-0.932809, -3.944811, -1.274707>, <-0.929630, -4.037808, -1.274707>, <-0.932809, -4.107430, -1.274707>, 
      <-0.932809, -3.866387, -1.554816>, <-0.932809, -3.936081, -1.554816>, <-0.929630, -4.029078, -1.554816>, <-0.932809, -4.098700, -1.554816>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.635459, -3.827254, -0.290535>, <1.643205, -3.916957, -0.290535>, <1.661919, -4.035951, -0.290535>, <1.664756, -4.125943, -0.290535>, 
      <0.923004, -3.826478, -0.306634>, <0.930750, -3.916180, -0.306634>, <0.941013, -4.035165, -0.306825>, <0.943850, -4.125157, -0.306825>, 
      <-0.072934, -3.879068, -0.332643>, <-0.072934, -3.948762, -0.332643>, <-0.060720, -4.058300, -0.331796>, <-0.063899, -4.127922, -0.331796>, 
      <-0.712241, -3.888809, -0.647355>, <-0.712241, -3.958503, -0.647355>, <-0.709062, -4.051500, -0.647355>, <-0.712241, -4.121122, -0.647355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.317833, -3.893202, -0.556291>, <3.317833, -3.962896, -0.556291>, <3.321012, -4.055894, -0.556291>, <3.317833, -4.125515, -0.556291>, 
      <2.882639, -3.883248, -0.287982>, <2.882639, -3.952942, -0.287982>, <2.895316, -4.061085, -0.289734>, <2.892137, -4.130707, -0.289734>, 
      <2.146682, -3.827811, -0.278983>, <2.154428, -3.917514, -0.278983>, <2.164081, -4.036498, -0.279188>, <2.166918, -4.126490, -0.279188>, 
      <1.635459, -3.827254, -0.290535>, <1.643205, -3.916957, -0.290535>, <1.661919, -4.035951, -0.290535>, <1.664756, -4.125943, -0.290535>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.538401, -3.870779, -1.463750>, <3.538401, -3.940473, -1.463750>, <3.541580, -4.033472, -1.463750>, <3.538401, -4.103093, -1.463750>, 
      <3.538401, -3.879510, -1.183641>, <3.538401, -3.949204, -1.183641>, <3.541580, -4.042202, -1.183641>, <3.538401, -4.111824, -1.183641>, 
      <3.556339, -3.898657, -0.703336>, <3.556339, -3.968351, -0.703336>, <3.558522, -4.052997, -0.705012>, <3.555343, -4.122618, -0.705012>, 
      <3.317833, -3.893202, -0.556291>, <3.317833, -3.962896, -0.556291>, <3.321012, -4.055894, -0.556291>, <3.317833, -4.125515, -0.556291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.317833, -3.848356, -1.995147>, <3.317833, -3.918050, -1.995147>, <3.360659, -4.025686, -1.995147>, <3.317833, -4.080669, -1.995147>, 
      <3.450180, -3.850748, -1.884166>, <3.450180, -3.920442, -1.884166>, <3.488874, -4.040568, -1.880353>, <3.446048, -4.095551, -1.880353>, 
      <3.538401, -3.865398, -1.636404>, <3.538401, -3.935092, -1.636404>, <3.541580, -4.028090, -1.636404>, <3.538401, -4.097712, -1.636404>, 
      <3.538401, -3.870779, -1.463750>, <3.538401, -3.940473, -1.463750>, <3.541580, -4.033472, -1.463750>, <3.538401, -4.103093, -1.463750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.678317, -3.855235, -2.184979>, <2.654163, -3.895210, -2.187275>, <2.669421, -3.957355, -2.233806>, <2.678317, -4.003263, -2.233806>, 
      <2.875169, -3.853927, -2.148875>, <2.851014, -3.893901, -2.151171>, <2.869712, -3.972334, -2.187622>, <2.878608, -4.018242, -2.187622>, 
      <3.164491, -3.845585, -2.123733>, <3.164491, -3.915278, -2.123733>, <3.207687, -4.007930, -2.132107>, <3.164861, -4.062914, -2.132107>, 
      <3.317833, -3.848356, -1.995147>, <3.317833, -3.918050, -1.995147>, <3.360659, -4.025686, -1.995147>, <3.317833, -4.080669, -1.995147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.282818, -3.855235, -2.184979>, <2.258751, -3.895065, -2.180391>, <2.281503, -3.956520, -2.233806>, <2.282818, -4.003263, -2.233806>, 
      <2.400943, -3.844130, -2.183954>, <2.376876, -3.883960, -2.179365>, <2.400136, -3.957906, -2.235308>, <2.401450, -4.004650, -2.235308>, 
      <2.561616, -3.856011, -2.206383>, <2.537462, -3.895985, -2.208679>, <2.554111, -3.948731, -2.260395>, <2.563007, -3.994639, -2.260395>, 
      <2.678317, -3.855235, -2.184979>, <2.654163, -3.895210, -2.187275>, <2.669421, -3.957355, -2.233806>, <2.678317, -4.003263, -2.233806>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.975208, -3.921333, -2.191082>, <1.961914, -3.943334, -2.192346>, <1.945911, -3.969629, -2.218717>, <1.945911, -3.994701, -2.224529>, 
      <2.068219, -3.907542, -2.182628>, <2.054925, -3.929543, -2.183892>, <2.046787, -3.962487, -2.220421>, <2.046787, -3.987559, -2.226233>, 
      <2.188829, -3.864071, -2.185795>, <2.164762, -3.903901, -2.181207>, <2.180375, -3.955338, -2.232525>, <2.181690, -4.002081, -2.232525>, 
      <2.282818, -3.855235, -2.184979>, <2.258751, -3.895065, -2.180391>, <2.281503, -3.956520, -2.233806>, <2.282818, -4.003263, -2.233806>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.503626, -3.970773, -2.255804>, <1.503626, -4.017333, -2.251237>, <1.406245, -4.026356, -2.231579>, <1.386441, -4.066726, -2.218665>, 
      <1.646871, -3.963447, -2.249531>, <1.646871, -4.010007, -2.244964>, <1.575073, -4.018398, -2.222957>, <1.555269, -4.058768, -2.210043>, 
      <1.833762, -3.942306, -2.203939>, <1.820468, -3.964308, -2.205203>, <1.777122, -3.981579, -2.215866>, <1.777122, -4.006651, -2.221678>, 
      <1.975208, -3.921333, -2.191082>, <1.961914, -3.943334, -2.192346>, <1.945911, -3.969629, -2.218717>, <1.945911, -3.994701, -2.224529>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.067024, -3.967778, -2.230857>, <1.067024, -3.993286, -2.233790>, <1.042302, -4.012263, -2.271822>, <1.037727, -4.037512, -2.270908>, 
      <1.197455, -3.981083, -2.235715>, <1.197455, -4.006591, -2.238648>, <1.148152, -4.016115, -2.264933>, <1.143577, -4.041364, -2.264020>, 
      <1.372725, -3.977467, -2.261537>, <1.372725, -4.024027, -2.256970>, <1.300356, -4.031348, -2.236986>, <1.280552, -4.071718, -2.224072>, 
      <1.503626, -3.970773, -2.255804>, <1.503626, -4.017333, -2.251237>, <1.406245, -4.026356, -2.231579>, <1.386441, -4.066726, -2.218665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.598284, -3.878421, -2.222082>, <0.582215, -3.925098, -2.213429>, <0.586646, -3.987485, -2.270908>, <0.583635, -4.037512, -2.270908>, 
      <0.741445, -3.880241, -2.223422>, <0.725376, -3.926918, -2.214769>, <0.722874, -3.987485, -2.270908>, <0.719863, -4.037512, -2.270908>, 
      <0.924682, -3.953258, -2.225555>, <0.924682, -3.978766, -2.228488>, <0.906452, -4.007319, -2.280662>, <0.901876, -4.032568, -2.279749>, 
      <1.067024, -3.967778, -2.230857>, <1.067024, -3.993286, -2.233790>, <1.042302, -4.012263, -2.271822>, <1.037727, -4.037512, -2.270908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.129544, -3.955859, -2.222082>, <0.149927, -3.975838, -2.222039>, <0.131184, -4.009018, -2.270908>, <0.129544, -4.037512, -2.270908>, 
      <0.271264, -3.959585, -2.236775>, <0.291647, -3.979564, -2.236732>, <0.265990, -4.004985, -2.290122>, <0.264349, -4.033479, -2.290122>, 
      <0.455774, -3.876609, -2.220748>, <0.439705, -3.923286, -2.212095>, <0.450419, -3.987485, -2.270908>, <0.447408, -4.037512, -2.270908>, 
      <0.598284, -3.878421, -2.222082>, <0.582215, -3.925098, -2.213429>, <0.586646, -3.987485, -2.270908>, <0.583635, -4.037512, -2.270908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.129544, -3.955859, -2.222082>, <-0.126990, -3.949114, -2.195485>, <-0.494318, -3.862317, -2.223088>, <-0.712241, -3.843963, -2.086210>, 
      <0.149927, -3.975838, -2.222039>, <-0.106607, -3.969092, -2.195442>, <-0.494318, -3.932011, -2.223088>, <-0.712241, -3.913657, -2.086210>, 
      <0.131184, -4.009018, -2.270908>, <-0.124918, -4.016678, -2.234406>, <-0.494704, -3.994309, -2.230701>, <-0.709062, -4.006655, -2.086210>, 
      <0.129544, -4.037512, -2.270908>, <-0.126559, -4.045173, -2.234406>, <-0.497883, -4.063930, -2.230701>, <-0.712241, -4.076277, -2.086210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.932809, -3.589823, -1.554816>, <-0.930344, -3.672559, -1.560524>, <-0.932809, -3.783418, -1.554816>, <-0.932809, -3.866387, -1.554816>, 
      <-0.932809, -3.584442, -1.727469>, <-0.930344, -3.667178, -1.733177>, <-0.932809, -3.778036, -1.727469>, <-0.932809, -3.861006, -1.727469>, 
      <-0.833237, -3.549847, -1.964186>, <-0.830772, -3.632583, -1.969894>, <-0.858147, -3.748706, -1.994567>, <-0.858147, -3.831674, -1.994567>, 
      <-0.712241, -3.567400, -2.086210>, <-0.709776, -3.650136, -2.091918>, <-0.712241, -3.760994, -2.086210>, <-0.712241, -3.843963, -2.086210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.712241, -3.612246, -0.647355>, <-0.710339, -3.695076, -0.651759>, <-0.712241, -3.805840, -0.647355>, <-0.712241, -3.888809, -0.647355>, 
      <-0.963380, -3.609567, -0.771692>, <-0.961478, -3.692397, -0.776096>, <-0.963649, -3.809671, -0.771116>, <-0.963649, -3.892640, -0.771116>, 
      <-0.932809, -3.598554, -1.274707>, <-0.930344, -3.681289, -1.280415>, <-0.932809, -3.792148, -1.274707>, <-0.932809, -3.875117, -1.274707>, 
      <-0.932809, -3.589823, -1.554816>, <-0.930344, -3.672559, -1.560524>, <-0.932809, -3.783418, -1.554816>, <-0.932809, -3.866387, -1.554816>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.620812, -3.617066, -0.290535>, <1.618859, -3.680236, -0.291604>, <1.630021, -3.764279, -0.290535>, <1.635459, -3.827254, -0.290535>, 
      <0.912937, -3.616294, -0.306530>, <0.910984, -3.679464, -0.307599>, <0.917565, -3.763502, -0.306634>, <0.923004, -3.826478, -0.306634>, 
      <-0.077725, -3.619015, -0.333210>, <-0.075823, -3.701846, -0.337615>, <-0.072934, -3.796099, -0.332643>, <-0.072934, -3.879068, -0.332643>, 
      <-0.712241, -3.612246, -0.647355>, <-0.710339, -3.695076, -0.651759>, <-0.712241, -3.805840, -0.647355>, <-0.712241, -3.888809, -0.647355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.317833, -3.616639, -0.556291>, <3.319735, -3.699469, -0.560695>, <3.317833, -3.810233, -0.556291>, <3.317833, -3.893202, -0.556291>, 
      <2.878288, -3.621876, -0.287370>, <2.880190, -3.704707, -0.291774>, <2.882639, -3.800279, -0.287982>, <2.882639, -3.883248, -0.287982>, 
      <2.135992, -3.617627, -0.278894>, <2.134039, -3.680798, -0.279963>, <2.141243, -3.764836, -0.278983>, <2.146682, -3.827811, -0.278983>, 
      <1.620812, -3.617066, -0.290535>, <1.618859, -3.680236, -0.291604>, <1.630021, -3.764279, -0.290535>, <1.635459, -3.827254, -0.290535>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.538401, -3.594216, -1.463750>, <3.540866, -3.676952, -1.469458>, <3.538401, -3.787810, -1.463750>, <3.538401, -3.870779, -1.463750>, 
      <3.538401, -3.602946, -1.183641>, <3.540866, -3.685682, -1.189349>, <3.538401, -3.796540, -1.183641>, <3.538401, -3.879510, -1.183641>, 
      <3.556873, -3.613790, -0.702540>, <3.558775, -3.696621, -0.706944>, <3.556339, -3.815688, -0.703336>, <3.556339, -3.898657, -0.703336>, 
      <3.317833, -3.616639, -0.556291>, <3.319735, -3.699469, -0.560695>, <3.317833, -3.810233, -0.556291>, <3.317833, -3.893202, -0.556291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.317833, -3.571793, -1.995147>, <3.320633, -3.654701, -1.993631>, <3.317833, -3.765387, -1.995147>, <3.317833, -3.848356, -1.995147>, 
      <3.426493, -3.574592, -1.860896>, <3.429293, -3.657499, -1.859380>, <3.450180, -3.767779, -1.884166>, <3.450180, -3.850748, -1.884166>, 
      <3.538401, -3.588835, -1.636404>, <3.540866, -3.671570, -1.642111>, <3.538401, -3.782429, -1.636404>, <3.538401, -3.865398, -1.636404>, 
      <3.538401, -3.594216, -1.463750>, <3.540866, -3.676952, -1.469458>, <3.538401, -3.787810, -1.463750>, <3.538401, -3.870779, -1.463750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.934875, -3.578672, -2.209413>, <2.938524, -3.691962, -2.213116>, <2.736897, -3.758288, -2.179409>, <2.678317, -3.855235, -2.184979>, 
      <3.058377, -3.577581, -2.163790>, <3.062026, -3.690870, -2.167494>, <2.933749, -3.756979, -2.143305>, <2.875169, -3.853927, -2.148875>, 
      <3.235010, -3.569660, -2.097476>, <3.237810, -3.652568, -2.095959>, <3.164491, -3.762616, -2.123733>, <3.164491, -3.845585, -2.123733>, 
      <3.317833, -3.571793, -1.995147>, <3.320633, -3.654701, -1.993631>, <3.317833, -3.765387, -1.995147>, <3.317833, -3.848356, -1.995147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.539374, -3.578672, -2.282716>, <2.542992, -3.695232, -2.290970>, <2.342987, -3.755658, -2.196450>, <2.282818, -3.855235, -2.184979>, 
      <2.660027, -3.580082, -2.284244>, <2.663645, -3.696642, -2.292498>, <2.461111, -3.744553, -2.195424>, <2.400943, -3.844130, -2.183954>, 
      <2.821684, -3.579672, -2.251227>, <2.825333, -3.692962, -2.254930>, <2.620197, -3.759063, -2.200813>, <2.561616, -3.856011, -2.206383>, 
      <2.934875, -3.578672, -2.209413>, <2.938524, -3.691962, -2.213116>, <2.736897, -3.758288, -2.179409>, <2.678317, -3.855235, -2.184979>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.202467, -3.570110, -2.200138>, <2.255420, -3.683923, -2.200684>, <2.040049, -3.814023, -2.184917>, <1.975208, -3.921333, -2.191082>, 
      <2.306396, -3.564580, -2.202139>, <2.359349, -3.678393, -2.202686>, <2.133060, -3.800232, -2.176463>, <2.068219, -3.907542, -2.182628>, 
      <2.435294, -3.577455, -2.281398>, <2.438912, -3.694015, -2.289652>, <2.248998, -3.764494, -2.197265>, <2.188829, -3.864071, -2.185795>, 
      <2.539374, -3.578672, -2.282716>, <2.542992, -3.695232, -2.290970>, <2.342987, -3.755658, -2.196450>, <2.282818, -3.855235, -2.184979>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.386441, -3.640026, -2.260516>, <1.410219, -3.741613, -2.274590>, <1.503626, -3.865998, -2.266080>, <1.503626, -3.970773, -2.255804>, 
      <1.632603, -3.630978, -2.255878>, <1.656380, -3.732565, -2.269953>, <1.646871, -3.858673, -2.259807>, <1.646871, -3.963447, -2.249531>, 
      <1.956489, -3.583200, -2.195402>, <2.009442, -3.697013, -2.195948>, <1.898604, -3.834997, -2.197774>, <1.833762, -3.942306, -2.203939>, 
      <2.202467, -3.570110, -2.200138>, <2.255420, -3.683923, -2.200684>, <2.040049, -3.814023, -2.184917>, <1.975208, -3.921333, -2.191082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.037727, -3.612920, -2.222082>, <1.084782, -3.708521, -2.230055>, <1.067024, -3.861626, -2.218650>, <1.067024, -3.967778, -2.230857>, 
      <1.142265, -3.603200, -2.211108>, <1.189320, -3.698801, -2.219081>, <1.197455, -3.874930, -2.223508>, <1.197455, -3.981083, -2.235715>, 
      <1.280970, -3.643903, -2.262503>, <1.304747, -3.745489, -2.276577>, <1.372725, -3.872692, -2.271813>, <1.372725, -3.977467, -2.261537>, 
      <1.386441, -3.640026, -2.260516>, <1.410219, -3.741613, -2.274590>, <1.503626, -3.865998, -2.266080>, <1.503626, -3.970773, -2.255804>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.698451, -3.703999, -2.332736>, <0.733129, -3.763203, -2.338681>, <0.620366, -3.814280, -2.233973>, <0.598284, -3.878421, -2.222082>, 
      <0.808635, -3.697000, -2.328400>, <0.843313, -3.756205, -2.334346>, <0.763526, -3.816100, -2.235312>, <0.741445, -3.880241, -2.223422>, 
      <0.928306, -3.623094, -2.233568>, <0.975361, -3.718696, -2.241541>, <0.924682, -3.847106, -2.213348>, <0.924682, -3.953258, -2.225555>, 
      <1.037727, -3.612920, -2.222082>, <1.084782, -3.708521, -2.230055>, <1.067024, -3.861626, -2.218650>, <1.067024, -3.967778, -2.230857>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.222010, -3.692937, -2.271652>, <-0.171295, -3.815107, -2.279916>, <0.034892, -3.863086, -2.222282>, <0.129544, -3.955859, -2.222082>, 
      <0.049392, -3.719217, -2.319081>, <0.100107, -3.841387, -2.327345>, <0.176612, -3.866812, -2.236975>, <0.271264, -3.959585, -2.236775>, 
      <0.422455, -3.721530, -2.343596>, <0.457133, -3.780734, -2.349542>, <0.477855, -3.812468, -2.232639>, <0.455774, -3.876609, -2.220748>, 
      <0.698451, -3.703999, -2.332736>, <0.733129, -3.763203, -2.338681>, <0.620366, -3.814280, -2.233973>, <0.598284, -3.878421, -2.222082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.222010, -3.692937, -2.271652>, <-0.380564, -3.677584, -2.243944>, <-0.598985, -3.583830, -2.200428>, <-0.712241, -3.567400, -2.086210>, 
      <-0.171295, -3.815107, -2.279916>, <-0.329848, -3.799754, -2.252208>, <-0.596520, -3.666566, -2.206136>, <-0.709776, -3.650136, -2.091918>, 
      <0.034892, -3.863086, -2.222282>, <-0.221642, -3.856341, -2.195685>, <-0.494318, -3.779348, -2.223088>, <-0.712241, -3.760994, -2.086210>, 
      <0.129544, -3.955859, -2.222082>, <-0.126990, -3.949114, -2.195485>, <-0.494318, -3.862317, -2.223088>, <-0.712241, -3.843963, -2.086210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.268171, -3.383350, -2.151562>, <2.349532, -3.441946, -2.190908>, <2.536041, -3.471283, -2.275111>, <2.539374, -3.578672, -2.282716>, 
      <2.387018, -3.381144, -2.149173>, <2.468379, -3.439741, -2.188519>, <2.656694, -3.472694, -2.276639>, <2.660027, -3.580082, -2.284244>, 
      <2.546036, -3.396918, -2.186989>, <2.627398, -3.450378, -2.198779>, <2.818529, -3.481711, -2.248024>, <2.821684, -3.579672, -2.251227>, 
      <2.663670, -3.400474, -2.170113>, <2.745032, -3.453934, -2.181903>, <2.931720, -3.480711, -2.206211>, <2.934875, -3.578672, -2.209413>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.740838, -3.417598, -2.188665>, <1.879327, -3.463352, -2.192107>, <2.140924, -3.437836, -2.199503>, <2.202467, -3.570110, -2.200138>, 
      <1.899636, -3.413312, -2.184022>, <2.038125, -3.459066, -2.187464>, <2.244854, -3.432305, -2.201505>, <2.306396, -3.564580, -2.202139>, 
      <2.109307, -3.386298, -2.154756>, <2.190668, -3.444894, -2.194102>, <2.431961, -3.470066, -2.273793>, <2.435294, -3.577455, -2.281398>, 
      <2.268171, -3.383350, -2.151562>, <2.349532, -3.441946, -2.190908>, <2.536041, -3.471283, -2.275111>, <2.539374, -3.578672, -2.282716>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.349267, -3.453286, -2.179390>, <0.454022, -3.528500, -2.225394>, <0.629508, -3.586295, -2.320916>, <0.698451, -3.703999, -2.332736>, 
      <0.489940, -3.453286, -2.179390>, <0.594695, -3.528500, -2.225394>, <0.739692, -3.579296, -2.316581>, <0.808635, -3.697000, -2.328400>, 
      <0.677474, -3.468135, -2.188887>, <0.743390, -3.513456, -2.198912>, <0.892804, -3.550964, -2.227553>, <0.928306, -3.623094, -2.233568>, 
      <0.818006, -3.461848, -2.188665>, <0.883922, -3.507170, -2.198690>, <1.002224, -3.540789, -2.216067>, <1.037727, -3.612920, -2.222082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.349267, -3.453286, -2.179390>, <0.221772, -3.453286, -2.179390>, <0.050539, -3.473678, -2.203554>, <-0.075530, -3.461848, -2.188665>, 
      <0.454022, -3.528500, -2.225394>, <0.326527, -3.528500, -2.225394>, <0.006595, -3.543005, -2.228451>, <-0.119474, -3.531175, -2.213561>, 
      <0.629508, -3.586295, -2.320916>, <0.353511, -3.603826, -2.331777>, <0.016571, -3.640152, -2.313733>, <-0.254831, -3.613872, -2.266304>, 
      <0.698451, -3.703999, -2.332736>, <0.422455, -3.721530, -2.343596>, <0.049392, -3.719217, -2.319081>, <-0.222010, -3.692937, -2.271652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.726888, -3.352299, -2.052291>, <-0.722494, -3.416829, -2.062467>, <-0.714186, -3.502109, -2.081706>, <-0.712241, -3.567400, -2.086210>, 
      <-0.566757, -3.368300, -2.174928>, <-0.562363, -3.432830, -2.185104>, <-0.600930, -3.518539, -2.195924>, <-0.598985, -3.583830, -2.200428>, 
      <-0.275598, -3.443074, -2.165036>, <-0.319542, -3.512400, -2.189932>, <-0.413385, -3.598519, -2.238596>, <-0.380564, -3.677584, -2.243944>, 
      <-0.075530, -3.461848, -2.188665>, <-0.119474, -3.531175, -2.213561>, <-0.254831, -3.613872, -2.266304>, <-0.222010, -3.692937, -2.271652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.947456, -3.374723, -1.520895>, <-0.943062, -3.439253, -1.531071>, <-0.934754, -3.524532, -1.550311>, <-0.932809, -3.589823, -1.554816>, 
      <-0.947456, -3.386866, -1.693205>, <-0.943062, -3.451396, -1.703381>, <-0.934754, -3.519151, -1.722964>, <-0.932809, -3.584442, -1.727469>, 
      <-0.863598, -3.338639, -1.947591>, <-0.859203, -3.403169, -1.957767>, <-0.835182, -3.484556, -1.959682>, <-0.833237, -3.549847, -1.964186>, 
      <-0.726888, -3.352299, -2.052291>, <-0.722494, -3.416829, -2.062467>, <-0.714186, -3.502109, -2.081706>, <-0.712241, -3.567400, -2.086210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.726888, -3.250898, -0.613436>, <-0.722494, -3.359302, -0.623612>, <-0.714739, -3.503459, -0.641571>, <-0.712241, -3.612246, -0.647355>, 
      <-0.981810, -3.261480, -0.734988>, <-0.977415, -3.369885, -0.745163>, <-0.965877, -3.500779, -0.765908>, <-0.963380, -3.609567, -0.771692>, 
      <-0.947456, -3.354855, -1.238978>, <-0.943062, -3.419385, -1.249154>, <-0.934754, -3.533262, -1.270202>, <-0.932809, -3.598554, -1.274707>, 
      <-0.947456, -3.374723, -1.520895>, <-0.943062, -3.439253, -1.531071>, <-0.934754, -3.524532, -1.550311>, <-0.932809, -3.589823, -1.554816>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.652784, -3.266780, -0.281049>, <1.643192, -3.371866, -0.283895>, <1.624073, -3.511570, -0.288749>, <1.620812, -3.617066, -0.290535>, 
      <0.932121, -3.265994, -0.297333>, <0.922529, -3.371080, -0.300179>, <0.916198, -3.510799, -0.304745>, <0.912937, -3.616294, -0.306530>, 
      <-0.076678, -3.223906, -0.303403>, <-0.072284, -3.332310, -0.313579>, <-0.080223, -3.510228, -0.327426>, <-0.077725, -3.619015, -0.333210>, 
      <-0.726888, -3.250898, -0.613436>, <-0.722494, -3.359302, -0.623612>, <-0.714739, -3.503459, -0.641571>, <-0.712241, -3.612246, -0.647355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.303185, -3.255292, -0.522372>, <3.307579, -3.363696, -0.532548>, <3.315335, -3.507852, -0.550507>, <3.317833, -3.616639, -0.556291>, 
      <2.877312, -3.229722, -0.260885>, <2.881706, -3.338126, -0.271060>, <2.875790, -3.513090, -0.281585>, <2.878288, -3.621876, -0.287370>, 
      <2.153053, -3.267325, -0.269745>, <2.143462, -3.372411, -0.272591>, <2.139253, -3.512132, -0.277108>, <2.135992, -3.617627, -0.278894>, 
      <1.652784, -3.266780, -0.281049>, <1.643192, -3.371866, -0.283895>, <1.624073, -3.511570, -0.288749>, <1.620812, -3.617066, -0.290535>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.523753, -3.379116, -1.429831>, <3.528147, -3.443646, -1.440007>, <3.536456, -3.528925, -1.459246>, <3.538401, -3.594216, -1.463750>, 
      <3.523753, -3.348877, -1.148837>, <3.528147, -3.413407, -1.159013>, <3.536456, -3.537656, -1.179137>, <3.538401, -3.602946, -1.183641>, 
      <3.543711, -3.269733, -0.670056>, <3.548105, -3.378138, -0.680232>, <3.554375, -3.505004, -0.696756>, <3.556873, -3.613790, -0.702540>, 
      <3.303185, -3.255292, -0.522372>, <3.307579, -3.363696, -0.532548>, <3.315335, -3.507852, -0.550507>, <3.317833, -3.616639, -0.556291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.303185, -3.414638, -2.003078>, <3.307579, -3.461785, -2.000699>, <3.316233, -3.524418, -1.996013>, <3.317833, -3.571793, -1.995147>, 
      <3.443052, -3.411165, -1.882693>, <3.447446, -3.458311, -1.880314>, <3.424893, -3.527216, -1.861762>, <3.426493, -3.574592, -1.860896>, 
      <3.523753, -3.398865, -1.613344>, <3.528147, -3.463395, -1.623520>, <3.536456, -3.523544, -1.631899>, <3.538401, -3.588835, -1.636404>, 
      <3.523753, -3.379116, -1.429831>, <3.528147, -3.443646, -1.440007>, <3.536456, -3.528925, -1.459246>, <3.538401, -3.594216, -1.463750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.303185, -3.414638, -2.003078>, <3.152889, -3.418370, -2.132439>, <2.859908, -3.406406, -2.141961>, <2.663670, -3.400474, -2.170113>, 
      <3.307579, -3.461785, -2.000699>, <3.157283, -3.465517, -2.130060>, <2.941270, -3.459866, -2.153751>, <2.745032, -3.453934, -2.181903>, 
      <3.316233, -3.524418, -1.996013>, <3.233410, -3.522284, -2.098342>, <3.055222, -3.479620, -2.160588>, <2.931720, -3.480711, -2.206211>, 
      <3.317833, -3.571793, -1.995147>, <3.235010, -3.569660, -2.097476>, <3.058377, -3.577581, -2.163790>, <2.934875, -3.578672, -2.209413>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.371794, -3.407542, -2.177771>, <1.376188, -3.477287, -2.202595>, <1.369691, -3.568464, -2.250602>, <1.386441, -3.640026, -2.260516>, 
      <1.482469, -3.402235, -2.177771>, <1.486863, -3.471980, -2.202595>, <1.615853, -3.559417, -2.245964>, <1.632603, -3.630978, -2.255878>, 
      <1.630123, -3.420586, -2.191902>, <1.768612, -3.466340, -2.195344>, <1.894947, -3.450926, -2.194767>, <1.956489, -3.583200, -2.195402>, 
      <1.740838, -3.417598, -2.188665>, <1.879327, -3.463352, -2.192107>, <2.140924, -3.437836, -2.199503>, <2.202467, -3.570110, -2.200138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.371794, -3.407542, -2.177771>, <1.205020, -3.415539, -2.177771>, <0.984804, -3.454386, -2.188401>, <0.818006, -3.461848, -2.188665>, 
      <1.376188, -3.477287, -2.202595>, <1.209414, -3.485284, -2.202595>, <1.050720, -3.499708, -2.198426>, <0.883922, -3.507170, -2.198690>, 
      <1.369691, -3.568464, -2.250602>, <1.264220, -3.572341, -2.252589>, <1.106763, -3.531068, -2.205093>, <1.002224, -3.540789, -2.216067>, 
      <1.386441, -3.640026, -2.260516>, <1.280970, -3.643903, -2.262503>, <1.142265, -3.603200, -2.211108>, <1.037727, -3.612920, -2.222082>
    }
  }
  texture {
    FireCape
  }
  scale <0.627278, 0.7, 0.941161>
  translate  <0.737099, -0.8337, -0.026897>
}
#declare Pants = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.122715, -11.937389, -1.302400>, <3.128748, -11.943298, -1.528236>, <3.052999, -11.947382, -1.707483>, <2.860500, -11.952882, -1.825750>, 
      <3.111566, -11.132316, -1.235711>, <3.117599, -11.138226, -1.461547>, <3.041850, -11.180417, -1.745591>, <2.849351, -11.185917, -1.863858>, 
      <3.085196, -10.061190, -1.109338>, <3.093742, -10.087061, -1.464242>, <3.062931, -10.393344, -1.801187>, <2.822986, -10.163978, -1.929705>, 
      <3.085551, -9.253813, -1.080104>, <3.094097, -9.279683, -1.435008>, <3.063280, -9.625699, -1.824259>, <2.823336, -9.396333, -1.952777>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.829481, -11.922491, -0.664546>, <2.957394, -11.921637, -0.831918>, <3.115481, -11.930301, -1.031589>, <3.122715, -11.937389, -1.302400>, 
      <2.818332, -11.136473, -0.664546>, <2.946244, -11.135618, -0.831918>, <3.104332, -11.125228, -0.964900>, <3.111566, -11.132316, -1.235711>, 
      <2.791972, -10.088526, -0.664546>, <2.903718, -10.075755, -0.768676>, <3.080462, -10.046860, -0.912733>, <3.085196, -10.061190, -1.109338>, 
      <2.792317, -9.302429, -0.664546>, <2.904063, -9.289658, -0.768676>, <3.080817, -9.239482, -0.883499>, <3.085551, -9.253813, -1.080104>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.532514, -11.941330, -0.530129>, <2.658113, -11.938810, -0.540039>, <2.770002, -11.922888, -0.586718>, <2.829481, -11.922491, -0.664546>, 
      <2.521365, -11.155311, -0.530129>, <2.646964, -11.152791, -0.540039>, <2.758852, -11.136870, -0.586718>, <2.818332, -11.136473, -0.664546>, 
      <2.495005, -10.107366, -0.530129>, <2.620604, -10.104845, -0.540039>, <2.720558, -10.096690, -0.597999>, <2.791972, -10.088526, -0.664546>, 
      <2.495350, -9.321268, -0.530129>, <2.620949, -9.318747, -0.540039>, <2.720903, -9.310592, -0.597999>, <2.792317, -9.302429, -0.664546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.716869, -11.944822, -0.576758>, <1.861481, -11.943490, -0.378876>, <2.218249, -11.947638, -0.505333>, <2.532514, -11.941330, -0.530129>, 
      <1.705720, -11.158803, -0.576758>, <1.850332, -11.157470, -0.378876>, <2.207099, -11.161619, -0.505333>, <2.521365, -11.155311, -0.530129>, 
      <1.679360, -10.110857, -0.576758>, <1.836751, -10.034439, -0.405119>, <2.180740, -10.113672, -0.505333>, <2.495005, -10.107366, -0.530129>, 
      <1.679705, -9.324758, -0.576758>, <1.837096, -9.248341, -0.405119>, <2.181085, -9.327574, -0.505333>, <2.495350, -9.321268, -0.530129>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.732454, -11.948700, -1.624907>, <1.554189, -11.944058, -1.261761>, <1.531318, -11.946531, -0.830661>, <1.716869, -11.944822, -0.576758>, 
      <1.721305, -11.277005, -1.558219>, <1.543040, -11.272364, -1.195072>, <1.520169, -11.160512, -0.830661>, <1.705720, -11.158803, -0.576758>, 
      <1.694994, -10.384365, -1.427040>, <1.543740, -10.596785, -1.191037>, <1.503798, -10.196097, -0.768212>, <1.679360, -10.110857, -0.576758>, 
      <1.695290, -9.709718, -1.402612>, <1.544036, -9.922138, -1.166609>, <1.504143, -9.409998, -0.768212>, <1.679705, -9.324758, -0.576758>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.316289, -11.960428, -1.797849>, <2.136412, -11.959762, -1.765823>, <1.836022, -11.951396, -1.835887>, <1.732454, -11.948700, -1.624907>, 
      <2.305140, -10.917181, -1.712106>, <2.125263, -10.916514, -1.680080>, <1.824873, -11.279702, -1.769199>, <1.721305, -11.277005, -1.558219>, 
      <2.278645, -9.529282, -1.543726>, <1.922068, -9.628343, -1.369818>, <1.921222, -10.066652, -1.780026>, <1.694994, -10.384365, -1.427040>, 
      <2.279125, -8.482938, -1.512040>, <1.922548, -8.582000, -1.338132>, <1.921518, -9.392005, -1.755598>, <1.695290, -9.709718, -1.402612>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.316289, -11.960428, -1.797849>, <2.305140, -10.917181, -1.712106>, <2.278645, -9.529282, -1.543726>, <2.279125, -8.482938, -1.512040>, 
      <2.477250, -11.961026, -1.826507>, <2.466101, -10.917778, -1.740765>, <2.579744, -9.445634, -1.690577>, <2.580225, -8.399290, -1.658891>, 
      <2.681345, -11.958000, -1.935819>, <2.670196, -11.191035, -1.973927>, <2.523553, -9.877745, -2.090087>, <2.523902, -9.110100, -2.113159>, 
      <2.860500, -11.952882, -1.825750>, <2.849351, -11.185917, -1.863858>, <2.822986, -10.163978, -1.929705>, <2.823336, -9.396333, -1.952777>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.145515, -12.010684, -1.660160>, <1.082833, -12.009692, -1.801632>, <0.873544, -11.970112, -1.843830>, <0.676182, -11.967324, -1.869673>, 
      <1.062263, -11.466542, -1.681363>, <0.999581, -11.465550, -1.822836>, <0.855371, -11.225902, -1.859732>, <0.658008, -11.223115, -1.885575>, 
      <0.865739, -10.747698, -1.723078>, <0.763276, -10.746291, -1.932712>, <0.826525, -10.467746, -1.906695>, <0.644111, -10.229953, -1.889750>, 
      <0.868009, -10.196874, -1.730838>, <0.765547, -10.195468, -1.940472>, <0.798018, -9.724421, -1.939626>, <0.615603, -9.486626, -1.922681>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.192491, -11.975498, -0.704376>, <1.414107, -11.985403, -0.999958>, <1.261885, -12.012526, -1.397516>, <1.145515, -12.010684, -1.660160>, 
      <1.198066, -11.231288, -0.704376>, <1.419682, -11.241194, -0.999958>, <1.178633, -11.468384, -1.418719>, <1.062263, -11.466542, -1.681363>, 
      <1.207984, -10.239023, -0.704376>, <1.381327, -10.486812, -1.099897>, <1.035683, -10.750030, -1.375380>, <0.865739, -10.747698, -1.723078>, 
      <1.211073, -9.494800, -0.704376>, <1.384416, -9.742588, -1.099897>, <1.037953, -10.199207, -1.383140>, <0.868009, -10.196874, -1.730838>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.358281, -11.975498, -0.610180>, <0.608837, -11.969209, -0.585435>, <0.998201, -11.966813, -0.445240>, <1.192491, -11.975498, -0.704376>, 
      <0.363856, -11.231288, -0.610180>, <0.614412, -11.224999, -0.585435>, <1.003776, -11.222604, -0.445240>, <1.198066, -11.231288, -0.704376>, 
      <0.379053, -10.239027, -0.610180>, <0.629609, -10.232738, -0.585435>, <1.095179, -10.077773, -0.446987>, <1.207984, -10.239023, -0.704376>, 
      <0.376863, -9.494800, -0.610180>, <0.627419, -9.488511, -0.585435>, <1.098268, -9.333550, -0.446987>, <1.211073, -9.494800, -0.704376>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.049587, -12.004182, -0.817248>, <0.139174, -12.000770, -0.704709>, <0.247012, -11.978290, -0.621169>, <0.358281, -11.975498, -0.610180>, 
      <0.055162, -11.259973, -0.817248>, <0.144749, -11.256562, -0.704709>, <0.252587, -11.234080, -0.621169>, <0.363856, -11.231288, -0.610180>, 
      <0.065080, -10.267708, -0.817248>, <0.154667, -10.264297, -0.704709>, <0.267785, -10.241819, -0.621169>, <0.379053, -10.239027, -0.610180>, 
      <0.068169, -9.523484, -0.817248>, <0.157756, -9.520073, -0.704709>, <0.265594, -9.497592, -0.621169>, <0.376863, -9.494800, -0.610180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.180318, -11.996003, -1.286767>, <-0.191976, -11.997686, -1.085324>, <-0.076053, -12.008966, -0.975077>, <0.049587, -12.004182, -0.817248>, 
      <-0.174743, -11.251794, -1.286767>, <-0.186401, -11.253477, -1.085324>, <-0.070478, -11.264756, -0.975077>, <0.055162, -11.259973, -0.817248>, 
      <-0.171278, -10.259470, -1.283844>, <-0.217882, -10.282594, -1.088878>, <-0.060560, -10.272491, -0.975077>, <0.065080, -10.267708, -0.817248>, 
      <-0.161736, -9.515306, -1.286767>, <-0.208340, -9.538430, -1.091802>, <-0.057471, -9.528268, -0.975077>, <0.068169, -9.523484, -0.817248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.106242, -11.996003, -1.796247>, <-0.038676, -12.000855, -1.697621>, <-0.167285, -11.994122, -1.511978>, <-0.180318, -11.996003, -1.286767>, 
      <0.156374, -11.223706, -1.760052>, <0.011456, -11.228558, -1.661426>, <-0.161710, -11.249912, -1.511978>, <-0.174743, -11.251794, -1.286767>, 
      <0.269504, -10.196326, -1.688731>, <0.132336, -10.201386, -1.576518>, <-0.118602, -10.233333, -1.504213>, <-0.171278, -10.259470, -1.283844>, 
      <0.273347, -9.421678, -1.675597>, <0.136178, -9.426738, -1.563384>, <-0.109060, -9.489169, -1.507136>, <-0.161736, -9.515306, -1.286767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.106242, -11.996003, -1.796247>, <0.156374, -11.223706, -1.760052>, <0.269504, -10.196326, -1.688731>, <0.273347, -9.421678, -1.675597>, 
      <0.248885, -11.991227, -1.893325>, <0.299017, -11.218930, -1.857130>, <0.368635, -10.192669, -1.769826>, <0.372478, -9.418022, -1.756692>, 
      <0.456028, -11.964214, -1.898501>, <0.437854, -11.220005, -1.914403>, <0.543945, -10.099378, -1.880445>, <0.515438, -9.356052, -1.913376>, 
      <0.676182, -11.967324, -1.869673>, <0.658008, -11.223115, -1.885575>, <0.644111, -10.229953, -1.889750>, <0.615603, -9.486626, -1.922681>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.164097, -7.502382, -1.723673>, <1.129019, -8.313875, -1.684054>, <0.871360, -9.383745, -1.742293>, <0.868009, -10.196874, -1.730838>, 
      <1.054806, -7.566409, -1.936536>, <1.019728, -8.377903, -1.896917>, <0.768898, -9.382338, -1.951927>, <0.765547, -10.195468, -1.940472>, 
      <0.779020, -7.717558, -2.047452>, <0.759604, -8.194446, -2.045405>, <0.779744, -9.247950, -1.960735>, <0.798018, -9.724421, -1.939626>, 
      <0.520333, -7.903614, -2.049707>, <0.500917, -8.380502, -2.047661>, <0.597330, -9.010157, -1.943790>, <0.615603, -9.486626, -1.922681>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.211073, -7.498951, -0.704376>, <1.205992, -8.097684, -0.704376>, <1.213558, -8.896050, -0.704376>, <1.211073, -9.494800, -0.704376>, 
      <1.444404, -7.499929, -1.021611>, <1.439323, -8.098662, -1.021611>, <1.386902, -9.143839, -1.099897>, <1.384416, -9.742588, -1.099897>, 
      <1.299163, -7.423254, -1.460609>, <1.264085, -8.234748, -1.420991>, <1.041305, -9.386078, -1.394595>, <1.037953, -10.199207, -1.383140>, 
      <1.164097, -7.502382, -1.723673>, <1.129019, -8.313875, -1.684054>, <0.871360, -9.383745, -1.742293>, <0.868009, -10.196874, -1.730838>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.345106, -7.498951, -0.610180>, <0.354417, -8.097709, -0.610180>, <0.375101, -8.895972, -0.610180>, <0.376863, -9.494800, -0.610180>, 
      <0.605082, -7.492426, -0.584505>, <0.614393, -8.091182, -0.584505>, <0.625657, -8.889684, -0.585435>, <0.627419, -9.488511, -0.585435>, 
      <1.011885, -7.498117, -0.433561>, <1.006803, -8.096850, -0.433561>, <1.100754, -8.734800, -0.446987>, <1.098268, -9.333550, -0.446987>, 
      <1.211073, -7.498951, -0.704376>, <1.205992, -8.097684, -0.704376>, <1.213558, -8.896050, -0.704376>, <1.211073, -9.494800, -0.704376>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.068169, -7.527637, -0.817248>, <0.084926, -8.126157, -0.817248>, <0.070654, -8.924735, -0.817248>, <0.068169, -9.523484, -0.817248>, 
      <0.142235, -7.505918, -0.707817>, <0.158992, -8.104438, -0.707817>, <0.160242, -8.921324, -0.704709>, <0.157756, -9.520073, -0.704709>, 
      <0.241549, -7.501550, -0.620407>, <0.250860, -8.100307, -0.620407>, <0.263832, -8.898765, -0.621169>, <0.265594, -9.497592, -0.621169>, 
      <0.345106, -7.498951, -0.610180>, <0.354417, -8.097709, -0.610180>, <0.375101, -8.895972, -0.610180>, <0.376863, -9.494800, -0.610180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.124419, -7.636631, -1.303892>, <-0.107993, -8.200094, -1.297623>, <-0.154508, -8.951620, -1.288981>, <-0.161736, -9.515306, -1.286767>, 
      <-0.134432, -7.508994, -1.142100>, <-0.118006, -8.072456, -1.135831>, <-0.201112, -8.974744, -1.094016>, <-0.208340, -9.538430, -1.091802>, 
      <-0.045945, -7.561099, -0.985849>, <-0.029188, -8.159618, -0.985849>, <-0.054986, -8.929518, -0.975077>, <-0.057471, -9.528268, -0.975077>, 
      <0.068169, -7.527637, -0.817248>, <0.084926, -8.126157, -0.817248>, <0.070654, -8.924735, -0.817248>, <0.068169, -9.523484, -0.817248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.124824, -8.249859, -1.732733>, <0.142479, -8.603651, -1.713167>, <0.275106, -9.066962, -1.669583>, <0.273347, -9.421678, -1.675597>, 
      <-0.024540, -8.188010, -1.559957>, <-0.006885, -8.541802, -1.540391>, <0.137938, -9.072022, -1.557370>, <0.136178, -9.426738, -1.563384>, 
      <-0.109647, -7.824941, -1.542593>, <-0.093221, -8.388404, -1.536324>, <-0.101832, -8.925482, -1.509350>, <-0.109060, -9.489169, -1.507136>, 
      <-0.124419, -7.636631, -1.303892>, <-0.107993, -8.200094, -1.297623>, <-0.154508, -8.951620, -1.288981>, <-0.161736, -9.515306, -1.286767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.124824, -8.249859, -1.732733>, <0.241068, -8.297994, -1.867198>, <0.328015, -8.041935, -2.051383>, <0.520333, -7.903614, -2.049707>, 
      <0.142479, -8.603651, -1.713167>, <0.258724, -8.651786, -1.847632>, <0.308599, -8.518822, -2.049337>, <0.500917, -8.380502, -2.047661>, 
      <0.275106, -9.066962, -1.669583>, <0.374237, -9.063304, -1.750678>, <0.497165, -8.879582, -1.934485>, <0.597330, -9.010157, -1.943790>, 
      <0.273347, -9.421678, -1.675597>, <0.372478, -9.418022, -1.756692>, <0.515438, -9.356052, -1.913376>, <0.615603, -9.486626, -1.922681>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.124640, -7.552162, -1.143617>, <3.120190, -8.060347, -1.090382>, <3.085775, -8.743162, -1.061614>, <3.085551, -9.253813, -1.080104>, 
      <3.132621, -7.600834, -1.475061>, <3.128171, -8.109019, -1.421825>, <3.094321, -8.769033, -1.416518>, <3.094097, -9.279683, -1.435008>, 
      <3.136252, -7.653917, -1.773761>, <3.132118, -8.154208, -1.802017>, <3.063509, -9.124820, -1.839313>, <3.063280, -9.625699, -1.824259>, 
      <2.862425, -7.726439, -1.952777>, <2.858292, -8.226730, -1.981033>, <2.823564, -8.895454, -1.967831>, <2.823336, -9.396333, -1.952777>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.831406, -7.537265, -0.664546>, <2.826903, -8.066925, -0.664546>, <2.792549, -8.772750, -0.664546>, <2.792317, -9.302429, -0.664546>, 
      <2.948271, -7.536485, -0.786022>, <2.943768, -8.066145, -0.786022>, <2.904296, -8.759978, -0.768676>, <2.904063, -9.289658, -0.768676>, 
      <3.119475, -7.520664, -0.929125>, <3.115026, -8.028850, -0.875890>, <3.081041, -8.728831, -0.865009>, <3.080817, -9.239482, -0.883499>, 
      <3.124640, -7.552162, -1.143617>, <3.120190, -8.060347, -1.090382>, <3.085775, -8.743162, -1.061614>, <3.085551, -9.253813, -1.080104>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.534439, -7.556103, -0.530129>, <2.529936, -8.085763, -0.530129>, <2.495582, -8.791589, -0.530129>, <2.495350, -9.321268, -0.530129>, 
      <2.660038, -7.553582, -0.540039>, <2.655535, -8.083242, -0.540039>, <2.621181, -8.789068, -0.540039>, <2.620949, -9.318747, -0.540039>, 
      <2.763495, -7.537718, -0.593956>, <2.758992, -8.067379, -0.593956>, <2.721135, -8.780912, -0.597999>, <2.720903, -9.310592, -0.597999>, 
      <2.831406, -7.537265, -0.664546>, <2.826903, -8.066925, -0.664546>, <2.792549, -8.772750, -0.664546>, <2.792317, -9.302429, -0.664546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.718794, -7.559597, -0.576758>, <1.714291, -8.089256, -0.576758>, <1.679937, -8.795080, -0.576758>, <1.679705, -9.324758, -0.576758>, 
      <1.878042, -7.558130, -0.390453>, <1.873539, -8.087790, -0.390453>, <1.837329, -8.718662, -0.405119>, <1.837096, -9.248341, -0.405119>, 
      <2.220174, -7.562411, -0.505333>, <2.215670, -8.092071, -0.505333>, <2.181317, -8.797895, -0.505333>, <2.181085, -9.327574, -0.505333>, 
      <2.534439, -7.556103, -0.530129>, <2.529936, -8.085763, -0.530129>, <2.495582, -8.791589, -0.530129>, <2.495350, -9.321268, -0.530129>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.734379, -7.563474, -1.466125>, <1.729732, -8.205315, -1.410535>, <1.695573, -9.065878, -1.379299>, <1.695290, -9.709718, -1.402612>, 
      <1.571635, -7.507505, -1.169083>, <1.566988, -8.149347, -1.113493>, <1.544319, -9.278298, -1.143296>, <1.544036, -9.922138, -1.166609>, 
      <1.545409, -7.561194, -0.779603>, <1.540906, -8.090854, -0.779603>, <1.504376, -8.880319, -0.768212>, <1.504143, -9.409998, -0.768212>, 
      <1.718794, -7.559597, -0.576758>, <1.714291, -8.089256, -0.576758>, <1.679937, -8.795080, -0.576758>, <1.679705, -9.324758, -0.576758>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.318214, -7.765741, -1.670823>, <2.315732, -7.977039, -1.607207>, <2.279226, -8.262358, -1.505360>, <2.279125, -8.482938, -1.512040>, 
      <2.140473, -7.740063, -1.594143>, <2.137992, -7.951362, -1.530528>, <1.922649, -8.361420, -1.331452>, <1.922548, -8.582000, -1.338132>, 
      <1.853468, -7.604428, -1.683487>, <1.848821, -8.246271, -1.627898>, <1.921801, -8.748165, -1.732286>, <1.921518, -9.392005, -1.755598>, 
      <1.734379, -7.563474, -1.466125>, <1.729732, -8.205315, -1.410535>, <1.695573, -9.065878, -1.379299>, <1.695290, -9.709718, -1.402612>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.318214, -7.765741, -1.670823>, <2.485925, -7.789970, -1.743175>, <2.668730, -7.777738, -2.079406>, <2.862425, -7.726439, -1.952777>, 
      <2.315732, -7.977039, -1.607207>, <2.483443, -8.001268, -1.679560>, <2.664596, -8.278030, -2.107663>, <2.858292, -8.226730, -1.981033>, 
      <2.279226, -8.262358, -1.505360>, <2.580326, -8.178710, -1.652211>, <2.524131, -8.609221, -2.128213>, <2.823564, -8.895454, -1.967831>, 
      <2.279125, -8.482938, -1.512040>, <2.580225, -8.399290, -1.658891>, <2.523902, -9.110100, -2.113159>, <2.823336, -9.396333, -1.952777>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.104133, -7.131765, -1.302400>, <3.108223, -7.265726, -1.286564>, <3.125815, -7.417946, -1.157677>, <3.124640, -7.552162, -1.143617>, 
      <3.110166, -7.137675, -1.528236>, <3.114256, -7.271636, -1.512400>, <3.133796, -7.466618, -1.489120>, <3.132621, -7.600834, -1.475061>, 
      <3.010099, -7.195436, -1.682686>, <3.014330, -7.373346, -1.685963>, <3.137720, -7.476215, -1.763725>, <3.136252, -7.653917, -1.773761>, 
      <2.841918, -7.147258, -1.825750>, <2.846150, -7.325168, -1.829027>, <2.863893, -7.548738, -1.942741>, <2.862425, -7.726439, -1.952777>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.810899, -7.116868, -0.664546>, <2.814753, -7.243078, -0.664546>, <2.832480, -7.411000, -0.664546>, <2.831406, -7.537265, -0.664546>, 
      <2.938812, -7.116014, -0.831918>, <2.942666, -7.242224, -0.831918>, <2.949345, -7.410220, -0.786022>, <2.948271, -7.536485, -0.786022>, 
      <3.096899, -7.124678, -1.031589>, <3.100989, -7.258638, -1.015753>, <3.120651, -7.386448, -0.943185>, <3.119475, -7.520664, -0.929125>, 
      <3.104133, -7.131765, -1.302400>, <3.108223, -7.265726, -1.286564>, <3.125815, -7.417946, -1.157677>, <3.124640, -7.552162, -1.143617>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.513932, -7.135706, -0.530129>, <2.517786, -7.261916, -0.530129>, <2.535513, -7.429838, -0.530129>, <2.534439, -7.556103, -0.530129>, 
      <2.639531, -7.133185, -0.540039>, <2.643385, -7.259395, -0.540039>, <2.661112, -7.427318, -0.540039>, <2.660038, -7.553582, -0.540039>, 
      <2.751420, -7.117266, -0.586718>, <2.755274, -7.243475, -0.586718>, <2.764569, -7.411454, -0.593956>, <2.763495, -7.537718, -0.593956>, 
      <2.810899, -7.116868, -0.664546>, <2.814753, -7.243078, -0.664546>, <2.832480, -7.411000, -0.664546>, <2.831406, -7.537265, -0.664546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.698287, -7.139198, -0.576758>, <1.702141, -7.265410, -0.576758>, <1.719867, -7.433332, -0.576758>, <1.718794, -7.559597, -0.576758>, 
      <1.842899, -7.137866, -0.378876>, <1.846752, -7.264077, -0.378876>, <1.879115, -7.431866, -0.390453>, <1.878042, -7.558130, -0.390453>, 
      <2.199667, -7.142013, -0.505333>, <2.203520, -7.268223, -0.505333>, <2.221247, -7.436146, -0.505333>, <2.220174, -7.562411, -0.505333>, 
      <2.513932, -7.135706, -0.530129>, <2.517786, -7.261916, -0.530129>, <2.535513, -7.429838, -0.530129>, <2.534439, -7.556103, -0.530129>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.713872, -7.143076, -1.624907>, <1.717962, -7.277037, -1.609072>, <1.735352, -7.429025, -1.477770>, <1.734379, -7.563474, -1.466125>, 
      <1.557623, -7.205231, -1.256942>, <1.561714, -7.339192, -1.241106>, <1.572608, -7.373056, -1.180727>, <1.571635, -7.507505, -1.169083>, 
      <1.512736, -7.140908, -0.830661>, <1.516590, -7.267119, -0.830661>, <1.546482, -7.434930, -0.779603>, <1.545409, -7.561194, -0.779603>, 
      <1.698287, -7.139198, -0.576758>, <1.702141, -7.265410, -0.576758>, <1.719867, -7.433332, -0.576758>, <1.718794, -7.559597, -0.576758>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.297707, -6.900751, -1.988389>, <2.305073, -7.176211, -1.965575>, <2.321323, -7.500996, -1.750530>, <2.318214, -7.765741, -1.670823>, 
      <2.082341, -6.899953, -1.950044>, <2.089707, -7.175413, -1.927231>, <2.143583, -7.475318, -1.673850>, <2.140473, -7.740063, -1.594143>, 
      <1.822559, -7.099841, -1.880864>, <1.826649, -7.233802, -1.865029>, <1.854442, -7.469980, -1.695132>, <1.853468, -7.604428, -1.683487>, 
      <1.713872, -7.143076, -1.624907>, <1.717962, -7.277037, -1.609072>, <1.735352, -7.429025, -1.477770>, <1.734379, -7.563474, -1.466125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.297707, -6.900751, -1.988389>, <2.480583, -6.901429, -2.020949>, <2.664084, -7.096314, -1.977025>, <2.841918, -7.147258, -1.825750>, 
      <2.305073, -7.176211, -1.965575>, <2.487949, -7.176889, -1.998136>, <2.668316, -7.274225, -1.980301>, <2.846150, -7.325168, -1.829027>, 
      <2.321323, -7.500996, -1.750530>, <2.489034, -7.525224, -1.822882>, <2.670198, -7.600037, -2.069370>, <2.863893, -7.548738, -1.942741>, 
      <2.318214, -7.765741, -1.670823>, <2.485925, -7.789970, -1.743175>, <2.668730, -7.777738, -2.079406>, <2.862425, -7.726439, -1.952777>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.009471, -6.924297, -1.890611>, <1.001262, -7.110418, -1.885299>, <1.172136, -7.316399, -1.732753>, <1.164097, -7.502382, -1.723673>, 
      <0.972476, -6.921436, -1.978659>, <0.964266, -7.107556, -1.973347>, <1.062845, -7.380427, -1.945616>, <1.054806, -7.566409, -1.936536>, 
      <0.831810, -7.001635, -1.945808>, <0.816882, -7.269474, -1.941316>, <0.789934, -7.449490, -2.048602>, <0.779020, -7.717558, -2.047452>, 
      <0.715271, -7.038624, -1.933186>, <0.700343, -7.306462, -1.928694>, <0.531247, -7.635546, -2.050857>, <0.520333, -7.903614, -2.049707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.231580, -7.078554, -0.704376>, <1.230624, -7.204820, -0.704376>, <1.212145, -7.372686, -0.704376>, <1.211073, -7.498951, -0.704376>, 
      <1.448745, -7.141255, -1.115950>, <1.447789, -7.267521, -1.115950>, <1.445476, -7.373664, -1.021611>, <1.444404, -7.499929, -1.021611>, 
      <1.150796, -6.935226, -1.554259>, <1.142587, -7.121347, -1.548946>, <1.307203, -7.237272, -1.469689>, <1.299163, -7.423254, -1.460609>, 
      <1.009471, -6.924297, -1.890611>, <1.001262, -7.110418, -1.885299>, <1.172136, -7.316399, -1.732753>, <1.164097, -7.502382, -1.723673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.333857, -6.729232, -0.610180>, <0.326692, -6.960061, -0.610180>, <0.341515, -7.268038, -0.610180>, <0.345106, -7.498951, -0.610180>, 
      <0.618388, -6.781021, -0.584242>, <0.611223, -7.011850, -0.584242>, <0.601491, -7.261513, -0.584505>, <0.605082, -7.492426, -0.584505>, 
      <1.058820, -7.028674, -0.376960>, <1.057864, -7.154940, -0.376960>, <1.012956, -7.371852, -0.433561>, <1.011885, -7.498117, -0.433561>, 
      <1.231580, -7.078554, -0.704376>, <1.230624, -7.204820, -0.704376>, <1.212145, -7.372686, -0.704376>, <1.211073, -7.498951, -0.704376>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.006594, -6.853187, -0.817248>, <-0.008136, -7.056755, -0.817248>, <0.062472, -7.324142, -0.817248>, <0.068169, -7.527637, -0.817248>, 
      <0.092009, -6.816243, -0.695380>, <0.090467, -7.019812, -0.695380>, <0.136537, -7.302424, -0.707817>, <0.142235, -7.505918, -0.707817>, 
      <0.211180, -6.706902, -0.621363>, <0.204015, -6.937732, -0.621363>, <0.237958, -7.270638, -0.620407>, <0.241549, -7.501550, -0.620407>, 
      <0.333857, -6.729232, -0.610180>, <0.326692, -6.960061, -0.610180>, <0.341515, -7.268038, -0.610180>, <0.345106, -7.498951, -0.610180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.236722, -6.943014, -1.315385>, <-0.232843, -7.153787, -1.317839>, <-0.130562, -7.425910, -1.306236>, <-0.124419, -7.636631, -1.303892>, 
      <-0.271127, -6.873678, -1.115238>, <-0.267249, -7.084451, -1.117692>, <-0.140574, -7.298273, -1.144444>, <-0.134432, -7.508994, -1.142100>, 
      <-0.137973, -6.902412, -0.979626>, <-0.139515, -7.105980, -0.979626>, <-0.051643, -7.357605, -0.985849>, <-0.045945, -7.561099, -0.985849>, 
      <-0.006594, -6.853187, -0.817248>, <-0.008136, -7.056755, -0.817248>, <0.062472, -7.324142, -0.817248>, <0.068169, -7.527637, -0.817248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.162142, -7.193234, -1.798838>, <0.160392, -7.510987, -1.804258>, <0.109009, -7.932932, -1.750260>, <0.124824, -8.249859, -1.732733>, 
      <-0.007088, -7.176238, -1.689015>, <-0.008838, -7.493991, -1.694436>, <-0.040356, -7.871082, -1.577484>, <-0.024540, -8.188010, -1.559957>, 
      <-0.194964, -7.027167, -1.558304>, <-0.191085, -7.237940, -1.560759>, <-0.115790, -7.614220, -1.544937>, <-0.109647, -7.824941, -1.542593>, 
      <-0.236722, -6.943014, -1.315385>, <-0.232843, -7.153787, -1.317839>, <-0.130562, -7.425910, -1.306236>, <-0.124419, -7.636631, -1.303892>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.162142, -7.193234, -1.798838>, <0.310052, -7.208089, -1.894825>, <0.499445, -7.107126, -1.909810>, <0.715271, -7.038624, -1.933186>, 
      <0.160392, -7.510987, -1.804258>, <0.308302, -7.525842, -1.900245>, <0.484517, -7.374965, -1.905318>, <0.700343, -7.306462, -1.928694>, 
      <0.109009, -7.932932, -1.750260>, <0.225253, -7.981067, -1.884726>, <0.338929, -7.773867, -2.052534>, <0.531247, -7.635546, -2.050857>, 
      <0.124824, -8.249859, -1.732733>, <0.241068, -8.297994, -1.867198>, <0.328015, -8.041935, -2.051383>, <0.520333, -7.903614, -2.049707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.083626, -6.208943, -1.302400>, <3.096440, -6.485137, -1.287082>, <3.095740, -6.856891, -1.334893>, <3.104133, -7.131765, -1.302400>, 
      <3.090246, -6.167991, -1.570526>, <3.103060, -6.444185, -1.555208>, <3.101773, -6.862802, -1.560729>, <3.110166, -7.137675, -1.528236>, 
      <3.052516, -5.995537, -1.779035>, <3.072447, -6.339507, -1.766422>, <3.001902, -6.850815, -1.676339>, <3.010099, -7.195436, -1.682686>, 
      <2.821412, -6.002140, -1.921020>, <2.841343, -6.346109, -1.908407>, <2.833721, -6.802637, -1.819403>, <2.841918, -7.147258, -1.825750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.790391, -6.194046, -0.664546>, <2.793521, -6.470929, -0.667388>, <2.802447, -6.840082, -0.664546>, <2.810899, -7.116868, -0.664546>, 
      <2.918304, -6.193192, -0.831918>, <2.921434, -6.470075, -0.834760>, <2.930360, -6.839228, -0.831918>, <2.938812, -7.116014, -0.831918>, 
      <3.077014, -6.249847, -1.034586>, <3.089828, -6.526041, -1.019268>, <3.088506, -6.849804, -1.064082>, <3.096899, -7.124678, -1.031589>, 
      <3.083626, -6.208943, -1.302400>, <3.096440, -6.485137, -1.287082>, <3.095740, -6.856891, -1.334893>, <3.104133, -7.131765, -1.302400>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.493424, -6.212884, -0.530129>, <2.518233, -6.488660, -0.533885>, <2.505480, -6.858920, -0.530129>, <2.513932, -7.135706, -0.530129>, 
      <2.619023, -6.210363, -0.540039>, <2.643832, -6.486139, -0.543795>, <2.631079, -6.856399, -0.540039>, <2.639531, -7.133185, -0.540039>, 
      <2.730912, -6.194443, -0.586718>, <2.734042, -6.471326, -0.589560>, <2.742968, -6.840479, -0.586718>, <2.751420, -7.117266, -0.586718>, 
      <2.790391, -6.194046, -0.664546>, <2.793521, -6.470929, -0.667388>, <2.802447, -6.840082, -0.664546>, <2.810899, -7.116868, -0.664546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.677780, -6.216377, -0.576758>, <1.711326, -6.490271, -0.599968>, <1.689836, -6.862413, -0.576758>, <1.698287, -7.139198, -0.576758>, 
      <1.822391, -6.215044, -0.378876>, <1.855937, -6.488938, -0.402086>, <1.834447, -6.861081, -0.378876>, <1.842899, -7.137866, -0.378876>, 
      <2.179159, -6.219191, -0.505333>, <2.203968, -6.494967, -0.509089>, <2.191215, -6.865227, -0.505333>, <2.199667, -7.142013, -0.505333>, 
      <2.493424, -6.212884, -0.530129>, <2.518233, -6.488660, -0.533885>, <2.505480, -6.858920, -0.530129>, <2.513932, -7.135706, -0.530129>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.693365, -6.220254, -1.624907>, <1.728668, -6.488991, -1.568198>, <1.705479, -6.868202, -1.657400>, <1.713872, -7.143076, -1.624907>, 
      <1.515100, -6.215613, -1.261761>, <1.550403, -6.484350, -1.205052>, <1.549230, -6.930358, -1.289435>, <1.557623, -7.205231, -1.256942>, 
      <1.492229, -6.218086, -0.830661>, <1.525775, -6.491980, -0.853871>, <1.504285, -6.864122, -0.830661>, <1.512736, -7.140908, -0.830661>, 
      <1.677780, -6.216377, -0.576758>, <1.711326, -6.490271, -0.599968>, <1.689836, -6.862413, -0.576758>, <1.698287, -7.139198, -0.576758>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.277200, -6.231982, -1.797849>, <2.291291, -6.440159, -1.802537>, <2.292147, -6.692832, -2.005609>, <2.297707, -6.900751, -1.988389>, 
      <2.103492, -6.265570, -1.752251>, <2.117583, -6.473746, -1.756938>, <2.076782, -6.692033, -1.967264>, <2.082341, -6.899953, -1.950044>, 
      <1.796933, -6.222950, -1.835887>, <1.832236, -6.491688, -1.779179>, <1.814166, -6.824967, -1.913357>, <1.822559, -7.099841, -1.880864>, 
      <1.693365, -6.220254, -1.624907>, <1.728668, -6.488991, -1.568198>, <1.705479, -6.868202, -1.657400>, <1.713872, -7.143076, -1.624907>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.277200, -6.231982, -1.797849>, <2.449322, -6.198701, -1.843031>, <2.623032, -6.007808, -2.042900>, <2.821412, -6.002140, -1.921020>, 
      <2.291291, -6.440159, -1.802537>, <2.463413, -6.406878, -1.847719>, <2.642962, -6.351777, -2.030287>, <2.841343, -6.346109, -1.908407>, 
      <2.292147, -6.692832, -2.005609>, <2.475024, -6.693510, -2.038169>, <2.655888, -6.751694, -1.970678>, <2.833721, -6.802637, -1.819403>, 
      <2.297707, -6.900751, -1.988389>, <2.480583, -6.901429, -2.020949>, <2.664084, -7.096314, -1.977025>, <2.841918, -7.147258, -1.825750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.244857, -5.671466, -1.775932>, <1.161307, -6.044536, -1.740278>, <1.026384, -6.540856, -1.901555>, <1.009471, -6.924297, -1.890611>, 
      <1.153667, -5.650762, -1.986819>, <1.070117, -6.023831, -1.951165>, <0.989389, -6.537995, -1.989604>, <0.972476, -6.921436, -1.978659>, 
      <0.874748, -5.849517, -2.098274>, <0.881868, -6.161785, -2.080640>, <0.849217, -6.689317, -1.951047>, <0.831810, -7.001635, -1.945808>, 
      <0.625856, -6.010278, -2.081464>, <0.632976, -6.322546, -2.063830>, <0.732678, -6.726306, -1.938425>, <0.715271, -7.038624, -1.933186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.221327, -6.145478, -0.704376>, <1.194568, -6.421125, -0.745228>, <1.233701, -6.798622, -0.704376>, <1.231580, -7.078554, -0.704376>, 
      <1.476067, -6.004701, -1.050592>, <1.449308, -6.280348, -1.091444>, <1.450866, -6.861323, -1.115950>, <1.448745, -7.141255, -1.115950>, 
      <1.383837, -5.703020, -1.454526>, <1.300287, -6.076090, -1.418873>, <1.167710, -6.551786, -1.565203>, <1.150796, -6.935226, -1.554259>, 
      <1.244857, -5.671466, -1.775932>, <1.161307, -6.044536, -1.740278>, <1.026384, -6.540856, -1.901555>, <1.009471, -6.924297, -1.890611>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.387116, -6.145478, -0.610180>, <0.364116, -6.319002, -0.627054>, <0.339313, -6.553463, -0.610180>, <0.333857, -6.729232, -0.610180>, 
      <0.637672, -6.139189, -0.585435>, <0.614672, -6.312714, -0.602309>, <0.623843, -6.605252, -0.584242>, <0.618388, -6.781021, -0.584242>, 
      <1.038847, -6.246321, -0.456369>, <1.012088, -6.521968, -0.497221>, <1.060941, -6.748742, -0.376960>, <1.058820, -7.028674, -0.376960>, 
      <1.221327, -6.145478, -0.704376>, <1.194568, -6.421125, -0.745228>, <1.233701, -6.798622, -0.704376>, <1.231580, -7.078554, -0.704376>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.078422, -6.174164, -0.817248>, <0.070972, -6.377083, -0.847500>, <-0.005039, -6.647895, -0.817248>, <-0.006594, -6.853187, -0.817248>, 
      <0.168009, -6.170753, -0.704709>, <0.160559, -6.373672, -0.734961>, <0.093564, -6.610952, -0.695380>, <0.092009, -6.816243, -0.695380>, 
      <0.275847, -6.148271, -0.621169>, <0.252847, -6.321795, -0.638043>, <0.216635, -6.531134, -0.621363>, <0.211180, -6.706902, -0.621363>, 
      <0.387116, -6.145478, -0.610180>, <0.364116, -6.319002, -0.627054>, <0.339313, -6.553463, -0.610180>, <0.333857, -6.729232, -0.610180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.151483, -6.165984, -1.286767>, <-0.149141, -6.400469, -1.295643>, <-0.241039, -6.708406, -1.312653>, <-0.236722, -6.943014, -1.315385>, 
      <-0.164031, -6.118560, -1.091033>, <-0.161690, -6.353045, -1.099909>, <-0.275445, -6.639070, -1.112506>, <-0.271127, -6.873678, -1.115238>, 
      <-0.047218, -6.178948, -0.975077>, <-0.054668, -6.381867, -1.005329>, <-0.136418, -6.697120, -0.979626>, <-0.137973, -6.902412, -0.979626>, 
      <0.078422, -6.174164, -0.817248>, <0.070972, -6.377083, -0.847500>, <-0.005039, -6.647895, -0.817248>, <-0.006594, -6.853187, -0.817248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.135077, -6.388280, -1.700977>, <0.144023, -6.629751, -1.671734>, <0.163482, -6.949874, -1.794687>, <0.162142, -7.193234, -1.798838>, 
      <0.020701, -6.411190, -1.584047>, <0.029647, -6.652661, -1.554804>, <-0.005748, -6.932878, -1.684864>, <-0.007088, -7.176238, -1.689015>, 
      <-0.138270, -6.215920, -1.492870>, <-0.135928, -6.450405, -1.501745>, <-0.199282, -6.792558, -1.555573>, <-0.194964, -7.027167, -1.558304>, 
      <-0.151483, -6.165984, -1.286767>, <-0.149141, -6.400469, -1.295643>, <-0.241039, -6.708406, -1.312653>, <-0.236722, -6.943014, -1.315385>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.135077, -6.388280, -1.700977>, <0.286109, -6.358028, -1.855382>, <0.390549, -6.162265, -2.065571>, <0.625856, -6.010278, -2.081464>, 
      <0.144023, -6.629751, -1.671734>, <0.295055, -6.599498, -1.826138>, <0.397668, -6.474533, -2.047937>, <0.632976, -6.322546, -2.063830>, 
      <0.163482, -6.949874, -1.794687>, <0.311392, -6.964728, -1.890674>, <0.516852, -6.794808, -1.915049>, <0.732678, -6.726306, -1.938425>, 
      <0.162142, -7.193234, -1.798838>, <0.310052, -7.208089, -1.894825>, <0.499445, -7.107126, -1.909810>, <0.715271, -7.038624, -1.933186>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.434653, -4.986687, -0.394350>, <1.197308, -5.075784, -0.829384>, <1.435128, -5.011920, -1.568942>, <1.435331, -5.022733, -2.072339>, 
      <1.507591, -5.355594, -0.449072>, <1.270246, -5.444691, -0.884106>, <1.512538, -5.371176, -1.434713>, <1.512741, -5.381990, -1.938109>, 
      <1.631745, -5.840514, -0.544907>, <1.446194, -5.842223, -0.798809>, <1.465222, -5.835919, -1.341883>, <1.643486, -5.840560, -1.705029>, 
      <1.677780, -6.216377, -0.576758>, <1.492229, -6.218086, -0.830661>, <1.515100, -6.215613, -1.261761>, <1.693365, -6.220254, -1.624907>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.434653, -4.986687, -0.394350>, <1.402184, -5.346936, -0.446925>, <1.256266, -5.785572, -0.651036>, <1.221327, -6.145478, -0.704376>, 
      <1.197308, -5.075784, -0.829384>, <1.164839, -5.436033, -0.881958>, <1.511006, -5.644796, -0.997252>, <1.476067, -6.004701, -1.050592>, 
      <1.435128, -5.011920, -1.568942>, <1.377985, -5.206539, -1.480020>, <1.432028, -5.487837, -1.475091>, <1.383837, -5.703020, -1.454526>, 
      <1.435331, -5.022733, -2.072339>, <1.378189, -5.217353, -1.983417>, <1.293048, -5.456282, -1.796497>, <1.244857, -5.671466, -1.775932>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.980521, -4.467476, -1.450166>, <3.007330, -4.990825, -1.414777>, <3.059321, -5.685082, -1.331454>, <3.083626, -6.208943, -1.302400>, 
      <2.968355, -4.467665, -1.616854>, <2.995164, -4.991014, -1.581466>, <3.065941, -5.644130, -1.599580>, <3.090246, -6.167991, -1.570526>, 
      <2.817657, -4.407624, -1.845052>, <2.806692, -4.866918, -1.835838>, <3.025953, -5.537096, -1.795846>, <3.052516, -5.995537, -1.779035>, 
      <2.687155, -4.476314, -1.923690>, <2.676190, -4.935608, -1.914476>, <2.794849, -5.543699, -1.937830>, <2.821412, -6.002140, -1.921020>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.980521, -4.467476, -1.450166>, <2.998796, -4.467191, -1.199765>, <2.924850, -4.426064, -0.837360>, <2.781032, -4.474852, -0.637433>, 
      <3.007330, -4.990825, -1.414777>, <3.025606, -4.990540, -1.164376>, <2.911043, -4.941089, -0.862644>, <2.767224, -4.989877, -0.662718>, 
      <3.059321, -5.685082, -1.331454>, <3.052709, -5.725986, -1.063640>, <2.912473, -5.677422, -0.826626>, <2.784560, -5.678276, -0.659253>, 
      <3.083626, -6.208943, -1.302400>, <3.077014, -6.249847, -1.034586>, <2.918304, -6.193192, -0.831918>, <2.790391, -6.194046, -0.664546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.294825, -4.700087, -0.496958>, <2.365540, -5.152283, -0.508666>, <2.452406, -5.756926, -0.523919>, <2.493424, -6.212884, -0.530129>, 
      <2.447998, -4.641857, -0.524613>, <2.518713, -5.094053, -0.536321>, <2.578005, -5.754405, -0.533829>, <2.619023, -6.210363, -0.540039>, 
      <2.685837, -4.507146, -0.505099>, <2.672029, -5.022170, -0.530383>, <2.725081, -5.678673, -0.581425>, <2.730912, -6.194443, -0.586718>, 
      <2.781032, -4.474852, -0.637433>, <2.767224, -4.989877, -0.662718>, <2.784560, -5.678276, -0.659253>, <2.790391, -6.194046, -0.664546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.294825, -4.700087, -0.496958>, <2.365540, -5.152283, -0.508666>, <2.452406, -5.756926, -0.523919>, <2.493424, -6.212884, -0.530129>, 
      <2.042523, -4.796002, -0.451406>, <2.113238, -5.248197, -0.463114>, <2.138141, -5.763233, -0.499123>, <2.179159, -6.219191, -0.505333>, 
      <1.708028, -4.989034, -0.408181>, <1.780966, -5.357941, -0.462904>, <1.776357, -5.839182, -0.347025>, <1.822391, -6.215044, -0.378876>, 
      <1.434653, -4.986687, -0.394350>, <1.507591, -5.355594, -0.449072>, <1.631745, -5.840514, -0.544907>, <1.677780, -6.216377, -0.576758>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.294825, -4.700087, -0.496958>, <1.962852, -4.810697, -0.457358>, <1.563686, -4.938250, -0.157844>, <1.434653, -4.986687, -0.394350>, 
      <2.365540, -5.152283, -0.508666>, <2.033567, -5.262893, -0.469066>, <1.636624, -5.307156, -0.212566>, <1.507591, -5.355594, -0.449072>, 
      <2.452406, -5.756926, -0.523919>, <2.138141, -5.763233, -0.499123>, <1.776357, -5.839182, -0.347025>, <1.631745, -5.840514, -0.544907>, 
      <2.493424, -6.212884, -0.530129>, <2.179159, -6.219191, -0.505333>, <1.822391, -6.215044, -0.378876>, <1.677780, -6.216377, -0.576758>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.162156, -4.898223, -1.943295>, <2.319656, -4.771650, -1.937413>, <2.529316, -4.559393, -2.018800>, <2.687155, -4.476314, -1.923690>, 
      <2.170666, -5.300520, -1.907495>, <2.328165, -5.173948, -1.901613>, <2.518351, -5.018687, -2.009586>, <2.676190, -4.935608, -1.914476>, 
      <2.249924, -5.829030, -1.788775>, <2.422046, -5.795749, -1.833957>, <2.596468, -5.549367, -2.059711>, <2.794849, -5.543699, -1.937830>, 
      <2.277200, -6.231982, -1.797849>, <2.449322, -6.198701, -1.843031>, <2.623032, -6.007808, -2.042900>, <2.821412, -6.002140, -1.921020>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.162156, -4.898223, -1.943295>, <2.170666, -5.300520, -1.907495>, <2.249924, -5.829030, -1.788775>, <2.277200, -6.231982, -1.797849>, 
      <1.944109, -4.935576, -1.982008>, <1.952618, -5.337874, -1.946208>, <2.076216, -5.862617, -1.743177>, <2.103492, -6.265570, -1.752251>, 
      <1.653379, -4.985380, -2.033626>, <1.730789, -5.344636, -1.899396>, <1.747054, -5.843256, -1.916010>, <1.796933, -6.222950, -1.835887>, 
      <1.435331, -5.022733, -2.072339>, <1.512741, -5.381990, -1.938109>, <1.643486, -5.840560, -1.705029>, <1.693365, -6.220254, -1.624907>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.665253, -4.844792, -2.057074>, <0.889782, -4.920776, -2.049615>, <1.204308, -4.969351, -2.067760>, <1.435331, -5.022733, -2.072339>, 
      <0.682040, -5.194224, -2.049249>, <0.906569, -5.270208, -2.041791>, <1.147165, -5.163970, -1.978837>, <1.378189, -5.217353, -1.983417>, 
      <0.617893, -5.661003, -2.101188>, <0.866785, -5.500242, -2.117998>, <1.201858, -5.435578, -2.007383>, <1.293048, -5.456282, -1.796497>, 
      <0.625856, -6.010278, -2.081464>, <0.874748, -5.849517, -2.098274>, <1.153667, -5.650762, -1.986819>, <1.244857, -5.671466, -1.775932>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.604733, -4.685581, -0.411450>, <0.492029, -5.116056, -0.451735>, <0.445553, -5.704592, -0.567307>, <0.387116, -6.145478, -0.610180>, 
      <0.863953, -4.736402, -0.391518>, <0.751249, -5.166877, -0.431803>, <0.696110, -5.698303, -0.542562>, <0.637672, -6.139189, -0.585435>, 
      <1.170095, -4.984416, -0.380965>, <1.137626, -5.344666, -0.433540>, <1.073786, -5.886416, -0.403029>, <1.038847, -6.246321, -0.456369>, 
      <1.434653, -4.986687, -0.394350>, <1.402184, -5.346936, -0.446925>, <1.256266, -5.785572, -0.651036>, <1.221327, -6.145478, -0.704376>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.071744, -4.719483, -0.499145>, <0.061626, -5.158377, -0.581785>, <0.094633, -5.732617, -0.751420>, <0.078422, -6.174164, -0.817248>, 
      <0.188825, -4.744196, -0.389401>, <0.178707, -5.183091, -0.472041>, <0.184220, -5.729206, -0.638881>, <0.168009, -6.170753, -0.704709>, 
      <0.445852, -4.654432, -0.423667>, <0.333148, -5.084906, -0.463951>, <0.334285, -5.707384, -0.578296>, <0.275847, -6.148271, -0.621169>, 
      <0.604733, -4.685581, -0.411450>, <0.492029, -5.116056, -0.451735>, <0.445553, -5.704592, -0.567307>, <0.387116, -6.145478, -0.610180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.261092, -4.502822, -1.223019>, <-0.235534, -5.002345, -1.237883>, <-0.156477, -5.665970, -1.267840>, <-0.151483, -6.165984, -1.286767>, 
      <-0.259996, -4.527283, -0.976534>, <-0.234438, -5.026806, -0.991398>, <-0.169025, -5.618546, -1.072107>, <-0.164031, -6.118560, -1.091033>, 
      <-0.106870, -4.681781, -0.666566>, <-0.116988, -5.120675, -0.749207>, <-0.031007, -5.737400, -0.909249>, <-0.047218, -6.178948, -0.975077>, 
      <0.071744, -4.719483, -0.499145>, <0.061626, -5.158377, -0.581785>, <0.094633, -5.732617, -0.751420>, <0.078422, -6.174164, -0.817248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.064544, -4.558839, -2.117875>, <0.131282, -5.113328, -2.044430>, <0.114374, -5.829444, -1.768655>, <0.135077, -6.388280, -1.700977>, 
      <-0.140549, -4.483127, -1.933215>, <-0.073811, -5.037616, -1.859770>, <-0.000002, -5.852354, -1.651725>, <0.020701, -6.411190, -1.584047>, 
      <-0.262359, -4.474561, -1.507790>, <-0.236801, -4.974084, -1.522655>, <-0.143264, -5.715906, -1.473943>, <-0.138270, -6.215920, -1.492870>, 
      <-0.261092, -4.502822, -1.223019>, <-0.235534, -5.002345, -1.237883>, <-0.156477, -5.665970, -1.267840>, <-0.151483, -6.165984, -1.286767>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.064544, -4.558839, -2.117875>, <0.208181, -4.611864, -2.247202>, <0.475502, -4.780578, -2.063377>, <0.665253, -4.844792, -2.057074>, 
      <0.131282, -5.113328, -2.044430>, <0.274919, -5.166353, -2.173757>, <0.492289, -5.130009, -2.055553>, <0.682040, -5.194224, -2.049249>, 
      <0.114374, -5.829444, -1.768655>, <0.265406, -5.799191, -1.923059>, <0.382585, -5.812990, -2.085295>, <0.617893, -5.661003, -2.101188>, 
      <0.135077, -6.388280, -1.700977>, <0.286109, -6.358028, -1.855382>, <0.390549, -6.162265, -2.065571>, <0.625856, -6.010278, -2.081464>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.128040, -4.021889, -0.411991>, <0.111151, -4.231167, -0.438137>, <0.076536, -4.511610, -0.460004>, <0.071744, -4.719483, -0.499145>, 
      <0.330807, -4.021585, -0.275336>, <0.313918, -4.230863, -0.301482>, <0.193617, -4.536324, -0.350260>, <0.188825, -4.744196, -0.389401>, 
      <0.698606, -4.022031, -0.414807>, <0.597095, -4.221139, -0.414807>, <0.502227, -4.439109, -0.403516>, <0.445852, -4.654432, -0.423667>, 
      <0.943101, -4.021889, -0.411450>, <0.841591, -4.220997, -0.411450>, <0.661108, -4.470258, -0.391300>, <0.604733, -4.685581, -0.411450>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.261092, -4.023697, -1.223019>, <-0.261092, -4.167434, -1.223019>, <-0.268433, -4.359336, -1.218749>, <-0.261092, -4.502822, -1.223019>, 
      <-0.215055, -4.023097, -0.957110>, <-0.215055, -4.166834, -0.957110>, <-0.267337, -4.383797, -0.972264>, <-0.259996, -4.527283, -0.976534>, 
      <-0.095746, -4.022225, -0.562812>, <-0.112635, -4.231504, -0.588959>, <-0.102078, -4.473908, -0.627426>, <-0.106870, -4.681781, -0.666566>, 
      <0.128040, -4.021889, -0.411991>, <0.111151, -4.231167, -0.438137>, <0.076536, -4.511610, -0.460004>, <0.071744, -4.719483, -0.499145>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.149307, -4.025502, -2.013939>, <-0.085152, -4.185503, -2.045120>, <0.043789, -4.386397, -2.140716>, <0.064544, -4.558839, -2.117875>, 
      <-0.307285, -4.025142, -1.833751>, <-0.243130, -4.185142, -1.864932>, <-0.161304, -4.310685, -1.956056>, <-0.140549, -4.483127, -1.933215>, 
      <-0.301972, -4.024230, -1.459141>, <-0.301972, -4.167967, -1.459141>, <-0.269700, -4.331074, -1.503521>, <-0.262359, -4.474561, -1.507790>, 
      <-0.261092, -4.023697, -1.223019>, <-0.261092, -4.167434, -1.223019>, <-0.268433, -4.359336, -1.218749>, <-0.261092, -4.502822, -1.223019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.530506, -4.025502, -2.125908>, <0.570930, -4.271289, -2.105258>, <0.653262, -4.595199, -2.062663>, <0.665253, -4.844792, -2.057074>, 
      <0.324041, -4.019871, -2.118034>, <0.364465, -4.265658, -2.097384>, <0.463512, -4.530984, -2.068966>, <0.475502, -4.780578, -2.063377>, 
      <-0.013047, -4.025813, -2.169356>, <0.051109, -4.185814, -2.200537>, <0.187426, -4.439422, -2.270042>, <0.208181, -4.611864, -2.247202>, 
      <-0.149307, -4.025502, -2.013939>, <-0.085152, -4.185503, -2.045120>, <0.043789, -4.386397, -2.140716>, <0.064544, -4.558839, -2.117875>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.530506, -4.025502, -2.125908>, <0.786494, -4.032484, -2.135670>, <1.126573, -4.054736, -2.088410>, <1.382031, -4.067265, -2.072339>, 
      <0.570930, -4.271289, -2.105258>, <0.826918, -4.278271, -2.115020>, <1.142564, -4.341377, -2.088410>, <1.398021, -4.353906, -2.072339>, 
      <0.653262, -4.595199, -2.062663>, <0.877791, -4.671183, -2.055204>, <1.188317, -4.682710, -2.067760>, <1.419341, -4.736092, -2.072339>, 
      <0.665253, -4.844792, -2.057074>, <0.889782, -4.920776, -2.049615>, <1.204308, -4.969351, -2.067760>, <1.435331, -5.022733, -2.072339>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.230529, -4.025502, -1.994201>, <2.210017, -4.287318, -1.978929>, <2.156615, -4.636254, -1.966607>, <2.162156, -4.898223, -1.943295>, 
      <1.975423, -4.032978, -2.013357>, <1.954911, -4.294794, -1.998085>, <1.938568, -4.673607, -2.005321>, <1.944109, -4.935576, -1.982008>, 
      <1.636581, -4.054736, -2.048898>, <1.652570, -4.341377, -2.048898>, <1.637388, -4.698740, -2.033626>, <1.653379, -4.985380, -2.033626>, 
      <1.382031, -4.067265, -2.072339>, <1.398021, -4.353906, -2.072339>, <1.419341, -4.736092, -2.072339>, <1.435331, -5.022733, -2.072339>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.868643, -4.023697, -1.960711>, <2.814197, -4.159482, -1.949605>, <2.690656, -4.329670, -1.926632>, <2.687155, -4.476314, -1.923690>, 
      <2.714109, -4.024073, -2.074145>, <2.659662, -4.159858, -2.063039>, <2.532816, -4.412749, -2.021742>, <2.529316, -4.559393, -2.018800>, 
      <2.421608, -4.019902, -1.979853>, <2.401096, -4.281718, -1.964581>, <2.314115, -4.509682, -1.960726>, <2.319656, -4.771650, -1.937413>, 
      <2.230529, -4.025502, -1.994201>, <2.210017, -4.287318, -1.978929>, <2.156615, -4.636254, -1.966607>, <2.162156, -4.898223, -1.943295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.971684, -4.023697, -1.450166>, <2.974335, -4.156831, -1.450166>, <2.973724, -4.334792, -1.459138>, <2.980521, -4.467476, -1.450166>, 
      <2.973919, -4.023697, -1.606402>, <2.976570, -4.156831, -1.606402>, <2.961558, -4.334982, -1.625826>, <2.968355, -4.467665, -1.616854>, 
      <2.994603, -4.023390, -1.868252>, <2.940156, -4.159175, -1.857146>, <2.821158, -4.260980, -1.847994>, <2.817657, -4.407624, -1.845052>, 
      <2.868643, -4.023697, -1.960711>, <2.814197, -4.159482, -1.949605>, <2.690656, -4.329670, -1.926632>, <2.687155, -4.476314, -1.923690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.848578, -4.023697, -0.557995>, <2.828314, -4.159043, -0.581826>, <2.784750, -4.336154, -0.630624>, <2.781032, -4.474852, -0.637433>, 
      <3.022410, -4.024080, -0.764836>, <3.002147, -4.159426, -0.788668>, <2.928569, -4.287366, -0.830550>, <2.924850, -4.426064, -0.837360>, 
      <2.967819, -4.023697, -1.180006>, <2.970471, -4.156831, -1.180006>, <2.992000, -4.334508, -1.208737>, <2.998796, -4.467191, -1.199765>, 
      <2.971684, -4.023697, -1.450166>, <2.974335, -4.156831, -1.450166>, <2.973724, -4.334792, -1.459138>, <2.980521, -4.467476, -1.450166>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.150794, -4.021889, -0.473399>, <2.194003, -4.225348, -0.480467>, <2.262681, -4.494536, -0.491636>, <2.294825, -4.700087, -0.496958>, 
      <2.360306, -4.022262, -0.497278>, <2.403515, -4.225721, -0.504346>, <2.415854, -4.436306, -0.519291>, <2.447998, -4.641857, -0.524613>, 
      <2.712910, -4.023398, -0.396565>, <2.692646, -4.158745, -0.420396>, <2.689555, -4.368448, -0.498289>, <2.685837, -4.507146, -0.505099>, 
      <2.848578, -4.023697, -0.557995>, <2.828314, -4.159043, -0.581826>, <2.784750, -4.336154, -0.630624>, <2.781032, -4.474852, -0.637433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.412791, -4.021142, -0.394350>, <1.419350, -4.310805, -0.394350>, <1.460391, -4.701120, -0.352674>, <1.434653, -4.986687, -0.394350>, 
      <1.635166, -4.021142, -0.405757>, <1.641725, -4.310805, -0.405757>, <1.733766, -4.703466, -0.366505>, <1.708028, -4.989034, -0.408181>, 
      <1.929559, -4.021495, -0.448184>, <1.972769, -4.224955, -0.455251>, <2.010379, -4.590451, -0.446084>, <2.042523, -4.796002, -0.451406>, 
      <2.150794, -4.021889, -0.473399>, <2.194003, -4.225348, -0.480467>, <2.262681, -4.494536, -0.491636>, <2.294825, -4.700087, -0.496958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.412791, -4.021142, -0.394350>, <1.419350, -4.310805, -0.394350>, <1.460391, -4.701120, -0.352674>, <1.434653, -4.986687, -0.394350>, 
      <1.635166, -4.021142, -0.405757>, <1.641725, -4.310805, -0.405757>, <1.589424, -4.652682, -0.116168>, <1.563686, -4.938250, -0.157844>, 
      <1.929559, -4.021495, -0.448184>, <1.972769, -4.224955, -0.455251>, <1.930708, -4.605146, -0.452035>, <1.962852, -4.810697, -0.457358>, 
      <2.150794, -4.021889, -0.473399>, <2.194003, -4.225348, -0.480467>, <2.262681, -4.494536, -0.491636>, <2.294825, -4.700087, -0.496958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.412791, -4.021142, -0.394350>, <1.271976, -4.021142, -0.387127>, <1.084088, -4.021807, -0.409514>, <0.943101, -4.021889, -0.411450>, 
      <1.419350, -4.310805, -0.394350>, <1.278534, -4.310805, -0.387127>, <0.982578, -4.220915, -0.409514>, <0.841591, -4.220997, -0.411450>, 
      <1.460391, -4.701120, -0.352674>, <1.195833, -4.698849, -0.339289>, <0.920328, -4.521080, -0.371368>, <0.661108, -4.470258, -0.391300>, 
      <1.434653, -4.986687, -0.394350>, <1.170095, -4.984416, -0.380965>, <0.863953, -4.736402, -0.391518>, <0.604733, -4.685581, -0.411450>
    }
  }
  texture {
    Graypants
    scale 2.0
    translate <0.877397, -6.213281, -0.671431>
  }
  scale <0.9, 1.0, 1.0>
  translate  <0.36476, 0.103676, 0.313818>
}
#declare ManCape = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.482424, -8.085010, -1.300651>, <-1.506527, -9.406998, -1.300651>, <-1.452942, -11.170018, -1.300651>, <-1.440307, -12.492164, -1.300651>, 
      <-1.329659, -8.174074, -1.659515>, <-1.353762, -9.496062, -1.659515>, <-1.304886, -11.126415, -1.735636>, <-1.292251, -12.448562, -1.735636>, 
      <-1.084345, -8.314570, -2.113200>, <-1.087538, -9.479656, -2.178518>, <-1.067451, -11.188930, -2.220057>, <-1.064257, -12.353090, -2.300199>, 
      <-0.913739, -8.412954, -2.461435>, <-0.916933, -9.578039, -2.526753>, <-0.906287, -11.129327, -2.648434>, <-0.903093, -12.293486, -2.728577>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.524426, -8.056914, -1.026852>, <-1.506102, -9.378993, -1.026852>, <-1.494944, -11.141919, -1.026852>, <-1.482309, -12.464065, -1.026852>, 
      <-1.527057, -8.060722, -1.110251>, <-1.508732, -9.382800, -1.110251>, <-1.497575, -11.145727, -1.110251>, <-1.484940, -12.467873, -1.110251>, 
      <-1.514319, -8.066416, -1.225726>, <-1.538422, -9.388403, -1.225726>, <-1.479736, -11.177908, -1.221932>, <-1.467100, -12.500054, -1.221932>, 
      <-1.482424, -8.085010, -1.300651>, <-1.506527, -9.406998, -1.300651>, <-1.452942, -11.170018, -1.300651>, <-1.440307, -12.492164, -1.300651>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.464741, -8.059416, -0.740031>, <-1.398832, -9.379978, -0.740031>, <-1.435259, -11.144421, -0.740031>, <-1.422624, -12.466566, -0.740031>, 
      <-1.513105, -8.058549, -0.813416>, <-1.447195, -9.379110, -0.813416>, <-1.483623, -11.143554, -0.813416>, <-1.470988, -12.465699, -0.813416>, 
      <-1.521658, -8.052908, -0.939094>, <-1.503334, -9.374986, -0.939094>, <-1.492176, -11.137913, -0.939094>, <-1.479541, -12.460058, -0.939094>, 
      <-1.524426, -8.056914, -1.026852>, <-1.506102, -9.378993, -1.026852>, <-1.494944, -11.141919, -1.026852>, <-1.482309, -12.464065, -1.026852>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.183532, -8.063026, -0.509595>, <-1.160807, -9.382913, -0.584483>, <-1.154050, -11.148030, -0.509595>, <-1.141415, -12.470176, -0.509595>, 
      <-1.241251, -8.056205, -0.601895>, <-1.218526, -9.376092, -0.676783>, <-1.251879, -11.148122, -0.557832>, <-1.239244, -12.470268, -0.557832>, 
      <-1.404722, -8.060491, -0.648961>, <-1.338812, -9.381053, -0.648961>, <-1.375240, -11.145496, -0.648961>, <-1.362605, -12.467642, -0.648961>, 
      <-1.464741, -8.059416, -0.740031>, <-1.398832, -9.379978, -0.740031>, <-1.435259, -11.144421, -0.740031>, <-1.422624, -12.466566, -0.740031>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682967, -8.151801, 0.510141>, <-0.650858, -9.447193, 0.258433>, <-0.653485, -11.171622, -0.095146>, <-0.640850, -12.465831, -0.354555>, 
      <-0.932377, -8.146374, 0.276446>, <-0.900268, -9.441766, 0.024738>, <-0.805899, -11.179624, -0.132856>, <-0.793264, -12.473833, -0.392265>, 
      <-1.002648, -8.084401, -0.220334>, <-0.979923, -9.404288, -0.295222>, <-1.013046, -11.147898, -0.440069>, <-1.000411, -12.470043, -0.440069>, 
      <-1.183532, -8.063026, -0.509595>, <-1.160807, -9.382913, -0.584483>, <-1.154050, -11.148030, -0.509595>, <-1.141415, -12.470176, -0.509595>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.070424, -8.090306, 0.665351>, <0.077893, -9.385008, 0.408213>, <0.099906, -11.110126, 0.060064>, <0.112541, -12.404335, -0.199345>, 
      <-0.155798, -8.117227, 0.624229>, <-0.148329, -9.411930, 0.367091>, <-0.126316, -11.137049, 0.018942>, <-0.113681, -12.431258, -0.240467>, 
      <-0.514057, -8.155476, 0.668408>, <-0.481949, -9.450868, 0.416700>, <-0.429052, -11.159837, -0.039618>, <-0.416417, -12.454046, -0.299027>, 
      <-0.682967, -8.151801, 0.510141>, <-0.650858, -9.447193, 0.258433>, <-0.653485, -11.171622, -0.095146>, <-0.640850, -12.465831, -0.354555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.445193, -8.017541, 0.715215>, <0.452682, -9.315766, 0.476498>, <0.474675, -11.037361, 0.109928>, <0.487310, -12.331570, -0.149481>, 
      <0.331728, -8.032850, 0.699973>, <0.339217, -9.331074, 0.461256>, <0.361210, -11.052670, 0.094686>, <0.373845, -12.346879, -0.164723>, 
      <0.183294, -8.076873, 0.685868>, <0.190763, -9.371575, 0.428730>, <0.212776, -11.096694, 0.080581>, <0.225411, -12.390902, -0.178828>, 
      <0.070424, -8.090306, 0.665351>, <0.077893, -9.385008, 0.408213>, <0.099906, -11.110126, 0.060064>, <0.112541, -12.404335, -0.199345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.730075, -8.001304, 0.753964>, <0.739985, -9.303570, 0.538478>, <0.759557, -11.021126, 0.148677>, <0.772192, -12.315336, -0.110732>, 
      <0.644034, -8.003392, 0.746506>, <0.653944, -9.305659, 0.531020>, <0.673516, -11.023215, 0.141219>, <0.686151, -12.317425, -0.118190>, 
      <0.530058, -8.006091, 0.726615>, <0.537547, -9.304315, 0.487898>, <0.559539, -11.025911, 0.121328>, <0.572175, -12.320121, -0.138081>, 
      <0.445193, -8.017541, 0.715215>, <0.452682, -9.315766, 0.476498>, <0.474675, -11.037361, 0.109928>, <0.487310, -12.331570, -0.149481>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.036474, -8.003186, 0.766468>, <1.036795, -9.310503, 0.583841>, <1.065956, -11.023008, 0.161181>, <1.078591, -12.317218, -0.098228>, 
      <0.945925, -8.003116, 0.782733>, <0.946247, -9.310433, 0.600106>, <0.973983, -11.022942, 0.159040>, <0.986618, -12.317151, -0.100369>, 
      <0.821703, -7.999079, 0.761906>, <0.831612, -9.301346, 0.546420>, <0.851184, -11.018902, 0.156619>, <0.863819, -12.313112, -0.102790>, 
      <0.730075, -8.001304, 0.753964>, <0.739985, -9.303570, 0.538478>, <0.759557, -11.021126, 0.148677>, <0.772192, -12.315336, -0.110732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.256935, -8.001712, 0.659325>, <1.264449, -9.304174, 0.484570>, <1.305234, -11.021532, 0.129308>, <1.325933, -12.315742, -0.097842>, 
      <1.189821, -7.995318, 0.688692>, <1.197334, -9.297779, 0.513937>, <1.231352, -11.015306, 0.132314>, <1.252052, -12.309515, -0.094836>, 
      <1.108852, -8.003242, 0.753467>, <1.109173, -9.310559, 0.570840>, <1.140140, -11.023062, 0.162908>, <1.152775, -12.317272, -0.096501>, 
      <1.036474, -8.003186, 0.766468>, <1.036795, -9.310503, 0.583841>, <1.065956, -11.023008, 0.161181>, <1.078591, -12.317218, -0.098228>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.654341, -8.062054, 0.496110>, <1.669031, -9.363001, 0.359879>, <1.740275, -11.081875, 0.060181>, <1.777104, -12.376083, -0.126646>, 
      <1.530061, -8.052770, 0.533625>, <1.544751, -9.353718, 0.397394>, <1.603912, -11.071689, 0.065043>, <1.640741, -12.365897, -0.121784>, 
      <1.375719, -8.013029, 0.607349>, <1.383232, -9.315490, 0.432594>, <1.441468, -11.033012, 0.123766>, <1.462168, -12.327222, -0.103385>, 
      <1.256935, -8.001712, 0.659325>, <1.264449, -9.304174, 0.484570>, <1.305234, -11.021532, 0.129308>, <1.325933, -12.315742, -0.097842>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.064796, -8.062054, 0.415463>, <1.942629, -8.060340, 0.444104>, <1.774172, -8.071004, 0.459938>, <1.654341, -8.062054, 0.496110>, 
      <2.069898, -9.361132, 0.296169>, <1.947731, -9.359417, 0.324810>, <1.788862, -9.371951, 0.323707>, <1.669031, -9.363001, 0.359879>, 
      <2.113095, -11.081878, 0.035986>, <2.006221, -11.080244, 0.041069>, <1.846918, -11.089841, 0.056378>, <1.740275, -11.081875, 0.060181>, 
      <2.133795, -12.376087, -0.126647>, <2.026921, -12.374454, -0.121564>, <1.883747, -12.384050, -0.130448>, <1.777104, -12.376083, -0.126646>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.640730, -8.075901, 0.264858>, <2.467386, -8.063818, 0.306303>, <2.238702, -8.064496, 0.374692>, <2.064796, -8.062054, 0.415463>, 
      <2.650589, -9.371450, 0.148273>, <2.477245, -9.359366, 0.189718>, <2.243804, -9.363573, 0.255398>, <2.069898, -9.361132, 0.296169>, 
      <2.670212, -11.095722, -0.039349>, <2.506829, -11.084334, -0.017171>, <2.278163, -11.084402, 0.028135>, <2.113095, -11.081878, 0.035986>, 
      <2.682847, -12.389932, -0.169723>, <2.519464, -12.378543, -0.147545>, <2.298863, -12.378611, -0.134498>, <2.133795, -12.376087, -0.126647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.105264, -8.134582, 0.166698>, <2.966750, -8.117422, 0.200131>, <2.779997, -8.085609, 0.231561>, <2.640730, -8.075901, 0.264858>, 
      <3.105582, -9.431837, 0.069066>, <2.967068, -9.414678, 0.102499>, <2.789856, -9.381157, 0.114976>, <2.650589, -9.371450, 0.148273>, 
      <3.153563, -11.154402, -0.137509>, <3.005100, -11.135509, -0.114860>, <2.819844, -11.106153, -0.059660>, <2.670212, -11.095722, -0.039349>, 
      <3.174263, -12.448612, -0.267883>, <3.025800, -12.429718, -0.245234>, <2.832479, -12.400362, -0.190035>, <2.682847, -12.389932, -0.169723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.653955, -8.201425, 0.020297>, <3.502138, -8.204744, 0.100092>, <3.270821, -8.155092, 0.126738>, <3.105264, -8.134582, 0.166698>, 
      <3.654273, -9.497574, -0.053390>, <3.502456, -9.500894, 0.026405>, <3.271140, -9.452348, 0.029105>, <3.105582, -9.431837, 0.069066>, 
      <3.664620, -11.221246, -0.218048>, <3.516418, -11.213009, -0.192307>, <3.301321, -11.173206, -0.160050>, <3.153563, -11.154402, -0.137509>, 
      <3.669190, -12.515455, -0.320196>, <3.520988, -12.507218, -0.294455>, <3.322021, -12.467416, -0.290424>, <3.174263, -12.448612, -0.267883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.326930, -8.107867, -0.475408>, <4.209878, -8.133575, -0.253369>, <3.877258, -8.196542, -0.097071>, <3.653955, -8.201425, 0.020297>, 
      <4.240979, -9.427069, -0.498830>, <4.123927, -9.452777, -0.276791>, <3.877576, -9.492691, -0.170758>, <3.654273, -9.497574, -0.053390>, 
      <4.356412, -11.192873, -0.475408>, <4.209561, -11.194405, -0.318301>, <3.876188, -11.233005, -0.254796>, <3.664620, -11.221246, -0.218048>, 
      <4.369047, -12.515018, -0.475408>, <4.222196, -12.516550, -0.318301>, <3.880759, -12.527214, -0.356944>, <3.669190, -12.515455, -0.320196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.100401, -8.103369, -0.826581>, <4.132048, -8.104769, -0.705272>, <4.385093, -8.095093, -0.585740>, <4.326930, -8.107867, -0.475408>, 
      <3.924149, -9.412480, -0.884808>, <3.955796, -9.413880, -0.763499>, <4.299142, -9.414294, -0.609162>, <4.240979, -9.427069, -0.498830>, 
      <4.129884, -11.188374, -0.826581>, <4.161531, -11.189773, -0.705273>, <4.442024, -11.191980, -0.566999>, <4.356412, -11.192873, -0.475408>, 
      <4.142519, -12.510519, -0.826581>, <4.174166, -12.511918, -0.705273>, <4.454660, -12.514126, -0.566999>, <4.369047, -12.515018, -0.475408>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.160515, -8.100508, -1.113308>, <4.195429, -8.133272, -1.039602>, <4.078216, -8.102387, -0.911622>, <4.100401, -8.103369, -0.826581>, 
      <3.960416, -9.407055, -1.146799>, <3.995331, -9.439819, -1.073093>, <3.901964, -9.411499, -0.969848>, <3.924149, -9.412480, -0.884808>, 
      <4.189996, -11.185514, -1.113308>, <4.230811, -11.179578, -1.035694>, <4.107698, -11.187392, -0.911622>, <4.129884, -11.188374, -0.826581>, 
      <4.202631, -12.507659, -1.113308>, <4.243446, -12.501723, -1.035694>, <4.120334, -12.509538, -0.911622>, <4.142519, -12.510519, -0.826581>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.225466, -7.582709, -2.042664>, <3.715195, -7.724101, -1.763857>, <4.011786, -7.960937, -1.427283>, <4.160515, -8.100508, -1.113308>, 
      <3.496248, -9.071044, -2.024010>, <3.687099, -9.232361, -1.745203>, <3.811687, -9.267484, -1.460774>, <3.960416, -9.407055, -1.146799>, 
      <3.637627, -11.072656, -1.798854>, <3.792563, -11.051887, -1.624537>, <4.081266, -11.201326, -1.320070>, <4.189996, -11.185514, -1.113308>, 
      <3.686177, -12.576886, -1.694364>, <3.841113, -12.556118, -1.520047>, <4.093901, -12.523472, -1.320070>, <4.202631, -12.507659, -1.113308>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.312067, -5.458568, -1.300651>, <-1.241105, -6.244961, -1.300651>, <-1.468030, -7.295554, -1.300651>, <-1.482424, -8.085010, -1.300651>, 
      <-1.154918, -5.529924, -1.600568>, <-1.083956, -6.316317, -1.600568>, <-1.315265, -7.384617, -1.659515>, <-1.329659, -8.174074, -1.659515>, 
      <-1.013027, -5.588680, -2.039265>, <-0.979910, -6.408903, -2.169783>, <-1.082070, -7.484674, -2.066674>, <-1.084345, -8.314570, -2.113200>, 
      <-0.884867, -5.644442, -2.355814>, <-0.851750, -6.464666, -2.486332>, <-0.911464, -7.583057, -2.414909>, <-0.913739, -8.412954, -2.461435>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.581212, -5.328257, -1.026852>, <-1.489943, -6.141929, -1.026852>, <-1.535773, -7.238218, -1.026852>, <-1.524426, -8.056914, -1.026852>, 
      <-1.505962, -5.361401, -1.116483>, <-1.414693, -6.175073, -1.116483>, <-1.538404, -7.242026, -1.110251>, <-1.527057, -8.060722, -1.110251>, 
      <-1.367307, -5.433486, -1.195227>, <-1.296345, -6.219879, -1.195227>, <-1.499925, -7.276958, -1.225726>, <-1.514319, -8.066416, -1.225726>, 
      <-1.312067, -5.458568, -1.300651>, <-1.241105, -6.244961, -1.300651>, <-1.468030, -7.295554, -1.300651>, <-1.482424, -8.085010, -1.300651>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.782741, -5.251259, -0.740031>, <-1.644394, -6.086283, -0.789150>, <-1.507004, -7.212638, -0.740031>, <-1.464741, -8.059416, -0.740031>, 
      <-1.810947, -5.306476, -0.828055>, <-1.672600, -6.141500, -0.877174>, <-1.555368, -7.211771, -0.813416>, <-1.513105, -8.058549, -0.813416>, 
      <-1.647823, -5.298918, -0.947511>, <-1.556554, -6.112589, -0.947511>, <-1.533005, -7.234212, -0.939094>, <-1.521658, -8.052908, -0.939094>, 
      <-1.581212, -5.328257, -1.026852>, <-1.489943, -6.141929, -1.026852>, <-1.535773, -7.238218, -1.026852>, <-1.524426, -8.056914, -1.026852>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.274710, -4.728238, -0.070334>, <-1.158446, -5.720733, -0.213244>, <-1.200881, -7.055346, -0.452421>, <-1.183532, -8.063026, -0.509595>, 
      <-1.414208, -4.740780, -0.332242>, <-1.297944, -5.733274, -0.475152>, <-1.258600, -7.048526, -0.544722>, <-1.241251, -8.056205, -0.601895>, 
      <-1.704935, -5.098943, -0.497217>, <-1.566588, -5.933967, -0.546336>, <-1.446984, -7.213714, -0.648961>, <-1.404722, -8.060491, -0.648961>, 
      <-1.782741, -5.251259, -0.740031>, <-1.644394, -6.086283, -0.789150>, <-1.507004, -7.212638, -0.740031>, <-1.464741, -8.059416, -0.740031>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.821820, -5.164867, 1.064098>, <-0.712444, -6.070593, 1.060977>, <-0.705159, -7.256504, 0.684107>, <-0.682967, -8.151801, 0.510141>, 
      <-1.094134, -5.088924, 0.796666>, <-0.984758, -5.994650, 0.793545>, <-0.954568, -7.251078, 0.450412>, <-0.932377, -8.146374, 0.276446>, 
      <-1.091931, -4.711805, 0.272834>, <-0.975667, -5.704300, 0.129924>, <-1.019997, -7.076722, -0.163161>, <-1.002648, -8.084401, -0.220334>, 
      <-1.274710, -4.728238, -0.070334>, <-1.158446, -5.720733, -0.213244>, <-1.200881, -7.055346, -0.452421>, <-1.183532, -8.063026, -0.509595>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.070424, -5.103372, 1.250684>, <0.077334, -6.014705, 1.307428>, <0.065257, -7.194690, 0.843227>, <0.070424, -8.090306, 0.665351>, 
      <-0.200750, -5.132108, 1.223092>, <-0.193841, -6.043440, 1.279835>, <-0.160965, -7.221611, 0.802105>, <-0.155798, -8.117227, 0.624229>, 
      <-0.630027, -5.218355, 1.252452>, <-0.520652, -6.124081, 1.249331>, <-0.536249, -7.260178, 0.842373>, <-0.514057, -8.155476, 0.668408>, 
      <-0.821820, -5.164867, 1.064098>, <-0.712444, -6.070593, 1.060977>, <-0.705159, -7.256504, 0.684107>, <-0.682967, -8.151801, 0.510141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.445193, -5.030606, 1.193019>, <0.452060, -5.936299, 1.249412>, <0.440045, -7.125046, 0.879327>, <0.445193, -8.017541, 0.715215>, 
      <0.333491, -5.045990, 1.219523>, <0.340358, -5.951683, 1.275915>, <0.326580, -7.140354, 0.864085>, <0.331728, -8.032850, 0.699973>, 
      <0.185024, -5.091228, 1.262345>, <0.191933, -6.002561, 1.319089>, <0.178127, -7.181257, 0.863745>, <0.183294, -8.076873, 0.685868>, 
      <0.070424, -5.103372, 1.250684>, <0.077334, -6.014705, 1.307428>, <0.065257, -7.194690, 0.843227>, <0.070424, -8.090306, 0.665351>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.716634, -5.014372, 1.097357>, <0.723460, -5.914594, 1.153409>, <0.723303, -7.111438, 0.901210>, <0.730075, -8.001304, 0.753964>, 
      <0.637194, -5.016177, 1.131484>, <0.644020, -5.916399, 1.187536>, <0.637262, -7.113527, 0.893752>, <0.644034, -8.003392, 0.746506>, 
      <0.528590, -5.019120, 1.173231>, <0.535457, -5.924813, 1.229624>, <0.524909, -7.113596, 0.890727>, <0.530058, -8.006091, 0.726615>, 
      <0.445193, -5.030606, 1.193019>, <0.452060, -5.936299, 1.249412>, <0.440045, -7.125046, 0.879327>, <0.445193, -8.017541, 0.715215>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.076797, -5.016253, 0.921686>, <1.083588, -5.911863, 0.977451>, <1.036256, -7.114446, 0.890621>, <1.036474, -8.003186, 0.766468>, 
      <0.964425, -5.016172, 0.964403>, <0.971215, -5.911783, 1.020168>, <0.945707, -7.114375, 0.906886>, <0.945925, -8.003116, 0.782733>, 
      <0.827067, -5.011862, 1.049916>, <0.833892, -5.912084, 1.105968>, <0.814931, -7.109214, 0.909152>, <0.821703, -7.999079, 0.761906>, 
      <0.716634, -5.014372, 1.097357>, <0.723460, -5.914594, 1.153409>, <0.723303, -7.111438, 0.901210>, <0.730075, -8.001304, 0.753964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.283816, -5.014778, 0.881748>, <1.286278, -5.912546, 0.920269>, <1.251797, -7.111110, 0.778820>, <1.256935, -8.001712, 0.659325>, 
      <1.226551, -5.009322, 0.908051>, <1.229014, -5.907090, 0.946572>, <1.184683, -7.104715, 0.808186>, <1.189821, -7.995318, 0.688692>, 
      <1.135922, -5.016296, 0.899210>, <1.142712, -5.911906, 0.954975>, <1.108634, -7.114502, 0.877620>, <1.108852, -8.003242, 0.753467>, 
      <1.076797, -5.016253, 0.921686>, <1.083588, -5.911863, 0.977451>, <1.036256, -7.114446, 0.890621>, <1.036474, -8.003186, 0.766468>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.694664, -5.075119, 0.637887>, <1.688444, -5.971907, 0.663346>, <1.644266, -7.169818, 0.589542>, <1.654341, -8.062054, 0.496110>, 
      <1.561370, -5.065325, 0.692735>, <1.555150, -5.962113, 0.718194>, <1.519986, -7.160535, 0.627057>, <1.530061, -8.052770, 0.533625>, 
      <1.414610, -5.027239, 0.821672>, <1.417072, -5.925007, 0.860193>, <1.370581, -7.122427, 0.726844>, <1.375719, -8.013029, 0.607349>, 
      <1.283816, -5.014778, 0.881748>, <1.286278, -5.912546, 0.920269>, <1.251797, -7.111110, 0.778820>, <1.256935, -8.001712, 0.659325>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.105120, -5.075123, 0.543798>, <1.980418, -5.073271, 0.563936>, <1.811222, -5.083683, 0.589926>, <1.694664, -5.075119, 0.637887>, 
      <2.105409, -5.971542, 0.575754>, <1.980708, -5.969690, 0.595892>, <1.805002, -5.980471, 0.615385>, <1.688444, -5.971907, 0.663346>, 
      <2.061288, -7.168832, 0.497487>, <1.939121, -7.167117, 0.526129>, <1.764097, -7.178768, 0.553370>, <1.644266, -7.169818, 0.589542>, 
      <2.064796, -8.062054, 0.415463>, <1.942629, -8.060340, 0.444104>, <1.774172, -8.071004, 0.459938>, <1.654341, -8.062054, 0.496110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.627289, -5.088967, 0.487281>, <2.474552, -5.078588, 0.524802>, <2.260708, -5.077433, 0.518673>, <2.105120, -5.075123, 0.543798>, 
      <2.631927, -5.987406, 0.501918>, <2.479190, -5.977028, 0.539439>, <2.260997, -5.973852, 0.550629>, <2.105409, -5.971542, 0.575754>, 
      <2.633920, -7.180973, 0.345391>, <2.460576, -7.168890, 0.386836>, <2.235194, -7.171274, 0.456716>, <2.061288, -7.168832, 0.497487>, 
      <2.640730, -8.075901, 0.264858>, <2.467386, -8.063818, 0.306303>, <2.238702, -8.064496, 0.374692>, <2.064796, -8.062054, 0.415463>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.172470, -5.147649, 0.281592>, <3.009126, -5.127936, 0.343218>, <2.797538, -5.100535, 0.445458>, <2.627289, -5.088967, 0.487281>, 
      <3.172760, -6.043884, 0.317879>, <3.009416, -6.024171, 0.379505>, <2.802176, -5.998974, 0.460094>, <2.631927, -5.987406, 0.501918>, 
      <3.105044, -7.240142, 0.234014>, <2.966530, -7.222982, 0.267447>, <2.773187, -7.190680, 0.312094>, <2.633920, -7.180973, 0.345391>, 
      <3.105264, -8.134582, 0.166698>, <2.966750, -8.117422, 0.200131>, <2.779997, -8.085609, 0.231561>, <2.640730, -8.075901, 0.264858>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.667397, -5.214492, 0.094868>, <3.518596, -5.197852, 0.151145>, <3.321184, -5.165596, 0.225485>, <3.172470, -5.147649, 0.281592>, 
      <3.691948, -6.130525, 0.115971>, <3.523222, -6.127168, 0.172248>, <3.321474, -6.061831, 0.261772>, <3.172760, -6.043884, 0.317879>, 
      <3.653735, -7.306502, 0.071174>, <3.501918, -7.309821, 0.150969>, <3.270602, -7.260653, 0.194054>, <3.105044, -7.240142, 0.234014>, 
      <3.653955, -8.201425, 0.020297>, <3.502138, -8.204744, 0.100092>, <3.270821, -8.155092, 0.126738>, <3.105264, -8.134582, 0.166698>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.836934, -5.333781, -0.347907>, <4.490096, -5.306170, -0.203097>, <4.017984, -5.253697, -0.037724>, <3.667397, -5.214492, 0.094868>, 
      <4.765178, -6.177547, -0.367461>, <4.418340, -6.149936, -0.222651>, <4.022610, -6.149804, -0.016620>, <3.691948, -6.130525, 0.115971>, 
      <4.381993, -7.262754, -0.460403>, <4.264941, -7.288462, -0.238364>, <3.877038, -7.301618, -0.046194>, <3.653735, -7.306502, 0.071174>, 
      <4.326930, -8.107867, -0.475408>, <4.209878, -8.133575, -0.253369>, <3.877258, -8.196542, -0.097071>, <3.653955, -8.201425, 0.020297>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.109361, -5.329283, -0.507174>, <5.049776, -5.335107, -0.433826>, <4.924070, -5.340717, -0.384287>, <4.836934, -5.333781, -0.347907>, 
      <4.948828, -6.205146, -0.529422>, <4.889243, -6.210970, -0.456074>, <4.852313, -6.184484, -0.403841>, <4.765178, -6.177547, -0.367461>, 
      <4.219136, -7.221459, -0.787355>, <4.250783, -7.222859, -0.666047>, <4.440156, -7.249980, -0.570735>, <4.381993, -7.262754, -0.460403>, 
      <4.100401, -8.103369, -0.826581>, <4.132048, -8.104769, -0.705272>, <4.385093, -8.095093, -0.585740>, <4.326930, -8.107867, -0.475408>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.308371, -5.287703, -0.928235>, <5.408017, -5.285832, -0.829525>, <5.197640, -5.320655, -0.615843>, <5.109361, -5.329283, -0.507174>, 
      <5.130930, -6.183097, -0.950979>, <5.230575, -6.181226, -0.852269>, <5.037106, -6.196518, -0.638090>, <4.948828, -6.205146, -0.529422>, 
      <4.298699, -7.198231, -1.090179>, <4.333613, -7.230996, -1.016474>, <4.196951, -7.220478, -0.872396>, <4.219136, -7.221459, -0.787355>, 
      <4.160515, -8.100508, -1.113308>, <4.195429, -8.133272, -1.039602>, <4.078216, -8.102387, -0.911622>, <4.100401, -8.103369, -0.826581>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.820735, -5.353473, -1.783703>, <4.267026, -5.333742, -1.527063>, <4.942390, -5.294573, -1.290781>, <5.308371, -5.287703, -0.928235>, 
      <3.498179, -5.829241, -1.823890>, <4.090588, -5.982195, -1.567250>, <4.764948, -6.189967, -1.313525>, <5.130930, -6.183097, -0.950979>, 
      <3.238004, -6.876441, -2.050988>, <3.727733, -7.051041, -1.772182>, <4.149970, -7.058660, -1.404154>, <4.298699, -7.198231, -1.090179>, 
      <3.225466, -7.582709, -2.042664>, <3.715195, -7.724101, -1.763857>, <4.011786, -7.960937, -1.427283>, <4.160515, -8.100508, -1.113308>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.996419, -2.388958, -1.300651>, <-1.907274, -3.328228, -1.300651>, <-1.396860, -4.518895, -1.300651>, <-1.312067, -5.458568, -1.300651>, 
      <-1.750564, -2.273246, -1.399755>, <-1.661420, -3.212516, -1.399755>, <-1.239711, -4.590250, -1.600568>, <-1.154918, -5.529924, -1.600568>, 
      <-1.422716, -2.044278, -1.387355>, <-1.349134, -3.195709, -1.524181>, <-1.059319, -4.442162, -1.856826>, <-1.013027, -5.588680, -2.039265>, 
      <-1.176843, -1.896558, -1.424514>, <-1.103261, -3.047989, -1.561340>, <-0.931158, -4.497925, -2.173374>, <-0.884867, -5.644442, -2.355814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.163349, -2.360860, -1.026852>, <-2.100973, -3.265901, -1.026852>, <-1.682337, -4.426723, -1.026852>, <-1.581212, -5.328257, -1.026852>, 
      <-2.123003, -2.363366, -1.114555>, <-2.060627, -3.268407, -1.114555>, <-1.607086, -4.459867, -1.116483>, <-1.505962, -5.361401, -1.116483>, 
      <-2.078506, -2.427593, -1.267561>, <-1.989362, -3.366863, -1.267561>, <-1.452100, -4.493812, -1.195227>, <-1.367307, -5.433486, -1.195227>, 
      <-1.996419, -2.388958, -1.300651>, <-1.907274, -3.328228, -1.300651>, <-1.396860, -4.518895, -1.300651>, <-1.312067, -5.458568, -1.300651>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.408461, -2.363363, -0.404970>, <-2.373496, -3.254830, -0.404970>, <-1.928320, -4.372583, -0.688344>, <-1.782741, -5.251259, -0.740031>, 
      <-2.452829, -2.371101, -0.600382>, <-2.417864, -3.262568, -0.600382>, <-1.956526, -4.427800, -0.776369>, <-1.810947, -5.306476, -0.828055>, 
      <-2.247130, -2.355656, -0.844732>, <-2.184754, -3.260697, -0.844732>, <-1.748948, -4.397384, -0.947511>, <-1.647823, -5.298918, -0.947511>, 
      <-2.163349, -2.360860, -1.026852>, <-2.100973, -3.265901, -1.026852>, <-1.682337, -4.426723, -1.026852>, <-1.581212, -5.328257, -1.026852>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.857747, -2.307564, 0.319137>, <-1.803658, -3.061556, 0.305478>, <-1.361789, -3.984884, 0.036702>, <-1.274710, -4.728238, -0.070334>, 
      <-2.059687, -2.310822, 0.134813>, <-2.005598, -3.064813, 0.121154>, <-1.501287, -3.997425, -0.225206>, <-1.414208, -4.740780, -0.332242>, 
      <-2.347965, -2.352813, -0.138522>, <-2.313000, -3.244280, -0.138522>, <-1.850514, -4.220267, -0.445530>, <-1.704935, -5.098943, -0.497217>, 
      <-2.408461, -2.363363, -0.404970>, <-2.373496, -3.254830, -0.404970>, <-1.928320, -4.372583, -0.688344>, <-1.782741, -5.251259, -0.740031>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.383977, -2.346837, 0.530144>, <-1.322205, -3.205427, 0.696955>, <-0.926941, -4.294374, 1.067098>, <-0.821820, -5.164867, 1.064098>, 
      <-1.538887, -2.328129, 0.530116>, <-1.477115, -3.186718, 0.696927>, <-1.199255, -4.218430, 0.799666>, <-1.094134, -5.088924, 0.796666>, 
      <-1.742509, -2.305705, 0.424322>, <-1.688420, -3.059697, 0.410663>, <-1.179010, -3.968451, 0.379870>, <-1.091931, -4.711805, 0.272834>, 
      <-1.857747, -2.307564, 0.319137>, <-1.803658, -3.061556, 0.305478>, <-1.361789, -3.984884, 0.036702>, <-1.274710, -4.728238, -0.070334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.028306, -2.535342, 0.319473>, <0.076818, -3.331526, 0.507809>, <0.064222, -4.285386, 1.199752>, <0.070424, -5.103372, 1.250684>, 
      <-0.401152, -2.507528, 0.358118>, <-0.352640, -3.303712, 0.546454>, <-0.206952, -4.314122, 1.172160>, <-0.200750, -5.132108, 1.223092>, 
      <-0.955005, -2.398644, 0.530220>, <-0.893232, -3.257234, 0.697031>, <-0.735149, -4.347861, 1.255452>, <-0.630027, -5.218355, 1.252452>, 
      <-1.383977, -2.346837, 0.530144>, <-1.322205, -3.205427, 0.696955>, <-0.926941, -4.294374, 1.067098>, <-0.821820, -5.164867, 1.064098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.403075, -2.462577, 0.369337>, <0.327985, -3.247812, 0.549663>, <0.439070, -4.223027, 1.142735>, <0.445193, -5.030606, 1.193019>, 
      <0.289610, -2.477886, 0.354095>, <0.214520, -3.263121, 0.534421>, <0.327368, -4.238411, 1.169239>, <0.333491, -5.045990, 1.219523>, 
      <0.143106, -2.542777, 0.309143>, <0.191618, -3.338961, 0.497479>, <0.178821, -4.273242, 1.211413>, <0.185024, -5.091228, 1.262345>, 
      <0.028306, -2.535342, 0.319473>, <0.076818, -3.331526, 0.507809>, <0.064222, -4.285386, 1.199752>, <0.070424, -5.103372, 1.250684>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.687957, -2.446342, 0.408086>, <0.684546, -3.222563, 0.592021>, <0.710597, -4.218213, 1.047784>, <0.716634, -5.014372, 1.097357>, 
      <0.601916, -2.448431, 0.400628>, <0.598504, -3.224652, 0.584563>, <0.631158, -4.220018, 1.081911>, <0.637194, -5.016177, 1.131484>, 
      <0.487940, -2.451127, 0.380737>, <0.412849, -3.236362, 0.561063>, <0.522467, -4.211541, 1.122948>, <0.528590, -5.019120, 1.173231>, 
      <0.403075, -2.462577, 0.369337>, <0.327985, -3.247812, 0.549663>, <0.439070, -4.223027, 1.142735>, <0.445193, -5.030606, 1.193019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.994355, -2.448223, 0.420590>, <0.999638, -3.218640, 0.572809>, <1.070854, -4.232465, 0.872884>, <1.076797, -5.016253, 0.921686>, 
      <0.902382, -2.448155, 0.418449>, <0.907665, -3.218572, 0.570668>, <0.958482, -4.232385, 0.915601>, <0.964425, -5.016172, 0.964403>, 
      <0.779584, -2.444118, 0.416028>, <0.776173, -3.220339, 0.599963>, <0.821030, -4.215704, 1.000343>, <0.827067, -5.011862, 1.049916>, 
      <0.687957, -2.446342, 0.408086>, <0.684546, -3.222563, 0.592021>, <0.710597, -4.218213, 1.047784>, <0.716634, -5.014372, 1.097357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.241699, -2.446749, 0.420976>, <1.240482, -3.215924, 0.566459>, <1.281671, -4.232687, 0.848190>, <1.283816, -5.014778, 0.881748>, 
      <1.168260, -2.440560, 0.429616>, <1.167043, -3.209735, 0.575099>, <1.224406, -4.227231, 0.874494>, <1.226551, -5.009322, 0.908051>, 
      <1.068540, -2.448278, 0.422317>, <1.073822, -3.218694, 0.574536>, <1.129979, -4.232508, 0.850408>, <1.135922, -5.016296, 0.899210>, 
      <0.994355, -2.448223, 0.420590>, <0.999638, -3.218640, 0.572809>, <1.070854, -4.232465, 0.872884>, <1.076797, -5.016253, 0.921686>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.692869, -2.507090, 0.338408>, <1.685176, -3.274749, 0.449053>, <1.700041, -4.299820, 0.615877>, <1.694664, -5.075119, 0.637887>, 
      <1.558501, -2.497218, 0.371708>, <1.550808, -3.264877, 0.482353>, <1.566747, -4.290026, 0.670724>, <1.561370, -5.065325, 0.692735>, 
      <1.379053, -2.458324, 0.404816>, <1.377836, -3.227500, 0.550299>, <1.412465, -4.245148, 0.788114>, <1.414610, -5.027239, 0.821672>, 
      <1.241699, -2.446749, 0.420976>, <1.240482, -3.215924, 0.566459>, <1.281671, -4.232687, 0.848190>, <1.283816, -5.014778, 0.881748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.063002, -2.507093, 0.217437>, <1.948012, -2.505361, 0.237959>, <1.805972, -2.515400, 0.310378>, <1.692869, -2.507090, 0.338408>, 
      <2.063951, -3.277856, 0.313353>, <1.948961, -3.276123, 0.333875>, <1.798279, -3.283059, 0.421024>, <1.685176, -3.274749, 0.449053>, 
      <2.104869, -4.298908, 0.516127>, <1.980168, -4.297056, 0.536265>, <1.816599, -4.308384, 0.567916>, <1.700041, -4.299820, 0.615877>, 
      <2.105120, -5.075123, 0.543798>, <1.980418, -5.073271, 0.563936>, <1.811222, -5.083683, 0.589926>, <1.694664, -5.075119, 0.637887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.612053, -2.520938, 0.174361>, <2.452652, -2.509827, 0.216590>, <2.225687, -2.509544, 0.188403>, <2.063002, -2.507093, 0.217437>, 
      <2.608667, -3.291373, 0.268069>, <2.449266, -3.280262, 0.310298>, <2.226636, -3.280307, 0.284318>, <2.063951, -3.277856, 0.313353>, 
      <2.623283, -4.312960, 0.474639>, <2.470546, -4.302581, 0.512160>, <2.260457, -4.301218, 0.491002>, <2.104869, -4.298908, 0.516127>, 
      <2.627289, -5.088967, 0.487281>, <2.474552, -5.078588, 0.524802>, <2.260708, -5.077433, 0.518673>, <2.105120, -5.075123, 0.543798>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.103468, -2.579620, -0.058210>, <2.946654, -2.560193, -0.014119>, <2.770272, -2.531967, 0.132445>, <2.612053, -2.520938, 0.174361>, 
      <3.108743, -3.351952, 0.030254>, <2.951929, -3.332525, 0.074344>, <2.766886, -3.302402, 0.226152>, <2.608667, -3.291373, 0.268069>, 
      <3.172219, -4.370886, 0.250143>, <3.008875, -4.351173, 0.311769>, <2.793532, -4.324528, 0.432816>, <2.623283, -4.312960, 0.474639>, 
      <3.172470, -5.147649, 0.281592>, <3.009126, -5.127936, 0.343218>, <2.797538, -5.100535, 0.445458>, <2.627289, -5.088967, 0.487281>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.625278, -2.646463, -0.110523>, <3.468973, -2.644014, -0.083751>, <3.255074, -2.598402, -0.100836>, <3.103468, -2.579620, -0.058210>, 
      <3.630538, -3.416540, -0.043894>, <3.474232, -3.414092, -0.017122>, <3.260349, -3.370734, -0.012373>, <3.108743, -3.351952, 0.030254>, 
      <3.663408, -4.441744, 0.076670>, <3.514606, -4.425104, 0.132946>, <3.320933, -4.388833, 0.194036>, <3.172219, -4.370886, 0.250143>, 
      <3.667397, -5.214492, 0.094868>, <3.518596, -5.197852, 0.151145>, <3.321184, -5.165596, 0.225485>, <3.172470, -5.147649, 0.281592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.794815, -2.606116, -0.347907>, <4.461113, -2.626645, -0.219287>, <3.978314, -2.651994, -0.170992>, <3.625278, -2.646463, -0.110523>, 
      <4.793557, -3.424512, -0.347907>, <4.459855, -3.445042, -0.219287>, <3.983574, -3.422071, -0.104363>, <3.630538, -3.416540, -0.043894>, 
      <4.906264, -4.518545, -0.329014>, <4.559427, -4.490934, -0.184204>, <4.013995, -4.480950, -0.055922>, <3.663408, -4.441744, 0.076670>, 
      <4.836934, -5.333781, -0.347907>, <4.490096, -5.306170, -0.203097>, <4.017984, -5.253697, -0.037724>, <3.667397, -5.214492, 0.094868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.117401, -2.554668, -0.685639>, <5.033383, -2.564475, -0.572881>, <4.926126, -2.598038, -0.398519>, <4.794815, -2.606116, -0.347907>, 
      <5.144918, -3.387707, -0.653627>, <5.060901, -3.397514, -0.540869>, <4.924868, -3.416434, -0.398519>, <4.793557, -3.424512, -0.347907>, 
      <5.259690, -4.509098, -0.486341>, <5.200105, -4.514922, -0.412993>, <4.993400, -4.525481, -0.365395>, <4.906264, -4.518545, -0.329014>, 
      <5.109361, -5.329283, -0.507174>, <5.049776, -5.335107, -0.433826>, <4.924070, -5.340717, -0.384287>, <4.836934, -5.333781, -0.347907>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.260111, -2.551807, -0.972366>, <5.280200, -2.554083, -0.878430>, <5.174674, -2.547983, -0.762502>, <5.117401, -2.554668, -0.685639>, 
      <5.325279, -3.370162, -0.962656>, <5.345368, -3.372438, -0.868720>, <5.202191, -3.381022, -0.730490>, <5.144918, -3.387707, -0.653627>, 
      <5.467918, -4.482611, -0.907785>, <5.567563, -4.480740, -0.809075>, <5.347968, -4.500470, -0.595009>, <5.259690, -4.509098, -0.486341>, 
      <5.308371, -5.287703, -0.928235>, <5.408017, -5.285832, -0.829525>, <5.197640, -5.320655, -0.615843>, <5.109361, -5.329283, -0.507174>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.893893, -2.529347, -1.730723>, <5.003758, -2.536085, -1.503216>, <5.207269, -2.545820, -1.219443>, <5.260111, -2.551807, -0.972366>, 
      <4.885637, -3.435618, -1.712833>, <4.995503, -3.442356, -1.485326>, <5.272437, -3.364176, -1.209734>, <5.325279, -3.370162, -0.962656>, 
      <4.058304, -4.480348, -1.729592>, <4.504595, -4.460616, -1.472952>, <5.101936, -4.489482, -1.270331>, <5.467918, -4.482611, -0.907785>, 
      <3.820735, -5.353473, -1.783703>, <4.267026, -5.333742, -1.527063>, <4.942390, -5.294573, -1.290781>, <5.308371, -5.287703, -0.928235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.831269, 0.011995, -1.300651>, <-1.984317, -0.693559, -1.306657>, <-2.064635, -1.670200, -1.300651>, <-1.996419, -2.388958, -1.300651>, 
      <-1.677985, 0.003391, -1.443022>, <-1.831033, -0.702164, -1.449027>, <-1.818781, -1.554488, -1.399755>, <-1.750564, -2.273246, -1.399755>, 
      <-1.422319, 0.019834, -1.567821>, <-1.546863, -0.541420, -1.480652>, <-1.459541, -1.468022, -1.318878>, <-1.422716, -2.044278, -1.387355>, 
      <-1.247054, 0.023194, -1.682322>, <-1.371598, -0.538060, -1.595154>, <-1.213668, -1.320302, -1.356037>, <-1.176843, -1.896558, -1.424514>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.952770, 0.062808, -1.026852>, <-2.133821, -0.644205, -1.022557>, <-2.213531, -1.632748, -1.026852>, <-2.163349, -2.360860, -1.026852>, 
      <-1.929427, 0.083205, -1.112567>, <-2.110478, -0.623809, -1.108272>, <-2.173185, -1.635254, -1.114555>, <-2.123003, -2.363366, -1.114555>, 
      <-1.897997, 0.015741, -1.238673>, <-2.051046, -0.689813, -1.244679>, <-2.146722, -1.708835, -1.267561>, <-2.078506, -2.427593, -1.267561>, 
      <-1.831269, 0.011995, -1.300651>, <-1.984317, -0.693559, -1.306657>, <-2.064635, -1.670200, -1.300651>, <-1.996419, -2.388958, -1.300651>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.983942, -0.121410, -0.740031>, <-2.210064, -0.769969, -0.656750>, <-2.435577, -1.672017, -0.404970>, <-2.408461, -2.363363, -0.404970>, 
      <-2.015672, -0.115004, -0.837488>, <-2.241794, -0.763562, -0.754207>, <-2.479944, -1.679754, -0.600382>, <-2.452829, -2.371101, -0.600382>, 
      <-1.979069, 0.039828, -0.930281>, <-2.160120, -0.667185, -0.925986>, <-2.297312, -1.627543, -0.844732>, <-2.247130, -2.355656, -0.844732>, 
      <-1.952770, 0.062808, -1.026852>, <-2.133821, -0.644205, -1.022557>, <-2.213531, -1.632748, -1.026852>, <-2.163349, -2.360860, -1.026852>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.613491, -0.005693, 0.015218>, <-1.752948, -0.662925, 0.213095>, <-1.907854, -1.609075, 0.331791>, <-1.857747, -2.307564, 0.319137>, 
      <-1.790954, -0.007964, -0.167523>, <-1.930410, -0.665196, 0.030355>, <-2.109795, -1.612333, 0.147467>, <-2.059687, -2.310822, 0.134813>, 
      <-1.905232, -0.137302, -0.498278>, <-2.131354, -0.785860, -0.414997>, <-2.375081, -1.661466, -0.138522>, <-2.347965, -2.352813, -0.138522>, 
      <-1.983942, -0.121410, -0.740031>, <-2.210064, -0.769969, -0.656750>, <-2.435577, -1.672017, -0.404970>, <-2.408461, -2.363363, -0.404970>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.185415, -0.111189, 0.082247>, <-1.325915, -0.752625, 0.282881>, <-1.432349, -1.674504, 0.399520>, <-1.383977, -2.346837, 0.530144>, 
      <-1.318090, -0.095308, 0.075650>, <-1.458590, -0.736744, 0.276284>, <-1.587259, -1.655795, 0.399492>, <-1.538887, -2.328129, 0.530116>, 
      <-1.520291, -0.004500, 0.111190>, <-1.659748, -0.661732, 0.309068>, <-1.792616, -1.607216, 0.436976>, <-1.742509, -2.305705, 0.424322>, 
      <-1.613491, -0.005693, 0.015218>, <-1.752948, -0.662925, 0.213095>, <-1.907854, -1.609075, 0.331791>, <-1.857747, -2.307564, 0.319137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.230092, -0.171289, 0.084007>, <-0.261197, -0.873841, 0.223432>, <-0.014129, -1.838890, 0.154728>, <0.028306, -2.535342, 0.319473>, 
      <-0.516910, -0.157201, 0.083371>, <-0.548014, -0.859753, 0.222796>, <-0.443588, -1.811076, 0.193373>, <-0.401152, -2.507528, 0.358118>, 
      <-0.900633, -0.145278, 0.096408>, <-1.041133, -0.786714, 0.297042>, <-1.003377, -1.726311, 0.399597>, <-0.955005, -2.398644, 0.530220>, 
      <-1.185415, -0.111189, 0.082247>, <-1.325915, -0.752625, 0.282881>, <-1.432349, -1.674504, 0.399520>, <-1.383977, -2.346837, 0.530144>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.905803, -0.213908, 0.086884>, <0.874308, -0.894736, 0.230039>, <0.467703, -1.786746, 0.214135>, <0.403075, -2.462577, 0.369337>, 
      <0.568085, -0.191278, 0.128381>, <0.536590, -0.872107, 0.271536>, <0.354238, -1.802054, 0.198893>, <0.289610, -2.477886, 0.354095>, 
      <0.110506, -0.188019, 0.084762>, <0.079401, -0.890571, 0.224187>, <0.100670, -1.846325, 0.144398>, <0.143106, -2.542777, 0.309143>, 
      <-0.230092, -0.171289, 0.084007>, <-0.261197, -0.873841, 0.223432>, <-0.014129, -1.838890, 0.154728>, <0.028306, -2.535342, 0.319473>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.737634, -0.236134, -0.034903>, <0.713401, -0.897328, 0.105704>, <0.690850, -1.788161, 0.252122>, <0.687957, -2.446342, 0.408086>, 
      <0.688944, -0.227643, 0.003591>, <0.664711, -0.888837, 0.144198>, <0.604809, -1.790250, 0.244664>, <0.601916, -2.448431, 0.400628>, 
      <0.967845, -0.218065, 0.079260>, <0.936350, -0.898894, 0.222415>, <0.552568, -1.775296, 0.225535>, <0.487940, -2.451127, 0.380737>, 
      <0.905803, -0.213908, 0.086884>, <0.874308, -0.894736, 0.230039>, <0.467703, -1.786746, 0.214135>, <0.403075, -2.462577, 0.369337>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.044032, -0.238015, -0.022399>, <1.026576, -0.899389, 0.118370>, <0.989805, -1.784653, 0.289482>, <0.994355, -2.448223, 0.420590>, 
      <0.952059, -0.237947, -0.024540>, <0.934603, -0.899321, 0.116229>, <0.897832, -1.784585, 0.287341>, <0.902382, -2.448155, 0.418449>, 
      <0.809136, -0.248604, -0.091432>, <0.784903, -0.909798, 0.049174>, <0.782477, -1.785937, 0.260065>, <0.779584, -2.444118, 0.416028>, 
      <0.737634, -0.236134, -0.034903>, <0.713401, -0.897328, 0.105704>, <0.690850, -1.788161, 0.252122>, <0.687957, -2.446342, 0.408086>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.291376, -0.236542, -0.022013>, <1.279486, -0.898295, 0.117546>, <1.242751, -1.782120, 0.295267>, <1.241699, -2.446749, 0.420976>, 
      <1.217494, -0.230316, -0.019007>, <1.205604, -0.892069, 0.120551>, <1.169311, -1.775931, 0.303908>, <1.168260, -2.440560, 0.429616>, 
      <1.118216, -0.238070, -0.020672>, <1.100760, -0.899443, 0.120097>, <1.063989, -1.784708, 0.291209>, <1.068540, -2.448278, 0.422317>, 
      <1.044032, -0.238015, -0.022399>, <1.026576, -0.899389, 0.118370>, <0.989805, -1.784653, 0.289482>, <0.994355, -2.448223, 0.420590>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.742546, -0.296883, -0.050817>, <1.746591, -0.959289, 0.070469>, <1.699548, -1.840581, 0.242342>, <1.692869, -2.507090, 0.338408>, 
      <1.606183, -0.286697, -0.045955>, <1.610228, -0.949103, 0.075331>, <1.565180, -1.830708, 0.275641>, <1.558501, -2.497218, 0.371708>, 
      <1.427610, -0.248023, -0.027556>, <1.415720, -0.909776, 0.112003>, <1.380104, -1.793696, 0.279107>, <1.379053, -2.458324, 0.404816>, 
      <1.291376, -0.236542, -0.022013>, <1.279486, -0.898295, 0.117546>, <1.242751, -1.782120, 0.295267>, <1.241699, -2.446749, 0.420976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.099237, -0.296885, -0.050818>, <1.992363, -0.295251, -0.045735>, <1.849189, -0.304849, -0.054619>, <1.742546, -0.296883, -0.050817>, 
      <2.113588, -0.957742, 0.045661>, <2.006714, -0.956108, 0.050743>, <1.853233, -0.967255, 0.066666>, <1.746591, -0.959289, 0.070469>, 
      <2.062186, -1.844190, 0.134944>, <1.947196, -1.842457, 0.155466>, <1.812651, -1.848891, 0.214312>, <1.699548, -1.840581, 0.242342>, 
      <2.063002, -2.507093, 0.217437>, <1.948012, -2.505361, 0.237959>, <1.805972, -2.515400, 0.310378>, <1.692869, -2.507090, 0.338408>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.648290, -0.310731, -0.093894>, <2.486704, -0.302411, -0.060184>, <2.264305, -0.299409, -0.058669>, <2.099237, -0.296885, -0.050818>, 
      <2.668370, -0.971649, 0.001133>, <2.506784, -0.963329, 0.034844>, <2.278656, -0.960266, 0.037810>, <2.113588, -0.957742, 0.045661>, 
      <2.614967, -1.857815, 0.093706>, <2.455567, -1.846704, 0.135935>, <2.224871, -1.846641, 0.105909>, <2.062186, -1.844190, 0.134944>, 
      <2.612053, -2.520938, 0.174361>, <2.452652, -2.509827, 0.216590>, <2.225687, -2.509544, 0.188403>, <2.063002, -2.507093, 0.217437>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.139705, -0.350456, -0.267883>, <2.987672, -0.334030, -0.233001>, <2.801635, -0.318626, -0.125885>, <2.648290, -0.310731, -0.093894>, 
      <3.173619, -1.017837, -0.198938>, <3.021586, -1.001411, -0.164056>, <2.821715, -0.979544, -0.030858>, <2.668370, -0.971649, 0.001133>, 
      <3.098910, -1.912210, -0.134656>, <2.942096, -1.892783, -0.090565>, <2.773186, -1.868844, 0.051789>, <2.614967, -1.857815, 0.093706>, 
      <3.103468, -2.579620, -0.058210>, <2.946654, -2.560193, -0.014119>, <2.770272, -2.531967, 0.132445>, <2.612053, -2.520938, 0.174361>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.634633, -0.417298, -0.320196>, <3.484266, -0.411441, -0.313138>, <3.285728, -0.366233, -0.301386>, <3.139705, -0.350456, -0.267883>, 
      <3.684603, -1.084072, -0.256124>, <3.534236, -1.078215, -0.249065>, <3.319642, -1.033613, -0.232441>, <3.173619, -1.017837, -0.198938>, 
      <3.620708, -1.977272, -0.168423>, <3.464402, -1.974823, -0.141651>, <3.250515, -1.930992, -0.177282>, <3.098910, -1.912210, -0.134656>, 
      <3.625278, -2.646463, -0.110523>, <3.468973, -2.644014, -0.083751>, <3.255074, -2.598402, -0.100836>, <3.103468, -2.579620, -0.058210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.844491, -0.416861, -0.347907>, <4.496364, -0.438625, -0.247202>, <3.997012, -0.431413, -0.337206>, <3.634633, -0.417298, -0.320196>, 
      <5.006775, -1.052625, -0.315564>, <4.658649, -1.074389, -0.214860>, <4.046982, -1.098188, -0.273134>, <3.684603, -1.084072, -0.256124>, 
      <4.795824, -1.949171, -0.347907>, <4.462122, -1.969701, -0.219287>, <3.973744, -1.982802, -0.228892>, <3.620708, -1.977272, -0.168423>, 
      <4.794815, -2.606116, -0.347907>, <4.461113, -2.626645, -0.219287>, <3.978314, -2.651994, -0.170992>, <3.625278, -2.646463, -0.110523>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.944402, -0.335414, -0.699080>, <4.930875, -0.332160, -0.587721>, <4.952102, -0.410133, -0.379036>, <4.844491, -0.416861, -0.347907>, 
      <5.149626, -0.969917, -0.663632>, <5.136099, -0.966663, -0.552273>, <5.114386, -1.045897, -0.346693>, <5.006775, -1.052625, -0.315564>, 
      <5.095370, -1.887716, -0.711269>, <5.011352, -1.897522, -0.598511>, <4.927136, -1.941093, -0.398519>, <4.795824, -1.949171, -0.347907>, 
      <5.117401, -2.554668, -0.685639>, <5.033383, -2.564475, -0.572881>, <4.926126, -2.598038, -0.398519>, <4.794815, -2.606116, -0.347907>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.921977, -0.435503, -0.985807>, <4.981849, -0.454583, -0.919495>, <4.955414, -0.338063, -0.789732>, <4.944402, -0.335414, -0.699080>, 
      <5.149876, -1.036105, -0.958739>, <5.209749, -1.055185, -0.892427>, <5.160638, -0.972566, -0.754283>, <5.149626, -0.969917, -0.663632>, 
      <5.209076, -1.910924, -0.979970>, <5.229165, -1.913200, -0.886034>, <5.152643, -1.881031, -0.788132>, <5.095370, -1.887716, -0.711269>, 
      <5.260111, -2.551807, -0.972366>, <5.280200, -2.554083, -0.878430>, <5.174674, -2.547983, -0.762502>, <5.117401, -2.554668, -0.685639>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.869567, 0.007109, -1.889524>, <4.185290, -0.125675, -1.618409>, <4.635696, -0.344272, -1.302881>, <4.921977, -0.435503, -0.985807>, 
      <4.272108, -0.709234, -1.866303>, <4.587830, -0.842018, -1.595188>, <4.863595, -0.944874, -1.275813>, <5.149876, -1.036105, -0.958739>, 
      <4.901379, -1.707515, -1.746946>, <5.011245, -1.714253, -1.519439>, <5.156234, -1.904938, -1.227048>, <5.209076, -1.910924, -0.979970>, 
      <4.893893, -2.529347, -1.730723>, <5.003758, -2.536085, -1.503216>, <5.207269, -2.545820, -1.219443>, <5.260111, -2.551807, -0.972366>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.872004, 0.160336, -2.237863>, <0.937317, 0.283193, -2.158457>, <1.030116, 0.460900, -2.074372>, <1.089713, 0.569861, -1.973176>, 
      <0.955764, 0.173035, -2.239993>, <1.021077, 0.295893, -2.160587>, <1.072115, 0.455265, -2.084292>, <1.131712, 0.564227, -1.983096>, 
      <1.069294, 0.173617, -2.237863>, <1.088387, 0.274548, -2.171150>, <1.148380, 0.447528, -2.085998>, <1.179156, 0.531980, -2.002794>, 
      <1.153847, 0.179309, -2.237863>, <1.172940, 0.280240, -2.171150>, <1.186712, 0.431293, -2.098691>, <1.217489, 0.515745, -2.015488>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.522696, 0.083619, -2.221817>, <0.620171, 0.228143, -2.133711>, <0.757804, 0.433068, -2.040305>, <0.847613, 0.565364, -1.928130>, 
      <0.626693, 0.092961, -2.246950>, <0.724168, 0.237485, -2.158844>, <0.829679, 0.430324, -2.057216>, <0.919488, 0.562620, -1.945041>, 
      <0.765853, 0.144242, -2.235164>, <0.831166, 0.267100, -2.155758>, <0.958811, 0.470465, -2.057531>, <1.018408, 0.579427, -1.956335>, 
      <0.872004, 0.160336, -2.237863>, <0.937317, 0.283193, -2.158457>, <1.030116, 0.460900, -2.074372>, <1.089713, 0.569861, -1.973176>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.321948, 0.110924, -2.104930>, <0.402944, 0.254306, -2.030268>, <0.495074, 0.469183, -1.950862>, <0.591933, 0.588864, -1.856058>, 
      <0.381493, 0.087804, -2.133974>, <0.462489, 0.231186, -2.059312>, <0.569126, 0.453428, -1.976723>, <0.665985, 0.573109, -1.881919>, 
      <0.454749, 0.077515, -2.205396>, <0.552224, 0.222039, -2.117290>, <0.679980, 0.436039, -2.021994>, <0.769789, 0.568335, -1.909819>, 
      <0.522696, 0.083619, -2.221817>, <0.620171, 0.228143, -2.133711>, <0.757804, 0.433068, -2.040305>, <0.847613, 0.565364, -1.928130>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.060623, 0.310107, -1.937296>, <0.049837, 0.421153, -1.877968>, <0.185308, 0.595120, -1.816046>, <0.307578, 0.680259, -1.739537>, 
      <0.066642, 0.273543, -1.978996>, <0.177102, 0.384589, -1.919668>, <0.271734, 0.576882, -1.854110>, <0.394004, 0.662021, -1.777600>, 
      <0.204142, 0.156665, -2.047469>, <0.285138, 0.300047, -1.972807>, <0.406048, 0.488124, -1.919772>, <0.502907, 0.607805, -1.824968>, 
      <0.321948, 0.110924, -2.104930>, <0.402944, 0.254306, -2.030268>, <0.495074, 0.469183, -1.950862>, <0.591933, 0.588864, -1.856058>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.668247, 0.395413, -1.780480>, <-0.478396, 0.505829, -1.763718>, <-0.234669, 0.643554, -1.651984>, <-0.043773, 0.723015, -1.576084>, 
      <-0.500766, 0.366955, -1.865551>, <-0.310915, 0.477372, -1.848789>, <-0.140431, 0.620941, -1.717460>, <0.050465, 0.700401, -1.641560>, 
      <-0.234795, 0.360148, -1.880226>, <-0.124334, 0.471193, -1.820899>, <0.080212, 0.617298, -1.769761>, <0.202482, 0.702437, -1.693251>, 
      <-0.060623, 0.310107, -1.937296>, <0.049837, 0.421153, -1.877968>, <0.185308, 0.595120, -1.816046>, <0.307578, 0.680259, -1.739537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.362939, 0.531392, -1.275793>, <-1.095515, 0.685436, -1.268193>, <-0.683047, 0.775271, -1.280935>, <-0.383324, 0.846052, -1.259499>, 
      <-1.183011, 0.476732, -1.456513>, <-0.915587, 0.630776, -1.448913>, <-0.569157, 0.753228, -1.366390>, <-0.269435, 0.824009, -1.344955>, 
      <-0.898156, 0.434478, -1.663700>, <-0.708304, 0.544894, -1.646937>, <-0.350761, 0.671412, -1.571324>, <-0.159864, 0.750873, -1.495424>, 
      <-0.668247, 0.395413, -1.780480>, <-0.478396, 0.505829, -1.763718>, <-0.234669, 0.643554, -1.651984>, <-0.043773, 0.723015, -1.576084>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.362939, 0.531392, -1.275793>, <-1.544802, 0.426634, -1.280962>, <-1.786765, 0.217157, -1.298905>, <-1.831269, 0.011995, -1.300651>, 
      <-1.183011, 0.476732, -1.456513>, <-1.364874, 0.371974, -1.461682>, <-1.633481, 0.208553, -1.441275>, <-1.677985, 0.003391, -1.443022>, 
      <-0.898156, 0.434478, -1.663700>, <-1.077900, 0.329940, -1.679569>, <-1.377653, 0.221119, -1.599082>, <-1.422319, 0.019834, -1.567821>, 
      <-0.668247, 0.395413, -1.780480>, <-0.847991, 0.290875, -1.796350>, <-1.202388, 0.224479, -1.713584>, <-1.247054, 0.023194, -1.682322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.400558, 0.617881, -1.044946>, <-1.224759, 0.733343, -1.048639>, <-0.948022, 0.816422, -1.054020>, <-0.741847, 0.858126, -1.052292>, 
      <-1.402914, 0.595653, -1.116340>, <-1.227115, 0.711116, -1.120033>, <-0.837340, 0.835399, -1.107264>, <-0.631164, 0.877103, -1.105536>, 
      <-1.414550, 0.547071, -1.223955>, <-1.147126, 0.701115, -1.216354>, <-0.781285, 0.794285, -1.207223>, <-0.481562, 0.865066, -1.185787>, 
      <-1.362939, 0.531392, -1.275793>, <-1.095515, 0.685436, -1.268193>, <-0.683047, 0.775271, -1.280935>, <-0.383324, 0.846052, -1.259499>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.400558, 0.617881, -1.044946>, <-1.596912, 0.488918, -1.040821>, <-1.894485, 0.290414, -1.028235>, <-1.952770, 0.062808, -1.026852>, 
      <-1.402914, 0.595653, -1.116340>, <-1.599268, 0.466690, -1.112215>, <-1.871143, 0.310810, -1.113949>, <-1.929427, 0.083205, -1.112567>, 
      <-1.414550, 0.547071, -1.223955>, <-1.596413, 0.442313, -1.229123>, <-1.853494, 0.220903, -1.236927>, <-1.897997, 0.015741, -1.238673>, 
      <-1.362939, 0.531392, -1.275793>, <-1.544802, 0.426634, -1.280962>, <-1.786765, 0.217157, -1.298905>, <-1.831269, 0.011995, -1.300651>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.400558, 0.617881, -1.044946>, <-1.224759, 0.733343, -1.048639>, <-0.948022, 0.816422, -1.054020>, <-0.741847, 0.858126, -1.052292>, 
      <-1.400558, 0.617881, -1.044946>, <-1.222280, 0.756733, -0.973514>, <-1.129922, 0.785235, -0.966517>, <-0.923747, 0.826939, -0.964789>, 
      <-1.400558, 0.617881, -1.044946>, <-1.222280, 0.756733, -0.973514>, <-1.195034, 0.716347, -0.943610>, <-1.165524, 0.734005, -0.872798>, 
      <-1.400558, 0.617881, -1.044946>, <-1.398079, 0.641271, -0.969821>, <-1.376610, 0.663152, -0.866684>, <-1.347100, 0.680811, -0.795872>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.400558, 0.617881, -1.044946>, <-1.398079, 0.641271, -0.969821>, <-1.376610, 0.663152, -0.866684>, <-1.347100, 0.680811, -0.795872>, 
      <-1.596912, 0.488918, -1.040821>, <-1.594433, 0.512308, -0.965696>, <-1.656673, 0.536979, -0.848047>, <-1.627163, 0.554638, -0.777235>, 
      <-1.894485, 0.290414, -1.028235>, <-1.920784, 0.267434, -0.931664>, <-1.915097, 0.173465, -0.874530>, <-1.883366, 0.167059, -0.777073>, 
      <-1.952770, 0.062808, -1.026852>, <-1.979069, 0.039828, -0.930281>, <-2.015672, -0.115004, -0.837488>, <-1.983942, -0.121410, -0.740031>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.213214, 0.729988, -0.595400>, <-1.480395, 0.604251, -0.497973>, <-1.551578, 0.286089, -0.072631>, <-1.613491, -0.005693, 0.015218>, 
      <-1.277810, 0.715804, -0.628174>, <-1.544991, 0.590067, -0.530747>, <-1.729041, 0.283817, -0.255372>, <-1.790954, -0.007964, -0.167523>, 
      <-1.319431, 0.697368, -0.729478>, <-1.599493, 0.571195, -0.710840>, <-1.804656, 0.151167, -0.535320>, <-1.905232, -0.137302, -0.498278>, 
      <-1.347100, 0.680811, -0.795872>, <-1.627163, 0.554638, -0.777235>, <-1.883366, 0.167059, -0.777073>, <-1.983942, -0.121410, -0.740031>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.689158, 0.825279, -0.462057>, <-0.978464, 0.649494, -0.347351>, <-1.112275, 0.222724, -0.022197>, <-1.185415, -0.111189, 0.082247>, 
      <-0.850309, 0.834350, -0.494960>, <-1.139615, 0.658565, -0.380254>, <-1.244950, 0.238606, -0.028794>, <-1.318090, -0.095308, 0.075650>, 
      <-1.069052, 0.761643, -0.522258>, <-1.336232, 0.635906, -0.424831>, <-1.458378, 0.287282, 0.023342>, <-1.520291, -0.004500, 0.111190>, 
      <-1.213214, 0.729988, -0.595400>, <-1.480395, 0.604251, -0.497973>, <-1.551578, 0.286089, -0.072631>, <-1.613491, -0.005693, 0.015218>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.169429, 0.652158, -0.313101>, <-0.016383, 0.445165, -0.202595>, <-0.217106, 0.122015, 0.025800>, <-0.230092, -0.171289, 0.084007>, 
      <-0.092066, 0.687936, -0.350246>, <-0.277878, 0.480943, -0.239740>, <-0.503924, 0.136103, 0.025163>, <-0.516910, -0.157201, 0.083371>, 
      <-0.428409, 0.810601, -0.408819>, <-0.717715, 0.634816, -0.294113>, <-0.827493, 0.188635, -0.008036>, <-0.900633, -0.145278, 0.096408>, 
      <-0.689158, 0.825279, -0.462057>, <-0.978464, 0.649494, -0.347351>, <-1.112275, 0.222724, -0.022197>, <-1.185415, -0.111189, 0.082247>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.547345, 0.656098, -0.286414>, <0.516461, 0.379872, -0.164049>, <0.919537, 0.082980, 0.024459>, <0.905803, -0.213908, 0.086884>, 
      <0.434233, 0.651309, -0.296522>, <0.403349, 0.375083, -0.174157>, <0.581819, 0.105609, 0.065956>, <0.568085, -0.191278, 0.128381>, 
      <0.280944, 0.636900, -0.297260>, <0.095133, 0.429907, -0.186754>, <0.123492, 0.105285, 0.026555>, <0.110506, -0.188019, 0.084762>, 
      <0.169429, 0.652158, -0.313101>, <-0.016383, 0.445165, -0.202595>, <-0.217106, 0.122015, 0.025800>, <-0.230092, -0.171289, 0.084007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.802501, 0.678960, -0.256526>, <0.726420, 0.418072, -0.177066>, <0.747777, 0.040630, -0.093758>, <0.737634, -0.236134, -0.034903>, 
      <0.725438, 0.675457, -0.262514>, <0.649356, 0.414569, -0.183054>, <0.699087, 0.049121, -0.055264>, <0.688944, -0.227643, 0.003591>, 
      <0.624344, 0.659358, -0.279533>, <0.593460, 0.383132, -0.157168>, <0.981579, 0.078822, 0.016835>, <0.967845, -0.218065, 0.079260>, 
      <0.547345, 0.656098, -0.286414>, <0.516461, 0.379872, -0.164049>, <0.919537, 0.082980, 0.024459>, <0.905803, -0.213908, 0.086884>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.076926, 0.680168, -0.245266>, <1.036493, 0.412236, -0.161477>, <1.051352, 0.039303, -0.081424>, <1.044032, -0.238015, -0.022399>, 
      <0.994736, 0.674625, -0.247132>, <0.954304, 0.406693, -0.163343>, <0.959379, 0.039371, -0.083565>, <0.952059, -0.237947, -0.024540>, 
      <0.884567, 0.682690, -0.250150>, <0.808485, 0.421802, -0.170690>, <0.819280, 0.028160, -0.150287>, <0.809136, -0.248604, -0.091432>, 
      <0.802501, 0.678960, -0.256526>, <0.726420, 0.418072, -0.177066>, <0.747777, 0.040630, -0.093758>, <0.737634, -0.236134, -0.034903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.298460, 0.712409, -0.245266>, <1.281366, 0.433786, -0.158015>, <1.296517, 0.049585, -0.082355>, <1.291376, -0.236542, -0.022013>, 
      <1.231672, 0.705463, -0.244004>, <1.214577, 0.426840, -0.156753>, <1.222635, 0.055811, -0.079349>, <1.217494, -0.230316, -0.019007>, 
      <1.143917, 0.684686, -0.243745>, <1.103484, 0.416754, -0.159957>, <1.125536, 0.039249, -0.079697>, <1.118216, -0.238070, -0.020672>, 
      <1.076926, 0.680168, -0.245266>, <1.036493, 0.412236, -0.161477>, <1.051352, 0.039303, -0.081424>, <1.044032, -0.238015, -0.022399>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.673029, 0.742159, -0.256526>, <1.729781, 0.440563, -0.171512>, <1.740633, 0.016350, -0.108170>, <1.742546, -0.296883, -0.050817>, 
      <1.560354, 0.737769, -0.254698>, <1.617106, 0.436173, -0.169684>, <1.604270, 0.026536, -0.103308>, <1.606183, -0.286697, -0.045955>, 
      <1.410610, 0.724072, -0.247385>, <1.393516, 0.445449, -0.160133>, <1.432751, 0.038103, -0.087897>, <1.427610, -0.248023, -0.027556>, 
      <1.298460, 0.712409, -0.245266>, <1.281366, 0.433786, -0.158015>, <1.296517, 0.049585, -0.082355>, <1.291376, -0.236542, -0.022013>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.992500, 0.739450, -0.256526>, <1.896789, 0.742699, -0.252635>, <1.768788, 0.745890, -0.258080>, <1.673029, 0.742159, -0.256526>, 
      <2.095938, 0.449432, -0.174776>, <2.000227, 0.452682, -0.170885>, <1.825540, 0.444294, -0.173066>, <1.729781, 0.440563, -0.171512>, 
      <2.092393, 0.018280, -0.096829>, <1.985519, 0.019914, -0.091746>, <1.847276, 0.008385, -0.111972>, <1.740633, 0.016350, -0.108170>, 
      <2.099237, -0.296885, -0.050818>, <1.992363, -0.295251, -0.045735>, <1.849189, -0.304849, -0.054619>, <1.742546, -0.296883, -0.050817>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.513783, 0.713615, -0.290706>, <2.359249, 0.729757, -0.268791>, <2.149193, 0.734130, -0.262896>, <1.992500, 0.739450, -0.256526>, 
      <2.682484, 0.457817, -0.215489>, <2.527950, 0.473960, -0.193574>, <2.252631, 0.444112, -0.181146>, <2.095938, 0.449432, -0.174776>, 
      <2.638806, 0.001432, -0.138777>, <2.477220, 0.009751, -0.105067>, <2.257461, 0.015756, -0.104680>, <2.092393, 0.018280, -0.096829>, 
      <2.648290, -0.310731, -0.093894>, <2.486704, -0.302411, -0.060184>, <2.264305, -0.299409, -0.058669>, <2.099237, -0.296885, -0.050818>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.939835, 0.640492, -0.390871>, <2.809577, 0.659794, -0.371345>, <2.644885, 0.699920, -0.309298>, <2.513783, 0.713615, -0.290706>, 
      <3.143061, 0.418458, -0.338574>, <3.012803, 0.437761, -0.319047>, <2.813586, 0.444123, -0.234081>, <2.682484, 0.457817, -0.215489>, 
      <3.124282, -0.046954, -0.299237>, <2.972249, -0.030527, -0.264355>, <2.792151, -0.006463, -0.170768>, <2.638806, 0.001432, -0.138777>, 
      <3.139705, -0.350456, -0.267883>, <2.987672, -0.334030, -0.233001>, <2.801635, -0.318626, -0.125885>, <2.648290, -0.310731, -0.093894>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.383119, 0.584791, -0.421024>, <3.249719, 0.586090, -0.405245>, <3.071283, 0.621013, -0.410576>, <2.939835, 0.640492, -0.390871>, 
      <3.613387, 0.381678, -0.369001>, <3.479987, 0.382977, -0.353222>, <3.274508, 0.398980, -0.358279>, <3.143061, 0.418458, -0.338574>, 
      <3.611466, -0.108161, -0.349902>, <3.461099, -0.102304, -0.342844>, <3.270306, -0.062730, -0.332740>, <3.124282, -0.046954, -0.299237>, 
      <3.634633, -0.417298, -0.320196>, <3.484266, -0.411441, -0.313138>, <3.285728, -0.366233, -0.301386>, <3.139705, -0.350456, -0.267883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.968647, 0.630471, -0.512560>, <3.816494, 0.631036, -0.419571>, <3.560196, 0.583066, -0.441969>, <3.383119, 0.584791, -0.421024>, 
      <4.328800, 0.438646, -0.451782>, <4.176647, 0.439211, -0.358793>, <3.790464, 0.379953, -0.389946>, <3.613387, 0.381678, -0.369001>, 
      <4.742578, -0.017609, -0.368218>, <4.394452, -0.039373, -0.267513>, <3.973844, -0.122277, -0.366912>, <3.611466, -0.108161, -0.349902>, 
      <4.844491, -0.416861, -0.347907>, <4.496364, -0.438625, -0.247202>, <3.997012, -0.431413, -0.337206>, <3.634633, -0.417298, -0.320196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.968647, 0.630471, -0.512560>, <4.328800, 0.438646, -0.451782>, <4.742578, -0.017609, -0.368218>, <4.844491, -0.416861, -0.347907>, 
      <4.064996, 0.630113, -0.571445>, <4.425149, 0.438288, -0.510667>, <4.850190, -0.010882, -0.399347>, <4.952102, -0.410133, -0.379036>, 
      <4.078828, 0.605459, -0.753044>, <4.416425, 0.440398, -0.727584>, <4.815127, 0.025706, -0.607714>, <4.930875, -0.332160, -0.587721>, 
      <4.102837, 0.582119, -0.860884>, <4.440434, 0.417058, -0.835425>, <4.828654, 0.022452, -0.719073>, <4.944402, -0.335414, -0.699080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.101651, 0.501176, -1.109958>, <4.150040, 0.519759, -1.050912>, <4.119543, 0.565879, -0.935920>, <4.102837, 0.582119, -0.860884>, 
      <4.402288, 0.276809, -1.096131>, <4.450677, 0.295392, -1.037085>, <4.457140, 0.400818, -0.910460>, <4.440434, 0.417058, -0.835425>, 
      <4.788920, -0.084846, -1.001610>, <4.848792, -0.103926, -0.935299>, <4.839666, 0.019802, -0.809725>, <4.828654, 0.022452, -0.719073>, 
      <4.921977, -0.435503, -0.985807>, <4.981849, -0.454583, -0.919495>, <4.955414, -0.338063, -0.789732>, <4.944402, -0.335414, -0.699080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.101651, 0.501176, -1.109958>, <3.892236, 0.657463, -1.119590>, <3.533117, 0.722610, -1.071779>, <3.280552, 0.789500, -1.061301>, 
      <4.101651, 0.501176, -1.109958>, <3.940624, 0.676046, -1.060544>, <3.756480, 0.733517, -0.936392>, <3.503914, 0.800407, -0.925914>, 
      <4.101651, 0.501176, -1.109958>, <3.940624, 0.676046, -1.060544>, <3.872858, 0.628093, -0.996045>, <3.856152, 0.644333, -0.921009>, 
      <4.101651, 0.501176, -1.109958>, <4.150040, 0.519759, -1.050912>, <4.119543, 0.565879, -0.935920>, <4.102837, 0.582119, -0.860884>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.315376, 0.279710, -1.821783>, <3.201958, 0.353012, -1.766419>, <3.171555, 0.464887, -1.558454>, <3.058753, 0.531136, -1.493733>, 
      <3.556010, 0.341544, -1.612190>, <3.442592, 0.414846, -1.556826>, <3.265173, 0.508094, -1.429482>, <3.152372, 0.574343, -1.364762>, 
      <3.901464, 0.424298, -1.354237>, <3.692048, 0.580585, -1.363868>, <3.392033, 0.715720, -1.157294>, <3.139468, 0.782611, -1.146816>, 
      <4.101651, 0.501176, -1.109958>, <3.892236, 0.657463, -1.119590>, <3.533117, 0.722610, -1.071779>, <3.280552, 0.789500, -1.061301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.315376, 0.279710, -1.821783>, <3.556010, 0.341544, -1.612190>, <3.901464, 0.424298, -1.354237>, <4.101651, 0.501176, -1.109958>, 
      <3.460221, 0.186097, -1.892488>, <3.700854, 0.247932, -1.682894>, <4.202101, 0.199931, -1.340410>, <4.402288, 0.276809, -1.096131>, 
      <3.778291, 0.169539, -1.894789>, <4.094014, 0.036755, -1.623674>, <4.502638, 0.006385, -1.318684>, <4.788920, -0.084846, -1.001610>, 
      <3.869567, 0.007109, -1.889524>, <4.185290, -0.125675, -1.618409>, <4.635696, -0.344272, -1.302881>, <4.921977, -0.435503, -0.985807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.103852, 0.244777, -1.979045>, <2.994700, 0.333354, -1.927120>, <2.847745, 0.467473, -1.880694>, <2.740012, 0.540032, -1.805962>, 
      <3.175120, 0.260669, -1.946938>, <3.065968, 0.349245, -1.895013>, <2.970118, 0.473912, -1.826768>, <2.862385, 0.546471, -1.752036>, 
      <3.256326, 0.264536, -1.873216>, <3.142908, 0.337838, -1.817852>, <3.095647, 0.429855, -1.663026>, <2.982845, 0.496103, -1.598305>, 
      <3.315376, 0.279710, -1.821783>, <3.201958, 0.353012, -1.766419>, <3.171555, 0.464887, -1.558454>, <3.058753, 0.531136, -1.493733>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.723352, 0.147697, -2.088496>, <2.601323, 0.251014, -2.008183>, <2.426687, 0.387492, -1.915410>, <2.316588, 0.492087, -1.820785>, 
      <2.841194, 0.173449, -2.068328>, <2.719164, 0.276766, -1.988015>, <2.551750, 0.401917, -1.892745>, <2.441651, 0.506512, -1.798121>, 
      <2.994583, 0.220412, -2.028272>, <2.885431, 0.308988, -1.976347>, <2.730826, 0.461321, -1.932217>, <2.623093, 0.533880, -1.857485>, 
      <3.103852, 0.244777, -1.979045>, <2.994700, 0.333354, -1.927120>, <2.847745, 0.467473, -1.880694>, <2.740012, 0.540032, -1.805962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.368300, 0.084038, -2.104930>, <2.293327, 0.199326, -2.049035>, <2.193642, 0.366753, -1.996430>, <2.118390, 0.468333, -1.918614>, 
      <2.472415, 0.102123, -2.081107>, <2.397442, 0.217412, -2.025212>, <2.251453, 0.377496, -1.964965>, <2.176201, 0.479076, -1.887150>, 
      <2.618972, 0.124887, -2.106360>, <2.496943, 0.228204, -2.026047>, <2.361485, 0.379971, -1.927226>, <2.251385, 0.484566, -1.832601>, 
      <2.723352, 0.147697, -2.088496>, <2.601323, 0.251014, -2.008183>, <2.426687, 0.387492, -1.915410>, <2.316588, 0.492087, -1.820785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.140697, 0.046488, -2.221817>, <2.079951, 0.159074, -2.163289>, <1.995674, 0.322039, -2.107604>, <1.938210, 0.421775, -2.026722>, 
      <2.215180, 0.043101, -2.200379>, <2.154434, 0.155688, -2.141850>, <2.060218, 0.322903, -2.106154>, <2.002754, 0.422639, -2.025271>, 
      <2.293735, 0.071086, -2.121992>, <2.218762, 0.186374, -2.066097>, <2.137672, 0.356353, -2.026892>, <2.062420, 0.457932, -1.949076>, 
      <2.368300, 0.084038, -2.104930>, <2.293327, 0.199326, -2.049035>, <2.193642, 0.366753, -1.996430>, <2.118390, 0.468333, -1.918614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.906444, 0.105038, -2.237863>, <1.843001, 0.212326, -2.144943>, <1.757415, 0.354945, -2.021223>, <1.694966, 0.462666, -1.928130>, 
      <1.977817, 0.091932, -2.235721>, <1.914373, 0.199220, -2.142801>, <1.831187, 0.327751, -2.034209>, <1.768737, 0.435472, -1.941116>, 
      <2.070998, 0.049657, -2.241878>, <2.010252, 0.162243, -2.183350>, <1.916012, 0.320973, -2.109395>, <1.858548, 0.420709, -2.028512>, 
      <2.140697, 0.046488, -2.221817>, <2.079951, 0.159074, -2.163289>, <1.995674, 0.322039, -2.107604>, <1.938210, 0.421775, -2.026722>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.606027, 0.144668, -2.237863>, <1.696152, 0.132779, -2.237863>, <1.817072, 0.121449, -2.240545>, <1.906444, 0.105038, -2.237863>, 
      <1.574410, 0.276191, -2.151412>, <1.664535, 0.264302, -2.151412>, <1.753628, 0.228738, -2.147625>, <1.843001, 0.212326, -2.144943>, 
      <1.534294, 0.468528, -2.057013>, <1.592592, 0.432405, -2.050544>, <1.693644, 0.378453, -2.009997>, <1.757415, 0.354945, -2.021223>, 
      <1.500638, 0.583077, -1.949694>, <1.558936, 0.546954, -1.943225>, <1.631195, 0.486174, -1.916904>, <1.694966, 0.462666, -1.928130>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.462649, 0.870556, -1.576298>, <1.522250, 0.876831, -1.569679>, <1.603736, 0.874103, -1.564370>, <1.661343, 0.878465, -1.547112>, 
      <1.521861, 0.727128, -1.659329>, <1.581461, 0.733402, -1.652710>, <1.674506, 0.712372, -1.687687>, <1.732113, 0.716734, -1.670429>, 
      <1.624274, 0.584606, -1.822749>, <1.698045, 0.557411, -1.835735>, <1.770587, 0.573375, -1.904705>, <1.850249, 0.574441, -1.902915>, 
      <1.694966, 0.462666, -1.928130>, <1.768737, 0.435472, -1.941116>, <1.858548, 0.420709, -2.028512>, <1.938210, 0.421775, -2.026722>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.462649, 1.025409, -1.602357>, <1.524000, 1.030780, -1.590526>, <1.603577, 1.044123, -1.566379>, <1.661343, 1.054497, -1.544283>, 
      <1.462844, 0.981229, -1.586005>, <1.524196, 0.986601, -1.574174>, <1.603799, 0.992356, -1.555904>, <1.661566, 1.002730, -1.533808>, 
      <1.446799, 0.908949, -1.554072>, <1.506400, 0.915224, -1.547453>, <1.586378, 0.913770, -1.534124>, <1.643985, 0.918132, -1.516866>, 
      <1.462649, 0.870556, -1.576298>, <1.522250, 0.876831, -1.569679>, <1.603736, 0.874103, -1.564370>, <1.661343, 0.878465, -1.547112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.460876, 1.271433, -1.724677>, <1.523966, 1.273104, -1.704318>, <1.603790, 1.276366, -1.663898>, <1.659618, 1.279348, -1.628234>, 
      <1.461408, 1.197626, -1.687981>, <1.524498, 1.199297, -1.667622>, <1.604307, 1.208910, -1.638712>, <1.660136, 1.211893, -1.603049>, 
      <1.462307, 1.102711, -1.630969>, <1.523659, 1.108082, -1.619138>, <1.603273, 1.114697, -1.580660>, <1.661039, 1.125071, -1.558564>, 
      <1.462649, 1.025409, -1.602357>, <1.524000, 1.030780, -1.590526>, <1.603577, 1.044123, -1.566379>, <1.661343, 1.054497, -1.544283>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.565357, 1.313861, -0.482692>, <1.534857, 1.313367, -0.475482>, <1.492215, 1.313452, -0.482923>, <1.460874, 1.313861, -0.482692>, 
      <1.565357, 1.365805, -0.484568>, <1.534857, 1.365311, -0.477358>, <1.492216, 1.365396, -0.484799>, <1.460874, 1.365806, -0.484568>, 
      <1.565357, 1.435143, -0.482999>, <1.536162, 1.437295, -0.471798>, <1.492220, 1.435144, -0.482999>, <1.460875, 1.435144, -0.482999>, 
      <1.565357, 1.487121, -0.483130>, <1.536162, 1.489273, -0.471929>, <1.492220, 1.487122, -0.483130>, <1.460876, 1.487122, -0.483130>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.565357, 1.200000, -0.472760>, <1.535479, 1.201749, -0.463448>, <1.492215, 1.199520, -0.472760>, <1.460874, 1.200000, -0.472760>, 
      <1.545847, 1.226236, -0.483090>, <1.515969, 1.227985, -0.473778>, <1.481030, 1.229660, -0.484683>, <1.449689, 1.230140, -0.484683>, 
      <1.565357, 1.279595, -0.481455>, <1.534857, 1.279101, -0.474244>, <1.492215, 1.279186, -0.481685>, <1.460874, 1.279595, -0.481455>, 
      <1.565357, 1.313861, -0.482692>, <1.534857, 1.313367, -0.475482>, <1.492215, 1.313452, -0.482923>, <1.460874, 1.313861, -0.482692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.565357, 1.200000, -0.472760>, <1.535479, 1.201749, -0.463448>, <1.492215, 1.199520, -0.472760>, <1.460874, 1.200000, -0.472760>, 
      <1.678754, 1.047506, -0.412718>, <1.648876, 1.049255, -0.403405>, <1.545939, 1.054750, -0.415489>, <1.514597, 1.055230, -0.415489>, 
      <1.927792, 0.920877, -0.307667>, <1.832081, 0.924127, -0.303776>, <1.739437, 0.901871, -0.302048>, <1.643678, 0.898140, -0.300494>, 
      <1.992500, 0.739450, -0.256526>, <1.896789, 0.742699, -0.252635>, <1.768788, 0.745890, -0.258080>, <1.673029, 0.742159, -0.256526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.659618, 1.188370, -0.534704>, <1.632765, 1.195121, -0.514943>, <1.597783, 1.198103, -0.482866>, <1.565357, 1.200000, -0.472760>, 
      <1.900209, 1.018392, -0.467394>, <1.873356, 1.025143, -0.447633>, <1.711180, 1.045609, -0.422824>, <1.678754, 1.047506, -0.412718>, 
      <2.352217, 0.958594, -0.362742>, <2.197684, 0.974736, -0.340827>, <2.084485, 0.915557, -0.314037>, <1.927792, 0.920877, -0.307667>, 
      <2.513783, 0.713615, -0.290706>, <2.359249, 0.729757, -0.268791>, <2.149193, 0.734130, -0.262896>, <1.992500, 0.739450, -0.256526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.766979, 1.149312, -0.621134>, <1.732988, 1.160858, -0.597506>, <1.693544, 1.179841, -0.559670>, <1.659618, 1.188370, -0.534704>, 
      <2.099597, 0.957603, -0.554132>, <2.065606, 0.969149, -0.530503>, <1.934135, 1.009863, -0.492360>, <1.900209, 1.018392, -0.467394>, 
      <2.680595, 0.923724, -0.457583>, <2.550337, 0.943026, -0.438056>, <2.483320, 0.944899, -0.381334>, <2.352217, 0.958594, -0.362742>, 
      <2.939835, 0.640492, -0.390871>, <2.809577, 0.659794, -0.371345>, <2.644885, 0.699920, -0.309298>, <2.513783, 0.713615, -0.290706>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.911168, 1.102925, -0.709568>, <1.869381, 1.114221, -0.679654>, <1.808595, 1.135176, -0.650063>, <1.766979, 1.149312, -0.621134>, 
      <2.332852, 0.898239, -0.626269>, <2.291065, 0.909536, -0.596355>, <2.141213, 0.943467, -0.583061>, <2.099597, 0.957603, -0.554132>, 
      <3.031103, 0.895295, -0.500553>, <2.897704, 0.896594, -0.484774>, <2.812043, 0.904245, -0.477287>, <2.680595, 0.923724, -0.457583>, 
      <3.383119, 0.584791, -0.421024>, <3.249719, 0.586090, -0.405245>, <3.071283, 0.621013, -0.410576>, <2.939835, 0.640492, -0.390871>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.045200, 1.074102, -0.820303>, <2.009099, 1.083525, -0.782846>, <1.953155, 1.091575, -0.739625>, <1.911168, 1.102925, -0.709568>, 
      <2.607380, 0.885991, -0.732137>, <2.571278, 0.895415, -0.694680>, <2.374840, 0.886889, -0.656326>, <2.332852, 0.898239, -0.626269>, 
      <3.445436, 0.909145, -0.600855>, <3.293283, 0.909709, -0.507866>, <3.208180, 0.893570, -0.521498>, <3.031103, 0.895295, -0.500553>, 
      <3.968647, 0.630471, -0.512560>, <3.816494, 0.631036, -0.419571>, <3.560196, 0.583066, -0.441969>, <3.383119, 0.584791, -0.421024>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.107273, 1.051736, -0.913039>, <2.094427, 1.059316, -0.882326>, <2.068515, 1.068016, -0.844494>, <2.045200, 1.074102, -0.820303>, 
      <2.691346, 0.858815, -0.901270>, <2.678500, 0.866395, -0.870556>, <2.630694, 0.879906, -0.756328>, <2.607380, 0.885991, -0.732137>, 
      <3.551404, 0.851730, -0.902470>, <3.527394, 0.875070, -0.794630>, <3.541785, 0.908787, -0.659739>, <3.445436, 0.909145, -0.600855>, 
      <4.102837, 0.582119, -0.860884>, <4.078828, 0.605459, -0.753044>, <4.064996, 0.630113, -0.571445>, <3.968647, 0.630471, -0.512560>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.132179, 1.022779, -1.028254>, <2.130430, 1.033585, -0.993524>, <2.120974, 1.043652, -0.945795>, <2.107273, 1.051736, -0.913039>, 
      <2.461894, 0.901435, -1.043997>, <2.460145, 0.912240, -1.009267>, <2.705047, 0.850730, -0.934026>, <2.691346, 0.858815, -0.901270>, 
      <2.940858, 0.879466, -1.047209>, <3.164221, 0.890373, -0.911822>, <3.304718, 0.913944, -0.962595>, <3.551404, 0.851730, -0.902470>, 
      <3.280552, 0.789500, -1.061301>, <3.503914, 0.800407, -0.925914>, <3.856152, 0.644333, -0.921009>, <4.102837, 0.582119, -0.860884>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.118456, 0.982664, -1.135040>, <2.130660, 0.992001, -1.104186>, <2.133835, 1.012551, -1.061128>, <2.132179, 1.022779, -1.028254>, 
      <2.377970, 0.804121, -1.236418>, <2.390174, 0.813458, -1.205564>, <2.463550, 0.891206, -1.076871>, <2.461894, 0.901435, -1.043997>, 
      <2.803001, 0.681340, -1.346993>, <2.896620, 0.724546, -1.218022>, <2.799774, 0.872577, -1.132724>, <2.940858, 0.879466, -1.047209>, 
      <3.058753, 0.531136, -1.493733>, <3.152372, 0.574343, -1.364762>, <3.139468, 0.782611, -1.146816>, <3.280552, 0.789500, -1.061301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.046279, 0.957060, -1.245430>, <2.071048, 0.964823, -1.214595>, <2.104185, 0.971746, -1.171120>, <2.118456, 0.982664, -1.135040>, 
      <2.237389, 0.792992, -1.399710>, <2.262158, 0.800754, -1.368875>, <2.363699, 0.793203, -1.272497>, <2.377970, 0.804121, -1.236418>, 
      <2.527664, 0.683050, -1.658661>, <2.650036, 0.689489, -1.604734>, <2.727093, 0.646307, -1.451565>, <2.803001, 0.681340, -1.346993>, 
      <2.740012, 0.540032, -1.805962>, <2.862385, 0.546471, -1.752036>, <2.982845, 0.496103, -1.598305>, <3.058753, 0.531136, -1.493733>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.912418, 0.918092, -1.391538>, <1.957655, 0.928408, -1.352579>, <2.009048, 0.945392, -1.291780>, <2.046279, 0.957060, -1.245430>, 
      <2.017111, 0.757705, -1.496101>, <2.062348, 0.768021, -1.457142>, <2.200157, 0.781323, -1.446060>, <2.237389, 0.792992, -1.399710>, 
      <2.182316, 0.619647, -1.705385>, <2.307379, 0.634072, -1.682720>, <2.410744, 0.676898, -1.710184>, <2.527664, 0.683050, -1.658661>, 
      <2.316588, 0.492087, -1.820785>, <2.441651, 0.506512, -1.798121>, <2.623093, 0.533880, -1.857485>, <2.740012, 0.540032, -1.805962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.768479, 0.893713, -1.484677>, <1.857436, 0.738126, -1.594818>, <2.011752, 0.612280, -1.808344>, <2.118390, 0.468333, -1.918614>, 
      <1.736902, 0.888729, -1.504243>, <1.825859, 0.733142, -1.614384>, <1.955782, 0.601879, -1.838806>, <2.062420, 0.457932, -1.949076>, 
      <1.697153, 0.881177, -1.536384>, <1.767923, 0.719446, -1.659701>, <1.914793, 0.575305, -1.901464>, <2.002754, 0.422639, -2.025271>, 
      <1.661343, 0.878465, -1.547112>, <1.732113, 0.716734, -1.670429>, <1.850249, 0.574441, -1.902915>, <1.938210, 0.421775, -2.026722>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.768479, 0.893713, -1.484677>, <1.812247, 0.900621, -1.457557>, <1.873628, 0.909247, -1.424945>, <1.912418, 0.918092, -1.391538>, 
      <1.857436, 0.738126, -1.594818>, <1.901204, 0.745034, -1.567698>, <1.978321, 0.748860, -1.529507>, <2.017111, 0.757705, -1.496101>, 
      <2.011752, 0.612280, -1.808344>, <2.069563, 0.623022, -1.776879>, <2.117113, 0.612126, -1.717201>, <2.182316, 0.619647, -1.705385>, 
      <2.118390, 0.468333, -1.918614>, <2.176201, 0.479076, -1.887150>, <2.251385, 0.484566, -1.832601>, <2.316588, 0.492087, -1.820785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.107273, 1.241261, -0.901095>, <2.120432, 1.231843, -0.930476>, <2.128751, 1.222012, -0.974374>, <2.131288, 1.212461, -1.006428>, 
      <2.110404, 1.283513, -0.904401>, <2.123563, 1.274095, -0.933782>, <2.128639, 1.263099, -0.973786>, <2.131176, 1.253548, -1.005840>, 
      <2.124084, 1.335433, -0.927205>, <2.135273, 1.329281, -0.950827>, <2.131288, 1.314290, -0.992442>, <2.131288, 1.307586, -1.018444>, 
      <2.131288, 1.375792, -0.938395>, <2.142478, 1.369640, -0.962017>, <2.131288, 1.355057, -0.997591>, <2.131288, 1.348353, -1.023593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.107273, 1.241261, -0.901095>, <2.120432, 1.231843, -0.930476>, <2.128751, 1.222012, -0.974374>, <2.131288, 1.212461, -1.006428>, 
      <2.103076, 1.184619, -0.896663>, <2.116235, 1.175201, -0.926044>, <2.128908, 1.164737, -0.975194>, <2.131445, 1.155186, -1.007248>, 
      <2.053187, 1.069601, -0.914129>, <2.066888, 1.061517, -0.946885>, <2.076728, 1.053349, -0.990960>, <2.078477, 1.042543, -1.025690>, 
      <2.107273, 1.051736, -0.913039>, <2.120974, 1.043652, -0.945795>, <2.130430, 1.033585, -0.993524>, <2.132179, 1.022779, -1.028254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.045200, 1.274075, -0.814212>, <2.068783, 1.267098, -0.836977>, <2.094126, 1.250670, -0.871741>, <2.107273, 1.241261, -0.901095>, 
      <2.045200, 1.214190, -0.810198>, <2.068783, 1.207213, -0.832963>, <2.089929, 1.194028, -0.867309>, <2.103076, 1.184619, -0.896663>, 
      <1.988901, 1.092940, -0.829132>, <2.012216, 1.086854, -0.853323>, <2.040341, 1.077181, -0.883416>, <2.053187, 1.069601, -0.914129>, 
      <2.045200, 1.074102, -0.820303>, <2.068515, 1.068016, -0.844494>, <2.094427, 1.059316, -0.882326>, <2.107273, 1.051736, -0.913039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.045201, 1.395681, -0.841858>, <2.072834, 1.389523, -0.869058>, <2.114928, 1.384786, -0.903858>, <2.131288, 1.375792, -0.938395>, 
      <2.045201, 1.359199, -0.833564>, <2.072834, 1.353041, -0.860764>, <2.107724, 1.344427, -0.892668>, <2.124084, 1.335433, -0.927205>, 
      <2.045200, 1.311404, -0.816714>, <2.068783, 1.304427, -0.839479>, <2.097257, 1.292923, -0.875047>, <2.110404, 1.283513, -0.904401>, 
      <2.045200, 1.274075, -0.814212>, <2.068783, 1.267098, -0.836977>, <2.094126, 1.250670, -0.871741>, <2.107273, 1.241261, -0.901095>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.125318, 1.173329, -1.129092>, <2.137699, 1.184523, -1.094212>, <2.134213, 1.201451, -1.043380>, <2.131288, 1.212461, -1.006428>, 
      <2.123143, 1.116218, -1.125505>, <2.135524, 1.127412, -1.090625>, <2.134370, 1.144177, -1.044200>, <2.131445, 1.155186, -1.007248>, 
      <2.073547, 1.013561, -1.117497>, <2.085751, 1.022898, -1.086643>, <2.080133, 1.032315, -1.058564>, <2.078477, 1.042543, -1.025690>, 
      <2.118456, 0.982664, -1.135040>, <2.130660, 0.992001, -1.104186>, <2.133835, 1.012551, -1.061128>, <2.132179, 1.022779, -1.028254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.125318, 1.173329, -1.129092>, <2.123143, 1.116218, -1.125505>, <2.073547, 1.013561, -1.117497>, <2.118456, 0.982664, -1.135040>, 
      <2.111293, 1.160649, -1.168605>, <2.109118, 1.103538, -1.165018>, <2.059276, 1.002643, -1.153576>, <2.104185, 0.971746, -1.171120>, 
      <2.071934, 1.143083, -1.211213>, <2.072106, 1.089717, -1.206616>, <2.036392, 0.994575, -1.186617>, <2.071048, 0.964823, -1.214595>, 
      <2.046279, 1.135604, -1.245921>, <2.046451, 1.082239, -1.241324>, <2.011622, 0.986813, -1.217452>, <2.046279, 0.957060, -1.245430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.125318, 1.173329, -1.129092>, <2.127015, 1.217883, -1.131890>, <2.129497, 1.275742, -1.148069>, <2.131288, 1.319633, -1.156202>, 
      <2.137699, 1.184523, -1.094212>, <2.139395, 1.229077, -1.097010>, <2.142427, 1.284231, -1.110418>, <2.144218, 1.328123, -1.118551>, 
      <2.134213, 1.201451, -1.043380>, <2.134100, 1.242538, -1.042792>, <2.131288, 1.297422, -1.057859>, <2.131288, 1.338190, -1.063009>, 
      <2.131288, 1.212461, -1.006428>, <2.131176, 1.253548, -1.005840>, <2.131288, 1.307586, -1.018444>, <2.131288, 1.348353, -1.023593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.125318, 1.173329, -1.129092>, <2.111293, 1.160649, -1.168605>, <2.071934, 1.143083, -1.211213>, <2.046279, 1.135604, -1.245921>, 
      <2.127015, 1.217883, -1.131890>, <2.112989, 1.205203, -1.171403>, <2.071781, 1.190541, -1.215302>, <2.046126, 1.183063, -1.250010>, 
      <2.129497, 1.275742, -1.148069>, <2.115322, 1.266435, -1.189344>, <2.073626, 1.248765, -1.231313>, <2.045524, 1.244963, -1.265766>, 
      <2.131288, 1.319633, -1.156202>, <2.117113, 1.310326, -1.197477>, <2.073303, 1.295633, -1.239818>, <2.045200, 1.291831, -1.274271>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.911168, 1.299276, -0.711791>, <1.953293, 1.292855, -0.740117>, <2.009193, 1.284727, -0.779454>, <2.045200, 1.274075, -0.814212>, 
      <1.911168, 1.240409, -0.709568>, <1.953292, 1.233988, -0.737893>, <2.009193, 1.224842, -0.775440>, <2.045200, 1.214190, -0.810198>, 
      <1.858990, 1.128252, -0.719875>, <1.900977, 1.116902, -0.749932>, <1.952800, 1.102364, -0.791675>, <1.988901, 1.092940, -0.829132>, 
      <1.911168, 1.102925, -0.709568>, <1.953155, 1.091575, -0.739625>, <2.009099, 1.083525, -0.782846>, <2.045200, 1.074102, -0.820303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.911170, 1.424846, -0.721727>, <1.954257, 1.416856, -0.754465>, <2.006700, 1.404261, -0.803960>, <2.045201, 1.395681, -0.841858>, 
      <1.911169, 1.387175, -0.718746>, <1.954257, 1.379185, -0.751485>, <2.006700, 1.367779, -0.795667>, <2.045201, 1.359199, -0.833564>, 
      <1.911168, 1.337038, -0.713217>, <1.953293, 1.330617, -0.741543>, <2.009193, 1.322056, -0.781956>, <2.045200, 1.311404, -0.816714>, 
      <1.911168, 1.299276, -0.711791>, <1.953293, 1.292855, -0.740117>, <2.009193, 1.284727, -0.779454>, <2.045200, 1.274075, -0.814212>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.912418, 1.111267, -1.417116>, <1.961554, 1.121043, -1.374763>, <2.007856, 1.124404, -1.297901>, <2.046279, 1.135604, -1.245921>, 
      <1.912614, 1.053059, -1.411711>, <1.961749, 1.062836, -1.369358>, <2.008028, 1.071038, -1.293304>, <2.046451, 1.082239, -1.241324>, 
      <1.884372, 0.961059, -1.363526>, <1.929609, 0.971374, -1.324567>, <1.974391, 0.975144, -1.263802>, <2.011622, 0.986813, -1.217452>, 
      <1.912418, 0.918092, -1.391538>, <1.957655, 0.928408, -1.352579>, <2.009048, 0.945392, -1.291780>, <2.046279, 0.957060, -1.245430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.912418, 1.111267, -1.417116>, <1.912238, 1.164682, -1.422076>, <1.911543, 1.236279, -1.423375>, <1.911168, 1.289855, -1.426058>, 
      <1.961554, 1.121043, -1.374763>, <1.961374, 1.174458, -1.379723>, <1.956337, 1.236930, -1.382342>, <1.955962, 1.290506, -1.385024>, 
      <2.007856, 1.124404, -1.297901>, <2.007703, 1.171862, -1.301990>, <2.007263, 1.239787, -1.312671>, <2.006940, 1.286655, -1.321176>, 
      <2.046279, 1.135604, -1.245921>, <2.046126, 1.183063, -1.250010>, <2.045524, 1.244963, -1.265766>, <2.045200, 1.291831, -1.274271>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.766979, 1.316485, -0.627130>, <1.807758, 1.313598, -0.656653>, <1.869653, 1.305604, -0.683875>, <1.911168, 1.299276, -0.711791>, 
      <1.766979, 1.266326, -0.625560>, <1.807758, 1.263439, -0.655083>, <1.869652, 1.246737, -0.681652>, <1.911168, 1.240409, -0.709568>, 
      <1.724147, 1.173999, -0.629762>, <1.765763, 1.159863, -0.658691>, <1.817202, 1.139548, -0.689961>, <1.858990, 1.128252, -0.719875>, 
      <1.766979, 1.149312, -0.621134>, <1.808595, 1.135176, -0.650063>, <1.869381, 1.114221, -0.679654>, <1.911168, 1.102925, -0.709568>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.766979, 1.447274, -0.630462>, <1.809824, 1.439162, -0.658114>, <1.870498, 1.432388, -0.690824>, <1.911170, 1.424846, -0.721727>, 
      <1.766979, 1.408037, -0.629462>, <1.809824, 1.399926, -0.657114>, <1.870497, 1.394717, -0.687843>, <1.911169, 1.387175, -0.718746>, 
      <1.766979, 1.355715, -0.628358>, <1.807758, 1.352829, -0.657881>, <1.869653, 1.343366, -0.685301>, <1.911168, 1.337038, -0.713217>, 
      <1.766979, 1.316485, -0.627130>, <1.807758, 1.313598, -0.656653>, <1.869653, 1.305604, -0.683875>, <1.911168, 1.299276, -0.711791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.768480, 1.080332, -1.485375>, <1.768239, 1.143538, -1.492506>, <1.767429, 1.225550, -1.516008>, <1.766979, 1.287786, -1.529136>, 
      <1.811053, 1.089958, -1.463812>, <1.810813, 1.153164, -1.470943>, <1.808856, 1.227280, -1.482712>, <1.808406, 1.289516, -1.495840>, 
      <1.875954, 1.104012, -1.448547>, <1.875775, 1.157427, -1.453506>, <1.872334, 1.235709, -1.459293>, <1.871959, 1.289285, -1.461976>, 
      <1.912418, 1.111267, -1.417116>, <1.912238, 1.164682, -1.422076>, <1.911543, 1.236279, -1.423375>, <1.911168, 1.289855, -1.426058>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.768480, 1.080332, -1.485375>, <1.735696, 1.072919, -1.501980>, <1.695876, 1.060699, -1.531074>, <1.661343, 1.054497, -1.544283>, 
      <1.768239, 1.143538, -1.492506>, <1.735456, 1.136125, -1.509111>, <1.695572, 1.131273, -1.545355>, <1.661039, 1.125071, -1.558564>, 
      <1.767429, 1.225550, -1.516008>, <1.733226, 1.224121, -1.543498>, <1.697098, 1.213867, -1.579437>, <1.660136, 1.211893, -1.603049>, 
      <1.766979, 1.287786, -1.529136>, <1.732775, 1.286357, -1.556626>, <1.696580, 1.281323, -1.604622>, <1.659618, 1.279348, -1.628234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.768480, 1.080332, -1.485375>, <1.811053, 1.089958, -1.463812>, <1.875954, 1.104012, -1.448547>, <1.912418, 1.111267, -1.417116>, 
      <1.768692, 1.024699, -1.479099>, <1.811265, 1.034325, -1.457536>, <1.876150, 1.045804, -1.443142>, <1.912614, 1.053059, -1.411711>, 
      <1.744804, 0.935121, -1.455364>, <1.788572, 0.942029, -1.428243>, <1.845582, 0.952213, -1.396933>, <1.884372, 0.961059, -1.363526>, 
      <1.768479, 0.893713, -1.484677>, <1.812247, 0.900621, -1.457557>, <1.873628, 0.909247, -1.424945>, <1.912418, 0.918092, -1.391538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.768480, 1.080332, -1.485375>, <1.768692, 1.024699, -1.479099>, <1.744804, 0.935121, -1.455364>, <1.768479, 0.893713, -1.484677>, 
      <1.735696, 1.072919, -1.501980>, <1.735908, 1.017287, -1.495703>, <1.713227, 0.930138, -1.474930>, <1.736902, 0.888729, -1.504243>, 
      <1.695876, 1.060699, -1.531074>, <1.696098, 1.008932, -1.520599>, <1.679795, 0.920844, -1.506138>, <1.697153, 0.881177, -1.536384>, 
      <1.661343, 1.054497, -1.544283>, <1.661566, 1.002730, -1.533808>, <1.643985, 0.918132, -1.516866>, <1.661343, 0.878465, -1.547112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.659618, 1.317082, -0.529674>, <1.659618, 1.278584, -0.526331>, <1.628850, 1.210108, -0.543312>, <1.659618, 1.188370, -0.534704>, 
      <1.633922, 1.316748, -0.511266>, <1.633922, 1.278250, -0.507923>, <1.601997, 1.216859, -0.523551>, <1.632765, 1.195121, -0.514943>, 
      <1.596116, 1.314359, -0.489963>, <1.596116, 1.280094, -0.488726>, <1.578273, 1.224339, -0.493196>, <1.597783, 1.198103, -0.482866>, 
      <1.565357, 1.313861, -0.482692>, <1.565357, 1.279595, -0.481455>, <1.545847, 1.226236, -0.483090>, <1.565357, 1.200000, -0.472760>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.659618, 1.317082, -0.529674>, <1.694978, 1.317542, -0.555005>, <1.731802, 1.318975, -0.601663>, <1.766979, 1.316485, -0.627130>, 
      <1.659618, 1.278584, -0.526331>, <1.694978, 1.279044, -0.551662>, <1.731802, 1.268816, -0.600092>, <1.766979, 1.266326, -0.625560>, 
      <1.628850, 1.210108, -0.543312>, <1.662776, 1.201579, -0.568278>, <1.690156, 1.185545, -0.606133>, <1.724147, 1.173999, -0.629762>, 
      <1.659618, 1.188370, -0.534704>, <1.693544, 1.179841, -0.559670>, <1.732988, 1.160858, -0.597506>, <1.766979, 1.149312, -0.621134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.659619, 1.472470, -0.559377>, <1.691002, 1.466268, -0.582310>, <1.734318, 1.453457, -0.609383>, <1.766979, 1.447274, -0.630462>, 
      <1.659619, 1.425854, -0.550466>, <1.691002, 1.419651, -0.573399>, <1.734318, 1.414221, -0.608383>, <1.766979, 1.408037, -0.629462>, 
      <1.659618, 1.364365, -0.533780>, <1.694978, 1.364825, -0.559111>, <1.731802, 1.358205, -0.602891>, <1.766979, 1.355715, -0.628358>, 
      <1.659618, 1.317082, -0.529674>, <1.694978, 1.317542, -0.555005>, <1.731802, 1.318975, -0.601663>, <1.766979, 1.316485, -0.627130>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.659619, 1.472470, -0.559377>, <1.659619, 1.425854, -0.550466>, <1.659618, 1.364365, -0.533780>, <1.659618, 1.317082, -0.529674>, 
      <1.630408, 1.478243, -0.538032>, <1.630408, 1.431627, -0.529121>, <1.633922, 1.364030, -0.515372>, <1.633922, 1.316748, -0.511266>, 
      <1.599482, 1.484605, -0.496222>, <1.599482, 1.432627, -0.496090>, <1.596116, 1.366304, -0.491839>, <1.596116, 1.314359, -0.489963>, 
      <1.565357, 1.487121, -0.483130>, <1.565357, 1.435143, -0.482999>, <1.565357, 1.365805, -0.484568>, <1.565357, 1.313861, -0.482692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.261616, 0.872664, -1.576298>, <1.201762, 0.877754, -1.571094>, <1.120509, 0.875341, -1.564370>, <1.062876, 0.879347, -1.547112>, 
      <1.217611, 0.754445, -1.672087>, <1.157757, 0.759535, -1.666883>, <1.068067, 0.755025, -1.658619>, <1.010434, 0.759031, -1.641361>, 
      <1.148636, 0.677590, -1.873124>, <1.077331, 0.687155, -1.856283>, <0.993783, 0.672063, -1.852243>, <0.921908, 0.674807, -1.835333>, 
      <1.089713, 0.569861, -1.973176>, <1.018408, 0.579427, -1.956335>, <0.919488, 0.562620, -1.945041>, <0.847613, 0.565364, -1.928130>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.260065, 1.027513, -1.602357>, <1.198748, 1.033100, -1.590447>, <1.119024, 1.045357, -1.566379>, <1.061194, 1.055374, -1.544283>, 
      <1.260142, 0.983332, -1.586004>, <1.198825, 0.988919, -1.574095>, <1.119145, 0.993589, -1.555903>, <1.061315, 1.003606, -1.533807>, 
      <1.274704, 0.907826, -1.547808>, <1.214851, 0.912916, -1.542604>, <1.137651, 0.914669, -1.533562>, <1.080018, 0.918675, -1.516304>, 
      <1.261616, 0.872664, -1.576298>, <1.201762, 0.877754, -1.571094>, <1.120509, 0.875341, -1.564370>, <1.062876, 0.879347, -1.547112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.260916, 1.273545, -1.724677>, <1.197783, 1.275404, -1.704300>, <1.117845, 1.277594, -1.663896>, <1.061937, 1.280232, -1.628234>, 
      <1.260661, 1.199735, -1.687981>, <1.197527, 1.201594, -1.667604>, <1.117622, 1.210137, -1.638711>, <1.061714, 1.212775, -1.603049>, 
      <1.259930, 1.104816, -1.630970>, <1.198613, 1.110403, -1.619060>, <1.118858, 1.115932, -1.580661>, <1.061029, 1.125949, -1.558564>, 
      <1.260065, 1.027513, -1.602357>, <1.198748, 1.033100, -1.590447>, <1.119024, 1.045357, -1.566379>, <1.061194, 1.055374, -1.544283>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.398557, 0.850799, -1.576298>, <1.356957, 0.851235, -1.576298>, <1.302914, 0.869152, -1.579889>, <1.261616, 0.872664, -1.576298>, 
      <1.385282, 0.892867, -1.543467>, <1.343681, 0.893303, -1.543467>, <1.316003, 0.904314, -1.551398>, <1.274704, 0.907826, -1.547808>, 
      <1.364835, 0.976459, -1.584130>, <1.334799, 0.976771, -1.584130>, <1.289512, 0.980656, -1.591709>, <1.260142, 0.983332, -1.586004>, 
      <1.360191, 1.028131, -1.602357>, <1.330154, 1.028443, -1.602357>, <1.289435, 1.024837, -1.608062>, <1.260065, 1.027513, -1.602357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.398557, 0.850799, -1.576298>, <1.418676, 0.850588, -1.576298>, <1.442760, 0.868462, -1.578507>, <1.462649, 0.870556, -1.576298>, 
      <1.385282, 0.892867, -1.543467>, <1.405401, 0.892656, -1.543467>, <1.426910, 0.906856, -1.556281>, <1.446799, 0.908949, -1.554072>, 
      <1.364835, 0.976459, -1.584130>, <1.395582, 0.976140, -1.584130>, <1.432763, 0.978596, -1.591806>, <1.462844, 0.981229, -1.586005>, 
      <1.360191, 1.028131, -1.602357>, <1.390938, 1.027812, -1.602357>, <1.432568, 1.022775, -1.608158>, <1.462649, 1.025409, -1.602357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.398557, 0.850799, -1.576298>, <1.432645, 0.742780, -1.660600>, <1.471036, 0.683828, -1.855302>, <1.500638, 0.583077, -1.949694>, 
      <1.418676, 0.850588, -1.576298>, <1.452764, 0.742569, -1.660600>, <1.529335, 0.647704, -1.848833>, <1.558936, 0.546954, -1.943225>, 
      <1.442760, 0.868462, -1.578507>, <1.501972, 0.725034, -1.661538>, <1.560502, 0.608114, -1.811523>, <1.631195, 0.486174, -1.916904>, 
      <1.462649, 0.870556, -1.576298>, <1.521861, 0.727128, -1.659329>, <1.624274, 0.584606, -1.822749>, <1.694966, 0.462666, -1.928130>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.398557, 0.850799, -1.576298>, <1.344237, 0.750283, -1.708055>, <1.261310, 0.635991, -1.897019>, <1.217489, 0.515745, -2.015488>, 
      <1.356957, 0.851235, -1.576298>, <1.302636, 0.750719, -1.708055>, <1.222977, 0.652226, -1.884326>, <1.179156, 0.531980, -2.002794>, 
      <1.302914, 0.869152, -1.579889>, <1.258910, 0.750933, -1.675677>, <1.190635, 0.671956, -1.883044>, <1.131712, 0.564227, -1.983096>, 
      <1.261616, 0.872664, -1.576298>, <1.217611, 0.754445, -1.672087>, <1.148636, 0.677590, -1.873124>, <1.089713, 0.569861, -1.973176>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.360749, 1.271433, -1.724677>, <1.360582, 1.198443, -1.687981>, <1.353291, 1.104899, -1.629437>, <1.360191, 1.028131, -1.602357>, 
      <1.330794, 1.271749, -1.724677>, <1.330627, 1.198759, -1.687981>, <1.323254, 1.105211, -1.629437>, <1.330154, 1.028443, -1.602357>, 
      <1.289413, 1.272706, -1.733875>, <1.289158, 1.198896, -1.697179>, <1.289300, 1.102140, -1.636674>, <1.289435, 1.024837, -1.608062>, 
      <1.260916, 1.273545, -1.724677>, <1.260661, 1.199735, -1.687981>, <1.259930, 1.104816, -1.630970>, <1.260065, 1.027513, -1.602357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.360749, 1.271433, -1.724677>, <1.390786, 1.271116, -1.724677>, <1.432298, 1.270676, -1.733899>, <1.460876, 1.271433, -1.724677>, 
      <1.360582, 1.198443, -1.687981>, <1.390618, 1.198125, -1.687981>, <1.432830, 1.196869, -1.697203>, <1.461408, 1.197626, -1.687981>, 
      <1.353291, 1.104899, -1.629437>, <1.384037, 1.104580, -1.629437>, <1.432226, 1.100077, -1.636770>, <1.462307, 1.102711, -1.630969>, 
      <1.360191, 1.028131, -1.602357>, <1.390938, 1.027812, -1.602357>, <1.432568, 1.022775, -1.608158>, <1.462649, 1.025409, -1.602357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.360749, 1.271433, -1.724677>, <1.330794, 1.271749, -1.724677>, <1.289413, 1.272706, -1.733875>, <1.260916, 1.273545, -1.724677>, 
      <1.360582, 1.198443, -1.687981>, <1.330627, 1.198759, -1.687981>, <1.289158, 1.198896, -1.697179>, <1.260661, 1.199735, -1.687981>, 
      <1.360358, 1.101122, -1.639053>, <1.330322, 1.101434, -1.639053>, <1.289300, 1.102140, -1.636674>, <1.259930, 1.104816, -1.630970>, 
      <1.360191, 1.028131, -1.602357>, <1.330154, 1.028443, -1.602357>, <1.289435, 1.024837, -1.608062>, <1.260065, 1.027513, -1.602357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.360749, 1.271433, -1.724677>, <1.360582, 1.198443, -1.687981>, <1.360358, 1.101122, -1.639053>, <1.360191, 1.028131, -1.602357>, 
      <1.390786, 1.271116, -1.724677>, <1.390618, 1.198125, -1.687981>, <1.391105, 1.100802, -1.639053>, <1.390938, 1.027812, -1.602357>, 
      <1.432298, 1.270676, -1.733899>, <1.432830, 1.196869, -1.697203>, <1.432226, 1.100077, -1.636770>, <1.432568, 1.022775, -1.608158>, 
      <1.460876, 1.271433, -1.724677>, <1.461408, 1.197626, -1.687981>, <1.462307, 1.102711, -1.630969>, <1.462649, 1.025409, -1.602357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.342543, 1.487121, -0.483130>, <1.342543, 1.487121, -0.535366>, <1.369612, 1.368092, -0.483189>, <1.376375, 1.316330, -0.481301>, 
      <1.378043, 1.487121, -0.483130>, <1.378043, 1.487121, -0.535366>, <1.394975, 1.367863, -0.483318>, <1.401738, 1.316101, -0.481430>, 
      <1.425376, 1.487122, -0.483130>, <1.425375, 1.435144, -0.482999>, <1.435513, 1.366137, -0.484381>, <1.435513, 1.314192, -0.482505>, 
      <1.460876, 1.487122, -0.483130>, <1.460875, 1.435144, -0.482999>, <1.460874, 1.365806, -0.484568>, <1.460874, 1.313861, -0.482692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.342543, 1.487121, -0.483130>, <1.378043, 1.487121, -0.483130>, <1.425376, 1.487122, -0.483130>, <1.460876, 1.487122, -0.483130>, 
      <1.342543, 1.487121, -0.535366>, <1.378043, 1.487121, -0.535366>, <1.425375, 1.435144, -0.482999>, <1.460875, 1.435144, -0.482999>, 
      <1.369612, 1.368092, -0.483189>, <1.394975, 1.367863, -0.483318>, <1.435513, 1.366137, -0.484381>, <1.460874, 1.365806, -0.484568>, 
      <1.376375, 1.316330, -0.481301>, <1.401738, 1.316101, -0.481430>, <1.435513, 1.314192, -0.482505>, <1.460874, 1.313861, -0.482692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.342543, 1.487121, -0.483130>, <1.342543, 1.487121, -0.535366>, <1.369612, 1.368092, -0.483189>, <1.376375, 1.316330, -0.481301>, 
      <1.315217, 1.487746, -0.483130>, <1.315217, 1.487746, -0.535366>, <1.334114, 1.368413, -0.483009>, <1.340877, 1.316651, -0.481120>, 
      <1.278788, 1.489003, -0.483130>, <1.280765, 1.436950, -0.482689>, <1.291750, 1.367912, -0.483432>, <1.293544, 1.315885, -0.481552>, 
      <1.251455, 1.489204, -0.483130>, <1.253432, 1.437151, -0.482689>, <1.256251, 1.367722, -0.483539>, <1.258045, 1.315694, -0.481660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.342543, 1.487121, -0.483130>, <1.342543, 1.487121, -0.535366>, <1.369612, 1.368092, -0.483189>, <1.376375, 1.316330, -0.481301>, 
      <1.315217, 1.487746, -0.483130>, <1.315217, 1.487746, -0.535366>, <1.334114, 1.368413, -0.483009>, <1.340877, 1.316651, -0.481120>, 
      <1.278788, 1.489003, -0.483130>, <1.280765, 1.436950, -0.482689>, <1.291750, 1.367912, -0.483432>, <1.293544, 1.315885, -0.481552>, 
      <1.251455, 1.489204, -0.483130>, <1.253432, 1.437151, -0.482689>, <1.256251, 1.367722, -0.483539>, <1.258045, 1.315694, -0.481660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.379686, 1.202844, -0.472760>, <1.383761, 1.234430, -0.485105>, <1.380797, 1.282484, -0.480066>, <1.376375, 1.316330, -0.481301>, 
      <1.344188, 1.203220, -0.472760>, <1.348263, 1.234806, -0.485105>, <1.345300, 1.282804, -0.479886>, <1.340877, 1.316651, -0.481120>, 
      <1.296855, 1.202332, -0.472760>, <1.305679, 1.233295, -0.484277>, <1.294722, 1.281734, -0.480319>, <1.293544, 1.315885, -0.481552>, 
      <1.261356, 1.202113, -0.472760>, <1.270180, 1.233075, -0.484277>, <1.259223, 1.281543, -0.480426>, <1.258045, 1.315694, -0.481660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.379686, 1.202844, -0.472760>, <1.344188, 1.203220, -0.472760>, <1.296855, 1.202332, -0.472760>, <1.261356, 1.202113, -0.472760>, 
      <1.383761, 1.234430, -0.485105>, <1.348263, 1.234806, -0.485105>, <1.305679, 1.233295, -0.484277>, <1.270180, 1.233075, -0.484277>, 
      <1.380797, 1.282484, -0.480066>, <1.345300, 1.282804, -0.479886>, <1.294722, 1.281734, -0.480319>, <1.259223, 1.281543, -0.480426>, 
      <1.376375, 1.316330, -0.481301>, <1.340877, 1.316651, -0.481120>, <1.293544, 1.315885, -0.481552>, <1.258045, 1.315694, -0.481660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.379686, 1.202844, -0.472760>, <1.360119, 1.051179, -0.413484>, <1.322828, 0.859540, -0.313514>, <1.298460, 0.712409, -0.245266>, 
      <1.344188, 1.203220, -0.472760>, <1.324621, 1.051555, -0.413484>, <1.256040, 0.852594, -0.312253>, <1.231672, 0.705463, -0.244004>, 
      <1.296855, 1.202332, -0.472760>, <1.250520, 1.039749, -0.412285>, <1.169513, 0.854300, -0.296787>, <1.143917, 0.684686, -0.243745>, 
      <1.261356, 1.202113, -0.472760>, <1.215021, 1.039530, -0.412285>, <1.102522, 0.849782, -0.298308>, <1.076926, 0.680168, -0.245266>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.379686, 1.202844, -0.472760>, <1.360119, 1.051179, -0.413484>, <1.308046, 0.868656, -0.294195>, <1.298460, 0.712409, -0.245266>, 
      <1.344188, 1.203220, -0.472760>, <1.324621, 1.051555, -0.413484>, <1.241258, 0.861710, -0.292933>, <1.231672, 0.705463, -0.244004>, 
      <1.296855, 1.202332, -0.472760>, <1.250520, 1.039749, -0.412285>, <1.169513, 0.854300, -0.296787>, <1.143917, 0.684686, -0.243745>, 
      <1.261356, 1.202113, -0.472760>, <1.215021, 1.039530, -0.412285>, <1.102522, 0.849782, -0.298308>, <1.076926, 0.680168, -0.245266>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.379686, 1.202844, -0.472760>, <1.383761, 1.234430, -0.485105>, <1.380797, 1.282484, -0.480066>, <1.376375, 1.316330, -0.481301>, 
      <1.404056, 1.202586, -0.472760>, <1.408131, 1.234172, -0.485105>, <1.406160, 1.282254, -0.480195>, <1.401738, 1.316101, -0.481430>, 
      <1.436505, 1.200373, -0.472760>, <1.425321, 1.230513, -0.484683>, <1.435513, 1.279927, -0.481268>, <1.435513, 1.314192, -0.482505>, 
      <1.460874, 1.200000, -0.472760>, <1.449689, 1.230140, -0.484683>, <1.460874, 1.279595, -0.481455>, <1.460874, 1.313861, -0.482692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.379686, 1.202844, -0.472760>, <1.383761, 1.234430, -0.485105>, <1.380797, 1.282484, -0.480066>, <1.376375, 1.316330, -0.481301>, 
      <1.404056, 1.202586, -0.472760>, <1.408131, 1.234172, -0.485105>, <1.406160, 1.282254, -0.480195>, <1.401738, 1.316101, -0.481430>, 
      <1.436505, 1.200373, -0.472760>, <1.425321, 1.230513, -0.484683>, <1.435513, 1.279927, -0.481268>, <1.435513, 1.314192, -0.482505>, 
      <1.460874, 1.200000, -0.472760>, <1.449689, 1.230140, -0.484683>, <1.460874, 1.279595, -0.481455>, <1.460874, 1.313861, -0.482692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.379686, 1.202844, -0.472760>, <1.360119, 1.051179, -0.413484>, <1.322828, 0.859540, -0.313514>, <1.298460, 0.712409, -0.245266>, 
      <1.404056, 1.202586, -0.472760>, <1.384489, 1.050920, -0.413484>, <1.434978, 0.871202, -0.315633>, <1.410610, 0.724072, -0.247385>, 
      <1.436505, 1.200373, -0.472760>, <1.490229, 1.055603, -0.415489>, <1.531003, 0.893750, -0.298666>, <1.560354, 0.737769, -0.254698>, 
      <1.460874, 1.200000, -0.472760>, <1.514597, 1.055230, -0.415489>, <1.643678, 0.898140, -0.300494>, <1.673029, 0.742159, -0.256526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.379686, 1.202844, -0.472760>, <1.404056, 1.202586, -0.472760>, <1.436505, 1.200373, -0.472760>, <1.460874, 1.200000, -0.472760>, 
      <1.360119, 1.051179, -0.413484>, <1.384489, 1.050920, -0.413484>, <1.490229, 1.055603, -0.415489>, <1.514597, 1.055230, -0.415489>, 
      <1.308046, 0.868656, -0.294195>, <1.420197, 0.880319, -0.296314>, <1.531003, 0.893750, -0.298666>, <1.643678, 0.898140, -0.300494>, 
      <1.298460, 0.712409, -0.245266>, <1.410610, 0.724072, -0.247385>, <1.560354, 0.737769, -0.254698>, <1.673029, 0.742159, -0.256526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.153564, 1.315132, -0.481976>, <1.151771, 1.367134, -0.483854>, <1.148951, 1.436531, -0.482784>, <1.146974, 1.488559, -0.483130>, 
      <1.184045, 1.314802, -0.474674>, <1.182251, 1.366804, -0.476552>, <1.178132, 1.438864, -0.471580>, <1.176155, 1.490892, -0.471927>, 
      <1.226701, 1.315525, -0.481755>, <1.224906, 1.367553, -0.483634>, <1.222088, 1.437382, -0.482689>, <1.220111, 1.489435, -0.483130>, 
      <1.258045, 1.315694, -0.481660>, <1.256251, 1.367722, -0.483539>, <1.253432, 1.437151, -0.482689>, <1.251455, 1.489204, -0.483130>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.156875, 1.201468, -0.472760>, <1.172668, 1.230088, -0.482902>, <1.154743, 1.280949, -0.480741>, <1.153564, 1.315132, -0.481976>, 
      <1.186742, 1.203401, -0.463448>, <1.202536, 1.232020, -0.473590>, <1.185224, 1.280619, -0.473439>, <1.184045, 1.314802, -0.474674>, 
      <1.230012, 1.201919, -0.472760>, <1.238836, 1.232882, -0.484277>, <1.227879, 1.281375, -0.480521>, <1.226701, 1.315525, -0.481755>, 
      <1.261356, 1.202113, -0.472760>, <1.270180, 1.233075, -0.484277>, <1.259223, 1.281543, -0.480426>, <1.258045, 1.315694, -0.481660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.156875, 1.201468, -0.472760>, <1.186742, 1.203401, -0.463448>, <1.230012, 1.201919, -0.472760>, <1.261356, 1.202113, -0.472760>, 
      <1.064491, 1.034055, -0.413431>, <1.094358, 1.035988, -0.404119>, <1.183677, 1.039336, -0.412285>, <1.215021, 1.039530, -0.412285>, 
      <0.856298, 0.863434, -0.312712>, <0.938364, 0.867164, -0.306336>, <1.020332, 0.844239, -0.300174>, <1.102522, 0.849782, -0.298308>, 
      <0.802501, 0.678960, -0.256526>, <0.884567, 0.682690, -0.250150>, <0.994736, 0.674625, -0.247132>, <1.076926, 0.680168, -0.245266>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.062688, 1.189257, -0.534704>, <1.089499, 1.196173, -0.514943>, <1.124462, 1.199370, -0.482866>, <1.156875, 1.201468, -0.472760>, 
      <0.924807, 1.011079, -0.469321>, <0.951618, 1.017995, -0.449560>, <1.032077, 1.031958, -0.423538>, <1.064491, 1.034055, -0.413431>, 
      <0.571202, 0.869475, -0.380938>, <0.648201, 0.872735, -0.374057>, <0.779235, 0.859932, -0.318700>, <0.856298, 0.863434, -0.312712>, 
      <0.547345, 0.656098, -0.286414>, <0.624344, 0.659358, -0.279533>, <0.725438, 0.675457, -0.262514>, <0.802501, 0.678960, -0.256526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.955571, 1.149537, -0.621134>, <0.989490, 1.161292, -0.597506>, <1.028816, 1.180519, -0.559670>, <1.062688, 1.189257, -0.534704>, 
      <0.741259, 0.967582, -0.535176>, <0.775178, 0.979337, -0.511548>, <0.890935, 1.002340, -0.494287>, <0.924807, 1.011079, -0.469321>, 
      <0.351936, 0.855471, -0.421642>, <0.463451, 0.840213, -0.405802>, <0.458091, 0.864686, -0.391046>, <0.571202, 0.869475, -0.380938>, 
      <0.169429, 0.652158, -0.313101>, <0.280944, 0.636900, -0.297260>, <0.434233, 0.651309, -0.296522>, <0.547345, 0.656098, -0.286414>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.811670, 1.102261, -0.709568>, <0.853387, 1.113815, -0.679654>, <0.914042, 1.135144, -0.650064>, <0.955571, 1.149537, -0.621134>, 
      <0.374916, 0.964175, -0.636628>, <0.416633, 0.975729, -0.606714>, <0.699731, 0.953189, -0.564106>, <0.741259, 0.967582, -0.535176>, 
      <-0.313727, 1.053395, -0.610910>, <-0.052978, 1.038717, -0.557672>, <0.090441, 0.891249, -0.458787>, <0.351936, 0.855471, -0.421642>, 
      <-0.689158, 0.825279, -0.462057>, <-0.428409, 0.810601, -0.408819>, <-0.092066, 0.687936, -0.350246>, <0.169429, 0.652158, -0.313101>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.677819, 1.072611, -0.820303>, <0.713861, 1.082257, -0.782845>, <0.769754, 1.090652, -0.739625>, <0.811670, 1.102261, -0.709568>, 
      <0.123391, 0.913205, -0.755825>, <0.159433, 0.922851, -0.718367>, <0.333000, 0.952566, -0.666685>, <0.374916, 0.964175, -0.636628>, 
      <-0.714435, 0.964716, -0.777279>, <-0.570272, 0.996371, -0.704136>, <-0.474879, 1.062466, -0.643813>, <-0.313727, 1.053395, -0.610910>, 
      <-1.213214, 0.729988, -0.595400>, <-1.069052, 0.761643, -0.522258>, <-0.850309, 0.834350, -0.494960>, <-0.689158, 0.825279, -0.462057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.615886, 1.049862, -0.913039>, <0.628685, 1.057521, -0.882326>, <0.654543, 1.066381, -0.844494>, <0.677819, 1.072611, -0.820303>, 
      <0.039422, 0.885526, -0.881823>, <0.052221, 0.893185, -0.851110>, <0.100115, 0.906975, -0.780015>, <0.123391, 0.913205, -0.755825>, 
      <-0.800836, 0.926913, -0.832224>, <-0.773167, 0.943470, -0.765829>, <-0.779031, 0.950533, -0.810052>, <-0.714435, 0.964716, -0.777279>, 
      <-1.347100, 0.680811, -0.795872>, <-1.319431, 0.697368, -0.729478>, <-1.277810, 0.715804, -0.628174>, <-1.213214, 0.729988, -0.595400>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.591158, 1.020752, -1.028254>, <0.201859, 0.917663, -1.041373>, <-0.346927, 0.938008, -1.048982>, <-0.741847, 0.858126, -1.052292>, 
      <0.592871, 1.029304, -0.992900>, <0.203572, 0.926215, -1.006019>, <-0.528828, 0.906821, -0.961479>, <-0.923747, 0.826939, -0.964789>, 
      <0.602236, 1.041693, -0.945795>, <0.025771, 0.877357, -0.914579>, <-0.619260, 0.980108, -0.909150>, <-1.165524, 0.734005, -0.872798>, 
      <0.615886, 1.049862, -0.913039>, <0.039422, 0.885526, -0.881823>, <-0.800836, 0.926913, -0.832224>, <-1.347100, 0.680811, -0.795872>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.605128, 0.996161, -1.135040>, <0.320541, 0.901553, -1.172654>, <-0.089875, 0.915352, -1.238512>, <-0.383324, 0.846052, -1.259499>, 
      <0.593339, 1.005065, -1.105375>, <0.308752, 0.910457, -1.142989>, <-0.188113, 0.934365, -1.164800>, <-0.481562, 0.865066, -1.185787>, 
      <0.589599, 1.012969, -1.060430>, <0.200299, 0.909880, -1.073549>, <-0.236245, 0.956984, -1.102227>, <-0.631164, 0.877103, -1.105536>, 
      <0.591158, 1.020752, -1.028254>, <0.201859, 0.917663, -1.041373>, <-0.346927, 0.938008, -1.048982>, <-0.741847, 0.858126, -1.052292>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.677462, 0.955565, -1.245430>, <0.478498, 0.838989, -1.336790>, <0.171195, 0.812496, -1.490613>, <-0.043773, 0.723015, -1.576084>, 
      <0.652202, 0.965200, -1.214044>, <0.453238, 0.848624, -1.305404>, <0.055104, 0.840353, -1.409953>, <-0.159864, 0.750873, -1.495424>, 
      <0.619863, 0.985031, -1.172120>, <0.335276, 0.890423, -1.209735>, <0.024015, 0.893308, -1.323968>, <-0.269435, 0.824009, -1.344955>, 
      <0.605128, 0.996161, -1.135040>, <0.320541, 0.901553, -1.172654>, <-0.089875, 0.915352, -1.238512>, <-0.383324, 0.846052, -1.259499>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.811561, 0.917423, -1.391538>, <0.677076, 0.802183, -1.477880>, <0.451416, 0.780416, -1.649532>, <0.307578, 0.680259, -1.739537>, 
      <0.766261, 0.927459, -1.352579>, <0.631776, 0.812219, -1.438921>, <0.346320, 0.802593, -1.603247>, <0.202482, 0.702437, -1.693251>, 
      <0.714406, 0.941474, -1.291334>, <0.515442, 0.824898, -1.382694>, <0.265433, 0.789882, -1.556090>, <0.050465, 0.700401, -1.641560>, 
      <0.677462, 0.955565, -1.245430>, <0.478498, 0.838989, -1.336790>, <0.171195, 0.812496, -1.490613>, <-0.043773, 0.723015, -1.576084>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.955648, 0.893933, -1.484677>, <0.864016, 0.769463, -1.578516>, <0.688796, 0.708549, -1.761251>, <0.591933, 0.588864, -1.856058>, 
      <0.911838, 0.900571, -1.457557>, <0.820205, 0.776100, -1.551396>, <0.599770, 0.727489, -1.730161>, <0.502907, 0.607805, -1.824968>, 
      <0.850405, 0.908817, -1.424945>, <0.715920, 0.793577, -1.511287>, <0.537842, 0.762177, -1.687596>, <0.394004, 0.662021, -1.777600>, 
      <0.811561, 0.917423, -1.391538>, <0.677076, 0.802183, -1.477880>, <0.451416, 0.780416, -1.649532>, <0.307578, 0.680259, -1.739537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.955648, 0.893933, -1.484677>, <0.987255, 0.889144, -1.504243>, <1.027050, 0.881837, -1.536384>, <1.062876, 0.879347, -1.547112>, 
      <0.864016, 0.769463, -1.578516>, <0.895623, 0.764674, -1.598082>, <0.974608, 0.761522, -1.630633>, <1.010434, 0.759031, -1.641361>, 
      <0.688796, 0.708549, -1.761251>, <0.762848, 0.692794, -1.787112>, <0.844084, 0.677778, -1.817022>, <0.921908, 0.674807, -1.835333>, 
      <0.591933, 0.588864, -1.856058>, <0.665985, 0.573109, -1.881919>, <0.769789, 0.568335, -1.909819>, <0.847613, 0.565364, -1.928130>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.613119, 1.239622, -0.902019>, <0.600117, 1.230132, -0.931447>, <0.591994, 1.220257, -0.975364>, <0.589578, 1.210694, -1.007424>, 
      <0.618196, 1.182878, -0.899423>, <0.605194, 1.173388, -0.928851>, <0.592687, 1.162941, -0.976185>, <0.590271, 1.153378, -1.008245>, 
      <0.670657, 1.065476, -0.916005>, <0.657006, 1.057307, -0.948761>, <0.648258, 1.043971, -0.991033>, <0.646545, 1.035419, -1.026388>, 
      <0.615886, 1.049862, -0.913039>, <0.602236, 1.041693, -0.945795>, <0.592871, 1.029304, -0.992900>, <0.591158, 1.020752, -1.028254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.613119, 1.239622, -0.902019>, <0.600117, 1.230132, -0.931447>, <0.591994, 1.220257, -0.975364>, <0.589578, 1.210694, -1.007424>, 
      <0.609210, 1.283307, -0.904017>, <0.596208, 1.273817, -0.933445>, <0.591499, 1.261231, -0.974778>, <0.589083, 1.251668, -1.006837>, 
      <0.594310, 1.338646, -0.920339>, <0.582379, 1.330682, -0.947214>, <0.587700, 1.313801, -0.989396>, <0.587929, 1.305630, -1.018742>, 
      <0.586249, 1.381085, -0.928191>, <0.574318, 1.373121, -0.955065>, <0.586993, 1.354488, -0.994247>, <0.587222, 1.346317, -1.023593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.674620, 1.272767, -0.814949>, <0.676067, 1.212789, -0.811832>, <0.735199, 1.089109, -0.826976>, <0.677819, 1.072611, -0.820303>, 
      <0.651168, 1.265666, -0.837778>, <0.652615, 1.205688, -0.834661>, <0.711922, 1.082879, -0.851167>, <0.654543, 1.066381, -0.844494>, 
      <0.626101, 1.249098, -0.872637>, <0.631178, 1.192354, -0.870042>, <0.683456, 1.073135, -0.885292>, <0.628685, 1.057521, -0.882326>, 
      <0.613119, 1.239622, -0.902019>, <0.618196, 1.182878, -0.899423>, <0.670657, 1.065476, -0.916005>, <0.615886, 1.049862, -0.913039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.669885, 1.401498, -0.837396>, <0.671306, 1.362879, -0.830662>, <0.673675, 1.311930, -0.816984>, <0.674620, 1.272767, -0.814949>, 
      <0.642851, 1.395926, -0.862834>, <0.644272, 1.357306, -0.856100>, <0.650223, 1.304830, -0.839814>, <0.651168, 1.265666, -0.837778>, 
      <0.600950, 1.390899, -0.895077>, <0.609011, 1.348460, -0.887225>, <0.622192, 1.292783, -0.874636>, <0.626101, 1.249098, -0.872637>, 
      <0.586249, 1.381085, -0.928191>, <0.594310, 1.338646, -0.920339>, <0.609210, 1.283307, -0.904017>, <0.613119, 1.239622, -0.902019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.595931, 1.171595, -1.130069>, <0.593569, 1.215997, -1.132992>, <0.590399, 1.273798, -1.148362>, <0.588028, 1.317599, -1.156202>, 
      <0.609966, 1.160721, -1.169135>, <0.607604, 1.205122, -1.172058>, <0.605263, 1.265085, -1.192912>, <0.602892, 1.308886, -1.200752>, 
      <0.649990, 1.151515, -1.211998>, <0.649686, 1.197969, -1.217750>, <0.645015, 1.253465, -1.238200>, <0.645012, 1.298588, -1.250651>, 
      <0.675261, 1.144306, -1.245921>, <0.674958, 1.190760, -1.251673>, <0.675253, 1.249593, -1.274973>, <0.675249, 1.294716, -1.287424>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.595931, 1.171595, -1.130069>, <0.583285, 1.181393, -1.094869>, <0.586793, 1.199670, -1.044379>, <0.589578, 1.210694, -1.007424>, 
      <0.593569, 1.215997, -1.132992>, <0.580923, 1.225795, -1.097792>, <0.586297, 1.240644, -1.043793>, <0.589083, 1.251668, -1.006837>, 
      <0.590399, 1.273798, -1.148362>, <0.577732, 1.281223, -1.110397>, <0.588235, 1.294712, -1.057955>, <0.587929, 1.305630, -1.018742>, 
      <0.588028, 1.317599, -1.156202>, <0.575361, 1.325024, -1.118237>, <0.587528, 1.335399, -1.062806>, <0.587222, 1.346317, -1.023593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.595931, 1.171595, -1.130069>, <0.609966, 1.160721, -1.169135>, <0.649990, 1.151515, -1.211998>, <0.675261, 1.144306, -1.245921>, 
      <0.598726, 1.119059, -1.126610>, <0.612761, 1.108185, -1.165676>, <0.650356, 1.095319, -1.205040>, <0.675628, 1.088110, -1.238963>, 
      <0.654771, 1.012664, -1.128479>, <0.669506, 1.001534, -1.165559>, <0.697625, 0.991813, -1.193187>, <0.722885, 0.982179, -1.224573>, 
      <0.605128, 0.996161, -1.135040>, <0.619863, 0.985031, -1.172120>, <0.652202, 0.965200, -1.214044>, <0.677462, 0.955565, -1.245430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.595931, 1.171595, -1.130069>, <0.598726, 1.119059, -1.126610>, <0.654771, 1.012664, -1.128479>, <0.605128, 0.996161, -1.135040>, 
      <0.583285, 1.181393, -1.094869>, <0.586080, 1.128858, -1.091410>, <0.642982, 1.021568, -1.098814>, <0.593339, 1.005065, -1.105375>, 
      <0.586793, 1.199670, -1.044379>, <0.587486, 1.142354, -1.045200>, <0.644986, 1.027635, -1.058563>, <0.589599, 1.012969, -1.060430>, 
      <0.589578, 1.210694, -1.007424>, <0.590271, 1.153378, -1.008245>, <0.646545, 1.035419, -1.026388>, <0.591158, 1.020752, -1.028254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.808196, 1.298688, -0.712123>, <0.809860, 1.239833, -0.709374>, <0.867171, 1.119808, -0.718837>, <0.811670, 1.102261, -0.709568>, 
      <0.766190, 1.292042, -0.740570>, <0.767854, 1.233187, -0.737821>, <0.825255, 1.108199, -0.748894>, <0.769754, 1.090652, -0.739625>, 
      <0.710449, 1.283616, -0.780071>, <0.711896, 1.223638, -0.776954>, <0.771241, 1.098755, -0.789519>, <0.713861, 1.082257, -0.782845>, 
      <0.674620, 1.272767, -0.814949>, <0.676067, 1.212789, -0.811832>, <0.735199, 1.089109, -0.826976>, <0.677819, 1.072611, -0.820303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.802529, 1.425665, -0.724676>, <0.804229, 1.387572, -0.720910>, <0.807115, 1.336948, -0.713910>, <0.808196, 1.298688, -0.712123>, 
      <0.760715, 1.418701, -0.756024>, <0.762416, 1.380608, -0.752258>, <0.765109, 1.330301, -0.742358>, <0.766190, 1.292042, -0.740570>, 
      <0.707855, 1.409325, -0.801667>, <0.709276, 1.370705, -0.794933>, <0.709505, 1.322779, -0.782107>, <0.710449, 1.283616, -0.780071>, 
      <0.669885, 1.401498, -0.837396>, <0.671306, 1.362879, -0.830662>, <0.673675, 1.311930, -0.816984>, <0.674620, 1.272767, -0.814949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.809774, 1.110593, -1.417116>, <0.760385, 1.121894, -1.374673>, <0.714186, 1.133202, -1.298170>, <0.675261, 1.144306, -1.245921>, 
      <0.809539, 1.164007, -1.422076>, <0.760150, 1.175309, -1.379633>, <0.713882, 1.179656, -1.303922>, <0.674958, 1.190760, -1.251673>, 
      <0.809878, 1.235607, -1.423375>, <0.766035, 1.236661, -1.385408>, <0.711973, 1.244891, -1.319631>, <0.675253, 1.249593, -1.274973>, 
      <0.809922, 1.289185, -1.426058>, <0.766079, 1.290239, -1.388091>, <0.711970, 1.290014, -1.332082>, <0.675249, 1.294716, -1.287424>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.809774, 1.110593, -1.417116>, <0.810031, 1.052385, -1.411711>, <0.851463, 0.951615, -1.365920>, <0.811561, 0.917423, -1.391538>, 
      <0.760385, 1.121894, -1.374673>, <0.760642, 1.063686, -1.369268>, <0.806163, 0.961651, -1.326961>, <0.766261, 0.927459, -1.352579>, 
      <0.714186, 1.133202, -1.298170>, <0.714552, 1.077006, -1.291212>, <0.759829, 0.968087, -1.270477>, <0.714406, 0.941474, -1.291334>, 
      <0.675261, 1.144306, -1.245921>, <0.675628, 1.088110, -1.238963>, <0.722885, 0.982179, -1.224573>, <0.677462, 0.955565, -1.245430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.952113, 1.316672, -0.627025>, <0.953740, 1.266541, -0.625456>, <0.992154, 1.180596, -0.635807>, <0.955571, 1.149537, -0.621134>, 
      <0.911404, 1.313568, -0.656658>, <0.913032, 1.263436, -0.655088>, <0.950625, 1.166204, -0.664736>, <0.914042, 1.135144, -0.650064>, 
      <0.849612, 1.305241, -0.684075>, <0.851276, 1.246386, -0.681326>, <0.908888, 1.131362, -0.688923>, <0.853387, 1.113815, -0.679654>, 
      <0.808196, 1.298688, -0.712123>, <0.809860, 1.239833, -0.709374>, <0.867171, 1.119808, -0.718837>, <0.811670, 1.102261, -0.709568>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.945901, 1.447469, -0.630462>, <0.947765, 1.408230, -0.629431>, <0.950839, 1.355929, -0.628254>, <0.952113, 1.316672, -0.627025>, 
      <0.903143, 1.439328, -0.658696>, <0.905007, 1.400089, -0.657665>, <0.910130, 1.352825, -0.657887>, <0.911404, 1.313568, -0.656658>, 
      <0.843676, 1.432518, -0.693828>, <0.845376, 1.394425, -0.690062>, <0.848531, 1.343501, -0.685862>, <0.849612, 1.305241, -0.684075>, 
      <0.802529, 1.425665, -0.724676>, <0.804229, 1.387572, -0.720910>, <0.807115, 1.336948, -0.713910>, <0.808196, 1.298688, -0.712123>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.953900, 1.080547, -1.485375>, <0.953694, 1.143753, -1.492506>, <0.954225, 1.225769, -1.516008>, <0.954365, 1.288007, -1.529136>, 
      <0.986729, 1.073337, -1.501980>, <0.986523, 1.136543, -1.509111>, <0.988486, 1.224552, -1.543493>, <0.988626, 1.286790, -1.556621>, 
      <1.026624, 1.061362, -1.531074>, <1.026458, 1.131938, -1.545356>, <1.024698, 1.214521, -1.579437>, <1.024921, 1.281978, -1.604623>, 
      <1.061194, 1.055374, -1.544283>, <1.061029, 1.125949, -1.558564>, <1.061714, 1.212775, -1.603049>, <1.061937, 1.280232, -1.628234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.953900, 1.080547, -1.485375>, <0.911268, 1.089910, -1.463812>, <0.846153, 1.102269, -1.448379>, <0.809774, 1.110593, -1.417116>, 
      <0.953694, 1.143753, -1.492506>, <0.911063, 1.153117, -1.470943>, <0.845917, 1.155683, -1.453339>, <0.809539, 1.164007, -1.422076>, 
      <0.954225, 1.225769, -1.516008>, <0.912716, 1.227244, -1.482707>, <0.850115, 1.234640, -1.458220>, <0.809878, 1.235607, -1.423375>, 
      <0.954365, 1.288007, -1.529136>, <0.912856, 1.289482, -1.495836>, <0.850159, 1.288218, -1.460903>, <0.809922, 1.289185, -1.426058>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.953900, 1.080547, -1.485375>, <0.986729, 1.073337, -1.501980>, <1.026624, 1.061362, -1.531074>, <1.061194, 1.055374, -1.544283>, 
      <0.954081, 1.024913, -1.479098>, <0.986910, 1.017703, -1.495703>, <1.026745, 1.009594, -1.520599>, <1.061315, 1.003606, -1.533807>, 
      <0.984020, 0.932473, -1.455621>, <1.015628, 0.927684, -1.475188>, <1.044192, 0.921166, -1.505576>, <1.080018, 0.918675, -1.516304>, 
      <0.955648, 0.893933, -1.484677>, <0.987255, 0.889144, -1.504243>, <1.027050, 0.881837, -1.536384>, <1.062876, 0.879347, -1.547112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.953900, 1.080547, -1.485375>, <0.954081, 1.024913, -1.479098>, <0.984020, 0.932473, -1.455621>, <0.955648, 0.893933, -1.484677>, 
      <0.911268, 1.089910, -1.463812>, <0.911449, 1.034276, -1.457536>, <0.940210, 0.939110, -1.428501>, <0.911838, 0.900571, -1.457557>, 
      <0.846153, 1.102269, -1.448379>, <0.846410, 1.044060, -1.442974>, <0.890306, 0.943009, -1.399327>, <0.850405, 0.908817, -1.424945>, 
      <0.809774, 1.110593, -1.417116>, <0.810031, 1.052385, -1.411711>, <0.851463, 0.951615, -1.365920>, <0.811561, 0.917423, -1.391538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.059430, 1.317846, -0.529243>, <1.060761, 1.279390, -0.525903>, <1.085389, 1.218593, -0.545469>, <1.062688, 1.189257, -0.534704>, 
      <1.024083, 1.318116, -0.554693>, <1.025414, 1.279660, -0.551353>, <1.051517, 1.209855, -0.570435>, <1.028816, 1.180519, -0.559670>, 
      <0.987261, 1.319352, -0.601440>, <0.988888, 1.269221, -0.599870>, <1.026072, 1.192352, -0.612178>, <0.989490, 1.161292, -0.597506>, 
      <0.952113, 1.316672, -0.627025>, <0.953740, 1.266541, -0.625456>, <0.992154, 1.180596, -0.635807>, <0.955571, 1.149537, -0.621134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.059430, 1.317846, -0.529243>, <1.085082, 1.317650, -0.510773>, <1.122825, 1.315465, -0.489340>, <1.153564, 1.315132, -0.481976>, 
      <1.060761, 1.279390, -0.525903>, <1.086413, 1.279194, -0.507432>, <1.124003, 1.281282, -0.488106>, <1.154743, 1.280949, -0.480741>, 
      <1.085389, 1.218593, -0.545469>, <1.112200, 1.225509, -0.525708>, <1.140255, 1.227990, -0.493009>, <1.172668, 1.230088, -0.482902>, 
      <1.062688, 1.189257, -0.534704>, <1.089499, 1.196173, -0.514943>, <1.124462, 1.199370, -0.482866>, <1.156875, 1.201468, -0.472760>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.052859, 1.473326, -0.559377>, <1.082008, 1.479283, -0.538019>, <1.112878, 1.485833, -0.496220>, <1.146974, 1.488559, -0.483130>, 
      <1.054830, 1.426682, -0.550337>, <1.083979, 1.432639, -0.528979>, <1.114855, 1.433805, -0.495874>, <1.148951, 1.436531, -0.482784>, 
      <1.057792, 1.365192, -0.533355>, <1.083444, 1.364996, -0.514885>, <1.121031, 1.367467, -0.491219>, <1.151771, 1.367134, -0.483854>, 
      <1.059430, 1.317846, -0.529243>, <1.085082, 1.317650, -0.510773>, <1.122825, 1.315465, -0.489340>, <1.153564, 1.315132, -0.481976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.052859, 1.473326, -0.559377>, <1.054830, 1.426682, -0.550337>, <1.057792, 1.365192, -0.533355>, <1.059430, 1.317846, -0.529243>, 
      <1.021580, 1.466934, -0.582296>, <1.023551, 1.420290, -0.573256>, <1.022445, 1.365463, -0.558806>, <1.024083, 1.318116, -0.554693>, 
      <0.978291, 1.453636, -0.609074>, <0.980154, 1.414397, -0.608043>, <0.985987, 1.358609, -0.602669>, <0.987261, 1.319352, -0.601440>, 
      <0.945901, 1.447469, -0.630462>, <0.947765, 1.408230, -0.629431>, <0.950839, 1.355929, -0.628254>, <0.952113, 1.316672, -0.627025>
    }
  }
  texture {
    FireCape
  }
  scale <0.8, 1.0, 1.0>
  translate  <0.5, 0.0, -0.08178>
}
#declare ManShirt = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.785667, -3.439704, -1.988314>, <1.691515, -3.440926, -1.997207>, <1.565121, -3.448196, -1.987992>, <1.470548, -3.449173, -1.987992>, 
      <1.786562, -3.326311, -1.988314>, <1.692410, -3.327533, -1.997207>, <1.565121, -3.334800, -1.987992>, <1.470548, -3.335777, -1.987992>, 
      <1.784195, -3.174121, -2.002687>, <1.689149, -3.175347, -2.011623>, <1.577814, -3.182076, -2.002290>, <1.482346, -3.183057, -2.002290>, 
      <1.788650, -3.061728, -1.988314>, <1.693604, -3.062954, -1.997250>, <1.566016, -3.070205, -1.987992>, <1.470548, -3.071187, -1.987992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.116115, -3.440795, -1.927017>, <2.019176, -3.439942, -1.954728>, <1.886038, -3.438402, -1.978834>, <1.785667, -3.439704, -1.988314>, 
      <2.117010, -3.327403, -1.927017>, <2.020071, -3.326550, -1.954728>, <1.886933, -3.325009, -1.978834>, <1.786562, -3.326311, -1.988314>, 
      <2.119116, -3.175402, -1.940581>, <2.022176, -3.174550, -1.968293>, <1.884570, -3.172827, -1.993250>, <1.784195, -3.174121, -2.002687>, 
      <2.119099, -3.062821, -1.927017>, <2.022159, -3.061968, -1.954729>, <1.889025, -3.060433, -1.978877>, <1.788650, -3.061728, -1.988314>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.459304, -3.445627, -1.795745>, <2.358010, -3.444691, -1.839239>, <2.222106, -3.441727, -1.896718>, <2.116115, -3.440795, -1.927017>, 
      <2.460199, -3.332235, -1.795745>, <2.358905, -3.331299, -1.839239>, <2.223001, -3.328335, -1.896718>, <2.117010, -3.327403, -1.927017>, 
      <2.466958, -3.180337, -1.807534>, <2.365664, -3.179402, -1.851028>, <2.225107, -3.176335, -1.910282>, <2.119116, -3.175402, -1.940581>, 
      <2.462288, -3.067653, -1.795745>, <2.360994, -3.066717, -1.839239>, <2.225090, -3.063753, -1.896718>, <2.119099, -3.062821, -1.927017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.852233, -3.447598, -1.610937>, <2.767165, -3.455588, -1.709269>, <2.578999, -3.446733, -1.744349>, <2.459304, -3.445627, -1.795745>, 
      <2.853128, -3.334205, -1.610937>, <2.768061, -3.342195, -1.709269>, <2.579894, -3.333341, -1.744349>, <2.460199, -3.332235, -1.795745>, 
      <2.865203, -3.182196, -1.620209>, <2.779167, -3.191880, -1.717541>, <2.586653, -3.181443, -1.756138>, <2.466958, -3.180337, -1.807534>, 
      <2.855217, -3.069621, -1.610937>, <2.769181, -3.079305, -1.708270>, <2.581983, -3.068759, -1.744349>, <2.462288, -3.067653, -1.795745>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.852233, -3.447598, -1.610937>, <2.853128, -3.334205, -1.610937>, <2.865203, -3.182196, -1.620209>, <2.855217, -3.069621, -1.610937>, 
      <2.997178, -3.433984, -1.443390>, <2.998073, -3.320590, -1.443390>, <3.008975, -3.166013, -1.457558>, <2.998990, -3.053438, -1.448287>, 
      <3.176429, -3.404374, -1.174854>, <3.177357, -3.286913, -1.180193>, <3.190617, -3.129368, -1.185926>, <3.179720, -3.012313, -1.188415>, 
      <3.186810, -3.377294, -0.954796>, <3.187737, -3.259832, -0.960135>, <3.200798, -3.102809, -0.970105>, <3.189901, -2.985755, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.914976, -3.283919, -0.280856>, <3.062813, -3.316506, -0.440214>, <3.197090, -3.350477, -0.736879>, <3.186810, -3.377294, -0.954796>, 
      <2.915871, -3.170527, -0.280856>, <3.063708, -3.203114, -0.440214>, <3.198017, -3.233016, -0.742218>, <3.187737, -3.259832, -0.960135>, 
      <2.929005, -3.018449, -0.271946>, <3.078296, -3.048511, -0.436574>, <3.211286, -3.075449, -0.747764>, <3.200798, -3.102809, -0.970105>, 
      <2.917959, -2.905945, -0.280856>, <3.067250, -2.936007, -0.445485>, <3.200389, -2.958394, -0.750253>, <3.189901, -2.985755, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.474044, -3.220183, -0.186482>, <2.606702, -3.242841, -0.210010>, <2.823086, -3.263664, -0.181805>, <2.914976, -3.283919, -0.280856>, 
      <2.474939, -3.106790, -0.186482>, <2.607597, -3.129448, -0.210010>, <2.823981, -3.150272, -0.181805>, <2.915871, -3.170527, -0.280856>, 
      <2.482039, -2.955021, -0.176160>, <2.614697, -2.977679, -0.199688>, <2.838058, -3.000136, -0.171655>, <2.929005, -3.018449, -0.271946>, 
      <2.477028, -2.842207, -0.186482>, <2.609686, -2.864865, -0.210010>, <2.827012, -2.887631, -0.180565>, <2.917959, -2.905945, -0.280856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.107402, -3.145986, -0.137623>, <2.218459, -3.161864, -0.152558>, <2.364151, -3.201413, -0.166991>, <2.474044, -3.220183, -0.186482>, 
      <2.108297, -3.032594, -0.137623>, <2.219354, -3.048472, -0.152558>, <2.365046, -3.088020, -0.166991>, <2.474939, -3.106790, -0.186482>, 
      <2.110281, -2.880863, -0.126514>, <2.221337, -2.896740, -0.141449>, <2.372147, -2.936252, -0.156669>, <2.482039, -2.955021, -0.176160>, 
      <2.110386, -2.768013, -0.137623>, <2.221442, -2.783890, -0.152558>, <2.367135, -2.823437, -0.166991>, <2.477028, -2.842207, -0.186482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.828395, -3.127876, -0.099655>, <1.912683, -3.130588, -0.106963>, <2.024339, -3.134111, -0.126453>, <2.107402, -3.145986, -0.137623>, 
      <1.829290, -3.014483, -0.099655>, <1.913579, -3.017195, -0.106963>, <2.025234, -3.020719, -0.126453>, <2.108297, -3.032594, -0.137623>, 
      <1.827339, -2.862624, -0.087998>, <1.911628, -2.865336, -0.095306>, <2.027218, -2.868988, -0.115343>, <2.110281, -2.880863, -0.126514>, 
      <1.831379, -2.749901, -0.099655>, <1.915668, -2.752613, -0.106963>, <2.027323, -2.756138, -0.126453>, <2.110386, -2.768013, -0.137623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.528168, -3.127350, -0.087403>, <1.618265, -3.125604, -0.089689>, <1.738635, -3.124988, -0.091873>, <1.828395, -3.127876, -0.099655>, 
      <1.529063, -3.013958, -0.087403>, <1.619160, -3.012211, -0.089689>, <1.739530, -3.011595, -0.091873>, <1.829290, -3.014483, -0.099655>, 
      <1.522895, -2.861852, -0.075598>, <1.612993, -2.860118, -0.077871>, <1.737579, -2.859736, -0.080215>, <1.827339, -2.862624, -0.087998>, 
      <1.531151, -2.749375, -0.087403>, <1.621249, -2.747641, -0.089676>, <1.741619, -2.747013, -0.091873>, <1.831379, -2.749901, -0.099655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.330701, -3.137523, -0.087025>, <1.389941, -3.134471, -0.087138>, <1.468879, -3.128499, -0.085898>, <1.528168, -3.127350, -0.087403>, 
      <1.330701, -3.024127, -0.087025>, <1.389941, -3.021075, -0.087138>, <1.469774, -3.015107, -0.085898>, <1.529063, -3.013958, -0.087403>, 
      <1.341042, -2.871843, -0.075237>, <1.401231, -2.870152, -0.075237>, <1.462713, -2.863011, -0.074080>, <1.522895, -2.861852, -0.075598>, 
      <1.330701, -2.759537, -0.087025>, <1.390889, -2.757845, -0.087025>, <1.470969, -2.750533, -0.085885>, <1.531151, -2.749375, -0.087403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.820325, -2.565368, -1.876504>, <1.818100, -2.718022, -1.885494>, <1.794659, -2.910146, -1.968930>, <1.788650, -3.061728, -1.988314>, 
      <1.688062, -2.566849, -1.886286>, <1.685837, -2.719503, -1.895275>, <1.699613, -2.911372, -1.977866>, <1.693604, -3.062954, -1.997250>, 
      <1.510940, -2.573354, -1.876217>, <1.514379, -2.728236, -1.885334>, <1.549869, -2.917104, -1.968425>, <1.566016, -3.070205, -1.987992>, 
      <1.378313, -2.574604, -1.876217>, <1.381753, -2.729487, -1.885334>, <1.454401, -2.918086, -1.968425>, <1.470548, -3.071187, -1.987992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.115984, -2.566346, -1.821661>, <2.115041, -2.718371, -1.830097>, <2.119076, -2.911652, -1.908804>, <2.119099, -3.062821, -1.927017>, 
      <2.029250, -2.565583, -1.846455>, <2.028308, -2.717608, -1.854891>, <2.022137, -2.910800, -1.936515>, <2.022159, -3.061968, -1.954729>, 
      <1.910285, -2.564361, -1.869851>, <1.908060, -2.717015, -1.878840>, <1.895034, -2.908851, -1.959493>, <1.889025, -3.060433, -1.978877>, 
      <1.820325, -2.565368, -1.876504>, <1.818100, -2.718022, -1.885494>, <1.794659, -2.910146, -1.968930>, <1.788650, -3.061728, -1.988314>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.423042, -2.570670, -1.704210>, <2.423422, -2.722552, -1.711531>, <2.456025, -2.916547, -1.779937>, <2.462288, -3.067653, -1.795745>, 
      <2.332412, -2.569832, -1.743125>, <2.332792, -2.721715, -1.750447>, <2.354732, -2.915612, -1.823431>, <2.360994, -3.066717, -1.839239>, 
      <2.210817, -2.567180, -1.794552>, <2.209874, -2.719205, -1.802988>, <2.225068, -2.912584, -1.878505>, <2.225090, -3.063753, -1.896718>, 
      <2.115984, -2.566346, -1.821661>, <2.115041, -2.718371, -1.830097>, <2.119076, -2.911652, -1.908804>, <2.119099, -3.062821, -1.927017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.774604, -2.572432, -1.538857>, <2.776505, -2.724954, -1.544646>, <2.841775, -2.918083, -1.598456>, <2.855217, -3.069621, -1.610937>, 
      <2.694928, -2.575977, -1.623851>, <2.696829, -2.728499, -1.629640>, <2.755739, -2.927767, -1.695789>, <2.769181, -3.079305, -1.708270>, 
      <2.530136, -2.571660, -1.658225>, <2.530516, -2.723542, -1.665546>, <2.575720, -2.917653, -1.728541>, <2.581983, -3.068759, -1.744349>, 
      <2.423042, -2.570670, -1.704210>, <2.423422, -2.722552, -1.711531>, <2.456025, -2.916547, -1.779937>, <2.462288, -3.067653, -1.795745>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.774604, -2.572432, -1.538857>, <2.909620, -2.566425, -1.394829>, <3.099645, -2.564252, -1.168409>, <3.108882, -2.540155, -0.972594>, 
      <2.776505, -2.724954, -1.544646>, <2.911520, -2.718947, -1.400619>, <3.101383, -2.699255, -1.153168>, <3.110620, -2.675158, -0.957354>, 
      <2.841775, -2.918083, -1.598456>, <2.985548, -2.901901, -1.435806>, <3.167130, -2.877057, -1.191290>, <3.177310, -2.850498, -0.975470>, 
      <2.855217, -3.069621, -1.610937>, <2.998990, -3.053438, -1.448287>, <3.179720, -3.012313, -1.188415>, <3.189901, -2.985755, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.830741, -2.425985, -0.348805>, <2.832840, -2.573633, -0.343474>, <2.903565, -2.759348, -0.292467>, <2.917959, -2.905945, -0.280856>, 
      <2.971655, -2.461849, -0.497172>, <2.973754, -2.609497, -0.491841>, <3.052856, -2.789410, -0.457095>, <3.067250, -2.936007, -0.445485>, 
      <3.118598, -2.514810, -0.766635>, <3.120336, -2.649813, -0.751395>, <3.187798, -2.823138, -0.753129>, <3.200389, -2.958394, -0.750253>, 
      <3.108882, -2.540155, -0.972594>, <3.110620, -2.675158, -0.957354>, <3.177310, -2.850498, -0.975470>, <3.189901, -2.985755, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.436231, -2.368958, -0.264367>, <2.436659, -2.513237, -0.258375>, <2.470646, -2.698544, -0.199627>, <2.477028, -2.842207, -0.186482>, 
      <2.554922, -2.389230, -0.285419>, <2.555350, -2.533509, -0.279426>, <2.603304, -2.721202, -0.223155>, <2.609686, -2.864865, -0.210010>, 
      <2.747825, -2.404882, -0.261504>, <2.749924, -2.552530, -0.256173>, <2.812618, -2.741034, -0.192176>, <2.827012, -2.887631, -0.180565>, 
      <2.830741, -2.425985, -0.348805>, <2.832840, -2.573633, -0.343474>, <2.903565, -2.759348, -0.292467>, <2.917959, -2.905945, -0.280856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.108188, -2.302575, -0.220651>, <2.107273, -2.444269, -0.214352>, <2.110518, -2.626858, -0.151519>, <2.110386, -2.768013, -0.137623>, 
      <2.207552, -2.316781, -0.234014>, <2.206638, -2.458475, -0.227714>, <2.221574, -2.642735, -0.166454>, <2.221442, -2.783890, -0.152558>, 
      <2.337907, -2.352165, -0.246928>, <2.338335, -2.496444, -0.240936>, <2.360753, -2.679775, -0.180136>, <2.367135, -2.823437, -0.166991>, 
      <2.436231, -2.368958, -0.264367>, <2.436659, -2.513237, -0.258375>, <2.470646, -2.698544, -0.199627>, <2.477028, -2.842207, -0.186482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.858555, -2.286370, -0.186680>, <1.856622, -2.427927, -0.180077>, <1.836428, -2.609019, -0.114225>, <1.831379, -2.749901, -0.099655>, 
      <1.933969, -2.288796, -0.193218>, <1.932036, -2.430353, -0.186616>, <1.920717, -2.611731, -0.121532>, <1.915668, -2.752613, -0.106963>, 
      <2.033870, -2.291950, -0.210657>, <2.032955, -2.433645, -0.204357>, <2.027454, -2.614983, -0.140348>, <2.027323, -2.756138, -0.126453>, 
      <2.108188, -2.302575, -0.220651>, <2.107273, -2.444269, -0.214352>, <2.110518, -2.626858, -0.151519>, <2.110386, -2.768013, -0.137623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.589934, -2.285900, -0.175718>, <1.586886, -2.428347, -0.168976>, <1.541537, -2.607892, -0.102252>, <1.531151, -2.749375, -0.087403>, 
      <1.670564, -2.284649, -0.177223>, <1.667515, -2.427095, -0.170481>, <1.631635, -2.606158, -0.104525>, <1.621249, -2.747641, -0.089676>, 
      <1.778244, -2.283786, -0.179717>, <1.776311, -2.425343, -0.173114>, <1.746668, -2.606131, -0.106442>, <1.741619, -2.747013, -0.091873>, 
      <1.858555, -2.286370, -0.186680>, <1.856622, -2.427927, -0.180077>, <1.836428, -2.609019, -0.114225>, <1.831379, -2.749901, -0.099655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.253189, -2.295764, -0.175380>, <1.255911, -2.439108, -0.168593>, <1.317611, -2.617386, -0.101946>, <1.330701, -2.759537, -0.087025>, 
      <1.354233, -2.293624, -0.175380>, <1.356955, -2.436968, -0.168593>, <1.377800, -2.615694, -0.101946>, <1.390889, -2.757845, -0.087025>, 
      <1.488897, -2.287468, -0.173832>, <1.485848, -2.429914, -0.167090>, <1.481354, -2.609051, -0.100734>, <1.470969, -2.750533, -0.085885>, 
      <1.589934, -2.285900, -0.175718>, <1.586886, -2.428347, -0.168976>, <1.541537, -2.607892, -0.102252>, <1.531151, -2.749375, -0.087403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.805062, -1.935841, -1.922011>, <1.805229, -2.124436, -1.904503>, <1.823081, -2.376309, -1.865370>, <1.820325, -2.565368, -1.876504>, 
      <1.697556, -1.937145, -1.931042>, <1.697723, -2.125741, -1.913534>, <1.690818, -2.377790, -1.875152>, <1.688062, -2.566849, -1.886286>, 
      <1.553429, -1.944141, -1.921710>, <1.541638, -2.133344, -1.904150>, <1.506720, -2.383348, -1.865032>, <1.510940, -2.573354, -1.876217>, 
      <1.445542, -1.945212, -1.921710>, <1.433751, -2.134415, -1.904150>, <1.374093, -2.384598, -1.865032>, <1.378313, -2.574604, -1.876217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.126079, -1.936955, -1.864542>, <2.120801, -2.125441, -1.848052>, <2.117156, -2.377361, -1.811174>, <2.115984, -2.566346, -1.821661>, 
      <2.031769, -1.936128, -1.890561>, <2.026491, -2.124614, -1.874072>, <2.030422, -2.376598, -1.835968>, <2.029250, -2.565583, -1.846455>, 
      <1.902548, -1.934658, -1.913822>, <1.902716, -2.123253, -1.896313>, <1.913041, -2.375302, -1.858717>, <1.910285, -2.564361, -1.869851>, 
      <1.805062, -1.935841, -1.922011>, <1.805229, -2.124436, -1.904503>, <1.823081, -2.376309, -1.865370>, <1.820325, -2.565368, -1.876504>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.459473, -1.941577, -1.741465>, <2.448534, -2.130091, -1.727130>, <2.422569, -2.381516, -1.695092>, <2.423042, -2.570670, -1.704210>, 
      <2.360975, -1.940672, -1.782284>, <2.350036, -2.129185, -1.767949>, <2.331940, -2.380678, -1.734008>, <2.332412, -2.569832, -1.743125>, 
      <2.228860, -1.937856, -1.836186>, <2.223583, -2.126341, -1.819696>, <2.211988, -2.378195, -1.784065>, <2.210817, -2.567180, -1.794552>, 
      <2.126079, -1.936955, -1.864542>, <2.120801, -2.125441, -1.848052>, <2.117156, -2.377361, -1.811174>, <2.115984, -2.566346, -1.821661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.841186, -1.943528, -1.568194>, <2.823740, -2.132317, -1.556888>, <2.772239, -2.382654, -1.531654>, <2.774604, -2.572432, -1.538857>, 
      <2.747866, -1.951272, -1.652142>, <2.730420, -2.140060, -1.640835>, <2.692564, -2.386199, -1.616647>, <2.694928, -2.575977, -1.623851>, 
      <2.575649, -1.942645, -1.693321>, <2.564710, -2.131159, -1.678986>, <2.529663, -2.382506, -1.649107>, <2.530136, -2.571660, -1.658225>, 
      <2.459473, -1.941577, -1.741465>, <2.448534, -2.130091, -1.727130>, <2.422569, -2.381516, -1.695092>, <2.423042, -2.570670, -1.704210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.841186, -1.943528, -1.568194>, <2.970516, -1.932796, -1.451853>, <3.167255, -1.903404, -1.269960>, <3.175694, -1.882144, -1.097178>, 
      <2.823740, -2.132317, -1.556888>, <2.953071, -2.121584, -1.440547>, <3.147984, -2.104390, -1.269960>, <3.156423, -2.083130, -1.097178>, 
      <2.772239, -2.382654, -1.531654>, <2.907255, -2.376647, -1.387626>, <3.097063, -2.363635, -1.191056>, <3.106299, -2.339538, -0.995241>, 
      <2.774604, -2.572432, -1.538857>, <2.909620, -2.566425, -1.394829>, <3.099645, -2.564252, -1.168409>, <3.108882, -2.540155, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.902095, -1.790085, -0.321149>, <2.883664, -1.981050, -0.331778>, <2.828011, -2.233983, -0.355738>, <2.830741, -2.425985, -0.348805>, 
      <3.057233, -1.823663, -0.512211>, <3.038802, -2.014628, -0.522840>, <2.968926, -2.269847, -0.504105>, <2.971655, -2.461849, -0.497172>, 
      <3.187721, -1.851845, -0.850932>, <3.168450, -2.052830, -0.850932>, <3.116015, -2.314193, -0.789282>, <3.118598, -2.514810, -0.766635>, 
      <3.175694, -1.882144, -1.097178>, <3.156423, -2.083130, -1.097178>, <3.106299, -2.339538, -0.995241>, <3.108882, -2.540155, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.473732, -1.730209, -0.232667>, <2.462594, -1.921691, -0.244817>, <2.435662, -2.176934, -0.272342>, <2.436231, -2.368958, -0.264367>, 
      <2.602584, -1.751484, -0.254722>, <2.591445, -1.942966, -0.266872>, <2.554353, -2.197206, -0.293394>, <2.554922, -2.389230, -0.285419>, 
      <2.819375, -1.772181, -0.219274>, <2.800944, -1.963146, -0.229903>, <2.745096, -2.212880, -0.268437>, <2.747825, -2.404882, -0.261504>, 
      <2.902095, -1.790085, -0.321149>, <2.883664, -1.981050, -0.331778>, <2.828011, -2.233983, -0.355738>, <2.830741, -2.425985, -0.348805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.117535, -1.660547, -0.186858>, <2.112426, -1.852941, -0.199789>, <2.109432, -2.109874, -0.229218>, <2.108188, -2.302575, -0.220651>, 
      <2.225361, -1.675454, -0.200852>, <2.220252, -1.867848, -0.213783>, <2.208797, -2.124080, -0.242581>, <2.207552, -2.316781, -0.234014>, 
      <2.366963, -1.712580, -0.214392>, <2.355824, -1.904063, -0.226541>, <2.337338, -2.160141, -0.254903>, <2.337907, -2.352165, -0.246928>, 
      <2.473732, -1.730209, -0.232667>, <2.462594, -1.921691, -0.244817>, <2.435662, -2.176934, -0.272342>, <2.436231, -2.368958, -0.264367>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.846489, -1.643493, -0.151261>, <1.845954, -1.836206, -0.164816>, <1.861190, -2.093408, -0.195680>, <1.858555, -2.286370, -0.186680>, 
      <1.928334, -1.646057, -0.158109>, <1.927800, -1.838770, -0.171665>, <1.936605, -2.095835, -0.202219>, <1.933969, -2.288796, -0.193218>, 
      <2.036802, -1.649386, -0.176380>, <2.031693, -1.841779, -0.189311>, <2.035114, -2.099249, -0.219223>, <2.033870, -2.291950, -0.210657>, 
      <2.117535, -1.660547, -0.186858>, <2.112426, -1.852941, -0.199789>, <2.109432, -2.109874, -0.229218>, <2.108188, -2.302575, -0.220651>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.554830, -1.642919, -0.139774>, <1.559224, -1.835860, -0.153546>, <1.594069, -2.092678, -0.184864>, <1.589934, -2.285900, -0.175718>, 
      <1.642361, -1.641366, -0.141705>, <1.646754, -1.834307, -0.155477>, <1.674699, -2.091427, -0.186369>, <1.670564, -2.284649, -0.177223>, 
      <1.759271, -1.640761, -0.143963>, <1.758736, -1.833473, -0.157518>, <1.780879, -2.090824, -0.188717>, <1.778244, -2.283786, -0.179717>, 
      <1.846489, -1.643493, -0.151261>, <1.845954, -1.836206, -0.164816>, <1.861190, -2.093408, -0.195680>, <1.858555, -2.286370, -0.186680>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.309687, -1.653018, -0.139419>, <1.300268, -1.846165, -0.153213>, <1.249512, -2.102148, -0.184548>, <1.253189, -2.295764, -0.175380>, 
      <1.383230, -1.649988, -0.139526>, <1.373811, -1.843135, -0.153320>, <1.350556, -2.100008, -0.184548>, <1.354233, -2.293624, -0.175380>, 
      <1.481254, -1.644224, -0.138151>, <1.485648, -1.837166, -0.151923>, <1.493032, -2.094246, -0.182978>, <1.488897, -2.287468, -0.173832>, 
      <1.554830, -1.642919, -0.139774>, <1.559224, -1.835860, -0.153546>, <1.594069, -2.092678, -0.184864>, <1.589934, -2.285900, -0.175718>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.819257, -1.360978, -1.988314>, <1.807014, -1.530845, -1.954387>, <1.804909, -1.762930, -1.938063>, <1.805062, -1.935841, -1.922011>, 
      <1.709881, -1.362262, -1.997892>, <1.697637, -1.532130, -1.963964>, <1.697403, -1.764235, -1.947094>, <1.697556, -1.937145, -1.931042>, 
      <1.563164, -1.369195, -1.987992>, <1.560817, -1.541684, -1.968107>, <1.564184, -1.771569, -1.937726>, <1.553429, -1.944141, -1.921710>, 
      <1.453367, -1.370248, -1.987992>, <1.451019, -1.542737, -1.968107>, <1.456297, -1.772640, -1.937726>, <1.445542, -1.945212, -1.921710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.149705, -1.362071, -1.927017>, <2.132645, -1.531732, -1.894309>, <2.130920, -1.764058, -1.879668>, <2.126079, -1.936955, -1.864542>, 
      <2.052766, -1.361219, -1.954728>, <2.035706, -1.530879, -1.922020>, <2.036611, -1.763231, -1.905687>, <2.031769, -1.936128, -1.890561>, 
      <1.919692, -1.359799, -1.979519>, <1.907448, -1.529666, -1.945592>, <1.902395, -1.761747, -1.929874>, <1.902548, -1.934658, -1.913822>, 
      <1.819257, -1.360978, -1.988314>, <1.807014, -1.530845, -1.954387>, <1.804909, -1.762930, -1.938063>, <1.805062, -1.935841, -1.922011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.492894, -1.366903, -1.795745>, <2.470842, -1.536293, -1.765596>, <2.469493, -1.768906, -1.754595>, <2.459473, -1.941577, -1.741465>, 
      <2.391600, -1.365967, -1.839239>, <2.369548, -1.535357, -1.809090>, <2.370995, -1.768000, -1.795414>, <2.360975, -1.940672, -1.782284>, 
      <2.255696, -1.363003, -1.896718>, <2.238636, -1.532664, -1.864009>, <2.233702, -1.764958, -1.851312>, <2.228860, -1.937856, -1.836186>, 
      <2.149705, -1.362071, -1.927017>, <2.132645, -1.531732, -1.894309>, <2.130920, -1.764058, -1.879668>, <2.126079, -1.936955, -1.864542>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.885822, -1.368872, -1.610937>, <3.028884, -1.372264, -1.448917>, <3.209616, -1.410510, -1.186908>, <3.219726, -1.384137, -0.972593>, 
      <2.844619, -1.534418, -1.579934>, <2.987680, -1.537810, -1.417913>, <3.190636, -1.562607, -1.206874>, <3.200746, -1.536234, -0.992559>, 
      <2.857112, -1.771179, -1.578516>, <2.986443, -1.760447, -1.462175>, <3.182008, -1.749538, -1.269960>, <3.190447, -1.728278, -1.097178>, 
      <2.841186, -1.943528, -1.568194>, <2.970516, -1.932796, -1.451853>, <3.167255, -1.903404, -1.269960>, <3.175694, -1.882144, -1.097178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.885822, -1.368872, -1.610937>, <2.844619, -1.534418, -1.579934>, <2.857112, -1.771179, -1.578516>, <2.841186, -1.943528, -1.568194>, 
      <2.799610, -1.366828, -1.708574>, <2.758407, -1.532374, -1.677570>, <2.763792, -1.778923, -1.662463>, <2.747866, -1.951272, -1.652142>, 
      <2.612589, -1.368009, -1.744349>, <2.590537, -1.537399, -1.714200>, <2.585669, -1.769973, -1.706450>, <2.575649, -1.942645, -1.693321>, 
      <2.492894, -1.366903, -1.795745>, <2.470842, -1.536293, -1.765596>, <2.469493, -1.768906, -1.754595>, <2.459473, -1.941577, -1.741465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.948565, -1.205195, -0.280856>, <2.919303, -1.378595, -0.295182>, <2.919019, -1.614735, -0.311389>, <2.902095, -1.790085, -0.321149>, 
      <3.098608, -1.256329, -0.446496>, <3.069347, -1.429730, -0.460822>, <3.074157, -1.648314, -0.502451>, <3.057233, -1.823663, -0.512211>, 
      <3.230448, -1.356165, -0.745289>, <3.211468, -1.508262, -0.765255>, <3.202475, -1.697978, -0.850932>, <3.187721, -1.851845, -0.850932>, 
      <3.219726, -1.384137, -0.972593>, <3.200746, -1.536234, -0.992559>, <3.190447, -1.728278, -1.097178>, <3.175694, -1.882144, -1.097178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.507634, -1.141458, -0.186482>, <2.484772, -1.316803, -0.201435>, <2.484017, -1.553403, -0.221449>, <2.473732, -1.730209, -0.232667>, 
      <2.640292, -1.164116, -0.210010>, <2.617430, -1.339460, -0.224963>, <2.612869, -1.574678, -0.243504>, <2.602584, -1.751484, -0.254722>, 
      <2.859155, -1.174724, -0.182152>, <2.829893, -1.348124, -0.196478>, <2.836299, -1.596831, -0.209514>, <2.819375, -1.772181, -0.219274>, 
      <2.948565, -1.205195, -0.280856>, <2.919303, -1.378595, -0.295182>, <2.919019, -1.614735, -0.311389>, <2.902095, -1.790085, -0.321149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.140992, -1.067262, -0.137623>, <2.123591, -1.244432, -0.153574>, <2.122269, -1.482276, -0.174876>, <2.117535, -1.660547, -0.186858>, 
      <2.252048, -1.083140, -0.152558>, <2.234648, -1.260310, -0.168509>, <2.230095, -1.497183, -0.188870>, <2.225361, -1.675454, -0.200852>, 
      <2.397741, -1.122688, -0.166991>, <2.374879, -1.298033, -0.181944>, <2.377247, -1.535775, -0.203173>, <2.366963, -1.712580, -0.214392>, 
      <2.507634, -1.141458, -0.186482>, <2.484772, -1.316803, -0.201435>, <2.484017, -1.553403, -0.221449>, <2.473732, -1.730209, -0.232667>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.861987, -1.049151, -0.099655>, <1.848763, -1.226911, -0.116380>, <1.846984, -1.464901, -0.138699>, <1.846489, -1.643493, -0.151261>, 
      <1.946275, -1.051863, -0.106963>, <1.933051, -1.229623, -0.123688>, <1.928830, -1.467465, -0.145547>, <1.928334, -1.646057, -0.158109>, 
      <2.057929, -1.055387, -0.126453>, <2.040529, -1.232557, -0.142404>, <2.041536, -1.471115, -0.164398>, <2.036802, -1.649386, -0.176380>, 
      <2.140992, -1.067262, -0.137623>, <2.123591, -1.244432, -0.153574>, <2.122269, -1.482276, -0.174876>, <2.117535, -1.660547, -0.186858>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.561758, -1.048626, -0.087403>, <1.553043, -1.226596, -0.104391>, <1.550765, -1.464428, -0.127034>, <1.554830, -1.642919, -0.139774>, 
      <1.651865, -1.047074, -0.089478>, <1.643150, -1.225044, -0.106466>, <1.638296, -1.462875, -0.128965>, <1.642361, -1.641366, -0.141705>, 
      <1.772226, -1.046263, -0.091873>, <1.759002, -1.224023, -0.108598>, <1.759766, -1.462169, -0.131401>, <1.759271, -1.640761, -0.143963>, 
      <1.861987, -1.049151, -0.099655>, <1.848763, -1.226911, -0.116380>, <1.846984, -1.464901, -0.138699>, <1.846489, -1.643493, -0.151261>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.313520, -1.058598, -0.087025>, <1.313123, -1.236809, -0.104035>, <1.318385, -1.474663, -0.126681>, <1.309687, -1.653018, -0.139419>, 
      <1.388029, -1.056752, -0.087025>, <1.387631, -1.234962, -0.104035>, <1.391928, -1.471633, -0.126788>, <1.383230, -1.649988, -0.139526>, 
      <1.487257, -1.049909, -0.085687>, <1.478543, -1.227879, -0.102676>, <1.477189, -1.465734, -0.125411>, <1.481254, -1.644224, -0.138151>, 
      <1.561758, -1.048626, -0.087403>, <1.553043, -1.226596, -0.104391>, <1.550765, -1.464428, -0.127034>, <1.554830, -1.642919, -0.139774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.437326, 0.714075, -1.548219>, <1.436451, 0.713446, -1.548219>, <1.433344, 0.711992, -1.548375>, <1.434410, 0.711977, -1.548219>, 
      <1.432039, 0.492595, -1.685708>, <1.431165, 0.491965, -1.685708>, <1.552238, 0.503837, -1.685864>, <1.553304, 0.503822, -1.685708>, 
      <1.424991, 0.197287, -1.869027>, <1.548297, 0.209984, -1.869027>, <1.627947, 0.251912, -1.907794>, <1.751336, 0.260089, -1.899186>, 
      <1.419704, -0.024193, -2.006517>, <1.543010, -0.011497, -2.006517>, <1.707337, 0.009951, -2.015126>, <1.830725, 0.018128, -2.006517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.094296, -5.836652, -1.222240>, <4.053301, -5.837350, -1.196227>, <3.999503, -5.841838, -1.157341>, <3.969715, -5.841014, -1.119004>, 
      <4.090109, -5.713088, -1.217078>, <4.049114, -5.713786, -1.191065>, <4.000395, -5.728843, -1.157341>, <3.970607, -5.728019, -1.119004>, 
      <4.116047, -5.528276, -1.147377>, <4.080607, -5.533353, -1.123536>, <4.078007, -5.555045, -1.135222>, <4.049421, -5.546014, -1.104375>, 
      <4.080341, -5.424772, -1.205034>, <4.044900, -5.429849, -1.181193>, <4.001274, -5.473395, -1.149851>, <3.972688, -5.464364, -1.119004>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.267990, -5.835934, -1.308271>, <4.211325, -5.846777, -1.315548>, <4.143391, -5.835816, -1.253392>, <4.094296, -5.836652, -1.222240>, 
      <4.263804, -5.712370, -1.308271>, <4.207138, -5.723213, -1.315548>, <4.139204, -5.712251, -1.248231>, <4.090109, -5.713088, -1.217078>, 
      <4.224646, -5.542554, -1.288779>, <4.166400, -5.550272, -1.303691>, <4.165992, -5.521120, -1.180976>, <4.116047, -5.528276, -1.147377>, 
      <4.254034, -5.424055, -1.308271>, <4.195788, -5.431773, -1.323182>, <4.130285, -5.417616, -1.238632>, <4.080341, -5.424772, -1.205034>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.502611, -5.758521, -1.169808>, <4.445358, -5.775756, -1.230174>, <4.350785, -5.820091, -1.297639>, <4.267990, -5.835934, -1.308271>, 
      <4.477698, -5.644912, -1.154323>, <4.420444, -5.662146, -1.214689>, <4.346599, -5.696528, -1.297639>, <4.263804, -5.712370, -1.308271>, 
      <4.372654, -5.487256, -1.113198>, <4.320340, -5.507296, -1.165692>, <4.298414, -5.532780, -1.269894>, <4.224646, -5.542554, -1.288779>, 
      <4.419567, -5.379824, -1.118190>, <4.367253, -5.399863, -1.170684>, <4.327802, -5.414281, -1.289386>, <4.254034, -5.424055, -1.308271>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.612491, -5.732234, -0.945040>, <4.618386, -5.744963, -1.019195>, <4.553466, -5.743213, -1.116188>, <4.502611, -5.758521, -1.169808>, 
      <4.613549, -5.598182, -0.945040>, <4.619444, -5.610911, -1.019195>, <4.528553, -5.629603, -1.100703>, <4.477698, -5.644912, -1.154323>, 
      <4.536208, -5.392973, -0.950359>, <4.527654, -5.414366, -1.030629>, <4.429560, -5.465458, -1.056096>, <4.372654, -5.487256, -1.113198>, 
      <4.616018, -5.285395, -0.945040>, <4.607464, -5.306788, -1.025310>, <4.476473, -5.358026, -1.061088>, <4.419567, -5.379824, -1.118190>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.463393, -5.673832, -0.676430>, <4.554718, -5.674272, -0.697896>, <4.605164, -5.716411, -0.852859>, <4.612491, -5.732234, -0.945040>, 
      <4.464368, -5.550309, -0.676430>, <4.555694, -5.550749, -0.697896>, <4.606222, -5.582359, -0.852859>, <4.613549, -5.598182, -0.945040>, 
      <4.407194, -5.368581, -0.696024>, <4.489227, -5.372182, -0.738547>, <4.545679, -5.369285, -0.861478>, <4.536208, -5.392973, -0.950359>, 
      <4.466643, -5.262088, -0.676430>, <4.548676, -5.265688, -0.718953>, <4.625489, -5.261707, -0.856159>, <4.616018, -5.285395, -0.945040>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.858968, -5.728600, -0.767923>, <4.023178, -5.685264, -0.696789>, <4.284152, -5.672968, -0.634299>, <4.463393, -5.673832, -0.676430>, 
      <3.941974, -5.589314, -0.746357>, <4.106184, -5.545978, -0.675222>, <4.285128, -5.549444, -0.634299>, <4.464368, -5.550309, -0.676430>, 
      <4.087506, -5.404711, -0.764780>, <4.184587, -5.397659, -0.744277>, <4.318948, -5.364708, -0.650280>, <4.407194, -5.368581, -0.696024>, 
      <4.135654, -5.264313, -0.696035>, <4.232735, -5.257261, -0.675532>, <4.378397, -5.258215, -0.630686>, <4.466643, -5.262088, -0.676430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.869949, -5.830442, -0.933504>, <3.853143, -5.813383, -0.880227>, <3.806876, -5.742347, -0.790489>, <3.858968, -5.728600, -0.767923>, 
      <3.829134, -5.675905, -0.902808>, <3.812328, -5.658846, -0.849532>, <3.889881, -5.603061, -0.768923>, <3.941974, -5.589314, -0.746357>, 
      <3.815057, -5.453087, -0.861561>, <3.857185, -5.401372, -0.752220>, <3.962504, -5.413792, -0.791180>, <4.087506, -5.404711, -0.764780>, 
      <3.733897, -5.315319, -0.831185>, <3.776025, -5.263604, -0.721843>, <4.010652, -5.273394, -0.722435>, <4.135654, -5.264313, -0.696035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.869949, -5.830442, -0.933504>, <3.829134, -5.675905, -0.902808>, <3.815057, -5.453087, -0.861561>, <3.733897, -5.315319, -0.831185>, 
      <3.888152, -5.848919, -0.991210>, <3.847337, -5.694382, -0.960515>, <3.775332, -5.501852, -0.964666>, <3.694172, -5.364084, -0.934290>, 
      <3.930902, -5.839940, -1.069052>, <3.931794, -5.726944, -1.069052>, <3.969158, -5.520656, -1.017763>, <3.892425, -5.439006, -1.032392>, 
      <3.969715, -5.841014, -1.119004>, <3.970607, -5.728019, -1.119004>, <4.049421, -5.546014, -1.104375>, <3.972688, -5.464364, -1.119004>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.852432, -5.135557, -1.612785>, <3.904463, -5.284708, -1.565740>, <4.032781, -5.286908, -1.281831>, <4.080341, -5.424772, -1.205034>, 
      <3.675656, -5.152509, -1.579520>, <3.727688, -5.301660, -1.532475>, <3.997340, -5.291985, -1.257990>, <4.044900, -5.429849, -1.181193>, 
      <3.483528, -5.251841, -1.387071>, <3.578307, -5.412770, -1.367358>, <3.873744, -5.337693, -1.174164>, <4.001274, -5.473395, -1.149851>, 
      <3.400349, -5.235162, -1.227551>, <3.495129, -5.396090, -1.207838>, <3.845158, -5.328662, -1.143317>, <3.972688, -5.464364, -1.119004>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.441751, -5.135299, -1.423518>, <4.449276, -5.241533, -1.400523>, <4.279932, -5.319627, -1.325448>, <4.254034, -5.424055, -1.308271>, 
      <4.273778, -5.123498, -1.501791>, <4.281304, -5.229732, -1.478797>, <4.221686, -5.327345, -1.340360>, <4.195788, -5.431773, -1.323182>, 
      <4.034114, -5.118136, -1.646973>, <4.086145, -5.267286, -1.599928>, <4.082725, -5.279752, -1.315430>, <4.130285, -5.417616, -1.238632>, 
      <3.852432, -5.135557, -1.612785>, <3.904463, -5.284708, -1.565740>, <4.032781, -5.286908, -1.281831>, <4.080341, -5.424772, -1.205034>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.747197, -5.198420, -1.195834>, <4.720863, -5.305078, -1.162735>, <4.465443, -5.274769, -1.123072>, <4.419567, -5.379824, -1.118190>, 
      <4.654362, -5.215654, -1.262958>, <4.628028, -5.322312, -1.229859>, <4.413129, -5.294808, -1.175566>, <4.367253, -5.399863, -1.170684>, 
      <4.546546, -5.142662, -1.374685>, <4.554072, -5.248895, -1.351690>, <4.353701, -5.309853, -1.306563>, <4.327802, -5.414281, -1.289386>, 
      <4.441751, -5.135299, -1.423518>, <4.449276, -5.241533, -1.400523>, <4.279932, -5.319627, -1.325448>, <4.254034, -5.424055, -1.308271>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.153356, -5.003192, -0.908995>, <5.076972, -5.168738, -0.914527>, <4.724611, -5.139020, -0.937803>, <4.616018, -5.285395, -0.945040>, 
      <5.126688, -5.058457, -1.057038>, <5.050304, -5.224002, -1.062569>, <4.716057, -5.160414, -1.018073>, <4.607464, -5.306788, -1.025310>, 
      <4.875618, -5.174579, -1.102980>, <4.849283, -5.281237, -1.069881>, <4.522349, -5.252971, -1.065969>, <4.476473, -5.358026, -1.061088>, 
      <4.747197, -5.198420, -1.195834>, <4.720863, -5.305078, -1.162735>, <4.465443, -5.274769, -1.123072>, <4.419567, -5.379824, -1.118190>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.864581, -4.955162, -0.544200>, <4.817882, -5.103876, -0.546868>, <4.541670, -5.127688, -0.651701>, <4.466643, -5.262088, -0.676430>, 
      <4.990092, -4.959768, -0.606774>, <4.943393, -5.108482, -0.609442>, <4.623703, -5.131288, -0.694225>, <4.548676, -5.265688, -0.718953>, 
      <5.176706, -4.954802, -0.779369>, <5.100323, -5.120348, -0.784901>, <4.734082, -5.115332, -0.848922>, <4.625489, -5.261707, -0.856159>, 
      <5.153356, -5.003192, -0.908995>, <5.076972, -5.168738, -0.914527>, <4.724611, -5.139020, -0.937803>, <4.616018, -5.285395, -0.945040>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.120735, -4.965298, -0.394177>, <4.119920, -5.088823, -0.425934>, <4.173197, -5.154838, -0.642431>, <4.135654, -5.264313, -0.696035>, 
      <4.345498, -4.951210, -0.360776>, <4.344683, -5.074734, -0.392533>, <4.270278, -5.147786, -0.621928>, <4.232735, -5.257261, -0.675532>, 
      <4.660941, -4.947689, -0.442675>, <4.614242, -5.096404, -0.445342>, <4.453424, -5.123815, -0.605958>, <4.378397, -5.258215, -0.630686>, 
      <4.864581, -4.955162, -0.544200>, <4.817882, -5.103876, -0.546868>, <4.541670, -5.127688, -0.651701>, <4.466643, -5.262088, -0.676430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.408100, -5.046457, -0.760644>, <3.409445, -5.174262, -0.773706>, <3.669830, -5.206567, -0.807206>, <3.733897, -5.315319, -0.831185>, 
      <3.561579, -4.988962, -0.583093>, <3.562924, -5.116767, -0.596155>, <3.711959, -5.154852, -0.697865>, <3.776025, -5.263604, -0.721843>, 
      <3.882186, -4.980251, -0.429627>, <3.881371, -5.103776, -0.461384>, <4.048196, -5.163920, -0.668832>, <4.010652, -5.273394, -0.722435>, 
      <4.120735, -4.965298, -0.394177>, <4.119920, -5.088823, -0.425934>, <4.173197, -5.154838, -0.642431>, <4.135654, -5.264313, -0.696035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.408100, -5.046457, -0.760644>, <3.312126, -5.082409, -0.871671>, <3.330787, -5.221213, -1.094145>, <3.400349, -5.235162, -1.227551>, 
      <3.409445, -5.174262, -0.773706>, <3.313471, -5.210215, -0.884732>, <3.425567, -5.382142, -1.074432>, <3.495129, -5.396090, -1.207838>, 
      <3.669830, -5.206567, -0.807206>, <3.630105, -5.255332, -0.910311>, <3.764896, -5.303304, -1.056705>, <3.845158, -5.328662, -1.143317>, 
      <3.733897, -5.315319, -0.831185>, <3.694172, -5.364084, -0.934290>, <3.892425, -5.439006, -1.032392>, <3.972688, -5.464364, -1.119004>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.841990, -4.741523, -1.420544>, <3.844815, -4.870644, -1.445629>, <3.810899, -5.016501, -1.650338>, <3.852432, -5.135557, -1.612785>, 
      <3.734611, -4.757472, -1.377018>, <3.737436, -4.886593, -1.402103>, <3.634124, -5.033452, -1.617073>, <3.675656, -5.152509, -1.579520>, 
      <3.535665, -4.701667, -1.328517>, <3.537514, -4.868999, -1.339734>, <3.398884, -5.108123, -1.404676>, <3.483528, -5.251841, -1.387071>, 
      <3.515608, -4.688278, -1.214072>, <3.517457, -4.855610, -1.225289>, <3.315705, -5.091444, -1.245156>, <3.400349, -5.235162, -1.227551>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.194765, -4.587401, -1.489368>, <4.242521, -4.760250, -1.462156>, <4.429223, -4.958450, -1.461798>, <4.441751, -5.135299, -1.423518>, 
      <4.078483, -4.592815, -1.503991>, <4.126239, -4.765664, -1.476778>, <4.261250, -4.946649, -1.540071>, <4.273778, -5.123498, -1.501791>, 
      <3.949704, -4.725524, -1.464206>, <3.952529, -4.854645, -1.489291>, <3.992581, -4.999079, -1.684526>, <4.034114, -5.118136, -1.646973>, 
      <3.841990, -4.741523, -1.420544>, <3.844815, -4.870644, -1.445629>, <3.810899, -5.016501, -1.650338>, <3.852432, -5.135557, -1.612785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.585716, -4.706894, -1.327019>, <4.611250, -4.864102, -1.310487>, <4.783948, -5.049574, -1.242025>, <4.747197, -5.198420, -1.195834>, 
      <4.481131, -4.705080, -1.407467>, <4.506666, -4.862288, -1.390935>, <4.691113, -5.066808, -1.309149>, <4.654362, -5.215654, -1.262958>, 
      <4.325553, -4.581311, -1.472921>, <4.373309, -4.754160, -1.445709>, <4.534018, -4.965813, -1.412964>, <4.546546, -5.142662, -1.374685>, 
      <4.194765, -4.587401, -1.489368>, <4.242521, -4.760250, -1.462156>, <4.429223, -4.958450, -1.461798>, <4.441751, -5.135299, -1.423518>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.932177, -4.600186, -0.922143>, <4.947802, -4.737261, -0.920808>, <5.211133, -4.877973, -0.904811>, <5.153356, -5.003192, -0.908995>, 
      <4.901888, -4.657008, -1.071926>, <4.917512, -4.794084, -1.070591>, <5.184465, -4.933238, -1.052853>, <5.126688, -5.058457, -1.057038>, 
      <4.714932, -4.709134, -1.227624>, <4.740467, -4.866342, -1.211093>, <4.912368, -5.025732, -1.149172>, <4.875618, -5.174579, -1.102980>, 
      <4.585716, -4.706894, -1.327019>, <4.611250, -4.864102, -1.310487>, <4.783948, -5.049574, -1.242025>, <4.747197, -5.198420, -1.195834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.720208, -4.454589, -0.661944>, <4.731573, -4.613808, -0.647963>, <4.912578, -4.802309, -0.541458>, <4.864581, -4.955162, -0.544200>, 
      <4.816864, -4.464566, -0.712965>, <4.828228, -4.623784, -0.698983>, <5.038089, -4.806915, -0.604032>, <4.990092, -4.959768, -0.606774>, 
      <4.952567, -4.561936, -0.821316>, <4.968191, -4.699011, -0.819981>, <5.234483, -4.829583, -0.775185>, <5.176706, -4.954802, -0.779369>, 
      <4.932177, -4.600186, -0.922143>, <4.947802, -4.737261, -0.920808>, <5.211133, -4.877973, -0.904811>, <5.153356, -5.003192, -0.908995>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.140575, -4.518477, -0.504287>, <4.138951, -4.656136, -0.492350>, <4.121618, -4.831468, -0.359770>, <4.120735, -4.965298, -0.394177>, 
      <4.316970, -4.481142, -0.486036>, <4.315346, -4.618801, -0.474099>, <4.346381, -4.817380, -0.326369>, <4.345498, -4.951210, -0.360776>, 
      <4.560606, -4.438115, -0.577696>, <4.571970, -4.597334, -0.563715>, <4.708938, -4.794836, -0.439932>, <4.660941, -4.947689, -0.442675>, 
      <4.720208, -4.454589, -0.661944>, <4.731573, -4.613808, -0.647963>, <4.912578, -4.802309, -0.541458>, <4.864581, -4.955162, -0.544200>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.727050, -4.664797, -0.764701>, <3.697973, -4.811128, -0.767646>, <3.406538, -4.898018, -0.745473>, <3.408100, -5.046457, -0.760644>, 
      <3.826592, -4.637752, -0.651650>, <3.797515, -4.784082, -0.654595>, <3.560017, -4.840522, -0.567922>, <3.561579, -4.988962, -0.583093>, 
      <3.991615, -4.550005, -0.519699>, <3.989992, -4.687664, -0.507762>, <3.883069, -4.846421, -0.395221>, <3.882186, -4.980251, -0.429627>, 
      <4.140575, -4.518477, -0.504287>, <4.138951, -4.656136, -0.492350>, <4.121618, -4.831468, -0.359770>, <4.120735, -4.965298, -0.394177>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.727050, -4.664797, -0.764701>, <3.630034, -4.691156, -0.874884>, <3.490029, -4.671204, -1.068121>, <3.515608, -4.688278, -1.214072>, 
      <3.697973, -4.811128, -0.767646>, <3.600957, -4.837487, -0.877830>, <3.491878, -4.838536, -1.079338>, <3.517457, -4.855610, -1.225289>, 
      <3.406538, -4.898018, -0.745473>, <3.310564, -4.933970, -0.856500>, <3.246144, -5.077495, -1.111750>, <3.315705, -5.091444, -1.245156>, 
      <3.408100, -5.046457, -0.760644>, <3.312126, -5.082409, -0.871671>, <3.330787, -5.221213, -1.094145>, <3.400349, -5.235162, -1.227551>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.834657, -4.323141, -1.454956>, <3.828011, -4.448900, -1.452520>, <3.839285, -4.617906, -1.396529>, <3.841990, -4.741523, -1.420544>, 
      <3.651955, -4.209693, -1.359547>, <3.645310, -4.335452, -1.357111>, <3.731906, -4.633855, -1.353003>, <3.734611, -4.757472, -1.377018>, 
      <3.413288, -3.939238, -1.290063>, <3.429333, -4.218248, -1.291344>, <3.532585, -4.422835, -1.309825>, <3.535665, -4.701667, -1.328517>, 
      <3.384161, -3.769918, -1.129328>, <3.400206, -4.048929, -1.130609>, <3.512528, -4.409446, -1.195380>, <3.515608, -4.688278, -1.214072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.205407, -4.279869, -1.558192>, <4.200607, -4.374311, -1.560641>, <4.169858, -4.497254, -1.503560>, <4.194765, -4.587401, -1.489368>, 
      <4.103959, -4.333477, -1.576445>, <4.099159, -4.427919, -1.578894>, <4.053576, -4.502668, -1.518183>, <4.078483, -4.592815, -1.503991>, 
      <3.924880, -4.379165, -1.502072>, <3.918234, -4.504923, -1.499635>, <3.947000, -4.601907, -1.440191>, <3.949704, -4.725524, -1.464206>, 
      <3.834657, -4.323141, -1.454956>, <3.828011, -4.448900, -1.452520>, <3.839285, -4.617906, -1.396529>, <3.841990, -4.741523, -1.420544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.544134, -3.948233, -1.327302>, <4.545466, -4.175728, -1.341475>, <4.549366, -4.483105, -1.350552>, <4.585716, -4.706894, -1.327019>, 
      <4.439011, -4.031188, -1.411505>, <4.440342, -4.258682, -1.425679>, <4.444782, -4.481291, -1.431000>, <4.481131, -4.705080, -1.407467>, 
      <4.343529, -4.206882, -1.533340>, <4.338729, -4.301324, -1.535789>, <4.300646, -4.491164, -1.487114>, <4.325553, -4.581311, -1.472921>, 
      <4.205407, -4.279869, -1.558192>, <4.200607, -4.374311, -1.560641>, <4.169858, -4.497254, -1.503560>, <4.194765, -4.587401, -1.489368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.999483, -3.653249, -0.922143>, <4.993712, -3.936416, -0.952029>, <4.899925, -4.317234, -0.924899>, <4.932177, -4.600186, -0.922143>, 
      <4.940775, -3.740483, -1.095952>, <4.935004, -4.023650, -1.125839>, <4.869636, -4.374056, -1.074682>, <4.901888, -4.657008, -1.071926>, 
      <4.679133, -3.841703, -1.219169>, <4.680464, -4.069198, -1.233342>, <4.678583, -4.485345, -1.251158>, <4.714932, -4.709134, -1.227624>, 
      <4.544134, -3.948233, -1.327302>, <4.545466, -4.175728, -1.341475>, <4.549366, -4.483105, -1.350552>, <4.585716, -4.706894, -1.327019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.768874, -3.614293, -0.661944>, <4.766554, -3.866455, -0.675013>, <4.702299, -4.203679, -0.683977>, <4.720208, -4.454589, -0.661944>, 
      <4.863266, -3.609670, -0.707607>, <4.860945, -3.861832, -0.720675>, <4.798954, -4.213656, -0.734997>, <4.816864, -4.464566, -0.712965>, 
      <5.029816, -3.608178, -0.832340>, <5.024046, -3.891344, -0.862226>, <4.920314, -4.278984, -0.824072>, <4.952567, -4.561936, -0.821316>, 
      <4.999483, -3.653249, -0.922143>, <4.993712, -3.936416, -0.952029>, <4.899925, -4.317234, -0.924899>, <4.932177, -4.600186, -0.922143>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.135711, -3.695556, -0.504287>, <4.128309, -3.942326, -0.504163>, <4.143476, -4.272536, -0.525615>, <4.140575, -4.518477, -0.504287>, 
      <4.332311, -3.705531, -0.491594>, <4.324908, -3.952300, -0.491470>, <4.319870, -4.235201, -0.507364>, <4.316970, -4.481142, -0.486036>, 
      <4.591472, -3.622982, -0.576125>, <4.589151, -3.875144, -0.589193>, <4.542696, -4.187205, -0.599729>, <4.560606, -4.438115, -0.577696>, 
      <4.768874, -3.614293, -0.661944>, <4.766554, -3.866455, -0.675013>, <4.702299, -4.203679, -0.683977>, <4.720208, -4.454589, -0.661944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.703421, -3.560236, -0.730731>, <3.709571, -3.891305, -0.712991>, <3.791665, -4.339618, -0.758156>, <3.727050, -4.664797, -0.764701>, 
      <3.819893, -3.548712, -0.633865>, <3.826043, -3.879780, -0.616124>, <3.891207, -4.312573, -0.645105>, <3.826592, -4.637752, -0.651650>, 
      <3.984294, -3.687874, -0.514063>, <3.976892, -3.934643, -0.513939>, <3.994516, -4.304064, -0.541027>, <3.991615, -4.550005, -0.519699>, 
      <4.135711, -3.695556, -0.504287>, <4.128309, -3.942326, -0.504163>, <4.143476, -4.272536, -0.525615>, <4.140575, -4.518477, -0.504287>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.703421, -3.560236, -0.730731>, <3.576452, -3.572799, -0.836327>, <3.363658, -3.650726, -1.016180>, <3.384161, -3.769918, -1.129328>, 
      <3.709571, -3.891305, -0.712991>, <3.582602, -3.903868, -0.818587>, <3.379703, -3.929737, -1.017460>, <3.400206, -4.048929, -1.130609>, 
      <3.791665, -4.339618, -0.758156>, <3.694648, -4.365977, -0.868340>, <3.486949, -4.392372, -1.049430>, <3.512528, -4.409446, -1.195380>, 
      <3.727050, -4.664797, -0.764701>, <3.630034, -4.691156, -0.874884>, <3.490029, -4.671204, -1.068121>, <3.515608, -4.688278, -1.214072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.929429, -3.086942, -1.452600>, <3.896672, -3.457344, -1.443922>, <3.854282, -3.951780, -1.462151>, <3.834657, -4.323141, -1.454956>, 
      <3.771015, -3.050438, -1.405760>, <3.738258, -3.420840, -1.397082>, <3.671580, -3.838332, -1.366742>, <3.651955, -4.209693, -1.359547>, 
      <3.482834, -3.103208, -1.360402>, <3.476520, -3.313144, -1.328172>, <3.401088, -3.727101, -1.289089>, <3.413288, -3.939238, -1.290063>, 
      <3.422364, -3.066887, -1.206630>, <3.416050, -3.276823, -1.174400>, <3.371961, -3.557781, -1.128354>, <3.384161, -3.769918, -1.129328>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.262212, -3.260418, -1.454956>, <4.244878, -3.566985, -1.477343>, <4.221030, -3.972498, -1.550221>, <4.205407, -4.279869, -1.558192>, 
      <4.161212, -3.223164, -1.487928>, <4.143878, -3.529730, -1.510315>, <4.119582, -4.026106, -1.568474>, <4.103959, -4.333477, -1.576445>, 
      <4.034852, -3.111235, -1.483772>, <4.002096, -3.481637, -1.475093>, <3.944505, -4.007804, -1.509266>, <3.924880, -4.379165, -1.502072>, 
      <3.929429, -3.086942, -1.452600>, <3.896672, -3.457344, -1.443922>, <3.854282, -3.951780, -1.462151>, <3.834657, -4.323141, -1.454956>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.577635, -3.326037, -1.240989>, <4.564440, -3.514288, -1.241803>, <4.543032, -3.759887, -1.315568>, <4.544134, -3.948233, -1.327302>, 
      <4.494978, -3.336161, -1.321782>, <4.481783, -3.524412, -1.322596>, <4.437908, -3.842842, -1.399771>, <4.439011, -4.031188, -1.411505>, 
      <4.366296, -3.298810, -1.420977>, <4.348962, -3.605377, -1.443364>, <4.359152, -3.899510, -1.525369>, <4.343529, -4.206882, -1.533340>, 
      <4.262212, -3.260418, -1.454956>, <4.244878, -3.566985, -1.477343>, <4.221030, -3.972498, -1.550221>, <4.205407, -4.279869, -1.558192>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.961226, -3.174797, -0.771703>, <4.951006, -3.325346, -0.772992>, <5.002540, -3.503212, -0.906308>, <4.999483, -3.653249, -0.922143>, 
      <4.919997, -3.234913, -0.944354>, <4.909777, -3.385462, -0.945643>, <4.943832, -3.590446, -1.080117>, <4.940775, -3.740483, -1.095952>, 
      <4.711144, -3.309684, -1.110490>, <4.697949, -3.497934, -1.111304>, <4.678030, -3.653357, -1.207435>, <4.679133, -3.841703, -1.219169>, 
      <4.577635, -3.326037, -1.240989>, <4.564440, -3.514288, -1.241803>, <4.543032, -3.759887, -1.315568>, <4.544134, -3.948233, -1.327302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.732677, -3.099973, -0.591739>, <4.730479, -3.255693, -0.602476>, <4.770309, -3.458404, -0.653865>, <4.768874, -3.614293, -0.661944>, 
      <4.814190, -3.126141, -0.619857>, <4.811992, -3.281861, -0.630594>, <4.864700, -3.453781, -0.699527>, <4.863266, -3.609670, -0.707607>, 
      <4.981050, -3.145892, -0.688689>, <4.970830, -3.296441, -0.689978>, <5.032874, -3.458141, -0.816505>, <5.029816, -3.608178, -0.832340>, 
      <4.961226, -3.174797, -0.771703>, <4.951006, -3.325346, -0.772992>, <5.002540, -3.503212, -0.906308>, <4.999483, -3.653249, -0.922143>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.188324, -2.926676, -0.505086>, <4.171094, -3.157073, -0.513780>, <4.142644, -3.464456, -0.504403>, <4.135711, -3.695556, -0.504287>, 
      <4.354568, -2.951313, -0.462618>, <4.337338, -3.181710, -0.471311>, <4.339243, -3.474431, -0.491710>, <4.332311, -3.705531, -0.491594>, 
      <4.575872, -3.049635, -0.537648>, <4.573674, -3.205354, -0.548385>, <4.592907, -3.467093, -0.568045>, <4.591472, -3.622982, -0.576125>, 
      <4.732677, -3.099973, -0.591739>, <4.730479, -3.255693, -0.602476>, <4.770309, -3.458404, -0.653865>, <4.768874, -3.614293, -0.661944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.695128, -2.946211, -0.856791>, <3.716114, -3.126072, -0.806014>, <3.699934, -3.372472, -0.740792>, <3.703421, -3.560236, -0.730731>, 
      <3.828004, -2.921888, -0.735090>, <3.848990, -3.101749, -0.684312>, <3.816406, -3.360947, -0.643926>, <3.819893, -3.548712, -0.633865>, 
      <4.013949, -2.900834, -0.549632>, <3.996719, -3.131231, -0.558326>, <3.991226, -3.456774, -0.514179>, <3.984294, -3.687874, -0.514063>, 
      <4.188324, -2.926676, -0.505086>, <4.171094, -3.157073, -0.513780>, <4.142644, -3.464456, -0.504403>, <4.135711, -3.695556, -0.504287>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.695128, -2.946211, -0.856791>, <3.594336, -2.964661, -0.949106>, <3.373067, -3.037277, -1.081272>, <3.422364, -3.066887, -1.206630>, 
      <3.716114, -3.126072, -0.806014>, <3.615322, -3.144522, -0.898329>, <3.366753, -3.247214, -1.049042>, <3.416050, -3.276823, -1.174400>, 
      <3.699934, -3.372472, -0.740792>, <3.572964, -3.385035, -0.846389>, <3.351458, -3.438589, -1.015206>, <3.371961, -3.557781, -1.128354>, 
      <3.703421, -3.560236, -0.730731>, <3.576452, -3.572799, -0.836327>, <3.363658, -3.650726, -1.016180>, <3.384161, -3.769918, -1.129328>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.983462, -2.640490, -1.494380>, <3.982816, -2.775056, -1.510199>, <3.941362, -2.952012, -1.455761>, <3.929429, -3.086942, -1.452600>, 
      <3.807927, -2.621803, -1.467368>, <3.807281, -2.756369, -1.483187>, <3.782947, -2.915507, -1.408921>, <3.771015, -3.050438, -1.405760>, 
      <3.533484, -2.673594, -1.427396>, <3.555802, -2.813350, -1.431403>, <3.487042, -2.963326, -1.381877>, <3.482834, -3.103208, -1.360402>, 
      <3.419170, -2.605971, -1.308019>, <3.441488, -2.745727, -1.312026>, <3.426571, -2.927004, -1.228105>, <3.422364, -3.066887, -1.206630>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.294782, -2.699186, -1.442762>, <4.286650, -2.867325, -1.453736>, <4.271710, -3.092440, -1.442689>, <4.262212, -3.260418, -1.454956>, 
      <4.201753, -2.702944, -1.467342>, <4.193621, -2.871083, -1.478315>, <4.170710, -3.055186, -1.475661>, <4.161212, -3.223164, -1.487928>, 
      <4.078114, -2.650566, -1.508946>, <4.077468, -2.785132, -1.524764>, <4.046785, -2.976305, -1.486933>, <4.034852, -3.111235, -1.483772>, 
      <3.983462, -2.640490, -1.494380>, <3.982816, -2.775056, -1.510199>, <3.941362, -2.952012, -1.455761>, <3.929429, -3.086942, -1.452600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.637651, -2.614066, -1.321533>, <4.665920, -2.827546, -1.309027>, <4.592717, -3.110860, -1.240059>, <4.577635, -3.326037, -1.240989>, 
      <4.547275, -2.639552, -1.382670>, <4.575544, -2.853032, -1.370164>, <4.510060, -3.120985, -1.320852>, <4.494978, -3.336161, -1.321782>, 
      <4.403032, -2.694814, -1.414161>, <4.394899, -2.862952, -1.425134>, <4.375794, -3.130833, -1.408710>, <4.366296, -3.298810, -1.420977>, 
      <4.294782, -2.699186, -1.442762>, <4.286650, -2.867325, -1.453736>, <4.271710, -3.092440, -1.442689>, <4.262212, -3.260418, -1.454956>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <5.079265, -2.477964, -0.912080>, <5.095700, -2.692753, -0.894055>, <4.975866, -2.959131, -0.769857>, <4.961226, -3.174797, -0.771703>, 
      <5.045610, -2.546934, -1.080657>, <5.062045, -2.761723, -1.062632>, <4.934636, -3.019247, -0.942507>, <4.919997, -3.234913, -0.944354>, 
      <4.787047, -2.571937, -1.220470>, <4.815316, -2.785417, -1.207964>, <4.726226, -3.094507, -1.109560>, <4.711144, -3.309684, -1.110490>, 
      <4.637651, -2.614066, -1.321533>, <4.665920, -2.827546, -1.309027>, <4.592717, -3.110860, -1.240059>, <4.577635, -3.326037, -1.240989>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.787324, -2.307341, -0.571831>, <4.808802, -2.544245, -0.588059>, <4.736034, -2.862133, -0.575340>, <4.732677, -3.099973, -0.591739>, 
      <4.912639, -2.326295, -0.639999>, <4.934117, -2.563200, -0.656227>, <4.817548, -2.888300, -0.603459>, <4.814190, -3.126141, -0.619857>, 
      <5.105414, -2.424378, -0.781104>, <5.121848, -2.639167, -0.763079>, <4.995690, -2.930227, -0.686842>, <4.981050, -3.145892, -0.688689>, 
      <5.079265, -2.477964, -0.912080>, <5.095700, -2.692753, -0.894055>, <4.975866, -2.959131, -0.769857>, <4.961226, -3.174797, -0.771703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.236301, -2.350465, -0.453530>, <4.248118, -2.524213, -0.453621>, <4.201302, -2.753134, -0.498537>, <4.188324, -2.926676, -0.505086>, 
      <4.393394, -2.339260, -0.390684>, <4.405210, -2.513008, -0.390776>, <4.367546, -2.777771, -0.456069>, <4.354568, -2.951313, -0.462618>, 
      <4.639666, -2.285008, -0.491509>, <4.661144, -2.521912, -0.507737>, <4.579230, -2.811794, -0.521249>, <4.575872, -3.049635, -0.537648>, 
      <4.787324, -2.307341, -0.571831>, <4.808802, -2.544245, -0.588059>, <4.736034, -2.862133, -0.575340>, <4.732677, -3.099973, -0.591739>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.567387, -2.394360, -1.059874>, <3.588200, -2.569826, -1.022893>, <3.674984, -2.773563, -0.905532>, <3.695128, -2.946211, -0.856791>, 
      <3.750572, -2.337081, -0.868315>, <3.771384, -2.512546, -0.831334>, <3.807860, -2.749239, -0.783831>, <3.828004, -2.921888, -0.735090>, 
      <3.985083, -2.368385, -0.554031>, <3.996900, -2.542133, -0.554123>, <4.026927, -2.727292, -0.543083>, <4.013949, -2.900834, -0.549632>, 
      <4.236301, -2.350465, -0.453530>, <4.248118, -2.524213, -0.453621>, <4.201302, -2.753134, -0.498537>, <4.188324, -2.926676, -0.505086>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.567387, -2.394360, -1.059874>, <3.494789, -2.417060, -1.135791>, <3.350378, -2.565277, -1.236180>, <3.419170, -2.605971, -1.308019>, 
      <3.588200, -2.569826, -1.022893>, <3.515602, -2.592526, -1.098810>, <3.372697, -2.705034, -1.240187>, <3.441488, -2.745727, -1.312026>, 
      <3.674984, -2.773563, -0.905532>, <3.574192, -2.792013, -0.997847>, <3.377274, -2.897395, -1.102747>, <3.426571, -2.927004, -1.228105>, 
      <3.695128, -2.946211, -0.856791>, <3.594336, -2.964661, -0.949106>, <3.373067, -3.037277, -1.081272>, <3.422364, -3.066887, -1.206630>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.344276, -1.563763, -1.344225>, <4.433746, -1.877445, -1.318273>, <4.594768, -2.290220, -1.340504>, <4.637651, -2.614066, -1.321533>, 
      <4.344276, -1.563763, -1.344225>, <4.418898, -2.218072, -1.347834>, <4.504392, -2.315706, -1.401641>, <4.547275, -2.639552, -1.382670>, 
      <4.344276, -1.563763, -1.344225>, <4.418898, -2.218072, -1.347834>, <4.419530, -2.353708, -1.391899>, <4.403032, -2.694814, -1.414161>, 
      <4.344276, -1.563763, -1.344225>, <4.329428, -1.904390, -1.373786>, <4.311281, -2.358080, -1.420500>, <4.294782, -2.699186, -1.442762>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.935657, -1.789679, -1.300102>, <3.969224, -2.047032, -1.337445>, <3.984712, -2.380080, -1.463768>, <3.983462, -2.640490, -1.494380>, 
      <3.720720, -1.826235, -1.266819>, <3.754287, -2.083588, -1.304162>, <3.809178, -2.361394, -1.436756>, <3.807927, -2.621803, -1.467368>, 
      <3.394622, -1.861892, -1.236078>, <3.413190, -2.124994, -1.267550>, <3.491611, -2.411395, -1.419880>, <3.533484, -2.673594, -1.427396>, 
      <3.213045, -1.756160, -1.169054>, <3.231612, -2.019262, -1.200526>, <3.377298, -2.343772, -1.300502>, <3.419170, -2.605971, -1.308019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.935657, -1.789679, -1.300102>, <4.072774, -1.766358, -1.321335>, <4.224999, -1.618479, -1.394970>, <4.344276, -1.563763, -1.344225>, 
      <3.969224, -2.047032, -1.337445>, <4.106341, -2.023711, -1.358678>, <4.210151, -1.959106, -1.424531>, <4.329428, -1.904390, -1.373786>, 
      <3.984712, -2.380080, -1.463768>, <4.079364, -2.390157, -1.478333>, <4.218252, -2.361838, -1.445080>, <4.311281, -2.358080, -1.420500>, 
      <3.983462, -2.640490, -1.494380>, <4.078114, -2.650566, -1.508946>, <4.201753, -2.702944, -1.467342>, <4.294782, -2.699186, -1.442762>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.824060, -1.382144, -0.922143>, <4.899586, -1.711137, -0.920085>, <5.053602, -2.142563, -0.940227>, <5.079265, -2.477964, -0.912080>, 
      <4.774908, -1.429497, -1.109390>, <4.850434, -1.758490, -1.107333>, <5.019946, -2.211533, -1.108804>, <5.045610, -2.546934, -1.080657>, 
      <4.513232, -1.486258, -1.272345>, <4.602702, -1.799940, -1.246393>, <4.744164, -2.248091, -1.239441>, <4.787047, -2.571937, -1.220470>, 
      <4.344276, -1.563763, -1.344225>, <4.433746, -1.877445, -1.318273>, <4.594768, -2.290220, -1.340504>, <4.637651, -2.614066, -1.321533>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.573394, -1.343030, -0.471387>, <4.637822, -1.633164, -0.491110>, <4.760493, -2.011390, -0.551558>, <4.787324, -2.307341, -0.571831>, 
      <4.708411, -1.338373, -0.547725>, <4.772840, -1.628506, -0.567449>, <4.885808, -2.030344, -0.619726>, <4.912639, -2.326295, -0.639999>, 
      <4.862330, -1.345275, -0.776352>, <4.937856, -1.674268, -0.774294>, <5.079750, -2.088977, -0.809251>, <5.105414, -2.424378, -0.781104>, 
      <4.824060, -1.382144, -0.922143>, <4.899586, -1.711137, -0.920085>, <5.053602, -2.142563, -0.940227>, <5.079265, -2.477964, -0.912080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.085010, -1.407638, -0.504287>, <4.175666, -1.679639, -0.494693>, <4.216835, -2.064255, -0.453379>, <4.236301, -2.350465, -0.453530>, 
      <4.207428, -1.382955, -0.424635>, <4.298083, -1.654956, -0.415040>, <4.373928, -2.053050, -0.390534>, <4.393394, -2.339260, -0.390684>, 
      <4.444513, -1.347476, -0.398519>, <4.508942, -1.637609, -0.418242>, <4.612836, -1.989057, -0.471236>, <4.639666, -2.285008, -0.491509>, 
      <4.573394, -1.343030, -0.471387>, <4.637822, -1.633164, -0.491110>, <4.760493, -2.011390, -0.551558>, <4.787324, -2.307341, -0.571831>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.529921, -1.553421, -1.150336>, <3.580384, -1.801875, -1.135080>, <3.538104, -2.147491, -1.111904>, <3.567387, -2.394360, -1.059874>, 
      <3.726399, -1.474889, -1.000546>, <3.776862, -1.723344, -0.985290>, <3.721289, -2.090212, -0.920345>, <3.750572, -2.337081, -0.868315>, 
      <3.870752, -1.450838, -0.643697>, <3.961408, -1.722839, -0.634103>, <3.965617, -2.082175, -0.553881>, <3.985083, -2.368385, -0.554031>, 
      <4.085010, -1.407638, -0.504287>, <4.175666, -1.679639, -0.494693>, <4.216835, -2.064255, -0.453379>, <4.236301, -2.350465, -0.453530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.529921, -1.553421, -1.150336>, <3.444284, -1.587650, -1.215624>, <3.120017, -1.701990, -1.134715>, <3.213045, -1.756160, -1.169054>, 
      <3.580384, -1.801875, -1.135080>, <3.494748, -1.836104, -1.200368>, <3.138584, -1.965092, -1.166187>, <3.231612, -2.019262, -1.200526>, 
      <3.538104, -2.147491, -1.111904>, <3.465507, -2.170191, -1.187821>, <3.308506, -2.303079, -1.228663>, <3.377298, -2.343772, -1.300502>, 
      <3.567387, -2.394360, -1.059874>, <3.494789, -2.417060, -1.135791>, <3.350378, -2.565277, -1.236180>, <3.419170, -2.605971, -1.308019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.317364, -1.163379, -1.135460>, <3.286068, -1.341213, -1.145538>, <3.200403, -1.577031, -1.147627>, <3.213045, -1.756160, -1.169054>, 
      <3.317364, -1.163379, -1.135460>, <3.347017, -1.453148, -1.106372>, <3.107375, -1.522861, -1.113288>, <3.120017, -1.701990, -1.134715>, 
      <3.317364, -1.163379, -1.135460>, <3.347017, -1.453148, -1.106372>, <3.417792, -1.457219, -1.223633>, <3.444284, -1.587650, -1.215624>, 
      <3.317364, -1.163379, -1.135460>, <3.378312, -1.275314, -1.096294>, <3.503430, -1.422990, -1.158345>, <3.529921, -1.553421, -1.150336>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.808830, -1.301609, -1.300102>, <3.822559, -1.449658, -1.272178>, <3.916290, -1.641195, -1.278556>, <3.935657, -1.789679, -1.300102>, 
      <3.656510, -1.304046, -1.248233>, <3.670238, -1.452095, -1.220309>, <3.701353, -1.677751, -1.245273>, <3.720720, -1.826235, -1.266819>, 
      <3.326812, -1.234091, -1.279711>, <3.295516, -1.411925, -1.289789>, <3.381981, -1.682763, -1.214651>, <3.394622, -1.861892, -1.236078>, 
      <3.317364, -1.163379, -1.135460>, <3.286068, -1.341213, -1.145538>, <3.200403, -1.577031, -1.147627>, <3.213045, -1.756160, -1.169054>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.219760, -1.148940, -1.442747>, <4.279778, -1.265880, -1.420863>, <4.307842, -1.436025, -1.354793>, <4.344276, -1.563763, -1.344225>, 
      <4.103148, -1.204938, -1.491661>, <4.163167, -1.321878, -1.469778>, <4.188565, -1.490741, -1.405538>, <4.224999, -1.618479, -1.394970>, 
      <3.939732, -1.299514, -1.344677>, <3.953461, -1.447564, -1.316753>, <4.053408, -1.617875, -1.299789>, <4.072774, -1.766358, -1.321335>, 
      <3.808830, -1.301609, -1.300102>, <3.822559, -1.449658, -1.272178>, <3.916290, -1.641195, -1.278556>, <3.935657, -1.789679, -1.300102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.709882, -0.868911, -0.922143>, <4.753929, -1.018405, -0.897822>, <4.788768, -1.228412, -0.923104>, <4.824060, -1.382144, -0.922143>, 
      <4.657351, -0.938923, -1.135236>, <4.701398, -1.088417, -1.110915>, <4.739616, -1.275765, -1.110352>, <4.774908, -1.429497, -1.109390>, 
      <4.414003, -1.055662, -1.361269>, <4.474022, -1.172601, -1.339385>, <4.476798, -1.358521, -1.282913>, <4.513232, -1.486258, -1.272345>, 
      <4.219760, -1.148940, -1.442747>, <4.279778, -1.265880, -1.420863>, <4.307842, -1.436025, -1.354793>, <4.344276, -1.563763, -1.344225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.459215, -0.829797, -0.471387>, <4.490314, -0.982272, -0.445610>, <4.539275, -1.189385, -0.460942>, <4.573394, -1.343030, -0.471387>, 
      <4.601214, -0.823452, -0.533637>, <4.632312, -0.975927, -0.507860>, <4.674292, -1.184727, -0.537281>, <4.708411, -1.338373, -0.547725>, 
      <4.745266, -0.821751, -0.778606>, <4.789313, -0.971245, -0.754284>, <4.827038, -1.191542, -0.777313>, <4.862330, -1.345275, -0.776352>, 
      <4.709882, -0.868911, -0.922143>, <4.753929, -1.018405, -0.897822>, <4.788768, -1.228412, -0.923104>, <4.824060, -1.382144, -0.922143>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.756706, -0.911501, -0.504287>, <3.890293, -1.026726, -0.531343>, <4.028608, -1.238412, -0.510256>, <4.085010, -1.407638, -0.504287>, 
      <3.934726, -0.859494, -0.400755>, <4.068313, -0.974719, -0.427811>, <4.151026, -1.213729, -0.430604>, <4.207428, -1.382955, -0.424635>, 
      <4.264847, -0.838482, -0.386179>, <4.295945, -0.990956, -0.360402>, <4.410394, -1.193831, -0.388074>, <4.444513, -1.347476, -0.398519>, 
      <4.459215, -0.829797, -0.471387>, <4.490314, -0.982272, -0.445610>, <4.539275, -1.189385, -0.460942>, <4.573394, -1.343030, -0.471387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.756706, -0.911501, -0.504287>, <3.553236, -0.970943, -0.622620>, <3.303111, -1.056707, -0.917851>, <3.317364, -1.163379, -1.135460>, 
      <3.890293, -1.026726, -0.531343>, <3.686823, -1.086168, -0.649676>, <3.364060, -1.168642, -0.878684>, <3.378312, -1.275314, -1.096294>, 
      <4.028608, -1.238412, -0.510256>, <3.814350, -1.281612, -0.649666>, <3.699908, -1.344459, -1.008554>, <3.503430, -1.422990, -1.158345>, 
      <4.085010, -1.407638, -0.504287>, <3.870752, -1.450838, -0.643697>, <3.726399, -1.474889, -1.000546>, <3.529921, -1.553421, -1.150336>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.819977, -0.542221, -1.535393>, <3.819193, -0.780411, -1.547996>, <3.787184, -1.068184, -1.344130>, <3.808830, -1.301609, -1.300102>, 
      <3.610108, -0.621364, -1.583965>, <3.609324, -0.859555, -1.596568>, <3.634864, -1.070622, -1.292261>, <3.656510, -1.304046, -1.248233>, 
      <3.286691, -0.645372, -1.370935>, <3.289856, -0.807611, -1.323992>, <3.249595, -1.092280, -1.329331>, <3.326812, -1.234091, -1.279711>, 
      <3.089083, -0.743805, -1.433623>, <3.092248, -0.906044, -1.386680>, <3.240147, -1.021568, -1.185080>, <3.317364, -1.163379, -1.135460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.819977, -0.542221, -1.535393>, <3.939912, -0.724237, -1.507599>, <4.120785, -0.956098, -1.478835>, <4.219760, -1.148940, -1.442747>, 
      <3.819977, -0.542221, -1.535393>, <3.939128, -0.962427, -1.520202>, <4.004173, -1.012096, -1.527749>, <4.103148, -1.204938, -1.491661>, 
      <3.819977, -0.542221, -1.535393>, <3.939128, -0.962427, -1.520202>, <3.918086, -1.066090, -1.388705>, <3.939732, -1.299514, -1.344677>, 
      <3.819977, -0.542221, -1.535393>, <3.819193, -0.780411, -1.547996>, <3.787184, -1.068184, -1.344130>, <3.808830, -1.301609, -1.300102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.100801, -0.900457, -1.763540>, <3.097286, -0.853461, -1.664565>, <2.994692, -0.790823, -1.463567>, <3.089083, -0.743805, -1.433623>, 
      <3.100801, -0.900457, -1.763540>, <3.239421, -0.874073, -1.456789>, <3.030398, -0.835003, -1.612234>, <3.124789, -0.787984, -1.582290>, 
      <3.100801, -0.900457, -1.763540>, <3.239421, -0.874073, -1.456789>, <3.286283, -0.709547, -1.296016>, <3.285051, -0.670091, -1.046537>, 
      <3.100801, -0.900457, -1.763540>, <3.242936, -0.921069, -1.555764>, <3.312280, -0.836968, -1.204274>, <3.311048, -0.797513, -0.954795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.100801, -0.900457, -1.763540>, <3.242936, -0.921069, -1.555764>, <3.312280, -0.836968, -1.204274>, <3.311048, -0.797513, -0.954795>, 
      <3.089433, -1.061169, -1.756839>, <3.231569, -1.081781, -1.549063>, <3.341387, -0.979631, -1.101559>, <3.340155, -0.940176, -0.852079>, 
      <2.924141, -1.214915, -1.639770>, <3.067203, -1.218307, -1.477750>, <3.231497, -1.235176, -1.163892>, <3.241606, -1.208803, -0.949576>, 
      <2.885822, -1.368872, -1.610937>, <3.028884, -1.372264, -1.448917>, <3.209616, -1.410510, -1.186908>, <3.219726, -1.384137, -0.972593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.093215, -0.657546, -0.227581>, <3.103479, -0.827590, -0.217044>, <2.976872, -1.037451, -0.266997>, <2.948565, -1.205195, -0.280856>, 
      <3.158565, -0.699536, -0.445745>, <3.168829, -0.869580, -0.435209>, <3.126916, -1.088586, -0.432637>, <3.098608, -1.256329, -0.446496>, 
      <3.309918, -0.761339, -0.726060>, <3.339025, -0.904002, -0.623345>, <3.252329, -1.180831, -0.722273>, <3.230448, -1.356165, -0.745289>, 
      <3.311048, -0.797513, -0.954795>, <3.340155, -0.940176, -0.852079>, <3.241606, -1.208803, -0.949576>, <3.219726, -1.384137, -0.972593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.157740, -0.607825, -0.316481>, <3.125254, -0.619089, -0.305243>, <3.126271, -0.665865, -0.239690>, <3.093215, -0.657546, -0.227581>, 
      <3.137143, -0.648619, -0.651624>, <3.104657, -0.659883, -0.640385>, <3.191620, -0.707855, -0.457854>, <3.158565, -0.699536, -0.445745>, 
      <3.013196, -0.649910, -1.117658>, <3.048902, -0.694089, -1.266325>, <3.283921, -0.633917, -0.817802>, <3.309918, -0.761339, -0.726060>, 
      <3.089083, -0.743805, -1.433623>, <3.124789, -0.787984, -1.582290>, <3.285051, -0.670091, -1.046537>, <3.311048, -0.797513, -0.954795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.157740, -0.607825, -0.316481>, <3.137143, -0.648619, -0.651624>, <3.013196, -0.649910, -1.117658>, <3.089083, -0.743805, -1.433623>, 
      <3.250192, -0.795384, -0.310409>, <3.229594, -0.836178, -0.645551>, <3.016361, -0.812148, -1.070715>, <3.092248, -0.906044, -1.386680>, 
      <3.600128, -0.776445, -0.472574>, <3.396658, -0.835887, -0.590907>, <3.225894, -0.914896, -0.967471>, <3.240147, -1.021568, -1.185080>, 
      <3.756706, -0.911501, -0.504287>, <3.553236, -0.970943, -0.622620>, <3.303111, -1.056707, -0.917851>, <3.317364, -1.163379, -1.135460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.894778, -0.691117, -2.170617>, <1.772529, -0.689776, -2.181122>, <1.608507, -0.686063, -2.170375>, <1.485820, -0.683897, -2.170271>, 
      <1.896601, -0.471905, -2.173511>, <1.774352, -0.470564, -2.184016>, <1.588672, -0.488152, -2.121249>, <1.465985, -0.485986, -2.121145>, 
      <1.893708, -0.173830, -2.091668>, <1.770320, -0.182007, -2.100276>, <1.562845, -0.209408, -2.055643>, <1.439539, -0.222104, -2.055643>, 
      <1.830725, 0.018128, -2.006517>, <1.707337, 0.009951, -2.015126>, <1.543010, -0.011497, -2.006517>, <1.419704, -0.024193, -2.006517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.894778, -0.691117, -2.170617>, <1.893036, -0.900588, -2.167852>, <1.834028, -1.156051, -2.029244>, <1.819257, -1.360978, -1.988314>, 
      <1.772529, -0.689776, -2.181122>, <1.770787, -0.899246, -2.178357>, <1.724651, -1.157335, -2.038821>, <1.709881, -1.362262, -1.997892>, 
      <1.608507, -0.686063, -2.170375>, <1.598772, -0.891968, -2.115691>, <1.572900, -1.163290, -2.042676>, <1.563164, -1.369195, -1.987992>, 
      <1.485820, -0.683897, -2.170271>, <1.476084, -0.889802, -2.115587>, <1.463103, -1.164343, -2.042676>, <1.453367, -1.370248, -1.987992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.251233, -0.692296, -2.104496>, <2.243201, -0.902196, -2.100742>, <2.170347, -1.156781, -1.966594>, <2.149705, -1.362071, -1.927017>, 
      <2.146664, -0.691376, -2.134388>, <2.138633, -0.901276, -2.130634>, <2.073408, -1.155928, -1.994306>, <2.052766, -1.361219, -1.954728>, 
      <2.003134, -0.692306, -2.161306>, <2.001392, -0.901777, -2.158541>, <1.934462, -1.154871, -2.020449>, <1.919692, -1.359799, -1.979519>, 
      <1.894778, -0.691117, -2.170617>, <1.893036, -0.900588, -2.167852>, <1.834028, -1.156051, -2.029244>, <1.819257, -1.360978, -1.988314>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.621430, -0.697508, -1.962893>, <2.634600, -0.907561, -1.957089>, <2.519660, -1.161297, -1.832340>, <2.492894, -1.366903, -1.795745>, 
      <2.513816, -0.671141, -2.006081>, <2.526986, -0.881194, -2.000278>, <2.418367, -1.160361, -1.875835>, <2.391600, -1.365967, -1.839239>, 
      <2.365566, -0.693302, -2.071812>, <2.357534, -0.903201, -2.068058>, <2.276339, -1.157713, -1.936295>, <2.255696, -1.363003, -1.896718>, 
      <2.251233, -0.692296, -2.104496>, <2.243201, -0.902196, -2.100742>, <2.170347, -1.156781, -1.966594>, <2.149705, -1.362071, -1.927017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.621430, -0.697508, -1.962893>, <2.772763, -0.734588, -1.902158>, <3.006697, -0.886810, -1.901103>, <3.100801, -0.900457, -1.763540>, 
      <2.634600, -0.907561, -1.957089>, <2.785933, -0.944641, -1.896355>, <2.995329, -1.047522, -1.894402>, <3.089433, -1.061169, -1.756839>, 
      <2.519660, -1.161297, -1.832340>, <2.639355, -1.162403, -1.780945>, <2.837929, -1.212871, -1.737407>, <2.924141, -1.214915, -1.639770>, 
      <2.492894, -1.366903, -1.795745>, <2.612589, -1.368009, -1.744349>, <2.799610, -1.366828, -1.708574>, <2.885822, -1.368872, -1.610937>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.481291, -0.218793, -1.111410>, <4.583124, -0.407073, -1.099319>, <4.650012, -0.665716, -0.955201>, <4.709882, -0.868911, -0.922143>, 
      <4.356092, -0.294794, -1.319982>, <4.457924, -0.483074, -1.307891>, <4.597482, -0.735728, -1.168294>, <4.657351, -0.938923, -1.135236>, 
      <4.053042, -0.454331, -1.481453>, <4.172976, -0.636347, -1.453659>, <4.315028, -0.862819, -1.397357>, <4.414003, -1.055662, -1.361269>, 
      <3.819977, -0.542221, -1.535393>, <3.939912, -0.724237, -1.507599>, <4.120785, -0.956098, -1.478835>, <4.219760, -1.148940, -1.442747>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.345054, -0.223478, -0.660654>, <4.409599, -0.401247, -0.619238>, <4.421045, -0.642647, -0.503026>, <4.459215, -0.829797, -0.471387>, 
      <4.462494, -0.188959, -0.731189>, <4.527038, -0.366727, -0.689772>, <4.563044, -0.636303, -0.565276>, <4.601214, -0.823452, -0.533637>, 
      <4.550692, -0.176664, -0.995793>, <4.652525, -0.364944, -0.983702>, <4.685397, -0.618556, -0.811664>, <4.745266, -0.821751, -0.778606>, 
      <4.481291, -0.218793, -1.111410>, <4.583124, -0.407073, -1.099319>, <4.650012, -0.665716, -0.955201>, <4.709882, -0.868911, -0.922143>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.345054, -0.223478, -0.660654>, <4.022210, -0.318372, -0.466753>, <3.506518, -0.486888, -0.437140>, <3.157740, -0.607825, -0.316481>, 
      <4.409599, -0.401247, -0.619238>, <4.086756, -0.496140, -0.425337>, <3.598970, -0.674447, -0.431068>, <3.250192, -0.795384, -0.310409>, 
      <4.421045, -0.642647, -0.503026>, <4.226676, -0.651332, -0.417818>, <3.778148, -0.724438, -0.369042>, <3.600128, -0.776445, -0.472574>, 
      <4.459215, -0.829797, -0.471387>, <4.264847, -0.838482, -0.386179>, <3.934726, -0.859494, -0.400755>, <3.756706, -0.911501, -0.504287>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.637153, -0.476808, -0.125780>, <2.640045, -0.680065, -0.109112>, <2.533910, -0.939929, -0.169296>, <2.507634, -1.141458, -0.186482>, 
      <2.778756, -0.520171, -0.151472>, <2.781649, -0.723429, -0.134804>, <2.666568, -0.962587, -0.192825>, <2.640292, -1.164116, -0.210010>, 
      <2.955863, -0.622978, -0.177266>, <2.966127, -0.793022, -0.166730>, <2.887463, -1.006981, -0.168294>, <2.859155, -1.174724, -0.182152>, 
      <3.093215, -0.657546, -0.227581>, <3.103479, -0.827590, -0.217044>, <2.976872, -1.037451, -0.266997>, <2.948565, -1.205195, -0.280856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.241656, -0.396773, -0.073076>, <2.240405, -0.600152, -0.053521>, <2.160883, -0.864731, -0.119388>, <2.140992, -1.067262, -0.137623>, 
      <2.361453, -0.413900, -0.089186>, <2.360202, -0.617279, -0.069631>, <2.271940, -0.880609, -0.134323>, <2.252048, -1.083140, -0.152558>, 
      <2.522139, -0.441587, -0.104912>, <2.525032, -0.644845, -0.088244>, <2.424017, -0.921159, -0.149805>, <2.397741, -1.122688, -0.166991>, 
      <2.637153, -0.476808, -0.125780>, <2.640045, -0.680065, -0.109112>, <2.533910, -0.939929, -0.169296>, <2.507634, -1.141458, -0.186482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.940692, -0.377236, -0.032119>, <1.936319, -0.580120, -0.011644>, <1.877053, -0.846641, -0.080601>, <1.861987, -1.049151, -0.099655>, 
      <2.031614, -0.380162, -0.040002>, <2.027241, -0.583046, -0.019527>, <1.961341, -0.849353, -0.087909>, <1.946275, -1.051863, -0.106963>, 
      <2.152056, -0.383963, -0.061026>, <2.150805, -0.587342, -0.041471>, <2.077821, -0.852856, -0.108218>, <2.057929, -1.055387, -0.126453>, 
      <2.241656, -0.396773, -0.073076>, <2.240405, -0.600152, -0.053521>, <2.160883, -0.864731, -0.119388>, <2.140992, -1.067262, -0.137623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.616835, -0.376668, -0.018903>, <1.609142, -0.578791, 0.001586>, <1.571657, -0.846481, -0.068107>, <1.561758, -1.048626, -0.087403>, 
      <1.714041, -0.375293, -0.021011>, <1.706348, -0.577417, -0.000522>, <1.661763, -0.844929, -0.070182>, <1.651865, -1.047074, -0.089478>, 
      <1.843867, -0.374121, -0.023724>, <1.839494, -0.577005, -0.003249>, <1.787292, -0.843753, -0.072819>, <1.772226, -1.046263, -0.091873>, 
      <1.940692, -0.377236, -0.032119>, <1.936319, -0.580120, -0.011644>, <1.877053, -0.846641, -0.080601>, <1.861987, -1.049151, -0.099655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.312510, -0.386120, -0.018495>, <1.310778, -0.587863, 0.002000>, <1.313970, -0.856727, -0.067757>, <1.313520, -1.058598, -0.087025>, 
      <1.403834, -0.384343, -0.018495>, <1.402103, -0.586086, 0.002000>, <1.388478, -0.854881, -0.067757>, <1.388029, -1.056752, -0.087025>, 
      <1.525524, -0.377959, -0.016923>, <1.517831, -0.580083, 0.003567>, <1.497156, -0.847765, -0.066392>, <1.487257, -1.049909, -0.085687>, 
      <1.616835, -0.376668, -0.018903>, <1.609142, -0.578791, 0.001586>, <1.571657, -0.846481, -0.068107>, <1.561758, -1.048626, -0.087403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.202885, 0.027706, -1.951876>, <2.285779, -0.161643, -2.030860>, <2.259693, -0.471217, -2.108450>, <2.251233, -0.692296, -2.104496>, 
      <2.094931, 0.021057, -1.984186>, <2.177825, -0.168292, -2.063170>, <2.155124, -0.470298, -2.138343>, <2.146664, -0.691376, -2.134388>, 
      <1.943087, 0.025574, -1.998678>, <2.006071, -0.166384, -2.083828>, <2.004956, -0.473094, -2.164199>, <2.003134, -0.692306, -2.161306>, 
      <1.830725, 0.018128, -2.006517>, <1.893708, -0.173830, -2.091668>, <1.896601, -0.471905, -2.173511>, <1.894778, -0.691117, -2.170617>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.403842, 0.053426, -1.834988>, <2.523242, -0.140172, -1.903894>, <2.606564, -0.460399, -1.969444>, <2.621430, -0.697508, -1.962893>, 
      <2.337939, 0.047972, -1.858455>, <2.457339, -0.145626, -1.927361>, <2.498950, -0.434032, -2.012632>, <2.513816, -0.671141, -2.006081>, 
      <2.269991, 0.031839, -1.931792>, <2.352886, -0.157510, -2.010776>, <2.374025, -0.472223, -2.075767>, <2.365566, -0.693302, -2.071812>, 
      <2.202885, 0.027706, -1.951876>, <2.285779, -0.161643, -2.030860>, <2.259693, -0.471217, -2.108450>, <2.251233, -0.692296, -2.104496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.989211, 0.092782, -1.671879>, <3.164342, -0.145238, -1.729670>, <3.122028, -0.600362, -1.776052>, <3.100801, -0.900457, -1.763540>, 
      <2.818647, 0.087989, -1.737132>, <2.993778, -0.150031, -1.794923>, <3.027924, -0.586716, -1.913615>, <3.006697, -0.886810, -1.901103>, 
      <2.575419, 0.067626, -1.773893>, <2.694819, -0.125972, -1.842798>, <2.757897, -0.497479, -1.908710>, <2.772763, -0.734588, -1.902158>, 
      <2.403842, 0.053426, -1.834988>, <2.523242, -0.140172, -1.903894>, <2.606564, -0.460399, -1.969444>, <2.621430, -0.697508, -1.962893>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.293140, 0.078416, -1.494768>, <3.447539, 0.073955, -1.411530>, <3.668758, 0.029680, -1.318908>, <3.813339, 0.068973, -1.227585>, 
      <3.437974, -0.129161, -1.524144>, <3.592373, -0.133622, -1.440906>, <3.827367, -0.094586, -1.358309>, <3.971948, -0.055293, -1.266986>, 
      <3.084309, -0.499078, -1.504434>, <3.281917, -0.400645, -1.441745>, <3.610782, -0.416344, -1.573118>, <3.820652, -0.337201, -1.524545>, 
      <3.089083, -0.743805, -1.433623>, <3.286691, -0.645372, -1.370935>, <3.610108, -0.621364, -1.583965>, <3.819977, -0.542221, -1.535393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.293140, 0.078416, -1.494768>, <3.437974, -0.129161, -1.524144>, <3.084309, -0.499078, -1.504434>, <3.089083, -0.743805, -1.433623>, 
      <3.200201, 0.081101, -1.544872>, <3.345036, -0.126476, -1.574248>, <2.989918, -0.546096, -1.534378>, <2.994692, -0.790823, -1.463567>, 
      <3.087823, 0.095553, -1.634153>, <3.262954, -0.142467, -1.691944>, <3.118512, -0.553367, -1.677077>, <3.097286, -0.853461, -1.664565>, 
      <2.989211, 0.092782, -1.671879>, <3.164342, -0.145238, -1.729670>, <3.122028, -0.600362, -1.776052>, <3.100801, -0.900457, -1.763540>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.081614, 0.292699, -0.996738>, <4.261772, 0.211594, -1.005188>, <4.387362, -0.045128, -1.122562>, <4.481291, -0.218793, -1.111410>, 
      <4.036480, 0.232523, -1.097337>, <4.216638, 0.151418, -1.105787>, <4.262163, -0.121129, -1.331134>, <4.356092, -0.294794, -1.319982>, 
      <3.916843, 0.097102, -1.162208>, <4.075452, -0.027164, -1.201609>, <4.053716, -0.249311, -1.470605>, <4.053042, -0.454331, -1.481453>, 
      <3.813339, 0.068973, -1.227585>, <3.971948, -0.055293, -1.266986>, <3.820652, -0.337201, -1.524545>, <3.819977, -0.542221, -1.535393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <4.028653, 0.356049, -0.747664>, <4.207534, 0.268846, -0.729910>, <4.278446, -0.040027, -0.703394>, <4.345054, -0.223478, -0.660654>, 
      <4.098610, 0.360640, -0.783469>, <4.277491, 0.273437, -0.765714>, <4.395885, -0.005507, -0.773929>, <4.462494, -0.188959, -0.731189>, 
      <4.109899, 0.330411, -0.933692>, <4.290057, 0.249306, -0.942142>, <4.456764, -0.002999, -1.006945>, <4.550692, -0.176664, -0.995793>, 
      <4.081614, 0.292699, -0.996738>, <4.261772, 0.211594, -1.005188>, <4.387362, -0.045128, -1.122562>, <4.481291, -0.218793, -1.111410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.191909, 0.234317, -0.541382>, <3.344377, 0.031461, -0.477440>, <3.042085, -0.373194, -0.324077>, <3.157740, -0.607825, -0.316481>, 
      <3.440606, 0.242927, -0.620451>, <3.593073, 0.040071, -0.556509>, <3.390863, -0.252257, -0.444736>, <3.506518, -0.486888, -0.437140>, 
      <3.796617, 0.340823, -0.628907>, <3.975498, 0.253620, -0.611152>, <3.955602, -0.134920, -0.509493>, <4.022210, -0.318372, -0.466753>, 
      <4.028653, 0.356049, -0.747664>, <4.207534, 0.268846, -0.729910>, <4.278446, -0.040027, -0.703394>, <4.345054, -0.223478, -0.660654>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.856776, 0.315479, -0.375083>, <3.035479, 0.079424, -0.307683>, <3.074955, -0.355032, -0.246326>, <3.093215, -0.657546, -0.227581>, 
      <2.963233, 0.289464, -0.409436>, <3.141936, 0.053409, -0.342036>, <3.108011, -0.363351, -0.258435>, <3.126271, -0.665865, -0.239690>, 
      <3.082519, 0.230530, -0.506603>, <3.234987, 0.027674, -0.442661>, <3.009600, -0.384458, -0.312839>, <3.125254, -0.619089, -0.305243>, 
      <3.191909, 0.234317, -0.541382>, <3.344377, 0.031461, -0.477440>, <3.042085, -0.373194, -0.324077>, <3.157740, -0.607825, -0.316481>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.485600, 0.406920, -0.313458>, <2.623861, 0.180755, -0.240944>, <2.633256, -0.202937, -0.148239>, <2.637153, -0.476808, -0.125780>, 
      <2.597766, 0.380166, -0.327484>, <2.736027, 0.154001, -0.254969>, <2.774859, -0.246300, -0.173931>, <2.778756, -0.520171, -0.151472>, 
      <2.749100, 0.341792, -0.340336>, <2.927803, 0.105737, -0.272936>, <2.937603, -0.320465, -0.196011>, <2.955863, -0.622978, -0.177266>, 
      <2.856776, 0.315479, -0.375083>, <3.035479, 0.079424, -0.307683>, <3.074955, -0.355032, -0.246326>, <3.093215, -0.657546, -0.227581>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.150534, 0.483930, -0.286771>, <2.253362, 0.241832, -0.212746>, <2.243329, -0.124784, -0.099228>, <2.241656, -0.396773, -0.073076>, 
      <2.252024, 0.466405, -0.296502>, <2.354852, 0.224307, -0.222477>, <2.363126, -0.141911, -0.115338>, <2.361453, -0.413900, -0.089186>, 
      <2.385708, 0.430746, -0.300967>, <2.523969, 0.204581, -0.228453>, <2.518242, -0.167716, -0.127371>, <2.522139, -0.441587, -0.104912>, 
      <2.485600, 0.406920, -0.313458>, <2.623861, 0.180755, -0.240944>, <2.633256, -0.202937, -0.148239>, <2.637153, -0.476808, -0.125780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.895567, 0.508805, -0.256883>, <1.966577, 0.255321, -0.178847>, <1.946579, -0.104121, -0.059682>, <1.940692, -0.377236, -0.032119>, 
      <1.972600, 0.504694, -0.262871>, <2.043610, 0.251210, -0.184835>, <2.037500, -0.107047, -0.067565>, <2.031614, -0.380162, -0.040002>, 
      <2.074626, 0.497038, -0.279493>, <2.177454, 0.254940, -0.205468>, <2.153729, -0.111974, -0.087178>, <2.152056, -0.383963, -0.061026>, 
      <2.150534, 0.483930, -0.286771>, <2.253362, 0.241832, -0.212746>, <2.243329, -0.124784, -0.099228>, <2.241656, -0.396773, -0.073076>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.621161, 0.512180, -0.245623>, <1.532864, 0.511207, -0.243875>, <1.415223, 0.504253, -0.245623>, <1.326920, 0.502541, -0.245623>, 
      <1.621161, 0.512180, -0.245623>, <1.488423, 0.703737, -0.303493>, <1.411692, 0.679039, -0.299444>, <1.323389, 0.677327, -0.299444>, 
      <1.621161, 0.512180, -0.245623>, <1.488423, 0.703737, -0.303493>, <1.443713, 0.742754, -0.332609>, <1.342297, 0.909837, -0.398903>, 
      <1.621161, 0.512180, -0.245623>, <1.576720, 0.704710, -0.305241>, <1.384523, 0.902042, -0.400308>, <1.283107, 1.069125, -0.466602>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.621161, 0.512180, -0.245623>, <1.532864, 0.511207, -0.243875>, <1.415223, 0.504253, -0.245623>, <1.326920, 0.502541, -0.245623>, 
      <1.680417, 0.255466, -0.166130>, <1.592120, 0.254494, -0.164382>, <1.420536, 0.241287, -0.164649>, <1.332233, 0.239575, -0.164649>, 
      <1.627248, -0.103072, -0.046638>, <1.535937, -0.104363, -0.044657>, <1.406184, -0.110560, -0.046309>, <1.314860, -0.112337, -0.046309>, 
      <1.616835, -0.376668, -0.018903>, <1.525524, -0.377959, -0.016923>, <1.403834, -0.384343, -0.018495>, <1.312510, -0.386120, -0.018495>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.621161, 0.512180, -0.245623>, <1.680417, 0.255466, -0.166130>, <1.627248, -0.103072, -0.046638>, <1.616835, -0.376668, -0.018903>, 
      <1.703537, 0.513087, -0.247254>, <1.762794, 0.256374, -0.167761>, <1.724453, -0.101697, -0.048746>, <1.714041, -0.375293, -0.021011>, 
      <1.813534, 0.513183, -0.250507>, <1.884543, 0.259699, -0.172471>, <1.849754, -0.101006, -0.051287>, <1.843867, -0.374121, -0.023724>, 
      <1.895567, 0.508805, -0.256883>, <1.966577, 0.255321, -0.178847>, <1.946579, -0.104121, -0.059682>, <1.940692, -0.377236, -0.032119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.636782, 0.711242, -1.519033>, <1.806613, 0.506181, -1.648886>, <2.091910, 0.281197, -1.846136>, <2.202885, 0.027706, -1.951876>, 
      <1.578009, 0.708774, -1.536420>, <1.747840, 0.503714, -1.666272>, <1.983955, 0.274548, -1.878446>, <2.094931, 0.021057, -1.984186>, 
      <1.495098, 0.711115, -1.539339>, <1.613992, 0.502960, -1.676828>, <1.863698, 0.267535, -1.891346>, <1.943087, 0.025574, -1.998678>, 
      <1.434410, 0.711977, -1.548219>, <1.553304, 0.503822, -1.685708>, <1.751336, 0.260089, -1.899186>, <1.830725, 0.018128, -2.006517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.545329, 1.034095, -0.466602>, <1.467156, 1.044623, -0.457821>, <1.334580, 1.124928, -0.489741>, <1.283107, 1.069125, -0.466602>, 
      <1.650400, 0.876508, -0.403686>, <1.572228, 0.887035, -0.394905>, <1.435996, 0.957845, -0.423448>, <1.384523, 0.902042, -0.400308>, 
      <1.843951, 0.693061, -0.313607>, <1.761917, 0.697439, -0.307230>, <1.659096, 0.705617, -0.306872>, <1.576720, 0.704710, -0.305241>, 
      <1.895567, 0.508805, -0.256883>, <1.813534, 0.513183, -0.250507>, <1.703537, 0.513087, -0.247254>, <1.621161, 0.512180, -0.245623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.639416, 1.021141, -0.506625>, <1.613890, 1.027942, -0.490557>, <1.575783, 1.029994, -0.470023>, <1.545329, 1.034095, -0.466602>, 
      <1.792751, 0.859978, -0.440669>, <1.767226, 0.866778, -0.424601>, <1.680855, 0.872407, -0.407107>, <1.650400, 0.876508, -0.403686>, 
      <2.063219, 0.689504, -0.349628>, <1.987311, 0.702612, -0.342350>, <1.920983, 0.688950, -0.319595>, <1.843951, 0.693061, -0.313607>, 
      <2.150534, 0.483930, -0.286771>, <2.074626, 0.497038, -0.279493>, <1.972600, 0.504694, -0.262871>, <1.895567, 0.508805, -0.256883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.746217, 0.980576, -0.593055>, <1.712392, 0.992599, -0.569426>, <1.674896, 1.011689, -0.528959>, <1.639416, 1.021141, -0.506625>, 
      <1.968032, 0.808479, -0.509176>, <1.934207, 0.820502, -0.485547>, <1.828232, 0.850525, -0.463003>, <1.792751, 0.859978, -0.440669>, 
      <2.338187, 0.648056, -0.390773>, <2.238295, 0.671882, -0.378282>, <2.164709, 0.671979, -0.359360>, <2.063219, 0.689504, -0.349628>, 
      <2.485600, 0.406920, -0.313458>, <2.385708, 0.430746, -0.300967>, <2.252024, 0.466405, -0.296502>, <2.150534, 0.483930, -0.286771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.889740, 0.932166, -0.681489>, <1.848116, 0.944049, -0.651575>, <1.787630, 0.965856, -0.621984>, <1.746217, 0.980576, -0.593055>, 
      <2.179851, 0.747160, -0.589567>, <2.138227, 0.759043, -0.559653>, <2.009445, 0.793759, -0.538105>, <1.968032, 0.808479, -0.509176>, 
      <2.647173, 0.592351, -0.454138>, <2.539497, 0.618664, -0.419391>, <2.450354, 0.621303, -0.404798>, <2.338187, 0.648056, -0.390773>, 
      <2.856776, 0.315479, -0.375083>, <2.749100, 0.341792, -0.340336>, <2.597766, 0.380166, -0.327484>, <2.485600, 0.406920, -0.313458>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.023352, 0.901460, -0.792224>, <1.987387, 0.911390, -0.754767>, <1.931563, 0.920226, -0.711546>, <1.889740, 0.932166, -0.681489>, 
      <2.373919, 0.701317, -0.716971>, <2.337954, 0.711248, -0.679514>, <2.221674, 0.735220, -0.619624>, <2.179851, 0.747160, -0.589567>, 
      <2.952671, 0.552619, -0.641714>, <2.843281, 0.548832, -0.606935>, <2.753630, 0.566336, -0.488491>, <2.647173, 0.592351, -0.454138>, 
      <3.191909, 0.234317, -0.541382>, <3.082519, 0.230530, -0.506603>, <2.963233, 0.289464, -0.409436>, <2.856776, 0.315479, -0.375083>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.085104, 0.878223, -0.884960>, <2.072366, 0.885983, -0.854247>, <2.046579, 0.895047, -0.816415>, <2.023352, 0.901460, -0.792224>, 
      <2.668169, 0.721571, -0.843771>, <2.655430, 0.729331, -0.813058>, <2.397146, 0.694904, -0.741162>, <2.373919, 0.701317, -0.716971>, 
      <3.486852, 0.620171, -0.801439>, <3.254815, 0.604945, -0.682682>, <3.201368, 0.561229, -0.720784>, <2.952671, 0.552619, -0.641714>, 
      <4.028653, 0.356049, -0.747664>, <3.796617, 0.340823, -0.628907>, <3.440606, 0.242927, -0.620451>, <3.191909, 0.234317, -0.541382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.109601, 0.848918, -1.000175>, <2.108003, 0.859747, -0.965445>, <2.098690, 0.869947, -0.917716>, <2.085104, 0.878223, -0.884960>, 
      <2.701205, 0.682052, -0.999144>, <2.699607, 0.692882, -0.964414>, <2.681755, 0.713295, -0.876527>, <2.668169, 0.721571, -0.843771>, 
      <3.521619, 0.544803, -0.970474>, <3.549904, 0.582515, -0.907428>, <3.556809, 0.624762, -0.837244>, <3.486852, 0.620171, -0.801439>, 
      <4.081614, 0.292699, -0.996738>, <4.109899, 0.330411, -0.933692>, <4.098610, 0.360640, -0.783469>, <4.028653, 0.356049, -0.747664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.095316, 0.809001, -1.106961>, <2.107650, 0.818165, -1.076107>, <2.111113, 0.838668, -1.033049>, <2.109601, 0.848918, -1.000175>, 
      <2.610723, 0.586993, -1.143148>, <2.623057, 0.596156, -1.112294>, <2.702717, 0.671802, -1.032018>, <2.701205, 0.682052, -0.999144>, 
      <3.378896, 0.409346, -1.119663>, <3.482400, 0.437475, -1.054286>, <3.476486, 0.484627, -1.071073>, <3.521619, 0.544803, -0.970474>, 
      <3.813339, 0.068973, -1.227585>, <3.916843, 0.097102, -1.162208>, <4.036480, 0.232523, -1.097337>, <4.081614, 0.292699, -0.996738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.022786, 0.784415, -1.217351>, <2.047662, 0.791829, -1.186516>, <2.080893, 0.798285, -1.143041>, <2.095316, 0.809001, -1.106961>, 
      <2.403892, 0.572615, -1.300576>, <2.428768, 0.580029, -1.269741>, <2.596300, 0.576277, -1.179228>, <2.610723, 0.586993, -1.143148>, 
      <3.040839, 0.440014, -1.443595>, <3.195238, 0.435553, -1.360357>, <3.234315, 0.370054, -1.210986>, <3.378896, 0.409346, -1.119663>, 
      <3.293140, 0.078416, -1.494768>, <3.447539, 0.073955, -1.411530>, <3.668758, 0.029680, -1.318908>, <3.813339, 0.068973, -1.227585>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.888389, 0.747333, -1.363459>, <1.933767, 0.757011, -1.324500>, <1.985394, 0.773272, -1.263701>, <2.022786, 0.784415, -1.217351>, 
      <2.218636, 0.550968, -1.455985>, <2.264014, 0.560646, -1.417026>, <2.366500, 0.561472, -1.346926>, <2.403892, 0.572615, -1.300576>, 
      <2.759352, 0.405184, -1.596028>, <2.857964, 0.407955, -1.558302>, <2.947900, 0.442699, -1.493699>, <3.040839, 0.440014, -1.443595>, 
      <2.989211, 0.092782, -1.671879>, <3.087823, 0.095553, -1.634153>, <3.200201, 0.081101, -1.544872>, <3.293140, 0.078416, -1.494768>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.744121, 0.724981, -1.456598>, <1.787982, 0.731272, -1.429478>, <1.849478, 0.739034, -1.396866>, <1.888389, 0.747333, -1.363459>, 
      <1.942037, 0.523514, -1.570115>, <1.985898, 0.529806, -1.542995>, <2.179725, 0.542669, -1.489392>, <2.218636, 0.550968, -1.455985>, 
      <2.250926, 0.301367, -1.746740>, <2.422503, 0.315567, -1.685645>, <2.588788, 0.400391, -1.661281>, <2.759352, 0.405184, -1.596028>, 
      <2.403842, 0.053426, -1.834988>, <2.575419, 0.067626, -1.773893>, <2.818647, 0.087989, -1.737132>, <2.989211, 0.092782, -1.671879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.744121, 0.724981, -1.456598>, <1.942037, 0.523514, -1.570115>, <2.250926, 0.301367, -1.746740>, <2.403842, 0.053426, -1.834988>, 
      <1.712477, 0.720442, -1.476164>, <1.910393, 0.518976, -1.589681>, <2.185023, 0.295913, -1.770207>, <2.337939, 0.047972, -1.858455>, 
      <1.672694, 0.712750, -1.508409>, <1.842524, 0.507689, -1.638262>, <2.159016, 0.285330, -1.826052>, <2.269991, 0.031839, -1.931792>, 
      <1.636782, 0.711242, -1.519033>, <1.806613, 0.506181, -1.648886>, <2.091910, 0.281197, -1.846136>, <2.202885, 0.027706, -1.951876>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.858074, -3.449284, -1.988314>, <0.858074, -3.335888, -1.988314>, <0.861642, -3.183722, -2.002687>, <0.858074, -3.071298, -1.988314>, 
      <1.041433, -3.449557, -2.000171>, <1.041433, -3.336161, -2.000171>, <1.045001, -3.183996, -2.014544>, <1.041433, -3.071571, -2.000171>, 
      <1.286816, -3.451070, -1.987992>, <1.286816, -3.337675, -1.987992>, <1.298614, -3.184947, -2.002290>, <1.286815, -3.073076, -1.987992>, 
      <1.470548, -3.449173, -1.987992>, <1.470548, -3.335777, -1.987992>, <1.482346, -3.183057, -2.002290>, <1.470548, -3.071187, -1.987992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.527627, -3.447768, -1.927017>, <0.527627, -3.334372, -1.927017>, <0.526721, -3.182360, -1.940581>, <0.527627, -3.069782, -1.927017>, 
      <0.624570, -3.447681, -1.954729>, <0.624570, -3.334285, -1.954729>, <0.623665, -3.182273, -1.968293>, <0.624570, -3.069695, -1.954729>, 
      <0.757458, -3.449134, -1.981808>, <0.757458, -3.335738, -1.981808>, <0.761026, -3.183573, -1.996180>, <0.757458, -3.071148, -1.981808>, 
      <0.858074, -3.449284, -1.988314>, <0.858074, -3.335888, -1.988314>, <0.861642, -3.183722, -2.002687>, <0.858074, -3.071298, -1.988314>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.184411, -3.449891, -1.795745>, <0.184411, -3.336495, -1.795745>, <0.178852, -3.184549, -1.807534>, <0.184411, -3.071905, -1.795745>, 
      <0.285709, -3.449755, -1.839239>, <0.285709, -3.336359, -1.839239>, <0.280150, -3.184413, -1.851028>, <0.285709, -3.071769, -1.839239>, 
      <0.421632, -3.447864, -1.896718>, <0.421632, -3.334468, -1.896718>, <0.420726, -3.182456, -1.910282>, <0.421632, -3.069878, -1.896718>, 
      <0.527627, -3.447768, -1.927017>, <0.527627, -3.334372, -1.927017>, <0.526721, -3.182360, -1.940581>, <0.527627, -3.069782, -1.927017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.208521, -3.448759, -1.610937>, <-0.346455, -3.434195, -1.443443>, <-0.498164, -3.403380, -1.170399>, <-0.508125, -3.376769, -0.954796>, 
      <-0.208521, -3.335363, -1.610937>, <-0.346455, -3.320799, -1.443443>, <-0.498164, -3.285915, -1.175738>, <-0.508125, -3.259304, -0.960135>, 
      <-0.219395, -3.183264, -1.620209>, <-0.356141, -3.166147, -1.457672>, <-0.510185, -3.128258, -1.181377>, <-0.519945, -3.102182, -0.970105>, 
      <-0.208521, -3.070772, -1.610937>, <-0.345267, -3.053655, -1.448400>, <-0.498364, -3.011293, -1.183865>, <-0.508125, -2.985217, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.208521, -3.448759, -1.610937>, <-0.208521, -3.335363, -1.610937>, <-0.219395, -3.183264, -1.620209>, <-0.208521, -3.070772, -1.610937>, 
      <-0.125896, -3.457483, -1.711269>, <-0.125896, -3.344087, -1.711269>, <-0.135801, -3.193728, -1.719568>, <-0.124928, -3.081236, -1.710296>, 
      <0.064711, -3.450052, -1.744349>, <0.064711, -3.336656, -1.744349>, <0.059152, -3.184710, -1.756138>, <0.064711, -3.072066, -1.744349>, 
      <0.184411, -3.449891, -1.795745>, <0.184411, -3.336495, -1.795745>, <0.178852, -3.184549, -1.807534>, <0.184411, -3.071905, -1.795745>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.269970, -3.284591, -0.280856>, <-0.269970, -3.171195, -0.280856>, <-0.281904, -3.019018, -0.271946>, <-0.269970, -2.906605, -0.280856>, 
      <-0.411659, -3.316372, -0.441047>, <-0.411659, -3.202977, -0.441047>, <-0.424992, -3.048258, -0.437465>, <-0.413058, -2.935844, -0.446376>, 
      <-0.518028, -3.350312, -0.740439>, <-0.518028, -3.232846, -0.745779>, <-0.530056, -3.075171, -0.751258>, <-0.518236, -2.958206, -0.753747>, 
      <-0.508125, -3.376769, -0.954796>, <-0.508125, -3.259304, -0.960135>, <-0.519945, -3.102182, -0.970105>, <-0.508125, -2.985217, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.171451, -3.224337, -0.186482>, <0.171451, -3.110941, -0.186482>, <0.165549, -2.959121, -0.176160>, <0.171451, -2.846350, -0.186482>, 
      <0.038619, -3.245947, -0.210010>, <0.038619, -3.132551, -0.210010>, <0.032717, -2.980731, -0.199688>, <0.038618, -2.867960, -0.210010>, 
      <-0.180439, -3.264509, -0.179634>, <-0.180439, -3.151113, -0.179634>, <-0.193344, -3.000922, -0.169502>, <-0.181410, -2.888508, -0.178413>, 
      <-0.269970, -3.284591, -0.280856>, <-0.269970, -3.171195, -0.280856>, <-0.281904, -3.019018, -0.271946>, <-0.269970, -2.906605, -0.280856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.538667, -3.153037, -0.137623>, <0.538667, -3.039641, -0.137623>, <0.537881, -2.887899, -0.126514>, <0.538667, -2.775051, -0.137623>, 
      <0.427489, -3.168037, -0.152558>, <0.427489, -3.054642, -0.152558>, <0.426703, -2.902899, -0.141449>, <0.427489, -2.790051, -0.152558>, 
      <0.281489, -3.206435, -0.166991>, <0.281489, -3.093039, -0.166991>, <0.275587, -2.941219, -0.156669>, <0.281489, -2.828448, -0.166991>, 
      <0.171451, -3.224337, -0.186482>, <0.171451, -3.110941, -0.186482>, <0.165549, -2.959121, -0.176160>, <0.171451, -2.846350, -0.186482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.817808, -3.137129, -0.099655>, <0.817808, -3.023733, -0.099655>, <0.820958, -2.871894, -0.087998>, <0.817808, -2.759143, -0.099655>, 
      <0.733501, -3.139176, -0.106963>, <0.733501, -3.025780, -0.106963>, <0.736651, -2.873941, -0.095306>, <0.733501, -2.761190, -0.106963>, 
      <0.621821, -3.141818, -0.126453>, <0.621821, -3.028422, -0.126453>, <0.621036, -2.876679, -0.115343>, <0.621821, -2.763832, -0.126453>, 
      <0.538667, -3.153037, -0.137623>, <0.538667, -3.039641, -0.137623>, <0.537881, -2.887899, -0.126514>, <0.538667, -2.775051, -0.137623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.118031, -3.138973, -0.087403>, <1.181814, -3.139022, -0.085832>, <1.266900, -3.137958, -0.087138>, <1.330701, -3.137523, -0.087025>, 
      <1.118031, -3.025577, -0.087403>, <1.181814, -3.025626, -0.085832>, <1.266900, -3.024562, -0.087138>, <1.330701, -3.024127, -0.087025>, 
      <1.125399, -2.873526, -0.075598>, <1.189183, -2.873574, -0.074027>, <1.277265, -2.873636, -0.075237>, <1.341042, -2.871843, -0.075237>, 
      <1.118031, -2.760987, -0.087403>, <1.181814, -2.761036, -0.085832>, <1.266924, -2.761330, -0.087025>, <1.330701, -2.759537, -0.087025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.118031, -3.138973, -0.087403>, <1.118031, -3.025577, -0.087403>, <1.125399, -2.873526, -0.075598>, <1.118031, -2.760987, -0.087403>, 
      <1.027915, -3.138904, -0.089622>, <1.027915, -3.025508, -0.089622>, <1.035283, -2.873456, -0.077817>, <1.027915, -2.760918, -0.089622>, 
      <0.907589, -3.134950, -0.091873>, <0.907589, -3.021554, -0.091873>, <0.910739, -2.869715, -0.080215>, <0.907589, -2.756964, -0.091873>, 
      <0.817808, -3.137129, -0.099655>, <0.817808, -3.023733, -0.099655>, <0.820958, -2.871894, -0.087998>, <0.817808, -2.759143, -0.099655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.830319, -2.574703, -1.876504>, <0.994374, -2.574947, -1.887113>, <1.213922, -2.576154, -1.876217>, <1.378313, -2.574604, -1.876217>, 
      <0.831339, -2.727370, -1.885494>, <0.995394, -2.727614, -1.896103>, <1.217362, -2.731037, -1.885334>, <1.381753, -2.729487, -1.885334>, 
      <0.853262, -2.919673, -1.968930>, <1.036621, -2.919946, -1.980787>, <1.270669, -2.919975, -1.968425>, <1.454401, -2.918086, -1.968425>, 
      <0.858074, -3.071298, -1.988314>, <1.041433, -3.071571, -2.000171>, <1.286815, -3.073076, -1.987992>, <1.470548, -3.071187, -1.987992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.534661, -2.573347, -1.821661>, <0.621398, -2.573269, -1.846455>, <0.740296, -2.574569, -1.870682>, <0.830319, -2.574703, -1.876504>, 
      <0.534404, -2.725375, -1.830097>, <0.621141, -2.725297, -1.854891>, <0.741316, -2.727236, -1.879672>, <0.831339, -2.727370, -1.885494>, 
      <0.528843, -2.918618, -1.908804>, <0.625786, -2.918531, -1.936515>, <0.752646, -2.919523, -1.962423>, <0.853262, -2.919673, -1.968930>, 
      <0.527627, -3.069782, -1.927017>, <0.624570, -3.069695, -1.954729>, <0.757458, -3.071148, -1.981808>, <0.858074, -3.071298, -1.988314>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.227578, -2.575247, -1.704210>, <0.318211, -2.575125, -1.743125>, <0.439825, -2.573433, -1.794552>, <0.534661, -2.573347, -1.821661>, 
      <0.225999, -2.727122, -1.711531>, <0.316633, -2.727000, -1.750447>, <0.439567, -2.725461, -1.802988>, <0.534404, -2.725375, -1.830097>, 
      <0.191866, -2.920854, -1.779937>, <0.293164, -2.920717, -1.823431>, <0.422848, -2.918714, -1.878505>, <0.528843, -2.918618, -1.908804>, 
      <0.184411, -3.071905, -1.795745>, <0.285709, -3.071769, -1.839239>, <0.421632, -3.069878, -1.896718>, <0.527627, -3.069782, -1.927017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.123987, -2.574234, -1.538857>, <-0.127091, -2.726737, -1.544646>, <-0.193884, -2.919345, -1.598456>, <-0.208521, -3.070772, -1.610937>, 
      <-0.251862, -2.567365, -1.395184>, <-0.254966, -2.719868, -1.400973>, <-0.330630, -2.902227, -1.435919>, <-0.345267, -3.053655, -1.448400>, 
      <-0.414776, -2.563822, -1.163405>, <-0.417579, -2.698807, -1.148165>, <-0.484706, -2.876141, -1.186741>, <-0.498364, -3.011293, -1.183865>, 
      <-0.423591, -2.540271, -0.972594>, <-0.426395, -2.675256, -0.957354>, <-0.494467, -2.850064, -0.975470>, <-0.508125, -2.985217, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.123987, -2.574234, -1.538857>, <-0.046546, -2.578393, -1.625865>, <0.120480, -2.575391, -1.658225>, <0.227578, -2.575247, -1.704210>, 
      <-0.127091, -2.726737, -1.544646>, <-0.049651, -2.730896, -1.631654>, <0.118901, -2.727266, -1.665546>, <0.225999, -2.727122, -1.711531>, 
      <-0.193884, -2.919345, -1.598456>, <-0.110290, -2.929808, -1.697815>, <0.072166, -2.921015, -1.728541>, <0.191866, -2.920854, -1.779937>, 
      <-0.208521, -3.070772, -1.610937>, <-0.124928, -3.081236, -1.710296>, <0.064711, -3.072066, -1.744349>, <0.184411, -3.071905, -1.795745>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.178966, -2.427349, -0.348805>, <-0.313547, -2.462455, -0.497832>, <-0.432928, -2.515326, -0.770495>, <-0.423591, -2.540271, -0.972594>, 
      <-0.182230, -2.574975, -0.343474>, <-0.316811, -2.610081, -0.492501>, <-0.435731, -2.650311, -0.755255>, <-0.426395, -2.675256, -0.957354>, 
      <-0.254420, -2.760126, -0.292467>, <-0.397508, -2.789365, -0.457986>, <-0.504578, -2.823053, -0.756622>, <-0.494467, -2.850064, -0.975470>, 
      <-0.269970, -2.906605, -0.280856>, <-0.413058, -2.935844, -0.446376>, <-0.518236, -2.958206, -0.753747>, <-0.508125, -2.985217, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.215982, -2.373438, -0.264367>, <0.097134, -2.392773, -0.285419>, <-0.098265, -2.406298, -0.259441>, <-0.178966, -2.427349, -0.348805>, 
      <0.214416, -2.517709, -0.258375>, <0.095568, -2.537044, -0.279426>, <-0.101529, -2.553925, -0.254109>, <-0.182230, -2.574975, -0.343474>, 
      <0.178967, -2.702742, -0.199627>, <0.046134, -2.724352, -0.223155>, <-0.165860, -2.742029, -0.190023>, <-0.254420, -2.760126, -0.292467>, 
      <0.171451, -2.846350, -0.186482>, <0.038618, -2.867960, -0.210010>, <-0.181410, -2.888508, -0.178413>, <-0.269970, -2.906605, -0.280856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.544539, -2.309645, -0.220651>, <0.445065, -2.323066, -0.234014>, <0.314435, -2.357421, -0.246928>, <0.215982, -2.373438, -0.264367>, 
      <0.544335, -2.451342, -0.214352>, <0.444862, -2.464763, -0.227714>, <0.312869, -2.501692, -0.240936>, <0.214416, -2.517709, -0.258375>, 
      <0.539650, -2.633900, -0.151519>, <0.428472, -2.648900, -0.166454>, <0.289004, -2.684840, -0.180136>, <0.178967, -2.702742, -0.199627>, 
      <0.538667, -2.775051, -0.137623>, <0.427489, -2.790051, -0.152558>, <0.281489, -2.828448, -0.166991>, <0.171451, -2.846350, -0.186482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.794292, -2.295412, -0.186680>, <0.718861, -2.297243, -0.193218>, <0.618939, -2.299607, -0.210657>, <0.544539, -2.309645, -0.220651>, 
      <0.795108, -2.436979, -0.180077>, <0.719677, -2.438810, -0.186616>, <0.618735, -2.441304, -0.204357>, <0.544335, -2.451342, -0.214352>, 
      <0.813871, -2.618226, -0.114225>, <0.729564, -2.620272, -0.121532>, <0.622804, -2.622680, -0.140348>, <0.539650, -2.633900, -0.151519>, 
      <0.817808, -2.759143, -0.099655>, <0.733501, -2.761190, -0.106963>, <0.621821, -2.763832, -0.126453>, <0.538667, -2.775051, -0.137623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.062908, -2.297062, -0.175718>, <1.064832, -2.439528, -0.168976>, <1.108763, -2.619426, -0.102253>, <1.118031, -2.760987, -0.087403>, 
      <1.119976, -2.297106, -0.174313>, <1.121900, -2.439572, -0.167570>, <1.172546, -2.619475, -0.100682>, <1.181814, -2.761036, -0.085832>, 
      <1.196116, -2.296973, -0.175380>, <1.198838, -2.440317, -0.168593>, <1.253834, -2.619178, -0.101946>, <1.266924, -2.761330, -0.087025>, 
      <1.253189, -2.295764, -0.175380>, <1.255911, -2.439108, -0.168593>, <1.317611, -2.617386, -0.101946>, <1.330701, -2.759537, -0.087025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.062908, -2.297062, -0.175718>, <0.982279, -2.297000, -0.177703>, <0.874621, -2.293462, -0.179717>, <0.794292, -2.295412, -0.186680>, 
      <1.064832, -2.439528, -0.168976>, <0.984203, -2.439466, -0.170961>, <0.875436, -2.435030, -0.173114>, <0.795108, -2.436979, -0.180077>, 
      <1.108763, -2.619426, -0.102253>, <1.018646, -2.619357, -0.104472>, <0.903652, -2.616046, -0.106442>, <0.813871, -2.618226, -0.114225>, 
      <1.118031, -2.760987, -0.087403>, <1.027915, -2.760918, -0.089622>, <0.907589, -2.756964, -0.091873>, <0.817808, -2.759143, -0.099655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.850550, -1.945316, -1.922011>, <1.028701, -1.945572, -1.933129>, <1.267053, -1.946984, -1.921710>, <1.445542, -1.945212, -1.921710>, 
      <0.848894, -2.133904, -1.904503>, <1.027045, -2.134160, -1.915621>, <1.255262, -2.136187, -1.904150>, <1.433751, -2.134415, -1.904150>, 
      <0.829056, -2.385628, -1.865370>, <0.993111, -2.385873, -1.875979>, <1.209702, -2.386148, -1.865032>, <1.374093, -2.384598, -1.865032>, 
      <0.830319, -2.574703, -1.876504>, <0.994374, -2.574947, -1.887113>, <1.213922, -2.576154, -1.876217>, <1.378313, -2.574604, -1.876217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.529534, -1.943895, -1.864542>, <0.623848, -1.943813, -1.890561>, <0.752903, -1.945176, -1.915917>, <0.850550, -1.945316, -1.922011>, 
      <0.533324, -2.132417, -1.848052>, <0.627637, -2.132335, -1.874071>, <0.751248, -2.133764, -1.898409>, <0.848894, -2.133904, -1.904503>, 
      <0.534981, -2.384358, -1.811174>, <0.621718, -2.384280, -1.835968>, <0.739032, -2.385494, -1.859549>, <0.829056, -2.385628, -1.865370>, 
      <0.534661, -2.573347, -1.821661>, <0.621398, -2.573269, -1.846455>, <0.740296, -2.574569, -1.870682>, <0.830319, -2.574703, -1.876504>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.196114, -1.945886, -1.741465>, <0.294616, -1.945758, -1.782284>, <0.426749, -1.943985, -1.836186>, <0.529534, -1.943895, -1.864542>, 
      <0.205565, -2.134480, -1.727130>, <0.304067, -2.134352, -1.767949>, <0.430539, -2.132506, -1.819696>, <0.533324, -2.132417, -1.848052>, 
      <0.229544, -2.386103, -1.695092>, <0.320177, -2.385981, -1.734008>, <0.440145, -2.384444, -1.784065>, <0.534981, -2.384358, -1.811174>, 
      <0.227578, -2.575247, -1.704210>, <0.318211, -2.575125, -1.743125>, <0.439825, -2.573433, -1.794552>, <0.534661, -2.573347, -1.821661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.185603, -1.944824, -1.568194>, <-0.169648, -2.133744, -1.556888>, <-0.120125, -2.384480, -1.531654>, <-0.123987, -2.574234, -1.538857>, 
      <-0.307771, -1.933324, -1.452667>, <-0.291816, -2.122244, -1.441361>, <-0.248000, -2.377612, -1.387980>, <-0.251862, -2.567365, -1.395184>, 
      <-0.477209, -1.902374, -1.264254>, <-0.459525, -2.103506, -1.264255>, <-0.410610, -2.363232, -1.186052>, <-0.414776, -2.563822, -1.163405>, 
      <-0.485207, -1.881752, -1.097178>, <-0.467523, -2.082884, -1.097178>, <-0.419425, -2.339680, -0.995241>, <-0.423591, -2.540271, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.185603, -1.944824, -1.568194>, <-0.094441, -1.953405, -1.654401>, <0.079933, -1.946037, -1.693321>, <0.196114, -1.945886, -1.741465>, 
      <-0.169648, -2.133744, -1.556888>, <-0.078486, -2.142325, -1.643095>, <0.089384, -2.134631, -1.678986>, <0.205565, -2.134480, -1.727130>, 
      <-0.120125, -2.384480, -1.531654>, <-0.042684, -2.388640, -1.618661>, <0.122446, -2.386247, -1.649107>, <0.229544, -2.386103, -1.695092>, 
      <-0.123987, -2.574234, -1.538857>, <-0.046546, -2.578393, -1.625865>, <0.120480, -2.575391, -1.658225>, <0.227578, -2.575247, -1.704210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.245298, -1.790905, -0.321149>, <-0.393978, -1.823663, -0.513357>, <-0.496843, -1.851750, -0.854099>, <-0.485207, -1.881752, -1.097178>, 
      <-0.228375, -1.982010, -0.331778>, <-0.377055, -2.014768, -0.523986>, <-0.479159, -2.052882, -0.854100>, <-0.467523, -2.082884, -1.097178>, 
      <-0.174721, -2.235374, -0.355738>, <-0.309302, -2.270480, -0.504765>, <-0.428762, -2.314736, -0.793142>, <-0.419425, -2.339680, -0.995241>, 
      <-0.178966, -2.427349, -0.348805>, <-0.313547, -2.462455, -0.497832>, <-0.432928, -2.515326, -0.770495>, <-0.423591, -2.540271, -0.972594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.183524, -1.734412, -0.232667>, <0.054508, -1.754669, -0.254722>, <-0.164988, -1.773210, -0.217327>, <-0.245298, -1.790905, -0.321149>, 
      <0.193151, -1.925976, -0.244817>, <0.064135, -1.946233, -0.266872>, <-0.148065, -1.964315, -0.227956>, <-0.228375, -1.982010, -0.331778>, 
      <0.218067, -2.181424, -0.272342>, <0.099219, -2.200759, -0.293394>, <-0.094019, -2.214324, -0.266374>, <-0.174721, -2.235374, -0.355738>, 
      <0.215982, -2.373438, -0.264367>, <0.097134, -2.392773, -0.285419>, <-0.098265, -2.406298, -0.259441>, <-0.178966, -2.427349, -0.348805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.540259, -1.667564, -0.186858>, <0.432319, -1.681619, -0.200852>, <0.290429, -1.717627, -0.214392>, <0.183524, -1.734412, -0.232667>, 
      <0.543849, -1.859992, -0.199789>, <0.435909, -1.874047, -0.213783>, <0.300056, -1.909191, -0.226541>, <0.193151, -1.925976, -0.244817>, 
      <0.544816, -2.116940, -0.229218>, <0.445342, -2.130361, -0.242581>, <0.316520, -2.165407, -0.254903>, <0.218067, -2.181424, -0.272342>, 
      <0.544539, -2.309645, -0.220651>, <0.445065, -2.323066, -0.234014>, <0.314435, -2.357421, -0.246928>, <0.215982, -2.373438, -0.264367>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.811432, -1.652649, -0.151261>, <0.729569, -1.654567, -0.158109>, <0.621078, -1.657040, -0.176380>, <0.540259, -1.667564, -0.186858>, 
      <0.810445, -1.845360, -0.164816>, <0.728582, -1.847278, -0.171665>, <0.624668, -1.849468, -0.189311>, <0.543849, -1.859992, -0.199789>, 
      <0.793180, -2.102435, -0.195680>, <0.717749, -2.104266, -0.202219>, <0.619216, -2.106902, -0.219223>, <0.544816, -2.116940, -0.229218>, 
      <0.794292, -2.295412, -0.186680>, <0.718861, -2.297243, -0.193218>, <0.618939, -2.299607, -0.210657>, <0.544539, -2.309645, -0.220651>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.103087, -1.654378, -0.139774>, <1.097170, -1.847279, -0.153546>, <1.060298, -2.103813, -0.184864>, <1.062908, -2.297062, -0.175718>, 
      <1.165051, -1.654424, -0.138301>, <1.159134, -1.847325, -0.152073>, <1.117367, -2.103857, -0.183458>, <1.119976, -2.297106, -0.174313>, 
      <1.247707, -1.653426, -0.139526>, <1.238288, -1.846573, -0.153320>, <1.192439, -2.103357, -0.184548>, <1.196116, -2.296973, -0.175380>, 
      <1.309687, -1.653018, -0.139419>, <1.300268, -1.846165, -0.153213>, <1.249512, -2.102148, -0.184548>, <1.253189, -2.295764, -0.175380>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.103087, -1.654378, -0.139774>, <1.015546, -1.654313, -0.141855>, <0.898669, -1.650605, -0.143963>, <0.811432, -1.652649, -0.151261>, 
      <1.097170, -1.847279, -0.153546>, <1.009629, -1.847214, -0.155627>, <0.897683, -1.843316, -0.157518>, <0.810445, -1.845360, -0.164816>, 
      <1.060298, -2.103813, -0.184864>, <0.979669, -2.103752, -0.186849>, <0.873509, -2.100485, -0.188717>, <0.793180, -2.102435, -0.195680>, 
      <1.062908, -2.297062, -0.175718>, <0.982279, -2.297000, -0.177703>, <0.874621, -2.293462, -0.179717>, <0.794292, -2.295412, -0.186680>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.840893, -1.370359, -1.988314>, <1.024252, -1.370632, -2.000171>, <1.269633, -1.372010, -1.987992>, <1.453367, -1.370248, -1.987992>, 
      <0.851795, -1.540318, -1.954387>, <1.035154, -1.540591, -1.966244>, <1.267286, -1.544499, -1.968107>, <1.451019, -1.542737, -1.968107>, 
      <0.852068, -1.772412, -1.938063>, <1.030219, -1.772668, -1.949182>, <1.277808, -1.774411, -1.937726>, <1.456297, -1.772640, -1.937726>, 
      <0.850550, -1.945316, -1.922011>, <1.028701, -1.945572, -1.933129>, <1.267053, -1.946984, -1.921710>, <1.445542, -1.945212, -1.921710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.510446, -1.368843, -1.927017>, <0.607389, -1.368756, -1.954729>, <0.740277, -1.370209, -1.981808>, <0.840893, -1.370359, -1.988314>, 
      <0.526166, -1.538633, -1.894309>, <0.623109, -1.538546, -1.922020>, <0.751179, -1.540168, -1.947880>, <0.851795, -1.540318, -1.954387>, 
      <0.526057, -1.770965, -1.879668>, <0.620371, -1.770883, -1.905687>, <0.754421, -1.772271, -1.931969>, <0.852068, -1.772412, -1.938063>, 
      <0.529534, -1.943895, -1.864542>, <0.623848, -1.943813, -1.890561>, <0.752903, -1.945176, -1.915917>, <0.850550, -1.945316, -1.922011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.167230, -1.370966, -1.795745>, <0.268528, -1.370830, -1.839239>, <0.404451, -1.368938, -1.896718>, <0.510446, -1.368843, -1.927017>, 
      <0.187944, -1.540525, -1.765596>, <0.289242, -1.540388, -1.809090>, <0.420171, -1.538729, -1.864009>, <0.526166, -1.538633, -1.894309>, 
      <0.187458, -1.773141, -1.754595>, <0.285960, -1.773013, -1.795414>, <0.423272, -1.771054, -1.851311>, <0.526057, -1.770965, -1.879668>, 
      <0.196114, -1.945886, -1.741465>, <0.294616, -1.945758, -1.782284>, <0.426749, -1.943985, -1.836186>, <0.529534, -1.943895, -1.864542>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225702, -1.369834, -1.610937>, <-0.141844, -1.368327, -1.710612>, <0.047530, -1.371127, -1.744349>, <0.167230, -1.370966, -1.795745>, 
      <-0.185807, -1.535700, -1.579934>, <-0.101948, -1.534193, -1.679608>, <0.068244, -1.540686, -1.714200>, <0.187944, -1.540525, -1.765596>, 
      <-0.200169, -1.772355, -1.578516>, <-0.109006, -1.780936, -1.664723>, <0.071277, -1.773292, -1.706450>, <0.187458, -1.773141, -1.754595>, 
      <-0.185603, -1.944824, -1.568194>, <-0.094441, -1.953405, -1.654401>, <0.079933, -1.946037, -1.693321>, <0.196114, -1.945886, -1.741465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.225702, -1.369834, -1.610937>, <-0.185807, -1.535700, -1.579934>, <-0.200169, -1.772355, -1.578516>, <-0.185603, -1.944824, -1.568194>, 
      <-0.361909, -1.372282, -1.449041>, <-0.322014, -1.538148, -1.418037>, <-0.322336, -1.760855, -1.462989>, <-0.307771, -1.933324, -1.452667>, 
      <-0.515615, -1.409305, -1.182365>, <-0.497835, -1.561547, -1.202332>, <-0.490747, -1.748396, -1.264254>, <-0.477209, -1.902374, -1.264254>, 
      <-0.525306, -1.383413, -0.972593>, <-0.507527, -1.535655, -0.992559>, <-0.498745, -1.727774, -1.097178>, <-0.485207, -1.881752, -1.097178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.287151, -1.205666, -0.280856>, <-0.431132, -1.256091, -0.447409>, <-0.535651, -1.355775, -0.748669>, <-0.525306, -1.383413, -0.972593>, 
      <-0.259259, -1.379292, -0.295182>, <-0.403240, -1.429717, -0.461735>, <-0.517872, -1.508017, -0.768635>, <-0.507527, -1.535655, -0.992559>, 
      <-0.260837, -1.615427, -0.311389>, <-0.409517, -1.648186, -0.503597>, <-0.510381, -1.697772, -0.854099>, <-0.498745, -1.727774, -1.097178>, 
      <-0.245298, -1.790905, -0.321149>, <-0.393978, -1.823663, -0.513357>, <-0.496843, -1.851750, -0.854099>, <-0.485207, -1.881752, -1.097178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.154270, -1.145412, -0.186482>, <0.021438, -1.167022, -0.210010>, <-0.200059, -1.175164, -0.180111>, <-0.287151, -1.205666, -0.280856>, 
      <0.175747, -1.320931, -0.201435>, <0.042915, -1.342541, -0.224963>, <-0.172166, -1.348790, -0.194437>, <-0.259259, -1.379292, -0.295182>, 
      <0.174635, -1.557531, -0.221449>, <0.045620, -1.577787, -0.243504>, <-0.180527, -1.597733, -0.207567>, <-0.260837, -1.615427, -0.311389>, 
      <0.183524, -1.734412, -0.232667>, <0.054508, -1.754669, -0.254722>, <-0.164988, -1.773210, -0.217327>, <-0.245298, -1.790905, -0.321149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.521486, -1.074112, -0.137623>, <0.410308, -1.089112, -0.152558>, <0.264308, -1.127510, -0.166991>, <0.154270, -1.145412, -0.186482>, 
      <0.537488, -1.251414, -0.153574>, <0.426310, -1.266415, -0.168509>, <0.285785, -1.303030, -0.181944>, <0.175747, -1.320931, -0.201435>, 
      <0.536932, -1.489261, -0.174876>, <0.428992, -1.503316, -0.188870>, <0.281540, -1.540745, -0.203173>, <0.174635, -1.557531, -0.221449>, 
      <0.540259, -1.667564, -0.186858>, <0.432319, -1.681619, -0.200852>, <0.290429, -1.717627, -0.214392>, <0.183524, -1.734412, -0.232667>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.800626, -1.058204, -0.099655>, <0.716319, -1.060251, -0.106963>, <0.604640, -1.062893, -0.126453>, <0.521486, -1.074112, -0.137623>, 
      <0.812447, -1.236062, -0.116380>, <0.728140, -1.238109, -0.123688>, <0.620642, -1.240195, -0.142404>, <0.537488, -1.251414, -0.153574>, 
      <0.812346, -1.474059, -0.138699>, <0.730483, -1.475977, -0.145547>, <0.617751, -1.478737, -0.164398>, <0.536932, -1.489261, -0.174876>, 
      <0.811432, -1.652649, -0.151261>, <0.729569, -1.654567, -0.158109>, <0.621078, -1.657040, -0.176380>, <0.540259, -1.667564, -0.186858>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.100849, -1.060048, -0.087403>, <1.108159, -1.238081, -0.104391>, <1.108560, -1.475925, -0.127034>, <1.103087, -1.654378, -0.139774>, 
      <1.164633, -1.060097, -0.085832>, <1.171942, -1.238130, -0.102821>, <1.170524, -1.475971, -0.125561>, <1.165051, -1.654424, -0.138301>, 
      <1.249737, -1.060179, -0.087025>, <1.249340, -1.238389, -0.104035>, <1.256405, -1.475071, -0.126788>, <1.247707, -1.653426, -0.139526>, 
      <1.313520, -1.058598, -0.087025>, <1.313123, -1.236809, -0.104035>, <1.318385, -1.474663, -0.126681>, <1.309687, -1.653018, -0.139419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.100849, -1.060048, -0.087403>, <1.010733, -1.059979, -0.089622>, <0.890406, -1.056025, -0.091873>, <0.800626, -1.058204, -0.099655>, 
      <1.108159, -1.238081, -0.104391>, <1.018043, -1.238012, -0.106610>, <0.902227, -1.233883, -0.108598>, <0.812447, -1.236062, -0.116380>, 
      <1.108560, -1.475925, -0.127034>, <1.021019, -1.475860, -0.129114>, <0.899584, -1.472015, -0.131401>, <0.812346, -1.474059, -0.138699>, 
      <1.103087, -1.654378, -0.139774>, <1.015546, -1.654313, -0.141855>, <0.898669, -1.650605, -0.143963>, <0.811432, -1.652649, -0.151261>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.242090, 0.699494, -1.548219>, <1.300632, 0.701514, -1.552516>, <1.378755, 0.709701, -1.548219>, <1.437326, 0.714075, -1.548219>, 
      <1.121556, 0.492284, -1.685708>, <1.180098, 0.494304, -1.690006>, <1.373469, 0.488220, -1.685708>, <1.432039, 0.492595, -1.685708>, 
      <0.921608, 0.250121, -1.899186>, <1.095223, 0.241817, -1.909156>, <1.251173, 0.207183, -1.869027>, <1.424991, 0.197287, -1.869027>, 
      <0.840311, 0.008794, -2.006517>, <1.013926, 0.000491, -2.016487>, <1.245886, -0.014297, -2.006517>, <1.419704, -0.024193, -2.006517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.011809, -5.461892, 0.403688>, <-0.057705, -5.353155, 0.366513>, <-0.163174, -5.184184, 0.369922>, <-0.164796, -5.099434, 0.279771>, 
      <0.022599, -5.437222, 0.427463>, <-0.023297, -5.328484, 0.390288>, <-0.131816, -5.166241, 0.393266>, <-0.133438, -5.081491, 0.303116>, 
      <0.068594, -5.406384, 0.464341>, <0.022903, -5.310404, 0.426013>, <-0.119415, -5.187370, 0.389581>, <-0.080266, -5.090571, 0.346384>, 
      <0.090704, -5.381147, 0.499441>, <0.045013, -5.285168, 0.461114>, <-0.100748, -5.158015, 0.414879>, <-0.061599, -5.061216, 0.371682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.159640, -5.560649, 0.326459>, <-0.204909, -5.453551, 0.284430>, <-0.239106, -5.286319, 0.244245>, <-0.310535, -5.203657, 0.186362>, 
      <-0.102904, -5.548705, 0.322019>, <-0.148172, -5.441607, 0.279990>, <-0.181244, -5.273479, 0.231529>, <-0.252674, -5.190817, 0.173646>, 
      <-0.053014, -5.491437, 0.375217>, <-0.098910, -5.382700, 0.338041>, <-0.207365, -5.209470, 0.337024>, <-0.208987, -5.124720, 0.246874>, 
      <-0.011809, -5.461892, 0.403688>, <-0.057705, -5.353155, 0.366513>, <-0.163174, -5.184184, 0.369922>, <-0.164796, -5.099434, 0.279771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.420641, -5.547960, 0.435683>, <-0.444983, -5.435836, 0.411128>, <-0.417044, -5.244776, 0.393928>, <-0.501783, -5.174214, 0.353831>, 
      <-0.354378, -5.558087, 0.383474>, <-0.378721, -5.445963, 0.358919>, <-0.355118, -5.256842, 0.350185>, <-0.439856, -5.186280, 0.310088>, 
      <-0.242540, -5.578101, 0.332947>, <-0.287809, -5.471004, 0.290918>, <-0.312387, -5.302580, 0.260350>, <-0.383817, -5.219919, 0.202467>, 
      <-0.159640, -5.560649, 0.326459>, <-0.204909, -5.453551, 0.284430>, <-0.239106, -5.286319, 0.244245>, <-0.310535, -5.203657, 0.186362>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.558350, -5.499716, 0.640607>, <-0.612555, -5.385851, 0.595137>, <-0.623059, -5.180484, 0.518749>, <-0.739033, -5.120166, 0.489040>, 
      <-0.549644, -5.536570, 0.575326>, <-0.603849, -5.422706, 0.529856>, <-0.597026, -5.220678, 0.450332>, <-0.713000, -5.160359, 0.420623>, 
      <-0.479498, -5.538965, 0.482058>, <-0.503841, -5.426841, 0.457502>, <-0.484407, -5.231650, 0.441511>, <-0.569145, -5.161088, 0.401414>, 
      <-0.420641, -5.547960, 0.435683>, <-0.444983, -5.435836, 0.411128>, <-0.417044, -5.244776, 0.393928>, <-0.501783, -5.174214, 0.353831>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.478562, -5.302750, 0.870021>, <-0.528510, -5.197829, 0.828122>, <-0.546299, -5.025384, 0.746734>, <-0.645055, -4.953010, 0.730358>, 
      <-0.558854, -5.347822, 0.852043>, <-0.608801, -5.242900, 0.810144>, <-0.614323, -5.075986, 0.709817>, <-0.713079, -5.003612, 0.693442>, 
      <-0.569172, -5.453902, 0.721757>, <-0.623377, -5.340037, 0.676287>, <-0.651885, -5.135979, 0.594505>, <-0.767859, -5.075661, 0.564797>, 
      <-0.558350, -5.499716, 0.640607>, <-0.612555, -5.385851, 0.595137>, <-0.623059, -5.180484, 0.518749>, <-0.739033, -5.120166, 0.489040>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.104131, -5.127833, 0.788944>, <-0.029319, -5.036642, 0.763826>, <-0.232786, -4.945444, 0.687131>, <-0.340702, -4.823860, 0.705215>, 
      <-0.071102, -5.136390, 0.844833>, <-0.204552, -5.045198, 0.819714>, <-0.326389, -4.973182, 0.706207>, <-0.434306, -4.851597, 0.724291>, 
      <-0.320978, -5.214291, 0.905306>, <-0.370926, -5.109369, 0.863407>, <-0.473123, -4.970951, 0.786447>, <-0.571879, -4.898577, 0.770071>, 
      <-0.478562, -5.302750, 0.870021>, <-0.528510, -5.197829, 0.828122>, <-0.546299, -5.025384, 0.746734>, <-0.645055, -4.953010, 0.730358>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.154714, -5.271828, 0.668045>, <0.126733, -5.113377, 0.643545>, <0.046027, -4.904442, 0.606396>, <0.061445, -4.743658, 0.586376>, 
      <0.156752, -5.233387, 0.711978>, <0.128771, -5.074936, 0.687477>, <-0.026124, -4.843083, 0.692618>, <-0.010707, -4.682299, 0.672598>, 
      <0.159720, -5.125119, 0.771215>, <0.026270, -5.033927, 0.746096>, <-0.112261, -4.909730, 0.662569>, <-0.220178, -4.788146, 0.680653>, 
      <0.104131, -5.127833, 0.788944>, <-0.029319, -5.036642, 0.763826>, <-0.232786, -4.945444, 0.687131>, <-0.340702, -4.823860, 0.705215>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.154714, -5.271828, 0.668045>, <0.152507, -5.313464, 0.620460>, <0.119513, -5.348266, 0.545176>, <0.090704, -5.381147, 0.499441>, 
      <0.126733, -5.113377, 0.643545>, <0.124527, -5.155013, 0.595960>, <0.073822, -5.252286, 0.506848>, <0.045013, -5.285168, 0.461114>, 
      <0.046027, -4.904442, 0.606396>, <0.114063, -4.962301, 0.525092>, <-0.048333, -5.075590, 0.485912>, <-0.100748, -5.158015, 0.414879>, 
      <0.061445, -4.743658, 0.586376>, <0.129480, -4.801517, 0.505073>, <-0.009184, -4.978791, 0.442715>, <-0.061599, -5.061216, 0.371682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.022792, -4.887831, -0.206960>, <0.140703, -4.818401, -0.173910>, <0.331540, -4.762282, 0.036445>, <0.381193, -4.662888, 0.178918>, 
      <-0.016601, -5.021644, -0.110928>, <0.146895, -4.952215, -0.077879>, <0.306845, -4.932551, 0.111735>, <0.356497, -4.833156, 0.254208>, 
      <-0.166956, -4.986550, 0.159693>, <-0.135598, -4.968607, 0.183037>, <-0.015201, -4.929691, 0.274592>, <0.003466, -4.900336, 0.299890>, 
      <-0.164796, -5.099434, 0.279771>, <-0.133438, -5.081491, 0.303116>, <-0.080266, -5.090571, 0.346384>, <-0.061599, -5.061216, 0.371682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.581975, -5.071904, -0.015779>, <-0.424352, -5.017041, -0.097177>, <-0.190825, -4.959188, -0.240926>, <-0.022792, -4.887831, -0.206960>, 
      <-0.549422, -5.158304, 0.042068>, <-0.391799, -5.103441, -0.039331>, <-0.184634, -5.093001, -0.144895>, <-0.016601, -5.021644, -0.110928>, 
      <-0.373483, -5.130811, 0.135353>, <-0.315622, -5.117972, 0.122637>, <-0.211146, -5.011836, 0.126795>, <-0.166956, -4.986550, 0.159693>, 
      <-0.310535, -5.203657, 0.186362>, <-0.252674, -5.190817, 0.173646>, <-0.208987, -5.124720, 0.246874>, <-0.164796, -5.099434, 0.279771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.862427, -5.180081, 0.226639>, <-0.762976, -5.177598, 0.167273>, <-0.680314, -5.106132, 0.035005>, <-0.581975, -5.071904, -0.015779>, 
      <-0.800133, -5.249590, 0.293368>, <-0.700681, -5.247106, 0.234002>, <-0.647760, -5.192532, 0.092851>, <-0.549422, -5.158304, 0.042068>, 
      <-0.584646, -5.105212, 0.314622>, <-0.522720, -5.117278, 0.270879>, <-0.446765, -5.147073, 0.151458>, <-0.373483, -5.130811, 0.135353>, 
      <-0.501783, -5.174214, 0.353831>, <-0.439856, -5.186280, 0.310088>, <-0.383817, -5.219919, 0.202467>, <-0.310535, -5.203657, 0.186362>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.344293, -5.090944, 0.439277>, <-1.280093, -5.174036, 0.318216>, <-1.000000, -5.183518, 0.308761>, <-0.862427, -5.180081, 0.226639>, 
      <-1.208387, -5.202180, 0.488536>, <-1.144186, -5.285272, 0.367474>, <-0.937705, -5.253026, 0.375490>, <-0.800133, -5.249590, 0.293368>, 
      <-0.896832, -5.038094, 0.448618>, <-0.870799, -5.078288, 0.380201>, <-0.652009, -5.092087, 0.362205>, <-0.584646, -5.105212, 0.314622>, 
      <-0.739033, -5.120166, 0.489040>, <-0.713000, -5.160359, 0.420623>, <-0.569145, -5.161088, 0.401414>, <-0.501783, -5.174214, 0.353831>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.145018, -4.814336, 0.759512>, <-1.249755, -4.890196, 0.705062>, <-1.400507, -5.018189, 0.545279>, <-1.344293, -5.090944, 0.439277>, 
      <-1.043148, -4.922622, 0.806421>, <-1.147885, -4.998482, 0.751970>, <-1.264601, -5.129424, 0.594537>, <-1.208387, -5.202180, 0.488536>, 
      <-0.769690, -4.861671, 0.709692>, <-0.837715, -4.912272, 0.672775>, <-0.925658, -4.993589, 0.524374>, <-0.896832, -5.038094, 0.448618>, 
      <-0.645055, -4.953010, 0.730358>, <-0.713079, -5.003612, 0.693442>, <-0.767859, -5.075661, 0.564797>, <-0.739033, -5.120166, 0.489040>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482580, -4.466815, 0.887262>, <-0.696692, -4.537410, 0.918958>, <-0.975082, -4.691253, 0.847858>, <-1.145018, -4.814336, 0.759512>, 
      <-0.428917, -4.581894, 0.899301>, <-0.643030, -4.652489, 0.930997>, <-0.873212, -4.799540, 0.894767>, <-1.043148, -4.922622, 0.806421>, 
      <-0.424850, -4.729055, 0.719316>, <-0.518453, -4.756792, 0.738392>, <-0.696514, -4.807238, 0.749405>, <-0.769690, -4.861671, 0.709692>, 
      <-0.340702, -4.823860, 0.705215>, <-0.434306, -4.851597, 0.724291>, <-0.571879, -4.898577, 0.770071>, <-0.645055, -4.953010, 0.730358>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.242446, -4.356872, 0.554121>, <0.058419, -4.315099, 0.705035>, <-0.255334, -4.391890, 0.853622>, <-0.482580, -4.466815, 0.887262>, 
      <0.293572, -4.470557, 0.585243>, <0.109544, -4.428784, 0.736156>, <-0.201672, -4.506968, 0.865661>, <-0.428917, -4.581894, 0.899301>, 
      <0.073614, -4.616738, 0.570573>, <0.001463, -4.555379, 0.656795>, <-0.304326, -4.693341, 0.694754>, <-0.424850, -4.729055, 0.719316>, 
      <0.061445, -4.743658, 0.586376>, <-0.010707, -4.682299, 0.672598>, <-0.220178, -4.788146, 0.680653>, <-0.340702, -4.823860, 0.705215>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.242446, -4.356872, 0.554121>, <0.293572, -4.470557, 0.585243>, <0.073614, -4.616738, 0.570573>, <0.061445, -4.743658, 0.586376>, 
      <0.357523, -4.382995, 0.459752>, <0.408648, -4.496679, 0.490873>, <0.141650, -4.674597, 0.489269>, <0.129480, -4.801517, 0.505073>, 
      <0.422717, -4.579764, 0.298069>, <0.398021, -4.750032, 0.373359>, <0.055881, -4.817911, 0.370923>, <-0.009184, -4.978791, 0.442715>, 
      <0.381193, -4.662888, 0.178918>, <0.356497, -4.833156, 0.254208>, <0.003466, -4.900336, 0.299890>, <-0.061599, -5.061216, 0.371682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.193158, -4.486444, -0.160142>, <-0.094435, -4.441682, -0.116219>, <0.058478, -4.296178, -0.094032>, <0.057497, -4.240088, 0.008593>, 
      <-0.141395, -4.605684, -0.139846>, <-0.042672, -4.560922, -0.095923>, <0.124621, -4.443190, -0.047751>, <0.123639, -4.387100, 0.054875>, 
      <-0.027734, -4.781017, -0.283614>, <0.135761, -4.711588, -0.250565>, <0.353595, -4.610223, -0.030794>, <0.403247, -4.510828, 0.111680>, 
      <-0.022792, -4.887831, -0.206960>, <0.140703, -4.818401, -0.173910>, <0.331540, -4.762282, 0.036445>, <0.381193, -4.662888, 0.178918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.566915, -4.523202, -0.269215>, <-0.457210, -4.484236, -0.283750>, <-0.292190, -4.531346, -0.204202>, <-0.193158, -4.486444, -0.160142>, 
      <-0.545012, -4.681749, -0.183888>, <-0.435307, -4.642784, -0.198423>, <-0.240427, -4.650586, -0.183907>, <-0.141395, -4.605684, -0.139846>, 
      <-0.636168, -4.928072, -0.112077>, <-0.478545, -4.873209, -0.193475>, <-0.195768, -4.852374, -0.317581>, <-0.027734, -4.781017, -0.283614>, 
      <-0.581975, -5.071904, -0.015779>, <-0.424352, -5.017041, -0.097177>, <-0.190825, -4.959188, -0.240926>, <-0.022792, -4.887831, -0.206960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.894815, -4.735664, -0.067178>, <-0.790623, -4.716297, -0.145802>, <-0.690304, -4.567028, -0.252866>, <-0.566915, -4.523202, -0.269215>, 
      <-0.857613, -4.875051, 0.002297>, <-0.753420, -4.855685, -0.076328>, <-0.668401, -4.725576, -0.167539>, <-0.545012, -4.681749, -0.183888>, 
      <-0.949363, -5.083078, 0.133516>, <-0.849912, -5.080594, 0.074149>, <-0.734506, -4.962301, -0.061293>, <-0.636168, -4.928072, -0.112077>, 
      <-0.862427, -5.180081, 0.226639>, <-0.762976, -5.177598, 0.167273>, <-0.680314, -5.106132, 0.035005>, <-0.581975, -5.071904, -0.015779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.301563, -4.659751, 0.285156>, <-1.233238, -4.743222, 0.162905>, <-1.023547, -4.759591, 0.029965>, <-0.894815, -4.735664, -0.067178>, 
      <-1.261494, -4.782690, 0.333284>, <-1.193169, -4.866160, 0.211033>, <-0.986345, -4.898978, 0.099439>, <-0.857613, -4.875051, 0.002297>, 
      <-1.447094, -5.006805, 0.402018>, <-1.382893, -5.089897, 0.280957>, <-1.086935, -5.086514, 0.215638>, <-0.949363, -5.083078, 0.133516>, 
      <-1.344293, -5.090944, 0.439277>, <-1.280093, -5.174036, 0.318216>, <-1.000000, -5.183518, 0.308761>, <-0.862427, -5.180081, 0.226639>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.198195, -4.365031, 0.475651>, <-1.275956, -4.429834, 0.433237>, <-1.347556, -4.603562, 0.367451>, <-1.301563, -4.659751, 0.285156>, 
      <-1.146994, -4.501066, 0.543090>, <-1.224754, -4.565868, 0.500676>, <-1.307487, -4.726500, 0.415579>, <-1.261494, -4.782690, 0.333284>, 
      <-1.249722, -4.703036, 0.711299>, <-1.354460, -4.778896, 0.656848>, <-1.503308, -4.934050, 0.508019>, <-1.447094, -5.006805, 0.402018>, 
      <-1.145018, -4.814336, 0.759512>, <-1.249755, -4.890196, 0.705062>, <-1.400507, -5.018189, 0.545279>, <-1.344293, -5.090944, 0.439277>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.664713, -4.129026, 0.632524>, <-0.842218, -4.164552, 0.640993>, <-1.069794, -4.258026, 0.545688>, <-1.198195, -4.365031, 0.475651>, 
      <-0.610012, -4.241939, 0.690432>, <-0.787517, -4.277465, 0.698900>, <-1.018592, -4.394062, 0.613126>, <-1.146994, -4.501066, 0.543090>, 
      <-0.540719, -4.342137, 0.874219>, <-0.754831, -4.412732, 0.905915>, <-1.079787, -4.579954, 0.799644>, <-1.249722, -4.703036, 0.711299>, 
      <-0.482580, -4.466815, 0.887262>, <-0.696692, -4.537410, 0.918958>, <-0.975082, -4.691253, 0.847858>, <-1.145018, -4.814336, 0.759512>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.198783, -4.165008, 0.427970>, <-0.313812, -4.147318, 0.527347>, <-0.514815, -4.099025, 0.625373>, <-0.664713, -4.129026, 0.632524>, 
      <-0.113855, -4.278658, 0.474206>, <-0.228885, -4.260969, 0.573583>, <-0.460114, -4.211938, 0.683280>, <-0.610012, -4.241939, 0.690432>, 
      <0.183067, -4.224834, 0.517976>, <-0.000961, -4.183060, 0.668889>, <-0.313473, -4.267212, 0.840579>, <-0.540719, -4.342137, 0.874219>, 
      <0.242446, -4.356872, 0.554121>, <0.058419, -4.315099, 0.705035>, <-0.255334, -4.391890, 0.853622>, <-0.482580, -4.466815, 0.887262>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.198783, -4.165008, 0.427970>, <-0.113855, -4.278658, 0.474206>, <0.183067, -4.224834, 0.517976>, <0.242446, -4.356872, 0.554121>, 
      <-0.086670, -4.182248, 0.331115>, <-0.001743, -4.295898, 0.377351>, <0.298143, -4.250956, 0.423606>, <0.357523, -4.382995, 0.459752>, 
      <0.056245, -4.168555, 0.139471>, <0.122388, -4.315568, 0.185753>, <0.444771, -4.427704, 0.230830>, <0.422717, -4.579764, 0.298069>, 
      <0.057497, -4.240088, 0.008593>, <0.123639, -4.387100, 0.054875>, <0.403247, -4.510828, 0.111680>, <0.381193, -4.662888, 0.178918>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.348480, -4.137586, -0.334656>, <-0.238938, -3.934768, -0.287555>, <-0.137695, -3.583095, -0.319381>, <-0.197984, -3.375577, -0.226349>, 
      <-0.292781, -4.241289, -0.289835>, <-0.183240, -4.038469, -0.242734>, <-0.041318, -3.828065, -0.225534>, <-0.101607, -3.620547, -0.132501>, 
      <-0.242715, -4.372287, -0.179572>, <-0.143992, -4.327525, -0.135649>, <-0.051738, -4.051206, -0.171154>, <-0.052719, -3.995116, -0.068528>, 
      <-0.193158, -4.486444, -0.160142>, <-0.094435, -4.441682, -0.116219>, <0.058478, -4.296178, -0.094032>, <0.057497, -4.240088, 0.008593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.690374, -4.287250, -0.438065>, <-0.574581, -4.296684, -0.439323>, <-0.402574, -4.237743, -0.357915>, <-0.348480, -4.137586, -0.334656>, 
      <-0.648200, -4.366566, -0.408425>, <-0.532407, -4.376000, -0.409683>, <-0.346876, -4.341446, -0.313094>, <-0.292781, -4.241289, -0.289835>, 
      <-0.578338, -4.440513, -0.313716>, <-0.468633, -4.401548, -0.328251>, <-0.341747, -4.417189, -0.223632>, <-0.242715, -4.372287, -0.179572>, 
      <-0.566915, -4.523202, -0.269215>, <-0.457210, -4.484236, -0.283750>, <-0.292190, -4.531346, -0.204202>, <-0.193158, -4.486444, -0.160142>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.158280, -4.071608, -0.325853>, <-1.019473, -4.125491, -0.379253>, <-0.848028, -4.274404, -0.436351>, <-0.690374, -4.287250, -0.438065>, 
      <-1.067413, -4.270644, -0.261945>, <-0.928605, -4.324528, -0.315345>, <-0.805854, -4.353721, -0.406711>, <-0.648200, -4.366566, -0.408425>, 
      <-0.947774, -4.537242, -0.166076>, <-0.843582, -4.517876, -0.244701>, <-0.701728, -4.484339, -0.297368>, <-0.578338, -4.440513, -0.313716>, 
      <-0.894815, -4.735664, -0.067178>, <-0.790623, -4.716297, -0.145802>, <-0.690304, -4.567028, -0.252866>, <-0.566915, -4.523202, -0.269215>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.738894, -3.880226, -0.034695>, <-1.629719, -3.985474, -0.169860>, <-1.336536, -4.002410, -0.257277>, <-1.158280, -4.071608, -0.325853>, 
      <-1.617544, -4.128778, 0.033171>, <-1.508369, -4.234027, -0.101994>, <-1.245669, -4.201447, -0.193369>, <-1.067413, -4.270644, -0.261945>, 
      <-1.384272, -4.405980, 0.185810>, <-1.315947, -4.489451, 0.063559>, <-1.076506, -4.561169, -0.068934>, <-0.947774, -4.537242, -0.166076>, 
      <-1.301563, -4.659751, 0.285156>, <-1.233238, -4.743222, 0.162905>, <-1.023547, -4.759591, 0.029965>, <-0.894815, -4.735664, -0.067178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.576214, -3.668707, 0.191572>, <-1.658365, -3.718418, 0.149191>, <-1.795302, -3.825846, 0.035142>, <-1.738894, -3.880226, -0.034695>, 
      <-1.472361, -3.886911, 0.264809>, <-1.554512, -3.936622, 0.222427>, <-1.673952, -4.074399, 0.103008>, <-1.617544, -4.128778, 0.033171>, 
      <-1.278883, -4.150655, 0.369376>, <-1.356643, -4.215458, 0.326962>, <-1.430266, -4.349791, 0.268105>, <-1.384272, -4.405980, 0.185810>, 
      <-1.198195, -4.365031, 0.475651>, <-1.275956, -4.429834, 0.433237>, <-1.347556, -4.603562, 0.367451>, <-1.301563, -4.659751, 0.285156>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.987134, -3.425315, 0.353134>, <-1.163554, -3.511327, 0.372888>, <-1.421817, -3.575277, 0.271225>, <-1.576214, -3.668707, 0.191572>, 
      <-0.882404, -3.632623, 0.436832>, <-1.058823, -3.718635, 0.456585>, <-1.317964, -3.793481, 0.344461>, <-1.472361, -3.886911, 0.264809>, 
      <-0.762442, -3.927294, 0.529067>, <-0.939947, -3.962820, 0.537536>, <-1.150481, -4.043651, 0.439412>, <-1.278883, -4.150655, 0.369376>, 
      <-0.664713, -4.129026, 0.632524>, <-0.842218, -4.164552, 0.640993>, <-1.069794, -4.258026, 0.545688>, <-1.198195, -4.365031, 0.475651>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.620126, -3.202574, 0.084521>, <-0.742425, -3.210282, 0.174327>, <-0.851260, -3.359071, 0.337921>, <-0.987134, -3.425315, 0.353134>, 
      <-0.496382, -3.481786, 0.213699>, <-0.618681, -3.489494, 0.303505>, <-0.746530, -3.566378, 0.421618>, <-0.882404, -3.632623, 0.436832>, 
      <-0.387509, -3.912452, 0.325224>, <-0.502539, -3.894763, 0.424601>, <-0.612544, -3.897293, 0.521916>, <-0.762442, -3.927294, 0.529067>, 
      <-0.198783, -4.165008, 0.427970>, <-0.313812, -4.147318, 0.527347>, <-0.514815, -4.099025, 0.625373>, <-0.664713, -4.129026, 0.632524>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.620126, -3.202574, 0.084521>, <-0.496382, -3.481786, 0.213699>, <-0.387509, -3.912452, 0.325224>, <-0.198783, -4.165008, 0.427970>, 
      <-0.486804, -3.194171, -0.013379>, <-0.363060, -3.473383, 0.115800>, <-0.275398, -3.929693, 0.228368>, <-0.086670, -4.182248, 0.331115>, 
      <-0.240424, -3.229496, -0.160859>, <-0.144047, -3.474466, -0.067012>, <-0.053971, -3.923584, 0.062350>, <0.056245, -4.168555, 0.139471>, 
      <-0.197984, -3.375577, -0.226349>, <-0.101607, -3.620547, -0.132501>, <-0.052719, -3.995116, -0.068528>, <0.057497, -4.240088, 0.008593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.925969, -3.122055, -0.749841>, <-0.802057, -3.010347, -0.721753>, <-0.524464, -2.921414, -0.667686>, <-0.502571, -2.816516, -0.536772>, 
      <-0.750111, -3.421549, -0.616712>, <-0.626199, -3.309841, -0.588625>, <-0.439255, -3.087566, -0.566273>, <-0.417361, -2.982668, -0.435359>, 
      <-0.512955, -3.831358, -0.467010>, <-0.403413, -3.628538, -0.419910>, <-0.210972, -3.396840, -0.390735>, <-0.271261, -3.189322, -0.297702>, 
      <-0.348480, -4.137586, -0.334656>, <-0.238938, -3.934768, -0.287555>, <-0.137695, -3.583095, -0.319381>, <-0.197984, -3.375577, -0.226349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.159499, -3.408743, -0.685680>, <-1.078414, -3.345562, -0.731606>, <-1.008431, -3.196395, -0.768533>, <-0.925969, -3.122055, -0.749841>, 
      <-1.019249, -3.670071, -0.603081>, <-0.938163, -3.606890, -0.649008>, <-0.832573, -3.495889, -0.635404>, <-0.750111, -3.421549, -0.616712>, 
      <-0.827636, -4.029105, -0.534531>, <-0.711843, -4.038540, -0.535790>, <-0.567049, -3.931514, -0.490269>, <-0.512955, -3.831358, -0.467010>, 
      <-0.690374, -4.287250, -0.438065>, <-0.574581, -4.296684, -0.439323>, <-0.402574, -4.237743, -0.357915>, <-0.348480, -4.137586, -0.334656>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.446367, -3.527545, -0.455089>, <-1.357337, -3.527562, -0.529492>, <-1.243061, -3.473854, -0.638350>, <-1.159499, -3.408743, -0.685680>, 
      <-1.359495, -3.682850, -0.392264>, <-1.270466, -3.682866, -0.466667>, <-1.102810, -3.735182, -0.555752>, <-1.019249, -3.670071, -0.603081>, 
      <-1.233511, -3.906823, -0.378763>, <-1.094703, -3.960707, -0.432163>, <-0.985290, -4.016260, -0.532818>, <-0.827636, -4.029105, -0.534531>, 
      <-1.158280, -4.071608, -0.325853>, <-1.019473, -4.125491, -0.379253>, <-0.848028, -4.274404, -0.436351>, <-0.690374, -4.287250, -0.438065>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.912407, -3.408599, -0.056462>, <-1.830043, -3.497605, -0.199347>, <-1.590169, -3.527517, -0.334910>, <-1.446367, -3.527545, -0.455089>, 
      <-1.843159, -3.533141, -0.006811>, <-1.760795, -3.622147, -0.149697>, <-1.503298, -3.682822, -0.272085>, <-1.359495, -3.682850, -0.392264>, 
      <-1.803192, -3.748529, -0.070653>, <-1.694016, -3.853778, -0.205818>, <-1.411767, -3.837626, -0.310187>, <-1.233511, -3.906823, -0.378763>, 
      <-1.738894, -3.880226, -0.034695>, <-1.629719, -3.985474, -0.169860>, <-1.336536, -4.002410, -0.257277>, <-1.158280, -4.071608, -0.325853>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.756094, -3.192839, 0.082227>, <-1.816433, -3.257892, 0.066504>, <-1.952010, -3.365802, 0.012241>, <-1.912407, -3.408599, -0.056462>, 
      <-1.690941, -3.328118, 0.124929>, <-1.751279, -3.393170, 0.109205>, <-1.882762, -3.490344, 0.061891>, <-1.843159, -3.533141, -0.006811>, 
      <-1.640417, -3.533811, 0.146297>, <-1.722568, -3.583522, 0.103916>, <-1.859600, -3.694150, -0.000817>, <-1.803192, -3.748529, -0.070653>, 
      <-1.576214, -3.668707, 0.191572>, <-1.658365, -3.718418, 0.149191>, <-1.795302, -3.825846, 0.035142>, <-1.738894, -3.880226, -0.034695>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.340281, -2.791777, 0.092629>, <-1.486882, -2.868242, 0.144675>, <-1.640022, -3.067700, 0.112475>, <-1.756094, -3.192839, 0.082227>, 
      <-1.232043, -2.983849, 0.162256>, <-1.378643, -3.060314, 0.214302>, <-1.574869, -3.202979, 0.155176>, <-1.690941, -3.328118, 0.124929>, 
      <-1.085214, -3.231172, 0.274752>, <-1.261634, -3.317184, 0.294505>, <-1.486020, -3.440381, 0.225950>, <-1.640417, -3.533811, 0.146297>, 
      <-0.987134, -3.425315, 0.353134>, <-1.163554, -3.511327, 0.372888>, <-1.421817, -3.575277, 0.271225>, <-1.576214, -3.668707, 0.191572>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.841139, -2.715611, -0.242596>, <-0.986462, -2.711319, -0.133409>, <-1.186510, -2.711572, 0.038038>, <-1.340281, -2.791777, 0.092629>, 
      <-0.794964, -2.861549, -0.133332>, <-0.940287, -2.857258, -0.024146>, <-1.078271, -2.903644, 0.107665>, <-1.232043, -2.983849, 0.162256>, 
      <-0.690307, -3.044220, 0.011259>, <-0.812606, -3.051928, 0.101065>, <-0.949340, -3.164928, 0.259538>, <-1.085214, -3.231172, 0.274752>, 
      <-0.620126, -3.202574, 0.084521>, <-0.742425, -3.210282, 0.174327>, <-0.851260, -3.359071, 0.337921>, <-0.987134, -3.425315, 0.353134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.841139, -2.715611, -0.242596>, <-0.794964, -2.861549, -0.133332>, <-0.690307, -3.044220, 0.011259>, <-0.620126, -3.202574, 0.084521>, 
      <-0.730906, -2.718866, -0.325418>, <-0.684730, -2.864805, -0.216154>, <-0.556985, -3.035817, -0.086641>, <-0.486804, -3.194171, -0.013379>, 
      <-0.484723, -2.731000, -0.430048>, <-0.399513, -2.897152, -0.328635>, <-0.313701, -3.043242, -0.232212>, <-0.240424, -3.229496, -0.160859>, 
      <-0.502571, -2.816516, -0.536772>, <-0.417361, -2.982668, -0.435359>, <-0.271261, -3.189322, -0.297702>, <-0.197984, -3.375577, -0.226349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.147362, -2.777053, -0.939427>, <-0.998391, -2.679736, -0.924324>, <-0.733029, -2.597375, -0.875346>, <-0.670409, -2.454381, -0.788613>, 
      <-1.111930, -2.906904, -0.923869>, <-0.962958, -2.809587, -0.908766>, <-0.726091, -2.734878, -0.842314>, <-0.663471, -2.591884, -0.755580>, 
      <-0.990030, -3.012955, -0.798337>, <-0.866119, -2.901247, -0.770249>, <-0.581240, -2.810705, -0.735259>, <-0.559346, -2.705806, -0.604344>, 
      <-0.925969, -3.122055, -0.749841>, <-0.802057, -3.010347, -0.721753>, <-0.524464, -2.921414, -0.667686>, <-0.502571, -2.816516, -0.536772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.413518, -2.939824, -0.863948>, <-1.324413, -2.912253, -0.887884>, <-1.227691, -2.829529, -0.947570>, <-1.147362, -2.777053, -0.939427>, 
      <-1.366481, -3.098974, -0.833680>, <-1.277377, -3.071403, -0.857616>, <-1.192259, -2.959379, -0.932012>, <-1.111930, -2.906904, -0.923869>, 
      <-1.236347, -3.265553, -0.730938>, <-1.155262, -3.202373, -0.776864>, <-1.072493, -3.087295, -0.817029>, <-0.990030, -3.012955, -0.798337>, 
      <-1.159499, -3.408743, -0.685680>, <-1.078414, -3.345562, -0.731606>, <-1.008431, -3.196395, -0.768533>, <-0.925969, -3.122055, -0.749841>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.773954, -2.970936, -0.771104>, <-1.674190, -2.974606, -0.821984>, <-1.517201, -2.971906, -0.836095>, <-1.413518, -2.939824, -0.863948>, 
      <-1.748106, -3.176073, -0.709622>, <-1.648342, -3.179743, -0.760502>, <-1.470164, -3.131056, -0.805827>, <-1.366481, -3.098974, -0.833680>, 
      <-1.545664, -3.350027, -0.526899>, <-1.456634, -3.350044, -0.601303>, <-1.319909, -3.330664, -0.683608>, <-1.236347, -3.265553, -0.730938>, 
      <-1.446367, -3.527545, -0.455089>, <-1.357337, -3.527562, -0.529492>, <-1.243061, -3.473854, -0.638350>, <-1.159499, -3.408743, -0.685680>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.279490, -2.907969, -0.422297>, <-2.200994, -3.006372, -0.558175>, <-1.938869, -2.964869, -0.686996>, <-1.773954, -2.970936, -0.771104>, 
      <-2.254839, -3.113547, -0.360174>, <-2.176344, -3.211950, -0.496052>, <-1.913021, -3.170007, -0.625514>, <-1.748106, -3.176073, -0.709622>, 
      <-2.011607, -3.230189, -0.127587>, <-1.929243, -3.319195, -0.270472>, <-1.689466, -3.349999, -0.406721>, <-1.545664, -3.350027, -0.526899>, 
      <-1.912407, -3.408599, -0.056462>, <-1.830043, -3.497605, -0.199347>, <-1.590169, -3.527517, -0.334910>, <-1.446367, -3.527545, -0.455089>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.123043, -2.533314, -0.166820>, <-2.221224, -2.623104, -0.221666>, <-2.340477, -2.831514, -0.316726>, <-2.279490, -2.907969, -0.422297>, 
      <-2.105293, -2.767539, -0.125928>, <-2.203474, -2.857329, -0.180774>, <-2.315827, -3.037092, -0.254603>, <-2.254839, -3.113547, -0.360174>, 
      <-1.855606, -2.986219, 0.017007>, <-1.915945, -3.051271, 0.001283>, <-2.051209, -3.187393, -0.058884>, <-2.011607, -3.230189, -0.127587>, 
      <-1.756094, -3.192839, 0.082227>, <-1.816433, -3.257892, 0.066504>, <-1.952010, -3.365802, 0.012241>, <-1.912407, -3.408599, -0.056462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.619049, -2.303970, -0.053359>, <-1.774039, -2.339605, 0.005479>, <-2.007357, -2.427514, -0.102194>, <-2.123043, -2.533314, -0.166820>, 
      <-1.610041, -2.473157, -0.013076>, <-1.765030, -2.508792, 0.045762>, <-1.989606, -2.661739, -0.061303>, <-2.105293, -2.767539, -0.125928>, 
      <-1.421810, -2.647103, 0.040184>, <-1.568411, -2.723567, 0.092230>, <-1.739535, -2.861080, 0.047254>, <-1.855606, -2.986219, 0.017007>, 
      <-1.340281, -2.791777, 0.092629>, <-1.486882, -2.868242, 0.144675>, <-1.640022, -3.067700, 0.112475>, <-1.756094, -3.192839, 0.082227>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.919441, -2.256589, -0.623736>, <-1.132107, -2.222870, -0.458907>, <-1.371195, -2.246985, -0.147450>, <-1.619049, -2.303970, -0.053359>, 
      <-0.915273, -2.416759, -0.540565>, <-1.127940, -2.383039, -0.375736>, <-1.362186, -2.416172, -0.107167>, <-1.610041, -2.473157, -0.013076>, 
      <-0.885463, -2.575525, -0.347478>, <-1.030786, -2.571233, -0.238292>, <-1.268039, -2.566898, -0.014407>, <-1.421810, -2.647103, 0.040184>, 
      <-0.841139, -2.715611, -0.242596>, <-0.986462, -2.711319, -0.133409>, <-1.186510, -2.711572, 0.038038>, <-1.340281, -2.791777, 0.092629>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.919441, -2.256589, -0.623736>, <-0.915273, -2.416759, -0.540565>, <-0.885463, -2.575525, -0.347478>, <-0.841139, -2.715611, -0.242596>, 
      <-0.835159, -2.269952, -0.689059>, <-0.830992, -2.430122, -0.605889>, <-0.775230, -2.578780, -0.430300>, <-0.730906, -2.718866, -0.325418>, 
      <-0.632726, -2.368330, -0.736418>, <-0.625788, -2.505833, -0.703386>, <-0.541498, -2.620291, -0.497620>, <-0.484723, -2.731000, -0.430048>, 
      <-0.670409, -2.454381, -0.788613>, <-0.663471, -2.591884, -0.755580>, <-0.559346, -2.705806, -0.604344>, <-0.502571, -2.816516, -0.536772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.685648, -1.628497, -1.024254>, <-1.604009, -2.021895, -0.976162>, <-1.526345, -2.558067, -0.936552>, <-1.413518, -2.939824, -0.863948>, 
      <-1.685648, -1.628497, -1.024254>, <-1.653879, -2.413765, -0.863854>, <-1.630028, -2.590149, -0.908699>, <-1.517201, -2.971906, -0.836095>, 
      <-1.685648, -1.628497, -1.024254>, <-1.653879, -2.413765, -0.863854>, <-1.723401, -2.584044, -0.939040>, <-1.674190, -2.974606, -0.821984>, 
      <-1.685648, -1.628497, -1.024254>, <-1.735518, -2.020367, -0.911946>, <-1.823165, -2.580374, -0.888159>, <-1.773954, -2.970936, -0.771104>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.278825, -1.828931, -0.904775>, <-1.064184, -1.853570, -0.860460>, <-0.738377, -1.879054, -0.818542>, <-0.555971, -1.758173, -0.791019>, 
      <-1.278665, -2.115036, -0.878094>, <-1.064024, -2.139674, -0.833779>, <-0.740830, -2.088760, -0.789905>, <-0.558423, -1.967879, -0.762381>, 
      <-1.222505, -2.501676, -0.972421>, <-1.073533, -2.404359, -0.957318>, <-0.743401, -2.391812, -0.924729>, <-0.680781, -2.248818, -0.837996>, 
      <-1.147362, -2.777053, -0.939427>, <-0.998391, -2.679736, -0.924324>, <-0.733029, -2.597375, -0.875346>, <-0.670409, -2.454381, -0.788613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.278825, -1.828931, -0.904775>, <-1.278665, -2.115036, -0.878094>, <-1.222505, -2.501676, -0.972421>, <-1.147362, -2.777053, -0.939427>, 
      <-1.415754, -1.813213, -0.933046>, <-1.415594, -2.099318, -0.906365>, <-1.302834, -2.554152, -0.980564>, <-1.227691, -2.829529, -0.947570>, 
      <-1.566807, -1.698101, -1.053025>, <-1.485168, -2.091500, -1.004933>, <-1.437241, -2.530496, -0.960488>, <-1.324413, -2.912253, -0.887884>, 
      <-1.685648, -1.628497, -1.024254>, <-1.604009, -2.021895, -0.976162>, <-1.526345, -2.558067, -0.936552>, <-1.413518, -2.939824, -0.863948>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.163984, -1.310501, -0.690479>, <-2.115207, -1.419124, -0.850297>, <-1.853987, -1.529902, -0.983499>, <-1.685648, -1.628497, -1.024254>, 
      <-2.217230, -1.784152, -0.589662>, <-2.168453, -1.892776, -0.749480>, <-1.903857, -1.921772, -0.871191>, <-1.735518, -2.020367, -0.911946>, 
      <-2.335044, -2.444658, -0.562303>, <-2.256548, -2.543061, -0.698182>, <-1.988080, -2.574308, -0.804052>, <-1.823165, -2.580374, -0.888159>, 
      <-2.279490, -2.907969, -0.422297>, <-2.200994, -3.006372, -0.558175>, <-1.938869, -2.964869, -0.686996>, <-1.773954, -2.970936, -0.771104>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.913016, -1.122160, -0.279277>, <-2.047993, -1.142762, -0.353005>, <-2.201962, -1.225927, -0.566045>, <-2.163984, -1.310501, -0.690479>, 
      <-1.985570, -1.540546, -0.215878>, <-2.120547, -1.561148, -0.289606>, <-2.255207, -1.699578, -0.465227>, <-2.217230, -1.784152, -0.589662>, 
      <-2.155006, -2.111548, -0.240453>, <-2.253187, -2.201338, -0.295299>, <-2.396031, -2.368203, -0.456732>, <-2.335044, -2.444658, -0.562303>, 
      <-2.123043, -2.533314, -0.166820>, <-2.221224, -2.623104, -0.221666>, <-2.340477, -2.831514, -0.316726>, <-2.279490, -2.907969, -0.422297>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.425157, -1.197731, -0.286910>, <-1.547376, -1.146503, -0.220743>, <-1.784174, -1.102494, -0.208900>, <-1.913016, -1.122160, -0.279277>, 
      <-1.531404, -1.514855, -0.205820>, <-1.653623, -1.463627, -0.139653>, <-1.856729, -1.520880, -0.145501>, <-1.985570, -1.540546, -0.215878>, 
      <-1.636851, -1.969638, -0.132962>, <-1.791840, -2.005273, -0.074125>, <-2.039319, -2.005748, -0.175827>, <-2.155006, -2.111548, -0.240453>, 
      <-1.619049, -2.303970, -0.053359>, <-1.774039, -2.339605, 0.005479>, <-2.007357, -2.427514, -0.102194>, <-2.123043, -2.533314, -0.166820>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.871237, -1.558821, -0.843274>, <-1.067089, -1.432538, -0.729684>, <-1.211246, -1.287391, -0.402717>, <-1.425157, -1.197731, -0.286910>, 
      <-0.921658, -1.762924, -0.778730>, <-1.117509, -1.636640, -0.665140>, <-1.317493, -1.604515, -0.321626>, <-1.531404, -1.514855, -0.205820>, 
      <-0.924518, -2.061463, -0.725057>, <-1.137184, -2.027744, -0.560228>, <-1.388996, -1.912653, -0.227054>, <-1.636851, -1.969638, -0.132962>, 
      <-0.919441, -2.256589, -0.623736>, <-1.132107, -2.222870, -0.458907>, <-1.371195, -2.246985, -0.147450>, <-1.619049, -2.303970, -0.053359>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.871237, -1.558821, -0.843274>, <-0.921658, -1.762924, -0.778730>, <-0.924518, -2.061463, -0.725057>, <-0.919441, -2.256589, -0.623736>, 
      <-0.785873, -1.613863, -0.892783>, <-0.836294, -1.817966, -0.828239>, <-0.840236, -2.074826, -0.790381>, <-0.835159, -2.269952, -0.689059>, 
      <-0.462518, -1.696241, -0.776918>, <-0.464970, -1.905947, -0.748280>, <-0.643098, -2.162767, -0.785801>, <-0.632726, -2.368330, -0.736418>, 
      <-0.555971, -1.758173, -0.791019>, <-0.558423, -1.967879, -0.762381>, <-0.680781, -2.248818, -0.837996>, <-0.670409, -2.454381, -0.788613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.655607, -1.188595, -0.961470>, <-0.709731, -1.287307, -0.890023>, <-0.840668, -1.435078, -0.882405>, <-0.871237, -1.558821, -0.843274>, 
      <-0.655607, -1.188595, -0.961470>, <-0.679840, -1.458180, -0.838888>, <-0.755304, -1.490120, -0.931915>, <-0.785873, -1.613863, -0.892783>, 
      <-0.655607, -1.188595, -0.961470>, <-0.679840, -1.458180, -0.838888>, <-0.460423, -1.517068, -0.801386>, <-0.462518, -1.696241, -0.776918>, 
      <-0.655607, -1.188595, -0.961470>, <-0.625716, -1.359469, -0.910335>, <-0.553876, -1.579000, -0.815487>, <-0.555971, -1.758173, -0.791019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.148149, -1.370959, -1.070554>, <-0.995853, -1.356726, -1.020544>, <-0.665613, -1.304112, -1.073066>, <-0.655607, -1.188595, -0.961470>, 
      <-1.161299, -1.506420, -1.004492>, <-1.009002, -1.492188, -0.954482>, <-0.635722, -1.474985, -1.021931>, <-0.625716, -1.359469, -0.910335>, 
      <-1.278909, -1.678301, -0.918822>, <-1.064268, -1.702940, -0.874507>, <-0.736282, -1.699881, -0.843010>, <-0.553876, -1.579000, -0.815487>, 
      <-1.278825, -1.828931, -0.904775>, <-1.064184, -1.853570, -0.860460>, <-0.738377, -1.879054, -0.818542>, <-0.555971, -1.758173, -0.791019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.557862, -1.272913, -1.257748>, <-1.441696, -1.343081, -1.284369>, <-1.279031, -1.383190, -1.113532>, <-1.148149, -1.370959, -1.070554>, 
      <-1.611661, -1.383337, -1.206093>, <-1.495495, -1.453505, -1.232714>, <-1.292180, -1.518651, -1.047471>, <-1.161299, -1.506420, -1.004492>, 
      <-1.669467, -1.501350, -1.060694>, <-1.550626, -1.570955, -1.089465>, <-1.415838, -1.662583, -0.947093>, <-1.278909, -1.678301, -0.918822>, 
      <-1.685648, -1.628497, -1.024254>, <-1.566807, -1.698101, -1.053025>, <-1.415754, -1.813213, -0.933046>, <-1.278825, -1.828931, -0.904775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.045757, -0.828776, -0.864856>, <-1.993781, -0.967526, -1.041255>, <-1.751362, -1.156033, -1.213405>, <-1.557862, -1.272913, -1.257748>, 
      <-2.090809, -0.970009, -0.810973>, <-2.038833, -1.108760, -0.987372>, <-1.805161, -1.266457, -1.161750>, <-1.611661, -1.383337, -1.206093>, 
      <-2.146745, -1.157148, -0.723121>, <-2.097968, -1.265771, -0.882938>, <-1.837806, -1.402755, -1.019939>, <-1.669467, -1.501350, -1.060694>, 
      <-2.163984, -1.310501, -0.690479>, <-2.115207, -1.419124, -0.850297>, <-1.853987, -1.529902, -0.983499>, <-1.685648, -1.628497, -1.024254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.794790, -0.640435, -0.453654>, <-1.936734, -0.654604, -0.514728>, <-2.080768, -0.735315, -0.746036>, <-2.045757, -0.828776, -0.864856>, 
      <-1.831681, -0.781856, -0.394333>, <-1.973625, -0.796025, -0.455407>, <-2.125820, -0.876549, -0.692152>, <-2.090809, -0.970009, -0.810973>, 
      <-1.886360, -0.968450, -0.302569>, <-2.021337, -0.989052, -0.376298>, <-2.184722, -1.072573, -0.598686>, <-2.146745, -1.157148, -0.723121>, 
      <-1.913016, -1.122160, -0.279277>, <-2.047993, -1.142762, -0.353005>, <-2.201962, -1.225927, -0.566045>, <-2.163984, -1.310501, -0.690479>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.092947, -0.733669, -0.454894>, <-1.270551, -0.648208, -0.375723>, <-1.600496, -0.621041, -0.370056>, <-1.794790, -0.640435, -0.453654>, 
      <-1.243688, -0.829108, -0.450119>, <-1.421292, -0.743648, -0.370948>, <-1.637386, -0.762463, -0.310735>, <-1.831681, -0.781856, -0.394333>, 
      <-1.370055, -1.033264, -0.328965>, <-1.492274, -0.982036, -0.262798>, <-1.757519, -0.948784, -0.232192>, <-1.886360, -0.968450, -0.302569>, 
      <-1.425157, -1.197731, -0.286910>, <-1.547376, -1.146503, -0.220743>, <-1.784174, -1.102494, -0.208900>, <-1.913016, -1.122160, -0.279277>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.092947, -0.733669, -0.454894>, <-1.243688, -0.829108, -0.450119>, <-1.370055, -1.033264, -0.328965>, <-1.425157, -1.197731, -0.286910>, 
      <-0.889953, -0.831347, -0.545383>, <-1.040693, -0.926786, -0.540608>, <-1.156145, -1.122925, -0.444772>, <-1.211246, -1.287391, -0.402717>, 
      <-0.640512, -1.014333, -0.793123>, <-0.694636, -1.113045, -0.721676>, <-1.036520, -1.308795, -0.768816>, <-1.067089, -1.432538, -0.729684>, 
      <-0.655607, -1.188595, -0.961470>, <-0.709731, -1.287307, -0.890023>, <-0.840668, -1.435078, -0.882405>, <-0.871237, -1.558821, -0.843274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.153301, -0.535835, -1.535393>, <-0.944063, -0.616632, -1.583965>, <-0.620847, -0.643192, -1.370935>, <-0.424022, -0.743182, -1.433623>, 
      <-1.154545, -0.820894, -1.504442>, <-0.945307, -0.901691, -1.553014>, <-0.625955, -0.833742, -1.290870>, <-0.429130, -0.933732, -1.353558>, 
      <-1.123226, -1.114212, -1.195765>, <-0.970929, -1.099979, -1.145755>, <-0.581688, -1.151047, -1.183852>, <-0.571682, -1.035531, -1.072256>, 
      <-1.148149, -1.370959, -1.070554>, <-0.995853, -1.356726, -1.020544>, <-0.665613, -1.304112, -1.073066>, <-0.655607, -1.188595, -0.961470>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.153301, -0.535835, -1.535393>, <-1.154545, -0.820894, -1.504442>, <-1.123226, -1.114212, -1.195765>, <-1.148149, -1.370959, -1.070554>, 
      <-1.153301, -0.535835, -1.535393>, <-1.275913, -1.042017, -1.421148>, <-1.254108, -1.126443, -1.238743>, <-1.279031, -1.383190, -1.113532>, 
      <-1.153301, -0.535835, -1.535393>, <-1.275913, -1.042017, -1.421148>, <-1.334448, -1.122950, -1.387344>, <-1.441696, -1.343081, -1.284369>, 
      <-1.153301, -0.535835, -1.535393>, <-1.274669, -0.756958, -1.452100>, <-1.450614, -1.052782, -1.360724>, <-1.557862, -1.272913, -1.257748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.436976, -0.899737, -1.763540>, <-0.572997, -0.919541, -1.554504>, <-0.613524, -0.835155, -1.201901>, <-0.611995, -0.796086, -0.954795>, 
      <-0.436976, -0.899737, -1.763540>, <-0.569111, -0.872575, -1.455529>, <-0.593770, -0.710288, -1.291817>, <-0.592241, -0.671219, -1.044711>, 
      <-0.436976, -0.899737, -1.763540>, <-0.569111, -0.872575, -1.455529>, <-0.357608, -0.834374, -1.609918>, <-0.451625, -0.786612, -1.579974>, 
      <-0.436976, -0.899737, -1.763540>, <-0.433090, -0.852770, -1.664565>, <-0.330005, -0.790944, -1.463567>, <-0.424022, -0.743182, -1.433623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.436976, -0.899737, -1.763540>, <-0.426877, -1.060534, -1.756839>, <-0.262805, -1.215579, -1.639770>, <-0.225702, -1.369834, -1.610937>, 
      <-0.572997, -0.919541, -1.554504>, <-0.562898, -1.080338, -1.547804>, <-0.399012, -1.218028, -1.477874>, <-0.361909, -1.372282, -1.449041>, 
      <-0.613524, -0.835155, -1.201901>, <-0.636213, -0.978576, -1.098623>, <-0.536110, -1.233803, -1.159349>, <-0.515615, -1.409305, -1.182365>, 
      <-0.611995, -0.796086, -0.954795>, <-0.634684, -0.939507, -0.851518>, <-0.545802, -1.207912, -0.949576>, <-0.525306, -1.383413, -0.972593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.427473, -0.656893, -0.227581>, <-0.482830, -0.698651, -0.445745>, <-0.610596, -0.760337, -0.728689>, <-0.611995, -0.796086, -0.954795>, 
      <-0.439079, -0.826850, -0.217044>, <-0.494436, -0.868608, -0.435209>, <-0.633285, -0.903759, -0.625412>, <-0.634684, -0.939507, -0.851518>, 
      <-0.314134, -1.037704, -0.266997>, <-0.458115, -1.088129, -0.433550>, <-0.556147, -1.180273, -0.725652>, <-0.545802, -1.207912, -0.949576>, 
      <-0.287151, -1.205666, -0.280856>, <-0.431132, -1.256091, -0.447409>, <-0.535651, -1.355775, -0.748669>, <-0.525306, -1.383413, -0.972593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.491604, -0.606664, -0.316481>, <-0.471329, -0.647620, -0.651624>, <-0.363839, -0.648490, -1.114530>, <-0.424022, -0.743182, -1.433623>, 
      <-0.459208, -0.618184, -0.305243>, <-0.438934, -0.659140, -0.640385>, <-0.391442, -0.691920, -1.260881>, <-0.451625, -0.786612, -1.579974>, 
      <-0.460593, -0.664951, -0.239690>, <-0.515950, -0.706709, -0.457854>, <-0.590842, -0.635471, -0.818606>, <-0.592241, -0.671219, -1.044711>, 
      <-0.427473, -0.656893, -0.227581>, <-0.482830, -0.698651, -0.445745>, <-0.610596, -0.760337, -0.728689>, <-0.611995, -0.796086, -0.954795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.491604, -0.606664, -0.316481>, <-0.587596, -0.768829, -0.302013>, <-0.933319, -0.632602, -0.459950>, <-1.092947, -0.733669, -0.454894>, 
      <-0.471329, -0.647620, -0.651624>, <-0.567321, -0.809784, -0.637155>, <-0.730325, -0.730281, -0.550439>, <-0.889953, -0.831347, -0.545383>, 
      <-0.363839, -0.648490, -1.114530>, <-0.368947, -0.839040, -1.034465>, <-0.556587, -0.861269, -0.903909>, <-0.640512, -1.014333, -0.793123>, 
      <-0.424022, -0.743182, -1.433623>, <-0.429130, -0.933732, -1.353558>, <-0.571682, -1.035531, -1.072256>, <-0.655607, -1.188595, -0.961470>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.770662, -0.699922, -2.170617>, <0.770570, -0.480703, -2.173511>, <0.775815, -0.182661, -2.091667>, <0.840311, 0.008794, -2.006517>, 
      <0.984841, -0.697046, -2.183763>, <0.984749, -0.477827, -2.186657>, <0.949430, -0.190964, -2.101638>, <1.013926, 0.000491, -2.016487>, 
      <1.271273, -0.688705, -2.170375>, <1.251438, -0.490793, -2.121249>, <1.265721, -0.212208, -2.055643>, <1.245886, -0.014297, -2.006517>, 
      <1.485820, -0.683897, -2.170271>, <1.465985, -0.485986, -2.121145>, <1.439539, -0.222104, -2.055643>, <1.419704, -0.024193, -2.006517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.770662, -0.699922, -2.170617>, <0.984841, -0.697046, -2.183763>, <1.271273, -0.688705, -2.170375>, <1.485820, -0.683897, -2.170271>, 
      <0.770750, -0.909400, -2.167852>, <0.984929, -0.906524, -2.180998>, <1.261537, -0.894610, -2.115691>, <1.476084, -0.889802, -2.115587>, 
      <0.827740, -1.165321, -2.029244>, <1.011100, -1.165594, -2.041101>, <1.279369, -1.166104, -2.042676>, <1.463103, -1.164343, -2.042676>, 
      <0.840893, -1.370359, -1.988314>, <1.024252, -1.370632, -2.000171>, <1.269633, -1.372010, -1.987992>, <1.453367, -1.370248, -1.987992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.414209, -0.698288, -2.104496>, <0.518782, -0.698194, -2.134388>, <0.662115, -0.701380, -2.163954>, <0.770662, -0.699922, -2.170617>, 
      <0.420584, -0.908244, -2.100742>, <0.525156, -0.908150, -2.130634>, <0.662203, -0.910858, -2.161190>, <0.770750, -0.909400, -2.167852>, 
      <0.491425, -1.163397, -1.966594>, <0.588368, -1.163309, -1.994306>, <0.727124, -1.165171, -2.022737>, <0.827740, -1.165321, -2.029244>, 
      <0.510446, -1.368843, -1.927017>, <0.607389, -1.368756, -1.954729>, <0.740277, -1.370209, -1.981808>, <0.840893, -1.370359, -1.988314>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.043982, -0.700578, -1.962893>, <0.029154, -0.910520, -1.957089>, <0.142087, -1.165155, -1.832340>, <0.167230, -1.370966, -1.795745>, 
      <-0.107639, -0.736462, -1.902159>, <-0.122467, -0.946404, -1.896355>, <0.022388, -1.165317, -1.780945>, <0.047530, -1.371127, -1.744349>, 
      <-0.346055, -0.886499, -1.903267>, <-0.335956, -1.047296, -1.896566>, <-0.178946, -1.214072, -1.739445>, <-0.141844, -1.368327, -1.710612>, 
      <-0.436976, -0.899737, -1.763540>, <-0.426877, -1.060534, -1.756839>, <-0.262805, -1.215579, -1.639770>, <-0.225702, -1.369834, -1.610937>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.043982, -0.700578, -1.962893>, <0.151801, -0.675061, -2.006082>, <0.299872, -0.698391, -2.071812>, <0.414209, -0.698288, -2.104496>, 
      <0.029154, -0.910520, -1.957089>, <0.136973, -0.885003, -2.000278>, <0.306246, -0.908347, -2.068058>, <0.420584, -0.908244, -2.100742>, 
      <0.142087, -1.165155, -1.832340>, <0.243385, -1.165019, -1.875834>, <0.385429, -1.163492, -1.936295>, <0.491425, -1.163397, -1.966594>, 
      <0.167230, -1.370966, -1.795745>, <0.268528, -1.370830, -1.839239>, <0.404451, -1.368938, -1.896718>, <0.510446, -1.368843, -1.927017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.812041, -0.207197, -1.111410>, <-1.687446, -0.284184, -1.319982>, <-1.385664, -0.446108, -1.481453>, <-1.153301, -0.535835, -1.535393>, 
      <-1.915920, -0.391335, -1.089917>, <-1.791325, -0.468322, -1.298490>, <-1.507033, -0.667231, -1.398159>, <-1.274669, -0.756958, -1.452100>, 
      <-1.985060, -0.638499, -0.937450>, <-1.933084, -0.777249, -1.113849>, <-1.644114, -0.935902, -1.316381>, <-1.450614, -1.052782, -1.360724>, 
      <-2.045757, -0.828776, -0.864856>, <-1.993781, -0.967526, -1.041255>, <-1.751362, -1.156033, -1.213405>, <-1.557862, -1.272913, -1.257748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.675846, -0.212957, -0.660654>, <-1.793009, -0.177512, -0.731189>, <-1.881107, -0.164521, -0.995793>, <-1.812041, -0.207197, -1.111410>, 
      <-1.732761, -0.342918, -0.622615>, <-1.849924, -0.307473, -0.693150>, <-1.984986, -0.348659, -0.974300>, <-1.915920, -0.391335, -1.089917>, 
      <-1.760436, -0.508738, -0.508896>, <-1.902380, -0.522906, -0.569970>, <-2.020071, -0.545038, -0.818630>, <-1.985060, -0.638499, -0.937450>, 
      <-1.794790, -0.640435, -0.453654>, <-1.936734, -0.654604, -0.514728>, <-2.080768, -0.735315, -0.746036>, <-2.045757, -0.828776, -0.864856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.675846, -0.212957, -0.660654>, <-1.732761, -0.342918, -0.622615>, <-1.760436, -0.508738, -0.508896>, <-1.794790, -0.640435, -0.453654>, 
      <-1.353762, -0.310396, -0.466753>, <-1.410677, -0.440356, -0.428714>, <-1.566142, -0.489344, -0.425298>, <-1.600496, -0.621041, -0.370056>, 
      <-0.839416, -0.482978, -0.437140>, <-0.935408, -0.645143, -0.422672>, <-1.110923, -0.547141, -0.380779>, <-1.270551, -0.648208, -0.375723>, 
      <-0.491604, -0.606664, -0.316481>, <-0.587596, -0.768829, -0.302013>, <-0.933319, -0.632602, -0.459950>, <-1.092947, -0.733669, -0.454894>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.030001, -0.479760, -0.125780>, <-0.111940, -0.522004, -0.151472>, <-0.289853, -0.623411, -0.177266>, <-0.427473, -0.656893, -0.227581>, 
      <0.025504, -0.682988, -0.109112>, <-0.116437, -0.725232, -0.134804>, <-0.301459, -0.793368, -0.166730>, <-0.439079, -0.826850, -0.217044>, 
      <0.129586, -0.943682, -0.169296>, <-0.003247, -0.965292, -0.192825>, <-0.227041, -1.007203, -0.166252>, <-0.314134, -1.037704, -0.266997>, 
      <0.154270, -1.145412, -0.186482>, <0.021438, -1.167022, -0.210010>, <-0.200059, -1.175164, -0.180111>, <-0.287151, -1.205666, -0.280856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.426117, -0.402850, -0.073076>, <0.306189, -0.419031, -0.089186>, <0.145289, -0.445448, -0.104912>, <0.030001, -0.479760, -0.125780>, 
      <0.425763, -0.606232, -0.053521>, <0.305835, -0.622413, -0.069631>, <0.140792, -0.648677, -0.088244>, <0.025504, -0.682988, -0.109112>, 
      <0.503194, -0.871431, -0.119388>, <0.392016, -0.886431, -0.134323>, <0.239623, -0.925780, -0.149805>, <0.129586, -0.943682, -0.169296>, 
      <0.521486, -1.074112, -0.137623>, <0.410308, -1.089112, -0.152558>, <0.264308, -1.127510, -0.166991>, <0.154270, -1.145412, -0.186482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.727227, -0.385689, -0.032119>, <0.636285, -0.387897, -0.040002>, <0.515816, -0.390748, -0.061026>, <0.426117, -0.402850, -0.073076>, 
      <0.729998, -0.588601, -0.011644>, <0.639056, -0.590809, -0.019527>, <0.515462, -0.594130, -0.041471>, <0.425763, -0.606232, -0.053521>, 
      <0.787159, -0.855582, -0.080601>, <0.702852, -0.857628, -0.087909>, <0.586348, -0.860211, -0.108218>, <0.503194, -0.871431, -0.119388>, 
      <0.800626, -1.058204, -0.099655>, <0.716319, -1.060251, -0.106963>, <0.604640, -1.062893, -0.126453>, <0.521486, -1.074112, -0.137623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.051078, -0.387677, -0.018903>, <1.057175, -0.589854, 0.001586>, <1.092546, -0.857832, -0.068107>, <1.100849, -1.060048, -0.087403>, 
      <1.129488, -0.387735, -0.017078>, <1.135585, -0.589912, 0.003412>, <1.156330, -0.857881, -0.066536>, <1.164633, -1.060097, -0.085832>, 
      <1.234094, -0.387646, -0.018495>, <1.232362, -0.589389, 0.002000>, <1.250186, -0.858308, -0.067757>, <1.249737, -1.060179, -0.087025>, 
      <1.312510, -0.386120, -0.018495>, <1.310778, -0.587863, 0.002000>, <1.313970, -0.856727, -0.067757>, <1.313520, -1.058598, -0.087025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.051078, -0.387677, -0.018903>, <0.953866, -0.387605, -0.021166>, <0.824073, -0.383338, -0.023724>, <0.727227, -0.385689, -0.032119>, 
      <1.057175, -0.589854, 0.001586>, <0.959963, -0.589783, -0.000677>, <0.826845, -0.586250, -0.003249>, <0.729998, -0.588601, -0.011644>, 
      <1.092546, -0.857832, -0.068107>, <1.002430, -0.857762, -0.070326>, <0.876940, -0.853402, -0.072819>, <0.787159, -0.855582, -0.080601>, 
      <1.100849, -1.060048, -0.087403>, <1.010733, -1.059979, -0.089622>, <0.890406, -1.056025, -0.091873>, <0.800626, -1.058204, -0.099655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.468239, 0.021311, -1.951876>, <0.576137, 0.013810, -1.984186>, <0.727744, 0.014178, -2.000052>, <0.840311, 0.008794, -2.006517>, 
      <0.383852, -0.167378, -2.030860>, <0.491751, -0.174879, -2.063169>, <0.663247, -0.177277, -2.085203>, <0.775815, -0.182661, -2.091667>, 
      <0.407495, -0.477149, -2.108450>, <0.512068, -0.477055, -2.138343>, <0.662022, -0.482161, -2.166848>, <0.770570, -0.480703, -2.173511>, 
      <0.414209, -0.698288, -2.104496>, <0.518782, -0.698194, -2.134388>, <0.662115, -0.701380, -2.163954>, <0.770662, -0.699922, -2.170617>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.267491, 0.048616, -1.834988>, <0.333350, 0.042642, -1.858455>, <0.401167, 0.025974, -1.931792>, <0.468239, 0.021311, -1.951876>, 
      <0.146566, -0.144034, -1.903894>, <0.212425, -0.150008, -1.927361>, <0.316781, -0.162715, -2.010776>, <0.383852, -0.167378, -2.030860>, 
      <0.060720, -0.463594, -1.969444>, <0.168538, -0.438076, -2.012633>, <0.293158, -0.477252, -2.075767>, <0.407495, -0.477149, -2.108450>, 
      <0.043982, -0.700578, -1.962893>, <0.151801, -0.675061, -2.006082>, <0.299872, -0.698391, -2.071812>, <0.414209, -0.698288, -2.104496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.317550, 0.092591, -1.671879>, <-0.147029, 0.086452, -1.737132>, <0.096031, 0.064169, -1.773892>, <0.267491, 0.048616, -1.834988>, 
      <-0.494554, -0.144039, -1.729670>, <-0.324033, -0.150178, -1.794923>, <-0.024893, -0.128480, -1.842798>, <0.146566, -0.144034, -1.903894>, 
      <-0.455834, -0.599484, -1.776052>, <-0.364912, -0.586246, -1.915779>, <-0.090902, -0.499478, -1.908710>, <0.060720, -0.463594, -1.969444>, 
      <-0.436976, -0.899737, -1.763540>, <-0.346055, -0.886499, -1.903267>, <-0.107639, -0.736462, -1.902159>, <0.043982, -0.700578, -1.962893>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.621583, 0.080624, -1.494768>, <-0.528626, 0.082575, -1.544872>, <-0.416137, 0.096140, -1.634153>, <-0.317550, 0.092591, -1.671879>, 
      <-0.768052, -0.125804, -1.524144>, <-0.675094, -0.123852, -1.574248>, <-0.593141, -0.140490, -1.691944>, <-0.494554, -0.144039, -1.729670>, 
      <-0.417727, -0.508338, -1.532299>, <-0.323709, -0.556100, -1.562243>, <-0.451947, -0.552517, -1.677077>, <-0.455834, -0.599484, -1.776052>, 
      <-0.424022, -0.743182, -1.433623>, <-0.330005, -0.790944, -1.463567>, <-0.433090, -0.852770, -1.664565>, <-0.436976, -0.899737, -1.763540>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.621583, 0.080624, -1.494768>, <-0.768052, -0.125804, -1.524144>, <-0.417727, -0.508338, -1.532299>, <-0.424022, -0.743182, -1.433623>, 
      <-0.776012, 0.077382, -1.411530>, <-0.922481, -0.129045, -1.440907>, <-0.614552, -0.408349, -1.469611>, <-0.620847, -0.643192, -1.370935>, 
      <-0.997573, 0.034854, -1.318908>, <-1.157158, -0.088156, -1.358309>, <-0.943173, -0.412526, -1.606127>, <-0.944063, -0.616632, -1.583965>, 
      <-1.141839, 0.075287, -1.227585>, <-1.301424, -0.047723, -1.266986>, <-1.152411, -0.331729, -1.557555>, <-1.153301, -0.535835, -1.535393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.408339, 0.301125, -0.996738>, <-1.363682, 0.240595, -1.097337>, <-1.245117, 0.104232, -1.162208>, <-1.141839, 0.075287, -1.227585>, 
      <-1.589132, 0.221444, -1.005188>, <-1.544475, 0.160914, -1.105787>, <-1.404702, -0.018777, -1.201609>, <-1.301424, -0.047723, -1.266986>, 
      <-1.715374, -0.035844, -1.131410>, <-1.590779, -0.112830, -1.339983>, <-1.384774, -0.242002, -1.503614>, <-1.152411, -0.331729, -1.557555>, 
      <-1.812041, -0.207197, -1.111410>, <-1.687446, -0.284184, -1.319982>, <-1.385664, -0.446108, -1.481453>, <-1.153301, -0.535835, -1.535393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.354881, 0.364055, -0.747664>, <-1.424800, 0.369198, -0.783469>, <-1.436326, 0.339060, -0.933692>, <-1.408339, 0.301125, -0.996738>, 
      <-1.534445, 0.278267, -0.729910>, <-1.604363, 0.283410, -0.765714>, <-1.617118, 0.259379, -0.942142>, <-1.589132, 0.221444, -1.005188>, 
      <-1.598431, -0.036187, -0.712394>, <-1.715594, -0.000742, -0.782929>, <-1.784441, 0.006832, -1.015793>, <-1.715374, -0.035844, -1.131410>, 
      <-1.675846, -0.212957, -0.660654>, <-1.793009, -0.177512, -0.731189>, <-1.881107, -0.164521, -0.995793>, <-1.812041, -0.207197, -1.111410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.519125, 0.235722, -0.541382>, <-0.767745, 0.246295, -0.620451>, <-1.122972, 0.346998, -0.628906>, <-1.354881, 0.364055, -0.747664>, 
      <-0.673189, 0.034076, -0.477440>, <-0.921810, 0.044649, -0.556509>, <-1.302536, 0.261210, -0.611152>, <-1.534445, 0.278267, -0.729910>, 
      <-0.358690, -0.382124, -0.336514>, <-0.706502, -0.258438, -0.457174>, <-1.276347, -0.133626, -0.518493>, <-1.598431, -0.036187, -0.712394>, 
      <-0.491604, -0.606664, -0.316481>, <-0.839416, -0.482978, -0.437140>, <-1.353762, -0.310396, -0.466753>, <-1.675846, -0.212957, -0.660654>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.183361, 0.314235, -0.375083>, <-0.290021, 0.289061, -0.409436>, <-0.409768, 0.231072, -0.506603>, <-0.519125, 0.235722, -0.541382>, 
      <-0.363922, 0.079598, -0.307683>, <-0.470581, 0.054424, -0.342036>, <-0.563832, 0.029425, -0.442661>, <-0.673189, 0.034076, -0.477440>, 
      <-0.406826, -0.354533, -0.246326>, <-0.439946, -0.362591, -0.258435>, <-0.326294, -0.393645, -0.325276>, <-0.358690, -0.382124, -0.336514>, 
      <-0.427473, -0.656893, -0.227581>, <-0.460593, -0.664951, -0.239690>, <-0.459208, -0.618184, -0.305243>, <-0.491604, -0.606664, -0.316481>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.188526, 0.402744, -0.313458>, <0.076152, 0.376876, -0.327484>, <-0.075481, 0.339697, -0.340336>, <-0.183361, 0.314235, -0.375083>, 
      <0.048484, 0.177677, -0.240944>, <-0.063890, 0.151810, -0.254970>, <-0.256041, 0.105061, -0.272936>, <-0.363922, 0.079598, -0.307683>, 
      <0.036060, -0.205928, -0.148239>, <-0.105881, -0.248172, -0.173931>, <-0.269205, -0.321051, -0.196011>, <-0.406826, -0.354533, -0.246326>, 
      <0.030001, -0.479760, -0.125780>, <-0.111940, -0.522004, -0.151472>, <-0.289853, -0.623411, -0.177266>, <-0.427473, -0.656893, -0.227581>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.524188, 0.477107, -0.286771>, <0.422563, 0.460384, -0.296502>, <0.288602, 0.425781, -0.300967>, <0.188526, 0.402744, -0.313458>, 
      <0.419452, 0.235828, -0.212746>, <0.317827, 0.219105, -0.222477>, <0.148561, 0.200714, -0.228453>, <0.048484, 0.177677, -0.240944>, 
      <0.426591, -0.130856, -0.099228>, <0.306663, -0.147037, -0.115338>, <0.151348, -0.171617, -0.127371>, <0.036060, -0.205928, -0.148239>, 
      <0.426117, -0.402850, -0.073076>, <0.306189, -0.419031, -0.089186>, <0.145289, -0.445448, -0.104912>, <0.030001, -0.479760, -0.125780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.779344, 0.499969, -0.256883>, <0.702281, 0.496466, -0.262871>, <0.600197, 0.489615, -0.279493>, <0.524188, 0.477107, -0.286771>, 
      <0.706336, 0.247053, -0.178847>, <0.629272, 0.243551, -0.184835>, <0.495462, 0.248336, -0.205467>, <0.419452, 0.235828, -0.212746>, 
      <0.723496, -0.112536, -0.059682>, <0.632554, -0.114744, -0.067565>, <0.516290, -0.118754, -0.087178>, <0.426591, -0.130856, -0.099228>, 
      <0.727227, -0.385689, -0.032119>, <0.636285, -0.387897, -0.040002>, <0.515816, -0.390748, -0.061026>, <0.426117, -0.402850, -0.073076>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.053769, 0.501177, -0.245623>, <0.971390, 0.500790, -0.247317>, <0.861410, 0.503699, -0.250507>, <0.779344, 0.499969, -0.256883>, 
      <1.012349, 0.241120, -0.165703>, <0.929970, 0.240733, -0.167397>, <0.788401, 0.250783, -0.172471>, <0.706336, 0.247053, -0.178847>, 
      <1.042825, -0.114007, -0.046638>, <0.945614, -0.113936, -0.048901>, <0.820343, -0.110185, -0.051287>, <0.723496, -0.112536, -0.059682>, 
      <1.051078, -0.387677, -0.018903>, <0.953866, -0.387605, -0.021166>, <0.824073, -0.383338, -0.023724>, <0.727227, -0.385689, -0.032119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.053769, 0.501177, -0.245623>, <1.083171, 0.685775, -0.302353>, <1.156416, 0.931775, -0.409649>, <1.283107, 1.069125, -0.466602>, 
      <1.053769, 0.501177, -0.245623>, <1.165099, 0.686160, -0.300668>, <1.215606, 0.772487, -0.341949>, <1.342297, 0.909837, -0.398903>, 
      <1.053769, 0.501177, -0.245623>, <1.165099, 0.686160, -0.300668>, <1.241458, 0.675738, -0.299444>, <1.323389, 0.677327, -0.299444>, 
      <1.053769, 0.501177, -0.245623>, <1.135697, 0.501562, -0.243938>, <1.244989, 0.500952, -0.245623>, <1.326920, 0.502541, -0.245623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.053769, 0.501177, -0.245623>, <1.012349, 0.241120, -0.165703>, <1.042825, -0.114007, -0.046638>, <1.051078, -0.387677, -0.018903>, 
      <1.135697, 0.501562, -0.243938>, <1.094277, 0.241505, -0.164019>, <1.121235, -0.114065, -0.044812>, <1.129488, -0.387735, -0.017078>, 
      <1.244989, 0.500952, -0.245623>, <1.250302, 0.237986, -0.164649>, <1.236444, -0.113863, -0.046309>, <1.234094, -0.387646, -0.018495>, 
      <1.326920, 0.502541, -0.245623>, <1.332233, 0.239575, -0.164649>, <1.314860, -0.112337, -0.046309>, <1.312510, -0.386120, -0.018495>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.053769, 0.501177, -0.245623>, <1.135697, 0.501562, -0.243938>, <1.244989, 0.500952, -0.245623>, <1.326920, 0.502541, -0.245623>, 
      <1.083171, 0.685775, -0.302353>, <1.165099, 0.686160, -0.300668>, <1.333292, 0.502665, -0.245623>, <1.415223, 0.504253, -0.245623>, 
      <1.156416, 0.931775, -0.409649>, <1.257832, 0.764691, -0.343355>, <1.488423, 0.703737, -0.303493>, <1.532864, 0.511207, -0.243875>, 
      <1.283107, 1.069125, -0.466602>, <1.384523, 0.902042, -0.400308>, <1.576720, 0.704710, -0.305241>, <1.621161, 0.512180, -0.245623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.039719, 0.700356, -1.519033>, <1.098470, 0.697425, -1.536420>, <1.180951, 0.697384, -1.543731>, <1.242090, 0.699494, -1.548219>, 
      <0.868275, 0.496642, -1.648886>, <0.927026, 0.493711, -1.666272>, <1.060417, 0.490175, -1.681221>, <1.121556, 0.492284, -1.685708>, 
      <0.581211, 0.273918, -1.846136>, <0.689110, 0.266417, -1.878446>, <0.809041, 0.255504, -1.892721>, <0.921608, 0.250121, -1.899186>, 
      <0.468239, 0.021311, -1.951876>, <0.576137, 0.013810, -1.984186>, <0.727744, 0.014178, -2.000052>, <0.840311, 0.008794, -2.006517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.133718, 1.022477, -0.466602>, <1.027406, 0.865725, -0.403686>, <0.832413, 0.683812, -0.313607>, <0.779344, 0.499969, -0.256883>, 
      <1.178784, 1.033367, -0.459197>, <1.072472, 0.876615, -0.396281>, <0.914479, 0.687542, -0.307230>, <0.861410, 0.503699, -0.250507>, 
      <1.267915, 1.110011, -0.483979>, <1.141224, 0.972660, -0.427025>, <1.000791, 0.685388, -0.304047>, <0.971390, 0.500790, -0.247317>, 
      <1.283107, 1.069125, -0.466602>, <1.156416, 0.931775, -0.409649>, <1.083171, 0.685775, -0.302353>, <1.053769, 0.501177, -0.245623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.039531, 1.010266, -0.506625>, <0.884928, 0.850318, -0.440669>, <0.613123, 0.681985, -0.349628>, <0.524188, 0.477107, -0.286771>, 
      <1.065110, 1.016865, -0.490557>, <0.910507, 0.856917, -0.424601>, <0.689132, 0.694493, -0.342350>, <0.600197, 0.489615, -0.279493>, 
      <1.104040, 1.015306, -0.471479>, <0.997728, 0.858553, -0.408563>, <0.755350, 0.680309, -0.319595>, <0.702281, 0.496466, -0.262871>, 
      <1.133718, 1.022477, -0.466602>, <1.027406, 0.865725, -0.403686>, <0.832413, 0.683812, -0.313607>, <0.779344, 0.499969, -0.256883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.932414, 0.970546, -0.593055>, <0.709248, 0.800205, -0.509176>, <0.337838, 0.642709, -0.390773>, <0.188526, 0.402744, -0.313458>, 
      <0.966333, 0.982301, -0.569427>, <0.743166, 0.811961, -0.485548>, <0.437914, 0.665746, -0.378282>, <0.288602, 0.425781, -0.300967>, 
      <1.003977, 1.001094, -0.528959>, <0.849375, 0.841146, -0.463002>, <0.511498, 0.665262, -0.359360>, <0.422563, 0.460384, -0.296502>, 
      <1.039531, 1.010266, -0.506625>, <0.884928, 0.850318, -0.440669>, <0.613123, 0.681985, -0.349628>, <0.524188, 0.477107, -0.286771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.788513, 0.923270, -0.681489>, <0.496951, 0.740560, -0.589567>, <0.028421, 0.589444, -0.454138>, <-0.183361, 0.314235, -0.375083>, 
      <0.830230, 0.934824, -0.651575>, <0.538668, 0.752113, -0.559653>, <0.136301, 0.614906, -0.419391>, <-0.075481, 0.339697, -0.340336>, 
      <0.890886, 0.956153, -0.621985>, <0.667719, 0.785813, -0.538106>, <0.225464, 0.616842, -0.404799>, <0.076152, 0.376876, -0.327484>, 
      <0.932414, 0.970546, -0.593055>, <0.709248, 0.800205, -0.509176>, <0.337838, 0.642709, -0.390773>, <0.188526, 0.402744, -0.313458>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.654662, 0.893620, -0.792224>, <0.302526, 0.696251, -0.716971>, <-0.277382, 0.552126, -0.641714>, <-0.519125, 0.235722, -0.541382>, 
      <0.690704, 0.903266, -0.754767>, <0.338568, 0.705897, -0.679514>, <-0.168025, 0.547475, -0.606935>, <-0.409768, 0.231072, -0.506603>, 
      <0.746597, 0.911661, -0.711546>, <0.455035, 0.728950, -0.619624>, <-0.078238, 0.564270, -0.488491>, <-0.290021, 0.289061, -0.409436>, 
      <0.788513, 0.923270, -0.681489>, <0.496951, 0.740560, -0.589567>, <0.028421, 0.589444, -0.454138>, <-0.183361, 0.314235, -0.375083>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.592729, 0.870871, -0.884960>, <0.008446, 0.718826, -0.843771>, <-0.811012, 0.623892, -0.801439>, <-1.354881, 0.364055, -0.747664>, 
      <0.605528, 0.878530, -0.854247>, <0.021245, 0.726486, -0.813058>, <-0.579103, 0.606835, -0.682682>, <-1.122972, 0.346998, -0.628906>, 
      <0.631386, 0.887390, -0.816415>, <0.279249, 0.690021, -0.741162>, <-0.526003, 0.562699, -0.720784>, <-0.767745, 0.246295, -0.620451>, 
      <0.654662, 0.893620, -0.792224>, <0.302526, 0.696251, -0.716971>, <-0.277382, 0.552126, -0.641714>, <-0.519125, 0.235722, -0.541382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.568001, 0.841761, -1.000175>, <-0.024901, 0.679570, -0.999144>, <-0.846372, 0.548801, -0.970474>, <-1.408339, 0.301125, -0.996738>, 
      <0.569684, 0.852577, -0.965445>, <-0.023218, 0.690386, -0.964414>, <-0.874359, 0.586736, -0.907428>, <-1.436326, 0.339060, -0.933692>, 
      <0.579079, 0.862702, -0.917716>, <-0.005205, 0.710658, -0.876527>, <-0.880931, 0.629035, -0.837244>, <-1.424800, 0.369198, -0.783469>, 
      <0.592729, 0.870871, -0.884960>, <0.008446, 0.718826, -0.843771>, <-0.811012, 0.623892, -0.801439>, <-1.354881, 0.364055, -0.747664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.581971, 0.801732, -1.106961>, <0.064828, 0.583799, -1.143148>, <-0.704723, 0.412221, -1.119663>, <-1.141839, 0.075287, -1.227585>, 
      <0.569710, 0.810993, -1.076107>, <0.052567, 0.593059, -1.112294>, <-0.808002, 0.441166, -1.054286>, <-1.245117, 0.104232, -1.162208>, 
      <0.566408, 0.831523, -1.033049>, <-0.026494, 0.669332, -1.032018>, <-0.801715, 0.488271, -1.071073>, <-1.363682, 0.240595, -1.097337>, 
      <0.568001, 0.841761, -1.000175>, <-0.024901, 0.679570, -0.999144>, <-0.846372, 0.548801, -0.970474>, <-1.408339, 0.301125, -0.996738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.654305, 0.776574, -1.217351>, <0.271539, 0.567789, -1.300576>, <-0.366436, 0.440219, -1.443595>, <-0.621583, 0.080624, -1.494768>, 
      <0.629488, 0.784184, -1.186516>, <0.246722, 0.575399, -1.269741>, <-0.520865, 0.436978, -1.360357>, <-0.776012, 0.077382, -1.411530>, 
      <0.596309, 0.790902, -1.143041>, <0.079166, 0.572969, -1.179228>, <-0.560458, 0.371788, -1.210986>, <-0.997573, 0.034854, -1.318908>, 
      <0.581971, 0.801732, -1.106961>, <0.064828, 0.583799, -1.143148>, <-0.704723, 0.412221, -1.119663>, <-1.141839, 0.075287, -1.227585>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.788404, 0.738432, -1.363459>, <0.456618, 0.544680, -1.455985>, <-0.085233, 0.403168, -1.596028>, <-0.317550, 0.092591, -1.671879>, 
      <0.743104, 0.748468, -1.324500>, <0.411318, 0.554716, -1.417026>, <-0.183820, 0.406718, -1.558302>, <-0.416137, 0.096140, -1.634153>, 
      <0.691608, 0.765136, -1.263701>, <0.308841, 0.556351, -1.346926>, <-0.273479, 0.442171, -1.493699>, <-0.528626, 0.082575, -1.544872>, 
      <0.654305, 0.776574, -1.217351>, <0.271539, 0.567789, -1.300576>, <-0.366436, 0.440219, -1.443595>, <-0.621583, 0.080624, -1.494768>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.932491, 0.714942, -1.456598>, <0.964098, 0.710153, -1.476164>, <1.003820, 0.702147, -1.508409>, <1.039719, 0.700356, -1.519033>, 
      <0.732991, 0.515044, -1.570115>, <0.764598, 0.510255, -1.589681>, <0.832376, 0.498434, -1.638262>, <0.868275, 0.496642, -1.648886>, 
      <0.422359, 0.295342, -1.746740>, <0.488217, 0.289368, -1.770207>, <0.514140, 0.278581, -1.826052>, <0.581211, 0.273918, -1.846136>, 
      <0.267491, 0.048616, -1.834988>, <0.333350, 0.042642, -1.858455>, <0.401167, 0.025974, -1.931792>, <0.468239, 0.021311, -1.951876>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.932491, 0.714942, -1.456598>, <0.732991, 0.515044, -1.570115>, <0.422359, 0.295342, -1.746740>, <0.267491, 0.048616, -1.834988>, 
      <0.888681, 0.721580, -1.429478>, <0.689181, 0.521682, -1.542995>, <0.250899, 0.310895, -1.685645>, <0.096031, 0.064169, -1.773892>, 
      <0.827248, 0.729826, -1.396866>, <0.495462, 0.536074, -1.489392>, <0.085289, 0.397029, -1.661281>, <-0.147029, 0.086452, -1.737132>, 
      <0.788404, 0.738432, -1.363459>, <0.456618, 0.544680, -1.455985>, <-0.085233, 0.403168, -1.596028>, <-0.317550, 0.092591, -1.671879>
    }
  }
  texture {
    YellowQuilted
    scale 3.0
    translate <-0.261718, -2.445111, 0.178027>
  }
  scale <0.8, 1.0, 1.0>
  translate  <0.55223, 0.0, -0.090687>
}
#declare Clothes = union {
  object { Sash }
  object { Pants }
  object { ManCape }
  object { ManShirt }
  rotate <90.0, 0.0, 172.0>
  translate  <-0.348111, -2.192266, -0.0>
}
#declare Face = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.605608, -0.304630, -0.733588>, <1.615222, -0.217487, -0.728225>, <1.640848, -0.104094, -0.707597>, <1.647358, -0.017007, -0.698185>, 
      <1.640053, -0.313510, -0.762778>, <1.649667, -0.226367, -0.757415>, <1.660598, -0.107220, -0.714189>, <1.667108, -0.020133, -0.704777>, 
      <1.677697, -0.314802, -0.812904>, <1.677404, -0.207391, -0.789962>, <1.686553, -0.089971, -0.734763>, <1.683907, 0.016103, -0.706390>, 
      <1.712541, -0.316416, -0.842915>, <1.712247, -0.209004, -0.819972>, <1.705871, -0.081952, -0.737167>, <1.703225, 0.024122, -0.708795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.642422, 0.187894, -0.680357>, <1.660194, 0.185224, -0.687157>, <1.681454, 0.186969, -0.703367>, <1.699996, 0.186530, -0.708388>, 
      <1.644616, 0.132574, -0.707638>, <1.662388, 0.129903, -0.714438>, <1.680931, 0.143835, -0.726038>, <1.699473, 0.143396, -0.731060>, 
      <1.651932, 0.044187, -0.691571>, <1.671682, 0.041061, -0.698164>, <1.682733, 0.063166, -0.693802>, <1.702051, 0.071186, -0.696207>, 
      <1.647358, -0.017007, -0.698185>, <1.667108, -0.020133, -0.704777>, <1.683907, 0.016103, -0.706390>, <1.703225, 0.024122, -0.708795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.621771, 0.628153, -0.380024>, <1.647419, 0.635578, -0.382991>, <1.683824, 0.635759, -0.385871>, <1.710657, 0.636643, -0.386850>, 
      <1.627966, 0.496075, -0.470124>, <1.653614, 0.503500, -0.473091>, <1.680626, 0.500725, -0.482332>, <1.707459, 0.501609, -0.483311>, 
      <1.636734, 0.331305, -0.609634>, <1.654506, 0.328635, -0.616434>, <1.683236, 0.333882, -0.626148>, <1.701779, 0.333443, -0.631170>, 
      <1.642422, 0.187894, -0.680357>, <1.660194, 0.185224, -0.687157>, <1.681454, 0.186969, -0.703367>, <1.699996, 0.186530, -0.708388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.326021, 0.178764, -0.495807>, <1.282239, 0.154980, -0.438431>, <1.245221, 0.117789, -0.350230>, <1.210593, 0.091656, -0.287839>, 
      <1.325144, 0.141732, -0.521379>, <1.281362, 0.117948, -0.464003>, <1.244011, 0.068454, -0.366692>, <1.209383, 0.042321, -0.304301>, 
      <1.322569, 0.082477, -0.545181>, <1.274509, 0.054682, -0.488740>, <1.240982, 0.010148, -0.408075>, <1.206722, -0.023532, -0.345148>, 
      <1.322675, 0.037476, -0.546194>, <1.274615, 0.009682, -0.489754>, <1.242735, -0.041111, -0.399366>, <1.208475, -0.074791, -0.336440>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.326021, 0.178764, -0.495807>, <1.282239, 0.154980, -0.438431>, <1.245221, 0.117789, -0.350230>, <1.210593, 0.091656, -0.287839>, 
      <1.327845, 0.255755, -0.442642>, <1.284062, 0.231972, -0.385265>, <1.246469, 0.168640, -0.333261>, <1.211840, 0.142508, -0.270871>, 
      <1.329877, 0.341578, -0.350354>, <1.292495, 0.298659, -0.330455>, <1.249300, 0.254468, -0.262793>, <1.214839, 0.208735, -0.243916>, 
      <1.331530, 0.411356, -0.288017>, <1.294148, 0.368437, -0.268118>, <1.251120, 0.304645, -0.243969>, <1.216659, 0.258912, -0.225091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.327172, -0.309177, -0.506794>, <1.325823, -0.205181, -0.518614>, <1.322922, -0.067171, -0.548550>, <1.322675, 0.037476, -0.546194>, 
      <1.281710, -0.322439, -0.427803>, <1.280361, -0.218443, -0.439623>, <1.274862, -0.094966, -0.492110>, <1.274615, 0.009682, -0.489754>, 
      <1.227124, -0.229724, -0.225547>, <1.225689, -0.161356, -0.271297>, <1.245508, -0.122179, -0.385594>, <1.242735, -0.041111, -0.399366>, 
      <1.224722, -0.321453, -0.217658>, <1.223287, -0.253085, -0.263408>, <1.211248, -0.155859, -0.322668>, <1.208475, -0.074791, -0.336440>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.327172, -0.309177, -0.506794>, <1.348300, -0.219653, -0.539119>, <1.392669, -0.113592, -0.602767>, <1.420739, -0.029770, -0.643898>, 
      <1.327172, -0.309177, -0.506794>, <1.346951, -0.115657, -0.550939>, <1.356799, -0.101698, -0.576244>, <1.384869, -0.017875, -0.617375>, 
      <1.327172, -0.309177, -0.506794>, <1.346951, -0.115657, -0.550939>, <1.352341, -0.087345, -0.577862>, <1.352094, 0.017302, -0.575505>, 
      <1.327172, -0.309177, -0.506794>, <1.325823, -0.205181, -0.518614>, <1.322922, -0.067171, -0.548550>, <1.322675, 0.037476, -0.546194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.446689, 0.219910, -0.597241>, <1.407228, 0.213797, -0.569059>, <1.354181, 0.194061, -0.532710>, <1.326021, 0.178764, -0.495807>, 
      <1.449156, 0.324089, -0.539628>, <1.409695, 0.317976, -0.511445>, <1.356004, 0.271053, -0.479545>, <1.327845, 0.255755, -0.442642>, 
      <1.451854, 0.438014, -0.425197>, <1.411300, 0.404278, -0.410040>, <1.363906, 0.380648, -0.368468>, <1.329877, 0.341578, -0.350354>, 
      <1.454068, 0.531487, -0.351464>, <1.413514, 0.497751, -0.336307>, <1.365559, 0.450426, -0.306131>, <1.331530, 0.411356, -0.288017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.442920, 0.060795, -0.611766>, <1.405804, 0.058235, -0.592976>, <1.347977, 0.052109, -0.575908>, <1.322675, 0.037476, -0.546194>, 
      <1.444051, 0.108530, -0.607409>, <1.406935, 0.105969, -0.588619>, <1.347871, 0.097110, -0.574894>, <1.322569, 0.082477, -0.545181>, 
      <1.445696, 0.177961, -0.620439>, <1.406234, 0.171848, -0.592257>, <1.353304, 0.157029, -0.558283>, <1.325144, 0.141732, -0.521379>, 
      <1.446689, 0.219910, -0.597241>, <1.407228, 0.213797, -0.569059>, <1.354181, 0.194061, -0.532710>, <1.326021, 0.178764, -0.495807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.535603, 0.211233, -0.645485>, <1.507879, 0.215768, -0.633712>, <1.471281, 0.223720, -0.614804>, <1.446689, 0.219910, -0.597241>, 
      <1.539208, 0.335570, -0.579940>, <1.511484, 0.340105, -0.568168>, <1.473749, 0.327899, -0.557191>, <1.449156, 0.324089, -0.539628>, 
      <1.541859, 0.475357, -0.450987>, <1.514042, 0.459323, -0.446250>, <1.475834, 0.457962, -0.434160>, <1.451854, 0.438014, -0.425197>, 
      <1.544540, 0.588553, -0.367631>, <1.516723, 0.572519, -0.362894>, <1.478048, 0.551435, -0.360427>, <1.454068, 0.531487, -0.351464>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.535603, 0.211233, -0.645485>, <1.539208, 0.335570, -0.579940>, <1.541859, 0.475357, -0.450987>, <1.544540, 0.588553, -0.367631>, 
      <1.566941, 0.206107, -0.658792>, <1.570545, 0.330444, -0.593247>, <1.564402, 0.488351, -0.454826>, <1.567083, 0.601547, -0.371470>, 
      <1.610578, 0.192679, -0.668172>, <1.604891, 0.336090, -0.597449>, <1.602857, 0.488806, -0.467219>, <1.596661, 0.620884, -0.377119>, 
      <1.642422, 0.187894, -0.680357>, <1.636734, 0.331305, -0.609634>, <1.627966, 0.496075, -0.470124>, <1.621771, 0.628153, -0.380024>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.528976, 0.051705, -0.650633>, <1.504239, 0.061119, -0.640176>, <1.468263, 0.062543, -0.624596>, <1.442920, 0.060795, -0.611766>, 
      <1.530964, 0.099563, -0.649089>, <1.506227, 0.108978, -0.638632>, <1.469393, 0.110277, -0.620238>, <1.444051, 0.108530, -0.607409>, 
      <1.534374, 0.168852, -0.667826>, <1.506651, 0.173387, -0.656054>, <1.470288, 0.181771, -0.638003>, <1.445696, 0.177961, -0.620439>, 
      <1.535603, 0.211233, -0.645485>, <1.507879, 0.215768, -0.633712>, <1.471281, 0.223720, -0.614804>, <1.446689, 0.219910, -0.597241>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.528976, 0.051705, -0.650633>, <1.530964, 0.099563, -0.649089>, <1.534374, 0.168852, -0.667826>, <1.535603, 0.211233, -0.645485>, 
      <1.566762, 0.037325, -0.666606>, <1.568750, 0.085183, -0.665061>, <1.565712, 0.163726, -0.681133>, <1.566941, 0.206107, -0.658792>, 
      <1.606581, -0.010552, -0.684574>, <1.611155, 0.050642, -0.677960>, <1.612772, 0.137359, -0.695453>, <1.610578, 0.192679, -0.668172>, 
      <1.647358, -0.017007, -0.698185>, <1.651932, 0.044187, -0.691571>, <1.644616, 0.132574, -0.707638>, <1.642422, 0.187894, -0.680357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.462747, -0.252019, -0.631233>, <1.473665, -0.181618, -0.638236>, <1.499169, -0.093963, -0.671135>, <1.514779, -0.026225, -0.688236>, 
      <1.417928, -0.252751, -0.594727>, <1.428846, -0.182350, -0.601730>, <1.468865, -0.095670, -0.663876>, <1.484474, -0.027932, -0.680976>, 
      <1.355708, -0.300853, -0.556376>, <1.376836, -0.211329, -0.588701>, <1.416916, -0.121632, -0.620695>, <1.444986, -0.037810, -0.661826>, 
      <1.327172, -0.309177, -0.506794>, <1.348300, -0.219653, -0.539119>, <1.392669, -0.113592, -0.602767>, <1.420739, -0.029770, -0.643898>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.462747, -0.252019, -0.631233>, <1.505415, -0.251322, -0.665987>, <1.564411, -0.294009, -0.698676>, <1.605608, -0.304630, -0.733588>, 
      <1.473665, -0.181618, -0.638236>, <1.516333, -0.180921, -0.672991>, <1.574024, -0.206866, -0.693314>, <1.615222, -0.217487, -0.728225>, 
      <1.499169, -0.093963, -0.671135>, <1.537992, -0.091777, -0.680435>, <1.601075, -0.106859, -0.704612>, <1.640848, -0.104094, -0.707597>, 
      <1.514779, -0.026225, -0.688236>, <1.553602, -0.024039, -0.697536>, <1.607584, -0.019772, -0.695200>, <1.647358, -0.017007, -0.698185>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.805871, -0.313901, -0.906069>, <1.803858, -0.194709, -0.884454>, <1.791180, -0.071702, -0.757752>, <1.789422, 0.041967, -0.715869>, 
      <1.833080, -0.315825, -0.884939>, <1.831067, -0.196633, -0.863324>, <1.819324, -0.072238, -0.757752>, <1.817567, 0.041432, -0.715869>, 
      <1.871020, -0.320644, -0.858824>, <1.868114, -0.213406, -0.838047>, <1.856786, -0.073992, -0.738679>, <1.854903, 0.031930, -0.711901>, 
      <1.896568, -0.320313, -0.835635>, <1.893662, -0.213075, -0.814859>, <1.882432, -0.085174, -0.735572>, <1.880549, 0.020748, -0.708795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.805871, -0.313901, -0.906069>, <1.803858, -0.194709, -0.884454>, <1.791180, -0.071702, -0.757752>, <1.789422, 0.041967, -0.715869>, 
      <1.777872, -0.314655, -0.887123>, <1.775859, -0.195464, -0.865507>, <1.764692, -0.071198, -0.757752>, <1.762934, 0.042471, -0.715869>, 
      <1.738147, -0.317601, -0.864969>, <1.737854, -0.210190, -0.842026>, <1.730179, -0.071861, -0.740193>, <1.727533, 0.034213, -0.711821>, 
      <1.712541, -0.316416, -0.842915>, <1.712247, -0.209004, -0.819972>, <1.705871, -0.081952, -0.737167>, <1.703225, 0.024122, -0.708795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.798169, 0.184205, -0.722535>, <1.795545, 0.141534, -0.720535>, <1.788801, 0.082122, -0.701073>, <1.789422, 0.041967, -0.715869>, 
      <1.768410, 0.184760, -0.722535>, <1.765786, 0.142088, -0.720535>, <1.762313, 0.082626, -0.701073>, <1.762934, 0.042471, -0.715869>, 
      <1.728718, 0.185850, -0.716166>, <1.728195, 0.142716, -0.738838>, <1.726359, 0.081276, -0.699232>, <1.727533, 0.034213, -0.711821>, 
      <1.699996, 0.186530, -0.708388>, <1.699473, 0.143396, -0.731060>, <1.702051, 0.071186, -0.696207>, <1.703225, 0.024122, -0.708795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.798169, 0.184205, -0.722535>, <1.825336, 0.183699, -0.722535>, <1.861504, 0.183241, -0.715880>, <1.887622, 0.183033, -0.708388>, 
      <1.795545, 0.141534, -0.720535>, <1.822712, 0.141027, -0.720535>, <1.861006, 0.140107, -0.738551>, <1.887124, 0.139899, -0.731059>, 
      <1.788801, 0.082122, -0.701073>, <1.816946, 0.081587, -0.701073>, <1.854064, 0.079169, -0.699959>, <1.879709, 0.067987, -0.696853>, 
      <1.789422, 0.041967, -0.715869>, <1.817567, 0.041432, -0.715869>, <1.854903, 0.031930, -0.711901>, <1.880549, 0.020748, -0.708795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.808830, 0.634318, -0.386850>, <1.805632, 0.499284, -0.487555>, <1.801367, 0.319239, -0.621830>, <1.798169, 0.184205, -0.722535>, 
      <1.779378, 0.635015, -0.386850>, <1.776180, 0.499982, -0.487555>, <1.771608, 0.319794, -0.621830>, <1.768410, 0.184760, -0.722535>, 
      <1.740082, 0.637613, -0.387924>, <1.736883, 0.502579, -0.484385>, <1.730500, 0.332762, -0.638948>, <1.728718, 0.185850, -0.716166>, 
      <1.710657, 0.636643, -0.386850>, <1.707459, 0.501609, -0.483311>, <1.701779, 0.333443, -0.631170>, <1.699996, 0.186530, -0.708388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.808830, 0.634318, -0.386850>, <1.832468, 0.634004, -0.386850>, <1.864059, 0.634911, -0.387811>, <1.887622, 0.633273, -0.386850>, 
      <1.805632, 0.499284, -0.487555>, <1.829269, 0.498971, -0.487555>, <1.864059, 0.499839, -0.484272>, <1.887622, 0.498201, -0.483311>, 
      <1.801367, 0.319239, -0.621830>, <1.828534, 0.318733, -0.621830>, <1.863201, 0.330155, -0.638661>, <1.889318, 0.329947, -0.631170>, 
      <1.798169, 0.184205, -0.722535>, <1.825336, 0.183699, -0.722535>, <1.861504, 0.183241, -0.715880>, <1.887622, 0.183033, -0.708388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.003928, -0.311333, -0.726309>, <1.989118, -0.222961, -0.722472>, <1.945959, -0.110377, -0.706428>, <1.935426, -0.021693, -0.698185>, 
      <1.969229, -0.319311, -0.755509>, <1.954418, -0.230938, -0.751672>, <1.926141, -0.113035, -0.713020>, <1.915608, -0.024351, -0.704777>, 
      <1.930663, -0.319871, -0.804690>, <1.927758, -0.212633, -0.783914>, <1.901613, -0.093537, -0.733249>, <1.899731, 0.012385, -0.706472>, 
      <1.896568, -0.320313, -0.835635>, <1.893662, -0.213075, -0.814859>, <1.882432, -0.085174, -0.735572>, <1.880549, 0.020748, -0.708795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.945212, 0.183033, -0.680357>, <1.941709, 0.127780, -0.707638>, <1.928177, 0.039337, -0.692512>, <1.935426, -0.021693, -0.698185>, 
      <1.927382, 0.180784, -0.687157>, <1.923879, 0.125531, -0.714438>, <1.908359, 0.036679, -0.699104>, <1.915608, -0.024351, -0.704777>, 
      <1.906091, 0.182886, -0.703090>, <1.905593, 0.139752, -0.725762>, <1.898891, 0.059623, -0.694530>, <1.899731, 0.012385, -0.706472>, 
      <1.887622, 0.183033, -0.708388>, <1.887124, 0.139899, -0.731059>, <1.879709, 0.067987, -0.696853>, <1.880549, 0.020748, -0.708795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.976282, 0.622680, -0.380024>, <1.966961, 0.490786, -0.470124>, <1.954294, 0.326269, -0.609634>, <1.945212, 0.183033, -0.680357>, 
      <1.950817, 0.630710, -0.382991>, <1.941496, 0.498816, -0.473091>, <1.936464, 0.324020, -0.616434>, <1.927382, 0.180784, -0.687157>, 
      <1.914401, 0.631412, -0.385758>, <1.914401, 0.496340, -0.482220>, <1.907788, 0.329800, -0.625872>, <1.906091, 0.182886, -0.703090>, 
      <1.887622, 0.633273, -0.386850>, <1.887622, 0.498201, -0.483311>, <1.889318, 0.329947, -0.631170>, <1.887622, 0.183033, -0.708388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.261308, 0.166414, -0.495807>, <2.261308, 0.129371, -0.521379>, <2.259393, 0.070057, -0.545853>, <2.261308, 0.025087, -0.546194>, 
      <2.304090, 0.141624, -0.438476>, <2.304090, 0.104582, -0.464048>, <2.306724, 0.041134, -0.489414>, <2.308638, -0.003837, -0.489755>, 
      <2.339169, 0.103560, -0.350230>, <2.339169, 0.054207, -0.366693>, <2.337726, -0.004246, -0.408914>, <2.339169, -0.055369, -0.399366>, 
      <2.372538, 0.076622, -0.287839>, <2.372538, 0.027269, -0.304302>, <2.371095, -0.038727, -0.345988>, <2.372538, -0.089850, -0.336440>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.261308, 0.166414, -0.495807>, <2.261308, 0.243427, -0.442642>, <2.261308, 0.329274, -0.350354>, <2.261308, 0.399071, -0.288017>, 
      <2.304090, 0.141624, -0.438476>, <2.304090, 0.218638, -0.385311>, <2.297664, 0.285482, -0.330455>, <2.297664, 0.355279, -0.268118>, 
      <2.339169, 0.103560, -0.350230>, <2.339169, 0.154417, -0.333265>, <2.339169, 0.240288, -0.262793>, <2.339169, 0.290487, -0.243969>, 
      <2.372538, 0.076622, -0.287839>, <2.372538, 0.127480, -0.270874>, <2.372538, 0.193752, -0.243916>, <2.372538, 0.243951, -0.225091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.282150, -0.323167, -0.499515>, <2.327249, -0.337614, -0.420524>, <2.384243, -0.246360, -0.218268>, <2.384243, -0.338120, -0.210379>, 
      <2.277602, -0.218431, -0.512172>, <2.322701, -0.232878, -0.433181>, <2.380076, -0.177569, -0.265601>, <2.380076, -0.269329, -0.257712>, 
      <2.265799, -0.080410, -0.546993>, <2.313129, -0.109334, -0.490554>, <2.341488, -0.137522, -0.384023>, <2.374857, -0.172003, -0.321097>, 
      <2.261308, 0.025087, -0.546194>, <2.308638, -0.003837, -0.489755>, <2.339169, -0.055369, -0.399366>, <2.372538, -0.089850, -0.336440>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.141649, 0.210406, -0.597241>, <2.141649, 0.314614, -0.539628>, <2.141649, 0.428571, -0.425197>, <2.141649, 0.522070, -0.351464>, 
      <2.180954, 0.203360, -0.569059>, <2.180954, 0.307568, -0.511445>, <2.181393, 0.393884, -0.410040>, <2.181393, 0.487383, -0.336307>, 
      <2.233688, 0.182418, -0.532819>, <2.233688, 0.259431, -0.479653>, <2.228213, 0.369138, -0.368468>, <2.228213, 0.438935, -0.306131>, 
      <2.261308, 0.166414, -0.495807>, <2.261308, 0.243427, -0.442642>, <2.261308, 0.329274, -0.350354>, <2.261308, 0.399071, -0.288017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.141649, 0.051247, -0.611766>, <2.141649, 0.098995, -0.607409>, <2.141649, 0.168446, -0.620439>, <2.141649, 0.210406, -0.597241>, 
      <2.178694, 0.047809, -0.592976>, <2.178694, 0.095557, -0.588619>, <2.180954, 0.161400, -0.592257>, <2.180954, 0.203360, -0.569059>, 
      <2.236379, 0.040321, -0.575921>, <2.234465, 0.085291, -0.575580>, <2.233688, 0.145375, -0.558391>, <2.233688, 0.182418, -0.532819>, 
      <2.261308, 0.025087, -0.546194>, <2.259393, 0.070057, -0.545853>, <2.261308, 0.129371, -0.521379>, <2.261308, 0.166414, -0.495807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.148118, -0.262479, -0.623954>, <2.132206, -0.189530, -0.632599>, <2.091860, -0.102577, -0.668951>, <2.067750, -0.034047, -0.688236>, 
      <2.105483, -0.260666, -0.658708>, <2.089571, -0.187716, -0.667353>, <2.053100, -0.099472, -0.678252>, <2.028990, -0.030942, -0.697536>, 
      <2.045401, -0.301798, -0.691410>, <2.030591, -0.213426, -0.687572>, <1.985656, -0.114083, -0.703444>, <1.975123, -0.025399, -0.695200>, 
      <2.003928, -0.311333, -0.726309>, <1.989118, -0.222961, -0.722472>, <1.945959, -0.110377, -0.706428>, <1.935426, -0.021693, -0.698185>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.148118, -0.262479, -0.623954>, <2.192902, -0.264384, -0.587448>, <2.253842, -0.314099, -0.549097>, <2.282150, -0.323167, -0.499515>, 
      <2.152187, -0.195681, -0.629937>, <2.196971, -0.197586, -0.593431>, <2.249294, -0.209363, -0.561754>, <2.277602, -0.218431, -0.512172>, 
      <2.157611, -0.106616, -0.637915>, <2.193753, -0.095575, -0.611392>, <2.235911, -0.099882, -0.576304>, <2.265799, -0.080410, -0.546993>, 
      <2.161680, -0.039818, -0.643898>, <2.197822, -0.028776, -0.617375>, <2.231420, 0.005615, -0.575505>, <2.261308, 0.025087, -0.546194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.148118, -0.262479, -0.623954>, <2.152187, -0.195681, -0.629937>, <2.157611, -0.106616, -0.637915>, <2.161680, -0.039818, -0.643898>, 
      <2.148118, -0.262479, -0.623954>, <2.136275, -0.122731, -0.638582>, <2.133181, -0.114080, -0.655843>, <2.137249, -0.047282, -0.661826>, 
      <2.148118, -0.262479, -0.623954>, <2.136275, -0.122731, -0.638582>, <2.122116, -0.105000, -0.661692>, <2.098006, -0.036471, -0.680976>, 
      <2.148118, -0.262479, -0.623954>, <2.132206, -0.189530, -0.632599>, <2.091860, -0.102577, -0.668951>, <2.067750, -0.034047, -0.688236>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.052554, 0.203837, -0.645485>, <2.051894, 0.328224, -0.579940>, <2.052554, 0.468035, -0.450987>, <2.052554, 0.581262, -0.367631>, 
      <2.080377, 0.207714, -0.633712>, <2.079718, 0.332101, -0.568168>, <2.079983, 0.451347, -0.446250>, <2.079983, 0.564574, -0.362894>, 
      <2.117154, 0.214797, -0.614804>, <2.117154, 0.319006, -0.557191>, <2.118149, 0.449081, -0.434160>, <2.118149, 0.542580, -0.360427>, 
      <2.141649, 0.210406, -0.597241>, <2.141649, 0.314614, -0.539628>, <2.141649, 0.428571, -0.425197>, <2.141649, 0.522070, -0.351464>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.052554, 0.203837, -0.645485>, <2.021104, 0.199455, -0.658792>, <1.977160, 0.187063, -0.668172>, <1.945212, 0.183033, -0.680357>, 
      <2.051894, 0.328224, -0.579940>, <2.020444, 0.323842, -0.593247>, <1.986242, 0.330299, -0.597449>, <1.954294, 0.326269, -0.609634>, 
      <2.052554, 0.468035, -0.450987>, <2.030325, 0.481559, -0.454826>, <1.991892, 0.482924, -0.467219>, <1.966961, 0.490786, -0.470124>, 
      <2.052554, 0.581262, -0.367631>, <2.030325, 0.594786, -0.371470>, <2.001213, 0.614818, -0.377119>, <1.976282, 0.622680, -0.380024>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.055402, 0.044197, -0.650633>, <2.017286, 0.030716, -0.666606>, <1.976345, -0.016206, -0.684574>, <1.935426, -0.021693, -0.698185>, 
      <2.054548, 0.092089, -0.649089>, <2.016431, 0.078607, -0.665061>, <1.969096, 0.044824, -0.678901>, <1.928177, 0.039337, -0.692512>, 
      <2.052779, 0.161439, -0.667826>, <2.021328, 0.157057, -0.681133>, <1.973657, 0.131810, -0.695453>, <1.941709, 0.127780, -0.707638>, 
      <2.052554, 0.203837, -0.645485>, <2.021104, 0.199455, -0.658792>, <1.977160, 0.187063, -0.668172>, <1.945212, 0.183033, -0.680357>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.055402, 0.044197, -0.650633>, <2.054548, 0.092089, -0.649089>, <2.052779, 0.161439, -0.667826>, <2.052554, 0.203837, -0.645485>, 
      <2.080355, 0.053023, -0.640176>, <2.079501, 0.100915, -0.638632>, <2.080602, 0.165316, -0.656054>, <2.080377, 0.207714, -0.633712>, 
      <2.116355, 0.053595, -0.624596>, <2.116355, 0.101342, -0.620238>, <2.117154, 0.172837, -0.638003>, <2.117154, 0.214797, -0.614804>, 
      <2.141649, 0.051247, -0.611766>, <2.141649, 0.098995, -0.607409>, <2.141649, 0.168446, -0.620439>, <2.141649, 0.210406, -0.597241>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.009995, -0.533971, -0.732547>, <2.010224, -0.546098, -0.733945>, <2.009135, -0.563694, -0.737592>, <2.006654, -0.574533, -0.732547>, 
      <2.009995, -0.533971, -0.732547>, <2.052292, -0.576139, -0.700535>, <2.049805, -0.577462, -0.700653>, <2.047324, -0.588301, -0.695609>, 
      <2.009995, -0.533971, -0.732547>, <2.052292, -0.576139, -0.700535>, <2.057867, -0.590126, -0.683441>, <2.094522, -0.623116, -0.646612>, 
      <2.009995, -0.533971, -0.732547>, <2.052062, -0.564012, -0.699137>, <2.095525, -0.610947, -0.646612>, <2.132180, -0.643937, -0.609782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.906769, -0.482968, -0.788805>, <1.910081, -0.509746, -0.791674>, <1.917463, -0.544936, -0.810656>, <1.917793, -0.571360, -0.804498>, 
      <1.943177, -0.492928, -0.781508>, <1.946489, -0.519706, -0.784376>, <1.950414, -0.546016, -0.801137>, <1.950743, -0.572440, -0.794979>, 
      <1.983719, -0.515207, -0.753415>, <1.983949, -0.527335, -0.754814>, <1.984495, -0.555353, -0.759970>, <1.982014, -0.566192, -0.754926>, 
      <2.009995, -0.533971, -0.732547>, <2.010224, -0.546098, -0.733945>, <2.009135, -0.563694, -0.737592>, <2.006654, -0.574533, -0.732547>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.809278, -0.479063, -0.772778>, <1.811558, -0.506138, -0.772486>, <1.811656, -0.541069, -0.787478>, <1.813064, -0.568186, -0.788471>, 
      <1.838909, -0.480351, -0.772276>, <1.841189, -0.507426, -0.771984>, <1.843436, -0.542047, -0.786961>, <1.844844, -0.569164, -0.787954>, 
      <1.878677, -0.475283, -0.794436>, <1.881989, -0.502062, -0.797304>, <1.886929, -0.543934, -0.819477>, <1.887259, -0.570359, -0.813319>, 
      <1.906769, -0.482968, -0.788805>, <1.910081, -0.509746, -0.791674>, <1.917463, -0.544936, -0.810656>, <1.917793, -0.571360, -0.804498>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.708920, -0.474367, -0.792159>, <1.709840, -0.501849, -0.794639>, <1.710464, -0.539815, -0.819089>, <1.711509, -0.565012, -0.807852>, 
      <1.738544, -0.467814, -0.796822>, <1.739463, -0.495296, -0.799303>, <1.740691, -0.539815, -0.826109>, <1.741735, -0.565012, -0.814872>, 
      <1.778615, -0.477730, -0.773298>, <1.780896, -0.504805, -0.773006>, <1.780644, -0.540114, -0.787982>, <1.782052, -0.567232, -0.788975>, 
      <1.809278, -0.479063, -0.772778>, <1.811558, -0.506138, -0.772486>, <1.811656, -0.541069, -0.787478>, <1.813064, -0.568186, -0.788471>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.599960, -0.525369, -0.739826>, <1.600059, -0.538176, -0.741299>, <1.602701, -0.558168, -0.747889>, <1.603606, -0.568186, -0.739826>, 
      <1.599960, -0.525369, -0.739826>, <1.554803, -0.569915, -0.708296>, <1.557650, -0.572600, -0.712473>, <1.558555, -0.582618, -0.704410>, 
      <1.599960, -0.525369, -0.739826>, <1.554803, -0.569915, -0.708296>, <1.548595, -0.585171, -0.690720>, <1.509251, -0.620389, -0.653891>, 
      <1.599960, -0.525369, -0.739826>, <1.554704, -0.557108, -0.706823>, <1.508157, -0.607543, -0.653891>, <1.468813, -0.642761, -0.617061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.599960, -0.525369, -0.739826>, <1.600059, -0.538176, -0.741299>, <1.602701, -0.558168, -0.747889>, <1.603606, -0.568186, -0.739826>, 
      <1.627628, -0.505965, -0.760003>, <1.627726, -0.518772, -0.761475>, <1.631883, -0.548820, -0.770830>, <1.632788, -0.558837, -0.762767>, 
      <1.670937, -0.482770, -0.786180>, <1.671857, -0.510252, -0.788660>, <1.673178, -0.539815, -0.810429>, <1.674223, -0.565012, -0.799193>, 
      <1.708920, -0.474367, -0.792159>, <1.709840, -0.501849, -0.794639>, <1.710464, -0.539815, -0.819089>, <1.711509, -0.565012, -0.807852>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.004260, -0.618697, -0.719191>, <2.046074, -0.623620, -0.690300>, <2.093804, -0.636365, -0.642605>, <2.132180, -0.643937, -0.609782>, 
      <2.004260, -0.618697, -0.719191>, <2.065418, -0.637581, -0.699473>, <2.067138, -0.642056, -0.656984>, <2.105514, -0.649628, -0.624161>, 
      <2.004260, -0.618697, -0.719191>, <2.065418, -0.637581, -0.699473>, <2.068983, -0.629355, -0.640375>, <2.068946, -0.654811, -0.642658>, 
      <2.004260, -0.618697, -0.719191>, <2.023603, -0.632658, -0.728365>, <2.043331, -0.637452, -0.655430>, <2.043294, -0.662908, -0.657712>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.915371, -0.618409, -0.759583>, <1.942329, -0.619254, -0.748159>, <1.980274, -0.615873, -0.735764>, <2.004260, -0.618697, -0.719191>, 
      <1.923824, -0.645841, -0.759767>, <1.950782, -0.646686, -0.748343>, <1.999617, -0.629833, -0.744937>, <2.023603, -0.632658, -0.728365>, 
      <1.930252, -0.679981, -0.725446>, <1.967742, -0.672624, -0.705903>, <2.007621, -0.648725, -0.676387>, <2.043331, -0.637452, -0.655430>, 
      <1.928202, -0.708326, -0.729490>, <1.965692, -0.700969, -0.709948>, <2.007584, -0.674181, -0.678669>, <2.043294, -0.662908, -0.657712>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.812146, -0.612674, -0.800603>, <1.845500, -0.613614, -0.800696>, <1.884661, -0.617446, -0.772597>, <1.915371, -0.618409, -0.759583>, 
      <1.813441, -0.639817, -0.811987>, <1.846795, -0.640756, -0.812079>, <1.893114, -0.644878, -0.772780>, <1.923824, -0.645841, -0.759767>, 
      <1.812117, -0.678990, -0.775646>, <1.849783, -0.682798, -0.775743>, <1.897179, -0.686472, -0.742686>, <1.930252, -0.679981, -0.725446>, 
      <1.811854, -0.708326, -0.778356>, <1.849520, -0.712133, -0.778453>, <1.895128, -0.714816, -0.746730>, <1.928202, -0.708326, -0.729490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.711788, -0.612674, -0.759016>, <1.741512, -0.612812, -0.772379>, <1.779569, -0.611756, -0.800512>, <1.812146, -0.612674, -0.800603>, 
      <1.711984, -0.636511, -0.759233>, <1.741708, -0.636649, -0.772596>, <1.780864, -0.638899, -0.811896>, <1.813441, -0.639817, -0.811987>, 
      <1.712283, -0.663120, -0.723808>, <1.741999, -0.666834, -0.741703>, <1.777407, -0.675482, -0.775556>, <1.812117, -0.678990, -0.775646>, 
      <1.708953, -0.686164, -0.728923>, <1.738669, -0.689878, -0.746819>, <1.777144, -0.704817, -0.778266>, <1.811854, -0.708326, -0.778356>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.602536, -0.611702, -0.706372>, <1.633773, -0.607834, -0.724622>, <1.678604, -0.612520, -0.744098>, <1.711788, -0.612674, -0.759016>, 
      <1.597165, -0.639132, -0.706600>, <1.628401, -0.635264, -0.724849>, <1.678800, -0.636357, -0.744315>, <1.711984, -0.636511, -0.759233>, 
      <1.591568, -0.653133, -0.640017>, <1.630628, -0.660193, -0.658212>, <1.675090, -0.658470, -0.701409>, <1.712283, -0.663120, -0.723808>, 
      <1.590239, -0.680624, -0.644893>, <1.629299, -0.687684, -0.663088>, <1.671760, -0.681515, -0.706524>, <1.708953, -0.686164, -0.728923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.602536, -0.611702, -0.706372>, <1.560353, -0.616925, -0.681727>, <1.508930, -0.633443, -0.643854>, <1.468813, -0.642761, -0.617061>, 
      <1.602536, -0.611702, -0.706372>, <1.554982, -0.644355, -0.681955>, <1.545358, -0.644802, -0.652204>, <1.505241, -0.654120, -0.625411>, 
      <1.602536, -0.611702, -0.706372>, <1.554982, -0.644355, -0.681955>, <1.556626, -0.646818, -0.623740>, <1.555297, -0.674309, -0.628617>, 
      <1.602536, -0.611702, -0.706372>, <1.597165, -0.639132, -0.706600>, <1.591568, -0.653133, -0.640017>, <1.590239, -0.680624, -0.644893>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.908260, -0.602518, -0.760945>, <1.911120, -0.593171, -0.774011>, <1.917991, -0.587251, -0.800795>, <1.917793, -0.571360, -0.804498>, 
      <1.880283, -0.598572, -0.765707>, <1.883143, -0.589224, -0.778773>, <1.887457, -0.586250, -0.809616>, <1.887259, -0.570359, -0.813319>, 
      <1.843439, -0.590233, -0.780227>, <1.842857, -0.583880, -0.783723>, <1.845220, -0.576424, -0.788220>, <1.844844, -0.569164, -0.787954>, 
      <1.815003, -0.589364, -0.776819>, <1.814421, -0.583011, -0.780315>, <1.813441, -0.575446, -0.788737>, <1.813064, -0.568186, -0.788471>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.994364, -0.602259, -0.700764>, <1.998051, -0.593941, -0.710299>, <2.003976, -0.586232, -0.727102>, <2.006654, -0.574533, -0.732547>, 
      <1.968545, -0.597483, -0.718194>, <1.972232, -0.589166, -0.727729>, <1.979337, -0.577891, -0.749481>, <1.982014, -0.566192, -0.754926>, 
      <1.934091, -0.602440, -0.742891>, <1.936951, -0.593093, -0.755957>, <1.950942, -0.588331, -0.791276>, <1.950743, -0.572440, -0.794979>, 
      <1.908260, -0.602518, -0.760945>, <1.911120, -0.593171, -0.774011>, <1.917991, -0.587251, -0.800795>, <1.917793, -0.571360, -0.804498>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.994364, -0.602259, -0.700764>, <1.998051, -0.593941, -0.710299>, <2.003976, -0.586232, -0.727102>, <2.006654, -0.574533, -0.732547>, 
      <2.036224, -0.610002, -0.672506>, <2.039911, -0.601684, -0.682041>, <2.006457, -0.575394, -0.732147>, <2.009135, -0.563694, -0.737592>, 
      <2.090835, -0.631434, -0.637077>, <2.054180, -0.598444, -0.673906>, <2.052292, -0.576139, -0.700535>, <2.010224, -0.546098, -0.733945>, 
      <2.132180, -0.643937, -0.609782>, <2.095525, -0.610947, -0.646612>, <2.052062, -0.564012, -0.699137>, <2.009995, -0.533971, -0.732547>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.994364, -0.602259, -0.700764>, <2.036224, -0.610002, -0.672506>, <2.090835, -0.631434, -0.637077>, <2.132180, -0.643937, -0.609782>, 
      <1.994364, -0.602259, -0.700764>, <2.039911, -0.601684, -0.682041>, <2.053177, -0.610612, -0.673906>, <2.094522, -0.623116, -0.646612>, 
      <1.994364, -0.602259, -0.700764>, <2.039911, -0.601684, -0.682041>, <2.044646, -0.600000, -0.690164>, <2.047324, -0.588301, -0.695609>, 
      <1.994364, -0.602259, -0.700764>, <1.998051, -0.593941, -0.710299>, <2.003976, -0.586232, -0.727102>, <2.006654, -0.574533, -0.732547>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.713987, -0.596579, -0.737659>, <1.743586, -0.595359, -0.751206>, <1.782675, -0.588376, -0.772944>, <1.815003, -0.589364, -0.776819>, 
      <1.713244, -0.587109, -0.758717>, <1.742842, -0.585889, -0.772263>, <1.782093, -0.582022, -0.776440>, <1.814421, -0.583011, -0.780315>, 
      <1.712383, -0.586095, -0.798450>, <1.742610, -0.586095, -0.805470>, <1.782429, -0.574492, -0.789241>, <1.813441, -0.575446, -0.788737>, 
      <1.711509, -0.565012, -0.807852>, <1.741735, -0.565012, -0.814872>, <1.782052, -0.567232, -0.788975>, <1.813064, -0.568186, -0.788471>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.606519, -0.597956, -0.681401>, <1.605645, -0.589025, -0.698929>, <1.604989, -0.583488, -0.727510>, <1.603606, -0.568186, -0.739826>, 
      <1.564458, -0.605879, -0.660712>, <1.563584, -0.596948, -0.678239>, <1.604083, -0.573470, -0.735573>, <1.602701, -0.558168, -0.747889>, 
      <1.510125, -0.629320, -0.636363>, <1.549469, -0.594102, -0.673192>, <1.554803, -0.569915, -0.708296>, <1.600059, -0.538176, -0.741299>, 
      <1.468813, -0.642761, -0.617061>, <1.508157, -0.607543, -0.653891>, <1.554704, -0.557108, -0.706823>, <1.599960, -0.525369, -0.739826>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.606519, -0.597956, -0.681401>, <1.605645, -0.589025, -0.698929>, <1.604989, -0.583488, -0.727510>, <1.603606, -0.568186, -0.739826>, 
      <1.606519, -0.597956, -0.681401>, <1.563584, -0.596948, -0.678239>, <1.559938, -0.597920, -0.692094>, <1.558555, -0.582618, -0.704410>, 
      <1.606519, -0.597956, -0.681401>, <1.563584, -0.596948, -0.678239>, <1.550563, -0.606947, -0.673192>, <1.509251, -0.620389, -0.653891>, 
      <1.606519, -0.597956, -0.681401>, <1.564458, -0.605879, -0.660712>, <1.510125, -0.629320, -0.636363>, <1.468813, -0.642761, -0.617061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.606519, -0.597956, -0.681401>, <1.638719, -0.591891, -0.697240>, <1.680918, -0.597942, -0.722524>, <1.713987, -0.596579, -0.737659>, 
      <1.605645, -0.589025, -0.698929>, <1.637845, -0.582960, -0.714767>, <1.680175, -0.588472, -0.743582>, <1.713244, -0.587109, -0.758717>, 
      <1.604989, -0.583488, -0.727510>, <1.634171, -0.574139, -0.750451>, <1.675097, -0.586095, -0.789790>, <1.712383, -0.586095, -0.798450>, 
      <1.603606, -0.568186, -0.739826>, <1.632788, -0.558837, -0.762767>, <1.674223, -0.565012, -0.799193>, <1.711509, -0.565012, -0.807852>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.896568, -0.921657, -0.352460>, <1.897699, -0.937936, -0.308155>, <1.905641, -1.021992, -0.307880>, <1.909530, -1.064993, -0.288774>, 
      <1.869647, -0.927580, -0.370726>, <1.870778, -0.943860, -0.326421>, <1.873845, -1.024925, -0.315842>, <1.877734, -1.067926, -0.296736>, 
      <1.842947, -0.930178, -0.418769>, <1.842334, -0.949740, -0.368695>, <1.838349, -1.030255, -0.346892>, <1.836438, -1.073822, -0.315449>, 
      <1.809913, -0.929545, -0.420124>, <1.809300, -0.949107, -0.370050>, <1.805454, -1.031202, -0.346756>, <1.803543, -1.074770, -0.315313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.896568, -0.921657, -0.352460>, <1.832301, -0.920426, -0.355096>, <1.746612, -0.918786, -0.358612>, <1.682345, -0.917555, -0.361248>, 
      <1.896568, -0.921657, -0.352460>, <1.805380, -0.926350, -0.373363>, <1.782721, -0.926948, -0.379082>, <1.718454, -0.925717, -0.381719>, 
      <1.896568, -0.921657, -0.352460>, <1.805380, -0.926350, -0.373363>, <1.800687, -0.929368, -0.420503>, <1.767653, -0.928736, -0.421858>, 
      <1.896568, -0.921657, -0.352460>, <1.869647, -0.927580, -0.370726>, <1.842947, -0.930178, -0.418769>, <1.809913, -0.929545, -0.420124>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.686435, -1.071420, -0.287851>, <1.685208, -1.025260, -0.309870>, <1.683572, -0.963715, -0.339229>, <1.682345, -0.917555, -0.361248>, 
      <1.721567, -1.072425, -0.296090>, <1.720340, -1.026266, -0.318109>, <1.719681, -0.971877, -0.359700>, <1.718454, -0.925717, -0.381719>, 
      <1.767459, -1.075810, -0.315164>, <1.769370, -1.032242, -0.346607>, <1.767040, -0.948298, -0.371784>, <1.767653, -0.928736, -0.421858>, 
      <1.803543, -1.074770, -0.315313>, <1.805454, -1.031202, -0.346756>, <1.809300, -0.949107, -0.370050>, <1.809913, -0.929545, -0.420124>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.323724, -0.440845, -0.495470>, <1.324268, -0.402210, -0.504410>, <1.318578, -0.345593, -0.493645>, <1.327172, -0.309177, -0.506794>, 
      <1.323724, -0.440845, -0.495470>, <1.279539, -0.388690, -0.421177>, <1.273116, -0.358855, -0.414654>, <1.281710, -0.322439, -0.427803>, 
      <1.323724, -0.440845, -0.495470>, <1.279539, -0.388690, -0.421177>, <1.224635, -0.324793, -0.217371>, <1.227124, -0.229724, -0.225547>, 
      <1.323724, -0.440845, -0.495470>, <1.278995, -0.427325, -0.412237>, <1.222233, -0.416522, -0.209482>, <1.224722, -0.321453, -0.217658>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.215157, -0.393087, -0.123446>, <1.247759, -0.439140, -0.221970>, <1.276505, -0.500015, -0.359765>, <1.323829, -0.546597, -0.451858>, 
      <1.214442, -0.401322, -0.108016>, <1.247043, -0.447375, -0.206540>, <1.275284, -0.546632, -0.329415>, <1.322608, -0.593213, -0.421509>, 
      <1.216332, -0.392381, -0.080166>, <1.246192, -0.478459, -0.160495>, <1.279089, -0.595010, -0.291760>, <1.318266, -0.664441, -0.383400>, 
      <1.217685, -0.402446, -0.065908>, <1.247544, -0.488523, -0.146237>, <1.278039, -0.619938, -0.242029>, <1.317216, -0.689369, -0.333670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.215157, -0.393087, -0.123446>, <1.216613, -0.376328, -0.154845>, <1.225343, -0.351053, -0.197851>, <1.224722, -0.321453, -0.217658>, 
      <1.247759, -0.439140, -0.221970>, <1.249215, -0.422381, -0.253369>, <1.222854, -0.446122, -0.189674>, <1.222233, -0.416522, -0.209482>, 
      <1.276505, -0.500015, -0.359765>, <1.277258, -0.471263, -0.378484>, <1.278524, -0.460756, -0.404502>, <1.278995, -0.427325, -0.412237>, 
      <1.323829, -0.546597, -0.451858>, <1.324582, -0.517844, -0.470577>, <1.323253, -0.474276, -0.487735>, <1.323724, -0.440845, -0.495470>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.234993, -0.540682, 0.085647>, <1.233074, -0.483242, 0.063042>, <1.222457, -0.437954, -0.015605>, <1.217685, -0.402446, -0.065908>, 
      <1.259365, -0.596553, 0.032316>, <1.257446, -0.539114, 0.009711>, <1.252316, -0.524031, -0.095934>, <1.247544, -0.488523, -0.146237>, 
      <1.280758, -0.677850, -0.038331>, <1.282008, -0.637812, -0.099761>, <1.276655, -0.652795, -0.176481>, <1.278039, -0.619938, -0.242029>, 
      <1.316233, -0.726920, -0.092122>, <1.317483, -0.686882, -0.153551>, <1.315832, -0.722226, -0.268122>, <1.317216, -0.689369, -0.333670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.313062, -0.853878, 0.111753>, <1.313730, -0.759919, 0.103921>, <1.237922, -0.628377, 0.120159>, <1.234993, -0.540682, 0.085647>, 
      <1.336352, -0.868754, 0.076672>, <1.337019, -0.774796, 0.068840>, <1.262294, -0.684248, 0.066829>, <1.259365, -0.596553, 0.032316>, 
      <1.366330, -0.884862, 0.027290>, <1.287836, -0.831898, 0.001208>, <1.359967, -0.710095, 0.011142>, <1.280758, -0.677850, -0.038331>, 
      <1.310531, -0.903466, -0.005184>, <1.312242, -0.850502, -0.031265>, <1.315226, -0.759165, -0.042649>, <1.316233, -0.726920, -0.092122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.458055, -0.391983, -0.651850>, <1.459234, -0.467946, -0.649095>, <1.465586, -0.567528, -0.627498>, <1.468813, -0.642761, -0.617061>, 
      <1.408889, -0.395007, -0.611683>, <1.410068, -0.470970, -0.608928>, <1.422090, -0.538678, -0.577937>, <1.425318, -0.613912, -0.567500>, 
      <1.353508, -0.449848, -0.550893>, <1.353037, -0.483279, -0.543157>, <1.354583, -0.547374, -0.528959>, <1.353830, -0.576127, -0.510239>, 
      <1.323724, -0.440845, -0.495470>, <1.323253, -0.474276, -0.487735>, <1.324582, -0.517844, -0.470577>, <1.323829, -0.546597, -0.451858>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.458055, -0.391983, -0.651850>, <1.457396, -0.349550, -0.653389>, <1.456270, -0.293782, -0.627078>, <1.462747, -0.252019, -0.631233>, 
      <1.408889, -0.395007, -0.611683>, <1.408230, -0.352574, -0.613222>, <1.411452, -0.294514, -0.590572>, <1.417928, -0.252751, -0.594727>, 
      <1.353508, -0.449848, -0.550893>, <1.354052, -0.411213, -0.559832>, <1.347114, -0.337269, -0.543227>, <1.355708, -0.300853, -0.556376>, 
      <1.323724, -0.440845, -0.495470>, <1.324268, -0.402210, -0.504410>, <1.318578, -0.345593, -0.493645>, <1.327172, -0.309177, -0.506794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.448605, -0.811688, -0.606062>, <1.396851, -0.783128, -0.528063>, <1.348782, -0.745312, -0.407508>, <1.317216, -0.689369, -0.333670>, 
      <1.451161, -0.788690, -0.651674>, <1.399406, -0.760130, -0.573675>, <1.349832, -0.720383, -0.457238>, <1.318266, -0.664441, -0.383400>, 
      <1.462751, -0.693439, -0.613761>, <1.419255, -0.664590, -0.564200>, <1.352609, -0.622743, -0.479890>, <1.322608, -0.593213, -0.421509>, 
      <1.468813, -0.642761, -0.617061>, <1.425318, -0.613912, -0.567500>, <1.353830, -0.576127, -0.510239>, <1.323829, -0.546597, -0.451858>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.447491, -0.834616, -0.236562>, <1.398488, -0.807277, -0.200184>, <1.345524, -0.767436, -0.136536>, <1.316233, -0.726920, -0.092122>, 
      <1.449106, -0.788402, -0.337541>, <1.400103, -0.761064, -0.301163>, <1.346774, -0.727399, -0.197965>, <1.317483, -0.686882, -0.153551>, 
      <1.443055, -0.861629, -0.507015>, <1.391300, -0.833070, -0.429017>, <1.347398, -0.778169, -0.341960>, <1.315832, -0.722226, -0.268122>, 
      <1.448605, -0.811688, -0.606062>, <1.396851, -0.783128, -0.528063>, <1.348782, -0.745312, -0.407508>, <1.317216, -0.689369, -0.333670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.441569, -1.013048, -0.166080>, <1.391488, -0.986678, -0.124218>, <1.348985, -0.932779, -0.056351>, <1.310531, -0.903466, -0.005184>, 
      <1.443345, -0.959518, -0.187225>, <1.393264, -0.933148, -0.145362>, <1.350696, -0.879815, -0.082432>, <1.312242, -0.850502, -0.031265>, 
      <1.446654, -0.858576, -0.184209>, <1.397651, -0.831237, -0.147830>, <1.344517, -0.799681, -0.087063>, <1.315226, -0.759165, -0.042649>, 
      <1.447491, -0.834616, -0.236562>, <1.398488, -0.807277, -0.200184>, <1.345524, -0.767436, -0.136536>, <1.316233, -0.726920, -0.092122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.602491, -0.423700, -0.723213>, <1.559923, -0.431320, -0.699626>, <1.496159, -0.389640, -0.682979>, <1.458055, -0.391983, -0.651850>, 
      <1.601701, -0.454592, -0.724086>, <1.559133, -0.462212, -0.700499>, <1.497338, -0.465603, -0.680224>, <1.459234, -0.467946, -0.649095>, 
      <1.599723, -0.494658, -0.736295>, <1.554467, -0.526397, -0.703292>, <1.504930, -0.532310, -0.664327>, <1.465586, -0.567528, -0.627498>, 
      <1.599960, -0.525369, -0.739826>, <1.554704, -0.557108, -0.706823>, <1.508157, -0.607543, -0.653891>, <1.468813, -0.642761, -0.617061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.602491, -0.423700, -0.723213>, <1.603408, -0.387858, -0.722200>, <1.601682, -0.340216, -0.735778>, <1.605608, -0.304630, -0.733588>, 
      <1.559923, -0.431320, -0.699626>, <1.560840, -0.395477, -0.698614>, <1.560485, -0.329595, -0.700866>, <1.564411, -0.294009, -0.698676>, 
      <1.496159, -0.389640, -0.682979>, <1.495500, -0.347207, -0.684519>, <1.498938, -0.293085, -0.661832>, <1.505415, -0.251322, -0.665987>, 
      <1.458055, -0.391983, -0.651850>, <1.457396, -0.349550, -0.653389>, <1.456270, -0.293782, -0.627078>, <1.462747, -0.252019, -0.631233>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.601149, -0.624910, -0.644431>, <1.564079, -0.626045, -0.627204>, <1.508514, -0.637406, -0.625272>, <1.468813, -0.642761, -0.617061>, 
      <1.601149, -0.624910, -0.644431>, <1.564495, -0.622083, -0.645787>, <1.548631, -0.628088, -0.652065>, <1.508930, -0.633443, -0.643854>, 
      <1.601149, -0.624910, -0.644431>, <1.564495, -0.622083, -0.645787>, <1.564005, -0.598276, -0.681573>, <1.560353, -0.616925, -0.681727>, 
      <1.601149, -0.624910, -0.644431>, <1.601565, -0.620948, -0.663013>, <1.606188, -0.593052, -0.706217>, <1.602536, -0.611702, -0.706372>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.601149, -0.624910, -0.644431>, <1.601565, -0.620948, -0.663013>, <1.606188, -0.593052, -0.706217>, <1.602536, -0.611702, -0.706372>, 
      <1.564079, -0.626045, -0.627204>, <1.564495, -0.622083, -0.645787>, <1.600817, -0.620482, -0.706445>, <1.597165, -0.639132, -0.706600>, 
      <1.508514, -0.637406, -0.625272>, <1.544942, -0.648765, -0.633622>, <1.556626, -0.646818, -0.623740>, <1.591568, -0.653133, -0.640017>, 
      <1.468813, -0.642761, -0.617061>, <1.505241, -0.654120, -0.625411>, <1.555297, -0.674309, -0.628617>, <1.590239, -0.680624, -0.644893>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.591468, -0.840710, -0.746994>, <1.547577, -0.829762, -0.706325>, <1.480773, -0.829439, -0.654543>, <1.448605, -0.811688, -0.606062>, 
      <1.591425, -0.812466, -0.796463>, <1.547534, -0.801519, -0.755794>, <1.483329, -0.806441, -0.700154>, <1.451161, -0.788690, -0.651674>, 
      <1.587531, -0.736649, -0.654831>, <1.552590, -0.730333, -0.638554>, <1.499178, -0.704798, -0.622111>, <1.462751, -0.693439, -0.613761>, 
      <1.590239, -0.680624, -0.644893>, <1.555297, -0.674309, -0.628617>, <1.505241, -0.654120, -0.625411>, <1.468813, -0.642761, -0.617061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.590543, -0.879957, -0.295761>, <1.549737, -0.865546, -0.274097>, <1.482954, -0.854401, -0.262889>, <1.447491, -0.834616, -0.236562>, 
      <1.592219, -0.829068, -0.421742>, <1.551413, -0.814658, -0.400078>, <1.484569, -0.808187, -0.363868>, <1.449106, -0.788402, -0.337541>, 
      <1.591571, -0.908082, -0.628991>, <1.547680, -0.897134, -0.588322>, <1.475223, -0.879381, -0.555496>, <1.443055, -0.861629, -0.507015>, 
      <1.591468, -0.840710, -0.746994>, <1.547577, -0.829762, -0.706325>, <1.480773, -0.829439, -0.654543>, <1.448605, -0.811688, -0.606062>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.584647, -1.047801, -0.234313>, <1.542016, -1.037638, -0.213113>, <1.476203, -1.031284, -0.195030>, <1.441569, -1.013048, -0.166080>, 
      <1.586416, -0.997448, -0.252747>, <1.543785, -0.987285, -0.231547>, <1.477979, -0.977755, -0.216174>, <1.443345, -0.959518, -0.187225>, 
      <1.589881, -0.900050, -0.246019>, <1.549075, -0.885639, -0.224355>, <1.482117, -0.878361, -0.210535>, <1.446654, -0.858576, -0.184209>, 
      <1.590543, -0.879957, -0.295761>, <1.549737, -0.865546, -0.274097>, <1.482954, -0.854401, -0.262889>, <1.447491, -0.834616, -0.236562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.584647, -1.047801, -0.234313>, <1.586416, -0.997448, -0.252747>, <1.589881, -0.900050, -0.246019>, <1.590543, -0.879957, -0.295761>, 
      <1.615491, -1.055154, -0.249651>, <1.617259, -1.004800, -0.268086>, <1.619949, -0.910668, -0.261983>, <1.620611, -0.890576, -0.311724>, 
      <1.655899, -1.064334, -0.271790>, <1.654672, -1.018175, -0.293809>, <1.653133, -0.956834, -0.321973>, <1.651906, -0.910674, -0.343992>, 
      <1.686435, -1.071420, -0.287851>, <1.685208, -1.025260, -0.309870>, <1.683572, -0.963715, -0.339229>, <1.682345, -0.917555, -0.361248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.704242, -0.347915, -0.788260>, <1.665149, -0.358715, -0.774673>, <1.639454, -0.417084, -0.743694>, <1.602491, -0.423700, -0.723213>, 
      <1.703413, -0.384065, -0.776644>, <1.664320, -0.394865, -0.763056>, <1.638664, -0.447976, -0.744567>, <1.601701, -0.454592, -0.724086>, 
      <1.707654, -0.436562, -0.788747>, <1.669671, -0.444965, -0.782768>, <1.627391, -0.475254, -0.756471>, <1.599723, -0.494658, -0.736295>, 
      <1.708920, -0.474367, -0.792159>, <1.670937, -0.482770, -0.786180>, <1.627628, -0.505965, -0.760003>, <1.599960, -0.525369, -0.739826>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.704242, -0.347915, -0.788260>, <1.704658, -0.329747, -0.794098>, <1.712592, -0.335082, -0.846901>, <1.712541, -0.316416, -0.842915>, 
      <1.665149, -0.358715, -0.774673>, <1.665566, -0.340547, -0.780511>, <1.677748, -0.333469, -0.816891>, <1.677697, -0.314802, -0.812904>, 
      <1.639454, -0.417084, -0.743694>, <1.640371, -0.381241, -0.742681>, <1.636127, -0.349096, -0.764967>, <1.640053, -0.313510, -0.762778>, 
      <1.602491, -0.423700, -0.723213>, <1.603408, -0.387858, -0.722200>, <1.601682, -0.340216, -0.735778>, <1.605608, -0.304630, -0.733588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.708536, -0.635421, -0.728461>, <1.709512, -0.628597, -0.737627>, <1.711694, -0.601206, -0.758912>, <1.711788, -0.612674, -0.759016>, 
      <1.671755, -0.634093, -0.710330>, <1.672731, -0.627269, -0.719497>, <1.678510, -0.601052, -0.743993>, <1.678604, -0.612520, -0.744098>, 
      <1.638342, -0.623771, -0.661715>, <1.638758, -0.619809, -0.680297>, <1.637425, -0.589184, -0.724467>, <1.633773, -0.607834, -0.724622>, 
      <1.601149, -0.624910, -0.644431>, <1.601565, -0.620948, -0.663013>, <1.606188, -0.593052, -0.706217>, <1.602536, -0.611702, -0.706372>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.674878, -0.868128, -0.815724>, <1.666493, -0.941050, -0.699852>, <1.680105, -0.902727, -0.497591>, <1.682345, -0.917555, -0.361248>, 
      <1.643726, -0.863136, -0.804607>, <1.635341, -0.936059, -0.688735>, <1.649666, -0.895846, -0.480335>, <1.651906, -0.910674, -0.343992>, 
      <1.615604, -0.846730, -0.769358>, <1.615707, -0.914103, -0.651355>, <1.622287, -0.839687, -0.437706>, <1.620611, -0.890576, -0.311724>, 
      <1.591468, -0.840710, -0.746994>, <1.591571, -0.908082, -0.628991>, <1.592219, -0.829068, -0.421742>, <1.590543, -0.879957, -0.295761>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.674878, -0.868128, -0.815724>, <1.643726, -0.863136, -0.804607>, <1.615604, -0.846730, -0.769358>, <1.591468, -0.840710, -0.746994>, 
      <1.678628, -0.835517, -0.867542>, <1.647476, -0.830526, -0.856425>, <1.615561, -0.818487, -0.818827>, <1.591425, -0.812466, -0.796463>, 
      <1.700386, -0.745459, -0.742086>, <1.663193, -0.740810, -0.719687>, <1.626592, -0.743708, -0.673026>, <1.587531, -0.736649, -0.654831>, 
      <1.708953, -0.686164, -0.728923>, <1.671760, -0.681515, -0.706524>, <1.629299, -0.687684, -0.663088>, <1.590239, -0.680624, -0.644893>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.796384, -0.370132, -0.790604>, <1.799230, -0.353262, -0.825244>, <1.806513, -0.351910, -0.912962>, <1.805871, -0.313901, -0.906069>, 
      <1.767968, -0.369533, -0.791714>, <1.770814, -0.352664, -0.826353>, <1.778514, -0.352664, -0.894016>, <1.777872, -0.314655, -0.887123>, 
      <1.730238, -0.340732, -0.797296>, <1.730654, -0.322564, -0.803134>, <1.738199, -0.336267, -0.868956>, <1.738147, -0.317601, -0.864969>, 
      <1.704242, -0.347915, -0.788260>, <1.704658, -0.329747, -0.794098>, <1.712592, -0.335082, -0.846901>, <1.712541, -0.316416, -0.842915>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.796384, -0.370132, -0.790604>, <1.767968, -0.369533, -0.791714>, <1.730238, -0.340732, -0.797296>, <1.704242, -0.347915, -0.788260>, 
      <1.800252, -0.402811, -0.785256>, <1.771836, -0.402212, -0.786366>, <1.729409, -0.376883, -0.785679>, <1.703413, -0.384065, -0.776644>, 
      <1.806480, -0.445843, -0.773136>, <1.775818, -0.444510, -0.773656>, <1.737278, -0.430009, -0.793411>, <1.707654, -0.436562, -0.788747>, 
      <1.809278, -0.479063, -0.772778>, <1.778615, -0.477730, -0.773298>, <1.738544, -0.467814, -0.796822>, <1.708920, -0.474367, -0.792159>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.282150, -0.454880, -0.488191>, <2.327370, -0.442550, -0.405039>, <2.384243, -0.433222, -0.202203>, <2.384243, -0.338120, -0.210379>, 
      <2.282150, -0.454880, -0.488191>, <2.327838, -0.403913, -0.413979>, <2.384243, -0.341462, -0.210092>, <2.384243, -0.246360, -0.218268>, 
      <2.282150, -0.454880, -0.488191>, <2.327838, -0.403913, -0.413979>, <2.328957, -0.376951, -0.415770>, <2.327249, -0.337614, -0.420524>, 
      <2.282150, -0.454880, -0.488191>, <2.282618, -0.416244, -0.497131>, <2.283858, -0.362504, -0.494761>, <2.282150, -0.323167, -0.499515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.391930, -0.409980, -0.116167>, <2.392430, -0.418231, -0.100737>, <2.390774, -0.409244, -0.072887>, <2.389158, -0.419270, -0.058629>, 
      <2.358134, -0.455164, -0.214691>, <2.358634, -0.463415, -0.199261>, <2.358671, -0.494510, -0.153216>, <2.357056, -0.504536, -0.138958>, 
      <2.328034, -0.516678, -0.351924>, <2.328034, -0.563310, -0.321575>, <2.322657, -0.610143, -0.284459>, <2.323054, -0.635091, -0.234729>, 
      <2.279277, -0.560593, -0.444579>, <2.279277, -0.607225, -0.414230>, <2.281753, -0.678542, -0.376122>, <2.282150, -0.703489, -0.326391>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.391930, -0.409980, -0.116167>, <2.390913, -0.393189, -0.147566>, <2.386019, -0.367429, -0.190212>, <2.384243, -0.338120, -0.210379>, 
      <2.358134, -0.455164, -0.214691>, <2.357117, -0.438373, -0.246090>, <2.386019, -0.462531, -0.182036>, <2.384243, -0.433222, -0.202203>, 
      <2.328034, -0.516678, -0.351924>, <2.328034, -0.487915, -0.370644>, <2.326966, -0.475982, -0.397303>, <2.327370, -0.442550, -0.405039>, 
      <2.279277, -0.560593, -0.444579>, <2.279277, -0.531830, -0.463298>, <2.281745, -0.488312, -0.480455>, <2.282150, -0.454880, -0.488191>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.368238, -0.557005, 0.092926>, <2.342412, -0.612219, 0.039595>, <2.318897, -0.692928, -0.031053>, <2.282150, -0.741053, -0.084843>, 
      <2.371660, -0.499635, 0.070321>, <2.345833, -0.554850, 0.016990>, <2.318696, -0.652872, -0.092481>, <2.281948, -0.700997, -0.146272>, 
      <2.383458, -0.454641, -0.008326>, <2.351356, -0.539907, -0.088655>, <2.323577, -0.667972, -0.169180>, <2.282674, -0.736371, -0.260843>, 
      <2.389158, -0.419270, -0.058629>, <2.357056, -0.504536, -0.138958>, <2.323054, -0.635091, -0.234729>, <2.282150, -0.703489, -0.326391>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.257435, -0.870153, 0.119032>, <2.233765, -0.884413, 0.083951>, <2.203376, -0.899729, 0.034569>, <2.283229, -0.917688, 0.002095>, 
      <2.259223, -0.776209, 0.111200>, <2.235553, -0.790469, 0.076119>, <2.203052, -0.846739, 0.008487>, <2.282905, -0.864698, -0.023986>, 
      <2.363014, -0.644593, 0.127438>, <2.337188, -0.699808, 0.074108>, <2.214303, -0.725189, 0.018420>, <2.282313, -0.773313, -0.035370>, 
      <2.368238, -0.557005, 0.092926>, <2.342412, -0.612219, 0.039595>, <2.318897, -0.692928, -0.031053>, <2.282150, -0.741053, -0.084843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.148118, -0.402505, -0.644571>, <2.145059, -0.475724, -0.641851>, <2.136961, -0.571507, -0.620219>, <2.132180, -0.643937, -0.609782>, 
      <2.197338, -0.406828, -0.604281>, <2.194279, -0.480047, -0.601561>, <2.181091, -0.546504, -0.570658>, <2.176309, -0.618934, -0.560221>, 
      <2.251947, -0.463116, -0.543730>, <2.251542, -0.496548, -0.535994>, <2.248824, -0.559260, -0.521170>, <2.248824, -0.588022, -0.502450>, 
      <2.282150, -0.454880, -0.488191>, <2.281745, -0.488312, -0.480455>, <2.279277, -0.531830, -0.463298>, <2.279277, -0.560593, -0.444579>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.148118, -0.402505, -0.644571>, <2.197338, -0.406828, -0.604281>, <2.251947, -0.463116, -0.543730>, <2.282150, -0.454880, -0.488191>, 
      <2.149889, -0.360111, -0.646146>, <2.199110, -0.364434, -0.605856>, <2.252414, -0.424480, -0.552669>, <2.282618, -0.416244, -0.497131>, 
      <2.157107, -0.303689, -0.619070>, <2.201891, -0.305594, -0.582564>, <2.255550, -0.353435, -0.544343>, <2.283858, -0.362504, -0.494761>, 
      <2.148118, -0.262479, -0.623954>, <2.192902, -0.264384, -0.587448>, <2.253842, -0.314099, -0.549097>, <2.282150, -0.323167, -0.499515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.148118, -0.822333, -0.598783>, <2.146126, -0.797172, -0.646333>, <2.136961, -0.697456, -0.606482>, <2.132180, -0.643937, -0.609782>, 
      <2.200583, -0.795158, -0.520842>, <2.198591, -0.769998, -0.568392>, <2.181091, -0.672453, -0.556921>, <2.176309, -0.618934, -0.560221>, 
      <2.249214, -0.758565, -0.400199>, <2.248816, -0.733618, -0.449929>, <2.248824, -0.634654, -0.472101>, <2.248824, -0.588022, -0.502450>, 
      <2.282150, -0.703489, -0.326391>, <2.281753, -0.678542, -0.376122>, <2.279277, -0.607225, -0.414230>, <2.279277, -0.560593, -0.444579>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.148118, -0.845277, -0.229283>, <2.147831, -0.799038, -0.330263>, <2.152227, -0.874242, -0.500683>, <2.148118, -0.822333, -0.598783>, 
      <2.197820, -0.819230, -0.192905>, <2.197533, -0.772991, -0.293885>, <2.204692, -0.847068, -0.422742>, <2.200583, -0.795158, -0.520842>, 
      <2.251808, -0.780789, -0.129257>, <2.251607, -0.740732, -0.190686>, <2.249737, -0.791447, -0.334651>, <2.249214, -0.758565, -0.400199>, 
      <2.282150, -0.741053, -0.084843>, <2.281948, -0.700997, -0.146272>, <2.282674, -0.736371, -0.260843>, <2.282150, -0.703489, -0.326391>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.149368, -1.023802, -0.158801>, <2.148993, -0.970244, -0.179946>, <2.148267, -0.869250, -0.176929>, <2.148118, -0.845277, -0.229283>, 
      <2.200123, -0.998752, -0.116939>, <2.199748, -0.945194, -0.138083>, <2.197969, -0.843203, -0.140551>, <2.197820, -0.819230, -0.192905>, 
      <2.244021, -0.945985, -0.049071>, <2.243697, -0.892994, -0.075153>, <2.251971, -0.813049, -0.079784>, <2.251808, -0.780789, -0.129257>, 
      <2.283229, -0.917688, 0.002095>, <2.282905, -0.864698, -0.023986>, <2.282313, -0.773313, -0.035370>, <2.282150, -0.741053, -0.084843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.003928, -0.430444, -0.715934>, <2.004786, -0.461928, -0.716816>, <2.009403, -0.502676, -0.728939>, <2.009995, -0.533971, -0.732547>, 
      <2.046576, -0.438836, -0.693339>, <2.047434, -0.470320, -0.694221>, <2.051470, -0.532717, -0.695528>, <2.052062, -0.564012, -0.699137>, 
      <2.110298, -0.399183, -0.675529>, <2.107239, -0.472403, -0.672809>, <2.100306, -0.538518, -0.657048>, <2.095525, -0.610947, -0.646612>, 
      <2.148118, -0.402505, -0.644571>, <2.145059, -0.475724, -0.641851>, <2.136961, -0.571507, -0.620219>, <2.132180, -0.643937, -0.609782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.003928, -0.430444, -0.715934>, <2.046576, -0.438836, -0.693339>, <2.110298, -0.399183, -0.675529>, <2.148118, -0.402505, -0.644571>, 
      <2.002951, -0.394603, -0.714930>, <2.045599, -0.402994, -0.692335>, <2.112069, -0.356789, -0.677104>, <2.149889, -0.360111, -0.646146>, 
      <2.009851, -0.346676, -0.727844>, <2.051324, -0.337141, -0.692944>, <2.114472, -0.301876, -0.653824>, <2.157107, -0.303689, -0.619070>, 
      <2.003928, -0.311333, -0.726309>, <2.045401, -0.301798, -0.691410>, <2.105483, -0.260666, -0.658708>, <2.148118, -0.262479, -0.623954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.999941, -0.631619, -0.637152>, <2.035888, -0.632357, -0.618121>, <2.092508, -0.640242, -0.617993>, <2.132180, -0.643937, -0.609782>, 
      <1.999941, -0.631619, -0.637152>, <2.037184, -0.628481, -0.642733>, <2.054132, -0.632670, -0.650816>, <2.093804, -0.636365, -0.642605>, 
      <1.999941, -0.631619, -0.637152>, <2.037184, -0.628481, -0.642733>, <2.027192, -0.609993, -0.681345>, <2.046074, -0.623620, -0.690300>, 
      <1.999941, -0.631619, -0.637152>, <2.001237, -0.627742, -0.661764>, <1.985378, -0.605069, -0.710236>, <2.004260, -0.618697, -0.719191>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.999941, -0.631619, -0.637152>, <2.035888, -0.632357, -0.618121>, <2.092508, -0.640242, -0.617993>, <2.132180, -0.643937, -0.609782>, 
      <2.001237, -0.627742, -0.661764>, <2.037184, -0.628481, -0.642733>, <2.065842, -0.645933, -0.632372>, <2.105514, -0.649628, -0.624161>, 
      <1.985378, -0.605069, -0.710236>, <2.004721, -0.619030, -0.719410>, <2.068983, -0.629355, -0.640375>, <2.068946, -0.654811, -0.642658>, 
      <2.004260, -0.618697, -0.719191>, <2.023603, -0.632658, -0.728365>, <2.043331, -0.637452, -0.655430>, <2.043294, -0.662908, -0.657712>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.003928, -0.847598, -0.739715>, <2.009535, -0.815701, -0.792305>, <2.043205, -0.724424, -0.663228>, <2.043294, -0.662908, -0.657712>, 
      <2.051122, -0.837085, -0.702588>, <2.056729, -0.805188, -0.755178>, <2.068856, -0.716326, -0.648173>, <2.068946, -0.654811, -0.642658>, 
      <2.115417, -0.839271, -0.647363>, <2.113426, -0.814110, -0.694912>, <2.110296, -0.703147, -0.620861>, <2.105514, -0.649628, -0.624161>, 
      <2.148118, -0.822333, -0.598783>, <2.146126, -0.797172, -0.646333>, <2.136961, -0.697456, -0.606482>, <2.132180, -0.643937, -0.609782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.003928, -0.886857, -0.288482>, <2.003559, -0.835942, -0.414463>, <1.991592, -0.917774, -0.624014>, <2.003928, -0.847598, -0.739715>, 
      <2.045861, -0.874124, -0.267948>, <2.045493, -0.823209, -0.393929>, <2.038786, -0.907262, -0.586887>, <2.051122, -0.837085, -0.702588>, 
      <2.112149, -0.864127, -0.255610>, <2.111862, -0.817888, -0.356590>, <2.119527, -0.891180, -0.549262>, <2.115417, -0.839271, -0.647363>, 
      <2.148118, -0.845277, -0.229283>, <2.147831, -0.799038, -0.330263>, <2.152227, -0.874242, -0.500683>, <2.148118, -0.822333, -0.598783>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.005429, -1.054798, -0.227034>, <1.975565, -1.059927, -0.243218>, <1.938300, -1.061935, -0.270252>, <1.909530, -1.064993, -0.288774>, 
      <2.004979, -1.004416, -0.245468>, <1.975114, -1.009545, -0.261653>, <1.934411, -1.018934, -0.289358>, <1.905641, -1.021992, -0.307880>, 
      <2.004074, -0.906960, -0.238740>, <1.970351, -0.917200, -0.255253>, <1.929384, -0.930965, -0.286656>, <1.897699, -0.937936, -0.308155>, 
      <2.003928, -0.886857, -0.288482>, <1.970205, -0.897096, -0.304995>, <1.928253, -0.914686, -0.330961>, <1.896568, -0.921657, -0.352460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.005429, -1.054798, -0.227034>, <2.004979, -1.004416, -0.245468>, <2.004074, -0.906960, -0.238740>, <2.003928, -0.886857, -0.288482>, 
      <2.047752, -1.047529, -0.204098>, <2.047302, -0.997147, -0.222533>, <2.046007, -0.894227, -0.218207>, <2.045861, -0.874124, -0.267948>, 
      <2.114269, -1.041125, -0.187751>, <2.113894, -0.987568, -0.208895>, <2.112298, -0.888100, -0.203256>, <2.112149, -0.864127, -0.255610>, 
      <2.149368, -1.023802, -0.158801>, <2.148993, -0.970244, -0.179946>, <2.148267, -0.869250, -0.176929>, <2.148118, -0.845277, -0.229283>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.890644, -0.351843, -0.780981>, <1.893033, -0.389927, -0.770016>, <1.901923, -0.443786, -0.784607>, <1.906769, -0.482968, -0.788805>, 
      <1.932156, -0.363906, -0.766046>, <1.934545, -0.401990, -0.755081>, <1.938331, -0.453745, -0.777310>, <1.943177, -0.492928, -0.781508>, 
      <1.964110, -0.422609, -0.737029>, <1.964969, -0.454093, -0.737912>, <1.983127, -0.483912, -0.749807>, <1.983719, -0.515207, -0.753415>, 
      <2.003928, -0.430444, -0.715934>, <2.004786, -0.461928, -0.716816>, <2.009403, -0.502676, -0.728939>, <2.009995, -0.533971, -0.732547>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.890644, -0.351843, -0.780981>, <1.932156, -0.363906, -0.766046>, <1.964110, -0.422609, -0.737029>, <2.003928, -0.430444, -0.715934>, 
      <1.889501, -0.333606, -0.786232>, <1.931013, -0.345669, -0.771297>, <1.963134, -0.386768, -0.736025>, <2.002951, -0.394603, -0.714930>, 
      <1.897074, -0.338971, -0.839250>, <1.931169, -0.338529, -0.808305>, <1.975152, -0.354654, -0.757043>, <2.009851, -0.346676, -0.727844>, 
      <1.896568, -0.320313, -0.835635>, <1.930663, -0.319871, -0.804690>, <1.969229, -0.319311, -0.755509>, <2.003928, -0.311333, -0.726309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.890644, -0.351843, -0.780981>, <1.889501, -0.333606, -0.786232>, <1.897074, -0.338971, -0.839250>, <1.896568, -0.320313, -0.835635>, 
      <1.864368, -0.344207, -0.790435>, <1.863225, -0.325970, -0.795685>, <1.871525, -0.339303, -0.862439>, <1.871020, -0.320644, -0.858824>, 
      <1.825305, -0.370741, -0.789475>, <1.828151, -0.353872, -0.824114>, <1.833722, -0.353833, -0.891832>, <1.833080, -0.315825, -0.884939>, 
      <1.796384, -0.370132, -0.790604>, <1.799230, -0.353262, -0.825244>, <1.806513, -0.351910, -0.912962>, <1.805871, -0.313901, -0.906069>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.890644, -0.351843, -0.780981>, <1.864368, -0.344207, -0.790435>, <1.825305, -0.370741, -0.789475>, <1.796384, -0.370132, -0.790604>, 
      <1.893033, -0.389927, -0.770016>, <1.866757, -0.382291, -0.779470>, <1.829173, -0.403421, -0.784127>, <1.800252, -0.402811, -0.785256>, 
      <1.901923, -0.443786, -0.784607>, <1.873832, -0.436101, -0.790238>, <1.836111, -0.447131, -0.772633>, <1.806480, -0.445843, -0.773136>, 
      <1.906769, -0.482968, -0.788805>, <1.878677, -0.475283, -0.794436>, <1.838909, -0.480351, -0.772276>, <1.809278, -0.479063, -0.772778>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.906936, -0.639311, -0.729028>, <1.941062, -0.639174, -0.709562>, <1.965225, -0.630906, -0.655531>, <1.999941, -0.631619, -0.637152>, 
      <1.909467, -0.633041, -0.738194>, <1.943592, -0.632903, -0.718728>, <1.966520, -0.627029, -0.680143>, <2.001237, -0.627742, -0.661764>, 
      <1.912017, -0.607524, -0.759510>, <1.938975, -0.608369, -0.748086>, <1.961392, -0.602245, -0.726809>, <1.985378, -0.605069, -0.710236>, 
      <1.915371, -0.618409, -0.759583>, <1.942329, -0.619254, -0.748159>, <1.980274, -0.615873, -0.735764>, <2.004260, -0.618697, -0.719191>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.896568, -0.878368, -0.796676>, <1.900622, -0.851028, -0.844995>, <1.924226, -0.763292, -0.737333>, <1.928202, -0.708326, -0.729490>, 
      <1.930711, -0.873428, -0.781695>, <1.934765, -0.846088, -0.830014>, <1.961716, -0.755935, -0.717791>, <1.965692, -0.700969, -0.709948>, 
      <1.974811, -0.854084, -0.762621>, <1.980418, -0.822187, -0.815211>, <2.007494, -0.735696, -0.684185>, <2.007584, -0.674181, -0.678669>, 
      <2.003928, -0.847598, -0.739715>, <2.009535, -0.815701, -0.792305>, <2.043205, -0.724424, -0.663228>, <2.043294, -0.662908, -0.657712>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.896568, -0.878368, -0.796676>, <1.930711, -0.873428, -0.781695>, <1.974811, -0.854084, -0.762621>, <2.003928, -0.847598, -0.739715>, 
      <1.886816, -0.944131, -0.680451>, <1.920959, -0.939190, -0.665469>, <1.962475, -0.924261, -0.646920>, <1.991592, -0.917774, -0.624014>, 
      <1.893361, -0.875490, -0.478104>, <1.925046, -0.868518, -0.456606>, <1.969837, -0.846181, -0.430976>, <2.003559, -0.835942, -0.414463>, 
      <1.896568, -0.921657, -0.352460>, <1.928253, -0.914686, -0.330961>, <1.970205, -0.897096, -0.304995>, <2.003928, -0.886857, -0.288482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.808230, -0.632388, -0.746508>, <1.809405, -0.626474, -0.762737>, <1.811385, -0.596724, -0.793914>, <1.812146, -0.612674, -0.800603>, 
      <1.777828, -0.631792, -0.746421>, <1.779003, -0.625878, -0.762650>, <1.778808, -0.595807, -0.793823>, <1.779569, -0.611756, -0.800512>, 
      <1.735796, -0.636405, -0.741898>, <1.736772, -0.629581, -0.751065>, <1.741418, -0.601344, -0.772274>, <1.741512, -0.612812, -0.772379>, 
      <1.708536, -0.635421, -0.728461>, <1.709512, -0.628597, -0.737627>, <1.711694, -0.601206, -0.758912>, <1.711788, -0.612674, -0.759016>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.808230, -0.632388, -0.746508>, <1.838368, -0.632979, -0.746594>, <1.880752, -0.639416, -0.743964>, <1.906936, -0.639311, -0.729028>, 
      <1.809405, -0.626474, -0.762737>, <1.839543, -0.627065, -0.762823>, <1.883283, -0.633146, -0.753130>, <1.909467, -0.633041, -0.738194>, 
      <1.811385, -0.596724, -0.793914>, <1.844739, -0.597664, -0.794007>, <1.881307, -0.606561, -0.772524>, <1.912017, -0.607524, -0.759510>, 
      <1.812146, -0.612674, -0.800603>, <1.845500, -0.613614, -0.800696>, <1.884661, -0.617446, -0.772597>, <1.915371, -0.618409, -0.759583>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.809784, -0.875691, -0.824902>, <1.809219, -0.940056, -0.720672>, <1.811310, -0.884971, -0.534222>, <1.809913, -0.929545, -0.420124>, 
      <1.769347, -0.873823, -0.828376>, <1.768782, -0.938188, -0.724146>, <1.769051, -0.884162, -0.535955>, <1.767653, -0.928736, -0.421858>, 
      <1.712715, -0.874191, -0.829226>, <1.704329, -0.947113, -0.713355>, <1.716214, -0.910889, -0.518061>, <1.718454, -0.925717, -0.381719>, 
      <1.674878, -0.868128, -0.815724>, <1.666493, -0.941050, -0.699852>, <1.680105, -0.902727, -0.497591>, <1.682345, -0.917555, -0.361248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.809784, -0.875691, -0.824902>, <1.769347, -0.873823, -0.828376>, <1.712715, -0.874191, -0.829226>, <1.674878, -0.868128, -0.815724>, 
      <1.810024, -0.848307, -0.869246>, <1.769587, -0.846439, -0.872721>, <1.716465, -0.841580, -0.881044>, <1.678628, -0.835517, -0.867542>, 
      <1.811388, -0.760222, -0.783150>, <1.776678, -0.756713, -0.783061>, <1.730102, -0.749174, -0.759982>, <1.700386, -0.745459, -0.742086>, 
      <1.811854, -0.708326, -0.778356>, <1.777144, -0.704817, -0.778266>, <1.738669, -0.689878, -0.746819>, <1.708953, -0.686164, -0.728923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.809784, -0.875691, -0.824902>, <1.810024, -0.848307, -0.869246>, <1.811388, -0.760222, -0.783150>, <1.811854, -0.708326, -0.778356>, 
      <1.837044, -0.876950, -0.822560>, <1.837284, -0.849566, -0.866904>, <1.849054, -0.764029, -0.783248>, <1.849520, -0.712133, -0.778453>, 
      <1.871704, -0.881966, -0.807586>, <1.875758, -0.854626, -0.855905>, <1.891153, -0.769783, -0.754574>, <1.895128, -0.714816, -0.746730>, 
      <1.896568, -0.878368, -0.796676>, <1.900622, -0.851028, -0.844995>, <1.924226, -0.763292, -0.737333>, <1.928202, -0.708326, -0.729490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.809784, -0.875691, -0.824902>, <1.837044, -0.876950, -0.822560>, <1.871704, -0.881966, -0.807586>, <1.896568, -0.878368, -0.796676>, 
      <1.809219, -0.940056, -0.720672>, <1.836479, -0.941315, -0.718330>, <1.861952, -0.947728, -0.691360>, <1.886816, -0.944131, -0.680451>, 
      <1.811310, -0.884971, -0.534222>, <1.844344, -0.885603, -0.532867>, <1.866440, -0.881413, -0.496370>, <1.893361, -0.875490, -0.478104>, 
      <1.809913, -0.929545, -0.420124>, <1.842947, -0.930178, -0.418769>, <1.869647, -0.927580, -0.370726>, <1.896568, -0.921657, -0.352460>
    }
  }
  texture {
    Clear_Glass
  }
  hollow
  scale <1.1, 1.1, 1.0>
  rotate <90.0, -0.0, -161.52832>
  translate  <-0.142205, -2.440134, 2.350677>
}
union { // Lord_Radon
  object { MedallionDone }
  object { HoleHead }
  object { Clothes }
  object { Face }
  sphere { // righthand
    <0,0,0>,1
    texture {
      Radon
    }
    hollow
    scale <0.32, 0.32, 0.56>
    rotate <-0.0, 0.0, 32.373924>
    translate  <-4.40118, -2.615502, -5.978953>
  }
  cone { // Righthandcuff
    <0,0,0>, 0.7, <0,0,1>, 1.0
    texture {
      Radon
    }
    hollow
    scale 0.45
    rotate <180.0, -0.0, 32.373924>
    translate  <-4.408514, -2.604291, -5.783872>
  }
  sphere { // lefthand
    <0,0,0>,1
    texture {
      Radon
    }
    hollow
    scale <0.32, 0.32, 0.56>
    rotate <25.942524, 0.0, 32.373924>
    translate  <-0.709006, -1.522616, -5.507695>
  }
  scale 0.5
  rotate -32.373924*z
  translate  <-19.89527, -0.74863, 0.54442>
}


#declare pillartip = union {
  box { // Tippytop_pil23
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone25
    }
    scale <3.0, 3.0, 0.25>
    rotate <0.0, 0.0, -0.0>
    translate  <-35.0, -30.0, 6.2>
  }
  cylinder { // TipTop_pilla23
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stone25
    }
    scale <2.7, 2.7, 0.5>
    rotate <0.0, 0.0, -0.0>
    translate  <-35.0, -30.0, 5.4>
  }
  cone { // Top_pillar23
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Stone25
    }
    scale <2.0, 2.5, 2.0>
    rotate <0.0, 0.0, -0.0>
    translate  <-35.0, -30.0, 3.4>
  }
  translate  <35.3, 90.9, 8.0>
}
#declare pillartop = union {
  box { // Tippytop_pil22
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone25
    }
    scale <3.0, 3.0, 0.25>
    rotate <0.0, 0.0, -0.0>
    translate  <-35.0, 60.900001, 1.9>
  }
  cylinder { // TipTop_pilla22
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stone25
    }
    scale <2.7, 2.7, 0.5>
    rotate <0.0, 0.0, -0.0>
    translate  <-35.0, 60.900001, 2.1>
  }
  cone { // Top_pillar22
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Stone25
    }
    scale <2.0, 2.5, 2.0>
    rotate <-180.0, 0.0, -0.0>
    translate  <-35.0, 60.900001, 4.6>
  }
  translate  <35.3, 0.0, -8.0>
}
union { // DoorPillar
  object { pillartip }
  object { pillartop }
  cylinder { // doorpillar1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stone24
    }
    scale <2.0, 2.0, 18.0>
    translate  <0.296426, 60.9, -5.0>
  }
}




#declare pillarlines3 = union {
  torus { // line13
    1.5, 0.5  rotate -x*90
    texture {
      Shiny_Black
    }
    scale <2.0, 2.0, 0.5>
    rotate -25.0*x
    translate  <0.0, -10.0, -2.8>
  }
  torus { // line14
    1.5, 0.5  rotate -x*90
    texture {
      Shiny_Black
    }
    scale <2.0, 2.0, 0.5>
    rotate 25.0*x
    translate  <0.0, -10.0, -0.8>
  }
  torus { // line15
    1.5, 0.5  rotate -x*90
    texture {
      Shiny_Black
    }
    scale <2.0, 2.0, 0.5>
    rotate -25.0*x
    translate  <0.0, -10.0, 1.3>
  }
  torus { // line16
    1.5, 0.5  rotate -x*90
    texture {
      Shiny_Black
    }
    scale <2.0, 2.0, 0.5>
    rotate 25.0*x
    translate  <0.0, -10.0, 3.3>
  }
  sphere { // P_Sphere_10
    <0,0,0>,1
    texture {
      Shiny_Black
    }
    scale 0.7
    translate  <0.0, -12.0, 0.2>
  }
  sphere { // P_Sphere_11
    <0,0,0>,1
    texture {
      Shiny_Black
    }
    scale 0.7
    translate  <0.0, -8.0, 2.3>
  }
  sphere { // P_Sphere_12
    <0,0,0>,1
    texture {
      Shiny_Black
    }
    scale 0.7
    translate  <0.0, -8.0, -1.8>
  }
}
#declare P_Lines_Done4 = difference {
  cylinder { // pillar3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stone24
    }
    scale <2.0, 2.0, 10.0>
    translate  <0.0, -10.0, -5.0>
  }
  object { pillarlines3 }
}
#declare W_Pillar_Done4 = union {
  box { // Tippytop_pill6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone25
    }
    scale <3.0, 3.0, 0.25>
    translate  <0.0, -10.0, -6.1>
  }
  cylinder { // TipTop_pillar6
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stone25
    }
    scale <2.7, 2.7, 0.5>
    translate  <0.0, -10.0, -5.9>
  }
  cone { // Top_pillar6
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Stone25
    }
    scale <2.5, 2.5, 2.0>
    rotate -180.0*x
    translate  <0.0, -10.0, -3.4>
  }
  box { // Tippytop_pill7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone25
    }
    scale <3.0, 3.0, 0.25>
    translate  <0.0, -10.0, 6.2>
  }
  cylinder { // TipTop_pillar7
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stone25
    }
    scale <2.7, 2.7, 0.5>
    translate  <0.0, -10.0, 5.4>
  }
  cone { // Top_pillar7
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Stone25
    }
    scale <2.5, 2.5, 2.0>
    translate  <0.0, -10.0, 3.4>
  }
  object { P_Lines_Done4 }
  rotate 0.0*x
  translate  <0.0, 40.0, 0.0>
}
#declare pillarlines4 = union {
  torus { // line17
    1.5, 0.5  rotate -x*90
    texture {
      Shiny_Black
    }
    scale <2.0, 2.0, 0.5>
    rotate -25.0*x
    translate  <0.0, -10.0, -2.8>
  }
  torus { // line18
    1.5, 0.5  rotate -x*90
    texture {
      Shiny_Black
    }
    scale <2.0, 2.0, 0.5>
    rotate 25.0*x
    translate  <0.0, -10.0, -0.8>
  }
  torus { // line19
    1.5, 0.5  rotate -x*90
    texture {
      Shiny_Black
    }
    scale <2.0, 2.0, 0.5>
    rotate -25.0*x
    translate  <0.0, -10.0, 1.3>
  }
  torus { // line20
    1.5, 0.5  rotate -x*90
    texture {
      Shiny_Black
    }
    scale <2.0, 2.0, 0.5>
    rotate 25.0*x
    translate  <0.0, -10.0, 3.3>
  }
  sphere { // P_Sphere_13
    <0,0,0>,1
    texture {
      Shiny_Black
    }
    scale 0.7
    translate  <0.0, -12.0, 0.2>
  }
  sphere { // P_Sphere_14
    <0,0,0>,1
    texture {
      Shiny_Black
    }
    scale 0.7
    translate  <0.0, -8.0, 2.3>
  }
  sphere { // P_Sphere_15
    <0,0,0>,1
    texture {
      Shiny_Black
    }
    scale 0.7
    translate  <0.0, -8.0, -1.8>
  }
}
#declare P_Lines_Done5 = difference {
  cylinder { // pillar4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stone24
    }
    scale <2.0, 2.0, 10.0>
    translate  <0.0, -10.0, -5.0>
  }
  object { pillarlines4 }
}
#declare W_Pillar_Done3 = merge {
  box { // Tippytop_pill8
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 0.25>
    translate  <0.0, -10.0, -6.1>
  }
  cylinder { // TipTop_pillar8
    <0,0,1>, <0,0,0>, 1 
    scale <2.7, 2.7, 0.5>
    translate  <0.0, -10.0, -5.9>
  }
  cone { // Top_pillar8
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <2.5, 2.5, 2.0>
    rotate -180.0*x
    translate  <0.0, -10.0, -3.4>
  }
  box { // Tippytop_pill9
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 0.25>
    translate  <0.0, -10.0, 6.2>
  }
  cylinder { // TipTop_pillar9
    <0,0,1>, <0,0,0>, 1 
    scale <2.7, 2.7, 0.5>
    translate  <0.0, -10.0, 5.4>
  }
  cone { // Top_pillar9
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <2.5, 2.5, 2.0>
    translate  <0.0, -10.0, 3.4>
  }
  object { P_Lines_Done5 }
  texture {
    Stone24
  }
  rotate 90.0*z
  translate  <-9.954136, 8.982729, 0.4>
}
#declare sunslats = union {
  object { sunhole5 }
  object { // sunhole6->sunhole5
    sunhole5
    rotate 0.0*y
    translate  <1.6, 0.0, -0.0>
  }
  object { // sunhole7->sunhole5
    sunhole5
    rotate 0.0*y
    translate  <3.2, 0.0, -0.0>
  }
  object { // sunhole8->sunhole5
    sunhole5
    rotate 0.0*y
    translate  <4.8, 0.0, -0.0>
  }
  object { // sunhole9->sunhole5
    sunhole5
    rotate 0.0*y
    translate  <6.4, 0.0, -0.0>
  }
  object { // sunhole10->sunhole5
    sunhole5
    rotate 0.0*y
    translate  <8.0, 0.0, -0.0>
  }
  object { // sunhole11->sunhole5
    sunhole5
    rotate 0.0*y
    translate  <9.6, 0.0, -0.0>
  }
  no_shadow
  hollow
}
#declare SunBox = difference {
  box { // SunCover
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale <11.0, 11.0, 15.0>
    translate  <-16.606719, 47.700001, 37.274936>
  }
  object { sunslats }
  texture {
    Stone24
  }
  hollow
  translate  -0.769993*x
}
#declare Roof_Done = difference {
  box { // hallroof
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone24
    }
    scale <25.0, 35.0, 5.3>
    translate  <-17.5, 0.0, 12.2>
  }
  cylinder { // Hall_Roof1
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 8.0, 72.0>
    rotate -90.0*x
    translate  <-17.5, -36.0, 6.9>
    texture {
      Stone25
    }
  }
}
#declare Door_Way = difference {
  box { // doorwall
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone24
    }
    scale <30.0, 2.5, 19.0>
    translate  <-18.8, 65.600001, 7.6>
  }
  box { // Door_Hole
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone24
    }
    scale <10.9, 3.3, 10.0>
    translate  <-17.0, 65.800001, 2.6>
  }
}
union { // evaluate
  object { W_Pillar_Done4 }
  object { W_Pillar_Done3 }
  object { SunBox }
  object { Roof_Done }
  object { Door_Way }
}




box { // wall2
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Stone24
  }
  scale <1.0, 35.0, 8.0>
  translate  -41.5*x
}


union { // Dark_Sun1
  sphere { // inner1
    <0,0,0>,1
    texture {
      Shiny_Black
    }
    scale <0.1, 0.9, 0.9>
    translate  <0.0, 0.085606, 0.05012>
  }
  cylinder { // outer1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold
    }
    scale <1.0, 1.0, 0.1>
    rotate <-180.0, -90.0, 0.0>
  }
  scale 3.0
  translate  <5.9, 4.0, 0.0>
}


union { // Dark_Sun2
  sphere { // inner
    <0,0,0>,1
    texture {
      Shiny_Black
    }
    scale <0.1, 0.9, 0.9>
    translate  <0.0, 0.085606, 0.05012>
  }
  cylinder { // outer
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold
    }
    scale <1.0, 1.0, 0.1>
    rotate <-180.0, -90.0, 0.0>
  }
  scale 3.0
  translate  <5.9, 20.0, 0.0>
}


torus { // DoorHandle2
  1.75, 0.25  rotate -x*90
  texture {
    DoorHandle
  }
  scale <0.7, 0.7, 2.5>
  rotate 80.0*x
  translate  <-18.8, 62.300001, 1.4>
}


sphere { // DoorKnob2
  <0,0,0>,1
  texture {
    DoorKnob
  }
  scale <0.8, 2.4, 1.0>
  translate  <-15.2, 64.7, 2.5>
}


torus { // DoorHandle1
  1.75, 0.25  rotate -x*90
  texture {
    DoorHandle
  }
  scale <0.7, 0.7, 2.5>
  rotate 80.0*x
  translate  <-15.2, 62.300001, 1.4>
}


sphere { // DoorKnob1
  <0,0,0>,1
  texture {
    DoorKnob
  }
  scale <0.8, 2.4, 1.0>
  translate  <-18.8, 64.700001, 2.5>
}


sphere { // doorsphere2
  <0,0,0>,1
  texture {
    UnderMap
  }
  scale 1.5
  translate  <0.3, 60.9, 3.0>
}


box { // floor
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Stone24
  }
  scale <40.0, 50.0, 0.5>
  translate  <-10.0, 14.0, -6.5>
}


box { // wall1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Stone24
  }
  scale <1.0, 35.0, 8.0>
  translate  7.0*x
}


box { // doorwall1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Stone24
  }
  scale <30.0, 2.5, 1.0>
  translate  <-15.551593, 60.977811, 15.471028>
}


